/**
 * @author Deepak Nigam
 */
Ext.define('Academia.controller.programCourseDashboard.enrollmentSummaryReport.EnrollmentSummaryReportController', {
	//extend : 'Ext.app.Controller',
	extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
	models : [],
	stores : ['program.ProgramCategoryStore','common.AcademyLocationByAcademyId','common.ProgramStore','enquiry.AcademicBatchStore',
	          'course.coursecomponent.CourseComponentCombo',
	          'common.ProgramByCategoryStore',
	          'programCourseDashboard.ESREvaluationGroupStore',
	          'programCourseDashboard.ESRProgramCategoryStore',
	          'programCourseDashboard.ESRProgramByCategoryStore',
	          'programCourseDashboard.EnrollmentSummaryReportStore',
	          'programCourseDashboard.ESRSemesterStore',
	          'programCourseDashboard.ESRCourseComponentStore'],
			  
  views : ['program.reports.enrollmentSummaryReport.EnrollmentSummaryReportStructure',
           'program.reports.enrollmentSummaryReport.EnrollmentSummarySearch',
           'program.reports.enrollmentSummaryReport.EnrollmentSummaryReportGrid'],	           
   config: {
	   ENROLLMENT_SUMMARY_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENROLLMENT_SUMMARY_REPORT_PRIVILEGES'),
   },
   refs : [{
	   ref : 'enrollmentsummaryreportstructure',
	   selector : 'enrollmentsummaryreportstructure'
   },{
	   ref : 'enrollmentsummarysearch',
	   selector : 'enrollmentsummarysearch'
   },{
	   ref : 'enrollmentsummaryreportgrid',
	   selector : 'enrollmentsummaryreportgrid'
   }],
   init : function() {
	   this.control({
		   /*'courseattendancegrid' : {
	       		beforerender:function(){
		 				 this.getStore('programCourseDashboard.CourseAttendanceGridStore').removeAll();
		 		    },
		 		 render:function(grid){
		 			this.doAccessControlValidation(grid, this.getCOURSE_ATTENDANCE_REPORT_PERMISSIONS());
                	this.disableExportBtnActionPivileges(grid, this.getCOURSE_ATTENDANCE_REPORT_PERMISSIONS());
		 		 }   
	       	},*/
		   //*****************Export For Course Summary**********************************************************************
		 /* 'searchresultgrid[itemId=enrollmentSummaryreportId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportSummaryReport(SERVERURL.PDFEXPORT,'pdf',false,'enrollmentSummaryreportId');
	            }
	        },
	        'searchresultgrid[itemId=enrollmentSummaryreportId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportSummaryReport(SERVERURL.PDFEXPORT,'pdf',true,'enrollmentSummaryreportId');
	            }
	        },
	        'searchresultgrid[itemId=enrollmentSummaryreportId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportSummaryReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'enrollmentSummaryreportId');
	            }
	        },
	        'searchresultgrid[itemId=enrollmentSummaryreportId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportSummaryReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'enrollmentSummaryreportId');
	            }
	        },*/
		   	/*'enrollmentsummaryreportstructure':{
			   afterrender : function(structure){
				   var grid = structure.down('searchresultgrid');
				   this.getCBGridHeaderFreeze(grid,structure);
			   }
		   	},

		   'searchresultgrid[itemId=enrollmentSummaryreportId]': {
			   	render: function(grid) {
				   	grid.addButtonToolbar();
				   	//this.genericCBGridAccessControlValidation(grid, this.getENROLLMENT_SUMMARY_REPORT_PERMISSIONS());
			   	}
		   	},*/
		   'enrollmentsummarysearch customcombobox[itemId=evaluationGroupItemId]': {
			    select: function(combo, records) {
			        var this$ = this;
			        var searchForm = this$.getEnrollmentsummarysearch();
			        var programCategoryItemId = searchForm.down('#programCategoryItemId');
			        programCategoryItemId.reset();
			        programCategoryItemId.setDisabled(false);
			        var store = programCategoryItemId.getStore();
			        store.getProxy().extraParams = {
			            evaluationGroupId: combo.getValue()
			        }
			        store.load();

			        var programItemId = searchForm.down('#programItemId');
			        programItemId.reset();
			        programItemId.setDisabled(true);
			    }
			},
			'enrollmentsummarysearch customcombobox[itemId=programCategoryItemId]': {
			    select: function(categoryCombo, records) {
			        var this$ = this;
			        var searchForm = this$.getEnrollmentsummarysearch();
			        var evaluationGroupItemId = searchForm.down('#evaluationGroupItemId');
			        var programItemId = searchForm.down('#programItemId');
			        programItemId.reset();
			        programItemId.setDisabled(false);
			        var store = programItemId.getStore();
			        store.getProxy().extraParams = {
			            evaluationGroupId: evaluationGroupItemId.getValue(),
			            programCategoryId: categoryCombo.getValue()
			        }
			        store.load();
			    }
			},
	        'enrollmentsummarysearch button[itemId=searchBtn]': {
	        	click: function(obj) {
	        		var this$ = this;
	        		var form = this.getEnrollmentsummarysearch();
	        		form.down('#searchBtn').setDisabled(true);
	        		var evaluationGroupId = form.down("#evaluationGroupItemId").getValue();
	        		var programCategoryId = form.down("#programCategoryItemId").getValue();
	        		var programId = form.down("#programItemId").getValue();
	        		var componentName = form.down("#componentNameItemId").getValue();
	        		var periodSequenceDetail = form.down("#periodSequenceDetailItemId").getValue();

	        		var grid = this$.getEnrollmentsummaryreportgrid();
	        		grid.getStore().getProxy().extraParams = {
	        			evaluationGroupId: evaluationGroupId,
	        			programCategoryId: programCategoryId,
	        			programId: programId,
	        			componentType: componentName,
	        			semesterCode: periodSequenceDetail
	        		};
	        		grid.getStore().load({
    					callback: function(records, operation, success) {
    						form.down('#searchBtn').setDisabled(false);
    					}
     	    		   });
	        		grid.config.searchFilterForm = form;
	        	}
	        },
	        'enrollmentsummarysearch button[itemId=resetBtn]': {
	        	click: function(obj) {
	        		var quickSearchForm = this.getEnrollmentsummarysearch();
	        		var programCategoryItemId = quickSearchForm.down('#programCategoryItemId');
	        		programCategoryItemId.setDisabled(true);
	        		var programItemId = quickSearchForm.down('#programItemId');
	        		programItemId.setDisabled(true);
	        		quickSearchForm.getForm().reset();

	        		/*var grid = this.getEnrollmentsummaryreportgrid(); 
	                grid.getStore().removeAll();
	                grid.getStore().loadData([]);*/
	        	}
	        },
	        'enrollmentsummaryreportgrid button[itemId=exportReportsId]': {
	        	click: function() {
	        		var $this = this;
	        		var form = this.getEnrollmentsummarysearch();
	        		var evaluationGroupId = form.down("#evaluationGroupItemId").getValue();
	        		if (!isNullOrEmpty(evaluationGroupId)) {
	        			var reportParams = new Object();
	        			var code = 'STUDENT_ENROLLMENT_SUMMARY_REPORT';
	        			var reportTitle = 'Student Enrollment Summary Report';

	        			var programCategoryId = form.down("#programCategoryItemId").getValue();
	        			var programId = form.down("#programItemId").getValue();
	        			var componentName = form.down("#componentNameItemId").getValue();
	        			var periodSequenceDetail = form.down("#periodSequenceDetailItemId").getValue();

	        			reportParams.code = code;
	        			reportParams.reportTitle = code;
	        			reportParams.evaluationGroupId = evaluationGroupId;
	        			reportParams.programCategoryId = programCategoryId;
	        			reportParams.programId = programId;
	        			reportParams.componentType = componentName;
	        			reportParams.semester = periodSequenceDetail;
	        			reportParams.courseNameLabel = getCommonTranslation('COURSE_NAME');
	        			reportParams.courseCodeLabel = getCommonTranslation('COURSE_CODE');
	        			//reportParams.headerName = reportType.getRawValue();//"Course Wise Marksheet Report";
	        			$this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.ESR_EXPORT_ENROLLMENT_SUMMARY_REPORT);
	        		} else {
	        			showWarningMessage(getCommonTranslation("ALERT"), getProgramandcourseTranslation('ESR_SELECT_EVALUATION_GROUP'));
	        		}
	        	}
	        },
	        'enrollmentsummaryreportgrid': {
	        	beforerender: function() {
	        		this.getStore('programCourseDashboard.EnrollmentSummaryReportStore').removeAll();
	        	},
	        	render: function(grid) {
	        		this.doAccessControlValidation(grid, this.getENROLLMENT_SUMMARY_REPORT_PERMISSIONS());
	        		this.disableExportBtnActionPivileges(grid, this.getENROLLMENT_SUMMARY_REPORT_PERMISSIONS());
	        		var exportPDFAll = grid.down('#exportPDFAll');
	        		exportPDFAll.setDisabled(true);
	        		var exportExcelAll = grid.down('#exportExcelAll');
	        		exportExcelAll.setDisabled(true);
	        	}
	        },
	        'enrollmentsummaryreportstructure': {
	        	afterrender: function(structure) {
	        		var newStructure=structure.down('panel');
	        		var grid = structure.down("enrollmentsummaryreportgrid");
	        		this.getGridHeaderFreezeNoPage(grid, newStructure, true);
	        	}
	        },
	   });
   },
   /*exportSummaryReport : function(exportUrl,filetype,whetherAll) {
	   
	   var quickSearchForm=this.getEnrollmentsummarysearch();	
	   var searchResultGrid = this.getSearchresultgrid();
	   var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
	   
	   var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	   var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	   
	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
	   var reportTitle=getCommonTranslation("ENROLLMENT_SUMMARY_REPORT");
	   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
		   jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	   searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
   },
   
   getJsonObject: function(key, value, additionalValue) {
    	 if (value != '' && value != null && additionalValue == undefined) {
    		 return {
    			 "paramCode": key,
    			 "paramValues": [value]
    		 };
    	 } else if (value != '' && additionalValue != undefined) {
    		 return {
    			 "paramCode": key,
    			 "paramValues": [value, additionalValue]
    		 };
    	 }
     },
     pushJsonObjectInArray: function(object, array) {
    	 if (object) {
    		 array.push(object);
    	 }
     },
     
     createJsonFormat : function(searchForm) {

    	 var this$ = this;
    	 var searchcriteria = new Array();
         var values = new Object();
         
         formValues = searchForm.getValues();
         
 		 var programObj = this$.getJsonObject('PROGRAM_CATEGORY_ID' , formValues.programCategory);
         this$.pushJsonObjectInArray(programObj,searchcriteria);
         
         var programCategoryObj = this$.getJsonObject('COURSE_TYPE_ID' , formValues.componentName);
         this$.pushJsonObjectInArray(programCategoryObj,searchcriteria);
         
         var periodSequenceObj = this$.getJsonObject('PROGRAM_PERIOD_SEQ_ID' , formValues.periodSequenceDetail);
         this$.pushJsonObjectInArray(periodSequenceObj,searchcriteria);

         var programObj = this$.getJsonObject('PROGRAM_ID' , formValues.programId);
         this$.pushJsonObjectInArray(programObj,searchcriteria);
         
         var programObj = this$.getJsonObject('WHETHERCOMPLETED' , true);
         this$.pushJsonObjectInArray(programObj,searchcriteria);
         
         var programObj = this$.getJsonObject('WHETHERCOMPLETED_NULL' , true);
         this$.pushJsonObjectInArray(programObj,searchcriteria);
         
         var programObj = this$.getJsonObject('EXITDATE_NULL' , true);
         this$.pushJsonObjectInArray(programObj,searchcriteria);

         values.configCode = CONSTANTS.CB.ENROLLMENT_SUMMARY_REPORT_CONFIG_CODE;
         values.searchCriterias = searchcriteria;
 		 
 		 return values;
     },
     
     createSearchCriteriaString: function(searchForm) {
     	var me=this;
         var formValues = new Array();
         formValues = searchForm.getValues();        
         var searchCriteriaString="";
         for (var key in formValues) {
         	var value = formValues[key];            
             if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                 var keyValueJsonObject = me.getJsonObject( key , value);
     	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
             }
         }
         searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
         return searchCriteriaString;
     },
     */
   //******************Disable Export Reports button**********************************
   disableExportBtnActionPivileges: function(gridReference, permissionsMap) {
	   var associatedAcadLocationIds = new Array();
	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	   var exportReportButton = gridReference.down('#exportReportsId');
	   exportReportButton.setVisible(false);
	   Ext.each(permissionList, function(privilege) {
		   if (privilege === 'EXPORT_REPORTS') {
			   if (!isNullOrEmpty(exportReportButton)) {
				   exportReportButton.setVisible(true);
			   }
		   }
	   });
   }
});