/**
 * This controller is used for complaints dashboard controller
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.reports.complaints.ComplaintsDashboardReportController', {
    extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',

    stores: ['reports.complaints.ComplaintsReportTreeStore', 'reports.complaints.UnassignedComplaintReportStore',
             'servicerequest.complaintrequest.ComplaintTypes', 'servicerequest.complaintrequest.ComplaintAgainsts', 
             'servicerequest.complaintrequest.ComplaintBy', 'facilitiesresources.resourcebooking.ResourceGroupStore',
             'facilitiesresources.resourcebooking.ResourceTypeStore', 'servicerequest.complaintrequest.InternalResourceStore',
             'reports.complaints.FollowUpScheduledComplaintsStore', 'reports.servicerequest.ServiceLevelGraphStore'],

    views: ['reports.common.DashboardReportTabStructure',
            'reports.complaints.ComplaintDashboardView', 'reports.complaints.ComplaintReportView', 
            'reports.complaints.UnassignedComplaintReportView', 'reports.complaints.UnassignedComplaintGrid',
            'reports.complaints.FollowUpScheduledComplaintsView', 'reports.complaints.FollowUpScheduleComplaintReportGrid', 
            'reports.complaints.FollowUpScheduledComplaintSearchForm',
            'reports.complaints.ComplaintServiceLevelGraphView', 'reports.complaints.ComplaintServiceLevelGraphSearch',
            'reports.complaints.ComplaintsHistoryGraphView', 'reports.complaints.ComplaintsHistorySearchForm',
            'reports.complaints.PendingComplaintsHistoryView', 'reports.complaints.PendingComplaintsHistorySearch',
            'reports.complaints.ComplaintsClosureRateView', 'reports.complaints.ComplaintsClosureRateSearch',
            'reports.complaints.ComplaintsClosureReasonView', 'reports.complaints.ComplaintsClosureReasonSearch'],
      config : {
    	  COMPLAINTDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLAINTDASHBOARD_PRIVILEGES'),

      }   ,   

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
        ref: 'organizationunit',
        selector: 'organizationunit'
    }, {
    	ref: 'complaintDashboardOrganizationUnit',
    	selector: 'organizationunit[itemId=complaintDashboardOrganizationUnit]'
    }, {
    	ref : 'complaintReportView',
		selector: 'complaintreportview[itemId=complaintReportView]'
	}, {
        ref: 'complaintsDashboardReportTabStructure',
        selector: 'dashboardreporttabstructure[itemId=complaintsDashboardReportTabStructure]'
    }, {
    	ref: 'complaintsReportTreePanelItemId',
    	selector:'treepanel[itemId=complaintsReportTreePanelItemId]'
    }, {
    	ref: 'unassignedComplaintSearchForm',
    	selector:'unassignedcomplaintreportview form[itemId=unassignedComplaintSearchForm]'
    }, {
    	ref: 'unassignedComplaintReportGrid',
    	selector: 'unassignedcomplaintreportview unassignedcomplaintgrid[itemId=unassignedComplaintReportGrid]'
    }, {
    	ref: 'followUpScheduledComplaintSearchForm',
    	selector: 'followupscheduledcomplaintsearchform[itemId=followUpScheduledComplaintSearchForm]'
    }, {
    	ref: 'followUpScheduleComplaintReportGrid',
    	selector: 'followupschedulecomplaintreportgrid[itemId=followUpScheduleComplaintReportGrid]'
    }, {
    	ref: 'complaintServiceLevelGraphSearch',
    	selector: 'complaintservicelevelgraphsearch[itemId=complaintServiceLevelGraphSearch]'
    }, {
    	ref: 'complaintServiceLevelChart',
    	selector: 'complaintservicelevelgraphview groupedbarchart[itemId=complaintServiceLevelChart]'
    }, {
    	ref: 'complaintsHistorySearchForm',
    	selector: 'complaintshistorysearchform[itemId=complaintsHistorySearchForm]'
    }, {
    	ref: 'complaintHistoryChart',
    	selector: 'columnchartreport[itemId=complaintHistoryChart]'
    }, {
    	ref: 'pendingComplaintsHistorySearch',
    	selector: 'pendingcomplaintshistorysearch[itemId=pendingComplaintsHistorySearch]'
    }, {
    	ref: 'pendingComplaintHistoryChart',
    	selector: 'columnchartreport[itemId=pendingComplaintHistoryChart]'
    }, {
    	ref: 'complaintsClosureRateSearch',
    	selector: 'complaintsclosureratesearch[itemId=complaintsClosureRateSearch]'
    }, {
    	ref: 'complaintsClosureRateChart',
    	selector: 'columnchartreport[itemId=complaintsClosureRateChart]'
    }, {
    	ref: 'complaintsClosureReasonSearch',
    	selector: 'complaintsclosurereasonsearch[itemId=complaintsClosureReasonSearch]'
    }, {
    	ref: 'complaintsClosureReasonChart',
    	selector: 'barchartreport[itemId=complaintsClosureReasonChart]'
    }, {
    	ref: 'requestAssignedWindow',
    	selector: 'requestassignedwindow'
    }, {
    	ref: 'assignRequestForm',
    	selector: 'requestassignedwindow form[itemId=assignRequestForm]'
    }],
    init: function(application) {
        this.control({
        	'organizationunit[itemId=complaintDashboardOrganizationUnit] radiogroup[itemId=organizationRadioUnitId]': {
    			change:function(obj,record){
    				this.organizationUnitChange(obj,record);
    			},
    			render:function(obj){
    				var permission = this.getCOMPLAINTDASHBOARD_PERMISSIONS();
  		  			this.organizationUnitChange(obj,null,permission);
    			}
    		},
    		'organizationunit[itemId=complaintDashboardOrganizationUnit] button[itemId=resetBtn]': {
    			click:function(obj,record){ 
    				this.resetOrganizationunit(obj);
    			}
    		},
        	'complaintreportview[itemId=complaintReportView] treepanel[itemId=complaintsReportTreePanelItemId]': {
        		itemclick : function( treePanel, record, item, index, e, eOpts ) {
					var $this = this;
					var complaintReportView = $this.getComplaintReportView();
					var treeTab = complaintReportView.down('#complaintsReportTreePanelItemId');
					var tabDetail = record.data;
					if(!isNullOrEmpty(tabDetail.text) && !isNullOrEmpty(tabDetail.reportXtype) && !isNullOrEmpty(tabDetail.reportXtypeItemId)){
						treeTab.toggleCollapse();
						var complaintsDashboardReportTabStructure = $this.getComplaintsDashboardReportTabStructure();
						complaintsDashboardReportTabStructure.removeAll();
						
						if (complaintsDashboardReportTabStructure) {
							complaintsDashboardReportTabStructure.add({
										xtype : tabDetail.reportXtype,
										itemId: tabDetail.reportXtypeItemId,
										title: tabDetail.text,
										frame: true
							});
							complaintsDashboardReportTabStructure.show();
						} 
						treePanel.getSelectionModel().deselectAll();
					}
					
				}
       	     },
       	     'dashboardreporttabstructure[itemId=complaintsDashboardReportTabStructure] form combo[itemId=faciltyTypeField]':{
       	    	afterrender: function(combo){
     	    		combo.store.clearFilter(true);
     	    		combo.store.filter({
     	    			filterFn: function(record) {
     	    				var flag = true;
     	    				if (record.get('name') == '') {
     	    					flag = false;
     	    				} else {
     	    					flag = true;
     	    				}
     	    				return flag;
     	    			}
     	    		}, this);
     	    		
     	    	},
     	    	select: function(combo, records, eOpts){
       	    		var form = combo.up('form');
       	    		form.down('#physicalTypeField').clearValue();
       	    		form.down('#facilityCodeField').clearValue();
       	    		form.down('#facilityCodeField').getStore().removeAll();
     	    		var store = form.down('#physicalTypeField').getStore();
     	    		store.getProxy().extraParams = {
     	    			resourceGroup : combo.getValue()
     	    		};
     	    		store.load();
     	    		
     	    	} 
     	     },
     	    'dashboardreporttabstructure[itemId=complaintsDashboardReportTabStructure] form combo[itemId=physicalTypeField]':{
     	    	select: function(combo, records, eOpts){
       	    		var form = combo.up('form');
       	    		form.down('#facilityCodeField').clearValue();
       	    		form.down('#facilityCodeField').getStore().removeAll();
     	    		var store = form.down('#facilityCodeField').getStore();
     	    		store.getProxy().extraParams = {
     	    			resourceTypeId: combo.getValue()
     	    		};
     	    		store.load();
     	    		
     	    	} 
     	     },
       	     'unassignedcomplaintreportview form[itemId=unassignedComplaintSearchForm] button[itemId=searchButtonId]': {
       	    	 click: function(){
       	    		 this.loadUnassignedComplaintReport();
       	    	 }
       	     },
       	     'unassignedcomplaintreportview unassignedcomplaintgrid[itemId=unassignedComplaintReportGrid]': {
       	    	 cellclick: function(grid, td, cellIndex, record){
       	    		 var searchResultGrid = this.getUnassignedComplaintReportGrid();
       	    		 this.cellclickComplaintReprotRequestGrid(searchResultGrid,cellIndex,record);            		
       	    	 }
       	     },
       	     'unassignedcomplaintreportview form[itemId=unassignedComplaintSearchForm] button[itemId=resetButtonId]': {
    	    	 click: function(){
    	    		 var form = this.getUnassignedComplaintSearchForm();
    	    		 form.getForm().reset();
    	    	 }
    	     },
       	     'followupscheduledcomplaintsview form[itemId=followUpScheduledComplaintSearchForm] button[itemId=searchButtonId]': {
    	    	 click: function(){
    	    		 this.loadFollowUpScheduledComplaintReport();
    	    	 }
    	     },
    	     'followupschedulecomplaintreportgrid[itemId=followUpScheduleComplaintReportGrid]': {
       	    	 cellclick: function(grid, td, cellIndex, record){
       	    		 var searchResultGrid = this.getFollowUpScheduleComplaintReportGrid();
       	    		 this.cellclickComplaintReprotRequestGrid(searchResultGrid,cellIndex,record);            		
       	    	 }
       	     },
    	     'followupscheduledcomplaintsview form[itemId=followUpScheduledComplaintSearchForm] button[itemId=resetButtonId]': {
    	    	 click: function(){
    	    		 var form = this.getFollowUpScheduledComplaintSearchForm();
    	    		 form.getForm().reset();
    	    	 }
    	     },
    	     'complaintservicelevelgraphview form[itemId=complaintServiceLevelGraphSearch] button[itemId=searchButtonId]': {
    	    	 click: function(){
    	    		 this.loadServiceLevelChart();
    	    	 }
    	     },
    	     'complaintservicelevelgraphview form[itemId=complaintServiceLevelGraphSearch] button[itemId=resetButtonId]': {
    	    	 click: function(){
    	    		 var form = this.getComplaintServiceLevelGraphSearch();
    	    		 form.getForm().reset();
    	    	 }
    	     },
    	     'complaintshistorygraphview form[itemId=complaintsHistorySearchForm] button[itemId=searchButtonId]': {
    	    	 click: function(){
    	    		 this.loadComplaintHistoryChart();
    	    	 }
    	     },
    	     'complaintshistorygraphview form[itemId=complaintsHistorySearchForm] button[itemId=resetButtonId]': {
    	    	 click: function(){
    	    		 var form = this.getComplaintsHistorySearchForm();
    	    		 form.getForm().reset();
    	    	 }
    	     },
    	     'pendingcomplaintshistoryview form[itemId=pendingComplaintsHistorySearch] button[itemId=searchButtonId]': {
    	    	 click: function(){
    	    		 this.loadPendingComplaintsHistoryChart();
    	    	 }
    	     },
    	     'pendingcomplaintshistoryview form[itemId=pendingComplaintsHistorySearch] button[itemId=resetButtonId]': {
    	    	 click: function(){
    	    		 var form = this.getPendingComplaintsHistorySearch();
    	    		 form.getForm().reset();
    	    	 }
    	     },
    	     'complaintsclosurerateview form[itemId=complaintsClosureRateSearch] button[itemId=searchButtonId]': {
    	    	 click: function(){
    	    		 this.loadComplaintsClosureRateChart();
    	    	 }
    	     },
    	     'complaintsclosurerateview form[itemId=complaintsClosureRateSearch] button[itemId=resetButtonId]': {
    	    	 click: function(){
    	    		 var form = this.getComplaintsClosureRateSearch();
    	    		 form.getForm().reset();
    	    	 }
    	     },
    	     'complaintsclosurereasonview form[itemId=complaintsClosureReasonSearch] button[itemId=searchButtonId]': {
    	    	 click: function(){
    	    		 this.loadComplaintClosureReasonChart();
    	    	 }
    	     },
    	     'complaintsclosurereasonview form[itemId=complaintsClosureReasonSearch] button[itemId=resetButtonId]': {
    	    	 click: function(){
    	    		 var form = this.getComplaintsClosureReasonSearch();
    	    		 form.getForm().reset();
    	    	 }
    	     },
    	     'requestassignedwindow[itemId=complaintAssignToWindow] form[itemId=assignRequestForm] button[itemId=cancelButtonId]': {
             	click: function(){
             		this.getRequestAssignedWindow().close();
             	}
             },
             'requestassignedwindow[itemId=complaintAssignToWindow] form[itemId=assignRequestForm] button[itemId=submitButtonId]': {
             	click: function(){
             		this.submitAssignRequest();
             	}
             },
             'requestassignedwindow[itemId=complaintAssignToWindow] form[itemId=assignRequestForm] combo[itemId=requestAssigneeCombo]': {
            	 afterrender: function(combo){
             		this.loadAssigneeCombo(combo);
             	}
             }
             
        });

    },
    /**
     *  load unassigned complaint report view
     */
    loadUnassignedComplaintReport: function(){
    	var this$ = this;
    	var unassignedComplaintSearchForm = this$.getUnassignedComplaintSearchForm();
    	var resultGrid = this$.getUnassignedComplaintReportGrid();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(unassignedComplaintSearchForm);
    	
    	var store = resultGrid.getStore();
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	store.getProxy().extraParams = formValues;
    	//resultGrid.down('custompagingtoolbar').moveFirst();
    	store.load();
    	var taskDelay = new Ext.util.DelayedTask(function(){
    		Ext.getBody().unmask();
    	  });
    	taskDelay.delay(1000);
    },
    
    /**
     *  load follow-up scheduled complaint report view
     */
    loadFollowUpScheduledComplaintReport: function(){
    	var this$ = this;
    	var followUpScheduledComplaintSearchForm = this$.getFollowUpScheduledComplaintSearchForm();
    	var resultGrid = this$.getFollowUpScheduleComplaintReportGrid();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(followUpScheduledComplaintSearchForm);
    	// Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var store = resultGrid.getStore();
    	store.getProxy().extraParams = formValues;
    	//resultGrid.down('custompagingtoolbar').moveFirst();
    	store.load();
     	var taskDelay = new Ext.util.DelayedTask(function(){
    		Ext.getBody().unmask();
    	  });
    	taskDelay.delay(1000);
    },
    
    /**
     * load service level Chart store
     */
    loadServiceLevelChart : function(){
    	var this$= this;
    	var complaintServiceLevelGraphSearch = this$.getComplaintServiceLevelGraphSearch();
    	var complaintServiceLevelChart = this$.getComplaintServiceLevelChart();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(complaintServiceLevelGraphSearch);
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.COMPLAINT_SERVICE_LEVEL_REPORT,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData:formValues,
            success: function(response) {
            	Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
            	var month = {JANUARY:1,FEBRUARY:2,MARCH:3,APRIL:4,MAY:5,JUNE:6,JULY:7,AUGUST:8,SEPTEMBER:9,OCTOBER:10,NOVEMBER:11,DECEMBER:12};
            	var newData = [];
            	Ext.each(data, function(currentRecord){
            		currentRecord.sequence = month[currentRecord.MONTH.toUpperCase()];
            		newData.push(currentRecord);
            	});
            	
            	if(newData.length){
                	newData.sort(function compare(a,b) {
                		if (a.sequence < b.sequence)
                			return -1;
                		if (a.sequence > b.sequence)
                			return 1;
                		return 0;
                	});
            	}
            	complaintServiceLevelChart.getStore().loadData(newData);
            }
        });
    },
    
    /**
     * load complaints history graph store
     */
    loadComplaintHistoryChart : function(){
    	var this$= this;
    	var complaintsHistorySearchForm = this$.getComplaintsHistorySearchForm();
    	var complaintHistoryChart = this$.getComplaintHistoryChart();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(complaintsHistorySearchForm);
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.COMPLAINT_SERVICE_REQUEST_COUNT_REPORT,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: formValues,
            success: function(response) {
            	data = Ext.decode(response.responseText);
            	complaintHistoryChart.getStore().loadData(data);
            }
        });
    },
    /**
     * load pending complaints history graph store
     */
    loadPendingComplaintsHistoryChart : function(){
    	var this$= this;
    	var pendingComplaintsHistorySearch = this$.getPendingComplaintsHistorySearch();
    	var pendingComplaintHistoryChart = this$.getPendingComplaintHistoryChart();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(pendingComplaintsHistorySearch);
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.COMPLAINT_SERVICE_REQUEST_COUNT_REPORT,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: formValues,
            success: function(response) {
           	 Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
            	pendingComplaintHistoryChart.getStore().loadData(data);
            }
        });
    },
    /**
     * load complaints closure rate store
     */
    loadComplaintsClosureRateChart : function(){
    	var this$= this;
    	var complaintsClosureRateSearch = this$.getComplaintsClosureRateSearch();
    	var complaintsClosureRateChart = this$.getComplaintsClosureRateChart();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(complaintsClosureRateSearch);
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.COMPLAINT_SERVICE_REQUEST_CLOSURE_RATE_REPORT,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: formValues,
            success: function(response) {
            	Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
            	complaintsClosureRateChart.getStore().loadData(data);
            }
        });
    },
    /**
     * load student closure reason graph store
     */
    loadComplaintClosureReasonChart : function(){
    	var this$= this;
    	var complaintsClosureReasonSearch = this$.getComplaintsClosureReasonSearch();
    	var complaintsClosureReasonChart = this$.getComplaintsClosureReasonChart();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(complaintsClosureReasonSearch);
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.COMPLAINT_SERVICE_CLOSURE_REASON_COUNT_REPORT,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: formValues,
            success: function(response) {
            	Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
            	complaintsClosureReasonChart.getStore().loadData(data);
            }
        });
    },
    /**
     * Create dashboard search criteria json
     * @params searchCriteriaForm
     */
    createSeachCriteriaDashboardJsonFormat: function(searchCriteriaForm){
    	var formValues = null;
    	if(searchCriteriaForm){
    		formValues = searchCriteriaForm.getValues();
        	for (var key in formValues) {
            	var value = formValues[key];            
                if(isNullOrEmpty(value) || value =='All' || key == 'selectedNameField'){
                	delete formValues[key];
                }
            }
        	var academyLocationIds = this.getAcademyLocationIds();
        	if(!isNullOrEmpty(academyLocationIds)){
        		academyLocationIds = academyLocationIds.toString();
        		var commaIndex = academyLocationIds.indexOf(",");
        		if(commaIndex != -1){
        			var academyLocationArray = academyLocationIds.split(",");
                	formValues.academyLocationIds = academyLocationArray;
        		}else{
        			formValues.academyLocationIds = [academyLocationIds];
        		}
            	
        	}
        	if(!isEmpty(formValues.assignTo)){
        		formValues.assignTo = formValues.assignTo.id;
        	}
        	
    	}
    	return formValues;
    },
    /**
     * Get Service Request controller
     */
    getServiceRequestController : function(){
    	var this$ = this;
    	return this$.getController('Academia.controller.servicerequest.ServiceRequestController');
    },
    /**
	  * This method is used to open tab after click of RequestId Cell of student track request grid
	  * Required :
	  * @param grid
	  * @param cellIndex
	  * @param record
	  */
    cellclickComplaintReprotRequestGrid: function(grid, cellIndex, record) {
	   var this$ = this;
	   var cellDataIndex = grid.columnManager.columns[cellIndex].dataIndex;
	   if (cellDataIndex == "requestId") {
		   
		   var complaintId = record.get('serviceRequestId');
		   var complaintType = record.get('serviceRequestType');
		   record.data.ID  = complaintId;
		   record.data.COMPLAINT_ID  = record.get('requestId');
		   record.data.COMPLAINT_DATE  = record.get('requestDate');
		   record.data.COMPLAINT_STATUS  = record.get('serviceRequestStatus');
		   record.data.LAST_NAME  = record.get('serviceRequestType');
		   record.data.REQUEST_STATUS_ID  = record.get('requestStatusId');
		   record.data.REQUEST_TYPE  = record.get('requestType');
		   record.data.SERVICE_REQUEST_STAGE  =record.get('serviceRequestStage');
		   record.data.SLA_DAYS  = null;
		   
		   this$.getServiceRequestController().setComplaintRequestData(complaintId,record,complaintType);  
	   }else if(cellDataIndex == "assignRequest"){
		   
		   if (grid.getSelectionModel().getCount() > 0) {
			   var formWindow = this$.getRequestAssignedWindow();
			   if(!formWindow){
				   formWindow = Ext.widget('requestassignedwindow',{
					   itemId:'complaintAssignToWindow'
				   });  
			   }
			   formWindow.show();
		   }else{
			   showWarningMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		   }
		   
		   
	   }
	     
	 },
	 loadAssigneeCombo: function(combo){
		  var this$ = this;
		  var contentPanel = this$.getContentPanel();
		  var dashboardReportTab = contentPanel.down('#complaintsDashboardReportTabStructure');
		  var grid = dashboardReportTab.down('grid');
		  if (grid.getSelectionModel().getCount() > 0) {
			  var records = grid.getSelectionModel().getSelection()[0];
			  var academyLocationId =records.get('academyLocationId');
			  combo.getStore().getProxy().extraParams = {
		    		academyLocationId:academyLocationId
		      };    
		  }
	  },
	 /**
	   * assign request to users
	   */
	  submitAssignRequest: function(){
		  var this$ = this;
		  var contentPanel = this$.getContentPanel();
		  var dashboardReportTab = contentPanel.down('#complaintsDashboardReportTabStructure');
		  var grid = dashboardReportTab.down('grid');
		  var assignRequestForm = this.getAssignRequestForm();
		  var formvalues = assignRequestForm.getValues();
		  var assigneeId = formvalues.assigneeId;
		  if (grid.getSelectionModel().getCount() > 0) {
			  if(!isNullOrEmpty(assigneeId)){
				  var records = grid.getSelectionModel().getSelection()[0];
				  var serviceRequestId =records.get('serviceRequestId');
				  formvalues.id = serviceRequestId;
		        	  
				  var jsonFormFieldData = Ext.encode(formvalues);
				  Ext.Ajax.request({
	                  type: 'rest',
	                  url: SERVERURL.COMPLAINT_ASSIGN_SERVICE_REQUEST,
	                  method: 'POST',
	                  jsonData: jsonFormFieldData,
	                  headers: {
	                      'Content-Type': 'application/json'
	                  },
	                  success: function(form, action) {
	                	  this$.getRequestAssignedWindow().close();
	                      grid.getStore().reload();
	                      showSuccessMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getServiceRequestTranslation('REQUEST_ASSIGN_SUCCESS'));
	                  }
	              });
			  }else{
				   showWarningMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getServiceRequestTranslation('PLEASE_SELECT_ASSIGNEE'));
			   }
			  
		   }else{
			   showWarningMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		   }
		  
	  }
});
