/**
 * @author Dharmendra.p
 *  
 */
Ext.define('Academia.controller.reports.programcourse.coursegroupcompletion.CourseGroupCompletionController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['reports.programcourse.coursegroupcompletion.CourseGroupCompletionStructure',
            'reports.programcourse.coursegroupcompletion.CourseGroupCompletionSearch'],

    stores: ['course.coursegroup.CourseGroup'],

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
        ref: 'coursegroupcompletionsearch',
        selector: 'coursegroupcompletionsearch'
    },{
        ref: 'coursegroupcompletionstructure',
        selector: 'coursegroupcompletionstructure'
    },{
	   	 ref: 'searchresultgrid',
		 selector: 'searchresultgrid[itemId=coursegroupcompletionreportId]'
    }],
    config: {
        PANDCDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PANDCDASHBOARD_PRIVILEGES')  		  
     },   
    init: function(application) {
        this.control({
        	 'searchresultgrid[itemId=coursegroupcompletionreportId]':{
  			   render : function(grid){
  				   this.gridRenderFunction(grid);
     				 this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
  			   }
  		   },	
  		 //***1**************Export For Report**********************************************************************
			  'searchresultgrid[itemId=coursegroupcompletionreportId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getSearchresultgrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid);
		            }
		        },
		        'searchresultgrid[itemId=coursegroupcompletionreportId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getSearchresultgrid();
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid);
		            }
		        },
		        'searchresultgrid[itemId=coursegroupcompletionreportId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		            	var grid = this.getSearchresultgrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid);
		            }
		        },
		        'searchresultgrid[itemId=coursegroupcompletionreportId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		            	var grid = this.getSearchresultgrid();
		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid);
		            }
		        },
		    //***************************************************************************************************************88    
        	'coursegroupcompletionsearch customcombobox#programId': {
   			 select: function(obj, record) {
   				 var programId = record[0].get("id");
   				 if(programId > 0){
   					var form = obj.up('form');
   					form.down('#batchId').setDisabled(false);
   					var store =form.down('#batchId').getStore();
   					store.getProxy().extraParams = {
   						 id: programId
   					 };
   					 store.load();
   					var $this = this;
					var searchForm = $this.getCoursegroupcompletionsearch();
					searchForm.isValid();
   				 }
   			 }
   		 },
   		'coursegroupcompletionsearch customcombobox#batchId': {
  			 select: function(obj, record) {
  				 var batchId = record[0].get("id");
  				 if(batchId > 0){
  					var form = obj.up('form');
  					form.down('#courseGroupId').setDisabled(false);
  					var store =form.down('#courseGroupId').getStore();
  					store.getProxy().extraParams = {
  						id: batchId
  					 };
  					 store.load();
  					var $this = this;
					var searchForm = $this.getCoursegroupcompletionsearch();
					searchForm.isValid();
  				 }
  			 }
  		 },
  		 'coursegroupcompletionsearch customcombobox#courseGroupId': {
  			 select: function(obj, record) {
  				 var groupId = record[0].get("groupId");
  				 var form = obj.up('form').getForm();
  				 form.findField('groupId').setValue(groupId);
  				var $this = this;
				var searchForm = $this.getCoursegroupcompletionsearch();
				searchForm.isValid();
  			 }
  		 },
 		 
   		'coursegroupcompletionsearch button#searchBtn': {
  			 click: this.specializationReportload
  		 },
  		'coursegroupcompletionsearch button#resetBtn': {
 			 click: function(obj, record) {
 				obj.up('form').getForm().reset();
 				obj.up('form').down('#batchId').setDisabled(true);
 				obj.up('form').down('#courseGroupId').setDisabled(true);
 			 }
 		 },   		
        	
        });
    },
    specializationReportload : function(model, records) {
    	var quickSearchForm = this.getCoursegroupcompletionsearch();
		var jsonFormatFormData = this.createJsonFormat(quickSearchForm,records);
		var searchResultGrid = this.getSearchresultgrid();
		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.COURSE_GROUP_COMPLETION_LIST_VIEWCODE);
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    	 Ext.getBody().unmask();
	},
	createJsonFormat:function(quickSearchForm, record){
		var formValues = quickSearchForm.getForm().getValues();
		
		var values = new Object();
		values.configCode = CONSTANTS.CB.COURSE_GROUP_COMPLETION_LIST_CONFIGCODE;
		var searchcriteria = new Array();
		
		var form = quickSearchForm.getForm();
		var groupId = form.findField('groupId').getValue();
		if(formValues.studentId != ""){
			searchcriteria.push({
				paramCode:"ADMISSION_CODE", 
				paramValues:[formValues.studentId]
			});
		}
		/*if(formValues.studentName != ""){
			searchcriteria.push({
				paramCode:"STUDENT_NAME", 
				paramValues:[formValues.studentName]
			});
		}*/
		
		if(formValues.program != ""){
			searchcriteria.push({
				paramCode:"PROGRAM_ID", 
				paramValues:[formValues.program]
			});
		}
		if(formValues.batchId != ""){
			searchcriteria.push({
				paramCode:"BATCH_ID", 
				paramValues:[formValues.batchId]
			});
		}
		if(formValues.courseGroup != ""){
			searchcriteria.push({
				paramCode:"COURSE_GROUP_ID", 
				paramValues:[groupId]
			});
		}
		
		values.searchCriterias=searchcriteria;
		return values;
	},
	gridRenderFunction:function(grid){
    	 grid.addButtonToolbar();
     },
     //**********************************Export Functionality********************************************************
     exportUserList : function(exportUrl,filetype,whetherAll,grid) {
  	   var quickSearchForm = null;
  	   var searchResultGrid = null;
  	   var pagingtoolbaroptions = null; 
  	   var searchCriteriaString = null;
  	   var jsonFormatFormData = null;
    
  	     quickSearchForm=this.getCoursegroupcompletionstructure(); 
  	     searchResultGrid = grid;
  	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
  	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
  	     jsonFormatFormData=this.createJsonFormat(quickSearchForm,null);
  	  
  	   
  	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
     	var reportTitle=getCommonTranslation('COURSE_GROUP_COMPLETION_REPORT_LIST');
  	   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
  		   jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
  	   }
  	   searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
  	   console.log("exportSuccess");
     }, 
   //**************************************End*********************************************************************  
  	   createSearchCriteriaString: function(searchForm) {
  		   var me=this;
  		   var formValues = new Array();
  		   formValues = searchForm.getValues();        
  		   var searchCriteriaString="";
  		   for (var key in formValues) {
  			   var value = formValues[key];            
  			   if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
  				   //  var keyValueJsonObject = me.getJsonObject( key , value);
  				   //searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
  			   }
  		   }
  		   searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
  		   return searchCriteriaString;
  	   }            
});