/**
 * @author Dharmendra.p
 *  
 */
Ext.define('Academia.controller.reports.programcourse.specialization.SpecializationReportController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['reports.programcourse.specialization.SpecializationReportStructure',
            'reports.programcourse.specialization.SpecializationReportSearch'],

    stores: ['program.programDetails.programBatches.courseSpecialization.ProgramCourseSpecializationStoreGrid',
             'common.ProgramStore','enquiry.AcademicBatchStore','attendance.StudentSearch',
             'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch'],

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
        ref: 'specializationreportsearch',
        selector: 'specializationreportsearch'
    },{
	   	 ref: 'searchresultgrid',
		 selector: 'searchresultgrid[itemId=specializationreportgridId]'
    },{
	   	 ref: 'specializationreportstructure',
		 selector: 'specializationreportstructure'
    }],
    config: {
        PANDCDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PANDCDASHBOARD_PRIVILEGES')  		  
     },  
    init: function(application) {
        this.control({
        	   'searchresultgrid[itemId=specializationreportgridId]':{
    			   render : function(grid){
    				   this.gridRenderFunction(grid);
       				 this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
    			   }
    		   },
    			 //***1**************Export For Report**********************************************************************
  			  'searchresultgrid[itemId=specializationreportgridId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
  		            click: function() {
  		            	var grid = this.getSearchresultgrid();
  		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,CONSTANTS.CB.SPECIALIZATION_STUDENT_RECORD_LIST_CONFIGCODE);
  		            }
  		        },
  		        'searchresultgrid[itemId=specializationreportgridId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
  		            click: function() {
  		            	var grid = this.getSearchresultgrid();
  		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,CONSTANTS.CB.SPECIALIZATION_STUDENT_RECORD_LIST_CONFIGCODE);
  		            }
  		        },
  		        'searchresultgrid[itemId=specializationreportgridId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
  		            click: function() {
  		            	var grid = this.getSearchresultgrid();
  		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,CONSTANTS.CB.SPECIALIZATION_STUDENT_RECORD_LIST_CONFIGCODE);
  		            }
  		        },
  		        'searchresultgrid[itemId=specializationreportgridId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
  		            click: function() {
  		            	var grid = this.getSearchresultgrid();
  		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,CONSTANTS.CB.SPECIALIZATION_STUDENT_RECORD_LIST_CONFIGCODE);
  		            }
  		        },
  		       //****************************************************************************************************** 
        	'specializationreportsearch customcombobox#programId': {
   			 select: function(obj, record) {
   				 var programId = record[0].get("id");
   				 if(programId > 0){
   					var form = obj.up('form');
   					form.down('#batchId').setDisabled(false);
   					var store =form.down('#batchId').getStore();
   					store.getProxy().extraParams = {
   						 id: programId
   					 };
   					 store.load();
   				 }
   			 }
   		 },
   		'specializationreportsearch customcombobox#batchId': {
  			 select: function(obj, record) {
  				 var batchId = record[0].get("id");
  				 if(batchId > 0){
  					var form = obj.up('form');
  					form.down('#batchSpecializationId').setDisabled(false);
  					var store =form.down('#batchSpecializationId').getStore();
  					store.getProxy().extraParams = {
  						batchId: batchId
  					 };
  					 store.load();
  				 }
  			 }
  		 },
   		 
   		'specializationreportsearch button#searchBtn': {
  			 click: this.specializationReportload
  		 },
  		'specializationreportsearch button#resetBtn': {
 			 click: function(obj, record) {
 				var form = obj.up('form');
 				form.getForm().reset();
 				form.down('#batchId').setDisabled(true);
 				form.down('#batchSpecializationId').setDisabled(true);
 			 }
 		 },   
 		'specializationreportstructure':{
			afterrender : function(structure){
				 var grid=structure.down('searchresultgrid');
	   			 this.getCBGridHeaderFreeze(grid,structure,false);
			 }
		},
        	
        });
    },
    /*specializationReportload:function(obj,record){
    	var form = obj.up('form');
    	var values = form.getForm().getValues();
    	console.log('values',values);

    },*/
    specializationReportload : function(model, records) {
    	var quickSearchForm = this.getSpecializationreportsearch();
    	quickSearchForm.down('#searchBtn').setDisabled(true);
		var jsonFormatFormData = this.createJsonFormat(quickSearchForm,records);
		var academyLocationId = this.getCurrentAcademyLocation();
		jsonFormatFormData.searchCriterias.push({
			 paramCode: "ACADEMY_LOCATION_ID",
			 paramValues: [academyLocationId]
			 });
		var searchResultGrid = this.getSearchresultgrid();
		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.SPECIALIZATION_STUDENT_RECORD_LIST_VIEWCODE);
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData, quickSearchForm.down('#searchBtn'));
    	 Ext.getBody().unmask();
	},
	createJsonFormat:function(quickSearchForm, record){
		var formValues = quickSearchForm.getForm().getValues();
		
		var values = new Object();
		values.configCode = CONSTANTS.CB.SPECIALIZATION_STUDENT_RECORD_LIST_CONFIGCODE;
		var searchcriteria = new Array();
		
		if(!isNullOrEmpty(formValues.studentId)){
			searchcriteria.push({
				paramCode:"ADMISSION_CODE", 
				paramValues:[formValues.studentId]
			});
		}
		if(!isNullOrEmpty(formValues.studentName)){
			searchcriteria.push({
				paramCode:"STUDENT_NAME", 
				paramValues:[formValues.studentName]
			});
		}
		
		if(!isNullOrEmpty(formValues.program)){
			searchcriteria.push({
				paramCode:"PROGRAM_ID", 
				paramValues:[formValues.program]
			});
		}
		if(!isNullOrEmpty(formValues.batchId)){
			searchcriteria.push({
				paramCode:"BATCH_ID", 
				paramValues:[formValues.batchId]
			});
		}
		if(!isNullOrEmpty(formValues.batchSpecialization)){
			searchcriteria.push({
				paramCode:"SPECIALIZATION_ID", 
				paramValues:[formValues.batchSpecialization]
			});
		}
		
		values.searchCriterias=searchcriteria;
		return values;
	},
	 gridRenderFunction:function(grid){
     	 grid.addButtonToolbar();
      },
      //**********************************Export Functionality********************************************************
      exportUserList : function(exportUrl,filetype,whetherAll,grid,configcode) {
   	   var quickSearchForm = null;
   	   var searchResultGrid = null;
   	   var pagingtoolbaroptions = null; 
   	   var searchCriteriaString = null;
   	   var jsonFormatFormData = null;
     
   	     quickSearchForm=this.getSpecializationreportstructure(); 
   	     searchResultGrid = grid;
   	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
   	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
   	     jsonFormatFormData=this.createJsonFormat(quickSearchForm,null);
   	  
   	   
   	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
    	var reportTitle=getCommonTranslation('SPECIALIZATION_REPORT_LIST');
   	   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
   		   jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
   	   }
   	   searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
   	   console.log("exportSuccess");
      }, 
    //**************************************End*********************************************************************  
   	   createSearchCriteriaString: function(searchForm) {
   		   var me=this;
   		   var formValues = new Array();
   		   formValues = searchForm.getValues();        
   		   var searchCriteriaString="";
   		   for (var key in formValues) {
   			   var value = formValues[key];            
   			   if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
   				   //  var keyValueJsonObject = me.getJsonObject( key , value);
   				   //searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
   			   }
   		   }
   		   searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
   		   return searchCriteriaString;
   	   } 
});