/**
 * This controller is used for scholarship listing functionality
 */
Ext.define('Academia.controller.scholarship.ScholarshipMasterController', {

    extend: 'Academia.controller.base.BaseController',
    views: ['Academia.view.scholarship.scholarshipmaster.ScholarshipMaster', 'Academia.view.scholarship.scholarshipmaster.AddPeriodForm',
            'Academia.view.scholarship.scholarshipmaster.AddScholarship', 'Academia.view.scholarship.scholarshipmaster.PeriodsGrid',
            'Academia.view.scholarship.scholarshipmaster.AcadamyLocationSelector', 'Academia.view.scholarship.scholarshipmaster.ScholarshipMasterSearchForm',
            'Academia.view.scholarship.scholarshipmaster.ScholarshipMasterScreen', 'Academia.view.scholarship.scholarshipmaster.NumberOfAwardeeWindow',
            'Academia.view.scholarship.scholarshipmaster.NumberOfAwardeeGrid', 'Academia.view.scholarship.scholarshipmaster.EligibilityCriteriaHyperLinkForm',
            'Academia.view.scholarship.scholarshipmaster.ScholarshipALMappingStructure','scholarshipRequest.FollowUpDetailsScholarshipForm','scholarshipRequest.ExecutionDetailsScholarshipForm',
            'Academia.view.scholarship.scholarshipmaster.Intellimali','Academia.view.scholarship.scholarshipmaster.IntellimaliScreen','scholarship.scholarshiplisting.ListOfOnlineDocumentsGrid',
            'Academia.view.scholarship.scholarshipmaster.IntellimaliSearchFilter','Academia.view.scholarship.scholarshipmaster.IntellimaliGrid','Academia.view.scholarship.scholarshipmaster.BursaryMasterGrid',
            'Academia.view.scholarship.scholarshipmaster.IntelliMaliTransactionForm','scholarship.scholarshiplisting.SPScholarshipListGrid','scholarship.managescholarship.manageScholarshipSearchTab',
            'Academia.view.scholarship.scholarshipmaster.IntellimaliBulkUploadForm','Academia.view.scholarship.scholarshipmaster.ImportIntellimaliForm','Academia.view.scholarship.scholarshipmaster.DownloadIntellimaliForm',
            'Academia.view.scholarship.scholarshipmaster.ImportIntellimaliBulkUploadGrid','scholarship.scholarshiplisting.SPScholarshipNewStructure','scholarship.managescholarship.ManageScholarshipSearchFilter',
            'Academia.view.scholarship.managescholarship.ScholarshipApplicationForm','Academia.view.scholarship.managescholarship.ScholarshipDetailsForm',
            'Academia.view.scholarship.managescholarship.ScholarshipDeleteConfirmationWindow','Academia.view.scholarship.scholarshipmaster.AddScholarshipTab',
            'Academia.view.scholarship.scholarshipmaster.AddScholarshipMappingProgressTracker', 'Academia.view.scholarship.scholarshipmaster.AddScholarshipTabStructure',
            'Academia.view.scholarship.scholarshipmaster.AddScholarshipTabForm','Academia.view.scholarship.scholarshipmaster.AddScholarshipMappingTab','Academia.view.scholarship.scholarshipmaster.AddScholarshipMappingTabStructure',
            'Academia.view.scholarship.scholarshipmaster.AddScholarshipAddMappingProgressTracker','Academia.view.scholarship.scholarshipmaster.AddScholarshipAcademyLocationGrid','Academia.view.scholarship.scholarshipmaster.AddScholarshipAlGridWithProgram','Academia.view.scholarship.scholarshipmaster.AddScholarshipAlGridWithProgramBatch',
            'Academia.view.scholarship.scholarshipmaster.AddScholarshipDoMappingAlertWin','Academia.view.scholarship.scholarshipmaster.AddScholarshipAlGridWithProgramGroup',
            /*Views for CR*/
            'Academia.view.scholarship.scholarshipmaster.AssociateProgramsCoursesPanel', 'Academia.view.scholarship.scholarshipmaster.AssociateAcademyLocationGrid',
            'Academia.view.scholarship.scholarshipmaster.AssociateCoursesSelector', 'Academia.view.scholarship.scholarshipmaster.AssociateAcademyLocationStructure',
            'scholarship.managescholarship.ScholarshipDetailViewWin','scholarship.scholarshiplisting.ListOfOnlineDocumentsCerpGrid',
            'Academia.view.scholarship.scholarshipmaster.AssociateCourseStructure', 'Academia.view.scholarship.scholarshipmaster.AssociatedProgramsGrid','scholarshipRequest.ScholarshipRequestForm',
            'scholarshipRequest.ScholarshipRequestPanel','scholarship.scholarshiplisting.ScholarshipRequesListStructure','scholarship.scholarshipmaster.ScholarshipServiceListMaster','scholarship.scholarshipmaster.ScholarshipRequestListSerachForm','scholarship.scholarshipmaster.ScholarshipRequestListGridStudent','scholarship.scholarshipmaster.ScholarshipRequestListGridApplicant',
            'scholarship.managescholarship.ManageScholarshipStructure','scholarship.managescholarship.ImportNominationAwardScholarship', 'scholarship.managescholarship.ManageScholarshipDownloadTemplateForm', 'scholarship.managescholarship.ManageScholarshipUploadTemplateForm','scholarship.managescholarship.ManageScholarshipUploadGrid',
            'UploadOptionRadioGroup','scholarship.scholarshiplisting.SPScholarshipAcceptForm','scholarship.scholarshiplisting.SchlDocumentDetailsWin','scholarship.managescholarship.ManageScholarshipStudentListGrid','scholarship.managescholarship.ManageScholarshipApplicantListGrid','scholarship.managescholarship.ManageScholarshipEditDocument','feeandpayment.BursaryMasterAccoutingGrid',
            'scholarship.scholarshipmaster.AccountingDetailsSetupWin',
            'scholarship.scholarshipmaster.ScholarshipApplyToView', 'scholarship.scholarshipmaster.ScholarshipApplyToSearchTab',
            'scholarship.scholarshipmaster.DocsAndRefStructure', 'scholarship.scholarshipmaster.DocsAndRefDetailsWindow','scholarship.managescholarship.ScholarshipHistoryGrid',
            'Academia.view.scholarship.scholarshipmaster.ScholarshipPurposePopUpWindow',
            'scholarship.scholarshipmaster.ScholarshipPurposePopUpGrid'
    ],
    stores: [ 'scholarships.Periods', 'scholarships.AcadamyLocations', 'scholarships.DisbursmentModes',
             'scholarships.ScholarshipTypes', 'scholarships.Status', 'scholarships.AmountTypes', 'scholarships.Currencys','scholarships.SPScholarshipListDocumentsGridStore',
             'scholarships.ApplicationModes', 'scholarships.ScholarshipPaymentTypes', 'scholarships.Acadamys', 'scholarships.Locations',
             'feeandpayment.ActiveCurrencyStore', 'securitysetup.unlockUser.acadamyStore', 'scholarships.SelectionTypes', 'scholarships.Organizations',
             'scholarships.ViewAwardeeStatusComboStore', 'scholarships.awardees','scholarshipRequest.CostCenterScholarshipReqStore','scholarships.ScholarshipIdNameStore',
             /*stores for CR*/
             'scholarships.AssociateAcademyLocationGridStore', 'scholarships.UserAcademyLocationStore', 'scholarships.AssociateProgramStore',
             'scholarships.AssociatedPrograms', 'scholarships.ScholarshipBatchesStore', 'scholarships.ScholarshipCoursesStore', 'common.UserAccessibleAcademys',
             'organization.academylocations.LocationStore','feeandpayment.managebill.ScholarshipSmartSearch','common.AcademyByUserStore','user.UserAcademyLocationStore',
             'scholarships.UserAcademyLocationAssociationStore','scholarships.ScholarshipCostCentreStore','scholarships.GraduateLevelStore',
             'scholarships.ScholarshipPurposeStore','scholarships.FundTypeStore','scholarships.ScholarshipSponsorsStore','scholarships.ScholarshipApplicationIdStore',
             'scholarships.ScholarshipOwnersStore','scholarshipRequest.RequestAssignedToUserStore','scholarshipRequest.ScholarshipStore','scholarshipRequest.AcademicYearScholarshipStore',
             'scholarshipRequest.CostCenterScholarshipReqStore','scholarshipRequest.ProjectNumberScholarshipReqStore','scholarshipRequest.FundingResourceScholarshipStore','scholarshipRequest.ScholarshipRequestListStore','scholarships.RequestTypeStore','scholarships.ServiceRequestStatusStore','feeandpayment.managebill.Applicant','scholarships.RequestAssignedToStore','scholarships.ScholarshipIdNameStore',
			 'scholarships.ApplicableTypeStore','common.BatchesAssociatedWithPeriodByAcadAndProgram','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod', 'coursetransaction.sectioncoursecoverageplan.mastertimetable.ParameterizedPeriodByBatch',
             'user.UserAcademyLocationStore','feeandpayment.managebill.Student','scholarships.FundAllocation','feeandpayment.accountingConfigurationMapping.AccountingYearStore','scholarships.IntellimaliGridStore','scholarships.BursaryMasterStore','scholarships.ManageScholarshipGridStore','scholarships.IntellimaliStudentStore','scholarships.BursaryMasterStore','scholarships.InstituteCSMStore','scholarships.AllowanceProposedStore','scholarships.IntelliMaliActiveProgramStore',
             'importutility.ModuleName','hostel.accommodationProvider.IntelliMaliAccommodationProviderGridStore','scholarships.SPScholarshipListGridStore','scholarships.ScholarshipAccountingYearStore',
             'scholarships.ManageScholarshipStore','scholarships.ScholarshipCategoryStore','scholarships.ManageScholarshipStatusStore','scholarships.IntelliMaliScholarshipBasedStore','scholarships.ManageScholarshipStdListGridStore','importutility.ImportIntelliMaliStore','scholarships.ScholarshipIdNameIntellimaliStore',
             'scholarshipRequest.TransactionIdStore','feeandpayment.managebill.Applicant','feeandpayment.ProgramBatchSeatTypeStore','feeandpayment.managebill.StudentDetailsByNationalId','feeandpayment.managebill.ProgramBatchCodeStore','feeandpayment.managebill.FindBatchByProgram','feeandpayment.managebill.ScholarshipIdOrNameStore','scholarships.ScholarshipTranscationStore','scholarships.ScholarshipAcountingYearStore',
             'scholarshipRequest.TaskNumberScholarshipReqStore','scholarshipRequest.ContractNumberScholarshipReqStore',
             'scholarshipRequest.FundingResourceScholarshipStore','scholarshipRequest.ExpenditureTypeScholarshipStore',
             'scholarshipRequest.ExpenditureOrganizationScholarshipStore','scholarships.ScholarshipOrganizationStore','scholarships.ScholarshipCurrencyStore','feeandpayment.BursaryMasterAccoutingStore','scholarships.FinancingInstitutionStore','scholarships.ScholarshipOwner','scholarships.InternalFundAdministration','scholarships.allowSchoalrshipIDNameStore','scholarships.PurposeStore','scholarships.FunTypeStore',
             'scholarships.ScholarshipApplyToGridStore','scholarships.AccountYearStore','scholarships.AccountCostCenterStore','scholarships.AccountProjectNumber','scholarships.TaskNumberStore','scholarships.ContractNumberStore','scholarships.FundingSourceNumberStore','scholarships.ExpenditureTypeStore',
             'scholarships.DocsAndRefGridStore','scholarships.ExpenditureOrganizationStore','scholarships.ScholarshipApplyToGridStore','scholarships.AddScholarshipAlMappingStore','common.AcademyLocationByName',
             'scholarships.ScholarshipDocumentNameStore','scholarships.AddScholarshipAlMappingWithProgramStore','scholarships.AddScholarshipALProgramBatchListStore','scholarships.AddScholarshipAlWithProgramBatchListStore','scholarships.ScholarshipStudentStore','scholarships.ScholarshipApplicantStore', 'scholarships.AddScholarshipAlWithProgramBatchListComboStore','scholarships.ScholarshipsFacultyCampusStore',
             'scholarships.ScholarshipsProgramStore','scholarships.ScholarshipsHistoryStore','scholarships.RequestByStore','scholarships.AddScholarshipAlMappingWithProgramGroupStore',
             'scholarships.ScholarshipPurposePopUpStore','feeandpayment.accountingConfigurationMapping.AccountingYearForSearchFilterStore'
	],       

    mixins: { 
    	/* to open the applicant profile */
        PersonCommonController: 'Academia.controller.personinfo.common.PersonCommonController'
    },
    refs: [{
        ref: 'scholarshipMasterForm',
        selector: 'scholarshipmastersearchform form[itemId=scholarshipMaster]'
    },{
    	ref: 'scholarshipmaster',
        selector: 'scholarshipmaster'
    }
    ,{
        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=scholarshipMasterGrid]'
    }, {
        ref: 'addScholarshipForm',
        selector: 'addscholarship form[itemId=addscholarshipform]'
    }, {
        ref: 'formAddscholarship',
        selector: 'addscholarship'
    }, {
        ref: 'periodsGrid',
        selector: 'periodsgrid'
    }, {
        ref: 'frmAddPeriodForm',
        selector: 'addperiodformWindow form[itemId=addPeriodForm]'
    }, {
        ref: 'winAddPeriodForm',
        selector: 'addperiodformWindow'
    }, {
        ref: 'acadamyLocationSelectRef',
        selector: 'acadamylocationselector'
    }, {
        ref: 'scholarshipForm',
        selector: 'scholarshipmastersearchform form[itemId=scholarshipMaster] fieldcontainer[itemId=Statuspanel]'
    }, {
        ref: 'periodsForm',
        selector: 'addscholarship panel[itemId=PeriodsFormId]'
    }, {
        ref: 'awardeeWindow',
        selector: 'numberofawardeewindow'
    }, {
        ref: 'NumberofAwardeeGrid',
        selector: 'numberofawardeegrid'
    }, {
        ref: 'awardeeWindowForm',
        selector: 'numberofawardeewindow form[itemId=AwardeeDetailsForm]'
    }, {
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'associateAcademyLocationGrid',
        selector: 'associateacademylocationgrid'
    }, {
        ref: 'associatedProgramsGrid',
        selector: 'associatedprogramsgrid'
    }, {
        ref: 'batchesMultiselectCombo',
        selector: 'multiselectcombofield#multiselectBatchCombo'
    }, {
        ref: 'courseMultiselectCombo',
        selector: 'multiselectcombofield#multiselectCourseCombo'
    },{
    	ref: 'scholarshipmasterscreen',
    	selector: 'scholarshipmasterscreen'
    },{
    	ref:'scholarshiprequestform',
    	selector:'scholarshiprequestform'
    },{
    	ref:'scholarshiprequestpanel',
    	selector:'scholarshiprequestpanel'
    },{
    	ref:'scholarshipRequestListGridStudent',
    	selector:'scholarshipRequestListGridStudent'
    },{
    	ref:'scholarshipRequestListGridApplicant',
    	selector:'scholarshipRequestListGridApplicant'
    },{
    	ref:'scholarshipRequestListSerachForm',
    	selector:'scholarshipRequestListSerachForm'
    },{
    	ref: 'intellimali',
        selector: 'intellimali'
    },{
    	ref: 'intellimaliscreen',
    	selector: 'intellimaliscreen'
    },{
        ref: 'intellimaliForm',
        selector: 'intellimalisearchfilter form[itemId=intellimaliForm]'
    },{
    	ref:'manageScholarshipStructure',
    	selector:'manageScholarshipStructure'
    },{
    	ref:'importnominationawardscholarship',
    	selector:'importnominationawardscholarship'
    },{
    	ref:'managescholarshipdownloadtemplateform',
    	selector:'managescholarshipdownloadtemplateform'
    },{
    	ref:'managescholarshipuploadtemplateform',
    	selector:'managescholarshipuploadtemplateform'
	},{
    	ref:'managescholarshipuploadgrid',
    	selector:'managescholarshipuploadgrid'
	},{
 		ref : 'uploadoptionradiogroup',
   		selector : 'uploadoptionradiogroup[itemId=selectiontransferUploadOptionRadioGroupItemId]'
   	},{
   		ref:'executiondetailsscholarshipform',
   		selector:'executiondetailsscholarshipform'
   	}, {
        ref: 'intellimaligrid',
        selector: 'intellimaligrid[itemId=intellimaliGrid]'
    },
    {
        ref: 'bursaryMasterGrid',
        selector: 'bursaryMasterGrid[itemId=bursaryMasterGrid]'
    },{
    	ref :'intellimalibulkuploadform',
    	selector:'intellimalibulkuploadform'
    },{
    	ref :'importintellimaliform',
    	selector:'importintellimaliform'
    },{
    	ref :'downloadintellimaliform',
    	selector:'downloadintellimaliform'
    },
      {
    	ref:'importintellimalibulkuploadgrid',
    	selector:'importintellimalibulkuploadgrid'
      },{
    	ref:'intellimalitransactionform',
    	selector:'intellimalitransactionform'
      },{
    	  ref:'spscholarshiplistgrid',
    	  selector:'spscholarshiplistgrid'
      },{
    	  ref:'spscholarshipacceptform',
    	  selector:'spscholarshipacceptform'
      },{
    	  ref:'listofonlinedocumentsgrid',
    	  selector:'listofonlinedocumentsgrid'
      },{
    	  ref:'schldocumentdetailswin',
    	  selector:'schldocumentdetailswin'
      },{
    	  ref:'managescholarshipsearchtab',
    	  selector:'managescholarshipsearchtab'
      },{
    	  ref:'managescholarshipsearchfilter',
    	  selector:'managescholarshipsearchfilter'
      },{
    	  ref:'managescholarshipstudentlistgrid',
    	  selector:'managescholarshipstudentlistgrid'
      },{
    	  ref:'managescholarshipapplicantlistgrid',
    	  selector:'managescholarshipapplicantlistgrid'
      },{
    	  ref:'scholarshipdetailviewwin',
    	  selector:'scholarshipdetailviewwin'
      },{
    	  ref:'listofonlinedocumentscerpgrid',
    	  selector:'listofonlinedocumentscerpgrid'
      },{
    	  ref:'managescholarshipeditdocument',
    	  selector:'managescholarshipeditdocument'
	  },{
    	  ref : 'importintellimaliuploadoptionradiogroup',
     		selector : 'uploadoptionradiogroup[itemId=importIntelliMaliUploadOptionRadioGroupItemId]'
      },{
    	  ref:'scholarshipapplicationform',
    	  selector:'scholarshipapplicationform'
      },{
    	  ref:'scholarshipdetailsform',
    	  selector:'scholarshipdetailsform'
      },{
    	  ref:'scholarshipDeleteConfirmationWindow',
    	  selector:'scholarshipDeleteConfirmationWindow'
      },{
    	ref:'addscholarshipmappingprogresstracker',
      	selector:'addscholarshipmappingprogresstracker'
      },{
      	ref:'addscholarshiptabstructure',
        selector:'addscholarshiptabstructure'
      },{
      	ref:'addscholarshiptabform',
        selector:'addscholarshiptabform'
       },{
    	   ref:'accountingDetailsSetupWin',
    	   selector:'accountingDetailsSetupWin'
       }, {
    	   ref: 'docsAndRefStructure',
    	   selector: 'docsAndRefStructure'
       }, {
    	   ref: 'docsAndRefDetailsWindow',
    	   selector: 'docsAndRefDetailsWindow'
       },{
    	 ref:'addScholarshipMappingTab',
         selector: 'addScholarshipMappingTab'
       },{
       	ref:'academylocationgridwithfeepayment',	//academylocationgrid
    	selector:'academylocationgridwithfeepayment'
    },{
    	ref:'addScholarshipMappingTabStructure',
    	selector: 'addScholarshipMappingTabStructure'
    },{
    	ref:'addScholarshipAddMappingProgressTracker',
    	selector: 'addScholarshipAddMappingProgressTracker'
    },{
    	ref:'addScholarshipAcademyLocationGrid',
    	selector: 'addScholarshipAcademyLocationGrid'
    },{
    	ref:'bursarymasteraccoutinggrid',
    	selector:'bursarymasteraccoutinggrid'
    },{
    	ref:'addScholarshipAlGridWithProgram',
    	selector:'addScholarshipAlGridWithProgram'
    },{
    	ref:'addScholarshipAlGridWithProgramGroup',
    	selector:'addScholarshipAlGridWithProgramGroup'
    },{
    	ref:'addScholarshipAlGridWithProgramBatch',
    	selector:'addScholarshipAlGridWithProgramBatch'
    },{
    	ref:'scholarshipApplyToSearchTab',
    	selector:'scholarshipApplyToSearchTab'
    },{
    	ref:'scholarshipApplyToView',
    	selector:'scholarshipApplyToView'
    },{
    	ref:'addScholarshipDoMappingAlertWin',
    	selector:'addScholarshipDoMappingAlertWin'
    },{
    	ref:'scholarshipHistoryGrid',
    	selector:'scholarshipHistoryGrid'
    },{
		ref:'scholarshipPurposePopUpWindow',
    	selector:'scholarshipPurposePopUpWindow'
	},{
		ref:'scholarshipPurposePopUpGrid',
    	selector:'scholarshipPurposePopUpGrid' 
	}],        
    config: {
        SCHOLARSHIP_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIP_MASTER_PRIVILEGES'),
        SS_SCHOLARSHIP_REQUEST_LIST: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SS_SCHOLARSHIP_REQUEST_LIST'),
        INTELLIMALI_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('INTELLIMALI_PRIVILEGES'),
        MANAGE_SCHOLARSHIP__PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SS_MANAGE_SCHOLARSHIP'),
        SP_SCHOLARSHIP_LIST_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIP_LISTING_PRIVILEGES'),
        SP_SCHOLARSHIP_DOCUMENTS_LIST_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIP_LISTING_DOCUMENTS_PRIVILEGES'),
        SS_MANAGE_SCHOLARSHIP_DOCUMENTS_LIST_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SS_MANAGE_SCHOLARSHIP_DOCUMENTS'),
        SCHOLARSHIPMASTER_ACCOUNTING_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIPMASTER_ACCOUNTING_DETAILS'),
        SCHOLARSHIPMASTER_DOCUMENT_AND_REFERENCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIPMASTER_DOCUMENT_AND_REFERENCE'),
        SCHOLARSHIPMASTER_APPLY_TO_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIPMASTER_APPLY_TO_PRIVILEGES')
    },

    init: function(application) {
    	//this.isFormResetting=false;
    	this.stdOrApplicantRecord;
    	this.gridRecord;
    	this.scholarshipAmountPerStd;
    	this.requesterType;
    	this.loggedInUserRoles;
    	this.scholarshipReqEditSCreen=false;
    	this.stdSchlData = [];
    	this.viewModeIntellimali='Add';
    	this.schlAppScreenMode='ADD';
    	this.schlAmountType;
    	this.schlAmountForStd;
    	this.suspendALChangeEvent=false;
    	this.suspendALEventSchlMaster=false;
        this.control({
		   	'addscholarship form[itemId=addscholarshipform]': {
        		afterrender:function(form){
        			var $this = this
        			var feeAmount = form.down('#feeAmounts');
        			var amountOrPercentage = form.down('#amountOrPercentage');
        			var feeHeads = form.down('#feeHeads');
        			var addFeeHeadBtn = form.down('#addFeeHeadBtn');
        			
        			 Ext.Ajax.request({
      					type: 'rest',
      					async: false,
      					url: SERVERURL.COMMON_FORM_FIELD_INFO,
      					params: {
      						//screenName: 'Manage Receipt',
      						academyLocationId: this.getCurrentAcademyLocation(),
      						languageCode:'en'
      					},
      					method: 'GET',
      					success: function(res, action) {
      						var response = Ext.decode(res.responseText);
      					
      						if( Object.keys(response).length > 0 ){
      							var records=response.addscholarship;
      							if(records){
      								form.config.feeHeadVisibility = records[0].isVisible;
          							if(records[0].isVisible == false){
          								feeAmount.hide();
          								amountOrPercentage.hide();
          								
          								addFeeHeadBtn.hide();
          								feeHeads.allowBlank = true;
          								feeAmount.allowBlank = true;
          								amountOrPercentage.allowBlank = true;
              							
          								form.doLayout();
          								
          							}else{
          								feeHeads.allowBlank = false;
          								feeAmount.allowBlank = false;
          								amountOrPercentage.allowBlank = false;
              						
          								feeAmount.show();
          								
          								amountOrPercentage.show();
          								addFeeHeadBtn.show()
          								form.doLayout();
          							}
      							}else{
      								feeAmount.show();
      								amountOrPercentage.show();
      								addFeeHeadBtn.show();
      								feeHeads.allowBlank = false;
      								feeAmount.allowBlank = false;
      								amountOrPercentage.allowBlank = false;
          						
      								form.doLayout();
      							}
      							
      						}
      					 }
					});
        		}
        	},
        	
            'intellimaligrid[itemId=intellimaliGrid]': {
                render: function(grid) {
                	var me=this;
                    me.doAccessControlValidation(grid,me.getINTELLIMALI_PERMISSIONS());
                },
                selectionchange: function(column, selected,eOpts ){
                    var grid = column.view.up('grid');
                    var btnEnable = false;
                    if(selected.length){
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                          if (records[count].get("transactionStatus") != "PENDING") {
                        	  btnEnable = true;
                          }
                        }
                        if(selected.length == 1){
                        	grid.down('#btnEdit').setDisabled(btnEnable);
                        	grid.down('#btnView').setDisabled(false);
                        }else{
                        	grid.down('#btnEdit').setDisabled(true);
                        	grid.down('#btnView').setDisabled(true);
                        }
                        grid.down('#btnDelete').setDisabled(btnEnable);
                        
                    }else{
                    	grid.down('#btnEdit').setDisabled(!btnEnable);
                    	grid.down('#btnView').setDisabled(!btnEnable);
                    	grid.down('#btnDelete').setDisabled(!btnEnable);
                    }
                }
            },
            'intellimaliscreen': {
            	render:function(structure){
            		var grid = structure.down('#intellimaliGrid');
            		this.getGridHeaderFreeze(grid,structure);
            	},
            },
            'intellimalisearchfilter multiselectcombofield[itemId=intellimaliBrandCampusName]':{
    			afterrender:function(obj, record){
					var $this = this;
					var filter = this.getIntellimaliForm();
					var studentCombo = filter.down('#student');
					var studentStore = studentCombo.getStore();
					obj.getStore().load({
						callback: function(record){
							$this.suspendALChangeEvent=true;
							obj.select(obj.getStore().collect(obj.valueField));
							$this.suspendALChangeEvent=false;
						}
					});
				},
				change:function(obj,record){
					var $this = this;
					var form = obj.up('form');
					form.down("#student").reset();
					if(!$this.suspendALChangeEvent){
					   this.changeStudent(obj, record);
					}
				}
    		},
    		'intellimalisearchfilter customcombobox[itemId=statusItemId]':{
    			afterrender:function(obj){
    				var form = obj.up('form');
    				var status = form.down('#statusItemId');
    				status.store.load({
 						 callback: function(records, operation, success) {
 							 for(var  i in records){
	           					  if(records[i].data.id=='PENDING'){
	           						status.setValue(records[i].data.id);
	           					  }
	           				  }
 						 }
 					 });
    			}
    		},
    		
    		'intellimalisearchfilter customcombobox[itemId=intellimaliAccountingYear]':{
    			afterrender:function(obj){
					var $this = this;
					var form = obj.up('form');
					var accountingYear = form.down('#intellimaliAccountingYear');
					var startDate = form.down('#fromdate');
					var endDate = form.down('#todate');
					var studentCombo = form.down('#student');
					var studentStore = studentCombo.getStore();
					var accountingYearId = accountingYear.getValue();
					var al = this.getAcademyLocationId(form);
					accountingYear.store.load({
						callback: function(records, operation, success) {
							for(var  i in records){
								if(records[i].data.whetherCurrentYear==true){
									accountingYear.setValue(records[i].data.id);
									startDate.setMinValue(records[i].data.startDate);
									startDate.setMaxValue(records[i].data.endDate);
									endDate.setMinValue(records[i].data.startDate);
									endDate.setMaxValue(records[i].data.endDate);
									//$this.changeStudent(obj, records);
									var al = $this.getAcademyLocationId(form);
									studentStore.on('beforeload',function() {
										studentStore.getProxy().extraParams.accountingYearId = accountingYear.getValue();
									}, this);
								}
							}
						}
					});
    			},
				select: function(obj, records) {
					var $this = this;
					var form = obj.up('form');
					var accountingYear = form.down('#intellimaliAccountingYear');
					var startDate = form.down('#fromdate');
					var endDate = form.down('#todate');
					var studentId = form.down('#student');
					if(!isNullOrEmpty(records)||!isNullOrEmpty(records[0].data)){
						startDate.setMinValue(records[0].data.startDate);
   						startDate.setMaxValue(records[0].data.endDate);
   						endDate.setMinValue(records[0].data.startDate);
   						endDate.setMaxValue(records[0].data.endDate);
   						studentId.reset();
   						this.changeStudent(obj, records);
					}
                }
    		},
    		 'intellimalisearchfilter form[itemId=intellimaliForm] button[itemId=searchBtn]': {
                 click: function(model, records) {
                    this.loadIntellimaliGridAndSearchUsers(model, records);
                   }
                },

             'intellimalisearchfilter form[itemId=intellimaliForm] button[itemId=resetBtn]':{
 				click:function(obj, record){
 					var $this = this;
 					var form = obj.up('form');
 					form.getForm().reset();
 					var startDate = form.down('#fromdate');
					var endDate = form.down('#todate');
					var status = form.down('#statusItemId');
    				status.store.load({
 						 callback: function(records, operation, success) {
 							 for(var  i in records){
	           					  if(records[i].data.id=='PENDING'){
	           						status.setValue(records[i].data.id);
	           					  }
	           				  }
 						 }
 					 });
 					startDate.setMinValue(null);
 					startDate.setMaxValue(null);
					endDate.setMinValue(null);
					endDate.setMaxValue(null);
					
					
                    var fnpALId = form.down('#intellimaliBrandCampusName');
					var store = fnpALId.getStore();
					
					store.load({
						callback: function(records, operation, success) {
							if (success) {
								 fnpALId.select(fnpALId.getStore().collect(fnpALId.valueField));
							}
						}
					});
					
 				}
     		},
     		'intellimalitransactionform button[itemId=resetButtonId]':{
 				click:function(obj, record){
 					var $this = this;
 					var form = $this.getIntellimalitransactionform();
 					setTimeout(function(){
 						var fundAllocationId = form.down('#fundAllocationId');
 						fundAllocationId.reset();
 						var transactionTypeId = form.down('#transactionTypeId');
 						transactionTypeId.reset();
 						var institutionId = form.down('#institutionId');
 						institutionId.reset();
 						var studentId = form.down('#studentId');
 						studentId.reset();
 						var suNumber = form.down('#suNumber');
 						suNumber.reset();
 						var programId = form.down('#programId');
 						programId.reset();
 						var passportNumber = form.down('#passportNumber');
 						passportNumber.reset();
 						var totalamountId = form.down('#totalamount');
 						totalamountId.reset();
 						var payementstartdateId = form.down('#payementstartdateId');
 						payementstartdateId.reset();
 						payementstartdateId.setMinValue(new Date());
 						var numberofinstalmentId = form.down('#numberofinstalment');
 						numberofinstalmentId.reset();
 						var estimatedmonthlyinstallmentId = form.down('#estimatedmonthlyinstallment');
 						estimatedmonthlyinstallmentId.reset();
 						var scholarshipId = form.down('#scholarshipId');
 						scholarshipId.reset();
 						var allowanceproposedId = form.down('#allowanceproposed');
 						allowanceproposedId.reset();
 						var accommodationproviderId = form.down('#accommodationproviderId');
 						accommodationproviderId.reset();
 						var commentsId = form.down('#commentsId');
 						commentsId.reset();
 						
 						form.getForm().reset();
					},300);
					form.getForm().reset();
					
 				}
     		},
     		'intellimaligrid[itemId=intellimaliGrid] button#btnAdd' : {
				click : function() {
					var this$ = this;
					this.viewModeIntellimali='Add';
					var structure = Ext.widget('intellimalitransactionform');
			        var tabName = getCommonTranslation('ADD_INTELLI_MALI_TRANSACTION');
			        structure.setTitle(getCommonTranslation('INTELLI_MALI_DETAILS'));
		            
		            var getcontroller=this.getController('menu.CoreERPNavigationController');
		 	        var getAddTab = getcontroller.getTab(getCommonTranslation('ADD_INTELLI_MALI'));
		 	        if (getAddTab != null) {
			            contentPanel.remove(getAddTab, true);
			        }
		 	     openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);
				}
			},
			'intellimaligrid[itemId=intellimaliGrid] button#btnEdit' : {
				click : function() {
					var this$ = this;
					this.viewModeIntellimali="Edit";
					var grid = this.getIntellimaligrid();
					if (grid.getSelectionModel().getCount() > 0) {
						var rec = grid.getSelectionModel().getSelection()[0];
						var structure = Ext.widget('intellimalitransactionform');
						var tabName = getCommonTranslation('EDIT_INTELLIMALI_TRANSACTION');
						structure.setTitle(getCommonTranslation('INTELLI_MALI_DETAILS'));
 
						var getcontroller=this.getController('menu.CoreERPNavigationController');
						var getAddTab = getcontroller.getTab(getCommonTranslation('EDIT_INTELLIMALI_TRANSACTION'));
						if (getAddTab != null) {
							contentPanel.remove(getAddTab, true);
						}
						openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);
						this.setIntellimaliData(structure,rec);
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'intellimaligrid[itemId=intellimaliGrid] button#btnView' : {
				click : function() {
					var this$ = this;
					this.viewModeIntellimali='View';
					var grid = this.getIntellimaligrid();
					if (grid.getSelectionModel().getCount() > 0) {
						var rec = grid.getSelectionModel().getSelection()[0];
						var structure = Ext.widget('intellimalitransactionform');
						var tabName = getCommonTranslation('VIEW_INTELLIMALI_TRANSACTION');
						structure.setTitle(getCommonTranslation('INTELLI_MALI_DETAILS'));
 
						var getcontroller=this.getController('menu.CoreERPNavigationController');
						var getAddTab = getcontroller.getTab(getCommonTranslation('VIEW_INTELLIMALI_TRANSACTION'));
						if (getAddTab != null) {
							contentPanel.remove(getAddTab, true);
						}
						openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);
						this.setIntellimaliData(structure,rec);
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'intellimaligrid[itemId=intellimaliGrid] button#btnDelete' : {
				click : function() {
					this.deleteIntellimaliRecords();
				}
			},
			'intellimalitransactionform button[itemId=cancelButtonId]':{
				click : function() {
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getAddTab = getcontroller.getTab(getCommonTranslation('VIEW_INTELLIMALI_TRANSACTION'));
					if (getAddTab != null) {
						contentPanel.remove(getAddTab, true);
					}
				}
			},
			'intellimalitransactionform':{
				afterrender: function(form){
					var studentId = form.down('#studentId');
					studentId.getStore().getProxy().extraParams = {
            		  isForSave:true
				     };
				}
			},
			'intellimalitransactionform customcombobox[itemId=studentId]':{
	                select:function(cmp,record){
				    var $this =this;
					var form = cmp.up('intellimalitransactionform');
					var academyLoactionId = form.down("#academyLocationId");
					var obj = form.down('#studentId');
					if(isNullOrEmpty(record[0].data.id)){
						var programId = form.down('#programId');
						programId.reset();
						var suNumber = form.down('#suNumber');
						suNumber.reset();
						var passportNumber = form.down('#passportNumber');
						passportNumber.reset();
						var fundAllocationId = form.down('#fundAllocationId');
						fundAllocationId.reset();
						var transactionTypeId = form.down('#transactionTypeId');
						transactionTypeId.reset();
					}else{
						var studentId=record[0].data.id;
						var personId=record[0].data.personId;
						var fundAllocationId = form.down('#fundAllocationId');
						fundAllocationId.reset();
						var transactionTypeId = form.down('#transactionTypeId');
						transactionTypeId.reset();
					}
				    
				    	// Finding AcademyLocation By Student Id
					var academyLoactionStore = academyLoactionId.getStore();
					academyLoactionStore.getProxy().extraParams = {
						  studentId: studentId
						  };
					setTimeout(function(){
						academyLoactionStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length == 1){
										academyLoactionId.setValue(records[0].data.id);
										var model = [records[0]];
										academyLoactionId.fireEvent('select', academyLoactionId, model);
										academyLoactionId.setReadOnly(true);
									}else{
										academyLoactionId.setReadOnly(false);
									}	 
								}
							}	   
						});
					},300);	
				    
				    
					var programId = form.down('#programId');
					programId.setDisabled(false);
					programId.reset();
					var programIdStore = programId.getStore();
					programIdStore.getProxy().extraParams = {
						studentId: studentId,
						academyLocationId:academyLoactionId.value
					};
					programIdStore.reload();
					setTimeout(function() {
						programIdStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if (records.length == 1) {
										programId.setValue(records[0].data.id);
										var model = [records[0]];
										programId.fireEvent('select', programId, model);
										programId.setReadOnly(true);
									} else {
										programId.setReadOnly(false);
									}
								}
							}
						});
					}, 300);

					
					
					
					//var externalRefOneFiled= form.down('#externalSysRefOne');
					var submitURL = SERVERURL.FIND_PATH_ID_DETAILS_BY_PERSON_ID;
					Ext.Ajax.request({
						type: 'rest',
						url: submitURL,
						params:{
							personId: personId
						},
						method: 'GET',
						success: function(response) {
							var externalRefOneData =response.responseText;
							var suNumber = form.down('#suNumber');
							if(!isNullOrEmpty(externalRefOneData)){
								var data=Ext.decode(response.responseText);
								var suNumber = form.down('#suNumber');
								suNumber.setValue(data.suNumber);
								//suNumber.setReadOnly(true);
								var passportNumber = form.down('#passportNumber');
								passportNumber.setValue(data.idTypeValue);
								//passportNumber.setReadOnly(true);
							}else
							{
								suNumber.setValue("");
							}		
						}
					});
					var scholarship = form.down('#scholarshipId');
					   
					 var scholarshipStore=scholarship.getStore();
						 scholarshipStore.getProxy().extraParams = {
						  studentId: studentId,
						  academyLocationId:academyLoactionId.value
						  };
						scholarshipStore.load();
						
						var submitURL = SERVERURL.PATH_FIND_BURSARY_DETAILS_BY_STUDENT_ID;
						Ext.Ajax.request({
							type: 'rest',
							url: submitURL,
							params:{
								studentId: record[0].data.id
							},
							method: 'GET',
							success: function(response) {
								var res =Ext.decode(response.responseText);	
								 if(res.length==0)
									{
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_STUDENT_IS_NOT_ASSOCIATED_WITH_ANY_SCHOLARSHIP'));
									}

							}
						});
					
				}
				},
				'intellimalitransactionform [itemId=academyLocationId]':{
					select: function(cmp, record) {
						
						var form = cmp.up('intellimalitransactionform');
						var academyLocation = form.down("#academyLocationId");
						var obj = form.down('#studentId');
						var programId = form.down('#programId');
						var scholarship = form.down('#scholarshipId');

						
						
						var programId = form.down('#programId');
						programId.setDisabled(false);
						programId.reset();
						var programIdStore = programId.getStore();
						programIdStore.getProxy().extraParams = {
							studentId: obj.value,
							academyLocationId: academyLocation.value
						};
						programIdStore.reload();
						setTimeout(function() {
							programIdStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if (records.length == 1) {
											programId.setValue(records[0].data.id);
											var model = [records[0]];
											programId.fireEvent('select', programId, model);
											programId.setReadOnly(true);
										} else {
											programId.setReadOnly(false);
										}
									}
								}
							});
						}, 300);


						var scholarshipStore = scholarship.getStore();
						scholarshipStore.getProxy().extraParams = {
							studentId: obj.value,
							academyLocationId: academyLocation.value
						};
						var scholarshipId = form.down('#scholarshipId');
						setTimeout(function() {
							scholarshipStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if (records.length == 1) {
											scholarshipId.setValue(records[0].data.id);
											var model = [records[0]];
											scholarshipId.fireEvent('select', scholarshipId, model);
											scholarshipId.setReadOnly(true);
										} else {
											scholarshipId.setReadOnly(false);
										}
									}
								}
							});
						}, 300);


					}
				},
				'intellimalitransactionform [itemId=programId]':{
					select: function(cmp, record) {
						var form = cmp.up('intellimalitransactionform');
						var academyLocation = form.down("#academyLocationId");
						var obj = form.down('#studentId');
						var progObj = form.down('#programId');
						var scholarship = form.down('#scholarshipId');
						var scholarshipStore = scholarship.getStore();
						scholarshipStore.getProxy().extraParams = {
							studentId: obj.value,
							academyLocationId: academyLocation.value,
							programId:progObj.value
						};
						var scholarshipId = form.down('#scholarshipId');
						setTimeout(function() {
							scholarshipStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if (records.length == 1) {
											scholarshipId.setValue(records[0].data.id);
											var model = [records[0]];
											scholarshipId.fireEvent('select', scholarshipId, model);
											scholarshipId.setReadOnly(true);
										} else {
											scholarshipId.setReadOnly(false);
										}
									}
								}
							});
						}, 300);
						
					}
				},
				'intellimalitransactionform customcombobox[itemId=intellimaliAccountingYear]':{
					    change:function(objval,record){
						var $this =this;
						if(this.viewModeIntellimali == 'Add'){
						var form = objval.up('intellimalitransactionform');                  
						var payementstartdate = form.down('#payementstartdateId');
						var startdate = new Date(objval.getStore().getAt(objval.getStore().findExact(objval.valueField,objval.getValue())).data.startDate);
						var enddate = new Date(objval.getStore().getAt(objval.getStore().findExact(objval.valueField,objval.getValue())).data.endDate)
						payementstartdate.setMinValue(new Date());
						payementstartdate.setMaxValue(enddate);
						payementstartdate.setDisabled(false);
						}
						                   	
				                }
				            },
				'intellimalitransactionform radiogroup[itemId=fundAllocationId]':{
					    change:function(objval,record){
						var $this =this;
						var temp=false;
						if(this.viewModeIntellimali == 'Add'){
						var form = objval.up('intellimalitransactionform');
						  var radioButton = form.down("#fundAllocationId") ;
						  var radioButtonValue = radioButton.lastValue.fundAllocation;
                        var allowanceproposed = form.down('#allowanceproposed');
						allowanceproposed.reset();
						var allowanceproposedStore = allowanceproposed.getStore();
						allowanceproposedStore.removeAll();
						
						var accommodationprovider = form.down('#accommodationproviderId');
						accommodationprovider.setVisible(false);
						var studentId=form.getValues().student;
					    var trnasactionType=form.down('#transactionTypeId');
					  //var externalRefOneFiled= form.down('#externalSysRefOne');
						var submitURL = SERVERURL.FIND_INTELLI_MALI_RECORD_BY_STUDENT_ID;
							Ext.Ajax.request({
								type: 'rest',
								url: submitURL,
								params:{
									studentId: studentId
								},
								method: 'GET',
								success: function(response) {
									var inteliMalirecord =response.responseText;
									if(!isNullOrEmpty(inteliMalirecord)){
										var data=Ext.decode(response.responseText);
										
										trnasactionType.setValue({transactionType:'NEW'});
										trnasactionType.items.items[1].setDisabled(true);
										trnasactionType.items.items[2].setDisabled(true);
										trnasactionType.items.items[3].setDisabled(true);
										
										
										trnasactionType.setValue({transactionType:'NEW'});
										trnasactionType.items.items[1].setDisabled(true);
										trnasactionType.items.items[2].setDisabled(true);
										trnasactionType.items.items[3].setDisabled(true);
																				
										for(var i=0;i<data.length;i++){ 
											if(data[i].fundAllocationCash==true  && record.fundAllocation=='CASH' && data[i].accountingYear.id==form.getValues().intellimaliAccountingYear){
												trnasactionType.items.items[0].setDisabled(true);
												trnasactionType.items.items[1].setDisabled(false);
												trnasactionType.items.items[2].setDisabled(false);
												trnasactionType.items.items[3].setDisabled(false);
												trnasactionType.reset();
												temp=true;
											}else if(!temp){
												trnasactionType.items.items[0].setDisabled(false);
												trnasactionType.setValue({transactionType:'NEW'});
											}
											if(data[i].fundAllocationBooks==true && record.fundAllocation=='BOOKS' && data[i].accountingYear.id== form.getValues().intellimaliAccountingYear){
												trnasactionType.items.items[0].setDisabled(true);
												trnasactionType.items.items[1].setDisabled(false);
												trnasactionType.items.items[2].setDisabled(false);
												trnasactionType.items.items[3].setDisabled(false);
												trnasactionType.reset();
												temp=true;
											}else if(!temp){
												trnasactionType.items.items[0].setDisabled(false);
												trnasactionType.setValue({transactionType:'NEW'});
											}
											if(data[i].fundAllocationMeals==true && record.fundAllocation=='MEALS' && data[i].accountingYear.id== form.getValues().intellimaliAccountingYear){
												trnasactionType.items.items[0].setDisabled(true);
												trnasactionType.items.items[1].setDisabled(false);
												trnasactionType.items.items[2].setDisabled(false);
												trnasactionType.items.items[3].setDisabled(false);
												trnasactionType.reset();
												temp=true;
											}else if(!temp){
												trnasactionType.items.items[0].setDisabled(false);
												trnasactionType.setValue({transactionType:'NEW'});
											} 
											if(data[i].fundAllocationAccommodation==true && record.fundAllocation=='ACCOMMODATION' && data[i].accountingYear.id== form.getValues().intellimaliAccountingYear){
												trnasactionType.items.items[0].setDisabled(true);
												trnasactionType.items.items[1].setDisabled(false);
												trnasactionType.items.items[2].setDisabled(false);
												trnasactionType.items.items[3].setDisabled(false);
												trnasactionType.reset();
												temp=true;
											}else if(!temp){
												trnasactionType.items.items[0].setDisabled(false);
												trnasactionType.setValue({transactionType:'NEW'});
											}

											/*if(!temp){
												trnasactionType.items.items[0].setVisible(true);
											}*/

										}
									}		
								}
							});
						allowanceproposedStore.load({
							callback: function(item, oper, scs) {
								if(radioButtonValue=='CASH'){
							    	allowanceproposed.setReadOnly(false);
							    	accommodationprovider.allowBlank=true;
							   }else if(radioButtonValue=='BOOKS'){
							    	var newBook=allowanceproposedStore.findRecord('code',"Study-materials");
							    	newBook && allowanceproposed.setValue(newBook.getId());
							    	allowanceproposed.setReadOnly(true);
							    	accommodationprovider.setVisible(false);
							    	accommodationprovider.allowBlank=true;
								}else if(radioButtonValue=='MEALS'){
									var newMeals=allowanceproposedStore.findRecord('code',"Meals")
									newMeals && allowanceproposed.setValue(newMeals.getId());
							    	allowanceproposed.setReadOnly(true);
							    	accommodationprovider.setVisible(false);
							    	accommodationprovider.allowBlank=true;
							    	
								}else if(radioButtonValue=='ACCOMMODATION'){
							    	allowanceproposed.setReadOnly(false);
							    	var newAcco=allowanceproposedStore.findRecord('code',"Accommodation");
							    	newAcco && allowanceproposed.setValue(newAcco.getId());
									allowanceproposed.setReadOnly(true);
							    	accommodationprovider.setVisible(true);  
							    	accommodationprovider.setDisabled(false);
									 var accommodationproviderStore=accommodationprovider.getStore();
									 accommodationproviderStore.getProxy().extraParams = {
										  studentId: studentId
									  };
									 accommodationproviderStore.load({
											callback: function(records, operation, success) {
												if (success) {
													if(records.length == 1){
														accommodationprovider.setValue(records[0].data.id);
														accommodationprovider.setReadOnly(true);
														accommodationprovider.allowBlank=false;
														accommodationprovider.setVisible(true);
													}else{
														accommodationprovider.setReadOnly(false);
														accommodationprovider.allowBlank=false;
														
													}	 
												}
											}	   
										});
									}
							} 
						});
                          
					    if(record.fundAllocation=='ACCOMMODATION'){
							var newAcco=allowanceproposed.getStore().findRecord('code',"Accommodation")
							if(newAcco){
								allowanceproposed.setValue(newAcco.getId());
							}
					    	allowanceproposed.setReadOnly(true);
                                    accommodationprovider.setVisible(true);  
                                     var accommodationproviderStore=accommodationprovider.getStore();
                                     accommodationproviderStore.getProxy().extraParams = {
								  studentId: studentId
								  };
                                     accommodationproviderStore.load({
                                            callback: function(records, operation, success) {
                                                if (success) {
                                                	accommodationprovider.allowBlank=false;
                                                    if(records.length == 1){
                                                        accommodationprovider.setValue(records[0].data.id);
												var model = [records[0]];
												accommodationprovider.fireEvent('select', accommodationprovider, model);
                                                        accommodationprovider.setReadOnly(true);
                                                    }else{
                                                        accommodationprovider.setReadOnly(false);
                                                    }     
                                                }
                                            }       
                                        });
                                    }
						}
				      }
				},
				'intellimalitransactionform datefield[itemId=payementstartdateId]':{
					    change:function(objval,record){
						var $this =this;
						var form = objval.up('intellimalitransactionform');
						var payementstartdate = form.down('#payementstartdateId');
						var numberofinstalment = form.down('#numberofinstalment');
						numberofinstalment.reset();
						numberofinstalment.setMaxValue(null);
						var totalDate=new Date(new Date().getFullYear(), 11, 31);
						var totalMonth=totalDate.getMonth();
						if(!isNullOrEmpty(payementstartdate.getValue())){
							var payementstartdateMonth=payementstartdate.getValue().getMonth();
							var totalCount=(totalMonth-payementstartdateMonth)+1;
						}
						
						numberofinstalment.setValue(totalCount);
						numberofinstalment.setMaxValue(totalCount);
					
						    
					}
				            },
				'intellimalitransactionform numberfield[itemId=numberofinstalment]':{
					    change:function(objval,record){
						var $this =this;
						var form = objval.up('intellimalitransactionform');
						var newt=form.getValues();
						var estimatedmonthlyinstallment = form.down('#estimatedmonthlyinstallment');
						
						var totalamount=newt.totalamount;
						var num=record;
						if(!isNullOrEmpty(num) && num>=1){
							var estimatedValue=totalamount/num;
							var estimatedValueNew= Number(estimatedValue.toFixed(2));
							estimatedmonthlyinstallment.setValue(estimatedValueNew);
							estimatedmonthlyinstallment.setReadOnly(true);
							
						}else{
							estimatedmonthlyinstallment.reset();
						}
						}
				            },
				'intellimalitransactionform numberfield[itemId=totalamount]':{
					    change:function(objval,record){
						var $this =this;
							var form = objval.up('intellimalitransactionform');
						var newt=form.getValues();
						var estimatedmonthlyinstallment = form.down('#estimatedmonthlyinstallment');
						var payementstartdateId = form.down('#payementstartdateId');
						payementstartdateId.reset();
						estimatedmonthlyinstallment.reset();
						}
				            },
				'intellimalitransactionform customcombobox[itemId=intellimaliAccountingYear]':{ 
	    			afterrender:function(obj){
						var $this = this;
						var form = obj.up('form');
						var accountingYear = form.down('#intellimaliAccountingYear');
						var payementstartdate = form.down('#payementstartdateId');
						accountingYear.store.load({
	  						 callback: function(records, operation, success) {
	  							 for(var  i in records){
		           					  if(records[i].data.whetherCurrentYear==true){
		           						accountingYear.setValue(records[i].data.id);
		           						payementstartdate.setMinValue(new Date());
		           						payementstartdate.setMaxValue(records[i].data.endDate);
		           					  }
		           				  }
	  						 }
	  					 });
						var allowanceproposed= form.down('#allowanceproposed');
						var accommodationprovide= form.down('#accommodationproviderId');
						accommodationprovide.setVisible(false);
						allowanceproposed.store.load();
					},
					change: function(objval, records) {
						var $this =this;
						var form = objval.up('intellimalitransactionform');
						if(this.viewModeIntellimali=='Add'){
						var payementstartdate = form.down('#payementstartdateId');
						var fundAllocationId = form.down('#fundAllocationId');
						payementstartdate.reset();
						fundAllocationId.reset();
						var transactionTypeId = form.down('#transactionTypeId');
						if(!isNullOrEmpty(objval.getStore().data.items)){
						if(!isNullOrEmpty(objval.getStore().getAt(objval.getStore().findExact(objval.valueField,objval.getValue())))){
						var startdate = new Date(objval.getStore().getAt(objval.getStore().findExact(objval.valueField,objval.getValue())).data.startDate);
						var enddate = new Date(objval.getStore().getAt(objval.getStore().findExact(objval.valueField,objval.getValue())).data.endDate)
						payementstartdate.setMinValue(new Date());
						payementstartdate.setMaxValue(enddate);
						}
						}
						}
					}
	                
	    		},
			       'intellimalitransactionform button[itemId=submitBtn]':{
						click: this.saveIntelliMaliRecord
					},
				       'intellimalitransactionform button[itemId=updateBtn]':{
							click: this.updateIntelliMaliRecord
						},
					
     		//bulk upload Intellimali
		   'intellimalibulkuploadform radiogroup[itemId=importDownloadgroupId]':{
			   change: this.downloadUploadFormChange
		   },
		   'intellimali':{
			   render : function(obj){
   				var $this = this;
   				var alForm = obj.down('intellimalibulkuploadform');
   				var ShField = alForm.down('#scholarshipId');
   				$this.setAllowBlank (ShField,false);
   				ShField.isValid();
   			  }
		   },
     		
		   
  		   'downloadintellimaliform button[itemId=resetBtn]':{
			   click:function(obj){
				   var $this = this;
				   var bulkUploadTemplateForm = $this.getIntellimalibulkuploadform();
				   var scholarshipField = bulkUploadTemplateForm.down("#scholarshipId");
				   scholarshipField.reset();
			   }   
		   },
		   'importintellimaliform button[itemId=resetBtn]':{
	   			click: function(obj) {
	   				var $this = this;
	   				var bulkUploadTemplateForm = $this.getImportintellimaliform()
	   				var uploadField = bulkUploadTemplateForm.down("#uploadFileField");
       			    uploadField.reset();
               	    var combo1 = bulkUploadTemplateForm.down('#moduleName');
    			    combo1.getStore().load({
    				  callback: function(records, operation, success) {
    					  for(var i in records){
    						  if(records[i].data.value=='Bulk Intellimali'){
    							combo1.setValue(records[i].data.id);
    						  }
    					  }
    				  }	   
    			  });
	   			}
	   		},
	   	           'importintellimaliform button[itemId=uploadTemplateBtnId]':{
			                   click:function(obj){
				                       var $this=this;
				                       var importWin=$this.getImportintellimaliform();
				                       var grdStore;
				                       var grid = $this.getImportintellimalibulkuploadgrid();
				                       var form=$this.getImportintellimaliform();
				                       var downloadIntellimaliform = this.getDownloadintellimaliform();
				                       var uploadCsv = form.down('#uploadFileField');
				                       submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
				                       $this.getHashOfFile(form);
				                         setTimeout(function() {
				                             form.getForm().submit({
				                                 method : 'POST',
				                                 url : submitUrl,
				                                 success : function(form, action){
				                                     showSuccessMessage(getCommonTranslation('IMPORT_UTILITY') ,getCommonTranslation('SUCCESS'));
				                                     downloadIntellimaliform.isValid();
				                                 },
				                                 failure: function(form, action) {
				                                         showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
				                                 }
				                             });
				                         },1000);
				                       
				                       Ext.defer(function() {
				                           var form =this.getImportintellimaliuploadoptionradiogroup();
				                           var isUploadAll = form.items.items[0].getValue().isUploadAll;
				                           this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_INTELLIMALI');
				                       }, 2000, this);
				                   } 
				                 },
				   'importintellimaliform uploadoptionradiogroup[itemId=importIntelliMaliUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
		 	   			change: function( radioGroup, newValue, oldValue, eOpts){
		 	   				
		 	   			var uploadForm=radioGroup.up('importintellimaliform');
		 	  		   	var grid = this.getImportintellimalibulkuploadgrid();
		 	  		   	var form =this.getImportintellimaliuploadoptionradiogroup();
		 	  		    var isUploadAll = newValue.isUploadAll;
		 	  		    this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_INTELLIMALI');
		 	   			}   
		 	   		},
		 	   	'importintellimalibulkuploadgrid':{
	     		     render : function(obj){
	    				var $this = this;
	    				var grid = $this.getImportintellimalibulkuploadgrid();
	    				var form =this.getImportintellimaliuploadoptionradiogroup();
	    				var isUploadAll = form.items.items[0].getValue().isUploadAll;
  					   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_INTELLIMALI');	
	    			  },
	    			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	      				if (e.target.tagName == 'A') {
	      					var fileType=null;
	      					if(cellIndex==1){
	      						fileType='successFile';
	      					}else if(cellIndex==6){
	      						fileType='errorFile';
	      					}else if(cellIndex==7){
	      						fileType='logFile';
	      					}
	      					var documentId = record.get("id");
	      					if (!isNullOrEmpty(documentId)) {
	      						this.getDownloadFile(documentId,fileType);
	      					}
	      				}
	      			}
	     		},
	     		
	     		'importintellimalibulkuploadgrid button[itemId=btnForce]':{
	    			click: function(obj) {
	 	            	var grid = this.getImportintellimalibulkuploadgrid();
	 	            	if (grid.getSelectionModel().getCount() > 0) {
	 	            		if(grid.getSelectionModel().getCount() > 1){
	 		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	 		        		}else{
	 		        			var this$ = this;
	    	                	var id = grid.getSelectionModel().selectionStart.data.id;
	    	                	console.log(id);
	    	                	var urlAppend="?jobName="+id;
	    	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	    	    	        	Ext.Ajax.request({
	    	    	        		url: submitURL,
	    	    	        		method: 'GET',
	    	    	        		success: function(response) {
	    	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	    	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	    	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	    	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	    	    	        			}else if(response.responseText==="SUCCESS"){
	        	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	    	    	        			}
	    	    	        		}
	    	    	        	});
	 		        		}
	 	            	} else {
	 	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	 	            	}  
	 	            }
	     		},
	     		'importintellimaliform':{
	        		render:function(obj){
	        			var $this=this;
	    	        	var importWin=$this.getImportintellimaliform()
	    	        	var moduleName = importWin.down('#moduleName');
	    	        	moduleName.getStore().load({
	    	        		callback: function(records, operation, success) {
	    	        			for(var i in records){
		    	        			if(records[i].data.value=="Bulk Intellimali"){
		    	        				moduleName.setValue(records[i].data.id);
		    	        				moduleName.setReadOnly(true)
		    	        			}
	    	        			}
 	            		   }	
	    	        	});
	        		}  
    		 },

    		 
    		 'downloadintellimaliform button[itemId=intellimaliDownload]':{
  			   click:function(obj){ 
  				   var $this = this;
  				   var form =$this.getDownloadintellimaliform().getForm();
  				   var intellimaliBulkUploadForm = $this.getIntellimalibulkuploadform();
  				   var scholarshipId = intellimaliBulkUploadForm.down("#scholarshipId").getValue();
       		
                	 //*********for multiselect Academy Location**********
                	  if(scholarshipId ==  undefined || scholarshipId == "") {
                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD') + " :  " + getCommonTranslation('SCHOLARSHIP'));
                		 return false;
                	   }
                	   else {
                		 var value = form.getValues();
      				   var csvForm = Ext.create('Ext.form.Panel'); 
      				   csvForm.getForm().submit({
      					   target: '_blank',
      					   method:'POST',
      					   params :{
      						   access_token : Ext.Ajax.defaultHeaders.access_token,
      						 scholarshipId: scholarshipId,
      					   },
      					   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
      					   url: SERVERURL.DOWNLOAD_INTELLIMALI_TEMPLATE_URL,
      					   standardSubmit :true
      				   });
                	   }
  			   }  
  		   },
  		   
        	'scholarshipmaster' : {
        		tabchange: function(view,newTab,oldtab){
        			var master=this.getScholarshipmaster();
        			var advancesearch = master.down('advancedsearchquerybuilder');
        			var combo1 = advancesearch.down('#loadSavedSearchComboId');
        			combo1.setVisible(false);
        		}
        	},
            'searchresultgrid[itemId=scholarshipMasterGrid]': {
                afterrender: function(grid) {
                	var me=this;
                    this.gridRenderFunction(grid);
                    this.genericCBGridAccessControlValidation(grid, this.getSCHOLARSHIP_MASTER_PERMISSIONS());
                    var deleteButton = grid.down('#searchResultGridBtnDelete');
                    deleteButton.setVisible(false);
                    me.addDataGridConfigButton(grid,me.getSCHOLARSHIP_MASTER_PERMISSIONS());
                }
            },
            'bursaryMasterGrid': {
                afterrender: function(grid) {
                	var me=this;
                	this.doAccessControlValidation(grid, me.getSCHOLARSHIP_MASTER_PERMISSIONS());
                    me.addDataGridConfigButton(grid,me.getSCHOLARSHIP_MASTER_PERMISSIONS());
                   
                    var associatedAcadLocationIds = new Array();
            		associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, me.getSCHOLARSHIP_MASTER_PERMISSIONS());
                    
            		
            		if(permissionList.indexOf('APPLY_TO') !== -1 && permissionList.indexOf('MOREACTIONS') !== -1){
            			var button = buttonsToolBar.query('#spBtnMoreActions')[0];
                		var scholarshipApplyToBtn = buttonsToolBar.query('#scholarshipApplyToBtn')[0];
                		if(!isNullOrEmpty(button)){
                			scholarshipApplyToBtn && scholarshipApplyToBtn.setVisible(true);
                			button.setVisible(true);
                	}  
            		}
            		
                },
                 cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
					if(columnName == "purpose"){
						 if(e.target.tagName=='A'){
							 this.showPurposeOnPopUpWindow();
						 }
					 }
                }
            },
            'scholarshipmastersearchform form[itemId=scholarshipMaster] button': {
                click: function(btn) {
                    if (btn.itemId == 'ScholarshipMasterSearchBtn') {
                        this.loadGridAndSearchUsers();
                    }
                }
            },
            
            'scholarshipmasterscreen searchresultgrid[itemId=scholarshipMasterGrid]': {
                cellclick: this.cellclick
            },

            'scholarshipmaster advancedsearchquerybuilder searchresultgrid[itemId=userAdvSearchResultGrid]': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    this.cellclickAdvanceSearch(grid, td, cellIndex, record, tr, rowIndex, e, eOpts)
                }
            },

            'bursaryMasterGrid button[itemId=btnAdd]': {
                click: this.addScholarshipTabPanel
            },
            'bursaryMasterGrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editScholarshipTabPanel, this, [false])
            },
            'bursaryMasterGrid button[itemId=btnView]': {
                click: Ext.bind(this.editScholarshipTabPanel, this, [true])
            },
            'bursaryMasterGrid button[itemId=btnDelete]': {
                click: this.deleteScholarship
            },
            'bursaryMasterGrid button[itemId=spBtnMoreActions] menuitem': {
                click: function(button) {
                    if (button.itemId === "assignGradeLevelEntry") {
                        this.assignProgarmEntities(button);
                    }
                    if(button.itemId === "scholarshipApplyToBtn") {
                    	this.openScholarshipApplyToScreen(button);
                    }
                }
            },
            'addscholarship button[itemId=addScholarshipBtn]': {
                click: function(btn) {
                    this.SaveAddScholarshipForm(btn);
                }
            },
            'addscholarship button[itemId=addFeeHeadBtn]': {
                click: this.addFeeHeadsForScholarship
             
            },
            'addscholarship radiogroup[itemId=applicationRequiredId]': {
                change: function(obj,newValue,oldValue) {
                	var form = obj.up('form');
            		var applicationStartDate = form.down("#applicationStartDateId");
            		var applicationEndDate = form.down("#applicationEndDateId");
            		var allowApplicationAfterEndDate = form.down("#allowApplicationAfterEndDateId");
            		if (newValue.applicationRequired==true) {
            			applicationStartDate.setDisabled(false);
            			applicationEndDate.setDisabled(false);
            			allowApplicationAfterEndDate.setDisabled(false);
            		} else {
            			applicationStartDate.setDisabled(true);
            			applicationEndDate.setDisabled(true);
            			allowApplicationAfterEndDate.setDisabled(true);
            		}
            		form.getForm().checkValidity();
                }
            },
            'periodsgrid button[itemId=btnAddPeriod]': {
                click: function(btn) {
                    this.addPeriod(btn)
                }
            },
            'periodsgrid button[itemId=btnEditPeriod]': {
                click: function(btn) {
                    this.editPeriod(btn, false)
                }
            },
            'periodsgrid button[itemId=btnViewPeriod]': {
                click: function(btn) {
                    this.editPeriod(btn, true)
                }
            },
            'periodsgrid button[itemId=btnDeletePeriod]': {
                click: function(btn) {
                    this.deletePeriod(btn);
                }
            },
            'addperiodformWindow form[itemId=addPeriodForm] button[itemId=btnSaveAddPeriodForm]': {
                click: function(button) {
                    this.saveAddPeriod(button)
                }
            },
            'addperiodformWindow form[itemId=addPeriodForm] button[itemId=btnCancelAddPeriodForm]': {
                click: this.cancelAddPeriod
            },
            'scholarshipmastersearchform form[itemId=scholarshipMaster] customcombobox[itemId=scholMaster_scholId]' : {
            	afterrender : function(combo) {
            		var form=this.getScholarshipMasterForm();
            		var alField = form.down('#academyLocationCombo')
            		var store = combo.getStore();
            		store.on('beforeload',function() {
            			var academyLocationIds = null;
            			var multiselectAcademyLocation=alField.getValue();
            			var ALsId = [];
            			for(var i in multiselectAcademyLocation){
            				if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
            					ALsId.push(multiselectAcademyLocation[i].data.id);
            				}else{
            					ALsId.push(multiselectAcademyLocation[i]);
            				}
            			}
            			store.getProxy().extraParams = {
            				academyLocationIds: ALsId.join()
            			};
            		}, this);
            	}
    		   },
            'scholarshipmastersearchform form[itemId=scholarshipMaster] textfield[itemId=scholMaster_scholId]': {
                change: this.disableOtherFilter
            },
            'scholarshipmastersearchform form[itemId=scholarshipMaster] textfield[itemId=scholMaster_scholName]': {
                change: this.disableOtherFilter
            },
            'scholarshipmastersearchform form[itemId=scholarshipMaster] combo[itemId=scholMaster_organisation]': {
                change: this.disableOtherFilter
            },
            'scholarshipmastersearchform form[itemId=scholarshipMaster] button[itemId=ScholarshipMasterResetBtn]': {
                click: function(obj){
                	//this.resetFacultySearchForm();
                	var this$ = this;
                	var searchFormRef = this$.getScholarshipMasterForm();
                	var fnpALId = this.getScholarshipMasterForm().down('#academyLocationCombo');
                	this.suspendALEventSchlMaster=true;
                	searchFormRef.getForm().reset();
                	this.suspendALEventSchlMaster=false;
                	var scholarshipCategory = this.getScholarshipMasterForm().down('#scholarship_category'); 
                	scholarshipCategory.getStore().getProxy().extraParams= {                			
                		scholarshipId: null,
                	}
                    scholarshipCategory.getStore().load(); 
                	searchFormRef.down("#scholMaster_scholId").setDisabled(false);
                    searchFormRef.down("#scholMaster_status").setDisabled(false);
                    searchFormRef.down("#scholMaster_amountType").setDisabled(false);
//                    searchFormRef.down("#scholMaster_scholType").setDisabled(false);
                    //searchFormRef.down("#scholMaster_organisation").setDisabled(false);
                    //searchFormRef.down("#scholMaster_disbursmentMode").setDisabled(false);  
                    
					var store = fnpALId.getStore();
					
					store.load({
						callback: function(records, operation, success) {
							if (success) {
								 fnpALId.select(fnpALId.getStore().collect(fnpALId.valueField));
							}
						}
					});
					
                }
            },
            'addscholarship form[itemId=addscholarshipform] combo[itemId=paymentId]': {
                select: function(combo, records, eOpts) {
                    this.disableValidity(records[0].data.id, combo, this);
                }
            },
           'addscholarship form[itemId=addscholarshipform] textfield#amountId':{
            	change:function(){
            		var addScholarshipForm = this.getAddScholarshipForm();
            		  var amountfield = addScholarshipForm.down("#amountId");
            		  var feeHeadsPanel = addScholarshipForm.down('#feeHeadsPanel')
            		  var  feeHeadPanelLength  = feeHeadsPanel.items.items.length;
            		  if(feeHeadPanelLength >1){
            		      for(var i =1;i< feeHeadPanelLength; i){
            		         feeHeadsPanel.remove(feeHeadsPanel.items.items[i])
            		         if(feeHeadsPanel.items.items.length == 1){
            		        	 feeHeadsPanel.items.items[0].down('#feeAmounts').reset();

                   			       feeHeadsPanel.items.items[0].down('#feeHeads').reset();

                   			  feeHeadsPanel.items.items[0].down('#amountOrPercentage').reset();
                   			  break;
            		         }
            		      }            			
            		  } else{
            			  feeHeadsPanel.items.items[0].down('#feeAmounts').reset();

            			  feeHeadsPanel.items.items[0].down('#feeHeads').reset();

            			  feeHeadsPanel.items.items[0].down('#amountOrPercentage').reset();
            		  }
            	}
            },
            'addscholarship form[itemId=addscholarshipform] combo[itemId=amountTypeId]': {
                change: function(combo, records, eOpts) {
                    //this.disableScholarshipPaymentType(records[0].data.id, this);
                    this.flushPeriodsStoreAndDisableAmount(combo);
                }
            },
            'addscholarship form[itemId=addscholarshipform] combo[itemId=disbursementMode]': {
                change: function(combo, records, eOpts) {
                    this.disableAdjustment(combo.getValue(), this, combo);
                }
            },
            'addscholarship form[itemId=addscholarshipform] combo[itemId=ScholarshipTypeId]': {
                select: function(combo, records, eOpts) {
                    var scholarshipType = records[0].data.id;
                    this.changeMode(scholarshipType, this, combo);
                    var addScholarshipForm = combo.up('panel[xtype=addscholarship]');
                    var organizationCombo = addScholarshipForm.down('#organizationCmb');
                    if (organizationCombo) {
                    	var orgStore = Ext.create('Academia.store.scholarships.Organizations');
                    	organizationCombo.bindStore(orgStore);
                        organizationCombo.getStore().load({
                            params: {
                                organizationType: scholarshipType
                            }
                        });
                    }
                }
            },
            'addscholarship combo': {
                render: this.loadCombo
            },

            /**
             * Listener to listen the changing of the Amount while adding and editing the amount of a Period.
             * from the add period form.
             */
            'addperiodformWindow form[itemId=addPeriodForm] numberfield[itemId=periodAmount]': {
                change: function(component) {
                    this.checkAmount(component);
                }
            },

            /**
             * Listener to listen the changing of the duration while adding and editing the duration of a period.
             * from the add period form.
             */
            'addperiodformWindow form[itemId=addPeriodForm] numberfield[itemId=DurationId]': {
                change: function(component) {
                    this.checkDuration(component);
                }
            },

            'numberofawardeegrid combo[itemId=statusComboId]': {
                select: function(cmb, record, evts) {
                	var contentPanelActiveTab = this.getContentPanelActiveTab();
                    var activeTab =	contentPanelActiveTab.activeTab;
                	if(activeTab.xtype == "advancedsearchquerybuilder")
                		{
                        var searchResultGrid =  activeTab.down('searchresultgrid');
                        var record = searchResultGrid.getSelectionModel().getSelection()[0];
                        var numberOfAwardeeGrid = this.getNumberofAwardeeGrid();
                		}
                	else
                		{
                		var searchResultGrid = this.getSearchResultGrid();
                        var record = searchResultGrid.getSelectionModel().getSelection()[0];
                        var numberOfAwardeeGrid = this.getNumberofAwardeeGrid();
                		}
                    var store = numberOfAwardeeGrid.getStore();
                    if (!isNullOrEmpty(record.get('ID'))) {
                        store.getProxy().extraParams = {
                            'scholarshipId': record.get('ID'),
                            'status': cmb.getValue()
                        };
                        store.load();
                    }
                }
            },
            'scholarshipmaster combo[itemId=ACADAMY]': {
                render: function(cmp) {
                    var academyList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademies();
                    cmp.getStore().loadData(academyList);
                }
            },
            'scholarshipmaster combo[itemId=LOCATION]': {
                render: function(cmp) {
                    var locationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedLocations();
                    cmp.getStore().loadData(locationList);
                }
            },
            'scholarshipmastersearchform combo[itemId=scholMaster_scholType]': {
                render: function(combo) {
                    combo.getStore().load({});
                },
                select: function(combo, records, eOpts) {
                    var scholarshipType = records[0].data.id;
                    var organizationCombo = this.getScholarshipMasterForm().down('#scholMaster_organisation');
                    if (organizationCombo) {
                        organizationCombo.getStore().load({
                            params: {
                                organizationType: scholarshipType
                            }
                        });
                    }
                    if (scholarshipType == 'INT') {
                        var formAddscholarship = combo.up('form');
                        var disbursementModeCombo = formAddscholarship.down('#scholMaster_disbursmentMode');
                        disbursementModeCombo.getStore().load();
                        disbursementModeCombo.setValue('ACD');
                    }
                }

            },
            'scholarshipmastersearchform customcombobox[itemId=scholMaster_scholId]': {
                render: function(combo) {
                    combo.getStore().load({});
                },
                select: function(combo, records, eOpts) {
                	var scholarshipId = records[0].data.id;
                	var scholarshipCategory = this.getScholarshipMasterForm().down('#scholarship_category');                	
                	 if (scholarshipCategory) {
                		 scholarshipCategory.getStore().getProxy().extraParams= {                			
                            	 scholarshipId: scholarshipId,
                		 }
                		 scholarshipCategory.getStore().load();
                     }
                	                 	 
                },                
            },
            'scholarshipmastersearchform customcombobox[itemId=scholMaster_scholId]': {
                render: function(combo) {
                    combo.getStore().load({});
                },
                select: function(combo, records, eOpts) {
                	var scholarshipId = records[0].data.id;
                	var scholarshipCategory = this.getScholarshipMasterForm().down('#scholarship_category');                	
                	 if (scholarshipCategory) {
                		 scholarshipCategory.getStore().getProxy().extraParams= {                			
                            	 scholarshipId: scholarshipId,
                		 }
                		 scholarshipCategory.getStore().load();
                     }
                	                 	 
                },                
            },
            'scholarshipmastersearchform multiselectcombofield[itemId=academyLocationCombo]': {
            	render: function(combo) {
            		//var $this = this;
            		//var form = $this.getScholarshiprequestform();
            		var fnpALId = this.getScholarshipMasterForm().down('#academyLocationCombo');
            		var academyLocationId = this.getCurrentAcademyLocation();

            		combo.getStore().load({

            			callback: function(records, operation, success) {
            				if (success) {
            					/* for(var i in records){
	   								   if(records[i].data.id==academyLocationId){
	   									   fnpALId.setValue(academyLocationId);
	   								   }
	   							   }*/
            					fnpALId.select(fnpALId.getStore().collect(fnpALId.valueField));
            				}
            			}

            		});

            	},
            	change:function(){
            		var form = this.getScholarshipMasterForm();
            		var schl = form.down('#scholMaster_scholId');
            		var schlStore = schl.getStore();
            		if(!this.suspendALEventSchlMaster)
            		 schlStore.load();
            	}
            },

            /***** Export Buttons************/'searchresultgrid[itemId=scholarshipMasterGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
                click: function() {
                    this.exportScholarshipMaster(SERVERURL.PDFEXPORT, 'pdf', false);
                }
            },
            'searchresultgrid[itemId=scholarshipMasterGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
                click: function() {
                    this.exportScholarshipMaster(SERVERURL.PDFEXPORT, 'pdf', true);
                }
            },
            'searchresultgrid[itemId=scholarshipMasterGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
                click: function() {
                    this.exportScholarshipMaster(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', false);
                }
            },
            'searchresultgrid[itemId=scholarshipMasterGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
                click: function() {
                    this.exportScholarshipMaster(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', true);
                }
            },

            'numberofawardeewindow numberofawardeegrid[itemId=NumberOfAwardeeGrid]': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var me = this;
                    var columnsArray = grid.getGridColumns();
                    if (columnsArray[cellIndex].dataIndex === "studentCode") {
                        me.openStudentProfile(grid, td, cellIndex, record, tr, rowIndex, e, eOpts);
                    }
                }
            },

            'associateacademylocationstructure userAcademyLocationCombo': {
                render: function(combo) {
                    combo.load();
                }
            },

            'associateacademylocationstructure grid#associateAcademyLocationGrid': {
                render: function(grid) {
                    this.loadScholarshipALGrid(grid);
                    this.loadALMultiselectCombo(grid);
                }
            },

            'associateacademylocationstructure button#saveScholarshipAcademyLocations': {
                click: function(button) {
                    this.updateScholarshipAcademyLocations(button);
                }
            },
            'associateacademylocationgrid': {
                select: function(selectionModel, record, index) {
                    this.loadProgramsOnSALSelection(selectionModel, record, index);
                }
            },
            'associateacademylocationstructure button#saveScholarshipPrograms': {
                click: function(button) {
                    this.updateScholarshipPrograms(button);
                }
            },
            'associatecoursestructure': {
                activate: function(tab) {
                    this.resetBatchAndCourseCombo();
                    this.loadProgramsGrid(tab);
                }
            },

            'associatedprogramsgrid': {
                select: function(selectionModel, record, index) {
                    this.loadBatchesAndSections(selectionModel, record, index);
                }
            },
            'associatecoursestructure button': {
                click: function(button) {
                    this.updateScholarshipBatchesAndCourses(button);
                }
            },
            'addscholarship customcombobox[itemId=currencyId]': {
            	render: function(combo) {
            		 Ext.Ajax.request({
                         type: 'rest',
                         url: SERVERURL.BASE_CURRENCY_ACADEMY_LOCATION,
                         method: 'GET',
                         params: {
                             academyLocationId : this.getCurrentAcademyLocation()
                         },
                         success: function(res, action) {
                             var data = Ext.decode(res.responseText);
                             combo.setValue(data.id);
                         }
                     });
            	}
            },
            'scholarshipmasterscreen': {
            	afterrender:function(structure){
            		var grid = structure.down('#scholarshipMasterGrid');
            		
            		var searchBtn = structure.down('#ScholarshipMasterSearchBtn')
            		searchBtn.setDisabled(true)
            		this.getCBGridHeaderFreeze(grid,structure);
            	},
            },
            'scholarshiprequestform textfield[itemId=paymentTowardsFees]':{
            	change:function(obj){
            		this.setTotalScholarshipAmount();
            	}
            },
            'scholarshiprequestform textfield[itemId=paymentTowardsLivingExpensesOrAccommodation]':{
            	change:function(obj){
            		this.setTotalScholarshipAmount();
            	}
            },
            'scholarshiprequestform textfield[itemId=Other]':{
            	change:function(obj){
            		this.setTotalScholarshipAmount();
            	}
            },
            'scholarshiprequestform': {
            	afterrender:function(form){
            		/*if(this.scholarshipReqEditSCreen==true){
            			var form =  this.getScholarshiprequestform();
            			form.down('#followUpDetailsScholarshipFormId').setVisible(true);
                		form.down('#submitBtn').setVisible(false);
                		form.down('#resetScholarShipFormBtn').setVisible(false);
                		form.down('#declarationsContainerId').setVisible(false);
                		var followUpRemarksContainerId = form.down('#followUpRemarksContainerId');
                		var itemsArray = new Array();
                		var insertPosition=followUpRemarksContainerId.items.items.length+1;
                		itemsArray.push({
            	        	xtype:'checkbox',
            	        	itemId: 'declaration',
            	        	name:'declaration',
            	        },{
            	        	xtype:'displayfield',
            	        	itemId: 'declarationText',
            	        	name:'declarationText',
            	        	width: 900,
            	        	cls:'declarationFieldCls',
            	        	value:getCommonTranslation('DECLARATION'),
            	        });
                		followUpRemarksContainerId.insert(insertPosition,itemsArray);
                		followUpRemarksContainerId.doLayout();
                		this.scholarshipReqEditSCreen=false;
            		}else{
            			form.down('#rejectBtn').setVisible(false);
                		form.down('#approveBtn').setVisible(false);
                		form.down('#reSubmit').setVisible(false);
            		}*/
            		this.applyDFRForScholarshipRequestForm(form);
            	},
            	validitychange:function(form, valid, eOpts){
            		var $this=this;
            		var form =  this.getScholarshiprequestform();
            		var submitBtn = form.down('#submitBtn');
            		var declarationCheckBox = form.down('#declaration');
            		var declarationFollowUp = form.down('#declarationFollowUp');
            		var declarationExecution = form.down('#executionDeclaration');
            		var checkOtherValidation = $this.checkScholarReqFormValidity();
            		var rejectBtn = form.down('#rejectBtn');
        			var approveBtn = form.down('#approveBtn');
        			var reSubmit = form.down('#reSubmit');
            		if(valid && !declarationCheckBox.getValue() && checkOtherValidation){
            			submitBtn.setDisabled(true);
            		}
            		if(valid  && declarationFollowUp && declarationFollowUp.getValue()){
            			rejectBtn.setDisabled(false);
            			approveBtn.setDisabled(false);
            			reSubmit.setDisabled(false);
            		}else if(valid  && declarationExecution && declarationExecution.getValue()){
            			rejectBtn.setDisabled(false);
            			approveBtn.setDisabled(false);
            			reSubmit.setDisabled(false);
            		}else{
            			rejectBtn.setDisabled(true);
            			approveBtn.setDisabled(true);
            			reSubmit.setDisabled(true);
            		}
            	}
            },
            'scholarshiprequestform checkbox[itemId=declaration]':{
            	change:function(checkbox, newValue, oldValue, eOpts ){
            		this.checkScholarReqFormValidity();
            	}
            },
            'addscholarshiptabform':{
            	afterrender:function(form){
            		this.applyDFRForScholarshipMasterForm(form);
            		  form.down('#cmbStatus').setValue('Active');
            		  form.down('#internalFundAdminId').getStore().load();
            	},
            },
            'scholarshiprequestform checkbox[itemId=declarationFollowUp]':{
            	change:function(checkbox, newValue, oldValue, eOpts ){
            		var form =  this.getScholarshiprequestform();
            		if(newValue){
            			form.down('#reSubmit').setDisabled(false);
            			form.down('#approveBtn').setDisabled(false);
            			form.down('#rejectBtn').setDisabled(false);
            		}else{
            			form.down('#reSubmit').setDisabled(true);
            			form.down('#approveBtn').setDisabled(true);
            			form.down('#rejectBtn').setDisabled(true);
            		}
            	}
            },
            'scholarshiprequestform checkbox[itemId=executionDeclaration]':{
            	change:function(checkbox, newValue, oldValue, eOpts ){
            		var form =  this.getScholarshiprequestform();
            		if(newValue){
            			form.down('#reSubmit').setDisabled(false);
            			form.down('#approveBtn').setDisabled(false);
            			form.down('#rejectBtn').setDisabled(false);
            		}else{
            			form.down('#reSubmit').setDisabled(true);
            			form.down('#approveBtn').setDisabled(true);
            			form.down('#rejectBtn').setDisabled(true);
            		}
            	}
            },
            'scholarshiprequestform customcombobox[itemId=costCentreOrPoetDetails]':{
            	change:function(obj){
            		//if(!this.isFormResetting && (obj.up().items.items.length ==1 || obj.up().items.items.length ==2)){  //do not call this method when change event fire after reseting form
            		if(obj.getValue()){
            			this.showCostCentreOrPoetDetailsFields(obj);
            		} 
            		//}
            	}
            },
            'scholarshiprequestform button[itemId=addMoreRowsBtnId]':{
    			click: function(obj){
    				this.addMultipleRecordForCostCenterOrPOET(obj);
    			}
            },
            'scholarshiprequestform button[itemId=resetScholarShipFormBtn]':{
            	click:function(obj){
            		this.resetScholarshipRequestForm(obj);
            	}
            },
            'scholarshiprequestform radiogroup[itemId=stdUnderstandNoWorkDoneInExchangeOfBursary]':{
            	change:function(radioField, newValue, oldValue, eOpts){
            		this.checkScholarReqFormValidity();
            	}
            },
            'scholarshiprequestform radiogroup[itemId=applicantUnderstandNoWorkDoneInExchangeOfBursary]':{
            	change:function(radioField, newValue, oldValue, eOpts){
            		this.checkScholarReqFormValidity();
            	}
            },
            'scholarshiprequestform customcombobox[itemId=scholarshipId]':{
	           render: function(){
		          var this$ = this;
	              var form =  this$.getScholarshiprequestform();
            	  var scholarshiprstore = form.down('#scholarshipId').getStore();
                  scholarshiprstore.getProxy().extraParams = { activeStatus: true };
	             },

	
            	change:function(){
            		var $this =this;
            		var form =  this.getScholarshiprequestform();
            		var obj = form.down('#scholarshipId');
            		var financialYear = form.down('#financialYear');
            		financialYear.setDisabled(false);
            		var financialYearStore=financialYear.getStore();
            		if(typeof obj.getValue()=='number'){
            			financialYearStore.getProxy().extraParams = {
                			scholarshipId: obj.getValue()
                		};
                		financialYearStore.load();
            		}
            		/*obj.getStore().load({
            			callback:function(records, operation, success) {
            				for(var  i in records){
            					if(records[i].data.id==obj.getValue()){
            						$this.scholarshipAmountPerStd = records[i].data.maxAmountPerStudent
            					}
            				}
            			}
            		});*/
            	},
            	select:function(){
            		var $this =this;
            		var form =  this.getScholarshiprequestform();
            		var financialYear = form.down('#financialYear');
            		financialYear.reset();
            		var obj = form.down('#scholarshipId');
            		obj.getStore().load({
            			callback:function(records, operation, success) {
            				for(var  i in records){
            					if(records[i].data.id==obj.getValue()){
            						$this.scholarshipAmountPerStd = records[i].data.maxAmountPerStudent
            					}
            				}
            			}
            		});
            	}
            },
            'scholarshiprequestform button[itemId=submitBtn]':{
            	click:function(btn){
            		this.saveScholarshipRaiseRequestForm();
            	}
            },
            'scholarshipRequestListGridStudent':{
            	afterrender:function(grid){
            		var me =this;
            		setTimeout(function(){
 	                   me.doAccessControlValidation(grid, me.getSS_SCHOLARSHIP_REQUEST_LIST());
                       me.addDataGridConfigButton(grid,me.getSS_SCHOLARSHIP_REQUEST_LIST());
                       },1500);
            	},
            	
            	cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
            		var $this = this;
            		this.scholarshipReqEditSCreen=true;
            		var currentLoggedInUser = $this.getCurrentlyLoggedInUser().id;
            		var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
            	    var record = grid.getSelectionModel().getSelection()[0];
            	    if(columnName == "requestId"){
            	    	if (e.target.tagName == 'A') {
            	    		if(currentLoggedInUser==1){
            	    			$this.getScholarshipRequestPanel(record.get('requesterType'),record,this.scholarshipReqEditSCreen); 
            	    			$this.loggedInUserRoles='sysadmin';
            	    		}else{
            	    			Ext.Ajax.request({
            	    				method : "GET",
            	    				type : 'rest',
            	    				url: SERVERURL.PATH_FIND_ROLES_BY_USERID_AND_ACADEMYLOCATION_ID,
            	    				params: {
            	    					userId : currentLoggedInUser,
            	    					academyLocationId : $this.getCurrentAcademyLocation()
            	    				},
            	    				headers : {
            	    					'Content-Type' : 'application/json'
            	    				},
            	    				success: function(response) {
            	    					var data = Ext.decode(response.responseText);
            	    					if(data.indexOf('Scholarship Officer')!=-1 || data.indexOf('scholarship officer')!=-1 || data.indexOf('Scholarship officer')!=-1 || data.indexOf('scholarship Officer')!=-1){
            	    						$this.loggedInUserRoles='Scholarship Officer';
            	    					}
            	    					$this.getScholarshipRequestPanel(record.get('requesterType'),record,$this.scholarshipReqEditSCreen); 
            	    				}
            	    			});
            	    		}
            	    	}
            	    }
            	},
            	selectionchange: function(column, selected,eOpts ){

                    var grid = column.view.up('grid');
                    var btnEnable = false;
                    if(selected.length){
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                          if (records[count].get("requestStatus") != "REASSIGNED") {
                        	  btnEnable = true;
                          }
                        }
                        grid.down('#btnDelete').setDisabled(btnEnable);
                    }else{
                    	grid.down('#btnDelete').setDisabled(!btnEnable);
                    }
                
            	}
            },
            'scholarshipRequestListGridStudent button[itemId=btnDelete]':{
            	click:function(btn){
            		var me = this,
            		scholarshipRequestListGrid = me.getScholarshipRequestListGridStudent(),
            		 records = scholarshipRequestListGrid.getSelectionModel().getSelection(),
            		 ids=Ext.Array.pluck(Ext.Array.pluck(records, 'data'), 'id').join();
            		showConfirmMessage(getMegaMenuTranslation('SS_SCHOLARSHIP_REQUEST_LIST'),getCommonTranslation('CANCEL_SELECTED_REQUEST'),function(btn,text){
						 if (btn == 'yes') {
							 Ext.getBody().mask(getCommonTranslation('CANCEL'), 'x-mask-loading');
							 Ext.Ajax.request({
				    				method : "PUT",
				    				type : 'rest',
				    				url: SERVERURL.PATH_REJECT_SCHOLORSHIP_REQUEST_BY_ID+'?id='+ids,
				    				headers : {
				    					'Content-Type' : 'application/json'
				    				},
				    				success: function(response) {
				    					Ext.getBody().unmask();
				    					showSuccessMessage(getMegaMenuTranslation('SS_SCHOLARSHIP_REQUEST_LIST'), getCommonTranslation('CANCEL_SELECTED_REQUEST_SUCCESSFULLY'));
				    					scholarshipRequestListGrid.getStore().removeAll();
				    					scholarshipRequestListGrid.getStore().load();
				    				},
				 		            failure: function(form, action) {
				 		            	Ext.getBody().unmask();
				 		            	btn.setDisabled(false);
				 		            }
				    			});
						 }
						 
            		})
            		
            	}
            },
            'scholarshipRequestListGridApplicant':{
            	afterrender:function(grid){
            		var me =this;
            		setTimeout(function(){
 	                    me.doAccessControlValidation(grid, me.getSS_SCHOLARSHIP_REQUEST_LIST());
                          me.addDataGridConfigButton(grid,me.getSS_SCHOLARSHIP_REQUEST_LIST());
                       },1500);
            	},
            	cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
            		var $this = this;
            		this.scholarshipReqEditSCreen=true;
            		var currentLoggedInUser = $this.getCurrentlyLoggedInUser().id;
            		var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
            	    var record = grid.getSelectionModel().getSelection()[0];
            		if(columnName == "requestId"){
            	    	if (e.target.tagName == 'A') {
            	    		if(currentLoggedInUser==1){
            	    			$this.getScholarshipRequestPanel(record.get('requesterType'),record,this.scholarshipReqEditSCreen); 
            	    			$this.loggedInUserRoles='sysadmin';
            	    		}else{
            	    			Ext.Ajax.request({
            	    				method : "GET",
            	    				type : 'rest',
            	    				url: SERVERURL.PATH_FIND_ROLES_BY_USERID_AND_ACADEMYLOCATION_ID,
            	    				params: {
            	    					userId : currentLoggedInUser,
            	    					academyLocationId : $this.getCurrentAcademyLocation()
            	    				},
            	    				headers : {
            	    					'Content-Type' : 'application/json'
            	    				},
            	    				success: function(response) {
            	    					var data = Ext.decode(response.responseText);
            	    					if(data.indexOf('Scholarship Officer')!=-1 || data.indexOf('scholarship officer')!=-1 || data.indexOf('Scholarship officer')!=-1 || data.indexOf('scholarship Officer')!=-1){
            	    						$this.loggedInUserRoles='Scholarship Officer';
            	    					}
            	    					$this.getScholarshipRequestPanel(record.get('requesterType'),record,$this.scholarshipReqEditSCreen); 
            	    				}
            	    			});
            	    		}

            	    	}
            	    }
            	},
            	selectionchange: function(column, selected,eOpts ){

                    var grid = column.view.up('grid');
                    var btnEnable = false;
                    if(selected.length){
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                          if (records[count].get("requestStatus") != "RESUBMITTED") {
                        	  btnEnable = true;
                          }
                        }
                        grid.down('#btnDelete').setDisabled(btnEnable);
                    }else{
                    	grid.down('#btnDelete').setDisabled(!btnEnable);
                    }
                
            	}
            },
            'scholarshipRequestListGridApplicant button[itemId=btnDelete]':{
            	click:function(btn){
            		btn.setDisabled(true);
            		var me = this,
            		applicantGrid = me.getScholarshipRequestListGridApplicant(),
            		 records = applicantGrid.getSelectionModel().getSelection(),
            		 ids=Ext.Array.pluck(Ext.Array.pluck(records, 'data'), 'id').join();
            		showConfirmMessage(getMegaMenuTranslation('SS_SCHOLARSHIP_REQUEST_LIST'),getCommonTranslation('CANCEL_SELECTED_REQUEST'),function(btn,text){
						 if (btn == 'yes') {
							 Ext.getBody().mask(getCommonTranslation('CANCEL'), 'x-mask-loading');
							 Ext.Ajax.request({
				    				method : "PUT",
				    				type : 'rest',
				    				url: SERVERURL.PATH_REJECT_SCHOLORSHIP_REQUEST_BY_ID+'?id='+ids,
				    				headers : {
				    					'Content-Type' : 'application/json'
				    				},
				    				success: function(response) {
				    					Ext.getBody().unmask();
				    					showSuccessMessage(getMegaMenuTranslation('SS_SCHOLARSHIP_REQUEST_LIST'), getCommonTranslation('CANCEL_SELECTED_REQUEST_SUCCESSFULLY'));
				    					scholarshipRequestListGrid.getStore().removeAll();
				    					scholarshipRequestListGrid.getStore().load();
				    				},
				 		            failure: function(form, action) {
				 		            	Ext.getBody().unmask();
				 		            	btn.setDisabled(false);
				 		            }
				    			});
						 }
						 
            		})
            	}
            },
            'scholarshiprequestform customcombobox[itemId=costCentre]':{
            	select:function(obj, selectedValue){
            		var form =  this.getScholarshiprequestform();
            		var feeHead = obj.nextSibling();
            		var costCentre = form.query('#costCentre');
            		var transactionId =obj.up().down('#transactionId');
            		transactionId.setDisabled(false);
            	    if(this.WhetherDuplicatecostCentreSelected(costCentre)){
            	    	obj.reset();
            	    	return  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DUPLICATE_COST_CENTRE_SELECTED'));
            	    }else{
            	    	obj.getStore().load({
              			  callback:function(records, operation, success) {
              				  for(var  i in records){
              					  if(records[i].data.id==selectedValue[0].data.id){
              						  if(feeHead.itemId=='feeHead'){
              							 feeHead.setValue(records[i].data.feeHeadName);
              						  }
              					  }
              				  }
              			  }
        				});
            	    	transactionId.getStore().proxy.extraParams = {
        	 				costCentreId : selectedValue[0].data.id
        	 			};	
            	    	transactionId.getStore().load({
		     					 callback: function(records, operation, success) {
		     						transactionId.reset()
		     					 }	   
		     				 });
            	    }
            	}
            },
            'scholarshipRequestListSerachForm button[itemId=ScholarshipListSearchBtn]':{
            	click:this.serachScholarshipRequestList
            },
            'scholarshipRequestListSerachForm customcombobox[itemId=requesterType]':{
            	select:function(cmp){
            		var me = this,searchForm = me.getScholarshipRequestListSerachForm();
            		var structure = this.getScholarshipRequestListSerachForm();
            		var grid;
            		
            		if(cmp.getValue() == 'Student'){
            			searchForm.down('#applicantId').reset();
            			searchForm.down('#studentId').setVisible(true);
            			searchForm.down('#stdStatus').setVisible(true);
            			searchForm.down('#applicantId').setVisible(false);
            			me.getScholarshipRequestListGridStudent().setVisible(true);
            			me.getScholarshipRequestListGridApplicant().setVisible(false);
            			me.getScholarshipRequestListGridStudent().getStore().removeAll();
            			grid= me.getScholarshipRequestListGridStudent();
            		}else{
            			me.getScholarshipRequestListGridApplicant().getStore().removeAll();
            			me.getScholarshipRequestListGridApplicant().setVisible(true);
            			me.getScholarshipRequestListGridStudent().setVisible(false);
            			searchForm.down('#studentId').reset();
            			searchForm.down('#applicantId').setVisible(true);
            			searchForm.down('#studentId').setVisible(false);
            			searchForm.down('#stdStatus').setVisible(false);
            			grid= me.getScholarshipRequestListGridApplicant();
            		}
            		grid.getHeader().removeCls('gridFixHeader');
      				grid.dockedItems.items[3].removeCls('gridFixHeader');
      				grid.columnManager.headerCt.removeCls('gridFixHeader');
            		/*var item0 = grid.dockedItems.items[0];
	                var item1 = grid.dockedItems.items[1];
	                var item3 = grid.dockedItems.items[3];
	                item0.removeCls('sticky-header-active-title');
	                item1.removeCls('sticky-header-active-buttons');
	                item3.removeCls('sticky-header-active-columns');
	                item0.addCls('x-docked');
	                item1.addCls('x-docked');
	                item3.addCls('x-docked');*/
            		
            	}
            },
            'scholarshipRequestListSerachForm button[itemId=ClearSearchBtn]':{
            	click:function(cmp){
            		var me = this,searchForm = me.getScholarshipRequestListSerachForm();
            		searchForm.getForm().reset();
            		searchForm.down('#requesterType').fireEvent('select',searchForm.down('#requesterType'));
            		
            	}
            },
            'scholarshiprequestform button[itemId=rejectBtn]':{
    			click: this.rejectScholarshipRequest
            },
            'scholarshiprequestform button[itemId=reSubmit]':{
    			click: this.reSubmitScholarshipRequest
            },
            'scholarshiprequestform button[itemId=approveBtn]':{
    			click: this.approveScholarshipRequest
            },
            'scholarshipRequestListSerachForm':{
            	afterrender:function(cmp){
            		var me = this,
            		loggedInuser= me.getCurrentlyLoggedInUser();
                	if(loggedInuser.id === 1){
                		cmp.down('#requestById').setVisible(true);
					}else{
						cmp.down('#requestById').setVisible(false);
					}
            	}
            },
            
            /*Manage Scholarship*/
            'manageScholarshipStructure':{
	   			 beforerender : function(structure){
	   				 this.showHideSectionTabs(structure, this.getMANAGE_SCHOLARSHIP__PERMISSIONS());
	   			 }, 	               	 
            },
            
            'manageScholarshipStructure tabpanel' : {
            	tabchange : function(tabPanel, newCard, oldCard, eOpts ){
            		var $this = this;
            		var structure=$this.getManageScholarshipStructure();
            		var manageSchlStdGrid = this.getManagescholarshipstudentlistgrid();
            		var manageSchlApplicantGrid = this.getManagescholarshipapplicantlistgrid();
            		var manageSchlFilter = this.getManagescholarshipsearchfilter();
            		if(manageSchlFilter.getForm().isValid()){
            			manageSchlFilter.down('#searchBtnItemID').setDisabled(false);
            		}else{
            			manageSchlFilter.down('#searchBtnItemID').setDisabled(true);
            		}
            		if(manageSchlStdGrid.isVisible()){
            			manageSchlStdGrid.getHeader().removeCls('gridFixHeader');
            			manageSchlStdGrid.dockedItems.items[3].removeCls('gridFixHeader');
            			manageSchlStdGrid.columnManager.headerCt.removeCls('gridFixHeader');
            		}else{
            			manageSchlApplicantGrid.getHeader().removeCls('gridFixHeader');
            			manageSchlApplicantGrid.dockedItems.items[3].removeCls('gridFixHeader');
            			manageSchlApplicantGrid.columnManager.headerCt.removeCls('gridFixHeader');
            		}
            		/*try{
            			var currentStructureBodyHeight = structure.body.getStyles('height').height;
            			structure.body.setStyle('height','100px');
            			structure.scrollBy(0,1);
            			structure.scrollBy(0,-1);
            			structure.body.setStyle('height',currentStructureBodyHeight);
            		}
            		catch(e){
            			structure.scrollBy(0,1);
            			structure.scrollBy(0,-1);
            		}
            		structure.doLayout();*/
            	}
            },
  		   	
	   		'importnominationawardscholarship radiogroup[itemId=importnominationawardItemId]':{
      		  change: function(cb, nv, ov){
      			  var $this = this;
      			  var structure = $this.getContentPanel().getActiveTab();
      			  var uploadTemplateForm = this.getManagescholarshipuploadtemplateform();
      			  var downloadTemplateForm = this.getManagescholarshipdownloadtemplateform();
      			  var downloadButton = downloadTemplateForm.down("#downoladTemplateBtnId")
      			  var uploadDownloadButton  = uploadTemplateForm.down("#uploadTemplateBtnId")
      			  var grid = structure.down('#managescholarshipuploadgridId');
      			  if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
      				  uploadTemplateForm.hide();
      				  downloadTemplateForm.show();
      				  $this.validateForm(downloadTemplateForm, downloadButton);
      				  grid.hide();
      			  }else{
      				  downloadTemplateForm.hide();
      				  uploadTemplateForm.show();
      				  $this.validateForm(uploadTemplateForm, uploadDownloadButton);
      				  uploadTemplateForm.down("#uploadFileField").reset();
      				  grid.show();
      			  }
      		  }
	   		},
	   		
	   		'managescholarshipdownloadtemplateform customcombobox[itemId=applicableForId]':{
  			  render :function(obj){
      			  var $this = this;
      			  var form =obj.up('managescholarshipdownloadtemplateform').getForm();
      			  var combo = form.findField('applicableFor');
      			  combo.getStore().load({
      				  callback: function(records, operation, success) {
      					  for(var i in records){
      						  combo.setValue(records[0].data.id);
      					  }
      				  }	   
      			  });
      		  }
  		  },
  		  
  		'managescholarshipdownloadtemplateform[itemId=managescholarshipdownloadtemplateformId] combo#academyLocationComboId': {
 			change: function(obj, record) {
 				if(obj.getValue().length > 0) {
 					var alids=[];
					var academyLocationIds = null;
					var academyLocationId = obj.getValue();

					if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
						for (var i in academyLocationId) {
							if (Ext.isObject(academyLocationId[0])) {
								alids.push(academyLocationId[i].get("id"));
							} else {
								alids.push(academyLocationId[i]);
							}
						}
						academyLocationIds = alids.join();
					}
					else if(!isNullOrEmpty(academyLocationId)){
						academyLocationIds = academyLocationId;
					}
	 				} else {
	 					var academyLocationIds='';
	 				}
	 				var form = this.getManagescholarshipdownloadtemplateform();
	 				var program = form.down("#programItemId"),
	 				programGroup = form.down("#programGroupItemId");
	 				
	 				programGroup.setDisabled(true);
	 				programGroup.reset();
	 				program.setDisabled(true);
	 				program.reset();

 					var batch = form.down("#batchItemId");
 					batch.setDisabled(true);
 					batch.reset();
	 				if(academyLocationIds != ''){
	 					/*program.setDisabled(false);
	 					programGroup.setDisabled(false);
	 					var store = program.getStore();
	 					store.proxy.extraParams = {
    	 					academyLocationIds : academyLocationIds
    	 			};		                    	 				
	 				store.load();*/
	 			    programGroup.setDisabled(false);
	 				var store = programGroup.getStore();
 					store.proxy.extraParams = {
 						academyLocationIds : academyLocationIds
	 			    };		                    	 				
 				store.load();
 				}
 			}
 		},
 		'managescholarshipdownloadtemplateform[itemId=managescholarshipdownloadtemplateformId] combo#programGroupItemId': {
 			change: function(obj, record) {
 				var form = this.getManagescholarshipdownloadtemplateform(),
 				academyLocationComboId = form.down('#academyLocationComboId'),
 				program = form.down("#programItemId"),
 				programGroup = form.down('#programGroupItemId');
 				if(academyLocationComboId.getValue().length > 0) {
 					var alids=[];
 					var academyLocationIds = null;
 					var academyLocationId = academyLocationComboId.getValue();

 					if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
 						for (var i in academyLocationId) {
 							if (Ext.isObject(academyLocationId[0])) {
 								alids.push(academyLocationId[i].get("id"));
 							} else {
 								alids.push(academyLocationId[i]);
 							}
 						}
 						academyLocationIds = alids.join();
 					}
 					else if(!isNullOrEmpty(academyLocationId)){
 						academyLocationIds = academyLocationId;
 					}
 				} else {
 					var academyLocationIds='';
 				}

 				if(programGroup.getValue().length > 0) {
 					var pgIds=[];
 					var programGroupIds = null;
 					var programGroupId = programGroup.getValue();

 					if (!isNullOrEmpty(programGroupId) && programGroupId.length > 0 && !isNullOrEmpty(programGroupId[0])) {
 						for (var i in programGroupId) {
 							if (Ext.isObject(programGroupId[0])) {
 								pgIds.push(programGroupId[i].get("id"));
 							} else {
 								pgIds.push(programGroupId[i]);
 							}
 						}
 						programGroupIds = pgIds.join();
 					}else if(!isNullOrEmpty(programGroupId)){
 						programGroupIds = programGroupId;
 					}
 				} else {
 					var programGroupIds='';
 				}

 				program.setDisabled(true);
 				program.reset();

 				if(academyLocationIds != '' && programGroupIds!=''){
 					program.setDisabled(false);
 					var store = program.getStore();
 					store.proxy.extraParams = {
 							academyLocationIds : academyLocationIds,
 							programGroupIds:programGroupIds
 					};		                    	 				
 					store.load();
 				}
 			}
 		},
 		'managescholarshipdownloadtemplateform[itemId=managescholarshipdownloadtemplateformId] combo#programItemId': {
// 			render : function(combo){
// 				var $this = this;
// 				var store = Ext.create('Academia.store.common.ProgramAssociatedWithPeriodByAcadLocation');
// 				combo.bindStore(store);
// 				store.load();
// 			},
 			change: function(obj, record) {
 				if(obj.getValue().length > 0) {
 					var progids=[];
					var programIds = null;
					var programId = obj.getValue();

					if (!isNullOrEmpty(programId) && programId.length > 0 && !isNullOrEmpty(programId[0])) {
						for (var i in programId) {
							if (Ext.isObject(programId[0])) {
								progids.push(programId[i].get("id"));
							} else {
								progids.push(programId[i]);
							}
						}
						programIds = progids.join();
					}
					else if(!isNullOrEmpty(programId)){
						programIds = programId;
					 }
 				   } else {
	 				 var programIds='';
 				   }
 				var form = this.getManagescholarshipdownloadtemplateform();
 				var batch = form.down("#batchItemId");
					batch.setDisabled(true);
					batch.reset();
 				if(programIds !=''){
 					batch.setDisabled(false);

 					var store = this.getStore('common.BatchesAssociatedWithPeriodByAcadAndProgram');
 					store.getProxy().extraParams = {
 						programIds: programIds,
 						isActive:true
 					};
 					store.load();
 				}
 			}
 		},  
 		
 		'managescholarshipdownloadtemplateform[itemId=managescholarshipdownloadtemplateformId] combo#batchItemId': {
 			render : function(combo){
// 				var $this = this;
// 				var store = Ext.create('Academia.store.common.BatchesAssociatedWithPeriodByAcadAndProgram');
// 				combo.bindStore(store);
// 				store.load();
 			},
 			change: function(obj, record) {
 				if(obj.getValue().length > 0) {
 					var btchids=[];
 				   var batchIds = null;
 				   var batchId = obj.getValue();

 				   if (!isNullOrEmpty(batchId) && batchId.length > 0 && !isNullOrEmpty(batchId[0])) {
 					   for (var i in batchId) {
 						   if (Ext.isObject(batchId[0])) {
 							   btchids.push(batchId[i].get("id"));
 						   } else {
 							   btchids.push(batchId[i]);
 						   }
 					   }
 					   batchIds = btchids.join();
 				   }
 				   else if(!isNullOrEmpty(batchId)){
 					   batchIds = batchId;
 					}
 				   } else {
 					 var batchIds='';
 				   }
 				var form = this.getManagescholarshipdownloadtemplateform();
 				var batch = form.down("#periodItemId");
 				   batch.setDisabled(true);
 				   batch.reset();
 				if(batchIds !=''){
 					batch.setDisabled(false);
 					var store = this.getStore('coursetransaction.sectioncoursecoverageplan.mastertimetable.ParameterizedPeriodByBatch');
 					store.getProxy().extraParams = {
 						batchIds: batchIds,
 						isActive:true
 					};
 					store.load();
 				}
 			}
 		},  
  		  
 		'managescholarshipdownloadtemplateform button[itemId=downoladTemplateBtnId]':{ 
 			click:function(obj){
	                 var $this = this;
	                 var form =obj.up('managescholarshipdownloadtemplateform').getForm();
	                 var values = form.getValues();
		
				     
	                 if(values.academyLocation.length > 0){
						var academyLocationIds=[]
	                    for(var i in values.academyLocation){   
							if(values.academyLocation[i] !== ""){
								academyLocationIds.push(values.academyLocation[i].data.id)
							}
						}
						var academyLocationId = academyLocationIds.join();
	                 }
			 				
	                 if(!isNullOrEmpty(values.accountingYear)){
		                         var accountingYearId = values.accountingYear;
		                 }
	                 
	                 if(!isNullOrEmpty(values.applicableFor)){
	                         var applicableForId = values.applicableFor;
	                 }
	                 
	                 if(!isNullOrEmpty(values.templateFor)){
	                         var templateForId = values.templateFor;
		                 }
	                 
	                 if(!isNullOrEmpty(values.scholarshipCategory)){
		                         var scholarshipCategoryId = values.scholarshipCategory;
		                 }
	                 
	                 if(!isNullOrEmpty(values.programName) && values.programName.length > 0){
						var programId=[]
	                    for(var i in values.programName){   
								if(values.programName[i] !== ""){
//						                        var programNameId = Ext.Array.pluck(Ext.Array.pluck(values.programName[i], 'data'), 'id').join();
									programId.push(values.programName[i].data.id)
								}
							}
							var programNameId = programId.join();
	                 }
	                 
	                 if(!isNullOrEmpty(values.batchName) && values.batchName && values.batchName.length > 0){
	 					var batchId = []
						for(var i in values.batchName){   
							if(values.batchName[i] !== ""){
								batchId.push(values.batchName[i].data.id)
							}
						}
	 					var batchNameId = batchId.join();
	                 }else {
						var batchNameId = null;
					 }
	                 
	                 if(!isNullOrEmpty(values.periodName) && values.periodName.length > 0){
						var periodId =[];

						for(var i in values.periodName){   
							if(values.periodName[i] !== ""){
								periodId.push(values.periodName[i].data.id)
							}
						}
	 					var periodNameId = periodId.join;
	                 }else {
						var periodNameId = null; 
					 }
	
	                var templateType=templateForId;
					var jsonData = new Object();
	 				 jsonData.academyLocationId =academyLocationId;
		             jsonData.accountingYear=accountingYearId;
		             jsonData.applicableFor=applicableForId;
		             jsonData.scholarshipCategory=scholarshipCategoryId;
		             jsonData.programId=programNameId;
		             jsonData.batchId=batchNameId;
		             jsonData.periodId=periodNameId;
					 var jsonObject = {
					    templateType:templateForId,
						scholarshipNomination:jsonData
					}
	                var csvForm = Ext.create('Ext.form.Panel', {
				  	 		            items: [{
				  	 		                xtype: 'textfield',
				  	 		                maxLength: 20480,
				  	 		                itemId: 'exportListDTO',
				  	 		                name: 'exportListDTO',
				  	 		                vtype: 'spaceAsInput'
				  	 		            }]
				  	 		        });
	 				 csvForm.down('#exportListDTO').setValue(Ext.encode(jsonObject));
		 		        csvForm.getForm().submit({
		 		            target: '_blank',
		 		            method: 'POST',
		 		            params: {
		 		                access_token: Ext.Ajax.defaultHeaders.access_token
		 		            },
		 		            headers: {
		 		                'Authorization': Ext.Ajax.defaultHeaders.Authorization
		 		            },
		 		            url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_SCHOLARSHIP_NOMINATION,
		 		            standardSubmit: true,
		 		            success: function(form, action) {
		 		                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
		 		            },
		 		            failure: function(form, action) {
		 		                showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
		 		            }
		 		        });
	             }  },
 		
	   		
	   		'managescholarshipdownloadtemplateform button[itemId=resetBtn]':{
                click:function(obj){
               	     var form = this.getManagescholarshipdownloadtemplateform();
               	     var academyLocation = form.down("#academyLocationComboId");
               	     academyLocation.clearValue();
               	     academyLocation.reset();
               	     var accountingYear = form.down("#accountingYearId");
               	     accountingYear.clearValue();
           	  		 accountingYear.reset();
               	     var applicableFor = form.down("#applicableForId");
	               	 applicableFor.getStore().load({
	      				  callback: function(records, operation, success) {
	      					  for(var i in records){
	      						applicableFor.setValue(records[0].data.id);
	      					  }
	      				  }
	               	 })
               	     var templateFor = form.down("#templateForId");
	               	 templateFor.clearValue();
	               	 templateFor.reset();
               	     var scholarshipCategory = form.down("#scholarshipCategoryId");
               	     scholarshipCategory.clearValue();
               	  	 scholarshipCategory.reset();
               	     var program = form.down("#programItemId");
               	     program.clearValue();
               	     program.reset();
               	     var batch = form.down("#batchItemId");
               	     batch.clearValue();
               	     batch.reset();
               	     batch.setDisabled(true);
               	     var period = form.down("#periodItemId");
               	     period.clearValue();
               	     period.reset();
            	     period.setDisabled(true);
						
            	}
             },
             
             'managescholarshipuploadtemplateform customcombobox[itemId=applicableForId]':{
     			  render :function(obj){
         			  var $this = this;
         			  var form =obj.up('managescholarshipuploadtemplateform').getForm();
         			  var combo = form.findField('applicableFor');
         			  combo.getStore().load({
         				  callback: function(records, operation, success) {
         					  for(var i in records){
         						  combo.setValue(records[0].data.id);
         					  }
         				  }	   
         			  });
//         			 var combo1 = form.findField('importUtilityMasterId');
//         			  combo1.getStore().load({
//         				  callback: function(records, operation, success) {
//         					  for(var i in records){
//         						  if(records[i].data.value=='Bulk Nomination Applicant' && obj.getValue()=='APPLICANT'){
//         							combo1.setValue(records[i].data.id);
//         						  }else  if(records[i].data.value=='Bulk Nomination Student' && obj.getValue()=='STUDENT'){
//         							combo1.setValue(records[i].data.id);
//         						  }
//         					  }
//         				  }	   
//         			  });
         		  },
         		 select:function(obj,record){
       			  var $this = this;
       			 var form =$this.getManagescholarshipuploadtemplateform();
       			  var combo1 = form.down('#moduleName');
       			var templateFor = form.down('#templateForId');
       			combo1.reset();
       			combo1.clearValue();
       			templateFor.reset();
       			templateFor.clearValue();
       			 
       			var grid = $this.getManagescholarshipuploadgrid();
		      	   var store =  grid.getStore();
		      	   this.resetPageSetting(store);
		      	   var moduleName = null;
		      	   if(obj.getValue()=='APPLICANT'){
		      		 moduleName='Bulk Nomination Applicant';
		      	   }else{
		      		 moduleName='Bulk Nomination Student'
		      	   }
		      	   store.getProxy().extraParams = {
		      		 moduleName:moduleName,
		      		 uploadedBy:$this.getCurrentlyLoggedInUser().id
		      	   };
		      	   store.load();
		         	}
	     		  },
	     		  
	     		  'managescholarshipuploadtemplateform customcombobox[itemId=templateForId]':{
	     			  select:function(obj,record){
	     				  var $this = this;
	     				  var moduleName= null;
	     				  var form =$this.getManagescholarshipuploadtemplateform();
	     				  var applicableFor = form.down('#applicableForId').getValue();
	     				  var templateFor= obj.getValue();

	     				  var combo1 = form.down('#moduleName');
	     				  combo1.getStore().load({
	     					  callback: function(records, operation, success) {
	     						  for(var i in records){
	     							  if(records[i].data.value=='Bulk Award Applicant' && applicableFor == 'APPLICANT' && templateFor=='AWARD'){
	     								  combo1.setValue(records[i].data.id);
	     								 moduleName='Bulk Award Applicant';
	     							  }else  if(records[i].data.value=='Bulk Award Student' && applicableFor == 'STUDENT' && templateFor=='AWARD'){
	     								  combo1.setValue(records[i].data.id);
	     								 moduleName='Bulk Award Student';
	     							  } else  if(records[i].data.value=='Bulk Nomination Applicant' && applicableFor == 'APPLICANT' && templateFor=='NOMINATION'){
	     								  combo1.setValue(records[i].data.id);
	     								 moduleName='Bulk Nomination Applicant';
	     							  }else  if(records[i].data.value=='Bulk Nomination Student' && applicableFor == 'STUDENT' && templateFor=='NOMINATION'){
	     								  combo1.setValue(records[i].data.id);
	     								 moduleName='Bulk Nomination Student';
	     							  }
	     						  }
	     						 var grid = $this.getManagescholarshipuploadgrid();
	     		  		      	   var store =  grid.getStore();
	     		  		      	$this.resetPageSetting(store);
	     		  		      	   store.getProxy().extraParams = {
	     		  		      		 moduleName:moduleName,
	     		  		      		 uploadedBy:$this.getCurrentlyLoggedInUser().id
	     		  		      	   };
	     		  		      	   store.load();
	     					  }	   
	     				  });
	     				 

	     			  }
	     		  },
	     		  
             'managescholarshipuploadtemplateform button[itemId=resetBtn]':{
                 click:function(obj){

        			 var $this = this;
        			 var form = this.getManagescholarshipuploadtemplateform();
        			 var uploadField = form.down("#uploadFileField");
        			 uploadField.reset();
        			 var applicableFor = form.down("#applicableForId");
        	 		 applicableFor.getStore().load({
      				   callback: function(records, operation, success) {
      					  for(var i in records){
      						applicableFor.setValue(records[0].data.id);
      					  }
      				   }
        	 		 })
        	 		 var templateFor = form.down("#templateForId");
 	               	 templateFor.clearValue();
 	               	 templateFor.reset();
 	               	 var combo1 = form.down('#moduleName');
	      			  combo1.getStore().load({
	      				  callback: function(records, operation, success) {
	      					  for(var i in records){
	      						  if(records[i].data.value=='Bulk Nomination Applicant' && applicableFor.getValue()=='APPLICANT'){
	      							combo1.setValue(records[i].data.id);
	      						  }else  if(records[i].data.value=='Bulk Nomination Student' && applicableFor.getValue()=='STUDENT'){
	      							combo1.setValue(records[i].data.id);
	      						  }
	      					  }
	      				  }	   
	      			  });
             	}
              
             },
             
             'managescholarshipuploadtemplateform button[itemId=uploadTemplateBtnId]': {

	        		click:function(obj){
	        			var $this=this;
	    	        	var grid = $this.getManagescholarshipuploadgrid();
	    	        	var form=$this.getManagescholarshipuploadtemplateform();
	    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	        	$this.getHashOfFile(form);
			        	setTimeout(function() {
		    	        	form.getForm().submit({
		    	        		method : 'POST',
		    	        		url : submitUrl,
		    	        		success : function(form, action){
		    	        			showSuccessMessage(getCommonTranslation('IMPORT_NOMINATION_AWARD') ,getCommonTranslation('SUCCESS'));
		    	        			form.isValid();
		    	    	        },
		    	        		failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		    	    	        }
		    	        	});
			        	},1000);
	    	        	
	    	        	Ext.defer(function() {
	    	        		var form=this.getManagescholarshipuploadtemplateform();
	    	        		var templateType= form.down('#applicableForId').getValue();
	    	        		var templateFor= form.down('#templateForId').getValue();
		    	        	var templateName;
		    	        	if((templateType=='Applicant' || templateType=='APPLICANT') && (templateFor=='Award' || templateFor=='AWARD')){
		    	        		templateName='Bulk Award Applicant';
		    	        	}
		    	        	else if((templateType=='Student' || templateType=='STUDENT') && (templateFor=='Award' || templateFor=='AWARD')){
		    	        		templateName='Bulk Award Student';
		    	        	}
		    	        	else if((templateType=='Applicant' || templateType=='APPLICANT') && (templateFor=='Nomination' || templateFor=='NOMINATION')){
		    	        		templateName='Bulk Nomination Applicant';
		    	        	}
		    	        	else{
		    	        		templateName='Bulk Nomination Student';
		    	        	}
	    	        		var form =this.getUploadoptionradiogroup();
	    	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
	    	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, templateName);
	    	        	}, 2000, this);
	        		}  
	        	  
             },
             
             'managescholarshipuploadtemplateform uploadoptionradiogroup[itemId=selectiontransferUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
 	   			change: function( radioGroup, newValue, oldValue, eOpts){
 	  		   		var grid = this.getManagescholarshipuploadgrid();
 	  		        var form=this.getManagescholarshipuploadtemplateform();
 					
 					var forms =this.getUploadoptionradiogroup();
 					var isUploadAll =forms.items.items[0].getValue().isUploadAll;
 					
 					var templateType= form.down('#applicableForId').getValue();
    	        	var templateName;
    	        	if(templateType=='Applicant' || templateType=='APPLICANT'){
    	        		templateName='Bulk Nomination Applicant';
    	        	}else{
    	        		templateName='Bulk Nomination Student';
    	        	}
 					
 	  		   		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, templateName);
 	   			}   
 	   		},
             
             'managescholarshipuploadgrid':{
     		     render : function(obj){
    				var $this = this;
    				var grid = $this.getManagescholarshipuploadgrid();
    				var uploadForm=$this.getManagescholarshipuploadtemplateform();
    	        	var templateType= uploadForm.down('#applicableForId').getValue();
    	        	var templateName;
    	        	if(templateType=='Applicant' || templateType=='APPLICANT'){
    	        		templateName='Bulk Nomination Applicant';
    	        	}else{
    	        		templateName='Bulk Nomination Student';
    	        	}
    				var form =this.getUploadoptionradiogroup();
	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid,templateName);
    			  },
    			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
      				if (e.target.tagName == 'A') {
      					var fileType=null;
      					if(cellIndex==1){
      						fileType='successFile';
      					}else if(cellIndex==6){
      						fileType='errorFile';
      					}else if(cellIndex==7){
      						fileType='logFile';
      					}
      					var documentId = record.get("id");
      					if (!isNullOrEmpty(documentId)) {
      						this.getDownloadFile(documentId,fileType);
      					}
      				}
      			}
     		},
     		
     		'managescholarshipuploadgrid button[itemId=btnForce]':{
    			click: function(obj) {
 	            	var grid = this.getManagescholarshipuploadgrid();
 	            	if (grid.getSelectionModel().getCount() > 0) {
 	            		if(grid.getSelectionModel().getCount() > 1){
 		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
 		        		}else{
 		        			var this$ = this;
    	                	var id = grid.getSelectionModel().selectionStart.data.id;
    	                	console.log(id);
    	                	var urlAppend="?jobName="+id;
    	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
    	    	        	Ext.Ajax.request({
    	    	        		url: submitURL,
    	    	        		method: 'GET',
    	    	        		success: function(response) {
    	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
    	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
    	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
    	    	        				//console.log("Manual trigger hit");
    	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
    	    	        			}else if(response.responseText==="SUCCESS"){
    	    	        				//console.log("Manual trigger hit");
        	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    	    	        			}
    	    	        		}
    	    	        	});
 		        		}
 	            	} else {
 	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 	            	}  
 	            }
     		},
     		'spscholarshipacceptform':{
     			afterrender:function(form){
     				var portalId = this.getCurrentLoggedPortalId();
     				var activeTab = this.getActiveTabfromContentPanel();
     				var $this = this;
     				var selectedRecord;
     				var grid;
     				var data;
     				if(portalId == 1) {
     					form.down('#submitBtn').setVisible(false);
     					form.down('#actionSubmitBtn').setVisible(false);
     					form.down('#actionSubmitBtn').setVisible(true);
     					this.getButtonPermission();
     					var docGridCerp = activeTab.down('listofonlinedocumentscerpgrid');
     					var docGrid = activeTab.down('listofonlinedocumentsgrid');
     					docGrid.setVisible(false);
     					docGridCerp.setVisible(true);
     					if(this.isStudent == true) {
     						grid = this.getManagescholarshipstudentlistgrid();     						
     					}else { 
     						grid = this.getManagescholarshipapplicantlistgrid();
     					}
     					selectedRecord = grid.getSelectionModel().getSelection()[0].data;
     					data = {
         						scholarshipId:selectedRecord.scholarshipId,
         						scholarshipAppNumber:selectedRecord.scholarshipApplicationID,
         						scholarshipNominationId:selectedRecord.id,
         						isStudent:$this.isStudent
         				};
						if(selectedRecord.status != 'ACCEPTANCE_PENDING' && selectedRecord.status != 'DOCUMENT_RE_SUBMISSION'){
							Ext.defer(function(){
								form.down('#actionSubmitBtn').setVisible(false);
								form.down('#declineScholarShipBtnAdmin').setVisible(false);
							},200);
							
						}
						 
     				}else {	
     					form.down('#actionSubmitBtn').setVisible(true);
     					form.down('#actionSubmitBtn').setVisible(false);
     					
     				    if(portalId == 3) {
     						form.down('#declineScholarShipBtnAdmin').setVisible(false);
     						form.down('#declineScholarShipBtn').setVisible(true);
						}
     					grid = this.getSpscholarshiplistgrid();
     					selectedRecord = grid.getSelectionModel().getSelection()[0].data;
	     				data = {
	     						scholarshipId:selectedRecord.scholarshipId,
	     						scholarshipAppNumber:selectedRecord.scholarshipApplicationNo,
	     						scholarshipNominationId:selectedRecord.scholarshipNominationId,
	     						isStudent:$this.isStudent
	     				};
	     				 
     				}
     				
     				this.stdSchlData.push(data);
     			}
     		},
     		'spscholarshiplistgrid':{
     			render:function(){
     				var loggedInUser = this.getCurrentlyLoggedInUser();
     				var grid = this.getSpscholarshiplistgrid();
     				var store = grid.getStore();
     				store.getProxy().extraParams = {
     					studentId:loggedInUser.id
     				};
     				store.load();
     			},
     			afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getSP_SCHOLARSHIP_LIST_PERMISSIONS());
					},1500);
				},
     			cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
     				 var selectedRecord = grid.getSelectionModel().getSelection()[0].data;
     				 if (e.target.tagName == 'BUTTON') {
     					 if (e.target.className == "firstButtonClsInGridRow") {
     						 var structure = Ext.widget('spscholarshipacceptform');
     						 var tabName = record.data.scholarshipApplicationNo;
     						 var getcontroller=this.getController('menu.CoreERPNavigationController');
     						 var getAddTab = getcontroller.getTab(record.data.scholarshipApplicationNo);
     						 if (getAddTab != null) {
     							 contentPanel.remove(getAddTab, true);
     						 }
     						 if (this.getCurrentLoggedPortalId() == 3){
     							this.isStudent= true;
     						 }
     						 openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);
     						structure.down('#scholarshipAppNumber').setValue(selectedRecord.scholarshipApplicationNo);
     						structure.down('#scholarshipIdName').setValue(selectedRecord.scholarshipCode+'/'+selectedRecord.scholarshipName);
     						structure.down('#accountingYear').setValue(selectedRecord.accountingYear);
     						structure.down('#programId').setValue(selectedRecord.programName);
     						structure.down('#batchId').setValue(selectedRecord.batchName);
     						structure.down('#amountId').setValue(selectedRecord.amount);
     					 }
     					 if (e.target.className == "secondButtonClsInGridRow") {
     						 showConfirmMessage(getCommonTranslation('SCHOLARSHIP_DECLINE'),getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_DECLINE_THE_SELECTED_SCHOLARSHIP'),function(btn,text){
     							 if (btn == 'yes') {
     								 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     								 var records = grid.getSelectionModel().getSelection();
     								 var schlNominationId = records[0].get("scholarshipNominationId");
     								 var jsonData={
     										   "id" : schlNominationId,
     										   "code":null,
     										   "status":"DECLINED"
     								 };
     								Ext.Ajax.request({
     									method : 'POST',
     									jsonData : jsonData,
     									type : 'rest',
     									url : SERVERURL.PATH_UPDATE_STATUS_NOMINATION,
     									headers : {
     										'Content-Type' : 'application/json'
     									},
     									success : function(form,action) {
     										Ext.getBody().unmask();
     										grid.getStore().reload();
     										showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_DECLINED_SUCCESSFULLY'));
     									}
     								});
     							 }
     						 });
     					 }
     				 }
     			}
     		},
     		'spscholarshipacceptform button[itemId=declineScholarShipBtn]':{
     			click:function(){
     				if(portalId == '1'){
     					this.declineScholarshipBehalfStudent()
     				}else{

         				var $this = this;
         				var grid = $this.getSpscholarshiplistgrid();
         				showConfirmMessage(getCommonTranslation('SCHOLARSHIP_DECLINE'),getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_DECLINE_THE_SELECTED_SCHOLARSHIP'),function(btn,text){
    						 if (btn == 'yes') {
    							 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    							// to get the data of current open tab
    			     				var scholarshipNominationId;
    			     			    Ext.each($this.stdSchlData,function(data){
    			     			    	if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
    			     			    		scholarshipNominationId= data.scholarshipNominationId;
    			     			    		return false;
    			     			    	}
    			     			    });
    							 var jsonData={
    									   "id" : scholarshipNominationId,
    									   "code":null,
    									   "status":"DECLINED"
    							 };
    							Ext.Ajax.request({
    								method : 'POST',
    								jsonData : jsonData,
    								type : 'rest',
    								url : SERVERURL.PATH_UPDATE_STATUS_NOMINATION,
    								headers : {
    									'Content-Type' : 'application/json'
    								},
    								success : function(form,action) {
    									Ext.getBody().unmask();
    									grid.getStore().reload();
    									grid.getSelectionModel().deselectAll(true);  
    									$this.getContentPanelActiveTab().close();
    									showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_DECLINED_SUCCESSFULLY'));
    								}
    							});
    						 }
    					 });
     				}
     			}
     		},
     		'spscholarshipacceptform button[itemId=submitBtn]':{
     			click:function(){
     				var $this = this;
     				var grid = $this.getSpscholarshiplistgrid();
     				var activeTab = this.getActiveTabfromContentPanel();
     				var onlinedocGrid = activeTab.down('listofonlinedocumentsgrid');
     				var onlinedocGridData = onlinedocGrid.getStore().data.items;
     				var whetherAllMandatoryDocUploaded=true;
     			    Ext.each(onlinedocGridData,function(data){
     			    	if((data.data.documentApplicability=='MANDATORY') && (!data.data.documentStatus || data.data.documentStatus=='RE_SUBMIT')){
     			    		whetherAllMandatoryDocUploaded=false
     			    	}
     			    });
     			    if(whetherAllMandatoryDocUploaded){
     			    	showConfirmMessage(getCommonTranslation('SCHOLARSHIP_ACCEPT'),getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_ACCEPT_THE_SELECTED_SCHOLARSHIP'),function(btn,text){
     			    		if (btn == 'yes') {
     			    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     			    			// to get the data of current open tab
     			    			var scholarshipNominationId;
     			    			Ext.each($this.stdSchlData,function(data){
     			    				if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
     			    					scholarshipNominationId= data.scholarshipNominationId;
     			    					return false;
     			    				}
     			    			});
     			    			var jsonData={
     			    					  "id" : scholarshipNominationId,
     			    					  "code":null,
     			    					  "status":"VERIFICATION_IN_PROGRESS"
     			    			};
     			    			Ext.Ajax.request({
     			    				method : 'POST',
     			    				jsonData : jsonData,
     			    				type : 'rest',
     			    				url : SERVERURL.PATH_UPDATE_STATUS_NOMINATION,
     			    				headers : {
     			    					'Content-Type' : 'application/json'
     			    				},
     			    				success : function(form,action) {
     			    					Ext.getBody().unmask();
     			    					if(form.responseText === '-1'){
     			    						Ext.getBody().unmask();
     			    						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
     			    					}else{
     			    						grid.getStore().reload();
     			    						grid.getSelectionModel().deselectAll(true);  
     			    						$this.getContentPanelActiveTab().close();
     			    						showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_ACCEPTED_SUCCESSFULLY'));
     			    					}
     			    				}
     			    			});
     			    		}
     			    	});
     			    }else{
     			    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_UPLOAD_ALL_MANDATORY_DOCUMENTS'));
     			    }
     			}
     		},
     		'listofonlinedocumentsgrid':{
     			render:function(grid){
     				var $this = this;
     				var store = grid.getStore();
     				var form = this.getSpscholarshipacceptform();
     				
     				// to get the data of current open tab
     				var scholarshipId;
     			    Ext.each($this.stdSchlData,function(data){
     			    	if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
     			    		scholarshipId= data.scholarshipId;
     			    		return false;
     			    	}
     			    });
     				store.getProxy().extraParams = {
     					scholarshipId: scholarshipId,
     					isStudent: $this.isStudent
      				};
     				store.load();
     			},
     			afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getSP_SCHOLARSHIP_DOCUMENTS_LIST_PERMISSIONS());
					},1500);
				},
     			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
     				var activeTab = this.getActiveTabfromContentPanel();
     				var docGrid = activeTab.down('listofonlinedocumentsgrid');
     				var uploadBtn = docGrid.down('#uploadBtn');
     				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				if (e.target.tagName == 'A') {
    					if(columnName=="uploadFileName"){
    						var documentId = record.data.encryptedDocIdUpload;
        					if (!isNullOrEmpty(documentId)) {
        						this.getDownloadSchlDocs(documentId);
        					}
    					}
    					if(columnName=="downloadFileName"){
    						var documentId = record.data.encryptedDocIdDownload;
        					if (!isNullOrEmpty(documentId)) {
        						this.getDownloadSchlDocs(documentId);
        					}
    					}
    					if(grid.ownerCt.columnManager.columns[cellIndex].itemId=="uplodaDoc"){
    						if (record.data.isAllowUplaod) {
        						this.uploadOnlineDocumnetStudent();
        					}
    					}
    				}
    			}  
     		},
     		'listofonlinedocumentscerpgrid':{
     			render:function(grid){
     				var $this = this;
     				var store = grid.getStore();
     				var form = this.getSpscholarshipacceptform();
     				this.doAccessControlValidation(grid, $this.getSS_MANAGE_SCHOLARSHIP_DOCUMENTS_LIST_PERMISSIONS());
     				var associatedAcadLocationIds = new Array();
     				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
     				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,$this.getSS_MANAGE_SCHOLARSHIP_DOCUMENTS_LIST_PERMISSIONS());
     				grid.down('#uploadBtn').setVisible(false);
     				 Ext.each(permissionList, function(privilege) {
     					       if (privilege === "UPLOAD_DOCUMENT") {
     						           grid.down('#uploadBtn').setVisible(true);
     						   }
     				});
     				// to get the data of current open tab
     				var scholarshipId;
     				var scholarshipNominationId;
     				Ext.each($this.stdSchlData,function(data){
     					if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
     						scholarshipId= data.scholarshipId;
     						scholarshipNominationId= data.scholarshipNominationId;
     						return false;
     					}
     				});
     				store.getProxy().extraParams = {
     					scholarshipId: scholarshipId,
     					scholarshipNominateId:scholarshipNominationId,
     					isStudent:this.isStudent
     				};
     				store.load();
     			},
     			afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getSS_MANAGE_SCHOLARSHIP_DOCUMENTS_LIST_PERMISSIONS());
					},1500);
					var form = grid.up('spscholarshipacceptform');
					var gridStore = grid.getStore();
					gridStore.on('refresh', function() {
						var whetherSaveEnable = true;
						for(var i = 0; i < gridStore.data.items.length; i++) {
							if(gridStore.data.items[i].get('documentApplicability') == 'MANDATORY' && isNullOrEmpty(gridStore.data.items[i].get('documentStatus'))) {
								whetherSaveEnable = false;
								break;
							}
						}
						Ext.defer(function() {
							if(form.down('#saveBtnCerp') && form.getForm().isValid()) {
								form.down('#saveBtnCerp').setDisabled(!whetherSaveEnable);
							}
							else if(form.down('#saveBtnCerp') && gridStore.data.items.length == 0) {
								form.down('#saveBtnCerp').setDisabled(true);
							}
						}, 251);
					});
				},
     			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
     				var activeTab = this.getActiveTabfromContentPanel();
     				var docGrid = activeTab.down('listofonlinedocumentscerpgrid');
     				var uploadBtn = docGrid.down('#uploadBtn');
     				var editBtn = docGrid.down('#btnEdit');
     				editBtn.setDisabled(true);
     				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
     				if(record.data.documentStatus =='SUBMITTED'){
     					uploadBtn.setDisabled(true);
     					editBtn.setDisabled(false);
     				}else{
     					editBtn.setDisabled(true);
     					uploadBtn.setDisabled(false);
     					if(record.data.documentStatus == 'VERIFIED'){
         					uploadBtn.setDisabled(true);
     					}
     				}
     				if(!record.data.isAllowUplaod){
     					uploadBtn.setDisabled(true);
     				}else{
     					uploadBtn.setDisabled(false);
     				}
    				if (e.target.tagName == 'A') {
    					if(columnName=="uploadFileName"){
    						var documentId = record.data.encryptedDocIdUpload;
        					if (!isNullOrEmpty(documentId)) {
        						this.getDownloadSchlDocs(documentId);
        					}
    					}
    					if(columnName=="downloadFileName"){
    						var documentId = record.data.encryptedDocIdDownload;
        					if (!isNullOrEmpty(documentId)) {
        						this.getDownloadSchlDocs(documentId);
        					}
    					}
    				}
    			}  
     		},
     		'listofonlinedocumentsgrid button[itemId=uploadBtn]':{
            	click: function(obj) {
            		var activeTab = this.getActiveTabfromContentPanel();
            		var listOfOnlineDocGrid = activeTab.down('listofonlinedocumentsgrid');
            		if (listOfOnlineDocGrid.getSelectionModel().getCount() > 0) {
            			var selectedRecord = listOfOnlineDocGrid.getSelectionModel().getSelection()[0].data;
            			var frmWin = this.getSchldocumentdetailswin();
            			if(!frmWin){
            				Ext.widget('schldocumentdetailswin');
            				frmWin = this.getSchldocumentdetailswin();
            			}
            			frmWin.show();
            			frmWin.down('#documentName').setValue(selectedRecord.doucumentMasterName);
            			frmWin.down('#submissionDate').setValue(dateRender(new Date()));
            			frmWin.down('#submissionMode').setValue("Online");
            			frmWin.down('#documentStatus').setValue("Submitted");
            		}else {
         			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
         		   }  
            	}
     		}, 
     		'listofonlinedocumentscerpgrid button[itemId=uploadBtn]':{
            	click: function(obj) {
            		var activeTab = this.getActiveTabfromContentPanel();
            		var listOfOnlineDocGrid = activeTab.down('listofonlinedocumentscerpgrid');
            		if (listOfOnlineDocGrid.getSelectionModel().getCount() > 0) {
            			var selectedRecord = listOfOnlineDocGrid.getSelectionModel().getSelection()[0].data;
            			var frmWin = this.getSchldocumentdetailswin();
            			if(!frmWin){
            				Ext.widget('schldocumentdetailswin');
            				frmWin = this.getSchldocumentdetailswin();
            			}
            			frmWin.show();
            			frmWin.down('#documentName').setValue(selectedRecord.doucumentMasterName);
            			frmWin.down('#submissionDate').setValue(dateRender(new Date()));
            			frmWin.down('#submissionMode').setValue("Online");
            			frmWin.down('#documentStatus').setValue("Submitted");
            		}else {
         			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
         		   }  
            	}
     		}, 
     		'schldocumentdetailswin filefield[itemId=selectFileField]' : {
     			change: function(doc, value, eOpts) {
     				value = value.replace('C:\\fakepath\\', '');
     				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
     				doc.setRawValue(newValue);
     				var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
     				if(!isNullOrEmpty(value)){
     					if (extension == "doc" || extension == "docx" || extension == "pdf" || extension=="txt" || extension=="xls"
     						|| extension == "xlsx" || extension == "ppt" || extension=="pptx" || extension == "jpg" || extension=="png") {

     					}else{
     						doc.reset();
     						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('INVALID_FILE_FORMAT'));
     					}
     				}

     			}
     		},
     		'schldocumentdetailswin button[itemId=docSubmitBtn]' : {
     			click: function(obj) {   	 
     				var $this=this;
     					var winform=$this.getSchldocumentdetailswin();
     				var form = this.getSpscholarshipacceptform();
     				var portalId = this.getCurrentLoggedPortalId();
     				var activeTab = this.getActiveTabfromContentPanel();
     				var listOfOnlineDocGrid;
     				if(portalId==1){
     					listOfOnlineDocGrid = activeTab.down('listofonlinedocumentscerpgrid');
     				}else{
     					 listOfOnlineDocGrid = activeTab.down('listofonlinedocumentsgrid');
     				}
     				var selectedRecord = listOfOnlineDocGrid.getSelectionModel().getSelection()[0].data;
     				var isTransient = true;
     				var module = 'scholarship';
     				var entityId ;
     				var entityType = 'nominationalScholarship';
     				$this.applyWindowMask(); 
					var scholarshipNominationId;
                     Ext.each($this.stdSchlData,function(data){
                         if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
                             scholarshipNominationId= data.scholarshipNominationId;
                             return false;
                         }
                     });
     				$this.getController('Academia.controller.document.DocumentController').saveDocumentForm(entityId, module, entityType, 'SCHOLARSHIP', 
     						function(success, response, isCallBackTransient){
     					var document ={
     							//"name":response.name,
     							"path":response.path,
     							"type":'DOCUMENT',
     							"createdBy":$this.getIdValueJson(response.createdBy.id, response.createdBy.value)
     					};
     					var data = {
     							 "scholarshipDocument":{
     								        "id":selectedRecord.id
     								    },
     								    "id":selectedRecord.scholarshipDocumentStudentId,
     								    "scholarshipDocumentName":winform.down('#documentName').getValue(),
     								    "submissionDate":$this.getDateFromDMYdate(winform.down('#submissionDate').getValue(),'y-m-d'),
     								    "submissionMode" : winform.down('#submissionMode').getValue(),
     								    "documentStatus":"SUBMITTED",
     								    "document":document,
										"scholarshipNominateOrAward":{
                                                 "id":scholarshipNominationId
                                             },
                                          "uploadedDocument":selectedRecord.uploadedDocument,
                                          "encryptedDocIdUpload":selectedRecord.encryptedDocIdUpload
     					};
     					Ext.Ajax.request({
     						type : 'rest',
     						url : SERVERURL.PATH_SCHOLARSHIP_DOCUMENT_SAVE,
     						jsonData : data,
     						method : 'POST',
     						success : function(res, action) {
     							if(form.getForm().isValid()){
     								form.down('#saveBtnCerp').setDisabled(false);
								}else{
									form.down('#saveBtnCerp').setDisabled(true);
								}
     							$this.hideWindowMask();
     							listOfOnlineDocGrid.getStore().reload();
     							listOfOnlineDocGrid.getSelectionModel().deselectAll(true);  
     							//showSuccessMessage(getCommonTranslation('DOCUMENT'), getCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
     							winform.close();
     						}
     					});
     					showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DOCUMENT_SUCCESS_ADD_MSG'));
     				}, isTransient);}
     		},
     		 'schldocumentdetailswin button[itemId=cancelBtn]':{
             	click: function(obj) {
             		var frmWin = this.getSchldocumentdetailswin();
 			   		frmWin.close();
             	}
      		},
      		'managescholarshipsearchfilter multiselectcombofield[itemId=academyLocationItemId]': {
      			render: function(obj){
      				var $this = this;
      				var formLayout = $this.getManagescholarshipsearchfilter();
      				var academyLocationId = this.getCurrentAcademyLocation();
      				var multiBrandCampusId = formLayout.down('#academyLocationItemId');
      				var studentId = formLayout.down('#studentId');
      				var applicantId = formLayout.down('#applicantId');
      				studentId.getStore().getProxy().extraParams = {
      					/*allStudents: false,
      					status:true,
      					admissionStatus:true,*/
      					academyLocationIds:academyLocationId
      				};
      				applicantId.getStore().getProxy().extraParams = {
      					academyLocationId:academyLocationId
      				};
      				var ALComboStore = multiBrandCampusId.getStore();
      				ALComboStore.load({
      					callback: function(records, operation, success) {
      						if (success) {
      							multiBrandCampusId.setValue(academyLocationId);
      						}
      					}   
      				});
      			},
      			change:function(cmp,rec){
      				var formLayout = this.getManagescholarshipsearchfilter();
      				var studentId = formLayout.down('#studentId');
      				var multiBrandCampusId = formLayout.down('#academyLocationItemId');
      				var val = multiBrandCampusId.getValue();
      				var applicantId = formLayout.down('#applicantId');
      				studentId.getStore().getProxy().extraParams = {
      					/*allStudents: false,
      					status:true,
      					admissionStatus:true,*/
      					academyLocationIds:val.join()
      				};
      				applicantId.getStore().getProxy().extraParams = {
      					academyLocationId:val.join()
      				};
      			}
      		},
      		'managescholarshipsearchfilter customcombobox[itemId=accountingYear]': {
      			select: function(obj){
      				var $this = this;
      				var formLayout = $this.getManagescholarshipsearchfilter();
      				var accountingYear = formLayout.down('#accountingYear').getValue();
      				var scholarship = formLayout.down('#scholarshipId');
      				scholarship.reset();
      				var scholarshipStore = scholarship.getStore();
      				var scholarshipAppId = formLayout.down('#scholarshipApplicationID');
      				scholarshipAppId.reset();
      				var scholarshipAppIdStore = scholarshipAppId.getStore();
      				scholarship.setDisabled(false);
      				scholarshipAppId.setDisabled(false);
      				scholarshipStore.getProxy().extraParams = {
      					accountingYearId: accountingYear
      				};
      				scholarshipStore.load();
      				scholarshipAppIdStore.getProxy().extraParams = {
      					accountingYearId: accountingYear,
      					scholarshipId:scholarship.getValue()
      				};
      				scholarshipAppIdStore.load();
      			}
      		},
      		'managescholarshipsearchfilter customcombobox[itemId=scholarshipId]': {
      			select: function(obj){
      				var $this = this;
      				var formLayout = $this.getManagescholarshipsearchfilter();
      				var accountingYear = formLayout.down('#accountingYear').getValue();
      				var scholarshipAppId = formLayout.down('#scholarshipApplicationID');
      				scholarshipAppId.reset();
      				var scholarship = formLayout.down('#scholarshipId');
      				var scholarshipAppIdStore = scholarshipAppId.getStore();
      				scholarshipAppId.setDisabled(false);
      				scholarshipAppIdStore.getProxy().extraParams = {
      					accountingYearId: accountingYear,
      					scholarshipId:scholarship.getValue()
      				};
      				scholarshipAppIdStore.load();
      			}
      		},
      		'managescholarshipsearchfilter button[itemId=resetBtnItemId]':{
      			click: function(obj){
      				var formLayout = this.getManagescholarshipsearchfilter();
      				formLayout.getForm().reset();
      				formLayout.down('#scholarshipId').setDisabled(true);
      				formLayout.down('#scholarshipApplicationID').setDisabled(true);
      				var academyLocationId = this.getCurrentAcademyLocation();
      				var multiBrandCampusId = formLayout.down('#academyLocationItemId');
      				var applicantId = formLayout.down('#applicantId');
      				var studentId = formLayout.down('#studentId');
      				applicantId.setVisible(false);
      				studentId.setVisible(true);
      				var ALComboStore = multiBrandCampusId.getStore();
      				ALComboStore.load({
      					callback: function(records, operation, success) {
      						if (success) {
      							multiBrandCampusId.setValue(academyLocationId);
      						}
      					}   
      				});
      			}
      		},
      		
      		
      		
      		'managescholarshipsearchfilter customcombobox[itemId=applicableFor]': {
      			select: function(obj){
      				var grid;
      				var filterForm = this.getManagescholarshipsearchfilter(),
      				applicantId = filterForm.down('#applicantId'),
      				studentId = filterForm.down('#studentId'),
      				stdStatus = filterForm.down('#stdStatus');
      				if(obj.getValue()=='APPLICANT'){
      					applicantId.reset();
      					applicantId.setVisible(true);
      					studentId.setVisible(false);
      					stdStatus.setVisible(false);
      					grid = this.getManagescholarshipapplicantlistgrid();
      					this.getManagescholarshipstudentlistgrid().setVisible(false);
          				this.getManagescholarshipapplicantlistgrid().setVisible(true);
          				this.getManagescholarshipapplicantlistgrid().getStore().removeAll();
      				}else{
      					studentId.reset();
      					studentId.setVisible(true);
      					stdStatus.setVisible(true);
      					applicantId.setVisible(false);
      					grid = this.getManagescholarshipstudentlistgrid();
      					this.getManagescholarshipstudentlistgrid().setVisible(true);
          				this.getManagescholarshipapplicantlistgrid().setVisible(false);
          				this.getManagescholarshipstudentlistgrid().getStore().removeAll();
      				}
      				grid.getHeader().removeCls('gridFixHeader');
      				grid.dockedItems.items[3].removeCls('gridFixHeader');
      				grid.columnManager.headerCt.removeCls('gridFixHeader');
      				if(grid.getStore().getCount()==0){
      					grid.down('custompagingtoolbar').hide();
      				}
      			}
      		},
      		'managescholarshipstudentlistgrid':{
      			render:function(grid){
      				this.doAccessControlValidation(grid,this.getMANAGE_SCHOLARSHIP__PERMISSIONS());
      				this.addDataGridConfigButton(grid,this.getMANAGE_SCHOLARSHIP__PERMISSIONS());
      			},
      			beforerender:function(grid){
      				grid.getStore().clearData();
      			},
      			selectionchange: function(column, selected,eOpts ){	var $this = this;
  				var grid = column.view.up('grid');
  				grid.down('#btnEdit').setDisabled(false);
  				grid.down('#btnView').setDisabled(false);
  				grid.down('#btnDelete').setDisabled(true);
  				if(selected.length > 0) {	
  					grid.down('#btnAdd').setDisabled(true);
  					if(selected.length == 1){	
  						if(selected[0].data.status == "DOCUMENT_RE_SUBMISSION" || selected[0].data.status == "ACCEPTANCE_PENDING"  || selected[0].data.status == "VERIFICATION_IN_PROGRESS" || selected[0].data.status == "NOMINATED"){
  							grid.down('#btnDelete').setDisabled(false);
  							/*var allScholarshipId = []
                        for(var i=0; i< selected.length ;i++){
                            allScholarshipId.push(selected[i].data.id)
                       }
            			$this.ScholarshipAllIds = allScholarshipId*/
  						}else{
  							grid.down('#btnDelete').setDisabled(true);
  						}

  						if(selected[0].data.status =="AWARD_ACTIVATION_PENDING" || selected[0].data.status == "DOCUMENT_RE_SUBMISSION" || selected[0].data.status == "ACCEPTANCE_PENDING"  || selected[0].data.status == "VERIFICATION_IN_PROGRESS" || selected[0].data.status == "NOMINATED" || selected[0].data.status=="DECLINED"){
  							grid.down('#btnEdit').setDisabled(false);
  						}else{
  							grid.down('#btnEdit').setDisabled(true);
  						}
  						if(selected[0].data.status=="SCHOLARSHIP_ACTIVATED" || selected[0].data.status=="AWARD_ACTIVATION_REJECTED") {
  							grid.down('#btnEdit').setDisabled(true)
  							grid.down('#btnDelete').setDisabled(true);
  						}
  					}
  					else if(selected.length > 1){
  						grid.down('#btnEdit').setDisabled(true);
  						grid.down('#btnView').setDisabled(true);
  						$this.ScholarshipAllIds  = [];
  						var isAllPendingSelected = true;
  						var isButtonEnabled = true;
  						var statusForButtonDisable = ["SCHOLARSHIP_ACTIVATED","AWARD_ACTIVATION_REJECTED"];
  						var selectedStatus = []
  						var StatusForButtonVisible = ["ACCEPTANCE_PENDING","NOMINATED","DOCUMENT_RE_SUBMISSION","VERIFICATION_IN_PROGRESS"]
  						for(var i=0; i< selected.length ;i++){
  							selectedStatus.push(selected[i].data.id);
  							if(!Ext.Array.contains(StatusForButtonVisible, selected[i].data.status)){
  								isAllPendingSelected = false;
  							}
  							if(!Ext.Array.contains(statusForButtonDisable, selected[i].data.status)){
  								isButtonEnabled = false;
  							}
  						}
  						$this.AllselectedStatus = selectedStatus
  						if(isAllPendingSelected){
  							grid.down('#btnDelete').setDisabled(false)
  						}
  						else{
  							grid.down('#btnDelete').setDisabled(true)
  						}
  						if(!isButtonEnabled){
  							grid.down('#btnDelete').setDisabled(true);
  						}
  					}
  				}else{
  					grid.down('#btnAdd').setDisabled(false);
  					grid.down('#btnDelete').setDisabled(false);
  				}},
      		},
      		
      	  'managescholarshipstudentlistgrid button[itemId=btnDelete]':{
          	click: function(btn){
      		  var grid = this.getManagescholarshipstudentlistgrid();
    		  if (grid.getSelectionModel().getCount() > 0) {
    			  this.openDeleteConfirmationWindow();
    		  }else{
    			  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    		  }
    	  }
          },
          'managescholarshipapplicantlistgrid button[itemId=btnDelete]':{
        	  click: function(btn){
        		  var grid = this.getManagescholarshipapplicantlistgrid();
        		  if (grid.getSelectionModel().getCount() > 0) {
        			  this.openDeleteConfirmationWindow();
        		  }else{
        			  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        		  }
        	  }
          },
          'scholarshipDeleteConfirmationWindow button[itemId=submitButtonId]':{
        	  click: function(btn){
        		  var $this = this;
        		  var grid;
        		  var form = $this.getScholarshipDeleteConfirmationWindow();
        		  var cancellation = form.down("#cancellationReason").getValue();
        		  var studentGrid = this.getManagescholarshipstudentlistgrid();
        		  var applicantgrid = this.getManagescholarshipapplicantlistgrid();
        		  if(studentGrid.isHidden()){
        			  grid=applicantgrid;
        		  }else{
        			  grid=studentGrid;
        		  }
        		  var records = grid.getSelectionModel().getSelection();
        		  var ids=[];
        		  records.forEach(function(obj){
        			  ids.push(obj.data.id);
        		  });
        		  var recordIds = ids.join(',');
//      		  var scholarshipId = $this.ScholarshipAllIds
//      		  var allSelected = $this.AllselectedStatus
//      		  getAllIdsInNumber = allSelected.join()
        		  /* if(!isNullOrEmpty($this.ScholarshipAllIds) && $this.ScholarshipAllIds.length > 0){
                    	 ids = $this.ScholarshipAllIds.join()
                     }else{
                    	 ids = $this.AllselectedStatus.join();
                    }*/
        		  Ext.Ajax.request({
        			  type: 'rest',
        			  method: 'DELETE',
        			  url: SERVERURL.PATH_DELETE_SCHOLARSHIP_NOMINATE_AWARD+ '?ids=' + recordIds + '&awardRejectionReasonId=' + cancellation,
        			  headers: {
        				  'Content-Type': 'application/json'
        			  },
        			  success: function(form, action) {
        				  grid.getStore().reload();
        				  grid.getSelectionModel().deselectAll(true);
        				  grid.down('#btnAdd').setDisabled(false);
        				  showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_APPLICATION_REJECTED_SUCCESSFULLY'));
        				  $this.getScholarshipDeleteConfirmationWindow().close();
        			  }
        		  });
        	  }
          },
            
            'scholarshipDeleteConfirmationWindow button[itemId=cancelButtonId]':{
            	click: function(btn){
            		 var $this = this;
                     var formWindow = $this.getScholarshipDeleteConfirmationWindow();
                     
 					if (!formWindow) {
 						formWindow = Ext.widget('scholarshipDeleteConfirmationWindow');
 					}
 					formWindow.close();
                            
                  
            	}
            },
            'scholarshipapplicationform':{
            	afterrender: function(form){
            		var studentGrid = this.getManagescholarshipstudentlistgrid();
            		var applicantgrid = this.getManagescholarshipapplicantlistgrid();
            		var grid = this.getScholarshipHistoryGrid();
            		var applicableFor = form.down('#applicableFor');
            		var applicant =form.down('#applicantIdOrName');
            		var studentId = form.down('#studentIdOrName');
                    var TranscationIdField = form.down('#TranscationId'); 
                    var amountId = form.down('#amountId'); 
            		TranscationIdField.setVisible(false);
            		TranscationIdField.setDisabled(true);
            		amountId.setVisible(false)
            		grid.getStore().removeAll();
            		if(studentGrid.isHidden()){
            			applicableFor.setValue('APPLICANT');
            			applicant.setVisible(true);
            			studentId.setVisible(false);
            			this.setAllowBlank(studentId,true);
            		}else{
            			applicableFor.setValue('STUDENT');
            			studentId.setVisible(true);
            			applicant.setVisible(false);
            			this.setAllowBlank(applicant,true);
            		}
            		studentId.getStore().getProxy().extraParams = {
            			isForSave:false
				     };
            	}
            },
            'scholarshipapplicationform customcombobox[itemId=fnpBrandCampusItemId]': {
            	select:function(cmp){
            		this.getProgramBetchRec(cmp.getValue());
            	}
            },
      		'scholarshipapplicationform customcombobox[itemId=applicableFor]':{
      			select: function(cmp){
      				var $this = this;
      				var form = this.getScholarshipapplicationform();
      				var applicableFor = form.down("#applicableFor").getValue();
      				var applicant = form.down("#applicantIdOrName");
      				var studentId = form.down("#studentIdOrName");
      				var stdStatus = form.down('#stdStatus');
      				var academyLocation = form.down('#fnpBrandCampusItemId');
      				academyLocation.reset();
      				academyLocation.setDisabled(true);
      				var programBatchCode = form.down('#programBatchCode');
      				programBatchCode.reset();
      				programBatchCode.setDisabled(true);
      				var BatchId = form.down('#BatchId');
      				BatchId.reset();
      				BatchId.setDisabled(true);
      				var departmentalId = form.down('#departmentalId');
      				departmentalId.reset();
      				departmentalId.setDisabled(true);
      				var TranscationId = form.down('#TranscationId');
      				TranscationId.reset();
      				TranscationId.setVisible(false);
      				TranscationId.setDisabled(true);
      				var amountId = form.down('#amountId');
      				amountId.reset();
      				amountId.setVisible(false);
      				if(applicableFor === 'STUDENT'){
      					studentId.setVisible(true);
      					stdStatus.setVisible(true);
      					applicant.setVisible(false);
      					applicant.reset();
      					this.setAllowBlank(applicant,true);
      					this.setAllowBlank(studentId,false);
      					form.getForm().checkValidity();
      				}else{
      					stdStatus.setVisible(false);
      					studentId.setVisible(false);
      					applicant.setVisible(true);
      					studentId.reset();
      					this.setAllowBlank(applicant,false);
      					this.setAllowBlank(studentId,true);
      					form.getForm().checkValidity();
      				}
      				form.getForm().reset();
      				cmp.setValue(applicableFor);
      			}
      		},
      		'scholarshipapplicationform customcombobox[itemId=BatchId]':{
      			select: function(btn){
      				var form = this.getScholarshipapplicationform();
      				var scholarship = form.down('#scholarshipId')
      				var academyLocation = form.down('#fnpBrandCampusItemId').getValue();
      				var programId = form.down('#programBatchCode').getValue();
      				var batchId = form.down('#BatchId').getValue();
      				var accountYearId = form.down('#accountingYearId').getValue();
      				var categoryName = form.down('#scholarshipCategoryId').getValue();
      				var applicant = form.down('#applicantIdOrName').getValue();
      				var studentIdOrName = form.down("#studentIdOrName").getValue();
      				var stdBatchId = form.down('#stdBatchId');
      				var scholarshipStore = scholarship.getStore();
      				scholarship.reset();
      				scholarshipStore.getProxy().extraParams = {
            			academyLocationId:academyLocation,
            			programId:programId,
            			batchId:stdBatchId.getValue(),
            			accountYearId:accountYearId,
            			categoryName:categoryName,
            			studentId:studentIdOrName,
            			applicant:applicant
            		};
            		scholarshipStore.load();
      			}
      		},
      		'scholarshipapplicationform customcombobox[itemId=studentIdOrName]':{
      			afterrender : function(combo) {
      				var isactive,form =  combo.up('form'),$this=this,
      				statusCombo = form.down('#stdStatus'),
      				store = combo.getStore();
      				store.on('beforeload',function() {
      					if(statusCombo.getValue()==="ACTIVE"){
      						isactive=true;
      					}else if(statusCombo.getValue()==="INACTIVE"){
      						isactive=false;
      					}else{
      						isactive='All';
      					}
      					store.getProxy().extraParams.isForSave = isactive;
      				}, this);
      			},
      			select: function(cmp){
      				var $this = this;
      				var from = this.getScholarshipapplicationform();
      				var grid = this.getScholarshipHistoryGrid();
      				var academyLocation = from.down('#fnpBrandCampusItemId');
      				var student = from.down("#studentIdOrName");
      				var studentStore = student.getStore();
      				var studentIdOrName = student.getValue();
      				var academyStore = academyLocation.getStore().getProxy();
      				var newApi =  {read: SERVERURL.FETCH_ACADEMY_LOCATION_CODE_AND_NAME_BY_STUDENT_ID , update: SERVERURL.FETCH_ACADEMY_LOCATION_CODE_AND_NAME_BY_STUDENT_ID };
      				Ext.apply(academyStore.api,newApi);
      				academyLocation.getStore().getProxy().extraParams={
      					studentId:studentIdOrName
      				}
      				academyLocation.getStore().load({
      					callback: function(records, operation, success) {
      						academyLocation.setDisabled(false);
      						if (records.length > 0) {
      							academyLocation.setValue(records[0].data.id);
      							$this.getProgramBetchRec(records[0].data.id,true);
      						}
      					}   
      				})
      				$this.fetchStudentDetails(studentIdOrName,true);
      				grid.getStore().getProxy().extraParams={
      					studentId:studentIdOrName
      				}
      				grid.getStore().load();
      			}
      		},
                'scholarshipapplicationform customcombobox[itemId=applicantIdOrName]':{
                	select: function(btn){var $this = this;
            		var from = this.getScholarshipapplicationform();
            		var grid = this.getScholarshipHistoryGrid();
            		var academyLocation = from.down('#fnpBrandCampusItemId');
            		var applicant = from.down("#applicantIdOrName");
            		var applicantStore = applicant.getStore();
            		var applicantOrName = applicant.getValue();
            		var academyStore = academyLocation.getStore().getProxy();
            		var newApi =  {read: SERVERURL.FETCH_ACADEMY_LOCATION_CODE_AND_NAME_BY_APPLICANT_ID, update: SERVERURL.FETCH_ACADEMY_LOCATION_CODE_AND_NAME_BY_APPLICANT_ID};
            		Ext.apply(academyStore.api,newApi);
            		academyLocation.getStore().getProxy().extraParams={
            			applicationId:applicantOrName
            		}
            		academyLocation.getStore().load({
            			callback: function(records, operation, success) {
            				academyLocation.setDisabled(false);
            				if (records.length > 0) {
            					academyLocation.setValue(records[0].data.id);
            					$this.getProgramBetchRec(records[0].data.id,false);
            				}
            			}   
            		})
            		$this.fetchStudentDetails(applicantOrName,false);
            		grid.getStore().getProxy().extraParams={
            			applicantId:applicantOrName
            		}
            		grid.getStore().load();
            		}
                },
                'scholarshipapplicationform customcombobox[itemId=programBatchCode]':{
                	select: function(combo,obj){
                		var $this = this;
                		var form = this.getScholarshipapplicationform();
                		var programValue = form.down('#programBatchCode').getValue();
                		var BatchId = form.down("#BatchId");
                		var scholarship = form.down('#scholarshipId')
          				var academyLocation = form.down('#fnpBrandCampusItemId').getValue();
          				var accountYearId = form.down('#accountingYearId').getValue();
          				var categoryName = form.down('#scholarshipCategoryId').getValue();
          				var applicant = form.down('#applicantIdOrName').getValue();
          				var studentIdOrName = form.down("#studentIdOrName").getValue();
          				var stdBatchId = form.down('#stdBatchId');
          				var TranscationId = form.down('#TranscationId');
                		var amountId = form.down('#amountId');
          				var scholarshipStore = scholarship.getStore();
          				var departmentalId =  form.down('#departmentalId');
          				
          				departmentalId.reset();
                	 departmentalId.getStore().removeAll();
   					 departmentalId.getStore().loadData([{
   						 departmentShortCode:obj[0].data.departmentShortCode,
   						 departmenetName:obj[0].data.departmenetName,
   						 departmentId:obj[0].data.departmentId
   					 }],false);
   					 departmentalId.setValue(obj[0].data.departmentId.toString())
   					 departmentalId.setReadOnly(true);
   					 departmentalId.setDisabled(false);
   					obj[0].data.status && admissionStatus.setValue(getCommonTranslation(obj[0].data.status));
                		
          				stdBatchId.setValue(obj[0].data.batchId);
          				BatchId.setDisabled(false);
                		BatchId.setValue(obj[0].data.batchName);
                		
                		amountId.reset();
                		TranscationId.reset();
          				scholarship.reset();
          				scholarshipStore.getProxy().extraParams = {
                			academyLocationId:academyLocation,
                			programId:programValue,
                			batchId:stdBatchId.getValue(),
                			accountYearId:accountYearId,
                			categoryName:categoryName,
                			studentId:studentIdOrName,
                			applicant:applicant
                		};
                		scholarshipStore.load();
                	},

                         afterrender : function(combo) {
                         var isactive,form =  combo.up('form'),$this=this,
                          		statusCombo = form.down('#stdStatus'),
                          		store = combo.getStore();
                          		store.on('beforeload',function() {
                          		if(statusCombo.getValue()==="ACTIVE"){
                          			isactive=true;
                          		}else if(statusCombo.getValue()==="INACTIVE"){
                          			isactive=false;
                          		}else{
                          			isactive='All';
                          		}
                          		store.getProxy().extraParams.isActive = isactive;
                          		}, this);
                         },

                },
                'scholarshipapplicationform customcombobox[itemId=statusId]':{
                	select: function(obj){
                		var $this = this;
                		var form = this.getScholarshipapplicationform();
                		var status = form.down('#statusId').getValue();
                		var amount = form.down('#amountId')
                		var scholarshipId = form.down('#scholarshipId');
                		var transcation = form.down('#TranscationId');
                		var applicableFor = form.down('#applicableFor');
                		amount.reset();
                		transcation.reset();
              
                		
                		
                		if(status === 'NOMINATED'){
                			amount.setVisible(false);
                			this.setAllowBlank(amount, true);
                    		transcation.setVisible(false);
                    		transcation.setDisabled(true);
                    		form.getForm().checkValidity();
                		}
                		else{
                			var grid;
                			var studentGrid = this.getManagescholarshipstudentlistgrid();
                			var applicantgrid = this.getManagescholarshipapplicantlistgrid();
                			if(studentGrid.isHidden()){
                				grid=applicantgrid;
                			}else{
                				grid=studentGrid;
                			}
                			var record = grid.getSelectionModel().getSelection();
                			amount.setVisible(true);
                			this.setAllowBlank(amount, false);
                	  		Ext.Ajax.request({
    				    		type: 'rest',
    				    		async: false,
    				    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    				    		params: {
    				    			screenName: 'scholarshipapplicationform',
    				    			academyLocationId: $this.getCurrentAcademyLocation(),
    				    			languageCode:'en'
    				    		},
    				    		method: 'GET',
    				    		success: function(res, action) {
    				    			var response = Ext.decode(res.responseText);
    				    			if(Object.keys(response).length > 0){
    				    				var records=response.scholarshipapplicationform;
    				    				for(i in records){  
    				    					if(records[i].formFieldId === 'TranscationId' ){
    				    						if(records[i].isVisible == false){
    				    							transcation.setDisabled(true);
    				    						}
    				    						else{
    				    							transcation.setVisible(true);
    				    							transcation.setDisabled(false);
    				    						}
    				    					}
    				    				}
    				    			}
    				    		}
    				    	});
                			
                			form.getForm().checkValidity();
                				if(record.length>0){
                					var url;
                					if(applicableFor.getValue() == "STUDENT") {
                						url = SERVERURL.PATH_CHECK_MAX_STUDENT_AMOUNT+'?scholarshipId='+record[0].data.scholarshipId+'&studentId='+record[0].data.studentId+'&nominationId='+record[0].data.id;
                					}else {
                						url = SERVERURL.PATH_CHECK_MAX_STUDENT_AMOUNT+'?scholarshipId='+record[0].data.scholarshipId+'&applicantId='+record[0].data.applicantId+'&nominationId='+record[0].data.id;
                					}
                					Ext.Ajax.request({
                						method : "GET",
                						type : 'rest',
                						url: url,
                						success: function(response) {
                							var data = Ext.decode(response.responseText)
                							if(!isNullOrEmpty(data)) {
                								form.down('#amountId').setMaxValue(data);
                								if(record[0].data.amountTypeInScholarship=='ADH'){
                									amount.setReadOnly(false);
                								}else{
                									amount.setReadOnly(true);
                									form.down('#amountId').setValue(data);
                								}
                							}
                						}
                					});
                				}else{
                					if($this.schlAmountType === 'FIX'){
                						if(status!='NOMINATED'){
                							amount.setValue($this.schlAmountForStd);
                							amount.setReadOnly(true);
                						}
                					}
                					else{
                						amount.setMaxValue($this.schlAmountForStd);
                						amount.setReadOnly(false);
                					}
                				}
                			}
                		}
                },
                
                'scholarshipapplicationform customcombobox[itemId=accountingYearId]':{
                	select: function(btn){
                		var $this = this;
                		var from = this.getScholarshipapplicationform();
                		var academyLocation = from.down('#fnpBrandCampusItemId').getValue();
                		var programId = from.down('#programBatchCode').getValue();
                		var batchId = from.down('#BatchId').getValue();
                		var accountYearId = from.down('#accountingYearId').getValue();
                		var categoryName = from.down('#scholarshipCategoryId').getValue();
                		var studentIdOrName = from.down("#studentIdOrName").getValue();
                		var applicant = from.down('#applicantIdOrName').getValue();
                		var studentIdOrName = from.down("#studentIdOrName").getValue();
                		var scholarship = from.down('#scholarshipId');
                		var stdBatchId = from.down('#stdBatchId');
                		var TranscationId = from.down('#TranscationId');
                		var amountId = from.down('#amountId');
                		var scholarshipStore = scholarship.getStore();
                		
                		amountId.reset();
                		TranscationId.reset();
                		scholarship.reset();
                		scholarship.setDisabled(false);
                		
                		scholarshipStore.getProxy().extraParams = {
                			academyLocationId:academyLocation,
                			programId:programId,
                			batchId:stdBatchId.getValue(),
                			accountYearId:accountYearId,
                			categoryName:categoryName,
                			studentId:studentIdOrName,
                			applicant:applicant,
                			statusCheck:true
     				 };
                		scholarshipStore.load();
                		
                	                 		
                	}
                },
                
                'scholarshipapplicationform customcombobox[itemId=scholarshipCategoryId]':{
                	select: function(btn){
                		var $this = this;
                		var from = this.getScholarshipapplicationform();
                		var academyLocation = from.down('#fnpBrandCampusItemId').getValue();
                		var programId = from.down('#programBatchCode').getValue();
                		var batchId = from.down('#BatchId').getValue();
                		var accountYearId = from.down('#accountingYearId').getValue();
                		var categoryName = from.down('#scholarshipCategoryId').getValue();
                		var studentIdOrName = from.down("#studentIdOrName").getValue();
                		var applicant = from.down('#applicantIdOrName').getValue();
                		var studentIdOrName = from.down("#studentIdOrName").getValue();
                		var scholarship = from.down('#scholarshipId')
                		var stdBatchId = from.down('#stdBatchId');
                		var scholarshipStore = scholarship.getStore();
                		
                		scholarship.setDisabled(false);
                		
                		scholarshipStore.getProxy().extraParams = {
                			academyLocationId:academyLocation,
                			programId:programId,
                			batchId:stdBatchId.getValue(),
                			accountYearId:accountYearId,
                			categoryName:categoryName,
                			studentId:studentIdOrName,
                			applicant:applicant,
                			statusCheck:true
     				 };
                		scholarshipStore.load();
                		
                	                 		
                	}
                },
                
                'scholarshipapplicationform customcombobox[itemId=scholarshipId]':{
            	select: function(combo,obj){
            		var $this = this;
            		var from = this.getScholarshipapplicationform();
            		var scholarshipId = from.down('#scholarshipId').getValue()
            		var amount = from.down('#amountId')
            		var TranscationId = from.down('#TranscationId')
                    var TranscationIdStore = TranscationId.getStore();
            		var statusId = from.down('#statusId').getValue();
            		
            		amount.reset();
            		TranscationId.reset();
            		
            		TranscationIdStore.getProxy().extraParams = {
            			scholarshipId:scholarshipId
 				     };
            	   	TranscationIdStore.load();
            	   	$this.schlAmountType=obj[0].raw.scholarshipAmountType;
            	   	$this.schlAmountForStd=obj[0].raw.amount;
            		if(obj[0].raw.scholarshipAmountType === 'FIX'){
            			if(statusId!='NOMINATED'){
            				amount.setValue(obj[0].raw.amount);
            				amount.setReadOnly(true);
            			}
            		}
            		else{
            			amount.setMaxValue(obj[0].raw.amount);
            			amount.setReadOnly(false);
            		}
            	}
            },
            
            'scholarshipapplicationform button[itemId=SubmitBtn]':{
            	click: function(obj){
            		this.saveScholarshipApplicationForm();
            	}
            },
            
            'scholarshipapplicationform button[itemId=closeBtn]':{
            	click: function(obj){
            		var activeTab = this.getActiveTabfromContentPanel();
            		activeTab.close();
            	}
            },
            
            'scholarshipapplicationform button[itemId=CancelBtn]':{
              	click: function(btn){
              		var $this = this;
              		var from = this.getScholarshipapplicationform();
              		var academyLocationId = this.getCurrentAcademyLocation();
            		var academyLocation = from.down('#fnpBrandCampusItemId')
            		var programId = from.down('#programBatchCode')
            		var batchId = from.down('#BatchId')
            		var accountYearId = from.down('#accountingYearId')
            		var categoryName = from.down('#scholarshipCategoryId')
            		var scholarshipId = from.down('#scholarshipId')
            		var TranscationId = from.down('#TranscationId')
            		var status = from.down('#statusId')
            		var amount = from.down('#amountId')
            		var studentId = from.down('#studentIdOrName')
            		var accountingYear = from.down('#accountingYearId')
            		var applicant = from.down('#applicantIdOrName')
            		var applicableFor = from.down('#applicableFor')
            		var externalRefNum = from.down('#externalRefNum')
                    this.schlAmountType='';
    	            this.schlAmountForStd='';

            		if(this.schlAppScreenMode=='ADD'){
            			academyLocation.reset();
                		academyLocation.setValue(academyLocationId);
                		programId.reset();
                		programId.setDisabled(true);
                        batchId.reset();
                		batchId.setDisabled(true);
                        accountYearId.reset();
                        scholarshipId.reset();
                        scholarshipId.setDisabled(true);
                        categoryName.reset();
                        accountingYear.reset();
                        applicant.reset();
                        applicableFor.reset();
                        studentId.reset();
                        externalRefNum.reset();
                        categoryName.setValue($this.ScholarShipCategoryDefaultValue);
                        from.getForm().reset();
                        var BatchId = from.down('#BatchId');
          				BatchId.setDisabled(true);
          				var departmentalId = from.down('#departmentalId');
          				departmentalId.setDisabled(true);
          				var fnpBrandCampusItemId = from.down('#fnpBrandCampusItemId');
          				fnpBrandCampusItemId.setDisabled(true);
            		}
            		status.reset();
            		TranscationId.reset();
            		TranscationId.setVisible(false);
            		TranscationId.setDisabled(true);
            		amount.reset();
            		amount.setVisible(false);
            		this.setAllowBlank(amount,true);
            		var studentGrid = this.getManagescholarshipstudentlistgrid();
            		var applicantgrid = this.getManagescholarshipapplicantlistgrid();
            		
            		if(studentGrid.isHidden()){
            			applicableFor.setValue('APPLICANT');
            			applicant.setVisible(true);
            			studentId.setVisible(false);
            			this.setAllowBlank(studentId,true);
            		}else{
            			applicableFor.setValue('STUDENT');
            			studentId.setVisible(true);
            			applicant.setVisible(false);
            			this.setAllowBlank(applicant,true);
            		}
            		
            		
              	}
            },

      		'managescholarshipapplicantlistgrid':{
      			render:function(grid){
      				this.doAccessControlValidation(grid,this.getMANAGE_SCHOLARSHIP__PERMISSIONS());
      				this.addDataGridConfigButton(grid,this.getMANAGE_SCHOLARSHIP__PERMISSIONS());
      			},
      			selectionchange: function(column, selected,eOpts ){
      				var $this = this;
      				var grid = column.view.up('grid');
      				grid.down('#btnEdit').setDisabled(false);
      				grid.down('#btnView').setDisabled(false)
      				if(selected.length > 0) {	
      					grid.down('#btnAdd').setDisabled(true);
      					if(selected.length == 1){	
      						if(selected[0].data.status == "DOCUMENT_RE_SUBMISSION" || selected[0].data.status == "ACCEPTANCE_PENDING"  || selected[0].data.status == "VERIFICATION_IN_PROGRESS" || selected[0].data.status == "NOMINATED"){
      							grid.down('#btnDelete').setDisabled(false);
      							/*var allScholarshipId = []
                            for(var i=0; i< selected.length ;i++){
                                allScholarshipId.push(selected[i].data.id)
                           }
                			$this.ScholarshipAllIds = allScholarshipId*/
      						}else{
      							grid.down('#btnDelete').setDisabled(true);
      						}

      						if(selected[0].data.status =="AWARD_ACTIVATION_PENDING" || selected[0].data.status == "DOCUMENT_RE_SUBMISSION" || selected[0].data.status == "ACCEPTANCE_PENDING"  || selected[0].data.status == "VERIFICATION_IN_PROGRESS" || selected[0].data.status == "NOMINATED" || selected[0].data.status=="DECLINED"){
      							grid.down('#btnEdit').setDisabled(false);
      						}else{
      							grid.down('#btnEdit').setDisabled(true);
      						}
      					}
      					else if(selected.length > 1){
      						grid.down('#btnEdit').setDisabled(true);
      						grid.down('#btnView').setDisabled(true);
      						$this.ScholarshipAllIds  = [];
      						var isAllPendingSelected = true;
      						var selectedStatus = []
      						var StatusForButtonVisible = ["ACCEPTANCE_PENDING","NOMINATED","DOCUMENT_RE_SUBMISSION","VERIFICATION_IN_PROGRESS"]
      						for(var i=0; i< selected.length ;i++){
      							selectedStatus.push(selected[i].data.id);
      							if(!Ext.Array.contains(StatusForButtonVisible, selected[i].data.status)){
      								isAllPendingSelected = false;
      							}
      						}
      						$this.AllselectedStatus = selectedStatus
      						if(isAllPendingSelected){
      							grid.down('#btnDelete').setDisabled(false)
      						}
      						else{
      							grid.down('#btnDelete').setDisabled(true)
      						}
      					}
      				}else{
      					grid.down('#btnAdd').setDisabled(false);
      					grid.down('#btnDelete').setDisabled(false);
      				}
      			},
      		},
      		
//      		new code 
      		'scholarshipapplicationform button[itemId=cancelButtonId]':{
              	click: function(btn){
              		var $this = this;
              		var win = $this.getScholarshipDeleteConfirmationWindow();
      				win.close();
              	}
              },
      		
      		
      		
      		'managescholarshipstudentlistgrid button[itemId=btnView]':{
      			click:function(grid){
      				var this$ = this;
      				var stdGrid = this.getManagescholarshipstudentlistgrid();
      				if (stdGrid.getSelectionModel().getCount() > 0) {
      					var rec = stdGrid.getSelectionModel().getSelection();
      					var record = rec[0];
      					if(record.data.status){
							this.getAddScholarshipDetails();
							this.setDataOnScholarshipDetailsForNomination(record,'STUDENT',true);
						}else{
      					var formWindow = this$.getScholarshipdetailviewwin();
      					if (!formWindow) {
      						Ext.widget('scholarshipdetailviewwin');
      						formWindow = this$.getScholarshipdetailviewwin();
      					}
      					formWindow.show();
      				    formWindow.down('#applicantId').setVisible(false);
      					
      					if(!isNullOrEmpty(rec[0].data)){
      						formWindow.down('#scholarshipAppId').setValue(rec[0].data.scholarshipApplicationID);
      						formWindow.down('#scholarshipIdName').setValue(rec[0].data.scholarshipCode+'/'+rec[0].data.scholarshipName);
      						formWindow.down('#accountingYear').setValue(rec[0].data.accountingYear);
      						formWindow.down('#studentId').setValue(rec[0].data.studentCode+'/'+rec[0].data.studentName);
      						formWindow.down('#programId').setValue(rec[0].data.programName);
      						formWindow.down('#batchId').setValue(rec[0].data.batch);
      						formWindow.down('#amountId').setValue(rec[0].data.amount);
      						formWindow.down('#scholarshipStatus').setValue(getCommonTranslation(rec[0].data.status));
      						this$.toggleReadOnlyFormItems(formWindow.down('form').getForm(), true);
      					}
						}
      				}else{
      					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
      				}
      			}
      		},
      		'managescholarshipapplicantlistgrid button[itemId=btnView]':{
      			click:function(grid){
      				var this$ = this;
      				var applicantGrid = this.getManagescholarshipapplicantlistgrid();
      				if (applicantGrid.getSelectionModel().getCount() > 0) {
      					var rec = applicantGrid.getSelectionModel().getSelection();
      					var record = rec[0];
      					if(record.data.status){
							this.getAddScholarshipDetails();
							this.setDataOnScholarshipDetailsForNomination(record,'APPLICANT',true);
						}else{
      					var formWindow = this$.getScholarshipdetailviewwin();
      					if (!formWindow) {
      						Ext.widget('scholarshipdetailviewwin');
      						formWindow = this$.getScholarshipdetailviewwin();
      					}
      					formWindow.show();
      				    formWindow.down('#studentId').setVisible(false);
      					
      					if(!isNullOrEmpty(rec[0].data)){
      						formWindow.down('#scholarshipAppId').setValue(rec[0].data.scholarshipApplicationID);
      						formWindow.down('#scholarshipIdName').setValue(rec[0].data.scholarshipCode+'/'+rec[0].data.scholarshipName);
      						formWindow.down('#accountingYear').setValue(rec[0].data.accountingYear);
      						formWindow.down('#applicantId').setValue(rec[0].data.applicantCode+'/'+rec[0].data.applicantName);
      						formWindow.down('#programId').setValue(rec[0].data.programName);
      						formWindow.down('#batchId').setValue(rec[0].data.batch);
      						formWindow.down('#amountId').setValue(rec[0].data.amount);
      						formWindow.down('#scholarshipStatus').setValue(getCommonTranslation(rec[0].data.status));
      						this$.toggleReadOnlyFormItems(formWindow.down('form').getForm(), true);
      					}
						}
      				}else{
      					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
      				}
      			}
      		},
      		'managescholarshipstudentlistgrid button[itemId=btnAdd]':{
      			click:function(obj){
      				this.schlAppScreenMode='ADD';
      				this.getAddScholarshipDetails();
      				var form = this.getScholarshipapplicationform();
      				form.down('#CancelBtn').fireEvent('click',form.down('#CancelBtn'));
      			}
      		},
      		'managescholarshipapplicantlistgrid button[itemId=btnAdd]':{
      			click:function(obj){
      				this.schlAppScreenMode='ADD';
      				this.getAddScholarshipDetails();
      				var form = this.getScholarshipapplicationform();
      				form.down('#CancelBtn').fireEvent('click',form.down('#CancelBtn'));
      			}
      		},
      		'scholarshipdetailviewwin button[itemId=CancelBtn]':{
      			click:function(obj){
      				var win = this.getScholarshipdetailviewwin();
      				win.close();
      			}
      		},
      		'managescholarshipsearchfilter button[itemId=searchBtnItemID]':{
                  click: function(obj){
                      this.getManageScholarshipSearchData();
                 }
              },

			'managescholarshipstudentlistgrid button[itemId=btnEdit]':{
				click:function() {
					this.isStudent = true;
					this.schlAppScreenMode='EDIT';
					var grid = this.getManagescholarshipstudentlistgrid();
					var record = grid.getSelectionModel().getSelection()[0];
					if (grid.getSelectionModel().getCount() > 0) {
						if(record.data.status=='NOMINATED'){
							this.getAddScholarshipDetails();
							this.setDataOnScholarshipDetailsForNomination(record,'STUDENT');
						}else{
							this.scholarShipIdOpenTab('STUDENT')
						}
					}else{
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				}
			},
			'managescholarshipapplicantlistgrid button[itemId=btnEdit]':{
				click:function() {
					this.isStudent = false;
					this.schlAppScreenMode='EDIT';
					var grid = this.getManagescholarshipapplicantlistgrid();
					var record = grid.getSelectionModel().getSelection()[0];
					if (grid.getSelectionModel().getCount() > 0) {
						if(record.data.status=='NOMINATED'){
							this.getAddScholarshipDetails();
							this.setDataOnScholarshipDetailsForNomination(record,'APPLICANT');
						}else{
							this.scholarShipIdOpenTab('Applicant')
						}
					}else{
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				}
			},
			 'contentpanel':{
            	 tabchange:function(tabPanel, newCard, oldCard, eOpts){
            		 var this$ = this;
            		 if(newCard.items && newCard.items.items && newCard.items.items.length>0){
            			 if(newCard.items.items[0].xtype == 'spscholarshipacceptform'){
            				 var portalId = this.getCurrentLoggedPortalId();
            				 var store;
            				 var activeTab = this.getActiveTabfromContentPanel();
            				 var docGridCerp = activeTab.down('listofonlinedocumentscerpgrid');
            				 var docGrid = activeTab.down('listofonlinedocumentsgrid');
            				 var spscholarshipacceptform = activeTab.down('spscholarshipacceptform');
            				 docGridCerp.setVisible(false);
            				 docGrid.setVisible(false);
            				 if(portalId == 1) {
            					 docGridCerp.setVisible(true);
            					 //spscholarshipacceptform.down('#saveBtnCerp').setVisible(true);
            					 docGridCerp.down('#btnEdit').setDisabled(false)
            					 store = docGridCerp.getStore();
            				 }else {
            					 docGrid.setVisible(true);
            					 store = docGrid.getStore();
            				 }
          					
//            				 var grid = this.getListofonlinedocumentsgrid();
            				 var scholarshipId;
            				 var scholarshipNominationId;
            				 Ext.each(this$.stdSchlData,function(data){
            					 if(this$.getContentPanelActiveTab().title == data.scholarshipAppNumber){
            						 scholarshipId= data.scholarshipId;
            						 scholarshipNominationId= data.scholarshipNominationId;
            						 return false;
            					 }
            				 });
            				 store.getProxy().extraParams = {
            					 scholarshipId: scholarshipId,
            					 scholarshipNominateId:scholarshipNominationId,
            					 isStudent: this$.isStudent
            				 };
            				 store.load();
            			 }else if(newCard.items.items[0].xtype == 'scholarshiplistingscreen'){
            				 var grid = newCard.items.items[0].down('grid');
            				 grid.getHeader().removeCls('gridFixHeader');
            				 grid.dockedItems.items[3].removeCls('gridFixHeader');
            				 grid.columnManager.headerCt.removeCls('gridFixHeader');
            			 }
            		 }
            	 }
               },
               'listofonlinedocumentscerpgrid button[itemId=btnEdit]':{
        			click:function(grid){
        				var this$ = this;
        				var activeTab = this.getActiveTabfromContentPanel();
        				var stdGrid = activeTab.down('listofonlinedocumentscerpgrid');
        				if (stdGrid.getSelectionModel().getCount() > 0) {
        					var rec = stdGrid.getSelectionModel().getSelection()[0].data;
        					if(rec.documentStatus == "SUBMITTED" || isNullOrEmpty(rec.documentStatus)){
        						var formWindow = this$.getManagescholarshipeditdocument();
        						if (!formWindow) {
        							Ext.widget('managescholarshipeditdocument');
        							formWindow = this$.getManagescholarshipeditdocument();
        						}
        						formWindow.show();
        						var currentLoginUser = this.getCurrentlyLoggedInUserWithPersonId()
        						if(!isNullOrEmpty(rec)){
        							formWindow.down('#form_id').setValue(rec.scholarshipDocumentStudentId);
        							formWindow.down('#doucumentMasterName').setValue(rec.doucumentMasterName);
        							formWindow.down('#documentApplicability').setValue(rec.documentApplicability =='OPTIONAL'?'Optional' : rec.documentApplicability == 'MANDATORY'?'Mandatory':'');
        							formWindow.down('#inspectionDate').setValue(dateRender(new Date()));
        							formWindow.down('#inspectionBy').setValue(currentLoginUser.code+'/'+currentLoginUser.value);
        							formWindow.down('#documentStatus').setValue(rec.documentStatus);
        							formWindow.down('#remark').setValue(rec.remark);
        							
        						}
        						
        					}
        				}else{
        					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        				}
        			}
              },
              'managescholarshipeditdocument button[itemId=CancelBtn]':{
        			click:function(obj){
        				var win = this.getManagescholarshipeditdocument();
        				win.close();
        			}
        		},
        		'managescholarshipeditdocument button[itemId=saveBtn]':{
        			click:function(){
//        				var jsonFormFieldData = new Object();
        				var $this=this;
        				var scholrshipForm = this.getSpscholarshipacceptform();
				          var form = $this.getManagescholarshipeditdocument();
				          var formValue = form.down('form').getForm().getValues();
						//var currentLoginUser = this.getCurrentlyLoggedInUserWithPersonId();
				   var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;


				   			//var currentLoginUser = this.getCurrentlyLoggedInUserWithPersonId();
				   //		  var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
//			   				form.down('#saveBtn').setDisabled(true);
				   			var jsonFormFieldData = {
				   				docId : parseInt(formValue.id),
				   				inspectionDate : new Date().getTime(),
				   			//	inspectionBy :currentlyLoggedInUserId,
				   				inspectionBy :currentlyLoggedInUserId,
				   				documentStatus:form.down('#documentStatus').getValue(),
				   				remark : form.down('#remark').getValue(),
				   			}   				
			   				
        				Ext.Ajax.request({
        	                type: 'rest',
        	                url: SERVERURL.PATH_SCHOLARSHIP_DOCUMENT_STUDENT_UPDATE,
        	                jsonData: jsonFormFieldData,
        	                method: 'POST',
        	                success: function(form, action) {
        	                	Ext.getBody().unmask();
        	                	var activeTab = $this.getActiveTabfromContentPanel();
        	                	var grid = activeTab.down('listofonlinedocumentscerpgrid');
        	                	var win = $this.getManagescholarshipeditdocument();
                				win.close();
        	                	var grid = $this.getListofonlinedocumentscerpgrid();
									if(scholrshipForm.getForm().isValid()){
										scholrshipForm.down('#saveBtnCerp').setDisabled(false);
									}else{
										scholrshipForm.down('#saveBtnCerp').setDisabled(true);
									}
        	                    grid.getStore().reload();
        	                	grid.getSelectionModel().deselectAll(true);
    	                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DOCUMENT_STATUS_UPDATED_SUCCESSFULLY'));
        	                }

        	            });
        			}
        		},
        		'spscholarshipacceptform button[itemId=saveBtnCerp]':{
        			click:function(){
        				var $this = this;
        				var activeTab = $this.getActiveTabfromContentPanel();
        				var spscholarshipacceptform = $this.getSpscholarshipacceptform();
        				var amount = activeTab.down('#amountItemId').getValue();
        				var onlinedocGrid = activeTab.down('listofonlinedocumentscerpgrid');
        				var onlinedocGridData = onlinedocGrid.getStore().data.items;
        				var whetherAllMandatoryDocUploaded=false;
        				var mandDocAvailable=false;
        				var isAnyOptionalDocResubmit=false;
        				var grid;
        				var selectedRecord;
        				if(this.isStudent == true) {
        					grid = this.getManagescholarshipstudentlistgrid();    
        					selectedRecord = grid.getSelectionModel().getSelection()[0].data;
        				}else {
        					grid = this.getManagescholarshipapplicantlistgrid();
        					selectedRecord = grid.getSelectionModel().getSelection()[0].data;
        				}

        				/*Ext.each(onlinedocGridData,function(data){
        					if((data.data.documentApplicability=='MANDATORY') && (!data.data.documentStatus || data.data.documentStatus=='RE_SUBMIT')){
        						whetherAllMandatoryDocUploaded=false
        					}
        				});*/
        				
        				Ext.each(onlinedocGridData,function(data){
        					if(selectedRecord.status != 'DECLINED'){
        						if((data.data.documentApplicability=='MANDATORY') && (data.data.documentStatus=='VERIFIED' || data.data.documentStatus=='RE_SUBMIT')){
            						whetherAllMandatoryDocUploaded=true;
            					}
        					}
        				});
        				
        				Ext.each(onlinedocGridData,function(data){
        					if((data.data.documentApplicability=='MANDATORY')){
        						mandDocAvailable=true;
        					}
        					if(data.data.documentApplicability=='OPTIONAL' && data.data.documentStatus=='RE_SUBMIT'){
        						isAnyOptionalDocResubmit=true;
        					}
        				});
        				
        				
        				if(mandDocAvailable==false && selectedRecord.status =='VERIFICATION_IN_PROGRESS'){
        					whetherAllMandatoryDocUploaded=true;
        				}
        				var allowInactive = selectedRecord.whetherAllowInactiveStudents;
        				var studentStatus = selectedRecord.studentStatus;
        				if(allowInactive && this.isStudent && !studentStatus){
        					showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_STUDENT_IS_INACTIVE_DO_YOU_STILL_WANT_TO_PROCEED'),function(btn,text){
        						if (btn == 'yes') {
        							if(whetherAllMandatoryDocUploaded){
        								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        								var scholarshipNominationId;
        								Ext.each($this.stdSchlData,function(data){
        									if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
        										scholarshipNominationId= data.scholarshipNominationId;
        										return false;
        									}
        								});
        								var jsonData={
        										"amount":amount,
        										"id" : scholarshipNominationId,
        										"code":null,
        										"status":"VERIFICATION_IN_PROGRESS", //this status is not using in api
        										"isAllOptionalDoc":mandDocAvailable?false:true,
        												"isAnyOptionalDocResubmit":isAnyOptionalDocResubmit
        								};
        								Ext.Ajax.request({
        									method : 'GET',
        									type : 'rest',
        									url : SERVERURL.PATH_SCHOLARSHIP_FIND_SCHOLARSHIP_STATUS,
        									params: {
        										nominationId : scholarshipNominationId,
        									},
        									headers : {
        										'Content-Type' : 'application/json'
        									},
        									success : function(response,action) {
        										var data = response.responseText;
        										Ext.getBody().unmask();
        										if(data=='SCHOLARSHIP_ACTIVATED'){
        											$this.getContentPanelActiveTab().close();
        											showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_SCHOLARSHIP_HAS_ALREADY_BEEN_AWARDED_CANNOT_BE_UPDATED'));
        										}else if(data=='AWARD_ACTIVATION_REJECTED'){
        											$this.getContentPanelActiveTab().close();
        											showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_SCHOLARSHIP_HAS_ALREADY_BEEN_REJECTED_CANNOT_BE_UPDATED'));
        										}else{
        											Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        											Ext.Ajax.request({
        												method : 'POST',
        												jsonData : jsonData,
        												type : 'rest',
        												url : SERVERURL.PATH_UPDATE_SCHOLARSHIP_STATUS_NOMINATION,
        												headers : {
        													'Content-Type' : 'application/json'
        												},
        												success : function(form,action) {
        													Ext.getBody().unmask();
        													if(form.responseText === '-1'){
        														showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
        													}else{
        														showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_UPDATED_SUCCESSFULLY'));
        														$this.getContentPanelActiveTab().close();
        														grid.getStore().reload();
        														grid.getSelectionModel().deselectAll(true);   
        														grid.down('#btnAdd').setDisabled(false);
        													}
        													/*Ext.getBody().unmask();
        	        	        							showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_UPDATED_SUCCESSFULLY'));
        	        	        							$this.getContentPanelActiveTab().close();
        	        	        							grid.getStore().reload();
        	        	        							grid.getSelectionModel().deselectAll(true);   
        	        	        							grid.down('#btnAdd').setDisabled(false);*/
        												}
        											});
        										}
        									}
        								});

        							}else if(amount != selectedRecord.amount){  //If user update the amount
        								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        								var scholarshipNominationId;
        								Ext.each($this.stdSchlData,function(data){
        									if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
        										scholarshipNominationId= data.scholarshipNominationId;
        										return false;
        									}
        								});
        								var jsonData={
        										"amount":amount,
        										"id" : scholarshipNominationId,
        								};
        								Ext.Ajax.request({
        									method : 'GET',
        									type : 'rest',
        									url : SERVERURL.PATH_SCHOLARSHIP_FIND_SCHOLARSHIP_STATUS,
        									params: {
        										nominationId : scholarshipNominationId,
        									},
        									headers : {
        										'Content-Type' : 'application/json'
        									},
        									success : function(response,action) {
        										var data = response.responseText;
        										Ext.getBody().unmask();
        										if(data=='SCHOLARSHIP_ACTIVATED'){
        											$this.getContentPanelActiveTab().close();
        											showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_SCHOLARSHIP_HAS_ALREADY_BEEN_AWARDED_CANNOT_BE_UPDATED'));
        										}else if(data=='AWARD_ACTIVATION_REJECTED'){
        											$this.getContentPanelActiveTab().close();
        											showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_SCHOLARSHIP_HAS_ALREADY_BEEN_REJECTED_CANNOT_BE_UPDATED'));
        										}else{
        											Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        											Ext.Ajax.request({
        												method : 'POST',
        												jsonData : jsonData,
        												type : 'rest',
        												url : SERVERURL.PATH_UPDATE_SCHOLARSHIP_STATUS_NOMINATION,
        												headers : {
        													'Content-Type' : 'application/json'
        												},
        												success : function(form,action) {
        													Ext.getBody().unmask();
        													showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_UPDATED_SUCCESSFULLY'));
        													$this.getContentPanelActiveTab().close();
        													grid.getStore().reload();
        													grid.getSelectionModel().deselectAll(true);   	
        													grid.down('#btnAdd').setDisabled(false);
        												}
        											});		
        										}
        									}
        								});
        							}else{
        								showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_UPDATED_SUCCESSFULLY'));
        								$this.getContentPanelActiveTab().close();
        								grid.getStore().reload();
        								grid.getSelectionModel().deselectAll(true);  
        								grid.down('#btnAdd').setDisabled(false);
        							}
        						} 
        					});
        				}else{
        					if(whetherAllMandatoryDocUploaded){
            					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            					var scholarshipNominationId;
            					Ext.each($this.stdSchlData,function(data){
            						if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
            							scholarshipNominationId= data.scholarshipNominationId;
            							return false;
            						}
            					});
            					var jsonData={
            							"amount":amount,
            							"id" : scholarshipNominationId,
            							"code":null,
            							"status":"VERIFICATION_IN_PROGRESS", //this status is not using in api
            							"isAllOptionalDoc":mandDocAvailable?false:true,
            						    "isAnyOptionalDocResubmit":isAnyOptionalDocResubmit
            					};
            					Ext.Ajax.request({
            						method : 'GET',
            						type : 'rest',
            						url : SERVERURL.PATH_SCHOLARSHIP_FIND_SCHOLARSHIP_STATUS,
            						 params: {
            							 nominationId : scholarshipNominationId,
                    				 },
            						headers : {
            							'Content-Type' : 'application/json'
            						},
            						success : function(response,action) {
            						    var data = response.responseText;
            						    Ext.getBody().unmask();
            						    if(data=='SCHOLARSHIP_ACTIVATED'){
            						    	$this.getContentPanelActiveTab().close();
            						    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_SCHOLARSHIP_HAS_ALREADY_BEEN_AWARDED_CANNOT_BE_UPDATED'));
            						    }else if(data=='AWARD_ACTIVATION_REJECTED'){
            						    	$this.getContentPanelActiveTab().close();
            						    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_SCHOLARSHIP_HAS_ALREADY_BEEN_REJECTED_CANNOT_BE_UPDATED'));
            						    }else{
            						    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            						    	Ext.Ajax.request({
            	        						method : 'POST',
            	        						jsonData : jsonData,
            	        						type : 'rest',
            	        						url : SERVERURL.PATH_UPDATE_SCHOLARSHIP_STATUS_NOMINATION,
            	        						headers : {
            	        							'Content-Type' : 'application/json'
            	        						},
            	        						success : function(form,action) {
    	                                             Ext.getBody().unmask();
    	   											 if(form.responseText === '-1'){
    	           											 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
                										 }else{
            	        									showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_UPDATED_SUCCESSFULLY'));
            	        									$this.getContentPanelActiveTab().close();
            	        									grid.getStore().reload();
            	        									grid.getSelectionModel().deselectAll(true);   
            	        									grid.down('#btnAdd').setDisabled(false);
    												}
            	        							/*Ext.getBody().unmask();
            	        							showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_UPDATED_SUCCESSFULLY'));
            	        							$this.getContentPanelActiveTab().close();
            	        							grid.getStore().reload();
            	        							grid.getSelectionModel().deselectAll(true);   
            	        							grid.down('#btnAdd').setDisabled(false);*/
            	        						}
            	        					});
            						    }
            						}
            					});
            					
            				}else if(amount != selectedRecord.amount){  //If user update the amount
            					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            					var scholarshipNominationId;
            					Ext.each($this.stdSchlData,function(data){
            						if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
            							scholarshipNominationId= data.scholarshipNominationId;
            							return false;
            						}
            					});
            					var jsonData={
            							"amount":amount,
            							"id" : scholarshipNominationId,
            					};
            					Ext.Ajax.request({
            						method : 'GET',
            						type : 'rest',
            						url : SERVERURL.PATH_SCHOLARSHIP_FIND_SCHOLARSHIP_STATUS,
            						 params: {
            							 nominationId : scholarshipNominationId,
                    				 },
            						headers : {
            							'Content-Type' : 'application/json'
            						},
            						success : function(response,action) {
            						    var data = response.responseText;
            						    Ext.getBody().unmask();
            						    if(data=='SCHOLARSHIP_ACTIVATED'){
            						    	$this.getContentPanelActiveTab().close();
            						    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_SCHOLARSHIP_HAS_ALREADY_BEEN_AWARDED_CANNOT_BE_UPDATED'));
            						    }else if(data=='AWARD_ACTIVATION_REJECTED'){
            						    	$this.getContentPanelActiveTab().close();
            						    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_SCHOLARSHIP_HAS_ALREADY_BEEN_REJECTED_CANNOT_BE_UPDATED'));
            						    }else{
            						    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            						    	Ext.Ajax.request({
                        						method : 'POST',
                        						jsonData : jsonData,
                        						type : 'rest',
                        						url : SERVERURL.PATH_UPDATE_SCHOLARSHIP_STATUS_NOMINATION,
                        						headers : {
                        							'Content-Type' : 'application/json'
                        						},
                        						success : function(form,action) {
                        							Ext.getBody().unmask();
                        							showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_UPDATED_SUCCESSFULLY'));
                        							$this.getContentPanelActiveTab().close();
                        							grid.getStore().reload();
                        							grid.getSelectionModel().deselectAll(true);   	
                        							grid.down('#btnAdd').setDisabled(false);
                        						}
                        					});		
            						    }
            						}
            					});
            				}else{
            					showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_UPDATED_SUCCESSFULLY'));
            					$this.getContentPanelActiveTab().close();
            					grid.getStore().reload();
            					grid.getSelectionModel().deselectAll(true);  
            					grid.down('#btnAdd').setDisabled(false);
            				}
        				}
        			}
         		},
         		 'scholarshiprequestform radiogroup[itemId=subsequentScholarshipAvailable]':{
         			change:function(obj){
         				var $this = this;
         				var form = this.getScholarshiprequestform();
         				Ext.Ajax.request({
				    		type: 'rest',
				    		async: false,
				    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
				    		params: {
				    			screenName: 'scholarshiprequestform',
				    			academyLocationId: $this.getCurrentAcademyLocation(),
				    			languageCode:'en'
				    		},
				    		method: 'GET',
				    		success: function(res, action) {
				    			var response = Ext.decode(res.responseText);
				    			if(Object.keys(response).length > 0){
				    				var records=response.scholarshiprequestform;
				    				for(i in records){  
				    					if(records[i].formFieldId=='subsequentAmount' ){
				    						if(obj.getValue().subsequentScholarshipAvailable && records[i].isVisible==true){
					    						form.down('#subsequentAmount').setVisible(true);
					         					form.down('#subsequentAmount').allowBlank=false;
					         					form.down('#subsequentAmount').labelSeparator ='';
					         					form.down('#subsequentAmount').setFieldLabel(records[i].formFieldLabel+ ':<span class="required" style="color:red"> *</span>');
					    					}else if(records[i].isVisible==false){
					         					form.down('#subsequentAmount').setVisible(false);
					         					form.down('#subsequentAmount').allowBlank=true;
					         					form.down('#subsequentAmount').reset();
					         				}
				    						$this.checkScholarReqFormValidity();
				    						return false;
				    					}else{
				    						if(obj.getValue().subsequentScholarshipAvailable){
				    							form.down('#subsequentAmount').setVisible(true);
					         					form.down('#subsequentAmount').allowBlank=false;
					         					form.down('#subsequentAmount').labelSeparator ='';
					         					form.down('#subsequentAmount').setFieldLabel(getCommonTranslation('SUBSEQUENT_AMOUNT')+ ':<span class="required" style="color:red"> *</span>');
				    						}else{
				    							form.down('#subsequentAmount').setVisible(false);
					         					form.down('#subsequentAmount').allowBlank=true;
					         					form.down('#subsequentAmount').reset();
				    						}
				    					}
				    					$this.checkScholarReqFormValidity();
				    				}
				    			}else{
				    				//If DFR is not applied
					    			if(obj.getValue().subsequentScholarshipAvailable ){
			    						form.down('#subsequentAmount').setVisible(true);
			         					form.down('#subsequentAmount').allowBlank=false;
			         					form.down('#subsequentAmount').labelSeparator ='';
			         					form.down('#subsequentAmount').setFieldLabel(getCommonTranslation('SUBSEQUENT_AMOUNT')+ ':<span class="required" style="color:red"> *</span>');
			    					}else{
			         					form.down('#subsequentAmount').setVisible(false);
			         					form.down('#subsequentAmount').allowBlank=true;
			         					form.down('#subsequentAmount').reset();
			         				}
			    					$this.checkScholarReqFormValidity();
				    			}
				    		}
				    	});
         			}
         		},
         		'scholarshiprequestform customcombobox[itemId=poetProjectNumber]':{
         			select:function(obj,selectedValue){
         				var me = this;
         				var form = this.getScholarshiprequestform();
         				var poetProjectNumber = form.query('#poetProjectNumber');
         				var poetTaskNumber = obj.up().nextSibling().items.items[0];
            	    	var poetContractNumber = obj.up().nextSibling().items.items[1];
            	    	var poetFundingSource = obj.up().nextSibling().items.items[2];
            	    	var feeHead = obj.nextSibling();
            	    	poetTaskNumber.reset();
            	    	poetContractNumber.reset();
            	    	poetFundingSource.reset();
            	    	poetTaskNumber.setDisabled(false);
            	    	poetContractNumber.setDisabled(false);
            	    	
                	    if(this.WhetherDuplicatecostCentreSelected(poetProjectNumber)){
                	    	obj.reset();
                	    	return  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DUPLICATE_PROJECT_NUMBER_SELECTED'));
                	    }else{
                	    	if(poetTaskNumber.itemId=='poetTaskNumber'){
                	    		poetTaskNumber.store.proxy.extraParams = {
                	    				poetMasterDetailId: obj.getValue()
                	    		}
                	    		poetTaskNumber.store.load();
                	    	}
                	    	if(poetContractNumber.itemId=='poetContractNumber'){
                	    		poetContractNumber.store.proxy.extraParams = {
                	    				poetMasterDetailId: obj.getValue()
                	    		}
                	    		poetContractNumber.store.load({
        							callback: function(records, operation, success) {
        								if (records && records.length) {
        									me.setAllowBlank(poetContractNumber,false);
        								}else{
        									me.setAllowBlank(poetContractNumber,true);
        								}
        							}
        						});
                	    	}
                	    	
                	    	obj.getStore().load({
                    			  callback:function(records, operation, success) {
                    				  for(var  i in records){
                    					  if(records[i].data.id==selectedValue[0].data.id){
                    						  if(feeHead.itemId=='poetFeeHead'){
                    							 feeHead.setValue(records[i].data.feeHeadPoetDet);
                    						  }
                    					  }
                    				  }
                    			  }
              				});
                	    }
         			}
         		},
         		'scholarshiprequestform customcombobox[itemId=poetContractNumber]':{
         			select:function(obj){
         				var me =this;
         				var form = this.getScholarshiprequestform();
                        var poetFundingSource = obj.nextSibling();
                        poetFundingSource.setDisabled(false);
         				if (poetFundingSource.itemId == "poetFundingSource") {
            	    		poetFundingSource.store.proxy.extraParams = {
            	    				poetMasterContractId: obj.getValue()
                            };
            	    		poetFundingSource.store.load({
							callback: function(records, operation, success) {
								if (records && records.length) {
									me.setAllowBlank(poetFundingSource,false);
								}else{
									me.setAllowBlank(poetFundingSource,true);
								}
							}
						})
                        }
         				this.applyDFRForScholarshipMasterForm(form);
         			}
         		},
         		'bursarymasteraccoutinggrid': {
                    render: function(grid) {
                    	var me=this;
                        var store=grid.getStore();
                        store.proxy.extraParams = {
                                scholarshipId: me.getActiveTabfromContentPanel().scholarshipId
                         }
                         store.load();
                        var isScholarshipViewMode = me.getActiveTabfromContentPanel().isScholarshipViewMode;
                        if(!isNullOrEmpty(isScholarshipViewMode) && isScholarshipViewMode==true) {
                        	var activeTab = me.getContentPanelActiveTab();
             		    	var structure = activeTab.down("addscholarshiptabstructure");
             		    	var bursaryMasterAccoutingGrid = activeTab.down("#bursarymasteraccoutinggrItemid");
             		    	bursaryMasterAccoutingGrid.down("#btnAdd").setVisible(false);
             		    	bursaryMasterAccoutingGrid.down("#btnEdit").setVisible(false);
             		    	bursaryMasterAccoutingGrid.down("#btnView").setVisible(false);
             		    	bursaryMasterAccoutingGrid.down("#btnDelete").setVisible(false);
             		    	structure.down("#schlAccountingNextBtn").setVisible(false);
             		    	structure.down("#schlAccountingsSubmitBtn").setVisible(false);
                        } else {
                    	this.doAccessControlValidation(grid, me.getSCHOLARSHIPMASTER_ACCOUNTING_DETAILS_PERMISSIONS());
                        }
                    },
                    selectionchange:function(cmp, selected){
                    	var me = this,
                    	grid = me.getBursarymasteraccoutinggrid(),
                    	editBtn = grid.down('#btnEdit'),
                    	btnView = grid.down('#btnView'),
                    	btnDelete = grid.down('#btnDelete');
                    	if(selected && selected.length){
                    		editBtn.setDisabled(false);
                    		btnView.setDisabled(false);
                    		btnDelete.setDisabled(false);
                    	}else{
                    		editBtn.setDisabled(true);
                    		btnView.setDisabled(true);
                    		btnDelete.setDisabled(true);
                    	}
                    }
         		},
					'bursarymasteraccoutinggrid button[itemId=btnAdd]':{
						click:function(){
							var me =this;
							form = me.getAddscholarshiptabform();
							var accountingWin = Ext.widget('accountingDetailsSetupWin');
							accountingWin.show();
							Ext.defer(function(){
								if(me.getActiveTabfromContentPanel().down('#scholarshipCategory').getValue() == 'DEPARTMENTAL'){
									accountingWin.down('#accountingType').items.items[0].setDisabled(true);
									accountingWin.down('#accountingType').items.items[1].setDisabled(true);
									accountingWin.down('#accountingType').items.items[2].setValue(true);
								}else{
									accountingWin.down('#accountingType').items.items[2].setDisabled(true);
								}
								if(form.down('#Id_hidden_field').getValue()){
									accountingWin.down('#allowedScholarship').getStore().getProxy().extraParams={
										scholarshipId:parseInt(form.down('#Id_hidden_field').getValue())
				      				}
								}
								
							},300)
						}
					},
					'bursarymasteraccoutinggrid button[itemId=btnEdit]':{
						click:function(btn){
							this.fetchAccountingDetails(false)
						}
						
					},
					'bursarymasteraccoutinggrid button[itemId=btnView]':{
						click:function(btn){
							this.fetchAccountingDetails(true)
						}
										},
					'bursarymasteraccoutinggrid button[itemId=btnDelete]':{
						click:function(btn){
							btn.setDisabled(true);
							var me = this,
							grid = me.getBursarymasteraccoutinggrid();
							showConfirmMessage(getFeeAndPaymentCommonTranslation('ACCOUNTING_DETAILS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
		            				   function(btn, text) {
		            			   if (btn == 'yes') {
		            				   Ext.getBody().mask(getCommonTranslation('DELETE'), 'x-mask-loading');
		            				   var records = grid.getSelectionModel().getSelection()[0];
		            				   var id = records.data.id;
		            				   Ext.Ajax.request({
		            					   method : "DELETE",
		            					   type : 'rest',
		            					   url : SERVERURL.DELETE_SCHOLARSHIP_ACCOUNTING_SETUP  + '?id=' + id,
		            					   headers : {
		            						   'Content-Type' : 'application/json'
		            					   },
		            					   success : function(form, action) {
		            						   Ext.getBody().unmask();
		            						   if(form.responseText  == 'Success'){
		            							   Ext.getBody().unmask();
			            						   showSuccessMessage(getHostelTranslation('ACCOUNTING_DETAILS'), getCommonTranslation('SUCCESS'));
			            						   grid.getStore().load();
		            						   }else{
		            							   showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('DEPENDENCY_EXISTS'));
		            							   
		            						   }

		            					   }
		            				   });
		            			   }
		            		   });
						}
						
					},
         		'addscholarshiptabform radiogroup[itemId=fundAdminId]':{         			
         			change: function(obj){
         				var activeTab = this.getContentPanelActiveTab();
         		    	var form = activeTab.down("#addscholarshiptabform");
         				var internalFundField = form.down('#internalFundAdminId');
         				var objField = form.down('#fundAdminId');
         				if(objField.getValue().fundAdminName == false){
         					internalFundField.setVisible(false)
         				}
         				else{
         					internalFundField.setVisible(true);
         					this.applyDFRForScholarshipMasterForm(form);
         				}	
         			}
         		},
         		'addscholarshiptabform customcombobox[itemId=awardWithOther]':{ 
         			change: function(obj){
         				var activeTab = this.getContentPanelActiveTab();
         		    	var form = activeTab.down("#addscholarshiptabform");
         				var allowSchoalrshipField = form.down('#allowSchoalrshipIDName');
         				var objField = form.down('#awardwithOtherId');
         				if(!isNullOrEmpty(objField.getValue()) && objField.getValue() == 'ONLY_ALLOWED_SCHOLARSHIP'){
         					allowSchoalrshipField.setVisible(true);
         					this.applyDFRForScholarshipMasterForm(form);
         				}
         				else{
         					allowSchoalrshipField.setVisible(false)
         				}	
         			}
         		},
         		'addscholarshiptabform radiogroup[itemId=applicationRequiredId]':{ 
         			change: function(obj){
         				var activeTab = this.getContentPanelActiveTab();
         		    	var form = activeTab.down("#addscholarshiptabform");
         				var applicationStartDateField = form.down('#applicationStartDateId');
         				var applicationEndDateField = form.down('#applicationEndDateId');
         				var allowApplicationAfterEndDateField = form.down('#allowApplicationAfterEndDateId');
         				var objField = form.down('#applicationRequiredId');
         				
         				if(objField.getValue().applicationRequired == false){
         					applicationStartDateField.setVisible(false)
         					applicationEndDateField.setVisible(false)
         					allowApplicationAfterEndDateField.setVisible(false)
         				}
         				else{
         					applicationStartDateField.setVisible(true);
         					applicationEndDateField.setVisible(true);
         					allowApplicationAfterEndDateField.setVisible(true);
         					this.applyDFRForScholarshipMasterForm(form);
         				}
         			}
         		},
         		'addscholarshiptabform button#addScholarshipTabFormSaveBtnId':{
          			 click:function(btn){
                   		this.addScholarshipTabForm(btn);
                   	}
          		 },
          		'addscholarshiptabform button[itemId=resetButtonId]':{
          			click:function(btn){
          				var addScholarshipTabStructure = this.getAddscholarshiptabstructure();
              			var stepsAndTabList1 = addScholarshipTabStructure.up()
              			var accountingDetailTabId = stepsAndTabList1.down('#addscholarshiptabstructure').down('#accountingDetailTabId')
              			accountingDetailTabId.setDisabled(true);
              			this.setProgressTracker(0)
          			}
          		},
          		'docsAndRefStructure grid button[itemId=btnAdd]': {
          			click: this.openDocsAndRefDetailsWin
          		},
          		'accountingDetailsSetupWin radiogroup[itemId=accountingType]':{
          			change:function(objval,record){
          				this.fieldHideShowAccounting(record);
          			}
          		},
          		'accountingDetailsSetupWin textfield[itemId=totalBuget]':{
          			change:function(cmp,val){
          				cmp.nextSibling().setValue(val);
          			}
          		},
          		'accountingDetailsSetupWin customcombobox[itemId=costCenterId]':{
      			select:function(cmp,val){
      				cmp.nextSibling().setValue(val[0].data.feeHeadName);
      			}
      		},
      		'accountingDetailsSetupWin customcombobox[itemId=projectNumber]':{
      			select:function(cmp,val){
      				var me = this,
      				formView = me .getAccountingDetailsSetupWin(),
      				taskNumber = formView.down('#taskNumber'),
      				contractNumber = formView.down('#contractNumber');
      				taskNumber.setDisabled(false);
      				contractNumber.setDisabled(false);
      				taskNumber.reset();
      				contractNumber.reset();
      				taskNumber.getStore().getProxy().extraParams={
      					poetMasterDetailId:cmp.getValue()
      				}
      				contractNumber.getStore().getProxy().extraParams={
      					poetMasterDetailId:cmp.getValue()
      				}
      				cmp.nextSibling().setValue(val[0].data.feeHeadPoetDet);
      			}
      		},
      		'accountingDetailsSetupWin customcombobox[itemId=contractNumber]':{
      			select:function(cmp,val){
      				var me = this,
      				formView = me .getAccountingDetailsSetupWin(),
      				fundingSourceNumber = formView.down('#fundingSourceNumber');
      				fundingSourceNumber.setDisabled(false);
      				fundingSourceNumber.getStore().getProxy().extraParams={
      					poetMasterContractId:cmp.getValue()
      				}
      			}
     		},
//     		 'bursaryMasterGrid button[itemId=spBtnMoreActions] menuitem': {
//                 click: function(button) {
//                     if (button.itemId === "assignGradeLevelEntry") {
//                         this.assignProgarmEntities(button);
//                     }
//                     if(button.itemId === "scholarshipApplyToBtn") {
//                     	this.openScholarshipApplyToScreen(button);
//                     }
//                 }
//             },
     		'scholarshipApplyToSearchTab button[itemId=btnAdd]':{
     			click:function(button){
     			    var grid = this.getBursaryMasterGrid(),
     			    me =this,
     			    records = grid.getSelectionModel().getSelection()[0],
     			    scholarshipId = records.data.id;
     				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     				Ext.Ajax.request({
     					type : 'rest',
     					url :SERVERURL.PATH_FETCH_SCHOLARSHIP_MAPPING_STATUS,
     					method : 'GET',
     					params : {
                           scholarshipId:scholarshipId
     					},
     					headers : {
     						'Content-Type' : 'application/json'
     					},
     					success : function(response, action) {
     						var resp = response.responseText;
     						if(resp=="IN_PROGRESS"){
     							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PREVIOUS_RECORD_ARE_ALREADY_PROCESSING_PLEASE_WAIT'));
     						}else{
     							me.openAddScholarshipMappingTab(button);
     						}
     						Ext.getBody().unmask();
     					},
     					failure:function(){
     						Ext.getBody().unmask();
     					}
     				});
     				
     				//this.openAddScholarshipMappingTab(button);
     			}
//   		this.getActiveTabfromContentPanel().scholarshipId = record.get('id');
     		},
	   		'scholarshipApplyToSearchTab button[itemId=btnDelete]':{
    			click:this.deleteScholarshipAcademyLocation
	   		 },
      		'accountingDetailsSetupWin button[itemId=cancelButtonId]':{
      			click:function(btn){
      				btn.up('window').close();
      			}
      		},
      		'accountingDetailsSetupWin button[itemId=accountDetailBtn]':{
      			click:function(btn){
      				this.saveAccountDetailsSetup(btn)
      			}
      		},
      		'docsAndRefStructure grid': {
      			afterrender: function(grid) {
      				var isScholarshipViewMode = this.getActiveTabfromContentPanel().isScholarshipViewMode;
                    if(!isNullOrEmpty(isScholarshipViewMode) && isScholarshipViewMode==true) {
                    	var activeTab = this.getContentPanelActiveTab();
         		    	var structure = activeTab.down("docsAndRefStructure");
         		    	structure.down("#btnAdd").setVisible(false);
         		    	structure.down("#btnEdit").setVisible(false);
         		    	structure.down("#btnDelete").setVisible(false);
         		    	structure.down("#submitBtnItemId").setVisible(false);
                    } else {
      				this.doAccessControlValidation(grid, this.getSCHOLARSHIPMASTER_DOCUMENT_AND_REFERENCE_PERMISSIONS());
                    }
      				grid.getSelectionModel().deselectAll();
      				var gridStore = grid.getStore();
      				gridStore.getProxy().extraParams = {
      					scholarshipId: this.getActiveTabfromContentPanel().scholarshipId
      				};
      				gridStore.load();
      			}
      		},
      		'scholarshipApplyToSearchTab grid': {
      			afterrender: function(grid) {
      				this.doAccessControlValidation(grid, this.getSCHOLARSHIPMASTER_APPLY_TO_PERMISSIONS());
      			}
      		},
      		'docsAndRefDetailsWindow button[itemId=saveDocumentBtn]': {
      			click: this.doSaveDocAndRef
      		},
      		'accountingDetailsSetupWin customcombobox[itemId=accountYearId]':{
      			select:function(cmp,val){
      				var me =this;
      					Ext.Ajax.request({
      				   type : 'rest',
      				   url : SERVERURL.FIND_ACCOUTING_SETUP_ALREADY_EXIST,
      				   params : {
      					 scholarshipId:me.getActiveTabfromContentPanel().scholarshipId,
      					 accountingYearId:cmp.getValue()
      				   },
      				   method : 'GET',
      				   success : function(frm, action) {
      					   if(frm.responseText != 'true'){
      						 cmp.reset();
      						 showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('ACCOUNTING_SETUP_ALREADY_AVAILABLE'));
      					   }
      					 
      				   }  
      			   });	
      			}
      		},
      		'addScholarshipAcademyLocationGrid button[itemId=nextButton]':{
    			click:this.addScholarshipAlNextEvent
	   		 },
      		'addScholarshipAcademyLocationGrid button[itemId=resetBtn]':{
      	 			  click:function(btn){
      	 				  var tabStructure = this.getAddScholarshipMappingTabStructure();
      	 				  var activeGrid = tabStructure.getActiveTab().down('grid');
      	 				  activeGrid.getSelectionModel().deselectAll();
      	 				  activeGrid.getStore().clearFilter();
      	 				  if(activeGrid.down('customcombobox'))
      	 				  activeGrid.down('customcombobox').reset();
      	 				activeGrid.getStore().load()
      	 		  },
	   		 },
	   		'addScholarshipAlGridWithProgramGroup button[itemId=resetBtn]':{
	 			  click:function(btn){
	 				  var tabStructure = this.getAddScholarshipMappingTabStructure();
	 				  var activeGrid = tabStructure.getActiveTab().down('grid');
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('customcombobox'))
	 				  activeGrid.down('customcombobox').reset();
	 				activeGrid.getStore().load()
		 		  },
	 		 },
      		'addScholarshipAlGridWithProgram button[itemId=resetBtn]':{
      	 			  click:function(btn){
      	 				  var tabStructure = this.getAddScholarshipMappingTabStructure();
      	 				  var activeGrid = tabStructure.getActiveTab().down('grid');
      	 				  activeGrid.getSelectionModel().deselectAll();
      	 				  activeGrid.getStore().clearFilter();
      	 				 if(activeGrid.down('customcombobox'))
         	 				activeGrid.down('customcombobox').reset();
      	 				activeGrid.getStore().load()
      	 		  },
	   		 },
      		'addScholarshipAlGridWithProgramBatch button[itemId=resetBtn]':{
      	 			  click:function(btn){
      	 				  var tabStructure = this.getAddScholarshipMappingTabStructure();
      	 				  var activeGrid = tabStructure.getActiveTab().down('grid');
      	 				  activeGrid.getSelectionModel().deselectAll();
      	 				  activeGrid.getStore().clearFilter();
      	 				 if(activeGrid.down('customcombobox'))
         	 				 activeGrid.down('customcombobox').reset();
      	 				activeGrid.getStore().load()
      	 				
      	 		  },
	   		 },
	   		'addScholarshipAcademyLocationGrid customcombobox#academylocationsearchcombo' : {
	 			  select:function(obj, record){
	 				 this.getAddScholarshipAcademyLocationGrid().getStore().clearFilter();
	 				 this.getAddScholarshipAcademyLocationGrid().getStore().filter({property: 'id',
						  value: record[0].get('id'),
						  exactMatch: true,
						  caseSensitive: true});
	 				var grid = this.getAddScholarshipAcademyLocationGrid();
	 				var gridDom = grid.el ? grid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ 1;	
	 			  }
	 		  },
		   		'addScholarshipAlGridWithProgramGroup customcombobox#programGroupsearchcomboId' : {
		 			  select:function(obj, record){
		 				 this.getAddScholarshipAlGridWithProgramGroup().getStore().clearFilter();
		 				 this.getAddScholarshipAlGridWithProgramGroup().getStore().filter({
		 					 property: 'value',
							  value: record[0].get('value'),
							  exactMatch: true,
							  caseSensitive: true});
		 				var grid = this.getAddScholarshipAlGridWithProgramGroup();
		 				var gridDom = grid.el ? grid.el.dom : null;
		 				//gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ 1;	
		 			  }
		 		  },
	   		'addScholarshipAlGridWithProgram customcombobox#programsearchcombo' : {
	 			  select:function(obj, record){
	 				 this.getAddScholarshipAlGridWithProgram().getStore().clearFilter();
	 				 this.getAddScholarshipAlGridWithProgram().getStore().filter({
	 					 property: 'programId',
						  value: record[0].get('programId'),
						  exactMatch: true,
						  caseSensitive: true});
	 				var grid = this.getAddScholarshipAlGridWithProgram();
	 				var gridDom = grid.el ? grid.el.dom : null;
	 				//gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ 1;	
	 			  }
	 		  },
	   		'addScholarshipAlGridWithProgramBatch customcombobox#programbatchsearchcombo' : {
	 			  select:function(obj, record){
	 				 this.getAddScholarshipAlGridWithProgramBatch().getStore().clearFilter();
	 				 this.getAddScholarshipAlGridWithProgramBatch().getStore().filter({property: 'batchId',
						  value: record[0].get('batchId'),
						  exactMatch: true,
						  caseSensitive: true});
	 				var grid = this.getAddScholarshipAlGridWithProgramBatch();
	 				var gridDom = grid.el ? grid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ 1;	
	 			  }
	 		  },
	 		  'docsAndRefDetailsWindow customcombobox[itemId=applicability]': {
	 			  select: this.hadleAllowUploadCheckbox
	 		  },
	 		  'addscholarshiptabform customcombobox[itemId=scholarshipCategory]': {
	 			  select: this.handleDocumentAndReferenceTab
	 		  },
	 		  'addscholarshiptabstructure button[itemId=schlAccountingNextBtn]': {
	 			  click: this.moveToDocAndRefTab
	 		  },
	 		  'addscholarshiptabstructure button[itemId=schlAccountingsSubmitBtn]': {
	 			  click: function(){
	 				 showSuccessMessage(getCommonTranslation('ALERT'), getCommonTranslation('SUCCESS'));
	 				 this.getActiveTabfromContentPanel().close();
	 		    	this.getBursaryMasterGrid().getStore().reload();
	 			  }
	 		  },
          		'docsAndRefStructure grid button[itemId=btnEdit]': {
          			click: this.openDocsAndRefDetailsWin
          		},
	      		'addScholarshipAlGridWithProgram button[itemId=nextButton]':{
	    			click:this.addScholarshipAlWithProgramNextEvent
		   		 },
		   		'addScholarshipAlGridWithProgramGroup button[itemId=nextButton]':{
	    			click:this.addScholarshipAlWithProgramGroupNextEvent
		   		 },
		   		 'docsAndRefDetailsWindow button[itemId=documentLink]': {
		   			 click: this.downloadDocument
		   		 },
		   		 'docsAndRefStructure grid button[itemId=btnDelete]': {
		   			 click: this.deleteDocument
		   		 },
		   		 'addScholarshipMappingTabStructure button#submitAddScholarMapping':{
		 			  click:function(btn){
		 				  this.submitAddScholarMapping();
		 			  }
		 		  },
		 		  'docsAndRefStructure button[itemId=submitBtnItemId]': {
		 			  click: this.onSubmitDocAndRef
		 		  },
		 		  'addScholarshipDoMappingAlertWin button[itemId=addScholarshipDoMappingBtn]':{
		 			   click : function(btn) {
		 				   var alertWin = this.getAddScholarshipDoMappingAlertWin();
		 				   alertWin.close();
		 			   }
		 		   },
		 		   "scholarshipHistoryGrid":{
		 			   afterrender:function(grid){
		 				  var me=this;
		                	var associatedAcadLocationIds = new Array();
		            		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,this.getMANAGE_SCHOLARSHIP__PERMISSIONS());
		            		grid.setVisible(false)
		            		Ext.each(permissionList, function(privilege) {
		            			if (privilege === "SCHOLARSHIP_HISTORY_GRID") {
		            				grid.setVisible(true);
		            			}
		            		});
		 			   }
		 		   },
		     		'spscholarshipacceptform button[itemId=actionSubmitBtn]':{
		     			click:function(){
		     				var $this = this,selectedRecord;
		     				var grid = $this.getManagescholarshipstudentlistgrid();
		     				var activeTab = this.getActiveTabfromContentPanel();
		     				var onlinedocGrid = activeTab.down('listofonlinedocumentsgrid');
		     				var onlinedocGridData = onlinedocGrid.getStore().data.items;
		     				var whetherAllMandatoryDocUploaded=true;
		     				Ext.each(onlinedocGridData,function(data){
		     					if((data.data.documentApplicability=='MANDATORY') && (!data.data.documentStatus || data.data.documentStatus=='RE_SUBMIT')){
		     						whetherAllMandatoryDocUploaded=false
		     					}
		     				});
		     				selectedRecord = grid.getSelectionModel().getSelection()[0].data;
		     				var allowInactive = selectedRecord.whetherAllowInactiveStudents;
		     				var studentStatus = selectedRecord.studentStatus;
		     				if(allowInactive && this.isStudent && !studentStatus){
		     					showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_STUDENT_IS_INACTIVE_DO_YOU_STILL_WANT_TO_PROCEED'),function(btn,text){
		     						if (btn == 'yes') { 
		     							if(whetherAllMandatoryDocUploaded){
		     								showConfirmMessage(getCommonTranslation('SCHOLARSHIP_ACCEPT'),getCommonTranslation('ACCEPT_SCHOLARSHIP_APPLICATION_BEHALF_STUDENT'),function(btn,text){
		     									if (btn == 'yes') {
		     										Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		     										// to get the data of current open tab
		     										var scholarshipNominationId;
		     										Ext.each($this.stdSchlData,function(data){
		     											if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
		     												scholarshipNominationId= data.scholarshipNominationId;
		     												return false;
		     											}
		     										});
		     										var jsonData={
		     												  "id" : scholarshipNominationId,
		     												  "code":null,
		     												  "status":"VERIFICATION_IN_PROGRESS"
		     										};
		     										Ext.Ajax.request({
		     											method : 'POST',
		     											jsonData : jsonData,
		     											type : 'rest',
		     											url : SERVERURL.PATH_UPDATE_STATUS_NOMINATION,
		     											headers : {
		     												'Content-Type' : 'application/json'
		     											},
		     											success : function(form,action) {
		     												Ext.getBody().unmask();
		     												if(form.responseText === '-1'){
		     													showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
		     												}else{

		     													grid.getStore().reload();
		     													grid.getSelectionModel().deselectAll(true);  
		     													$this.getContentPanelActiveTab().close();
		     													showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_ACCEPTED_SUCCESSFULLY'));
		     												}
		     											}
		     										});
		     									}
		     								});

		     							}else{
		     								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_UPLOAD_ALL_MANDATORY_DOCUMENTS'));
		     							}
		     						} 
		     					}); 
		     				}
		     				else{
		     					if(whetherAllMandatoryDocUploaded){
		     						showConfirmMessage(getCommonTranslation('SCHOLARSHIP_ACCEPT'),getCommonTranslation('ACCEPT_SCHOLARSHIP_APPLICATION_BEHALF_STUDENT'),function(btn,text){
		     							if (btn == 'yes') {
		     								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		     								// to get the data of current open tab
		     								var scholarshipNominationId;
		     								Ext.each($this.stdSchlData,function(data){
		     									if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
		     										scholarshipNominationId= data.scholarshipNominationId;
		     										return false;
		     									}
		     								});
		     								var jsonData={
		     										  "id" : scholarshipNominationId,
		     										  "code":null,
		     										  "status":"VERIFICATION_IN_PROGRESS"
		     								};
		     								Ext.Ajax.request({
		     									method : 'POST',
		     									jsonData : jsonData,
		     									type : 'rest',
		     									url : SERVERURL.PATH_UPDATE_STATUS_NOMINATION,
		     									headers : {
		     										'Content-Type' : 'application/json'
		     									},
		     									success : function(form,action) {
		     										Ext.getBody().unmask();
		     										if(form.responseText === '-1'){
		     											showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
		     										}else{

		     											grid.getStore().reload();
		     											grid.getSelectionModel().deselectAll(true);  
		     											$this.getContentPanelActiveTab().close();
		     											showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_ACCEPTED_SUCCESSFULLY'));
		     										}
		     									}
		     								});
		     							}
		     						});

		     					}else{
		     						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_UPLOAD_ALL_MANDATORY_DOCUMENTS'));
		     					}
		     				}
		     			}
		     		},
		     		'spscholarshipacceptform button[itemId=actionSubmiStudentBtn]':{
		     			click:function(){
		     				var $this = this;
		     				var grid = $this.getManagescholarshipstudentlistgrid();
		     				var activeTab = this.getActiveTabfromContentPanel();
		     				var onlinedocGrid = activeTab.down('listofonlinedocumentsgrid');
		     				var onlinedocGridData = onlinedocGrid.getStore().data.items;
		     				var whetherAllMandatoryDocUploaded=true;
		     			    Ext.each(onlinedocGridData,function(data){
		     			    	if((data.data.documentApplicability=='MANDATORY') && (!data.data.documentStatus || data.data.documentStatus=='RE_SUBMIT')){
		     			    		whetherAllMandatoryDocUploaded=false
		     			    	}
		     			    });
		     			    if(whetherAllMandatoryDocUploaded){
		     			    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	     			    			// to get the data of current open tab
	     			    			var scholarshipNominationId;
	     			    			Ext.each($this.stdSchlData,function(data){
	     			    				if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
	     			    					scholarshipNominationId= data.scholarshipNominationId;
	     			    					return false;
	     			    				}
	     			    			});
	     			    			var jsonData={
	     			    					  "id" : scholarshipNominationId,
	     			    					  "code":null,
	     			    					  "status":"VERIFICATION_IN_PROGRESS"
	     			    			};
	     			    			Ext.Ajax.request({
	     			    				method : 'POST',
	     			    				jsonData : jsonData,
	     			    				type : 'rest',
	     			    				url : SERVERURL.PATH_UPDATE_STATUS_NOMINATION,
	     			    				headers : {
	     			    					'Content-Type' : 'application/json'
	     			    				},
	     			    				success : function(form,action) {
	     			    					Ext.getBody().unmask();
	     			    					onlinedocGrid.getStore().reload();
	     			    					onlinedocGrid.getSelectionModel().deselectAll(true);  
	     			    					$this.getContentPanelActiveTab().close();
	     			    					showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_ACCEPTED_SUCCESSFULLY'));
	     			    				}
	     			    			});
		     			    }else{
		     			    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_UPLOAD_ALL_MANDATORY_DOCUMENTS'));
		     			    }
		     			}
		     		},
		     		'spscholarshipacceptform button[itemId=declineScholarShipBtnAdmin]':{
	     			click:function(){
	     				if(portalId == '1'){
	     					this.declineScholarshipBehalfStudent()
	     				}
	     			}
		     		},
	          		'accountingDetailsSetupWin customcombobox[itemId=awardWithOther]':{
	          			change:function(cmp,val){
	          				cmp.nextSibling().reset();
	          				if(val == 'ONLY_ALLOWED_SCHOLARSHIP'){
	          					cmp.nextSibling().setDisabled(false);
	          					cmp.nextSibling().setVisible(true);
	          				}else{
	          					cmp.nextSibling().setDisabled(true);
	          					cmp.nextSibling().setVisible(false);
	          				}
	          				cmp.up('form').getForm().isValid();
	          				cmp.up('form').getForm().checkValidity();
	          			}
	          		},
	          		'addscholarshiptabform datefield[itemId=scholarshipValidFromId]':{
	          			change:this.checkDateIspassed
	          		},
	          		'addscholarshiptabform datefield[itemId=scholarshipValidTillId]':{
	          			change:this.checkDateIspassed
	          		},
	          		'addscholarshiptabform statusCombo[itemId=cmbStatus]':{
	          			select:this.checkDateIspassed
	          		},
	          		'scholarshipRequestListSerachForm customcombobox[itemId=studentId]' : {
	          			afterrender : function(combo) {
	          				var isInactive,form =  combo.up('form'),$this=this,
	          				statusCombo = form.down('#stdStatus'),
	          				store = combo.getStore();
	          				store.on('beforeload',function() {
	          					if($this.getContentPanelActiveTab().title==getMegaMenuTranslation("SS_SCHOLARSHIP_REQUEST_LIST")){
	          						if(statusCombo.getValue()==="ACTIVE"){
	          							isInactive=false;
	          						}else if(statusCombo.getValue()==="INACTIVE"){
	          							isInactive=true;
	          						}else{
	          							isInactive='All';
	          						}
	          						store.getProxy().extraParams.isInactive = isInactive;
	          					}
	          				}, this);
	          			}
	          		},
	          		'scholarshipRequestListSerachForm customcombobox[itemId=stdStatus]' : {
	          			select : function(combo) {
	          				var form =  combo.up('form');
	          				form.down('#studentId').reset();
	          				
	          			}
	          		},
	          		'managescholarshipsearchfilter customcombobox[itemId=studentId]' : {
	          			afterrender : function(combo) {
	          				var isInactive,form =  combo.up('form'),$this=this,
	          				statusCombo = form.down('#stdStatus'),
	          				store = combo.getStore();
	          				store.on('beforeload',function() {
	          					if($this.getContentPanelActiveTab().title==getMegaMenuTranslation("MANAGE_SCHOLARSHIP")){
	          						if(statusCombo.getValue()==="ACTIVE"){
	          							isInactive=false;
	          						}else if(statusCombo.getValue()==="INACTIVE"){
	          							isInactive=true;
	          						}else{
	          							isInactive='All';
	          						}
	          						store.getProxy().extraParams.isInactive = isInactive;
	          					}
	          				}, this);
	          			}
	          		},
	          		'managescholarshipsearchfilter customcombobox[itemId=stdStatus]' : {
	          			select : function(combo) {
	          				var form =  combo.up('form');
	          				form.down('#studentId').reset();
	          				
	          			}
	          		},
	          		'scholarshipapplicationform customcombobox[itemId=stdStatus]' : {
	          			select : function(combo) {
	          				var form =  combo.up('form');
	          				form.down('#studentIdOrName').reset();
	          				
	          			}
	          		},
	          		
        });
    },
//  openAddScholarshipMappingTab function code: Start
  openAddScholarshipMappingTab: function(button){
	var scholarshipId = this.getActiveTabfromContentPanel().scholarshipId;
	
  	var contentpanel = this.getContentPanel();
  	var coursetabstructure = Ext.widget('addScholarshipMappingTab'); 
  	var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');

  	var getcontroller=this.getController('menu.CoreERPNavigationController');
  	var getTab=getcontroller.getTab(tabName);
  	if(getTab!=null){
  		contentpanel.remove(getTab, true);
  	}
  	openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_FIVE);
  	var academylocationgrid = this.getAddScholarshipAcademyLocationGrid();
  	var feeplanwithprogrambatchseatstructure = this.getAddScholarshipMappingTabStructure();
  	academylocationgrid.getStore().clearFilter();
  	academylocationgrid.getStore().load();
  	this.getAddScholarshipAddMappingProgressTracker().setVisible(true);  	
  	
//  	this.resetProgressTracker();
  	var progressTrackerId = coursetabstructure.down("#addScholarshipAddMappingProgressTrackerId");
  	var progresstracker1 = progressTrackerId.down("#progresstracker1");
  	progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
  	progresstracker1.textEl.addCls("inProgressCss-progress-text");
  	progresstracker1.updateText("Step 1 In Progress");
  	this.getActiveTabfromContentPanel().scholarshipId = scholarshipId;
  },
  
  //delete scholarship academy location mapping
  deleteScholarshipAcademyLocation: function() {
      var grid = this.getScholarshipApplyToSearchTab().down('grid');
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('DELETE_SCHOLARSHIP_SETUP_MAPPING'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  var records = grid.getSelectionModel().getSelection()[0];
                  var id = records.data.id;
                  var programId = records.data.programId;
                  var batchId=records.data.batchId;
                  Ext.Ajax.request({
                      type: 'rest',
                      method: 'DELETE',
                      url: SERVERURL.SCHOLARSHIP_ACADEMY_LOCATION_DELETE +'?id='+ id+'&programId=' + programId+'&batchId=' + batchId,
                      headers: {
                          'Content-Type': 'application/json'
                      },
                      success: function(form, action) {
                          grid.getStore().reload();
                          showSuccessMessage(getCommonTranslation('DELETE_SCHOLARSHIP_SETUP_MAPPING'), getCommonTranslation('SCHOLARSHIP_DELETE_SUCCESS'));
                      }
                  });
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('DELETE_SCHOLARSHIP_SETUP_MAPPING'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
//openAddScholarshipMappingTab function code: End
  
//  AddScholarshipAlNext function:Start
  addScholarshipAlNextEvent:function(btn){
  	var academylocationgrid = this.getAddScholarshipAcademyLocationGrid();
  	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
  	var academyLocationIdsArr = [];
  	selectionModel.forEach(function(obj){
  		academyLocationIdsArr.push(obj.get('id'));
  	});
  	if(academyLocationIdsArr.length > 0){
	    	var addScholarshipMappingTabStructure = this.getAddScholarshipMappingTabStructure();	    	
	    	var programcontainer = addScholarshipMappingTabStructure.down('#programGroupcontainer');
	    	programcontainer.setDisabled(false);
	    	addScholarshipMappingTabStructure.setActiveTab(programcontainer);
	    	
//	    	var alProgramGrid = this.getAddScholarshipAlGridWithProgramGroup();
////	    	var alProgramGroupSearchCombo = alProgramGrid.down('#programGroupsearchcombo');
////	    	alProgramGroupSearchCombo.getStore().getProxy().extraParams= {
////	    		academyLocationIds: academyLocationIdsArr.join()
////	    	};
//	    	//alProgramGroupSearchCombo.getStore().load();
	    	
	    	var alProgramGrid = this.getAddScholarshipAlGridWithProgramGroup();
	    	var alProgramGroupSearchCombo = alProgramGrid.down('#programGroupsearchcomboId');
	    	alProgramGroupSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	alProgramGroupSearchCombo.getStore().load();
	    	
	    	var alProgramGridStore = alProgramGrid.getStore();
	    	alProgramGridStore.getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join(),
	    	};	    	
	    	alProgramGridStore.clearFilter();
	    	alProgramGridStore.load();
	    
	    	this.setProgressTrackForAddScholarAlMapping(1);
  	} else {
  		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
  	}
  },
  
//  AddScholarshipAlNext function :End

//AddScholarshipAlWithProgramGroupNext function:Start
  addScholarshipAlWithProgramGroupNextEvent:function(btn){
  	//var academylocationgrid = this.getAddScholarshipAlGridWithProgram();
	  var academylocationgrid = this.getAddScholarshipAlGridWithProgramGroup();
  	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
  	var alprogramgridIdsArr = [];
  	var programIdsArr = [];
  	selectionModel.forEach(function(obj){
		alprogramgridIdsArr.push(obj.get('secondId'));
		programIdsArr.push(obj.get('longValue'));
		//batchIdsArr.push(obj.get('batchId'));
	});
  	if(programIdsArr.length > 0){
	    	var addScholarshipMappingTabStructure = this.getAddScholarshipMappingTabStructure();
	    	var programcontainer = addScholarshipMappingTabStructure.down('#programcontainer');
	    	programcontainer.setDisabled(false);
	    	addScholarshipMappingTabStructure.setActiveTab(programcontainer);	    	
	  
	    	var alProgramGrid = this.getAddScholarshipAlGridWithProgram();
	    	var alProgramGroupGrid = this.getAddScholarshipAlGridWithProgramGroup();
	    	
	    	var alProgramGroupSearchCombo = alProgramGroupGrid.down('#programGroupsearchcomboId');	    	
	    	alProgramGroupSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: programIdsArr.join()
	    	};
	    	alProgramGroupSearchCombo.getStore().load();
	    	
	    	var alProgramGridStore = alProgramGrid.getStore();    	
	    	alProgramGridStore.getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programGroupId:programIdsArr.join(),

	    	};
	    	alProgramGridStore.clearFilter();
	    	alProgramGridStore.load();
	    	
	    	this.setProgressTrackForAddScholarAlMapping(2);
  	} else {
  		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
  	}
  },
//  AddScholarshipAlWithProgramGroupNext function :End
  
//AddScholarshipAlWithProgramNext function:Start
  addScholarshipAlWithProgramNextEvent:function(btn){
  	var academylocationgrid = this.getAddScholarshipAlGridWithProgram();
  	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
  	var alprogramgridIdsArr = [];
  	var programIdsArr = [];
	var batchIdsArr = [];
  	selectionModel.forEach(function(obj){
		alprogramgridIdsArr.push(obj.get('academyLocationId'));
		programIdsArr.push(obj.get('programId'));
		//batchIdsArr.push(obj.get('batchId'));
	});
  	if(programIdsArr.length > 0){
	    	var addScholarshipMappingTabStructure = this.getAddScholarshipMappingTabStructure();
	    	var programbatchcontainer = addScholarshipMappingTabStructure.down('#programbatchcontainer');
	    	programbatchcontainer.setDisabled(false);
	    	addScholarshipMappingTabStructure.setActiveTab(programbatchcontainer);
//	    	run
	    	var alProgramGrid = this.getAddScholarshipAlGridWithProgramBatch();
	    	var alProgramSearchCombo = alProgramGrid.down('#programbatchsearchcombo');
	    	alProgramSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds: programIdsArr.join()
	    	};
	    	//alProgramSearchCombo.getStore().load();
	    	var alProgramGridStore = alProgramGrid.getStore();
	    	
	    	alProgramGridStore.getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programIdsArr.join(),
	    		page:1,
    			start:0,
    			limit:-1
	    	};
	    	alProgramGridStore.clearFilter();
	    	alProgramGridStore.load();
	    	
	    	this.setProgressTrackForAddScholarAlMapping(3);
  	} else {
  		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
  	}
  },
  
//  AddScholarshipAlWithProgramNext function :End
//  submitAddScholarMapping: Start
  submitAddScholarMapping: function(button){
	  var addScholarMappingId = this.getActiveTabfromContentPanel().scholarshipId
	  
  	var tabStructure = this.getAddScholarshipMappingTabStructure();
  	var activeGrid = tabStructure.getActiveTab().down('grid');
  	var selectedRecord = activeGrid.getSelectionModel().getSelection();
  	var addScholarshipMappingTab = this.getAddScholarshipMappingTab();
  	var submitJsonObj = {}  	
  	var  collectArr = [];
  	if(selectedRecord.length>0){
  		var submitUrl = SERVERURL.PATH_ADD_SCHOLARSHIP_MAPPING_AL_PROGRAM;
  		var grid
  		Ext.each(selectedRecord,function(currentRecord){
  			collectArr.push({
				academyLocation:{
					id:currentRecord.get('academyLocationId') 
				},
				program:{
					id:currentRecord.get('programId') 
				},
				batch:{
					id:currentRecord.get('batchId') 
				},
			});
  		}),
  		submitJsonObj = {
  			scholarshipId:addScholarMappingId,
  			wsScholarshipALWithProgAndBatchRequestModel:collectArr
  		};
		
  		Ext.Ajax.request({
  			method: "POST",
  			type: 'rest',
  			url: submitUrl,
  			scope:this,
  			jsonData:submitJsonObj,
  			success : function(response, action) {
  				var contentpanel = this.getContentPanel();
  		    	var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');

  		    	var getcontroller=this.getController('menu.CoreERPNavigationController');
  		    	var getTab=getcontroller.getTab(tabName);
  		    	if(getTab!=null){
  		    		contentpanel.remove(getTab, true);
  		    	}

  		      var grid = this.getScholarshipApplyToSearchTab().down('grid');
  		    	var grdStore = grid.getStore();
  		    	grdStore.load();
  		    	
  		    	if(response.responseText == "success"){
  		    		getFeeAndPaymentCommonTranslation('APPLICABLE_FOR_SUCCESS')
        				showSuccessMessage(getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'), getFeeAndPaymentCommonTranslation('APPLY_TO_CREATED_SUCCESS'));
  		    	}
  		    	else {
      				var alertWin = this.getAddScholarshipDoMappingAlertWin();
      				if(!alertWin){
      					alertWin = Ext.widget('addScholarshipDoMappingAlertWin');
      				}
      				alertWin.down('#addScholarshipDoMapping').setValue(response.responseText);
      				alertWin.show();
      			}
  			}
  		});
  	} else {
  		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
  	}
  
  },

//  setProgressTrackerForAddScholarshipAlMapping: Start
  setProgressTrackForAddScholarAlMapping : function(progresstracker){
  	var structure = this.getAddScholarshipMappingTab();
  	  var addscholarshipmappingprogresstracker = structure.down("#addScholarshipAddMappingProgressTrackerId");

  	  var progresstracker1 = addscholarshipmappingprogresstracker.down("#progresstracker1");
  	  var progresstracker2 = addscholarshipmappingprogresstracker.down("#progresstracker2");
  	  var progresstracker3 = addscholarshipmappingprogresstracker.down("#progresstracker3");
  	  var progresstracker4 = addscholarshipmappingprogresstracker.down("#progresstracker4");

  	if(progresstracker==1){
		  for(var i = 0; i < 11; i ++ ){
			  progresstracker1.updateProgress((i * 0.1), '');
		  }
		  progresstracker1.textEl.addCls("custom-progress-text");
		  progresstracker1.textEl.removeCls("inProgressCss-progress-text");
		  progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
		  progresstracker2.textEl.addCls("inProgressCss-progress-text");
		  progresstracker2.updateText("Step 2 In Progress");
		  progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
	  }
	  if(progresstracker==2){
		  for(var i = 0; i < 11; i ++ ){
			  progresstracker2.updateProgress((i * 0.1), '');
		  }
		  progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
		  progresstracker3.textEl.addCls("inProgressCss-progress-text");
		  progresstracker3.updateText("Step 3 In Progress");
		  progresstracker2.textEl.removeCls("inProgressCss-progress-text");
		  progresstracker2.textEl.addCls("custom-progress-text");
		  progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
	  }
	  if(progresstracker==3){
		  for(var i = 0; i < 11; i ++ ){
			  progresstracker3.updateProgress((i * 0.1), '');
		  }
		  progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
		  progresstracker4.textEl.addCls("inProgressCss-progress-text");
		  progresstracker4.updateText("Step 4 In Progress");
		  progresstracker3.textEl.removeCls("inProgressCss-progress-text");
		  progresstracker3.textEl.addCls("custom-progress-text");
		  progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
	  }
	  if(progresstracker==4){
		  for(var i = 0; i < 11; i ++ ){
			  progresstracker4.updateProgress((i * 0.1), '');
		  }
		  progresstracker5.textEl.removeCls("x-progress-text x-progress-text-back");
		  progresstracker5.textEl.addCls("inProgressCss-progress-text");
		  progresstracker5.updateText("Step 4 In Progress");
		  progresstracker4.textEl.removeCls("inProgressCss-progress-text");
		  progresstracker4.textEl.addCls("custom-progress-text");
		  progresstracker4.updateText(getCommonTranslation('STEP_3_COMPLETE'));
	  }
    },

  resetProgressTracker : function(){
  	  var structure = this.addScholarshipTabStructure();
  	  var addscholarshipmappingprogresstracker = structure.down("#addscholarshipmappingprogresstracker");
  	  var progresstracker1 = addscholarshipmappingprogresstracker.down("#progresstracker1");
  	  var progresstracker2 = addscholarshipmappingprogresstracker.down("#progresstracker2");
  	  var progresstracker3 = addscholarshipmappingprogresstracker.down("#progresstracker3");
  	  var progresstracker4 = addscholarshipmappingprogresstracker.down("#progresstracker4");
  	  progresstracker1.reset();
  	  progresstracker1.updateText('');
  	  progresstracker2.reset();
  	  progresstracker2.updateText('');
  	  progresstracker3.reset();
  	  progresstracker3.updateText('');
  	  progresstracker4.reset();
	  progresstracker4.updateText('');
    },
//  setProgressTrackerForAddScholarshipAlMapping: End
  //  add schloarship tab form submit data
    addScholarshipTabForm: function(btn){
    	var $this = this;
    	var activeTab = $this.getContentPanelActiveTab();
    	var addScholarshipTabStructure = activeTab.down("#addscholarshiptabstructure");
    	var form = activeTab.down("#addscholarshiptabform");    	
    	var json = $this.createJsonForScholarshipTabForm(form);
    	var url = SERVERURL.PATH_SAVE_SCHOLARSHIP;
    	var isupdate = false;
    	var successMsg = getCommonTranslation('BURSARY_MASTER_CREATED_SUCCESSFULLY');
    	if(!isNullOrEmpty(json.id)) {
    		url = SERVERURL.PATH_UPDATE_SCHOLARSHIP;
    		isupdate = true;
    		successMsg = getCommonTranslation('SCHOLARSHIP_REQUEST_UPDATED_SUCCESSFULLY');
    	}
    	var formData = Ext.encode(json);
    	var stepsAndTabList1 = addScholarshipTabStructure.up()
		var accountingDetailTabId = stepsAndTabList1.down('#addscholarshiptabstructure').down('#accountingDetailTabId')
		   
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		   Ext.Ajax.request({
			   type : 'rest',
			   url : url,
			   jsonData : formData,
			   method : 'POST',
			   success : function(frm, action) {
				   Ext.getBody().unmask(); 
				   showSuccessMessage(getCommonTranslation('SUCCESS'), successMsg);	
				   if(!isupdate) {
					   form.down('#Id_hidden_field').setValue(frm.responseText)
					   $this.getActiveTabfromContentPanel().scholarshipId=frm.responseText;
				   accountingDetailTabId.setDisabled(false);
				   addScholarshipTabStructure.setActiveTab(accountingDetailTabId);
				   $this.setProgressTracker(1);
				   $this.getActiveTabfromContentPanel().scholarshipId = parseInt(frm.responseText);
				   }
			   },failure: function(form, action) {
				   var data = Ext.decode(form.responseText);
				   if(data && data.length && data[0].key == 'BURSARY_NAME_SHOULD_UNIQUE'){
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('BURSARY_NAME_SHOULD_UNIQUE'));
				   }
				        
				   }
//			   params : {id: id},	   
		   });	
    },
    createJsonForScholarshipTabForm: function(form){
    	var allowedScholarship =  form.down('#allowSchoalrshipIDName');
    	formDatas = form.getForm().getValues();
    	
//    	Getting owner field value
    		var OwnersJsonArry = [];
    		if(typeof formDatas.ownerIds == "object"){
        		Ext.each(formDatas.ownerIds, function(currentOwner){
                	var mainObj = '';
                    if(!isNullOrEmpty(currentOwner)){
                    	if(typeof currentOwner == "object") {
		                	mainObj = {
		                			"owner" : {
		                					"id" : currentOwner.data.id
		                			}	
		                	}
                    	} else {
                    		mainObj = {
		                			"owner" : {
		                					"id" : currentOwner
		                			}	
		                	}
                    	}
                	OwnersJsonArry.push(mainObj);
                    }
                });
    		}
    		else{
            	var mainObj = '';
            	mainObj = {
            			"owner" : {
            					"id" : formDatas.ownerIds
            			}		
            	}
            	OwnersJsonArry.push(mainObj);
    		}
    		formDatas.ownerIds = OwnersJsonArry;
    		
//    		getting allow schloarship Id/Name field value
    		
    		var allowSchloarshipJsonArry = [];    		
    		if(typeof formDatas.allowSchoalrshipIDName == "object"){
        		Ext.each(formDatas.allowSchoalrshipIDName, function(currentOwner){
                	var mainObj = '';
                    if(!isNullOrEmpty(currentOwner)){
                    	if(typeof currentOwner == "object") {
		                	mainObj = {
		                			"allowedscholarship" : {
		                					"id" : currentOwner.data.id
		                			}	
		                	}
                    	} else {
                    		mainObj = {
		                			"allowedscholarship" : {
		                					"id" : currentOwner
		                			}	
		                	}
                    	}
                    	allowSchloarshipJsonArry.push(mainObj);
                    }
                });
    		}
    		else{
    			if(!allowedScholarship.hidden && isNullOrEmpty(allowedScholarship)){
    				var mainObj = '';
                	mainObj = {
                			"allowedscholarship" : {
                					"id" : formDatas.allowSchoalrshipIDName
                			}		
                	}
                	allowSchloarshipJsonArry.push(mainObj);
    			}
    		}
    		
		var purposeNames = form.down('#purposeId');
		var purposeValues = purposeNames.getValue();
		var purposeId;
		var purposeList = [];
		if (purposeValues != "" && purposeValues != null) {
			for (var i in purposeValues) {
				if (Ext.isObject(purposeValues[0])) {
					purposeId = purposeValues[i].get("id");
					purposeList.push(purposeId);
				} else {
					purposeId = purposeValues[i];
					purposeList.push(purposeId);
				}
			}
		}
            formDatas.purposeList = purposeList;

    		formDatas.allowSchoalrshipIDName = allowSchloarshipJsonArry;
    		
//    		Internal Fund Administration getting value
    		if(!isNullOrEmpty(formDatas.internalFundAdmin)){
    			var InternalFundAdministration ={    				
        				"id" : formDatas.internalFundAdmin
    			   };
        		
                	formDatas.internalFundAdmin = InternalFundAdministration;
    		}
    		
//    		scholarshipStatus
    		if(formDatas.scholarshipStatus == 'Active'){
    			formDatas.scholarshipStatus = true
    		}
    		else if(formDatas.scholarshipStatus == 'Inactive'){
    			formDatas.scholarshipStatus = false
    		}
    		
    	json = {
    			"id":isNullOrEmpty(formDatas.id)?null:formDatas.id,
    			"version": "",
    			"serialNo":isNullOrEmpty(formDatas.serialNo)?null:formDatas.serialNo,
    			"scholarshipName": isNullOrEmpty(formDatas.scholarshipName)?null:formDatas.scholarshipName,
    			'scholarshipNameOtherLanguage':formDatas.scholarshipNameOtherLanguage,
    			'scholarshipCategory':isNullOrEmpty(formDatas.scholarshipCategory)?null:formDatas.scholarshipCategory,
    			'organizationId':isNullOrEmpty(formDatas.organizationId)?null:formDatas.organizationId,
    			'scholarshipType':isNullOrEmpty(formDatas.scholarshipType)?null:formDatas.scholarshipType,
    			'graduateLevel':isNullOrEmpty(formDatas.graduateLevel)?null:formDatas.graduateLevel,
    			'scholarshipStatus':formDatas.scholarshipStatus,
    			'scholarshipValidFrom':formDatas.scholarshipValidFrom,
    			'scholarshipValidTill':formDatas.scholarshipValidTill,    			
    			'validityInMonth':formDatas.validityInMonth,
    			'currencyId':formDatas.currencyId,
    			'purpose':isNullOrEmpty(formDatas.purposeList)?null:formDatas.purposeList.join(),
    			'fundType':isNullOrEmpty(formDatas.fundType)?null:formDatas.fundType,
    			'financingInstitutionId':isNullOrEmpty(formDatas.financingInstitutionId)?null:formDatas.financingInstitutionId,
    			'scholarshipOwners':isNullOrEmpty(formDatas.ownerIds)?null:formDatas.ownerIds,
    			'coversOldDebt':formDatas.coversOldDebt,
    			'allocateBalanceOn':formDatas.allocateBalanceOn,
    			'darScholarship':formDatas.darScholarship,
    			'applicationMode':isNullOrEmpty(formDatas.applicationMode)?null:formDatas.applicationMode,
    			'applicationRequired':formDatas.applicationRequired,
    			'applicationStartDate':formDatas.applicationStartDate,    			
    			'applicationEndDate':formDatas.applicationEndDate,
    			'allowApplicationAfterEndDate':formDatas.allowApplicationAfterEndDate,
    			'backgroundDescription':formDatas.droolAgendaDescription,
    			'backgroundOtherLanguage':formDatas.droolAgendaDescriptionOtherLanguage,
    			'fundAdministratorInternal':formDatas.fundAdminName,
    			'internalFundAdministrator':isNullOrEmpty(formDatas.internalFundAdmin)?null:formDatas.internalFundAdmin,
    			'awardCancellation':isNullOrEmpty(formDatas.awardCancellation)?null:formDatas.awardCancellation,
    			'scholarshipAmountType':isNullOrEmpty(formDatas.scholarshipAmountType)?null:formDatas.scholarshipAmountType,
    			'maxAmountPerStudent':formDatas.maxAmountPerStudent,
    			'maxNoAwardees':formDatas.maxNoAwardees,
    			"allowConcessionCandidate":true,
    	          "disbursementMode":"ACD",
    	          "paymentType":"OT",
    	          "selectionType":"ACD",
    	          "background":"bgTest",
    	          "whetherAllowInactiveStudents":formDatas.allowInactive
    	}
    	return json;
    },
    
    setProgressTracker : function(progresstracker){
    	var addScholarshipTabStructure = this.getAddscholarshiptabstructure();
    	  var structure = addScholarshipTabStructure.up();
    	  var addscholarshipmappingprogresstracker = structure.down("#addscholarshipmappingprogresstracker");

    	  var progresstracker1 = addscholarshipmappingprogresstracker.down("#progresstracker1");
    	  var progresstracker2 = addscholarshipmappingprogresstracker.down("#progresstracker2");
    	  var progresstracker3 = addscholarshipmappingprogresstracker.down("#progresstracker3");
    	  var progresstracker4 = addscholarshipmappingprogresstracker.down("#progresstracker4");

    	if(progresstracker==1){
  		  for(var i = 0; i < 11; i ++ ){
  			  progresstracker1.updateProgress((i * 0.1), '');
  		  }
  		  progresstracker1.textEl.addCls("custom-progress-text");
  		  progresstracker1.textEl.removeCls("inProgressCss-progress-text");
  		  progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
  		  progresstracker2.textEl.addCls("inProgressCss-progress-text");
  		  progresstracker2.updateText("Step 2 In Progress");
  		  progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
  	  }
  	  if(progresstracker==2){
  		  for(var i = 0; i < 11; i ++ ){
  			  progresstracker2.updateProgress((i * 0.1), '');
  		  }
  		  progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
  		  progresstracker3.textEl.addCls("inProgressCss-progress-text");
  		  progresstracker3.updateText("Step 3 In Progress");
  		  progresstracker2.textEl.removeCls("inProgressCss-progress-text");
  		  progresstracker2.textEl.addCls("custom-progress-text");
  		  progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
  	  }
  	  if(progresstracker==3){
  		  for(var i = 0; i < 11; i ++ ){
  			  progresstracker3.updateProgress((i * 0.1), '');
  		  }
  		  progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
  		  progresstracker4.textEl.addCls("inProgressCss-progress-text");
  		  progresstracker4.updateText("Step 4 In Progress");
  		  progresstracker3.textEl.removeCls("inProgressCss-progress-text");
  		  progresstracker3.textEl.addCls("custom-progress-text");
  		  progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
  	  }
  	  if(progresstracker==4){
  		  for(var i = 0; i < 11; i ++ ){
  			  progresstracker4.updateProgress((i * 0.1), '');
  		  }
  		  progresstracker4.textEl.removeCls("inProgressCss-progress-text");
  		  progresstracker4.textEl.addCls("custom-progress-text");
  		  progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
  	  }
      },

    resetProgressTracker : function(){
    	  var structure = this.addScholarshipTabStructure();
    	  var addscholarshipmappingprogresstracker = structure.down("#addscholarshipmappingprogresstracker");
    	  var progresstracker1 = addscholarshipmappingprogresstracker.down("#progresstracker1");
    	  var progresstracker2 = addscholarshipmappingprogresstracker.down("#progresstracker2");
    	  var progresstracker3 = addscholarshipmappingprogresstracker.down("#progresstracker3");
    	  var progresstracker4 = addscholarshipmappingprogresstracker.down("#progresstracker4");
    	  progresstracker1.reset();
    	  progresstracker1.updateText('');
    	  progresstracker2.reset();
    	  progresstracker2.updateText('');
    	  progresstracker3.reset();
    	  progresstracker3.updateText('');
    	  progresstracker4.reset();
    	  progresstracker4.updateText('');
      },
    
    getAddScholarshipDetails : function(){
    	var contentpanel = this.getContentPanel();
    	var structure = Ext.widget('scholarshipapplicationform');
    	var tabName = getCommonTranslation('SCHOLARSHIP_APPLICATION');
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentpanel.remove(getTab, true);
    	}
    	openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
    },
    
    scholarShipIdOpenTab:function(type) {
    	var grid;
    	var url;
    	var structure = Ext.widget('spscholarshipacceptform');
    	if(type == "STUDENT") {
    		grid = this.getManagescholarshipstudentlistgrid();
    	}else {
    		grid = this.getManagescholarshipapplicantlistgrid();
    	}
		var selectedRecord = grid.getSelectionModel().getSelection()[0].data;
		var contentPanel = this.getContentPanel();
		 var tabName = selectedRecord.scholarshipApplicationID;
		 var getcontroller=this.getController('menu.CoreERPNavigationController');
		 var getAddTab = getcontroller.getTab(tabName);
		 if (getAddTab != null) {
			 contentPanel.remove(getAddTab, true);
		 }
		openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);
		//structure.down('#declineScholarShipBtn').setVisible(false);
		structure.down('#scholarshipAppNumber').setValue(selectedRecord.scholarshipApplicationID);
		structure.down('#scholarshipIdName').setValue(selectedRecord.scholarshipCode+'/'+selectedRecord.scholarshipName);
		structure.down('#accountingYear').setValue(selectedRecord.accountingYear);
		structure.down('#programId').setValue(selectedRecord.programName);
		structure.down('#batchId').setValue(selectedRecord.batch);
		structure.down('#amountId').setVisible(false);
		structure.down('#amountItemId').setVisible(true);
		structure.down('#amountItemId').setValue(selectedRecord.amount);
		
		if(selectedRecord.amountTypeInScholarship == 'FIX' || selectedRecord.status == 'NOMINATED'  || selectedRecord.status == 'REJECTED' || selectedRecord.status == 'DECLINED' || selectedRecord.status == 'ACCEPTED'  || selectedRecord.status == 'DOCUMENT_RE_SUBMISSION' ) {
			structure.down('#amountItemId').setDisabled(true);
		}
		if(type == "STUDENT") {
    		structure.down('#StudentIdName').setVisible(true)
			structure.down('#StudentIdName').setValue(selectedRecord.studentCode +'/'+selectedRecord.studentName);	
    		url = SERVERURL.PATH_CHECK_MAX_STUDENT_AMOUNT+'?scholarshipId='+selectedRecord.scholarshipId+'&studentId='+selectedRecord.studentId+'&nominationId='+selectedRecord.id;
    	}else {
    		structure.down('#applicantIdName').setVisible(true)
    		structure.down('#applicantIdName').setValue(selectedRecord.applicantCode +'/'+selectedRecord.applicantName);
    		url = SERVERURL.PATH_CHECK_MAX_STUDENT_AMOUNT+'?scholarshipId='+selectedRecord.scholarshipId+'&applicantId='+selectedRecord.applicantId+'&nominationId='+selectedRecord.id;
    	}
		if(selectedRecord.amountTypeInScholarship !== 'FIX') {
			Ext.Ajax.request({
				method : "GET",
				type : 'rest',
				url: url,
				success: function(response) {
					var data = Ext.decode(response.responseText)
					if(!isNullOrEmpty(data)) {
						this.maxAmountLength = data;					
						structure.down('#amountItemId').setMaxValue(data)		
					}
				}
			});
		}

    },
    /**** Export function *******/
    
    exportScholarshipMaster: function(exportUrl, filetype, whetherAll) {
        var quickSearchForm = this.getScholarshipMasterForm();
        var searchResultGrid = this.getSearchResultGrid();
        var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
        var searchCriteriaString = this.createSearchCriteriaString(quickSearchForm);
        var jsonFormatFormData = this.createJsonFormat(quickSearchForm);
        var visibleColumns = this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation('SCHOLARSHIP_MASTER');
        if (!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) && searchResultGrid.store.getCurrentSortCriteria() != undefined && searchResultGrid.store.getCurrentSortCriteria() != null) jsonFormatFormData.sortCriterias = searchResultGrid.store.getCurrentSortCriteria();
        searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions, whetherAll, searchCriteriaString, visibleColumns, reportTitle);
    },

    createSearchCriteriaString: function(searchForm) {
        var me = this;
        var formValues = new Array();
        formValues = searchForm.getValues();
        var searchCriteriaString = "";
        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && key !== 'selectedNameField') {
                var keyValueJsonObject = me.getJsonObject(key, value);
                searchCriteriaString = searchCriteriaString + keyValueJsonObject.paramCode + "  : " + searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString = searchCriteriaString.substring(0, searchCriteriaString.length - 1);
        return searchCriteriaString;
    },

    loadGridAndSearchUsers: function(model, records) {
       var $this=this;
  	   var form = $this.getScholarshipMasterForm();
  	   var formValue = form.getValues();
  	   var status;
  	   if(formValue.SCHOLARSHIP_STATUS == 'Active'){
  		 status = true;
  	   }if(formValue.SCHOLARSHIP_STATUS == 'Inactive'){
  		 status = false;
  	   }
  	   if(formValue.SCHOLARSHIP_CATEGORY == ''){
  		 formValue.SCHOLARSHIP_CATEGORY = null;
  	   }
  	   if(formValue.AMOUNT_TYPE == ''){
  		 formValue.AMOUNT_TYPE = null;
  	   }
  	   var al = $this.getAcademyLocationForBursaryMaster(form);
  	   var grid = $this.getBursaryMasterGrid();
  	   var store =  grid.getStore();
  	   this.resetPageSetting(store);
  	   store.getProxy().extraParams = {
  		   academyLocationIds: al.join(),
  		   scholarshipId:formValue.SCHOLARSHIP_ID,
  		   scholarshipCategory:formValue.SCHOLARSHIP_CATEGORY,
  		   amountType:formValue.AMOUNT_TYPE,
  		   status:status,
  		   schWithoutMapping:formValue.SCHOLARSHIP_WITHOUT_MAPPING,
  	   };
  	   store.load();
  	   grid.getSelectionModel().deselectAll();
    },
    
    loadIntellimaliGridAndSearchUsers: function(model, records) {
 	   var $this=this;
	   var form = $this.getIntellimaliForm();
	   var formValue = form.getValues();
	   var al = $this.getAcademyLocationId(form);
	   var grid = $this.getIntellimaligrid();
	   var store =  grid.getStore();
	   this.resetPageSetting(store);
	   store.getProxy().extraParams = {
		   academyLocationIds: al.join(),
		   accountingYearId: formValue.intellimaliAccountingYear,
		   studentId: formValue.student,
		   startDate: formValue.fromdate,
		   endDate: formValue.todate,
		   fundAllocationType: formValue.fundAllocation,
		   status:formValue.status
		  /* page:1,
		   start:0,
		   limit:-1*/

	   };
	   store.load();
	   grid.getSelectionModel().deselectAll();
   },
   changeStudent:function(obj,rec){
		var form = obj.up('form');
		var intellimaliBrandCampusName = form.down('#intellimaliBrandCampusName');
		var intellimaliAccountingYear = form.down('#intellimaliAccountingYear');
		var brandCampusName = intellimaliBrandCampusName.getValue();
		var accountingYearId = intellimaliAccountingYear.getValue();
		var student = form.down('#student');
		var studentStore = student.getStore();
		var al = this.getAcademyLocationId(form);
			studentStore.getProxy().extraParams = {
				academyLocationIds :  al.join(),
				accountingYearId : accountingYearId
			};
			studentStore.load();
   },
   getAcademyLocationId: function(form) {
	   var intellimaliBrandCampusName = form.down('#intellimaliBrandCampusName');
	   var brandCampusName = intellimaliBrandCampusName.getValue();
	   var alData;
	   var acaloc = [];
		if(brandCampusName!="" && brandCampusName!=null){
			for(var i in brandCampusName){
				if(Ext.isObject(brandCampusName[0])){
 					alData = brandCampusName[i].get("id");
 					acaloc.push(alData);
 				}else{
 					alData = brandCampusName[i];
 					acaloc.push(alData);
 				}
			}
		}
		return acaloc;
   },
   
   getAcademyLocationForBursaryMaster: function(form) {
	   var bursaryBrandCampusName = form.down('#academyLocationCombo');
	   var academyLocation = bursaryBrandCampusName.getValue();
	   var alData;
	   var acaloc = [];
		if(academyLocation!="" && academyLocation!=null){
			for(var i in academyLocation){
				if(Ext.isObject(academyLocation[0])){
 					alData = academyLocation[i].get("id");
 					acaloc.push(alData);
 				}else{
 					alData = academyLocation[i];
 					acaloc.push(alData);
 				}
			}
		}
		return acaloc;
   },
   
    loadCombo: function(combo) {
        var store = combo.getStore();
        store.load();
    },

    /**
     * @method to show number of awardee form
     */
    cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        var searchResultGrid = this.getSearchResultGrid();
        var columnName = searchResultGrid.columnManager.columns[cellIndex].dataIndex;
        if (columnName == "NO_OF_AWARDEES") {
            var value = record.get(columnName);
            if (value > 0) {
                var me = this;
                me.showAwardeePopUp();
                var id = record.raw.ID;
                var grid = me.getNumberofAwardeeGrid();
                grid.down('#statusComboId').getStore().load();
                var refCombo = me.getNumberofAwardeeGrid().down("#statusComboId");
                var store = grid.getStore();
                store.getProxy().extraParams = {
                    'scholarshipId': id,
                    'status': refCombo.getValue()
                };
                store.load();

                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.SCHOLARSHIP_AWARDEE_FIND_AWARDEE_SUMMARY,
                    method: 'GET',
                    params: {
                        scholarshipId: id
                    },
                    success: function(res, action) {
                        var data = Ext.decode(res.responseText);
                        me.getAwardeeWindowForm().getForm().setValues(data);
                    }
                });
            }
        }
    },

    createJsonFormat: function(MasterForm) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        
        var academyLocationId = [];
		 Ext.Ajax.request({
				type : 'rest',
				url :SERVERURL.FIND_ASSIGNED_ACADEMY_LOCATION_IDS,
				method : 'GET',
				async: false,
				success : function(response) {
					var data = Ext.decode(response.responseText);
					for(var i=0; i< data.length ;i++){
						if(!isNullOrEmpty(data[i])){
							academyLocationId.push(data[i]);
						}
            	   }
				}
			});
        
		 var accessibleAcademyLocationIds =academyLocationId.join();
        
        values.configCode = CONSTANTS.CB.SCHOLARSHIP_MASTER_BASIC_CONFIGCODE;
        formValues = MasterForm.getValues();

        if (!isNullOrEmpty(formValues.SCHOLARSHIP_ID) && formValues.SCHOLARSHIP_ID !== undefined) {
            var SCHOLARSHIP_ID = this.getJsonObject('SCHOLARSHIP_ID', formValues.SCHOLARSHIP_ID);
            this.pushJsonObjectInArray(SCHOLARSHIP_ID, searchcriteria);
        }

        if (!isNullOrEmpty(formValues.SCHOLARSHIP_NAME) && formValues.SCHOLARSHIP_NAME !== undefined) {
            var SCHOLARSHIP_NAME = this.getJsonObject('SCHOLARSHIP_NAME', formValues.SCHOLARSHIP_NAME);
            this.pushJsonObjectInArray(SCHOLARSHIP_NAME, searchcriteria);
        }

        if (formValues.ORGANIZATION_NAME !== undefined) {
            var ORGANIZATION_NAME = this.getJsonObject('ORGANIZATION_NAME', formValues.ORGANIZATION_NAME);
            this.pushJsonObjectInArray(ORGANIZATION_NAME, searchcriteria);
        }

        if (formValues.AMOUNT_TYPE !== undefined) {
            var SCHOLARSHIP_AMOUNT_TYPE = this.getJsonObject('SCHOLARSHIP_AMOUNT_TYPE', formValues.AMOUNT_TYPE);
            this.pushJsonObjectInArray(SCHOLARSHIP_AMOUNT_TYPE, searchcriteria);
        }

        if (formValues.SCHOLARSHIP_STATUS !== undefined) {
            var status = false;
            if (formValues.SCHOLARSHIP_STATUS == 'Active') status = true;

            var SCHOLARSHIP_STATUS = this.getJsonObject('SCHOLARSHIP_STATUS',
            status);
            this.pushJsonObjectInArray(SCHOLARSHIP_STATUS,
            searchcriteria);
        }

        if (formValues.SCHOLARSHIP_TYPE !== undefined) {
            var SCHOLARSHIP_TYPE = this.getJsonObject('SCHOLARSHIP_TYPE', formValues.SCHOLARSHIP_TYPE);
            this.pushJsonObjectInArray(SCHOLARSHIP_TYPE, searchcriteria);
        }
        if (formValues.DISBURSMENT_MODE !== undefined) {
            var DISBURSMENT_MODE = this.getJsonObject('DISBURSMENT_MODE', formValues.DISBURSMENT_MODE);
            this.pushJsonObjectInArray(DISBURSMENT_MODE, searchcriteria);
        }

        if (formValues.ACADEMY_NAME !== undefined) {
            var ACADEMY_NAME = this.getJsonObjectFromArray('ACADEMY_NAME', formValues.ACADEMY_NAME);
            this.pushJsonObjectInArray(ACADEMY_NAME, searchcriteria);
        }

        if (formValues.LOCATION_NAME !== undefined) {
            var LOCATION_NAME = this.getJsonObjectFromArray('LOCATION_NAME', formValues.LOCATION_NAME);
            this.pushJsonObjectInArray(LOCATION_NAME, searchcriteria);
        }

        if (formValues.ACADEMY_LOCATION !== undefined && !isNullOrEmpty(formValues.ACADEMY_LOCATION) && formValues.ACADEMY_LOCATION.join()!=="") {
            var ACADEMY_LOCATION = this.getJsonObjectFromArray('ACADEMY_LOCATION', formValues.ACADEMY_LOCATION);
            this.pushJsonObjectInArray(ACADEMY_LOCATION, searchcriteria);
        }else{
        	var ACADEMY_LOCATION = this.getJsonObjectFromArray('ACADEMY_LOCATION', accessibleAcademyLocationIds);
            this.pushJsonObjectInArray(ACADEMY_LOCATION, searchcriteria);
            
            var WITHOUT_AL = this.getJsonObject('WITHOUT_AL', true);
            this.pushJsonObjectInArray(WITHOUT_AL, searchcriteria);
        }
        
        values.searchCriterias = searchcriteria;
        return values;
    },

    
    /**
     * Method to get the json Objects from the selected fields of the 
     * Search form
     * @author Akshay.Kalbhor
     */
    getJsonObject: function(key, rawvalue, additionalValue) {
        var value = rawvalue;
        if (rawvalue !== true && rawvalue !== false) {
            rawvalue = rawvalue.toString();
            value = rawvalue.trim();
        }

        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        } else if ((value === true || value === false) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if ((value === true || value === false) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    /**
     * Method to get the array of selected ids from the array of objects
     * @author Akshay.Kalbhor 
     */
    getJsonObjectFromArray: function(key, array) {
        var idArray = new Array();
        Ext.each(array, function(arrayObj) {
            if (arrayObj != "All" && arrayObj != "" && arrayObj instanceof Object) {
                idArray.push(arrayObj.getId());
            } else if (arrayObj != "All" && arrayObj != "") {
                idArray.push(arrayObj);
            }
        });

        return {
            "paramCode": key,
            "paramValues": idArray
        };
    },

    pushJsonObjectInArray: function(object, array) {
        if (object && !isNullOrEmpty(object.paramValues[0])) {
            array.push(object);
        }
    },

    gridRenderFunction: function(grid) {

        grid.addDocked({
            xtype: 'toolbar',
            itemId: 'functionButtonsToolbar',
            dock: 'top',
            items: [{
                xtype: 'button',
                itemId: 'searchResultGridBtnAdd',
                tooltip: getCommonTranslation('ADD'),
                iconCls:'icon-addbutton',
				 cls:'addbutton'
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnEdit',
                tooltip: getCommonTranslation('EDIT'),
                iconCls:'icon-editbutton',
				cls:'editbutton'
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnView',
                tooltip: getCommonTranslation('VIEW'),
                iconCls: 'icon-View',
				cls:'iconView'	
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnDelete',
                disabled: true,
                cls: 'CustomToolbarBtnReject',
                tooltip: getCommonTranslation('DELETE'),
                iconCls: 'icon-Delete',
				cls:'iconDelete'
            }, {
                xtype: 'button',
                itemId: 'searchResultGridMoreOperations',
                tooltip: getCommonTranslation('MORE_OPERATIONS'),
                text: getCommonTranslation('MORE_OPERATIONS'),
                menu: new Ext.menu.Menu({
                    items: [{
                        text: getCommonTranslation('ASSIGN_ALP_ENTITIES'),
                        itemId: 'assignProgEntities'
                    }]
                })
            }, '->', {
                xtype: 'splitbutton',
                itemId: 'exportToPdfBtn',
                cls: 'CustomToolbarBtnExport export-cls',
                iconCls: 'export-pdf-icon',
                menu: [{
                    text: 'Export Current Page',
                    itemId: 'exportCurrentPage'
                }, {
                    text: 'Export All',
                    itemId: 'exportAll'
                }],
                listeners: {
                    click: function() {
                        this.showMenu();
                    }
                }
            }, {
                xtype: 'splitbutton',
                itemId: 'exportToXcelBtn',
                cls: 'CustomToolbarBtnExport export-cls',
                iconCls: 'export-excel-icon',
                menu: [{
                    text: 'Export Current Page',
                    itemId: 'exportCurrentPage'
                }, {
                    text: 'Export All',
                    itemId: 'exportAll'
                }],
                listeners: {
                    click: function() {
                        this.showMenu();
                    }
                }
            }]
        });
    },

    /* to add scholarship form  */
    
    addScholarship: function() {
        var tabTitle = "Add Scholarship";
        this.showFormTab(tabTitle);
    },

    cancelAddScholarshipForm: function(formRef) {
        formRef.close();
    },

    showFormTab: function(tabTitle) {
        var contentXtype = 'addscholarship';
//        var menuColorcls=CONSTANTS.MENU_COLOR_TEN;
        var newTab = contentPanel.items.findBy(function(tab) {
            return tab.title === tabTitle;
        });
        if (!newTab) {
            newTab = contentPanel.add({
                xtype: contentXtype,
                closable: true,
                title: tabTitle,
                menuColorCls: CONSTANTS.MENU_COLOR_TEN
            });
        }
        return contentPanel.setActiveTab(newTab);
    },
    
    addScholarshipTabPanel: function(){
//    	alert('l')
    	var contentpanel = this$.getContentpanel();
    	var structure = Ext.widget('addscholarshiptab');
    	var tabName = 'Add Scholarship Tab';
    	var getcontroller=this$.getController('menu.CoreERPNavigationController');
    		 var getTab=getcontroller.getTab(getCommonTranslation('VIEW_SCHOLARSHIP'));
      	 if(getTab!=null){
      		 contentPanel.remove(getTab, true);
      	 }
      	 var getTab=getcontroller.getTab(getCommonTranslation('EDIT_SCHOLARSHIP'));
       	 if(getTab!=null){
       		 contentPanel.remove(getTab, true);
       	 }
    	openTab(contentpanel, tabName, structure, CONSTANTS.MENU_COLOR_FIVE);
    	this.getAddscholarshipmappingprogresstracker().setVisible(true);
        
//	  	  this.resetAddScholarshipProgressTracker();
	  	  var addscholarshipmappingprogresstracker = structure.down("#addscholarshipmappingprogresstracker");
	  	  var progresstracker1 = addscholarshipmappingprogresstracker.down("#progresstracker1");	  	  
	  	  progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
	  	  progresstracker1.textEl.addCls("inProgressCss-progress-text");
	  	  progresstracker1.updateText("Step 1 In Progress");
    },

    /**
     * method to open a new tab with passed form within it
     * @param {Object} windowReference: reference of the form that has to be opened.
     */
    openTab: function(tabTitle, contentXType) {
        var coreErpNavigationController = Academia.app.getController('menu.CoreERPNavigationController');
        coreErpNavigationController.addTab(tabTitle, contentXType);
    },

    /**
     * method to open a new tab with passed form within it
     * @param {Object} windowReference: reference of the form that has to be opened.
     */
    openTabAndSetValue: function(tabTitle, contentXtype, value,menuColorcls) {
    	contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var newTab = contentPanel.items.findBy(function(tab) {
    		return tab.title === tabTitle;
    	});
    	if (newTab) {
    		newTab.close();
    		newTab = false;
    	}
    	if (!newTab) {
    		newTab = contentPanel.add({
    			xtype: contentXtype,
    			closable: true,
    			menuColorCls: menuColorcls,
    			title: tabTitle
    		});
    	}
    	Ext.apply(newTab, {
    		"scholarshipId": value
    	});
    	contentPanel.setActiveTab(newTab);
    	return newTab;
    },

    editScholarship: function(isView) {
    	var this$$ = this;
    	var grid = this$$.getSearchResultGrid();
    	var openScholarTab;
    	viewMode=false;    //used on AddScholarship.js
    	if(this.getAddScholarshipForm()){
    		var isEditOPenVal = this.getAddScholarshipForm().config.isEditOpen
    	}
    	
    	if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection()[0];
    		var tabName = null;
    		if (isView) {
    			tabName = getCommonTranslation('VIEW_SCHOLARSHIP');
    			if(isEditOPenVal) {
    				openScholarTab = getCommonTranslation('EDIT_SCHOLARSHIP');
    			}else if(isEditOPenVal == undefined && isView ==true){
    				 openScholarTab = getCommonTranslation('VIEW_SCHOLARSHIP');
    			}else{
    				 openScholarTab = getCommonTranslation('VIEW_SCHOLARSHIP');
    			}
    			
    			
    		} else {
    			tabName = getCommonTranslation('EDIT_SCHOLARSHIP');
    			if(isEditOPenVal){
    				 openScholarTab = getCommonTranslation('EDIT_SCHOLARSHIP');
    			}else if(isEditOPenVal == undefined && isView ==false){
    				openScholarTab = getCommonTranslation('EDIT_SCHOLARSHIP');
    				
    			}else{
    				openScholarTab = getCommonTranslation('VIEW_SCHOLARSHIP');
    			}
    		}
    		
    		var getcontroller=this.getController('menu.CoreERPNavigationController');
       	    var getTab=getcontroller.getTab(openScholarTab);
	       	 if(getTab!=null){
	       		 contentPanel.remove(getTab, true);
	       	 }

    		var addScholarshipFormWindow = this$$.showFormTab(tabName);
    		addScholarshipFormWindow.down('#resetButtonId').setVisible(false);
    		var feeHeadsPanel =addScholarshipFormWindow.down('#feeHeadsPanel');
    		
    		var ScholarshipTypeCombo = addScholarshipFormWindow.down("combo#ScholarshipTypeId");
			ScholarshipTypeCombo.setReadOnly(true);
			var disbursementMode = addScholarshipFormWindow.down('combo#disbursementMode');
			disbursementMode.setReadOnly(true);
			var currencyId = addScholarshipFormWindow.down("combo#currencyId");
			currencyId.setReadOnly(true);
    		setTimeout(function(){
    			if (isView) {
    				viewMode=true;   //used on AddScholarship.js
    				this$$.hideToolbar();
    				this$$.getAddScholarshipForm().config.isEditOpen = false;
    	    		
    				
    				feeHeadsPanel.items.items[0].down('#addFeeHeadBtn').disable();
    				this$$.toggleReadOnlyFormItems(addScholarshipFormWindow.getForm(), true);

    				var refPaymentType = addScholarshipFormWindow.down("combo#paymentId");
    				refPaymentType.readOnly = true;
    				var appMode = addScholarshipFormWindow.down('combo#appModeId');
    				appMode.readOnly = true;
    				var selectionType = addScholarshipFormWindow.down('combo#selTypeId');
    				selectionType.readOnly = true;
    				var disbursementMode = addScholarshipFormWindow.down('combo#disbursementMode');
    				disbursementMode.readOnly = true;
    				addScholarshipFormWindow.down('#addScholarshipBtn').setVisible(false);
    				var currencyId = addScholarshipFormWindow.down("combo#currencyId");
    				currencyId.readOnly = true;
    			} else {
    				this$$.getAddScholarshipForm().config.isEditOpen = true;
    	    		
    				//Code to hide fields in edit mode. as per the request by Nitin
    				
    			}},500);
    		var id = record.raw.ID;

    		this$$.getScholarshipDetails(tabName).getForm().setValues({
    			id: id
    		});
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.SCHOLARSHIP_URL,
    			method: 'GET',
    			params: {
    				id: id
    			},
    			success: function(res, action) {
    				var data = Ext.decode(res.responseText);
    				var grid = addScholarshipFormWindow.down('periodsgrid');
    				this$$.loadScholarshipDetailsForm(data, tabName);
    				this$$.disableValidity(data.paymentType, null, this$$);
    				//TODO: Add component as the third param
    				//this$$.disableScholarshipPaymentType(data.scholarshipAmountType, this$$);
    				this$$.disableAdjustment(data.disbursementMode, this$$, null);
    				this$$.changeMode(data.scholarshipType, this$$);
    				this$$.hideGridPanel(data);
    				var organizationCombo = this$$.getFormAddscholarship().down('#organizationCmb');
    				if (organizationCombo) {
    					organizationCombo.getStore().load({
    						params: {
    							organizationType: data.scholarshipType
    						},
    						callback: function() {
    							organizationCombo.setValue(data.organizationId);
    						}
    					});
    				}
    				var store = grid.getStore();
    				store.loadData(data.scholarshipInstallments);
    				feeHeadsPanel.config.scholarshipHeadIdArray =[];
    				// to Add Fee Heads 


    				Ext.Ajax.request({
    					type: 'rest',
    					async: false,
    					url: SERVERURL.COMMON_FORM_FIELD_INFO,
    					params: {
    						//screenName: 'Manage Receipt',
    						academyLocationId: this$$.getCurrentAcademyLocation(),
    						languageCode:'en'
    					},
    					method: 'GET',
    					success: function(res, action) {
    						var response = Ext.decode(res.responseText);

    						if( Object.keys(response).length > 0 ){
    							var records=response.addscholarship;
    							if(records){
    								if(records[0].isVisible == true){
        								if(data.scholarFeeHeads.length>0){
        									for(var i =0; i< data.scholarFeeHeads.length ;i++){
        										if(i !=0){
        											this$$.addFeeHeadsForScholarship("edit",feeHeadsPanel);
        										}
        										var value = data.scholarFeeHeads[i];

        										var feeHeadsPanelContainer=feeHeadsPanel.items.items[i];
        										feeHeadsPanelContainer.items.items[0].setValue(value.feeHead.id);
        										feeHeadsPanelContainer.items.items[1].setValue(value.amountType);
        										//feeHeadsPanelContainer.items.items[2].setValue(value.feeAmount);
        										feeHeadsPanel.config.scholarshipHeadIdArray.push(value.id);
        										if(isView){
        											feeHeadsPanelContainer.items.items[0].setReadOnly(true);
        											feeHeadsPanelContainer.items.items[1].setReadOnly(true);
        											feeHeadsPanelContainer.items.items[2].setReadOnly(true);
        											feeHeadsPanelContainer.items.items[3].disable();
        										}
        									}

        								}
        								setTimeout(function(){
        									if(data.scholarFeeHeads.length>0){
        										for(var i =0; i< data.scholarFeeHeads.length ;i++){
        											var value = data.scholarFeeHeads[i];
        											var feeHeadsPanelContainer=feeHeadsPanel.items.items[i];    
        											if(value.amountType == "PERCENTAGE") {
        											    feeHeadsPanelContainer.items.items[2].setRawValue(value.feeHeadPercentageValue);
        											}else{
        											    feeHeadsPanelContainer.items.items[2].setRawValue(value.feeAmount);
        											} 
        										}

        									}
        								},600);


        							}else{
        								if(data.scholarFeeHeads.length>0){
        									var feeHeadsPanelContainer=feeHeadsPanel.items.items[0];
        									feeHeadsPanelContainer.items.items[0].allowBlank =true;
        									feeHeadsPanelContainer.items.items[1].allowBlank =true;
        									feeHeadsPanelContainer.items.items[2].allowBlank =true;
        								}

        							}
    							}else{
    								if(data.scholarFeeHeads.length>0){
    									for(var i =0; i< data.scholarFeeHeads.length ;i++){
    										if(i !=0){
    											this$$.addFeeHeadsForScholarship("edit",feeHeadsPanel);
    										}
    										var value = data.scholarFeeHeads[i];

    										var feeHeadsPanelContainer=feeHeadsPanel.items.items[i];
    										feeHeadsPanelContainer.items.items[0].setValue(value.feeHead.id);
    										feeHeadsPanelContainer.items.items[1].setValue(value.amountType);
    										//feeHeadsPanelContainer.items.items[2].setValue(value.feeAmount);
    										feeHeadsPanel.config.scholarshipHeadIdArray.push(value.id);
    										if(isView){
    											feeHeadsPanelContainer.items.items[0].setReadOnly(true);
    											feeHeadsPanelContainer.items.items[1].setReadOnly(true);
    											feeHeadsPanelContainer.items.items[2].setReadOnly(true);
    											feeHeadsPanelContainer.items.items[3].disable();
    										}
    									}

    								}
    								setTimeout(function(){
    									if(data.scholarFeeHeads.length>0){
    										for(var i =0; i< data.scholarFeeHeads.length ;i++){
    											var value = data.scholarFeeHeads[i];
    											var feeHeadsPanelContainer=feeHeadsPanel.items.items[i];    
    											if(value.amountType == "PERCENTAGE") {
    											    feeHeadsPanelContainer.items.items[2].setRawValue(value.feeHeadPercentageValue);
    											}else{
    											    feeHeadsPanelContainer.items.items[2].setRawValue(value.feeAmount);
    											} 
    										}

    									}
    								},600);
    							}
    							setTimeout(function(){
    							var form =	addScholarshipFormWindow;
    							var saveBtn =form.down('#addScholarshipBtn');
    							if(form.isValid){
    								saveBtn.enable();
    							}else{
    								saveBtn.disable();
    							}
    							},1000);
    							
    						}
    					}
    				});

    				store.fireEvent('refresh');
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },

    hideGridPanel: function(data) {
        var ref = this;
        var periodPanel = ref.getPeriodsForm();
        if (data.paymentType === 'OT') {

            periodPanel.setVisible(false);
        } else {

            periodPanel.setVisible(true);
        }
    },

    hideToolbar: function() {
        var ref = this;
        var periodPanel = ref.getPeriodsForm();
        var items = periodPanel.down('grid').getDockedItems('toolbar');
        for (var i = 0; i < items.length; i++) {
            items[i].setVisible(false);
        }
    },

    loadScholarshipDetailsForm: function(data, tabName) {

        if (data) {
            var form = this.getScholarshipDetails(tabName).getForm();
            form.setValues(data);
            if(!isNullOrEmpty(data.scholarshipValidFrom)) {
            	form.findField('scholarshipValidFrom').setValue(dateRender(data.scholarshipValidFrom));
            }
            if(!isNullOrEmpty(data.scholarshipValidTill)) {
            	form.findField('scholarshipValidTill').setValue(dateRender(data.scholarshipValidTill));
            }
			if(!isNullOrEmpty(data.applicationStartDate)) {
				form.findField('applicationStartDate').setValue(dateRender(data.applicationStartDate));
			}
			if(!isNullOrEmpty(data.applicationEndDate)) {
				form.findField('applicationEndDate').setValue(dateRender(data.applicationEndDate));
			}
			if(!isNullOrEmpty(data.applicationRequired)) {
				form.findField('applicationRequired').setValue({applicationRequired:data.applicationRequired});
			}
			if(!isNullOrEmpty(data.darScholarship)) {
				form.findField('darScholarship').setValue({darScholarship:data.darScholarship});
			}
			if(!isNullOrEmpty(data.allowApplicationAfterEndDate)) {
				form.findField('allowApplicationAfterEndDate').setValue({allowApplicationAfterEndDate:data.allowApplicationAfterEndDate});
			}
			if(!isNullOrEmpty(data.coversOldDebt)) {
				form.findField('coversOldDebt').setValue({coversOldDebt:data.coversOldDebt});
			}
			if(!isNullOrEmpty(data.allocateBalanceOn)) {
				form.findField('allocateBalanceOn').setValue({allocateBalanceOn:data.allocateBalanceOn});
			}
        }
    },

    getScholarshipDetails: function(tabTitle) {
        var menuController = this.getMenuController();
        var tabRef = menuController.getTab(tabTitle);
        return tabRef;
    },

    // to add period form into grid
    addPeriod: function(btn) {
        var periodFormWindow = this.getWinAddPeriodForm();
        if (!periodFormWindow) {
            periodFormWindow = Ext.widget('addperiodformWindow');
        }
        /*
         * Check to verify the number of periods already added in the grid.
         * if the number of periods added is less than the Validity(in Months) then only allow adding/showing of the add period form
         * else do not allow adding of the period.
         */
        if (this.adhocIntervalCheck(btn)) {
            periodFormWindow.down('numberfield#periodAmount').setDisabled(true);
            periodFormWindow.show();
        } else {
            periodFormWindow.show();
        }
    },

    /**
     * function to check if the AmountType is Adhoc and Payment Type is Interval
     * then the amount field should be disabled in the addPeriod form.
     * 
     * returns {boolean} true if the AmountType is Adhoc and Payment Type is Interval
     * false if !(AmountType is Adhoc and Payment Type is Interval)
     */
    adhocIntervalCheck: function(btn) {
        var periodsGrid = btn.up('panel[xtype=periodsgrid]');
        var addScholarshipForm = periodsGrid.up('panel[xtype=addscholarship]');
        var amountTypeCombo = addScholarshipForm.down('combo#amountTypeId');
        var paymentTypeCombo = addScholarshipForm.down('combo#paymentId');

        var returnValue = null;
        if (amountTypeCombo.getValue() == "ADH" && paymentTypeCombo.getValue() == "IRL") {
            returnValue = true;
        } else {
            returnValue = false;
        }
        return returnValue;
    },

    showAwardeePopUp: function() {
        var awardeeWindow = this.getAwardeeWindow();
        if (!awardeeWindow) {
            awardeeWindow = Ext.widget('numberofawardeewindow');
        }
        awardeeWindow.show();
    },

    showWindow: function(windowReference) {
        var formWindow = Ext.widget(windowReference);
        formWindow.show();
        return formWindow;
    },

    editPeriod: function(btn, isView) {
        var me = this;
        var grid = btn.up('grid[xtype=periodsgrid]');
        if (grid.getSelectionModel().getCount() > 0) {
            var periodWindow = me.showWindow('addperiodformWindow');
            periodWindow.setTitle(getCommonTranslation('EDIT_PERIOD'));
            var record = grid.getSelectionModel().getSelection()[0];
            if (!isNullOrEmpty(record)) {
                var addPeriodFormVar = periodWindow.down('panel#addPeriodForm');
                /* 
                 * Mantis#11695
                 * check if the scholarship is adhoc.
                 * if true then disable the amount field
                 */
                if(this.checkIfAdhocScholarship()) {
                	addPeriodFormVar.down('numberfield#periodAmount').setDisabled(true);
                	delete record.data.amount;
                }
                addPeriodFormVar.loadRecord(record);
                if (isView) {
                    periodWindow.setTitle(getCommonTranslation('VIEW_PERIOD'));
                    periodWindow.down('#btnSaveAddPeriodForm').setVisible(false);
                    toggleReadOnlyFormItems(addPeriodFormVar.getForm(), true);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     * @author Akshay.Kalbhor
     * method to check if the scholarship type is adhoc.
     */
    checkIfAdhocScholarship: function() {
    	var addScholarshipTab = this.getActiveTabfromContentPanel();
    	var amountType =addScholarshipTab.down('combo#amountTypeId');
    	if(amountType.getValue() == "ADH") {
    		return true;
    	} else {
    		return false;
    	}
    },

    deletePeriod: function(btn) {
        var grid = this.getPeriodsGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('DELETE_PERIOD'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection();
                    for (var count = 0; count < records.length; count++) {
                        grid.getStore().remove(records[count]);
                    }
                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_PERIOD_FORM_MSG'));
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /*
     * This function is used for to save period form Details after clicking on save button    
     */
    saveAddPeriod: function(button) {
        var frmAddPeriodForm = button.up('form#addPeriodForm');
        var addScholarshipFormRef = this.getActiveTabfromContentPanel();
        var periodGrid = addScholarshipFormRef.down('panel[xtype=periodsgrid]');
        var refPeriodStore = periodGrid.getStore();
        var value = frmAddPeriodForm.getValues();
        var loadedRecord = new Academia.model.scholarship.PeriodModel(value);

        var client_Id = loadedRecord.get('client_Id');
        var server_Id = loadedRecord.get('id');

        if (isNullOrEmpty(server_Id)) {
        	//Client Side 
            if (client_Id == 0) {
            	//Client Side Add Case
                if (refPeriodStore.getCount() == 0) {
                    client_Id = 1;
                } else {
                    var record = refPeriodStore.last();
                    if (!isEmpty(record)) {
                        client_Id = record.get('client_Id') + 1;
                    }
                }
                loadedRecord.set('client_Id', client_Id);
                refPeriodStore.add(loadedRecord);
                showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADD_PERIOD_MSG'));
            } else {
            	//Client Side update Case
                if (periodGrid.getSelectionModel().getCount() > 0) {
                    var records = periodGrid.getSelectionModel().getSelection();
                    if (!isEmpty(records[0].data)) {
                        Ext.each(loadedRecord.fields.items, function(field) {
                            records[0].set(field.name, loadedRecord.get(field.name));
                        });
                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATE_PERIOD_MSG'));
                    }
                }
            }
        } else {
        	//Server Side Edit Case
            if (periodGrid.getSelectionModel().getCount() > 0) {
                var records = periodGrid.getSelectionModel().getSelection();
                if (!isEmpty(records[0].data)) {
                    Ext.each(loadedRecord.fields.items, function(field) {
                        records[0].set(field.name, loadedRecord.get(field.name));
                    });
                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATE_PERIOD_MSG'));
                }
            }
        }

        refPeriodStore.commitChanges();
        this.getWinAddPeriodForm().close();
    },

    /*
     * This function is used for to close Add Period Details Dialog box after clicking on cancel button   
     */
    cancelAddPeriod: function() {
        this.getWinAddPeriodForm().close();
    },

    /* function to add scholarship form for save button */
    SaveAddScholarshipForm: function(btn) {
        var this$ = this;
        var addScholarshipTab = btn.up('panel[xtype=addscholarship]');
        //var refAddScholarshipForm = addScholarshipTab.down('idgeneratorform');
        var refAddScholarshipForm =btn.up('form');
        var ResultGrid = this.getSearchResultGrid();

        var addFormRef = this.getAddScholarshipForm();
        var addAmountRef = refAddScholarshipForm.down("#amountId");
        var paymentType = refAddScholarshipForm.down("#paymentId");
        var feeHeadPanel =addFormRef.down('#feeHeadsPanel');
        var submitUrl, isUpdate = false;
        var addScholarshipField = refAddScholarshipForm.down('#Id_hidden_field');
        if (isNullOrEmpty(addScholarshipField.getSubmitValue()) || addScholarshipField.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.ADD_SCHOLARSHIP_CREATE,
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.ADD_SCHOLARSHIP_UPDATE,
            isUpdate = true;
        };
        // to retrive data from add scholarship form
        var formData = refAddScholarshipForm.getValues();

        // to retrieve data from grid
        var datar = new Array();
        if((refAddScholarshipForm.config.feeHeadVisibility || feeHeadPanel.items.items.length >= 1) && formData.scholarshipAmountType !="ADH") {
        	 var scholarShipHeadArr =new Array();
             var totalAMountOfFeeHead =0;
           
        	 if(feeHeadPanel.items.items.length> 1){
             	var feeHeadPanelLength = feeHeadPanel.items.items.length;
             	var feeHeadItems =feeHeadPanel.items.items;
             	for(var i=0; i< feeHeadPanelLength;i++ ){
             		 var obj = new Object();
             		 if(isUpdate) {
             			 obj.id= feeHeadPanel.config.scholarshipHeadIdArray[i];
                           
             		 }
             		 else{
             			 obj.id= null;
                          
             		 }
             		  obj.feeHead = {
             				  id:this$.getIdValueJson(formData["feeHeads"][i]).id
             		  }
             		  obj.amountType =this$.getIdValueJson(formData["amountOrPercentage"][i]).id
             		  
             		  if(obj.amountType == "PERCENTAGE"){
             			 
             			var totalAmt = parseInt(formData.amount);
       					var remainingAmt =totalAmt-totalAMountOfFeeHead;
       					var feeAmtVal =parseInt(formData["feeAmounts"][i]);
       					var remainingAmtOfFeeHead= remainingAmt* feeAmtVal/100;
       					
       					
       					obj.feeHeadPercentageValue =parseInt(formData["feeAmounts"][i]);  
       				    obj.feeAmount =remainingAmtOfFeeHead
           			
             		  }else{
             			  obj.feeHeadPercentageValue =null
             			  obj.feeAmount =parseInt(formData["feeAmounts"][i]);
             			  totalAMountOfFeeHead = totalAMountOfFeeHead+parseInt(formData["feeAmounts"][i]); 
             		  }
             		  scholarShipHeadArr.push(obj);
             	}
             }else{
             	 var obj = new Object();
             	 if(isUpdate) {
         			 obj.id= feeHeadPanel.config.scholarshipHeadIdArray[0];
                       
         		 }
         		 else{
         			 obj.id= null;
                      
         		 }
             	 if(!isNullOrEmpty(formData["feeHeads"])){
             		 obj.feeHead = {
            				  id:this$.getIdValueJson(formData["feeHeads"]).id
            		  } 
             	 }
             	 if(!isNullOrEmpty(formData["amountOrPercentage"])){
             		 obj.amountType =this$.getIdValueJson(formData["amountOrPercentage"]).id
             	 }
         		  
         		  if(obj.amountType == "PERCENTAGE"){
         			 
         			var totalAmt = parseInt(formData.amount);
     					var remainingAmt =totalAmt-totalAMountOfFeeHead;
     					var feeAmtVal =parseInt(formData["feeAmounts"]);
     					var remainingAmtOfFeeHead= remainingAmt* feeAmtVal/100;
     					
     					
     					obj.feeHeadPercentageValue =parseInt(formData["feeAmounts"]);  
     				    obj.feeAmount =remainingAmtOfFeeHead

         		  }else{
         			  obj.feeHeadPercentageValue =null
         			  
         			  if(!isNullOrEmpty(formData["feeAmounts"])){
         				  obj.feeAmount =parseInt(formData["feeAmounts"]);
         			  }else{
         				  obj.feeAmount =0.0;
         			  }
         			  
         			  totalAMountOfFeeHead = totalAMountOfFeeHead+parseInt(formData["feeAmounts"]); 
         		  }
         		  scholarShipHeadArr.push(obj);
             }
        }else{
        	scholarShipHeadArr =[];
        }
       
    	if(!isNullOrEmpty(formData.ownerIds)){
    		var OwnersJsonArry = [];
    		if(typeof formData.ownerIds == "object"){
        		Ext.each(formData.ownerIds, function(currentOwner){
                	var mainObj = '';
                    if(!isNullOrEmpty(currentOwner)){
                    	if(typeof currentOwner == "object") {
		                	mainObj = {
		                			"owner" : {
		                					"id" : currentOwner.data.id
		                			}	
		                	}
                    	} else {
                    		mainObj = {
		                			"owner" : {
		                					"id" : currentOwner
		                			}	
		                	}
                    	}
                	OwnersJsonArry.push(mainObj);
                    }
                });
    		}
    		else{
            	var mainObj = '';
            	mainObj = {
            			"owner" : {
            					"id" : formData.ownerIds
            			}		
            	}
            	OwnersJsonArry.push(mainObj);
    		}
    		formData.scholarshipOwners = OwnersJsonArry;
    	}
    	if(isNullOrEmpty(formData.costCentreId)) {
    		delete formData.costCentreId;
    	}
    	if(isNullOrEmpty(formData.financingInstitutionId)) {
    		delete formData.financingInstitutionId;
    	}
    	if(isNullOrEmpty(formData.fundType)) {
    		delete formData.fundType;
    	}
    	if(isNullOrEmpty(formData.graduateLevel)) {
    		delete formData.graduateLevel;
    	}
    	if(isNullOrEmpty(formData.purpose)) {
    		delete formData.purpose;
    	}
        
    	delete formData.ownerIds;
        delete formData.amountOrPercentage;
        delete formData.feeAmounts;
        delete formData.feeHeads;
        var store = addScholarshipTab.down('periodsgrid').getStore();
        if (paymentType.getValue()=="IRL" && store.getCount() == 0) {
        	 showWarningMessage(getCommonTranslation('ADD_SCHOLARSHIP'), getCommonTranslation('PLEASE_ENTER_PERIODS'));
        } else {
        	var records = store.getRange();
            for (var i = 0; i < records.length; i++) {
                datar.push(records[i].data);
            }
            // to delet client id from grid records
            for (var i = 0; i < datar.length; i++) {
                delete datar[i].client_Id;
            }
         
            formData.scholarshipInstallments = datar;
            formData.scholarshipFeeHeads =scholarShipHeadArr;
            jsonDataEncode = Ext.encode(formData);
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
          
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: jsonDataEncode,
                method: 'POST',

                success: function(form, action) {
                	  Ext.getBody().unmask();
                    this$.loadGridAndSearchUsers();
                    ResultGrid.getStore().reload();
                    this$.cancelAddScholarshipForm(addScholarshipTab);
                    ResultGrid.getSelectionModel().deselectAll(true);

                    if (isUpdate) {
                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATE_SCHOLARSHIP_MSG'));
                    } else {
                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADD_SCHOLARSHIP_MSG'));
                    }
                }

            });
        }

    },

    deleteScholarship: function() {
        var grid = this.getSearchResultGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('DELETE_SCHOLARSHIP'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection()[0];
                    var id = records.data.ID;

                    Ext.Ajax.request({
                        type: 'rest',
                        method: 'DELETE',
                        url: SERVERURL.SCHOLARSHIP_DELETE + '?id=' + id,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                            grid.getStore().reload();
                            showSuccessMessage(getCommonTranslation('DELETE_SCHOLARSHIP'), getCommonTranslation('SCHOLARSHIP_DELETE_SUCCESS'));
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('DELETE_SCHOLARSHIP'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    disableValidity: function(paymentTypeData, combo, me) {
        var refaddScholarship = null;
        var refPeriodPanel = null;
        if (isNullOrEmpty(combo)) {
            refaddScholarship = me.getAddScholarshipForm();
            refPeriodPanel = me.getFormAddscholarship();
        } else {
            refaddScholarship = combo.up('idgeneratorform#addscholarshipform');
            refPeriodPanel = combo.up('panel[xtype=addscholarship]');
        }
        var refValidity = refaddScholarship.down("#validityId");
        var refPeriodsForm = refPeriodPanel.down("#PeriodsFormId");
        refValidity = this.getContentPanelActiveTab().down('#validityId');
        if (paymentTypeData === 'OT') {
            refValidity.setDisabled(true);
            refValidity.setValue(0);
            refPeriodsForm.setVisible(false);
        } else {
            refValidity.setDisabled(false);
            refValidity.fireEvent('validitychange');
            var periodsGrid = refPeriodsForm.down('panel[xtype=periodsgrid]');
            periodsGrid.getStore().removeAll();
            refPeriodsForm.setVisible(true);
        }
    },

   /* disableScholarshipPaymentType: function(amountTypeData, me) {
        var refaddScholarship = this.getAddScholarshipForm();
        var refPaymentType = refaddScholarship.down("#paymentId");
        var refPeriodPanel = this.getFormAddscholarship();
        var refValidity = refaddScholarship.down("#validityId");
        var refPeriodsForm = refPeriodPanel.down("#PeriodsFormId");
        if (amountTypeData === 'ADH') {
            var store = refPaymentType.getStore();
            var foundRecInd = store.findBy(function(record) {
                if (record.data.id == 'OT') {
                    return true;
                }
            });
            var foundRec = store.getAt(foundRecInd);
            refPaymentType.setValue(foundRec.data.id);
            refPaymentType.readOnly = true;

            refValidity.setDisabled(true);
            refPeriodsForm.setVisible(false);
        } else {
            if (refPaymentType.value === 'OT') {
                var store = refPaymentType.getStore();
                var foundRecInd = store.findBy(function(record) {
                    if (record.data.id == 'OT') {
                        return true;
                    }
                });
                var foundRec = store.getAt(foundRecInd);
                refPaymentType.setValue(foundRec.data.id);
                refPaymentType.setReadOnly(false);
                refValidity.setDisabled(true);
                refPeriodsForm.setVisible(false);
            } else {
                refPaymentType.setReadOnly(false);
                refValidity.setDisabled(false);
                refPeriodsForm.setVisible(true);
            }
        }
    },*/

    disableAdjustment: function(selectionData, me, combo) {
        var refaddScholarship = null;
        if (isNullOrEmpty(combo)) {
            refaddScholarship = this.getAddScholarshipForm();
        } else {
            refaddScholarship = combo.up('panel[xtype=addscholarship]');
        }

        var refAdjustment = refaddScholarship.down("#AdjustmentAllowed");
        if (selectionData === 'ACD') {
            refAdjustment.enable(true);
        } else {
            refAdjustment.disable(true);
        }
    },

    changeMode: function(scholarshipTypeData, me, component) {
        var this$ = this;
        var refaddScholarship = null;
        if(component != undefined) {
        	refaddScholarship = component.up('panel[xtype=addscholarship]');	
        } else {
        	refaddScholarship = this.getActiveTabfromContentPanel();
        }
        var refAppMode = refaddScholarship.down("#appModeId");
        var refSelType = refaddScholarship.down("#selTypeId");
        var refDisMode = refaddScholarship.down("#disbursementMode");
        //tODO: First select the Scholarship Type as external, then select the Disbursent mode as Direct => It will disable the "allow adjustment checkbox"
        //now change the scholarship type to Internal, This will Set the disbursementMode to Through Academy, But the Allow Adjustment checkbox is not enabled.
        var adjustmentCheckbox = refaddScholarship.down("#AdjustmentAllowed");

        if (scholarshipTypeData === 'INT') {
            this$.setAppModelValue(refAppMode, 'INS');
            this$.setAppModelValue(refSelType, 'ACD');
            this$.setAppModelValue(refDisMode, 'ACD');
            refAppMode.setReadOnly(true);
            refSelType.setReadOnly(true);
            refDisMode.setReadOnly(true);
        } else {
            refAppMode.setReadOnly(false);
            refSelType.setReadOnly(false);
            refDisMode.setReadOnly(false);
            // adjustmentCheckbox.enable();
        }
    },

    setAppModelValue: function(combo, value) {
        var this$ = this;
        var store = combo.getStore();
        if (!store.items) {
            store.load({
                callback: function(records, operation, success) {
                    if (success) {
                        this$.setAppModeValue(combo, value);
                    }
                }
            });
        } else {
            this$.setAppModeValue(combo, value);
        }
    },

    setAppModeValue: function(combo, value) {
        var store = combo.getStore();
        var foundRecInd = store.findBy(function(record) {
            if (record.data.id == value) {
                return true;
            }
        });
        var foundRec = store.getAt(foundRecInd);
        combo.setValue(foundRec.internalId);
    },

    disableOtherFilter: function(cmp, e, eOpts) {
        var searchFormRef = this.getScholarshipMasterForm();
        var refScholarshipId = searchFormRef.down("#scholMaster_scholId");
        var refScholarshipName = searchFormRef.down("#scholMaster_scholName");
        var statusCombo = searchFormRef.down("#scholMaster_status");
        var amountType = searchFormRef.down("#scholMaster_amountType");
        var scholType = searchFormRef.down("#scholMaster_scholType");
        var refOrganization = searchFormRef.down("#scholMaster_organisation");
        var refDisbursementMode = searchFormRef.down("#scholMaster_disbursmentMode");
        var academyCombo = searchFormRef.down('#academyCombo');
        var locationCombo = searchFormRef.down('#locationCombo');

       /* if (cmp.itemId === 'scholMaster_scholId') {
            refScholarshipName.disable(true);
            refOrganization.disable(true);

        } else if (cmp.itemId === 'scholMaster_scholName') {
            refScholarshipId.disable(true);
            refOrganization.disable(true);
        } else if (cmp.itemId === 'scholMaster_organisation') {
            refScholarshipName.disable(true);
            refScholarshipId.disable(true);
        }

         Common fields to be disabled irrespective of the fields 
        statusCombo.disable(true);
        amountType.disable(true);
        scholType.disable(true);
        refDisbursementMode.disable(true);
        academyCombo.setDisabled(true);
        locationCombo.setDisabled(true);

        if (refScholarshipId.value === "" || refScholarshipName.value === "") {
            refScholarshipId.enable(true);
            refScholarshipName.enable(true);
            refOrganization.enable(true);
            statusCombo.enable(true);
            amountType.enable(true);
            scholType.enable(true);
            refDisbursementMode.enable(true);
            academyCombo.enable(true);
            locationCombo.enable(true);
        }*/
    },

    /**
     * This function is used to calculate total amount of grid
     */
    calculateTotalAmount: function(periodsGrid, id, cilentId) {
        var records = periodsGrid.getStore();
        var data = records.data.items;
        var Total = 0;
        for (var i = 0; i < data.length; i++) {
        	if(isNullOrEmpty(id) && isNullOrEmpty(cilentId)){
        		Total = Total + parseInt(data[i].data.amount);
        	}else if(!isNullOrEmpty(id)){
        		if (data[i].data.id != id) {
                    Total = Total + parseInt(data[i].data.amount);
                }
        	}else if(!isNullOrEmpty(cilentId)){
        		if (data[i].data.client_Id != cilentId) {
                    Total = Total + parseInt(data[i].data.amount);
                }
        	}
            
        }
        return Total;
    },

    /**
     * This function is used to calculate total duration of grid
     * Club with "calculateTotalAmoun" by making it parameterised.
     */
    calculateTotalDuration: function(periodsGrid, id, cilentId) {
        var records = periodsGrid.getStore();
        var data = records.data.items;
        var Total = 0;
        for (var i = 0; i < data.length; i++) {
        	if(isNullOrEmpty(id) && isNullOrEmpty(cilentId)){
        		Total = Total + parseInt(data[i].data.durationInMonth);
        	}else if(!isNullOrEmpty(id)){
        		if (data[i].data.id != id) {
        			Total = Total + parseInt(data[i].data.durationInMonth);
                }
        	}else if(!isNullOrEmpty(cilentId)){
        		if (data[i].data.client_Id != cilentId) {
        			Total = Total + parseInt(data[i].data.durationInMonth);
                }
        	}
        }
        return Total;
    },

    /**
     * Method to check if the amount added in all the periods is equal to or less than the Amount that is sponsored.
     */
    checkAmount: function(cmp) {
        var idField = cmp.up('window[xtype=addperiodformWindow]').down('hidden#PeriodId');
        var cilentIdField = cmp.up('window[xtype=addperiodformWindow]').down('hidden#period_client_Id');
        var id = idField.getValue();
        var cilentId = cilentIdField.getValue();
        var addFormRef = this.getActiveTabfromContentPanel();
        var periodsGrid = addFormRef.down('panel[xtype=periodsgrid]');
        var addAmountRef = addFormRef.down("#amountId");
        var totalSponsoredAmount = null;
        if (isNullOrEmpty(addAmountRef.getValue()) || addAmountRef.getValue() == "") {
            totalSponsoredAmount = 0;
        } else {
            totalSponsoredAmount = parseInt(addAmountRef.getValue());
        }
        var periodForm = this.getFrmAddPeriodForm();
        var periodAmount = 0;
        var periodAmountRef = periodForm.down("#periodAmount");

        periodAmountRef.setMaxValue(totalSponsoredAmount);
        periodAmount = periodAmountRef.getValue();
        var subtotal = this.calculateTotalAmount(periodsGrid, id, cilentId);
        var total = periodAmount + subtotal;

        if (total > totalSponsoredAmount || totalSponsoredAmount == 0) {
            if (totalSponsoredAmount == 0) {
                showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('PLEASE_ENTER_BASE_AMOUNT'));
            } else {
                showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('PLEASE_ENTER_VALID_AMOUNT'));
            }
            cmp.reset();
        }
    },

    /**
     * Method to check if the Duration added in all the periods is equal to or less than the Duration of the Scholarship.
     * @author Akshay.Kalbhor
     */
    checkDuration: function(cmp) {
        var idField = cmp.up('window[xtype=addperiodformWindow]').down('hidden#PeriodId');
        var cilentIdField = cmp.up('window[xtype=addperiodformWindow]').down('hidden#period_client_Id');
        var id = idField.getValue();
        var cilentId = cilentIdField.getValue();
        var addFormRef = this.getActiveTabfromContentPanel();
        var validityField = addFormRef.down("#validityId");
        var periodsGrid = addFormRef.down('panel[xtype=periodsgrid]');
        var totalValidity = null;
        if (isNullOrEmpty(validityField.getValue())) {
            totalValidity = 0;
        } else {
            totalValidity = parseInt(validityField.getValue());
        }

        var periodForm = this.getFrmAddPeriodForm();
        var durationField = periodForm.down("#DurationId");
        var periodDuration = durationField.getValue();


        durationField.setMaxValue(totalValidity);
        var subtotal = this.calculateTotalDuration(periodsGrid, id, cilentId);
        var total = periodDuration + subtotal;

        if (total > totalValidity || periodDuration === 0 || totalValidity == 0) {
            if (totalValidity == 0) {
                showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('PLEASE_ENTER_VALIDITY'));
            } else {
                showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('PLEASE_ENTER_VALID_DURATION'));
            }
            cmp.reset();
        }
    },

    getMenuController: function() {
        return Academia.app.getController('menu.CoreERPNavigationController');
    },

    /**
     * @method to open the student profile on click of the student Id.
     */
    openStudentProfile: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        var columnIndex = grid.getGridColumns()[cellIndex].dataIndex;
        if (columnIndex == "studentCode") {
            var tabTitle = record.get('studentCode');
            var studentId = record.get('studentId');
            var personId = record.get('personId');
            var programBatchSeatTypeConfigId = record.get('programBatchSeatConfigId');
            this.getController('Academia.controller.personinfo.common.PersonCommonController').addContentPanelTab(tabTitle, 'studentprofile', studentId, personId, null, null, programBatchSeatTypeConfigId);
            grid.up('window[xtype=numberofawardeewindow]').close();
        }
    },

    /**
     * @method Method to show the popup which will configure the ALP entities with the scholarship
     * @Prarm {Object} button The reference of the Clicked button
     * @author Akshay.Kalbhor
     */
    assignProgarmEntities: function(button) {
        var grid = button.up('grid');
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            var associateALPTab = this.openTabAndSetValue(getCommonTranslation('SCHOLARSHIP_SETUP'), 'associateprogramscoursespanel', record.get('ID'),CONSTANTS.MENU_COLOR_TEN);
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },

    /**
     * Method to load the selected academyLocations in the Scholarship Academy Location Grid.
     */
    loadScholarshipALGrid: function(grid) {
        var panel = grid.up('panel[xtype=associateprogramscoursespanel]');
        var store = grid.getStore();
        var scholarshipId = panel.getScholarshipId();
        store.getProxy().extraParams = {
            'scholarshipId': scholarshipId
        };
        grid.getStore().load({
            callback: function() {
                if (grid.store.getCount() > 0) {
                    grid.selModel.doSelect(grid.store.data.items[0]);
                }
            }
        });
    },

    /**
     * Method to load the selected academyLocations in the Scholarship Academy Location Multiselect field.
     */
    loadALMultiselectCombo: function(grid) {
        //Fire a ajax and get all the academyLocations from ScholarshipAcademyLocations table,
        var alCombo = grid.up('panel[xtype=associateprogramscoursespanel]').down('multiselectcombofield#userAcademyLocationCombo');
        var panel = grid.up('panel[xtype=associateprogramscoursespanel]');
        var scholarshipId = panel.getScholarshipId();
        alCombo.getStore().getProxy().extraParams ={
        	 scholarshipId: scholarshipId
            };

        var params = {
            scholarshipId: scholarshipId
        };
        this.sendGetAjaxRequest(SERVERURL.SCHOL_AL, 'GET', params, function(option, success, response) {
            var responseObject = Ext.JSON.decode(response.responseText);
            var selectedIdsArray = new Array();
            Ext.each(responseObject, function(rec) {
                selectedIdsArray.push(rec.id);
            });
            alCombo.setValue(selectedIdsArray);
        });
    },

    updateScholarshipAcademyLocations: function(button) {
        var panel = button.up('panel[xtype=associateprogramscoursespanel]');
        var scholALGrid = panel.down('grid[xtype=associateacademylocationgrid]');
        var scholarshipId = panel.getScholarshipId();
        var multiselectField = button.previousSibling('multiselectcombofield#userAcademyLocationCombo');
        if (multiselectField.isDirty()) {
            var selectedValues = multiselectField.getValue();
            var academyLocations = new Array();
            Ext.each(selectedValues, function(value) {
                if (value instanceof Object) {
                    academyLocations.push(value.get('id'));
                } else {
                    academyLocations = selectedValues;
                }
            });

            var submitData = new Object();
            submitData.scholarshipId = scholarshipId;
            if (academyLocations == "") {
                academyLocations = null;
                this.resetStoresAndComponents(button);
            }
            submitData.academyLocations = academyLocations;
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
           
            this.sendSaveAjaxRequest(SERVERURL.UPDATE_SCHOLARSHIP_AL, "POST", submitData, function(option, success, response) {
            	 Ext.getBody().unmask();
                if (success) {
                    scholALGrid.getStore().reload();
                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_ACADEMY_LOCATION_UPDATE'));

                } else {
                    showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('ERROR_WHILE_SAVING_DATA'));
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * Method to reset the child components on unassigning the parent record.
     */
    resetStoresAndComponents: function(button) {
        var panel = button.up('panel[xtype=associateprogramscoursespanel]');
        var programsCombo = panel.down('multiselectcombofield#programItemSelector');
        var batchMultiselectCombo = this.getBatchesMultiselectCombo();
        var courseMultiselectCombo = this.getCourseMultiselectCombo();
        var programsGrid = this.getAssociatedProgramsGrid();
        programsGrid.getStore().removeAll();
        programsCombo.onTrigger1Click();
        programsCombo.getStore().removeAll();
        batchMultiselectCombo.getStore().removeAll();
        batchMultiselectCombo.onTrigger1Click();
        courseMultiselectCombo.getStore().removeAll();
        courseMultiselectCombo.onTrigger1Click();
    },

    loadProgramsOnSALSelection: function(selectionModel, record, index) {
        var grid = this.getAssociateAcademyLocationGrid();
        var panel = grid.up('panel[xtype=associateacademylocationstructure]');
        var multiselectcombo = panel.down('multiselectcombofield#programItemSelector');
        multiselectcombo.onTrigger1Click();
        var store = multiselectcombo.getStore();
        store.removeAll();
        var scholarshipALId = record.get('id');
        var academyLocationIds = record.get('academyLocationId');
        if(!isNullOrEmpty(academyLocationIds)){
        	store.getProxy().extraParams = {
                'academyLocationIds': academyLocationIds
            };
            store.load();

            var programIds = this.loadCurrentlyAllocatedPrograms(scholarshipALId);
            multiselectcombo.setValue(programIds);
        }
        
    },

    loadCurrentlyAllocatedPrograms: function(scholarshipALId) {
        var submitData = new Object();
        submitData.scholarshipALId = scholarshipALId;
        var programIds = new Array();
        Ext.Ajax.request({
            type: 'rest',
            method: 'GET',
            async: false,
            url: SERVERURL.SCHOLARSHIP_PROGRAMS_LIST,
            params: submitData,
            success: function(response, action) {
                var responseObject = Ext.JSON.decode(response.responseText);

                Ext.each(responseObject, function(rec) {
                    programIds.push(rec.programId);
                });
            }
        });
        return programIds;
    },

    updateScholarshipPrograms: function(button) {
        var panel = button.up('panel[xtype=associateacademylocationstructure]');
        var scholALGrid = panel.down('grid[xtype=associateacademylocationgrid]');
        var multiselectcombo = panel.down('multiselectcombofield#programItemSelector');
        if (multiselectcombo.isDirty()) {
            var selectedRecord = scholALGrid.getSelectionModel().getSelection()[0];
            var id = selectedRecord.get('id');
            var programs = multiselectcombo.getValue();
            var programIds = new Array();
            Ext.each(programs, function(program) {
                if (program instanceof Object) {
                    programIds.push(program.get('id'));
                } else {
                    programIds.push(program)
                }
            });
            var submitData = new Object();
            submitData.scholarshipAcademyLocationId = id;
            if (programIds == "") {
                programIds = null;
            }
            submitData.programIds = programIds;
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        
            this.sendSaveAjaxRequest(SERVERURL.UPDATE_SCHOLARSHIP_PROGRAMS, "POST", submitData, function(option, success, response) {
                Ext.getBody().unmask();
                if (success) {
                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_PROGRAM_UPDATE'));
                } else {
                    showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('ERROR_WHILE_SAVING_DATA'));
                }
            });
        } else {
            Ext.getBody().unmask();
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * Method loads the program grid according to the selected academyLocation from the scholarship AcademyLocation Grid
     */
    loadProgramsGrid: function(tab) {
        var grid = this.getAssociateAcademyLocationGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var selectedRecord = grid.getSelectionModel().getSelection()[0];
            var scholarshipALId = selectedRecord.get('id');
            var programsGrid = this.getAssociatedProgramsGrid();
           var programsGridModel =  programsGrid.getSelectionModel()
            var programsGridSelectrecord = programsGrid.getSelectionModel().getSelection()[0];
            var store = programsGrid.getStore();
            store.getProxy().extraParams = {
                'scholarshipALId': scholarshipALId
            };
            store.load({
                callback: function() {
                    if (store.getCount() > 0) {
                        programsGrid.selModel.doSelect(store.data.items[0]);
                    }
                }
            });
            if(programsGridSelectrecord!=undefined){
            	 this.loadBatchesAndSections(programsGridModel, programsGridSelectrecord, 0);
            }
            /*setTimeout(function(){
            this.loadBatchesAndSections(programsGridModel, programsGridSelectrecord, 0)
            },500);*/
        } else {
            var parentTabPanel = tab.up('panel[xtype=associateprogramscoursespanel]');
            parentTabPanel.setActiveTab(0);
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_AL_RECORD_IN_PREVIOUS_TAB'));
        }

    },

    /**
     * @method This method triggers the stores to load themselves on the selection of a record from the program grid.
     */
    loadBatchesAndSections: function(selectionModel, record, index) {
        var grid = this.getAssociatedProgramsGrid();
        var panel = grid.up('panel[xtype=associatecoursestructure]')
        var batchcombo = panel.down('multiselectcombofield#multiselectBatchCombo');
        var courseCombo = panel.down('multiselectcombofield#multiselectCourseCombo');
        batchcombo.onTrigger1Click();
        courseCombo.onTrigger1Click();
        var store = batchcombo.getStore();
        var courseStore = courseCombo.getStore();
        store.removeAll();
        courseStore.removeAll();
        var programId = record.get('programId');
        var scholarshipProgramId = record.get('id');
        store.getProxy().extraParams = {
            'id': programId
        };
        store.reload();

        courseStore.getProxy().extraParams = {
            'programId': programId
        };
        courseStore.reload();

        var batchIds = this.loadCurrentlyAllocatedBatches(scholarshipProgramId);
        batchcombo.setValue(batchIds);

        var courseIds = this.loadCurrentlyAllocatedCourses(scholarshipProgramId);
        courseCombo.setValue(courseIds);
    },

    /**
     * @method Method to fire an ajax request and get the currently allocated batches for the selected program.
     * @param  {int} scholarshipProgramId
     */
    loadCurrentlyAllocatedBatches: function(scholarshipProgramId) {
        var submitData = new Object();
        submitData.scholarshipProgramId = scholarshipProgramId;
        var batchIds = new Array();
        Ext.Ajax.request({
            type: 'rest',
            method: 'GET',
            async: false,
            url: SERVERURL.GET_BATCHES_BY_SPROGRAM,
            params: submitData,
            success: function(response, action) {
                var responseObject = Ext.JSON.decode(response.responseText);
                Ext.each(responseObject, function(rec) {
                    batchIds.push(rec.id);
                });
            }
        });
        return batchIds;
    },

    /**
     * @method Method to fire an ajax request and get the currently allocated courses for the selected program.
     * @param  {int} scholarshipProgramId
     */
    loadCurrentlyAllocatedCourses: function(scholarshipProgramId) {
        var submitData = new Object();
        submitData.scholarshipProgramId = scholarshipProgramId;
        var courseIds = new Array();
        Ext.Ajax.request({
            type: 'rest',
            method: 'GET',
            async: false,
            url: SERVERURL.GET_COURSES_BY_SPROGRAM,
            params: submitData,
            success: function(response, action) {
                var responseObject = Ext.JSON.decode(response.responseText);
                Ext.each(responseObject, function(rec) {
                    courseIds.push(rec.id);
                });
            }
        });
        return courseIds;
    },

    /**
     * Method to update the scholarship Batches and courses.
     * Calls this method after the Scholarship Batches are selected and Save button is clicked.
     * Calls this method after the Scholarship Courses are selected and Save button is clicked.
     * @param {Object} the reference of the clicked button.
     */
    updateScholarshipBatchesAndCourses: function(button) {
        var panel = button.up('panel[xtype=associatecoursestructure]');
        var programsGrid = panel.down('grid[xtype=associatedprogramsgrid]');
        var batchMultiselectcombo = panel.down('multiselectcombofield#multiselectBatchCombo');
        var courseMultiselectcombo = panel.down('multiselectcombofield#multiselectCourseCombo');
        var selectedRecord = programsGrid.getSelectionModel().getSelection()[0];
        if (selectedRecord != undefined && (batchMultiselectcombo.isDirty() || courseMultiselectcombo.isDirty())) {
            var id = selectedRecord.get('id');
            var selectedIds = new Array();
            var submitData = new Object();
            submitData.scholarshipProgramId = id;
            var url = null;

            if (button.itemId == 'btnSaveAssociatedBatches') {
                selectedIds = batchMultiselectcombo.getValue();
                var mappedIds = this.populateInputIds(selectedIds);
                submitData.batchIds = mappedIds;
                url = SERVERURL.UPDATE_PROGRAMS_FOR_BATCHES;
            } else if (button.itemId == 'btnSaveAssociatedCourses') {
                selectedIds = courseMultiselectcombo.getValue();
                var mappedIds = this.populateInputIds(selectedIds);
                submitData.courseIds = mappedIds;
                url = SERVERURL.UPDATE_PROGRAMS_FOR_COURSES
            }

            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            
            this.sendSaveAjaxRequest(url, "POST", submitData, function(option, success, response) {
            	Ext.getBody().unmask();
                if (success) {
                    if (url == SERVERURL.UPDATE_PROGRAMS_FOR_BATCHES) {
                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_PROGRAM_BATCH'));
                    } else {
                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_PROGRAM_COURSE'));
                    }
                } else {
                	Ext.getBody().unmask();
                    showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('ERROR_WHILE_SAVING_DATA'));
                }
            });
        } else {
        	Ext.getBody().unmask();
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },

    /**
     * @private
     * @method Method to populate the selected ids in an array form, 
     * inserts a id by extracting from an object/ direct id depending on the recieved object of selected Id's
     * Due to the inconsistent behaviour of Multiselect combo.
     * @param {Object[]} array of selected ids in the multiselect combo.
     */
    populateInputIds: function(selectedIds) {
        var inputIds = new Array();
        Ext.each(selectedIds, function(id) {
            if (id instanceof Object) {
                inputIds.push(id.get('id'));
            } else {
                inputIds.push(id);
            }
        });
        if (selectedIds == "") {
            inputIds = null;
        }
        return inputIds;
    },

    /**
     * @method This method clears the Batch and Course multiselect Combos.
     */
    resetBatchAndCourseCombo: function() {
        var grid = this.getAssociatedProgramsGrid();
        var panel = grid.up('panel[xtype=associatecoursestructure]')
        var batchcombo = panel.down('multiselectcombofield#multiselectBatchCombo');
        var courseCombo = panel.down('multiselectcombofield#multiselectCourseCombo');
        batchcombo.getStore().removeAll();
        courseCombo.getStore().removeAll();
        batchcombo.onTrigger1Click();
        courseCombo.onTrigger1Click();
    },

    /**
     * Method  to flush the existing periods on selection of the Amount type,
     * if amount type is changed from fixed to adhoc, the schol amount has to be reset to zero,
     * and the corresponding periods amount also has to be reset, else will cause validation errors on edit of periods.
     * @author akshay.kalbhor 
     */
    flushPeriodsStoreAndDisableAmount: function(combo) {
        var this$ = this;
        var periodsGrid = combo.up('panel[xtype=addscholarship]').down('panel[xtype=periodsgrid]');
        var store = periodsGrid.getStore();
        var addScholarshipTab = combo.up('panel[xtype=addscholarship]');
        var amountTypeData = combo.getValue();
        var amountfield = addScholarshipTab.down("textfield#amountId");
        var feeHeadsPanel = addScholarshipTab.down("#feeHeadsPanel");
        if (amountTypeData === "ADH") {
            if (store.getCount() > 0) {
                showConfirmMessage(getCommonTranslation('FLUSH_PERIODS'), getCommonTranslation('FLUSH_PERIODS_CONFIRM_MESSAGE'), function(btn, text) {
                    if (btn == 'yes') {
                        store.removeAll();
                        store.fireEvent('refresh');
                        amountfield.setDisabled(true);
                        feeHeadsPanel.hide();
                        amountfield.setValue('');
                    } else {
                        combo.setValue("FIX");
                    }
                });
            } else {
                amountfield.setDisabled(true);
                feeHeadsPanel.hide();
                amountfield.config.showAlert = true;
                amountfield.setValue('');                
                for(var i =0 ;i<feeHeadsPanel.items.items.length ;i++){
                    feeHeadsPanel.items.items[i].down('#feeHeads').allowBlank = true;
                     feeHeadsPanel.items.items[i].down('#amountOrPercentage').allowBlank = true
                      feeHeadsPanel.items.items[i].down('#feeAmounts').allowBlank = true

                }
                amountfield.fireEvent('validitychange');
            }
        } else {
            //code to enable amount
            amountfield.setValue(0);
            amountfield.setDisabled(false);
            feeHeadsPanel.show();
            amountfield.fireEvent('validitychange');
        }
        
        var feeHeadsPanel = addScholarshipTab.down('#feeHeadsPanel')
		  var  feeHeadPanelLength  = feeHeadsPanel.items.items.length;
		  if(feeHeadPanelLength >1){
		      for(var i =1;i< feeHeadPanelLength; i++){
		         feeHeadsPanel.remove(feeHeadsPanel.items.items[i])
		      }

		  }else{
			  feeHeadsPanel.items.items[0].down('#feeAmounts').reset();

			  feeHeadsPanel.items.items[0].down('#feeHeads').reset();

			  feeHeadsPanel.items.items[0].down('#amountOrPercentage').reset();
		  } 
    },
    cellclickAdvanceSearch: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var contentPanelActiveTab = this.getContentPanelActiveTab();
        var activeTab =	contentPanelActiveTab.activeTab;
        var searchResultGrid =  activeTab.down('searchresultgrid');
       // var searchResultGrid = this.getSearchResultGrid();
        var columnName = searchResultGrid.columnManager.columns[cellIndex].dataIndex;
        if (columnName == "NO_OF_AWARDEES") {
            var value = record.get(columnName);
            if (value > 0) {
                var me = this;
                me.showAwardeePopUp();
                var id = record.raw.ID;
                var grid = me.getNumberofAwardeeGrid();
                grid.down('#statusComboId').getStore().load();
                var refCombo = me.getNumberofAwardeeGrid().down("#statusComboId");
                var store = grid.getStore();
                store.getProxy().extraParams = {
                    'scholarshipId': id,
                    'status': refCombo.getValue()
                };
                store.load();

                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.SCHOLARSHIP_AWARDEE_FIND_AWARDEE_SUMMARY,
                    method: 'GET',
                    params: {
                        scholarshipId: id
                    },
                    success: function(res, action) {
                        var data = Ext.decode(res.responseText);
                        me.getAwardeeWindowForm().getForm().setValues(data);
                    }
                });
            }
        }
    },
    addFeeHeadsForScholarship: function(viewName,feeHeadPanelOfEdit){
    	var this$ = this;
 	    var panelItem = new Array();
 	   panelItem.push({
 		  xtype: 'fieldcontainer',
				width: '100%',
				layout: {
					type: 'hbox',
					align: 'bottom'
				},
				defaults:{
					width: 226,
					labelAlign: 'top',
  				
				},
				items: [{
					xtype: 'customcombobox',
					itemId: 'feeHeads',
					name: 'feeHeads',    					
					fieldLabel: getFeeAndPaymentCommonTranslation('FEES_HEADS'),
					store: Ext.create('Academia.store.feeandpayment.reports.FeeHeadWiseFeeReportStore'),
					valueField: 'id',
					displayField: 'value',
					//typeAhead:true,
				    forceSelection:true,
					allowBlank: false
				},{
					xtype: 'customcombobox',
					itemId: 'amountOrPercentage',
					name: 'amountOrPercentage',
					fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT_OR'),
					labelAlign: 'top',
					store:Ext.create('Academia.store.feeandpayment.FeeAmount'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
	        	    forceSelection:true,
					allowBlank: false,
					listeners:{
						change:function(cmp,record){
							cmp.up().down('#feeAmounts').reset();
							if(record == "PERCENTAGE"){
								cmp.up().down('#feeAmounts').setMaxValue(100);
								cmp.up().down('#feeAmounts').setMinValue(1);
							}else{
								cmp.up().down('#feeAmounts').setMaxValue(10000000000000000000);
								cmp.up().down('#feeAmounts').setMinValue(1);
							}
						}
					}
				},{
					xtype:'numberfield',
					enableKeyEvents : true,
					itemId: 'feeAmounts',
					name: 'feeAmounts',
					allowBlank: false,
					hideTrigger:true,
					maxValue: 100,
					allowDecimals:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('FEES_AMOUNT'),
					listeners:{
						change : function(comp, newVal, oldVal){
						       var addForm =  comp.up('#addscholarshipform');
	    						
						 	   var feeHeadsPanel = addForm.down('#feeHeadsPanel');   	 
						 	   var amountFld = addForm.down('#amountId');
						 	   var totalAMountOfFeeHead=0;
						 	   var feeHeadPanelLength  = feeHeadsPanel.items.items.length;
							   var feeHeadItems = feeHeadsPanel.items.items;						
							   var remainingAmt = 0;
							   var feeAmtVal ;
							   var remainingAmtOfFeeHead ;
							   var percentDataArray = new Array();
					 			 for(var i = 0;i< feeHeadPanelLength ;i++){
					 				 if(feeHeadItems[i].items.items[1].getValue() == "PERCENTAGE"){
					 					 if(feeHeadItems[i].items.items[2].getValue() == 100){
   					 						percentDataArray.push(feeHeadItems[i].items.items[1].getValue());
   					 					 }
					 					var totalAmt = parseInt(amountFld.getValue());
					 					remainingAmt =totalAmt-totalAMountOfFeeHead;
					 					feeAmtVal =feeHeadItems[i].items.items[2].getValue();
					 					remainingAmtOfFeeHead= remainingAmt* feeAmtVal/100;
					 					totalAMountOfFeeHead = remainingAmtOfFeeHead+totalAMountOfFeeHead;
					 				 }
					 				 else{
					 					totalAMountOfFeeHead = totalAMountOfFeeHead+feeHeadItems[i].items.items[2].getValue(); 
					 				 }
					 				//totalAMountOfFeeHead = totalAMountOfFeeHead+feeHeadItems[i].items.items[2].getValue()
					 			 }
					 			 if(totalAMountOfFeeHead > parseInt(amountFld.getValue())){
					 				 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SUM_OF_FEE_HEADS_AMOUNT_EXCEEDING_THE_TOTAL_AMOUNT'));
					 				comp.reset();
					 			 }
					 			else if(totalAMountOfFeeHead == parseInt(amountFld.getValue())){
									  if(percentDataArray.length >1){
											 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SUM_OF_FEE_HEADS_AMOUNT_EXCEEDING_THE_TOTAL_AMOUNT'));
		      					 			 comp.reset();
		      					 			
									  }
								 }
					 	   
							
						}
				  }
					
					
				},{
		 			   xtype: 'button',
		 			   glyph: ICONGLYPH.DELETEGLYPH,
		 			   cls: 'CustomBodyBtnReject',
		 			   tooltip: getCommonTranslation('DELETETOOLTIP'),
		 			   listeners:{
		 				   click:function(obj){
		 					   var frm = obj.up('#addscholarshipform');
		 					   var feeHeadPanel = frm.down('#feeHeadsPanel');
		 					   var container = obj.up('fieldcontainer');
		 					   feeHeadPanel.remove(container);
		 					   frm.doLayout();
		 				   }
		 			   }
		 		   }]  
 	   });

 	  var addForm =  this.getAddScholarshipForm();
 	  if(viewName == "edit"){
 		 var feeHeadsPanel = feeHeadPanelOfEdit;   	 
 		 
 	  }else{
 		 var feeHeadsPanel = addForm.down('#feeHeadsPanel');   	 
 		   
 	  }
	    var amountFld = addForm.down('#amountId');
	   var feeAmounts =addForm.down('#feeAmounts');
	   var totalAMountOfFeeHead=0;
	   var feeHeadPanelLength  = feeHeadsPanel.items.items.length;
	   var feeHeadItems = feeHeadsPanel.items.items;
	   var allFldVal =true;
	   var remainingAmt = 0;
	   var feeAmtVal ;
	   var remainingAmtOfFeeHead ;
	  if(feeHeadPanelLength > 0 && viewName != "edit" && viewName != "view"){ 		 
			 for(var i = 0;i< feeHeadPanelLength ;i++){
				 if(feeHeadItems[i].items.items[1].getValue() == "PERCENTAGE"){
					var totalAmt = parseInt(amountFld.getValue());
					remainingAmt =totalAmt-totalAMountOfFeeHead;
					feeAmtVal =feeHeadItems[i].items.items[2].getValue();
					remainingAmtOfFeeHead= remainingAmt* feeAmtVal/100;
					totalAMountOfFeeHead = remainingAmtOfFeeHead+totalAMountOfFeeHead;
				 }
				 else{
					totalAMountOfFeeHead = totalAMountOfFeeHead+feeHeadItems[i].items.items[2].getValue(); 
				 }
			
			var feeHeadVal =feeHeadItems[i].items.items[0].getValue();
			var amtTypeVal =feeHeadItems[i].items.items[1].getValue();
			var amtVal =feeHeadItems[i].items.items[2].getValue();

			     if(!feeHeadVal || !amtTypeVal || !amtVal){
			         allFldVal = false;
			         break;
			     }
			 }
		
			
			if(allFldVal){
			    if(totalAMountOfFeeHead >= amountFld.getValue()){
				 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SUM_OF_FEE_HEADS_AMOUNT_EXCEEDING_THE_TOTAL_AMOUNT'));
			 	  
			 }else{
				 feeHeadsPanel.add(panelItem);
				 addForm.doLayout();
		      } 
		}else{
			    showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_ENTER_THE_DETAILS_IN_THE_CURRENT_ROW_TO_ADD_MORE_ROWS'));
			}
			
		 
	   }else{
		   feeHeadsPanel.add(panelItem);
			 addForm.doLayout();
	   } 
   },
   getIdValueJson: function(id, value) {
	   if (id) return {
		   id: id,
		   value: value
	   };
   },
   
   /*To show the scholarship raise request tab*/
   getScholarshipRequestPanel:function(requestIsFor,record,scholarshipReqEditSCreen){
	   if(!scholarshipReqEditSCreen){
		   this.scholarshipReqEditSCreen=false
	   }
	   this.requesterType = requestIsFor;
	   this.stdOrApplicantRecord = record;
	   var contentpanel = this.getContentPanel();
	   var structure = Ext.widget('scholarshiprequestpanel');
	   var tabName = getCommonTranslation('SCHOLARSHIP_REQUEST');
	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	   var getTab=getcontroller.getTab(tabName);
	   if(getTab!=null){
		   contentpanel.remove(getTab, true);
	   }
	   openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
	   this.setDataOnScholarshipRequestForm(this.requesterType,record);
   },
   
   /*To set Data on Scholarship Request Form*/
   setDataOnScholarshipRequestForm:function(requesterType,record){
	   var $this = this;
	   var form = this.getScholarshiprequestform();
	   var assinedToReadOnly=false;
	   this.gridRecord=record;
	   form.down('#requestById').setValue(this.getCurrentlyLoggedInUser().value);
	   if(!isNullOrEmpty(record)){
		   if(record.data.requestStatus){ //req edit case 
			   var requestDate = new Date(record.data.requestDate);
			   var formattedDate = requestDate.toLocaleDateString(); 
			   form.down('#RequestDateId').setValue(formattedDate);
			   form.down('#requestId').setVisible(true);
			   form.down('#requestId').setValue('Req'+record.data.id);
			   form.down('#recordId').setValue(record.data.id);
			   form.down('#applicantId').setValue(record.data.applicantName+" ("+record.data.applicantCode+")");
			   form.down('#studentId').setValue(record.data.studentName+" ("+record.data.studentCode+")");
			   form.down('#batchId').setValue(record.data.batchName);
			   form.down('#emailId').setValue(record.data.emailId);
			   form.down('#stdStatusId').setValue(record.data.studentStatus);
			   setTimeout(function(){
				   form.down('#RequestDateId').setValue(dateRender(record.data.requestDate));
			   },800);
			   form.down('#requesterTypeId').setValue(record.data.requesterType);
			   setTimeout(function(){
				   form.down('#RequestDateId').setValue(dateRender(record.data.requestDate));
			   },800);
			   form.down('#programId').setValue(record.data.programName);
			   form.down('#mobileId').setValue(record.data.mobileNo);
			   form.down('#requestById').setValue(record.data.requestByName);
			   var scholarshipStore = form.down('#scholarshipId').getStore();
               scholarshipStore.getProxy().extraParams = {};
			   scholarshipStore.load({
				   callback:function(records, operation, success) {
					   for(var  i in records){
						   if(records[i].data.id==record.data.scholarshipId){
							   $this.scholarshipAmountPerStd = records[i].data.maxAmountPerStudent;			               
						   }
					   }
				   }
			   });
			   form.down('#scholarshipId').setValue(record.data.scholarshipId);
			   form.down('#financialYear').getStore().load();
			   form.down('#financialYear').setValue(record.data.financialYearId);
			   form.down('#financialYear').setDisabled(false);
			   form.down('#workStatusOfStudent').setValue(record.data.workStatus);
			   form.down('#workStatusOfApplicant').setValue(record.data.workStatus);
			   form.down('#liableForTax').setValue({liableForTax:record.data.isTaxLiable});
			   form.down('#stdUnderstandNoWorkDoneInExchangeOfBursary').setValue(record.data.isDoingNowork);
			   form.down('#applicantUnderstandNoWorkDoneInExchangeOfBursary').setValue(record.data.isDoingNowork);
			   form.down('#subsequentScholarshipAvailable').setValue({subsequentScholarshipAvailable:record.data.isSubsequentBusary});
			   if(!isNullOrEmpty(record.data.studentFees)){
			   form.down('#paymentTowardsFees').setValue(record.data.studentFees.toFixed(2));
			   }
			   form.down('#paymentTowardsLivingExpensesOrAccommodation').setValue(record.data.accomondationFees);
			   form.down('#Other').setValue(record.data.otherFees);
			   if(!isNullOrEmpty(record.data.totalScholarshipAmount)){
			   record.data.totalScholarshipAmount && form.down('#totalScholarshipAmount').setValue(record.data.totalScholarshipAmount.toFixed(2));
			   }
			   form.down('#subsequentAmount').setValue(record.data.subsequentAmount);
			   form.down('#costCentreOrPoetDetails').setValue('COST_CENTER');
			   form.down('#remark').setValue(record.data.remark);
			   form.down('#userName').setValue(this.getCurrentlyLoggedInUser().value);
			   form.down('#executionUserName').setValue(this.getCurrentlyLoggedInUser().value);
			   form.down('#declaration').setValue(true);
			   form.down('#assigneeToId').getStore().load({
				   callback: function(records, operation, success) {
					   for(var i in records){
						   if(record.data.requestStatus=="CLOSED"  || record.data.requestStatus=="REJECTED_BO"){
							   this.add({
							        value: record.data.assignedToName,
							        id: record.data.assignedToId,
							        code:record.data.assignedToCode
							    });
							   form.down('#assigneeToId').setValue(record.data.assignedToId);
						   }
						   if(records[i].data.id == record.data.assignedToId){
							   form.down('#assigneeToId').setValue(record.data.assignedToId);
							   if(record.data.requestById == $this.getCurrentlyLoggedInUser().id && (record.data.requestStatus=="REASSIGNED")){
								   form.down('#assigneeToId').reset();
							   }
						   }else{
							   if(assinedToReadOnly){
								   form.down('#assigneeToId').setReadOnly(false);
							   }
						   }
					   }
				   }	   
			   });
			   if(($this.loggedInUserRoles=='Scholarship Officer' || this.getCurrentlyLoggedInUser().id==1) && record.data.requestStatus=="Approved"){
				   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
				   form.down('#executiondetailsscholarshipformId').setVisible(true);
				   form.down('#executionDeclarationContainerId').setVisible(true);
				   form.down('#userName').setVisible(false);
				   form.down('#reqExecutedOn').setVisible(false);
				   form.down('#followUpRemarks').setVisible(false);
				   form.down('#submitBtn').setVisible(false);
				   form.down('#resetScholarShipFormBtn').setVisible(false);
				   form.down('#declarationsContainerId').setVisible(false);
				   form.down('#rejectBtn').setVisible(true);
				   form.down('#approveBtn').setVisible(true);
				   form.down('#reSubmit').setVisible(true);
				   form.down('#reSubmit').setText(getCommonTranslation("RESUBMIT_SCHOLARSHIP_SCHOLARSHIPOFFICER"));
				   this.setDataForCostCenterFieldsInViewMode(record.data.costCenterAndPoetDetails,true);
				   toggleReadOnlyFormItems(form.getForm(),true);
				   form.down('#executionDeclaration').setReadOnly(false);
				   form.down('#executionFollowUpRemarks').setReadOnly(false);
				   if(record.data.scholarshipFollowUpDetails && record.data.scholarshipFollowUpDetails[0] && record.data.scholarshipFollowUpDetails[0].requestStatus!='APPLIED'){ // if sysadmin or line manager open assigned req which is coming back after correction
					   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
					   form.down('#followUpGrid').setVisible(true);
					   form.down('#followUpGrid').getStore().getProxy().extraParams={
						   //assignToId:record.data.scholarshipFollowUpDetails[0].reviewerUserId,
						   scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					   }
					   form.down('#followUpGrid').getStore().load();
					   form.down('#executionGrid').getStore().getProxy().extraParams={
						   scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					   }
					   form.down('#executionGrid').getStore().load({
						   callback: function(record){
							   if(record.length>0){
								   form.down('#executiondetailsscholarshipformId').setVisible(true);
								   form.down('#executionGrid').setVisible(true);
								   form.down('#executionReqExecutedOn').setVisible(true);
								   form.down('#executionFollowUpRemarks').setVisible(true);
								   form.down('#executionUserName').setVisible(true);
							   }
						   }
					   });
				   }
			   }else if(record.data.requestStatus=="CLOSED" || record.data.requestStatus=="REJECTED_BO"){
				   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
				   form.down('#executiondetailsscholarshipformId').setVisible(true);
				   form.down('#executionDeclarationContainerId').setVisible(false);
				   form.down('#userName').setVisible(false);
				   form.down('#reqExecutedOn').setVisible(false);
				   form.down('#followUpRemarks').setVisible(false);
				   form.down('#submitBtn').setVisible(false);
				   form.down('#resetScholarShipFormBtn').setVisible(false);
				   form.down('#declarationsContainerId').setVisible(false);
				   form.down('#rejectBtn').setVisible(false);
				   form.down('#approveBtn').setVisible(false);
				   form.down('#reSubmit').setVisible(false);
				   this.setDataForCostCenterFieldsInViewMode(record.data.costCenterAndPoetDetails,true);
				   toggleReadOnlyFormItems(form.getForm(),true);
				   if(record.data.scholarshipFollowUpDetails && record.data.scholarshipFollowUpDetails[0] && record.data.scholarshipFollowUpDetails[0].requestStatus!='APPLIED'){ // if sysadmin or line manager open assigned req which is coming back after correction
					   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
					   form.down('#followUpGrid').setVisible(true);
					   form.down('#followUpGrid').getStore().getProxy().extraParams={
						   //assignToId:record.data.scholarshipFollowUpDetails[0].reviewerUserId,
						   scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					   }
					   form.down('#followUpGrid').getStore().load();
					   form.down('#executionGrid').getStore().getProxy().extraParams={
						   scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					   }
					   form.down('#executionGrid').getStore().load({
						   callback: function(record){
							   if(record.length>0){
								   form.down('#executiondetailsscholarshipformId').setVisible(true);
								   form.down('#executionGrid').setVisible(true);
								   form.down('#executionReqExecutedOn').setVisible(false);
								   form.down('#executionFollowUpRemarks').setVisible(false);
								   form.down('#executionUserName').setVisible(false);
							   }
						   }
					   });
				   }
			   }else if(record.data.requestById == this.getCurrentlyLoggedInUser().id && record.data.requestStatus=="ASSIGNED"){  //when req creater open its own created req
				   this.setDataForCostCenterFieldsInViewMode(record.data.costCenterAndPoetDetails,false);
				   form.down('#followUpDetailsScholarshipFormId').setVisible(false);
				   form.down('#followUpGrid').setVisible(false);
				   form.down('#declaration').setValue(false);
				   if(record.data.scholarshipFollowUpDetails && record.data.scholarshipFollowUpDetails[0] && record.data.scholarshipFollowUpDetails[0].requestStatus!='APPLIED'){ // if creater open assigned req after doing correction
					   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
					   form.down('#reqExecutedOn').setVisible(false);
					   form.down('#followUpRemarks').setVisible(false);
					   form.down('#userName').setVisible(false);
					   form.down('#followUpGrid').setVisible(true);
					   form.down('#followUpRemarks').setValue(record.data.scholarshipFollowUpDetails[0].followUpRemark);
					   form.down('#followUpGrid').getStore().getProxy().extraParams={
						   //assignToId:record.data.scholarshipFollowUpDetails[0].reviewerUserId,
						   scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					   }
					   form.down('#followUpGrid').getStore().load();
					   form.down('#executionGrid').getStore().getProxy().extraParams={
						   scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					   }
					   form.down('#executionGrid').getStore().load({
						   callback: function(record){
							   if(record.length>0){
								   form.down('#executiondetailsscholarshipformId').setVisible(true);
								   form.down('#executionGrid').setVisible(true);
								   form.down('#executionReqExecutedOn').setVisible(false);
								   form.down('#executionFollowUpRemarks').setVisible(false);
								   form.down('#executionUserName').setVisible(false);
							   }
						   }
					   });
				   }
			   }else if((record.data.requestById == this.getCurrentlyLoggedInUser().id || this.getCurrentlyLoggedInUser().id==1) && record.data.requestStatus=="REASSIGNED"){
				   assinedToReadOnly=true;
				   form.down('#declaration').setValue(false);
				   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
				   form.down('#reqExecutedOn').setVisible(false);
				   form.down('#followUpRemarks').setVisible(false);
				   form.down('#userName').setVisible(false);
				   if(record.data.scholarshipFollowUpDetails && record.data.scholarshipFollowUpDetails[0]){
					   form.down('#followUpGrid').setVisible(true);
					   form.down('#followUpRemarks').setValue(record.data.scholarshipFollowUpDetails[0].followUpRemark);
					   form.down('#followUpGrid').getStore().getProxy().extraParams={
						    //assignToId:record.data.scholarshipFollowUpDetails[0].reviewerUserId,
					        scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					}
					   form.down('#followUpGrid').getStore().load();
					   form.down('#executionGrid').getStore().getProxy().extraParams={
						   scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					   }
					   form.down('#executionGrid').getStore().load({
						   callback: function(record){
							   if(record.length>0){
								   form.down('#executiondetailsscholarshipformId').setVisible(true);
								   form.down('#executionGrid').setVisible(true);
								   form.down('#executionReqExecutedOn').setVisible(false);
								   form.down('#executionFollowUpRemarks').setVisible(false);
								   form.down('#executionUserName').setVisible(false);
							   }
						   }
					   });
				   }
				   this.setDataForCostCenterFieldsInViewMode(record.data.costCenterAndPoetDetails,false);
			   } else if((record.data.requestById == this.getCurrentlyLoggedInUser().id || this.getCurrentlyLoggedInUser().id==1) && (record.data.requestStatus=="REJECTED" || record.data.requestStatus=="Approved" || record.data.requestStatus=="CLOSED")){
				   form.down('#declarationsContainerId').setVisible(false)
				   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
				   form.down('#reqExecutedOn').setVisible(false);
				   form.down('#followUpRemarks').setVisible(false);
				   form.down('#userName').setVisible(false);
				   form.down('#submitBtn').setVisible(false);
				   form.down('#resetScholarShipFormBtn').setVisible(false);
				   toggleReadOnlyFormItems(form.getForm(),true);
				   if(record.data.scholarshipFollowUpDetails && record.data.scholarshipFollowUpDetails[0]){
					   form.down('#followUpGrid').setVisible(true);
					   form.down('#followUpRemarks').setValue(record.data.scholarshipFollowUpDetails[0].followUpRemark);
					   form.down('#followUpGrid').getStore().getProxy().extraParams={
						    //assignToId:record.data.scholarshipFollowUpDetails[0].reviewerUserId,
					        scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					}
					   form.down('#followUpGrid').getStore().load();
					   form.down('#executionGrid').getStore().getProxy().extraParams={
					        scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					}
					   form.down('#executionGrid').getStore().load({
						   callback: function(record){
							   if(record.length>0){
								   form.down('#executiondetailsscholarshipformId').setVisible(true);
								   form.down('#executionGrid').setVisible(true);
								   form.down('#executionReqExecutedOn').setVisible(false);
								   form.down('#executionFollowUpRemarks').setVisible(false);
								   form.down('#executionUserName').setVisible(false);
							   }
						   }
					   });
				   }
				   this.setDataForCostCenterFieldsInViewMode(record.data.costCenterAndPoetDetails,true);
			   }else if((record.data.assignedToId == this.getCurrentlyLoggedInUser().id || this.getCurrentlyLoggedInUser().id==1) && record.data.requestStatus=="ASSIGNED"){
				   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
				   form.down('#submitBtn').setVisible(false);
				   form.down('#resetScholarShipFormBtn').setVisible(false);
				   form.down('#declarationsContainerId').setVisible(false);
				   form.down('#rejectBtn').setVisible(true);
				   form.down('#approveBtn').setVisible(true);
				   form.down('#reSubmit').setVisible(true);
				   form.down('#reSubmit').setText(getCommonTranslation("RESUBMIT_SCHOLARSHIP_LINEMANAGER"));
				   var declarationContainerId = form.down('#declarationContainerId');
				   declarationContainerId.setVisible(true);
				   this.setDataForCostCenterFieldsInViewMode(record.data.costCenterAndPoetDetails,true);
				   toggleReadOnlyFormItems(form.getForm(),true);
				   form.down('#declarationFollowUp').setReadOnly(false);
				   form.down('#followUpRemarks').setReadOnly(false);
				   if(record.data.scholarshipFollowUpDetails && record.data.scholarshipFollowUpDetails[0] && record.data.scholarshipFollowUpDetails[0].requestStatus!='APPLIED'){ // if sysadmin or line manager open assigned req which is coming back after correction
					   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
					   form.down('#followUpGrid').setVisible(true);
					   form.down('#followUpGrid').getStore().getProxy().extraParams={
						   //assignToId:record.data.scholarshipFollowUpDetails[0].reviewerUserId,
						   scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					   }
					   form.down('#followUpGrid').getStore().load();
					   form.down('#executionGrid').getStore().getProxy().extraParams={
						   scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					   }
					   form.down('#executionGrid').getStore().load({
						   callback: function(record){
							   if(record.length>0){
								   form.down('#executiondetailsscholarshipformId').setVisible(true);
								   form.down('#executionGrid').setVisible(true);
								   form.down('#executionReqExecutedOn').setVisible(false);
								   form.down('#executionFollowUpRemarks').setVisible(false);
								   form.down('#executionUserName').setVisible(false);
							   }
						   }
					   });
				   }
			   }else if(record.data.assignedToId == this.getCurrentlyLoggedInUser().id && (record.data.requestStatus=="REJECTED" || record.data.requestStatus=="Approved" || record.data.requestStatus=="CLOSED")){
				   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
				   form.down('#userName').setVisible(false);
				   form.down('#reqExecutedOn').setVisible(false);
				   form.down('#followUpRemarks').setVisible(false);
				   form.down('#submitBtn').setVisible(false);
				   form.down('#resetScholarShipFormBtn').setVisible(false);
				   form.down('#declarationsContainerId').setVisible(false);
				   form.down('#rejectBtn').setVisible(false);
				   form.down('#approveBtn').setVisible(false);
				   form.down('#reSubmit').setVisible(false);
				   this.setDataForCostCenterFieldsInViewMode(record.data.costCenterAndPoetDetails,true);
				   if(record.data.scholarshipFollowUpDetails && record.data.scholarshipFollowUpDetails[0]){
					   form.down('#followUpGrid').setVisible(true);
					   form.down('#followUpRemarks').setValue(record.data.scholarshipFollowUpDetails[0].followUpRemark);
					   form.down('#followUpGrid').getStore().getProxy().extraParams={
						    //assignToId:record.data.scholarshipFollowUpDetails[0].reviewerUserId,
					        scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					}
					   form.down('#followUpGrid').getStore().load();
					   form.down('#executionGrid').getStore().getProxy().extraParams={
						   scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					   }
					   form.down('#executionGrid').getStore().load({
						   callback: function(record){
							   if(record.length>0){
								   form.down('#executiondetailsscholarshipformId').setVisible(true);
								   form.down('#executionGrid').setVisible(true);
								   form.down('#executionReqExecutedOn').setVisible(false);
								   form.down('#executionFollowUpRemarks').setVisible(false);
								   form.down('#executionUserName').setVisible(false);
							   }
						   }
					   });
				   }
				   toggleReadOnlyFormItems(form.getForm(),true);
			   }
		   }else{
			   if(requesterType=='Applicant'){
				   form.down('#applicantId').setValue(record.data.APPLICATION_PERSON_PRINTNAME+" ("+record.data.APPLICATION_ID+")");
				   form.down('#batchId').setValue(record.data.BATCH);
				   form.down('#emailId').setValue(record.data.EMAIL);
			   }else if(requesterType=='Student'){
				   form.down('#studentId').setValue(record.data.STUDENT_NAME+" ("+record.data.STUDENT_ID+")");
				   form.down('#batchId').setValue(record.data.BATCH_NAME);
				   form.down('#emailId').setValue(record.data.EMAIL_ID);
				   form.down('#stdStatusId').setValue(record.data.STATUS);
			   }
			   form.down('#followUpGrid').setVisible(false);
			   form.down('#requesterTypeId').setValue(requesterType);
			   form.down('#programId').setValue(record.data.PROGRAM_NAME);
			   form.down('#mobileId').setValue(record.data.MOBILE_NUMBER);
		   }
	   }
   },
   
   /*To dynamically add field based on selection of const center or poet dropdown*/
   showCostCentreOrPoetDetailsFields:function(obj){
	   var $this = this;
	   var form = this.getScholarshiprequestform();
	   var scholarshiprequestpanel = this.getScholarshiprequestpanel();
	   var costCentreOrPoetDetailsContainer = scholarshiprequestpanel.down('#costCentreOrPoetDetailsContainerId');
	   var costCentreOrPoetDetailsFieldContainer = obj.up(); 
	   
	   if(!isNullOrEmpty(obj.nextSibling())){ // to remove delete button
		   if(obj.nextSibling().itemId=='deleteRowsBtnId'){
		     costCentreOrPoetDetailsFieldContainer.remove(obj.nextSibling()); 
		   }
	   }
	   if(obj.getValue()=='COST_CENTER'){  
		   var costCentrePanelFirstRowItem = new Array();
		   var costCentrePanelsecondThirdRowItem = new Array();
		   var currentFieldContainer=obj.up();
		   var currentFieldContainerItems= currentFieldContainer.items.items;
		   costCentreOrPoetDetailsContainer.remove(obj.up().nextSibling());  //if user again select the value from drop down so to override new fields , deleted the existing one
		   costCentreOrPoetDetailsContainer.remove(obj.up().nextSibling());
		   costCentreOrPoetDetailsContainer.doLayout();
		   
		   var index;
		   var costCentreRows = costCentreOrPoetDetailsContainer.items.items;
		   for(var i=0;i<costCentreRows.length;i++){
			   if(costCentreRows[i].itemId==obj.up().itemId){
				   index=i;
				   break;
			   }
		   }
		   for(var i=0;i<currentFieldContainerItems.length;i++){  //to remove cost centre ahead fields
			   if(currentFieldContainerItems[i] && currentFieldContainerItems[i].itemId!='costCentreOrPoetDetails'){
				   currentFieldContainer.remove(currentFieldContainerItems[i]);
				   i--;
			   }
		   }
		   costCentrePanelFirstRowItem.push({
			   xtype: 'customcombobox',
			   fieldLabel: getCommonTranslation('COST_CENTRE')+':<span class="required" style="color:red"> *</span>',
			   name: 'costCentre',
			   itemId: 'costCentre',
			   /* store: Ext.create('Academia.store.scholarshipRequest.CostCenterScholarshipReqStore',{
				                           storeId: randomString(10)
				                       }),*/
			   store:'scholarshipRequest.CostCenterScholarshipReqStore',
			   valueField: 'id',
			   displayField: 'value', 
			   allowBlank:false,
			   labelSeparator:'',
			   style:index>0?{
				   //marginLeft:index>0 ? '-4px !important':'4px !important'
				   marginLeft:'-1px !important'
			   }:{
				   marginLeft:((this.scholarshipReqEditSCreen)? '-1px !important':'8px !important')
			   },
			   queryParam:'name',
			   minChars:3,
			   typeAhead:false,
			   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			   triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			   enableKeyEvents  : 'true',
			   forceSelection:true,
			   listConfig: {
				   listeners: {
					   beforeshow: function(picker) {
						   picker.width = picker.up('combobox').getSize().width;
					   }
				   },
				   loadingText: getCommonTranslation('SEARCHING'),
				   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			   }
			   /*  listConfig: {
			   listeners: {
				   beforeshow: function(picker) {
					   picker.minWidth = picker.up('combobox').getSize().width;
					   var store = picker.up('combobox').getStore();
					   store.on('load', function(){
						   var form = picker.up('combobox').up('form');
						   var store = picker.up('combobox').getStore();
						   var costCenterFields = form.query('#costCentre');
						   var selectedCostCenters = [];
						   store.clearFilter();
						   Ext.each(costCenterFields, function(combo) {
							   selectedCostCenters.push(combo.getValue());
						   });
						   if(selectedCostCenters.length){
							   store.filterBy(function(record) {
								   return !Ext.Array.contains(selectedCostCenters,record.get('id'));
							   });
						   }
					   });

				   }
			   }
       		},*/
		   },{
			   xtype:'textfield',
			   fieldLabel : getCommonTranslation('FEE_HEAD'),
			   itemId: 'feeHead',
			   name:'feeHead',
			   hidden: true,
			   readOnly:true,
		   },{
			   xtype: 'customcombobox',
			   fieldLabel: getCommonTranslation('TRANSACTION_ID'),
			   name: 'transactionId',
			   itemId: 'transactionId',
			   store: Ext.create('Academia.store.scholarshipRequest.TransactionIdStore',{
				                           storeId: 'transactionIdStore'+index}),
			   valueField: 'id',
			   displayField: 'code', 
			   disabled:true,
			   editable: false,
			   listConfig: {
				   loadingText: getCommonTranslation('SEARCHING'),
				   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				   listeners: {
					   beforeshow: function(picker) {
						   picker.width = picker.up('combobox').getSize().width;
					   }
				   },
			   },
		   },{
			   xtype:'textfield',
			   fieldLabel : getCommonTranslation('COST_CENTRE_AMOUNT')+':<span class="required" style="color:red"> *</span>',
			   itemId: 'amount',
			   name:'amount',
			   allowBlank:false,
			   labelSeparator:'',
			   maskRe: /[0-9.]/,
		   },{
			   xtype: 'button',
			   itemId: 'addMoreRowsBtnId',
			   cls: 'CustomBodyBtnSettings',
			   text: getCommonTranslation('ADDBUTTONTEXT'),
			   tooltip: getCommonTranslation('ADD'),
			   hidden: true,
			   width:40,
			   style:{
				   marginTop:'43px !important',
				   marginLeft:'9px !important'
			   }
		   },{
			   xtype: 'button',
			   glyph: ICONGLYPH.DELETEGLYPH,
			   cls: 'CustomBodyBtnReject',
			   itemId: 'deleteRowsBtnId',
			   tooltip: getCommonTranslation('DELETETOOLTIP'),
			   width:40,
			   hidden: index<1 ? true:false,
			   style:{
				  marginTop:'40px !important',
				  marginLeft:'-7px !important',
			    },
			    listeners:{
	   				   click:function(obj){
	   					var panelContainer = $this.getScholarshiprequestpanel().down('#costCentreOrPoetDetailsContainerId');
	   					panelContainer.remove(obj.up());
	   					$this.checkScholarReqFormValidity();
	   				   }
	   			   }
		   });
		   costCentreOrPoetDetailsFieldContainer.insert(2,costCentrePanelFirstRowItem);
		   costCentreOrPoetDetailsFieldContainer.doLayout();
		   $this.checkScholarReqFormValidity();
	   }else{   
		   var poetPanelFirstRowItem = new Array();
		   var poetPanelsecondThirdRowItem = new Array();
		   var currentFieldContainer=obj.up();
		   var currentFieldContainerItems= currentFieldContainer.items.items;
		   var index;
		   var costCentreRows = costCentreOrPoetDetailsContainer.items.items;
		   for(var i=0;i<costCentreRows.length;i++){  // to find out index of current row
			   if(costCentreRows[i].itemId==obj.up().itemId){
				   index=i;
				   break;
			   }
		   }
		   for(var i=0;i<currentFieldContainerItems.length;i++){  //to remove cost centre ahead fields
			   if(currentFieldContainerItems[i] && currentFieldContainerItems[i].itemId!='costCentreOrPoetDetails'){
				   currentFieldContainer.remove(currentFieldContainerItems[i]);
				   i--;
			   }
		   }
		   poetPanelFirstRowItem.push({
			   xtype: 'customcombobox',
			   fieldLabel: getCommonTranslation('PROJECT_NUMBER_NAME')+':<span class="required" style="color:red"> *</span>',
			   name: 'poetProjectNumber',
			   itemId: 'poetProjectNumber',
			   store: 'scholarshipRequest.ProjectNumberScholarshipReqStore',
			   valueField: 'id',
			   displayField: 'valueCode', 
			   labelSeparator:'',
			   allowBlank: false,
			   style:index>0?{
				   // marginLeft:index>0 ? '-2px !important':'8px !important'
				   marginLeft:'-1px !important'
			   }:{
				   marginLeft:((this.scholarshipReqEditSCreen)? '-1px !important':'8px !important')
			   },
			   allowBlank:false,
				allowBlank:false,
				queryParam:'qry',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}

		   },{
			   xtype:'textfield',
			   fieldLabel : getCommonTranslation('FEE_HEAD'),
			   itemId: 'poetFeeHead',
			   name:'poetFeeHead',
			   hidden: true,
			   readOnly:true,
		   },{
			   xtype:'textfield',
			   fieldLabel : getCommonTranslation('POET_AMOUNT')+':<span class="required" style="color:red"> *</span>',
			   itemId: 'poetAmount',
			   name:'poetAmount',
			   allowBlank:false,
			   labelSeparator:'',
			   maxLength:13,
			   maskRe: /[0-9.]/,
		   });
		   costCentreOrPoetDetailsFieldContainer.insert(2,poetPanelFirstRowItem);
		   costCentreOrPoetDetailsFieldContainer.doLayout();
		   
		   poetPanelsecondThirdRowItem.push({
			   xtype: 'fieldcontainer',
			   width:'100%',
			   itemId:'poetContainer'+Math.random(),
			   cls:'scholarshipDetailFormCls',
			   layout: {
				   type: 'hbox'
			   },
			   defaults :{
				   width: 226,
				   labelAlign:'top',
				   xtype:'customcombobox',
			   },
			   items:[{
				   fieldLabel : getCommonTranslation('TASK_NUMBER')+':<span class="required" style="color:red"> *</span>',
				   itemId: 'poetTaskNumber',
				   name:'poetTaskNumber',
				   store: Ext.create('Academia.store.scholarshipRequest.TaskNumberScholarshipReqStore',{
					                           storeId: randomString(10)
					                       }),
				   valueField: 'id',
				   displayField: 'valueCode', 
				   valueField: 'id',
					allowBlank:false,
					allowBlank:false,
					disabled:true,
					queryParam:'query',
					minChars:3,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					}
			   },{
				   fieldLabel : getCommonTranslation('CONTRACT_NUMBER'),
				   itemId: 'poetContractNumber',
				   name:'poetContractNumber',
				   store: Ext.create('Academia.store.scholarshipRequest.ContractNumberScholarshipReqStore',{
					                           storeId: randomString(10)
					                       }),
				   valueField: 'id',
				   displayField: 'valueCode', 
					disabled:true,
					queryParam:'query',
					minChars:3,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					}
			   },{
				   fieldLabel: getCommonTranslation('FUNDING_SOURCE_NUMBER'),
				   name: 'poetFundingSource',
				   itemId: 'poetFundingSource',
				   store: Ext.create('Academia.store.scholarshipRequest.FundingResourceScholarshipStore',{
					                           storeId: randomString(10)
					                       }),
				   valueField: 'id',
				   displayField: 'valueCode', 
				 	disabled:true,
					queryParam:'query',
					minChars:3,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					}
			   },{
				   fieldLabel: getCommonTranslation('EXPENDITURE_TYPE')+':<span class="required" style="color:red"> *</span>',
				   name: 'poetExpenditureType',
				   itemId: 'poetExpenditureType',
				   store: 'scholarshipRequest.ExpenditureTypeScholarshipStore',
				   valueField: 'id',
				   displayField: 'value', 
				   labelSeparator:'',
				 	queryParam:'query',
					minChars:3,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					}
			   }]
		   },{
			   xtype: 'fieldcontainer',
			   width:'100%',
			   itemId:'poetContainer'+Math.random(),
			   cls:'scholarshipDetailFormCls',
			   layout: {
				   type: 'hbox'
			   },
			   defaults :{
				   width: 226,
				   labelAlign:'top',
			   },
			   items:[{
				   xtype:'customcombobox',
				   itemId: 'poetExpenditureOrganization',
				   name:'poetExpenditureOrganization',
				   fieldLabel: getCommonTranslation('EXPENDITURE_ORGANIZATION')+':<span class="required" style="color:red"> *</span>',
				   store: 'scholarshipRequest.ExpenditureOrganizationScholarshipStore',
				   valueField: 'id',
				   displayField: 'value', 
				   labelSeparator:'',
				   allowBlank:false,
					allowBlank:false,
					queryParam:'query',
					minChars:3,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					}
			   },{
				   xtype: 'button',
				   itemId: 'addMoreRowsBtnId', //poetAddMoreRowsBtnId
				   cls: 'CustomBodyBtnSettings',
				   text: getCommonTranslation('ADDBUTTONTEXT'),
				   tooltip: getCommonTranslation('ADD'),
				   hidden:true,
				   width:40,
				   style:{
					   marginTop:'43px !important',
					   marginLeft:'9px !important'
				   }
			   },{
				   xtype: 'button',
				   glyph: ICONGLYPH.DELETEGLYPH,
				   cls: 'CustomBodyBtnReject',
				   itemId: 'deleteRowsBtnId',
				   tooltip: getCommonTranslation('DELETETOOLTIP'),
				   width:40,
				   hidden: index<1 ? true:false,
						   style:{
							   marginTop:'40px !important',
							   marginLeft:'-7px !important',
						   },
						   listeners:{
							   click:function(obj){
								   var panelContainer = $this.getScholarshiprequestpanel().down('#costCentreOrPoetDetailsContainerId');
								   panelContainer.remove(obj.up().previousSibling());
								   panelContainer.remove(obj.up().previousSibling());
								   panelContainer.remove(obj.up());
								   $this.checkScholarReqFormValidity();
							   }
						   }
			   }]
		   });
		   costCentreOrPoetDetailsContainer.insert(index+1,poetPanelsecondThirdRowItem);
		   costCentreOrPoetDetailsContainer.doLayout();
	   }
   },
   
   /*To add multiple record on click of add icon
    * @param1 = add icon*/
   addMultipleRecordForCostCenterOrPOET:function(obj){
	   var $this =this;
	   var form = this.getScholarshiprequestform();
	   var scholarshiprequestpanel = this.getScholarshiprequestpanel();
	   var costCentreOrPoetDetailsContainer = scholarshiprequestpanel.down('#costCentreOrPoetDetailsContainerId');
	   var newItemsArray = new Array();
	   var insertPosition=costCentreOrPoetDetailsContainer.items.items.length+1;
	   var costCentreOrPoetDetails = Ext.create('Ext.data.Store', {
		    fields: ['value', 'name'],
		    data : [
		        {"value":"COST_CENTER", "name":"Cost Centre"},
	            {"value":"POET", "name":"POET"}] 
		});
	   newItemsArray.push({
		        xtype: 'fieldcontainer',
		        itemId:'costOrPoetfirstRow'+Math.random(),
		        cls:'scholarshipDetailFormCls',
		        cls:'scholarshipDetailFormCls',
		        layout: {
		            type: 'hbox'
		        },
		        defaults: {
		            width: 226,
		            labelAlign: 'top'
		        },
		        items: [{
		        	xtype: 'customcombobox',
		        	fieldLabel: getCommonTranslation('COST_CENTRE_OR_POET_DETAILS')+':<span class="required" style="color:red"> *</span>',
		        	name: 'costCentreOrPoetDetails',
		        	itemId: 'costCentreOrPoetDetails',
		        	store: costCentreOrPoetDetails,
		        	valueField: 'value',
		        	displayField: 'name', 
		        	editable: false,
		        	allowBlank:false,
		        	labelSeparator:''
		        },{
		        	xtype: 'button',
		        	glyph: ICONGLYPH.DELETEGLYPH,
		        	cls: 'CustomBodyBtnReject',
		        	itemId:'deleteRowsBtnId',
		        	tooltip: getCommonTranslation('DELETETOOLTIP'),
		        	width:40,
		        	itemId:'deleteForCostCenterOrPoet',
		        	style:{
		        		marginTop:'43px !important',
		        	},
		        	listeners:{
		        		click:function(obj){
		        			var panelContainer = $this.getScholarshiprequestpanel().down('#costCentreOrPoetDetailsContainerId');
		   					panelContainer.remove(obj.up());
		   					$this.checkScholarReqFormValidity();
		        		}
		        	}
		        }]
		   });
	   
	   costCentreOrPoetDetailsContainer.insert(insertPosition,newItemsArray);
	   costCentreOrPoetDetailsContainer.doLayout();
	   $this.checkScholarReqFormValidity();
   },
   
   setDataForCostCenterFieldsInViewMode:function(costCenterAndPoetDetails,viewMode){
	   var $this =this;
	   var form = this.getScholarshiprequestform();
	   var mainContainer=form.down('#costCentreOrPoetDetailsContainerId');
	   mainContainer.removeAll();
	   var costCentreOrPoetDetails = Ext.create('Ext.data.Store', {
		    fields: ['value', 'name'],
		    data : [
		        {"value":"COST_CENTER", "name":"Cost Centre"},
		        {"value":"POET", "name":"POET"}]
		});

	   Ext.Array.each(costCenterAndPoetDetails,function(value,index){
		   if(value.isCostCenter){
			   var newItemsArray = new Array();
			   newItemsArray.push({
				   xtype: 'fieldcontainer',
				   itemId:'costOrPoetfirstRow'+Math.random(),
				   cls:'scholarshipDetailFormCls',
				   layout: {
					   type: 'hbox'
				   },
				   defaults: {
					   width: 226,
					   labelAlign: 'top'
				   },
				   items: [{
					   xtype:'hidden',
					   name: 'costCentreRecId',
					   itemId: 'costCentreRecId',
					   value:value.id
				   },{
					   xtype: 'customcombobox',
					   fieldLabel: getCommonTranslation('COST_CENTRE_OR_POET_DETAILS')+':<span class="required" style="color:red"> *</span>',
					   name: 'costCentreOrPoetDetails',
					   itemId: 'costCentreOrPoetDetails',
					   valueField: 'value',
					   displayField: 'name', 
					   editable: false,
					   store:costCentreOrPoetDetails,
					   readOnly:viewMode?true:false,
					   allowBlank:false,
					   labelSeparator:'',
					   value:'COST_CENTER'
				   },{
					   xtype: 'customcombobox',
					   fieldLabel: getCommonTranslation('COST_CENTRE')+':<span class="required" style="color:red"> *</span>',
					   name: 'costCentre',
					   itemId: 'costCentre',
					  /* store: Ext.create('Academia.store.scholarshipRequest.CostCenterScholarshipReqStore',{
					                           storeId: 'costCentreSchlStore'+index
					                       }),*/
					   store:'scholarshipRequest.CostCenterScholarshipReqStore',	   
					   valueField: 'id',
					   displayField: 'value', 
					   readOnly:viewMode?true:false,
							   allowBlank:false,
							   labelSeparator:'',
							   queryParam:'name',
							   minChars:3,
							   typeAhead:false,
							   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							   triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
							   enableKeyEvents  : 'true',
							   forceSelection:true,
							   listConfig: {
								   listeners: {
									   beforeshow: function(picker) {
										   picker.width = picker.up('combobox').getSize().width;
									   }
								   },
								   loadingText: getCommonTranslation('SEARCHING'),
								   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							   },
							   listeners: {
								   render: function(combo) {
									   var store= combo.getStore();
									   store.load({
										   callback:function(record, operation, success){
											   combo.setValue(value.costCentreId);
											   combo.nextSibling().setValue(value.feeHeadCostCen);
										   }
									   });
								   }
							   }
				   //value:value.id,
				   /*listConfig: {
					   listeners: {
						   beforeshow: function(picker) {
							   picker.minWidth = picker.up('combobox').getSize().width;
							   var store = picker.up('combobox').getStore();
							   store.on('load', function(){
								   var form = picker.up('combobox').up('form');
								   var store = picker.up('combobox').getStore();
								   var costCenterFields = form.query('#costCentre');
								   var selectedCostCenters = [];
								   store.clearFilter();
								   Ext.each(costCenterFields, function(combo) {
									   selectedCostCenters.push(combo.getValue());
								   });
								   if(selectedCostCenters.length){
									   store.filterBy(function(record) {
										   return !Ext.Array.contains(selectedCostCenters,record.get('id'));
									   });
								   }
							   });

						   },
					   }
		       		},*/
				   },{
					   xtype:'textfield',
					   fieldLabel : getCommonTranslation('FEE_HEAD'),
					   itemId: 'feeHead',
					   name:'feeHead',
					   hidden:true,
					   readOnly:true
				   },{
					   xtype: 'customcombobox',
					   fieldLabel: getCommonTranslation('TRANSACTION_ID'),
					   name: 'transactionId',
					   itemId: 'transactionId',
					   readOnly:viewMode?true:false,
							   store: Ext.create('Academia.store.scholarshipRequest.TransactionIdStore',{
								                           storeId: 'transactionIdStore'+index}),
								   valueField: 'id',
								   displayField: 'code', 
								   disabled:true,
								   editable: false,
								   listConfig: {
									   loadingText: getCommonTranslation('SEARCHING'),
									   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									   listeners: {
										   beforeshow: function(picker) {
											   picker.width = picker.up('combobox').getSize().width;
										   }
									   },
								   },
								   listeners: {
									   render: function(combo) {
										   var store= combo.getStore();
										   store.getProxy().extraParams = {
											   costCentreId : value.costCentreId
										   };
										   store.load({
											   callback:function(record, operation, success){
												   combo.setValue(value.costCenterTransectionId);
												   combo.setDisabled(false);
											   }
										   });
									   }
								   }
				   },{
					   xtype:'textfield',
					   fieldLabel : getCommonTranslation('COST_CENTRE_AMOUNT')+':<span class="required" style="color:red"> *</span>',
					   itemId: 'amount',
					   name:'amount',
					   readOnly:viewMode?true:false,
					   allowBlank:false,
					   labelSeparator:'',
					   maskRe: /[0-9.]/,
					   listeners: {
						   render: function(combo) {
							   if(value.amountCostCen){
							   combo.setValue(value.amountCostCen.toFixed(2));
							   }
						   }
					   }
				   },{
					   xtype: 'button',
					   itemId: 'addMoreRowsBtnId',
					   cls: 'CustomBodyBtnSettings',
					   text: getCommonTranslation('ADDBUTTONTEXT'),
					   tooltip: getCommonTranslation('ADD'),
					   width:40,
					   hidden:viewMode?true:false,
							   style:{
								   marginTop:'43px !important',
								   marginLeft:'9px !important'
							   }
				   },{
					   xtype: 'button',
					   glyph: ICONGLYPH.DELETEGLYPH,
					   cls: 'CustomBodyBtnReject',
					   tooltip: getCommonTranslation('DELETETOOLTIP'),
					   width:40,
					   itemId:'deleteForCostCenterOrPoet',
					   style:{
						   marginTop:'40px !important',
						   marginLeft:'-7px !important',
					   },
					   hidden:viewMode?true:(index<1 ? true:false),
							   listeners:{
								   click:function(obj){
									   var panelContainer = $this.getScholarshiprequestpanel().down('#costCentreOrPoetDetailsContainerId');
									   panelContainer.remove(obj.up());
									   $this.checkScholarReqFormValidity();
								   }
							   }
				   }]
			   });
			   mainContainer.insert(mainContainer.items.items.length,newItemsArray);
			   mainContainer.doLayout();
		   }else{
			   var newItemsArray = new Array();
			   var poetPanelFirstRowItem = new Array();
			   var poetPanelsecondThirdRowItem = new Array();
			   
			   poetPanelFirstRowItem.push({
						   xtype: 'fieldcontainer',
						   itemId:'costOrPoetfirstRow'+Math.random(),
						   cls:'scholarshipDetailFormCls',
						   layout: {
							   type: 'hbox'
						   },
						   defaults: {
							   width: 226,
							   labelAlign: 'top'
						   },
						   items: [{
							   xtype:'hidden',
							   name: 'poetRecId',
							   itemId: 'poetRecId',
							   value:value.id
						   },{
							   xtype: 'customcombobox',
							   fieldLabel: getCommonTranslation('COST_CENTRE_OR_POET_DETAILS')+':<span class="required" style="color:red"> *</span>',
							   name: 'costCentreOrPoetDetails',
							   itemId: 'costCentreOrPoetDetails',
							   valueField: 'value',
							   displayField: 'name', 
							   editable: false,
							   store:costCentreOrPoetDetails,
							   readOnly:viewMode?true:false,
									   allowBlank:false,
									   labelSeparator:'',
									   value:'POET'
						   },{
							   xtype: 'customcombobox',
							   fieldLabel: getCommonTranslation('PROJECT_NUMBER_NAME')+':<span class="required" style="color:red"> *</span>',
							   name: 'poetProjectNumber',
							   itemId: 'poetProjectNumber',
							   store: 'scholarshipRequest.ProjectNumberScholarshipReqStore',
							   valueField: 'id',
							   displayField: 'valueCode', 
							   labelSeparator:'',
							   allowBlank: false,
							   readOnly:viewMode?true:false,
							   queryParam:'qry',
							   minChars:3,
							   typeAhead:false,
							   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							   triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
							   enableKeyEvents  : 'true',
							   forceSelection:true,
							   listConfig: {
								   listeners: {
									   beforeshow: function(picker) {
										   picker.width = picker.up('combobox').getSize().width;
									   }
								   },
								   loadingText: getCommonTranslation('SEARCHING'),
								   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							   },
							   listeners: {
								   render: function(combo) {
									   var store= combo.getStore();
									   store.load({
										   callback:function(record, operation, success){
											   combo.setValue(value.projectNumberPriId);
											   combo.nextSibling().setValue(value.feeHeadPoetDet);
										   }
									   });
								   }
							   }

						   },{
							   xtype:'textfield',
							   fieldLabel : getCommonTranslation('FEE_HEAD'),
							   itemId: 'poetFeeHead',
							   hidden:true,
							   name:'poetFeeHead',
							   readOnly:true
						   },{
							   xtype:'textfield',
							   fieldLabel : getCommonTranslation('POET_AMOUNT')+':<span class="required" style="color:red"> *</span>',
							   itemId: 'poetAmount',
							   name:'poetAmount',
							   allowBlank:false,
							   labelSeparator:'',
							   maxLength:13,
							   maskRe: /[0-9.]/,
							   readOnly:viewMode?true:false,
							   listeners: {
								   render: function(combo) {
									   combo.setValue(value.amountCostCen);
								   }
							   }
						   }]
					   },{
						   xtype: 'fieldcontainer',
						   width:'100%',
						   itemId:'poetContainer'+Math.random(),
						   cls:'scholarshipDetailFormCls',
						   layout: {
							   type: 'hbox'
						   },
						   defaults :{
							   width: 226,
							   labelAlign:'top',
							   xtype:'customcombobox',
						   },
						   items:[{
							   fieldLabel : getCommonTranslation('TASK_NUMBER')+':<span class="required" style="color:red"> *</span>',
							   itemId: 'poetTaskNumber',
							   name:'poetTaskNumber',
							   store: Ext.create('Academia.store.scholarshipRequest.TaskNumberScholarshipReqStore',{
								                           storeId: randomString(10)
								                       }),
								   valueField: 'id',
								   displayField: 'valueCode', 
								   allowBlank: false,
								   labelSeparator:'',
								   readOnly:viewMode?true:false,
										   queryParam:'query',
											minChars:3,
											typeAhead:false,
											emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
											triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
											enableKeyEvents  : 'true',
											forceSelection:true,
											listConfig: {
												listeners: {
													beforeshow: function(picker) {
														picker.width = picker.up('combobox').getSize().width;
													}
												},
												loadingText: getCommonTranslation('SEARCHING'),
												emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
											},
								   listeners: {
									   render: function(combo) {
										   var store= combo.getStore();
										   store.getProxy().extraParams = {
											   poetMasterDetailId : value.projectNumberPriId
										   };
										   store.load({
											   callback:function(record, operation, success){
												   combo.setValue(value.taskNumberPriId);
											   }
										   });
									   }
								   }
						   },{
							   fieldLabel : getCommonTranslation('CONTRACT_NUMBER'),
							   itemId: 'poetContractNumber',
							   name:'poetContractNumber',
							   store: Ext.create('Academia.store.scholarshipRequest.ContractNumberScholarshipReqStore',{
								                           storeId: randomString(10)
								                       }),
								   valueField: 'id',
								   displayField: 'valueCode', 
								   readOnly:viewMode?true:false,
										   queryParam:'query',
											minChars:3,
											typeAhead:false,
											emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
											triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
											enableKeyEvents  : 'true',
											forceSelection:true,
								   listConfig: {
									   listeners: {
										   beforeshow: function(picker) {
											   picker.width = picker.up('combobox').getSize().width;
										   }
									   },
									   loadingText: getCommonTranslation('SEARCHING'),
									   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								   },
								   listeners: {
									   render: function(combo) {
										   var store= combo.getStore();
										   store.getProxy().extraParams = {
											   poetMasterDetailId : value.projectNumberPriId
										   };
										   store.load({
											   callback:function(record, operation, success){
												   combo.setValue(value.contractId);
											   }
										   });
									   }
								   }
						   },{
							   fieldLabel: getCommonTranslation('FUNDING_SOURCE_NUMBER'),
							   name: 'poetFundingSource',
							   itemId: 'poetFundingSource',
							   store: Ext.create('Academia.store.scholarshipRequest.FundingResourceScholarshipStore',{
								                           storeId: randomString(10)
								                       }),
								   valueField: 'id',
								   displayField: 'valueCode', 
								   readOnly:viewMode?true:false,
										   queryParam:'query',
											minChars:3,
											typeAhead:false,
											emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
											triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
											enableKeyEvents  : 'true',
											forceSelection:true,
								   listConfig: {
									   listeners: {
										   beforeshow: function(picker) {
											   picker.width = picker.up('combobox').getSize().width;
										   }
									   },
									   loadingText: getCommonTranslation('SEARCHING'),
									   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								   },
								   listeners: {
									   render: function(combo) {
										   var store= combo.getStore();
										   store.getProxy().extraParams = {
											   poetMasterContractId : value.contractId
										   };
										   store.load({
											   callback:function(record, operation, success){
												   combo.setValue(value.fundSourcePriId);
											   }
										   });
									   }
								   }
						   },{
							   fieldLabel: getCommonTranslation('EXPENDITURE_TYPE')+':<span class="required" style="color:red"> *</span>',
							   name: 'poetExpenditureType',
							   itemId: 'poetExpenditureType',
							   store: 'scholarshipRequest.ExpenditureTypeScholarshipStore',
							   valueField: 'id',
							   displayField: 'value', 
							   labelSeparator:'',
							   allowBlank: false,
							   readOnly:viewMode?true:false,
									  queryParam:'query',
										minChars:3,
										typeAhead:false,
										emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
										triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
										enableKeyEvents  : 'true',
										forceSelection:true,
							   listConfig: {
								   listeners: {
									   beforeshow: function(picker) {
										   picker.width = picker.up('combobox').getSize().width;
									   }
								   },
								   loadingText: getCommonTranslation('SEARCHING'),
								   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							   },
							   listeners: {
								   render: function(combo) {
									   var store= combo.getStore();
									   store.load({
										   callback:function(record, operation, success){
											   combo.setValue(value.expenditureTypePriId);
										   }
									   });
								   }
							   }
						   }]
					   },{
						   xtype: 'fieldcontainer',
						   width:'100%',
						   itemId:'poetContainer'+Math.random(),
						   cls:'scholarshipDetailFormCls',
						   layout: {
							   type: 'hbox'
						   },
						   defaults :{
							   width: 226,
							   labelAlign:'top',
						   },
						   items:[{
							   xtype:'customcombobox',
							   itemId: 'poetExpenditureOrganization',
							   name:'poetExpenditureOrganization',
							   fieldLabel: getCommonTranslation('EXPENDITURE_ORGANIZATION')+':<span class="required" style="color:red"> *</span>',
							   store: 'scholarshipRequest.ExpenditureOrganizationScholarshipStore',
							   valueField: 'id',
							   displayField: 'value', 
							   labelSeparator:'',
							   allowBlank: false,
							   editable: false,
							   readOnly:viewMode?true:false,
										queryParam:'query',
										minChars:3,
										typeAhead:false,
										emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
										triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
										enableKeyEvents  : 'true',
										forceSelection:true,
							   listConfig: {
								   listeners: {
									   beforeshow: function(picker) {
										   picker.width = picker.up('combobox').getSize().width;
									   }
								   },
								   loadingText: getCommonTranslation('SEARCHING'),
								   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							   },
							   listeners: {
								   render: function(combo) {
									   var store= combo.getStore();
									   store.load({
										   callback:function(record, operation, success){
											   combo.setValue(value.expenditureOrganizationPriId);
										   }
									   });
								   }

							   }
						   },{
							   xtype: 'button',
							   itemId: 'addMoreRowsBtnId', //poetAddMoreRowsBtnId
							   cls: 'CustomBodyBtnSettings',
							   text: getCommonTranslation('ADDBUTTONTEXT'),
							   tooltip: getCommonTranslation('ADD'),
							   width:40,
							   style:{
								   marginTop:'43px !important',
								   marginLeft:'9px !important'
							   },
							   hidden:viewMode?true:false
						   },{
							   xtype: 'button',
							   glyph: ICONGLYPH.DELETEGLYPH,
							   cls: 'CustomBodyBtnReject',
							   itemId: 'deleteRowsBtnId',
							   tooltip: getCommonTranslation('DELETETOOLTIP'),
							   width:40,
							   hidden:viewMode?true:(index<1 ? true:false),
									   style:{
										   marginTop:'40px !important',
										   marginLeft:'-7px !important',
									   },
									   listeners:{
										   click:function(obj){
											   var panelContainer = $this.getScholarshiprequestpanel().down('#costCentreOrPoetDetailsContainerId');
											   panelContainer.remove(obj.up().previousSibling());
											   panelContainer.remove(obj.up().previousSibling());
											   panelContainer.remove(obj.up());
											   $this.checkScholarReqFormValidity();
										   }
									   }
						   }]
					   });
			   mainContainer.insert(mainContainer.items.items.length,poetPanelFirstRowItem);
			   mainContainer.doLayout();

			  /* poetPanelsecondThirdRowItem.push();
			   mainContainer.insert(mainContainer.items.items.length,poetPanelsecondThirdRowItem);
			   mainContainer.doLayout();*/
		   }
	   });
	   
	  /* var mainContainerFields = mainContainer.items.items;
	   Ext.Array.each(mainContainerFields,function(value,index){
		   value.items.items[2].store.load();
		   value.items.items[2].setValue(costCenterAndPoetDetails[index].costCentreId);
	   });*/
   },
   
   /*To reset the raise scholarship form*/
   resetScholarshipRequestForm:function(){
	   var form = this.getScholarshiprequestform();
	   var container = form.down('#costCentreOrPoetDetailsContainerId');
	   var  costCentreOrPoetDetails= Ext.ComponentQuery.query('#costCentreOrPoetDetails');
	  /* for(i=0;i<costCentreOrPoetDetails.length;i++){
		   costCentreOrPoetDetails[i].suspendEvent('change');
		   costCentreOrPoetDetails[i].reset();
		   costCentreOrPoetDetails[i].resumeEvent('change');
	   }*/
	   //form.getForm().reset();
	   form.down('#assigneeToId').reset();
	   form.down('#scholarshipId').reset();
	   form.down('#workStatusOfStudent').reset();
	   form.down('#workStatusOfApplicant').reset();
	   form.down('#liableForTax').reset();
	   form.down('#stdUnderstandNoWorkDoneInExchangeOfBursary').reset();
	   form.down('#applicantUnderstandNoWorkDoneInExchangeOfBursary').reset();
	   form.down('#subsequentScholarshipAvailable').reset();
	   form.down('#subsequentAmount').reset();
	   form.down('#paymentTowardsFees').reset();
	   form.down('#paymentTowardsLivingExpensesOrAccommodation').reset();
	   form.down('#Other').reset();
	   form.down('#totalScholarshipAmount').reset();
	   form.down('#remark').reset();
	   form.down('#declaration').reset();
	   Ext.defer(function() {
			 form.down('#financialYear').reset();
			 form.down('#financialYear').setDisabled(true);
		},1000, this);
	   Ext.each(container.items.items, function(fieldContainer){
		   Ext.each(fieldContainer.items.items, function(field){
			   if(field.itemId!='costCentreOrPoetDetails'){
				   if(field.xtype!='button'){
					   field.reset();
					   if(field.itemId == 'poetTaskNumber' || field.itemId == 'poetContractNumber' || field.itemId == 'poetFundingSource'){
						   field.setDisabled(true);
					   }
				   }
			   }
		   });
	   });
	   //this.setBasicDetailsOnResetButtonClick(this.requesterType,this.gridRecord);
	  // form.down('#RequestDateId').setValue(dateFormatRender(new Date()));
   },
   
   saveScholarshipRaiseRequestForm:function(){
	   var this$ = this;
	   var form = this.getScholarshiprequestform();
	   var scholarshipCombo = form.down('#scholarshipId');
	   var stdStatusId = form.down('#stdStatusId').getValue();
	   var requesterTypeId = form.down('#requesterTypeId').getValue();
	   var selectedValue = scholarshipCombo.getValue(); 
	   var store = scholarshipCombo.getStore();
	   var selectedRecord = store.findRecord('id', selectedValue);
       var json = this.createJsonForScholarshipForm();
	   var formData = Ext.encode(json);
	   var studentGridView = this$.getScholarshipRequestListGridApplicant();
	   var applicantgridView = this$.getScholarshipRequestListGridStudent();
	   var urlPath;
	   var methodType;
	   var allCostCentreAmountFields = Ext.ComponentQuery.query('#amount');
	   var allPoetAmountFields = Ext.ComponentQuery.query('#poetAmount');
	   var sumOfCostCentreAmount=0;
	   var sumOfPoetAmount=0;
	   var sumOFCostCentreAndPOETAmount=0;
	   Ext.each(allCostCentreAmountFields,function(amountFields){
		   sumOfCostCentreAmount=sumOfCostCentreAmount+parseFloat(amountFields.getValue());
	   });
	   Ext.each(allPoetAmountFields,function(amountFields){
		   sumOfPoetAmount=sumOfPoetAmount+parseFloat(amountFields.getValue());
	   });
	   sumOFCostCentreAndPOETAmount=sumOfCostCentreAmount+sumOfPoetAmount;
	   var totalScholarshipAmount = form.down('#totalScholarshipAmount').getValue();
	   if(this$.scholarshipReqEditSCreen){
		   urlPath=SERVERURL.PATH_UPDATE_SCHOLARSHIP_RAISE_REQUEST;
		   methodType='PUT'
	   }else{
		   urlPath=SERVERURL.PATH_SAVE_SCHOLARSHIP_RAISE_REQUEST;
		   methodType='POST'
	   }
	   if(selectedRecord){
		   var allowInactive = selectedRecord.get('whetherAllowInactiveStudents');
		   if(allowInactive && requesterTypeId==='Student' && stdStatusId==="Inactive"){
			   showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_STUDENT_IS_INACTIVE_DO_YOU_STILL_WANT_TO_PROCEED'),function(btn,text){
				   if (btn == 'yes') {
					   if(totalScholarshipAmount>this$.scholarshipAmountPerStd && sumOFCostCentreAndPOETAmount>totalScholarshipAmount){
						   showWarningMessage(getCommonTranslation('ALERT'), '1. '+getCommonTranslation('THE_TOTAL_SCHOLARSHIP_AMOUNT_IS_GREATER_THAN_THE_AMOUNT_PER_STUDENT')+'<br>'+'2. '+getCommonTranslation('THE_TOTAL_OF_COST_CENTRE/POET_DETAILS_AMOUNT_DOES_NOT_MATCH_WITH_SCHOLARSHIP_TOTAL_AMOUNT'));
					   }else if(totalScholarshipAmount>this$.scholarshipAmountPerStd){
						   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_TOTAL_SCHOLARSHIP_AMOUNT_IS_GREATER_THAN_THE_AMOUNT_PER_STUDENT'));
					   }else if(sumOFCostCentreAndPOETAmount!=totalScholarshipAmount){
						   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_TOTAL_OF_COST_CENTRE/POET_DETAILS_AMOUNT_DOES_NOT_MATCH_WITH_SCHOLARSHIP_TOTAL_AMOUNT'));
					   }else{
						   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						   Ext.Ajax.request({
							   type : 'rest',
							   url : urlPath,
							   jsonData : formData,
							   method : methodType,
							   success : function(frm, action) {
								   var tabName = getCommonTranslation('SCHOLARSHIP_REQUEST');
								   Ext.getBody().unmask(); 
								   if(this$.scholarshipReqEditSCreen){
									   if(studentGridView.isHidden()){
										   applicantgridView.getStore().load();
										   applicantgridView.getSelectionModel().deselectAll();
									   }else{
										   studentGridView.getStore().load();
										   studentGridView.getSelectionModel().deselectAll();
									   }
								   }
								   if(this$.scholarshipReqEditSCreen){
									   if(form.responseText === 'SCHOLARSHIP_STATUS_IS_INACTIVE'){
										   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
									   }else{
										   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_REQUEST_UPDATE_SUCCESSFULLY'));
									   }
								   }else{
									   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_REQUEST_SAVED_SUCCESSFULLY'));
								   }
								   var getcontroller=this$.getController('menu.CoreERPNavigationController');
								   var getTab=getcontroller.getTab(tabName);
								   if(getTab!=null){
									   contentPanel.remove(getTab, true);
								   }
							   }
						   });
					   }
				   }
			   });
		   }else{
			   if(totalScholarshipAmount>this$.scholarshipAmountPerStd && sumOFCostCentreAndPOETAmount>totalScholarshipAmount){
				   showWarningMessage(getCommonTranslation('ALERT'), '1. '+getCommonTranslation('THE_TOTAL_SCHOLARSHIP_AMOUNT_IS_GREATER_THAN_THE_AMOUNT_PER_STUDENT')+'<br>'+'2. '+getCommonTranslation('THE_TOTAL_OF_COST_CENTRE/POET_DETAILS_AMOUNT_DOES_NOT_MATCH_WITH_SCHOLARSHIP_TOTAL_AMOUNT'));
			   }else if(totalScholarshipAmount>this$.scholarshipAmountPerStd){
				   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_TOTAL_SCHOLARSHIP_AMOUNT_IS_GREATER_THAN_THE_AMOUNT_PER_STUDENT'));
			   }else if(sumOFCostCentreAndPOETAmount!=totalScholarshipAmount){
				   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_TOTAL_OF_COST_CENTRE/POET_DETAILS_AMOUNT_DOES_NOT_MATCH_WITH_SCHOLARSHIP_TOTAL_AMOUNT'));
			   }else{
				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				   Ext.Ajax.request({
					   type : 'rest',
					   url : urlPath,
					   jsonData : formData,
					   method : methodType,
					   success : function(frm, action) {
						   var tabName = getCommonTranslation('SCHOLARSHIP_REQUEST');
						   Ext.getBody().unmask(); 
						   if(this$.scholarshipReqEditSCreen){
							   if(studentGridView.isHidden()){
								   applicantgridView.getStore().load();
								   applicantgridView.getSelectionModel().deselectAll();
							   }else{
								   studentGridView.getStore().load();
								   studentGridView.getSelectionModel().deselectAll();
							   }
						   }
						   if(this$.scholarshipReqEditSCreen){
							   if(form.responseText === 'SCHOLARSHIP_STATUS_IS_INACTIVE'){
								   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
							   }else{
								   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_REQUEST_UPDATE_SUCCESSFULLY'));
							   }
						   }else{
							   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_REQUEST_SAVED_SUCCESSFULLY'));
						   }
						   var getcontroller=this$.getController('menu.CoreERPNavigationController');
						   var getTab=getcontroller.getTab(tabName);
						   if(getTab!=null){
							   contentPanel.remove(getTab, true);
						   }
					   }
				   });
			   }
		   }
	   }
   },
   createJsonForScholarshipForm:function(){
	   var this$ =this;
	   var record = this.stdOrApplicantRecord;
	   var form = this.getScholarshiprequestform();
	   var formData = form.getForm().getValues();
	   var student;
	   var applicant;
	   var admission;
	   var programBatchSeatConfiguration;
	   var workStatus;
	   var isDoingNowork;
	   var json= new Object;
	   var costCentreOrPoetDetailsContainer = form.down('#costCentreOrPoetDetailsContainerId');
	   var costCenterDataArray=new Array();
	   var fieldContainer = costCentreOrPoetDetailsContainer.items.items;
       var requesterType = this.requesterType;
	   if(!isNullOrEmpty(record)){
		   if(this.requesterType=='Applicant'){
			   applicant ={
					   "id":this$.scholarshipReqEditSCreen?record.data.applicantId:record.data.ID
			   };
			   programBatchSeatConfiguration={
					   "id":this$.scholarshipReqEditSCreen?record.data.pbstId:record.data.PROG_BATCH_SEAT_CONFIG_ID
			   };
			   workStatus=formData.workStatusOfApplicant;
			   isDoingNowork=formData.applicantUnderstandNoWorkDoneInExchangeOfBursary;
		   }else if(this.requesterType=='Student'){
			   student={
					   "id":this$.scholarshipReqEditSCreen?record.data.studentId:record.data.ID
			   };

			   programBatchSeatConfiguration={
					   "id":this$.scholarshipReqEditSCreen?record.data.pbstId:record.data.PROGRAM_BATCH_SEAT_CONFIG_ID
			   };
			   admission={
					   "id":this$.scholarshipReqEditSCreen?record.data.addmissionId:record.data.ADMISSION_ID
			   };
			   workStatus=formData.workStatusOfStudent
			   isDoingNowork=formData.stdUnderstandNoWorkDoneInExchangeOfBursary;
		   }
	   }

	   var requestBy={
			          "id":this.getCurrentlyLoggedInUser().id
			       };
	   var assignedTo={
			   "id":formData.assigneeToId	   
	   };
	   var scholarship={
			   "id":formData.scholarshipId
	   };
	   var finacialYear={
			   "id":formData.financialYear
	   } 
	   

	   for(var j=0; j<fieldContainer.length; j++){
		   if(this$.scholarshipReqEditSCreen){ // req edit case
			   if(fieldContainer[j].items.items[0].itemId=='costCentreOrPoetDetails' ||
					   fieldContainer[j].items.items[1].itemId=='costCentreOrPoetDetails'){ //loop only iterate for 1st row of poet
				   if(fieldContainer[j].items.items[0].getValue()=='COST_CENTER' || 
						   fieldContainer[j].items.items[1].getValue()=='COST_CENTER'){
					   if(fieldContainer[j].items.items.length==8){
						   var costCentre={
								   "id":fieldContainer[j].items.items[2].getValue()
						   }
						   var costCentreChildTransaction={
								   "id":fieldContainer[j].items.items[4].getValue()
						   }
						   costCenterDataArray.push({
							   "costCentre":costCentre,
							   "amountCostCen":parseFloat(fieldContainer[j].items.items[5].getValue()),
							   "isCostCenter":true,
							   "costCentreChildTransaction":costCentreChildTransaction,
							   "id":fieldContainer[j].items.items[0].getValue()
						   });
					   }else{   //hidden id field will not be there in case of adding new row in edit case
						   var costCentre={
								   "id":fieldContainer[j].items.items[1].getValue()
						   }
						   var costCentreChildTransaction={
								   "id":fieldContainer[j].items.items[3].getValue()
						   }
						   costCenterDataArray.push({
							   "costCentre":costCentre,
							   "amountCostCen":parseFloat(fieldContainer[j].items.items[4].getValue()),
							   "isCostCenter":true,
							   "costCentreChildTransaction":costCentreChildTransaction
						   });
					   }
				   }else{
					   if(!fieldContainer[j].itemId.includes("poetContainer")){
						   if(fieldContainer[j].items.items.length==5){
							   var projectNum={
									   "id":fieldContainer[j].items.items[2].getValue()
							   }
							   var taskNum={
									   "id":fieldContainer[j].nextSibling().items.items[0].getValue()
							   }
							   var contractNum={
									   "id":fieldContainer[j].nextSibling().items.items[1].getValue()
							   }
							   var fundingSourceNum={
									   "id":fieldContainer[j].nextSibling().items.items[2].getValue()
							   }
							   var expenditureType={
									   "id":fieldContainer[j].nextSibling().items.items[3].getValue()
							   }
							   var expenditureOrganization={
									   "id":fieldContainer[j].nextSibling().nextSibling().items.items[0].getValue()
							   }
							   costCenterDataArray.push({
								   "poetMasterDetails":projectNum,
								   "amountCostCen":parseFloat(fieldContainer[j].items.items[4].getValue()),
								   "poetMasterTaskDetails":taskNum,
								   "poetMasterContractDetails":contractNum,
								   "poetMasterContractFundSource":fundingSourceNum,
								   "expenditureType":expenditureType,
								   "expenditureOrganization":expenditureOrganization,
								   "isCostCenter":false,
								   "id":fieldContainer[j].items.items[0].getValue()
							   });
						   }else{ // in case of edit while adding new row id field will not be there 
							   var projectNum={
									   "id":fieldContainer[j].items.items[1].getValue()
							   }
							   var taskNum={
									   "id":fieldContainer[j].nextSibling().items.items[0].getValue()
							   }
							   var contractNum={
									   "id":fieldContainer[j].nextSibling().items.items[1].getValue()
							   }
							   var fundingSourceNum={
									   "id":fieldContainer[j].nextSibling().items.items[2].getValue()
							   }
							   var expenditureType={
									   "id":fieldContainer[j].nextSibling().items.items[3].getValue()
							   }
							   var expenditureOrganization={
									   "id":fieldContainer[j].nextSibling().nextSibling().items.items[0].getValue()
							   }
							   costCenterDataArray.push({
								   "poetMasterDetails":projectNum,
								   "amountCostCen":parseFloat(fieldContainer[j].items.items[3].getValue()),
								   "poetMasterTaskDetails":taskNum,
								   "poetMasterContractDetails":contractNum,
								   "poetMasterContractFundSource":fundingSourceNum,
								   "expenditureType":expenditureType,
								   "expenditureOrganization":expenditureOrganization,
								   "isCostCenter":false,
							   });
						   }
					   }
				   }
			   }
		   }else{ // first time add case (req create)
			   if(fieldContainer[j].items.items[0].itemId=='costCentreOrPoetDetails'){
				   if(fieldContainer[j].items.items[0].getValue()=='COST_CENTER'){
					   var costCentre={
							   "id":fieldContainer[j].items.items[1].getValue()
					   }
					   var costCentreChildTransaction={
							   "id":fieldContainer[j].items.items[3].getValue()
					   }
					   costCenterDataArray.push({
						   "costCentre":costCentre,
						   "amountCostCen":parseFloat(fieldContainer[j].items.items[4].getValue()),
						   "isCostCenter":true,
						   "costCentreChildTransaction":costCentreChildTransaction
					   });
				   }else{
					   if(!fieldContainer[j].itemId.includes("poetContainer")){
						   var projectNum={
								   "id":fieldContainer[j].items.items[1].getValue()
						   }
						   var taskNum={
								   "id":fieldContainer[j].nextSibling().items.items[0].getValue()
						   }
						   var contractNum={
								   "id":fieldContainer[j].nextSibling().items.items[1].getValue()
						   }
						   var fundingSourceNum={
								   "id":fieldContainer[j].nextSibling().items.items[2].getValue()
						   }
						   var expenditureType={
								   "id":fieldContainer[j].nextSibling().items.items[3].getValue()
						   }
						   var expenditureOrganization={
								   "id":fieldContainer[j].nextSibling().nextSibling().items.items[0].getValue()
						   }
						   costCenterDataArray.push({
							   "poetMasterDetails":projectNum,
							   "amountCostCen":parseFloat(fieldContainer[j].items.items[3].getValue()),
							   "poetMasterTaskDetails":taskNum,
							   "poetMasterContractDetails":contractNum,
							   "poetMasterContractFundSource":fundingSourceNum,
							   "expenditureType":expenditureType,
							   "expenditureOrganization":expenditureOrganization,
							   "isCostCenter":false
						   });
					   }
				   }
			   }
		   }
	   }
	   json = {
			   "requestStatus":"ASSIGNED",
               "requestBy":requestBy,
			   "student":student,
			   "applicant":applicant,
			   "admission":admission,
			   "programBatchSeatConfiguration":programBatchSeatConfiguration,
			   "requesterType":requesterType,
			   "requestDate":formData.requestDateId,
			   "assignedTo":assignedTo,
			   "scholarship":isNullOrEmpty(formData.scholarshipId)?null:scholarship,
			   "finacialYear":formData.financialYear,
			   "workStatus":workStatus,
			   "isTaxLiable":formData.liableForTax,
			   "isDoingNowork":isDoingNowork,
			   "isSubsequentBusary":formData.subsequentScholarshipAvailable,
			   "studentFees":parseFloat(formData.paymentTowardsFees),
			   "accomondationFees":parseFloat(formData.paymentTowardsLivingExpensesOrAccommodation),
			   "otherFees":parseFloat(formData.Other),
			   "totalScholarshipAmount":parseFloat(formData.totalScholarshipAmount).toFixed(2),
			   "remark":formData.remark,
			   "costCenterAndPoetDetails":costCenterDataArray,
			   "subsequentAmount":formData.subsequentAmount
	   };
	   if(this$.scholarshipReqEditSCreen){
		   json.id = parseInt(formData.recordId);
	   }
	   return json;
   },
   applyDFRForScholarshipMasterForm: function(form,mode){
	   var $this=this;
	  var awardWithOther= form.down('#awardwithOtherId').getValue();
	  var fundAdminName= form.down('#fundAdminId').getValue().fundAdminName;
	  var applicationRequired= form.down('#applicationRequiredId').getValue().applicationRequired;
	   Ext.Ajax.request({
		   type: 'rest',
		   async: false,
		   url: SERVERURL.COMMON_FORM_FIELD_INFO,
		   params: {
			   screenName: 'addscholarshiptabform',
			   academyLocationId: $this.getCurrentAcademyLocation(),
			   languageCode:'en'
		   },
		   method: 'GET',
		   success: function(res, action) {
			   var response = Ext.decode(res.responseText);
			   if( Object.keys(response).length > 0 ){
				   form.down('#allowSchoalrshipIDName').setVisible(false);
				   form.down('#applicationStartDateId').setVisible(false);
				   form.down('#applicationEndDateId').setVisible(false);
				   form.down('#allowApplicationAfterEndDateId').setVisible(false);
				   form.down('#internalFundAdminId').setVisible(false);
				   var records=response.addscholarshiptabform;
				   for(i in records){  
					  if(records[i].formFieldId=='allowSchoalrshipIDName' && records[i].isVisible==true && awardWithOther=='ONLY_ALLOWED_SCHOLARSHIP') {
						  form.down('#allowSchoalrshipIDName').setVisible(true);
					  }
					  if(records[i].formFieldId=='internalFundAdminId' && records[i].isVisible==true && fundAdminName==true) {
						  form.down('#internalFundAdminId').setVisible(true);
					  }
					  if(records[i].formFieldId=='applicationStartDateId' && records[i].isVisible==true && applicationRequired==true ) {
						  form.down('#applicationStartDateId').setVisible(true);  
					  }
					  if(records[i].formFieldId=='applicationEndDateId' && records[i].isVisible==true && applicationRequired==true){
						  form.down('#applicationEndDateId').setVisible(true);
					  }
					  if(records[i].formFieldId=='allowApplicationAfterEndDateId' && records[i].isVisible==true && applicationRequired==true){
						  form.down('#allowApplicationAfterEndDateId').setVisible(true);
					  }
				   }
				   }
		   }
		   });
   },
   applyDFRForScholarshipRequestForm:function(form){
	   var $this=this;
	   form.down('#RequestDateId').setFieldLabel(getCommonTranslation('REQUEST_DATE')+':');
	   if(this.requesterType=='Student'){
		   form.down('#studentId').setVisible(true);
		   form.down('#workStatusOfStudent').setVisible(true);
		   form.down('#stdUnderstandNoWorkDoneInExchangeOfBursary').setVisible(true);
		}else if(this.requesterType=='Applicant'){
		   form.down('#applicantId').setVisible(true);
		   form.down('#workStatusOfApplicant').setVisible(true);
		   form.down('#applicantUnderstandNoWorkDoneInExchangeOfBursary').setVisible(true);
		}
	   
	   Ext.Ajax.request({
		   type: 'rest',
		   async: false,
		   url: SERVERURL.COMMON_FORM_FIELD_INFO,
		   params: {
			   screenName: 'scholarshiprequestform',
			   academyLocationId: $this.getCurrentAcademyLocation(),
			   languageCode:'en'
		   },
		   method: 'GET',
		   success: function(res, action) {
			   var response = Ext.decode(res.responseText);
			   if( Object.keys(response).length > 0 ){
				   var records=response.scholarshiprequestform;
				   for(i in records){  
					   if(records[i].formFieldId=='studentId' && records[i].isVisible==true && $this.requesterType=='Student'){
						   form.down('#studentId').setVisible(true);
						   form.down('#applicantId').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#applicantId').allowBlank=true;
						   }
					   }else if(records[i].formFieldId=='studentId' && records[i].isVisible==false && $this.requesterType=='Student' ){  
						   form.down('#studentId').setVisible(false);
						   form.down('#applicantId').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#applicantId').allowBlank=true;
						   }
					   }
					   
					   if(records[i].formFieldId=='applicantId' && records[i].isVisible==true && $this.requesterType=='Applicant'){
						   form.down('#applicantId').setVisible(true);
						   form.down('#studentId').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#studentId').allowBlank=true;
						   }
					   }else if(records[i].formFieldId=='applicantId'  && records[i].isVisible==false && $this.requesterType=='Applicant'){
						   form.down('#applicantId').setVisible(false);
						   form.down('#studentId').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#studentId').allowBlank=true;
						   }
					   }
					   
					   if(records[i].formFieldId=='workStatusOfStudent' && records[i].isVisible==true && $this.requesterType=='Student'){
						   form.down('#workStatusOfStudent').setVisible(true);
						   form.down('#workStatusOfApplicant').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#workStatusOfApplicant').allowBlank=true;
						   }
					   }else if(records[i].formFieldId=='workStatusOfStudent' && records[i].isVisible==false && $this.requesterType=='Student' ){
						   form.down('#workStatusOfStudent').setVisible(false);
						   form.down('#workStatusOfApplicant').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#workStatusOfApplicant').allowBlank=true;
						   }
					   }
					   
					   if(records[i].formFieldId=='workStatusOfApplicant' && records[i].isVisible==true && $this.requesterType=='Applicant'){
						   form.down('#workStatusOfApplicant').setVisible(true);
						   form.down('#workStatusOfStudent').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#workStatusOfStudent').allowBlank=true;
						   }
					   }else if(records[i].formFieldId=='workStatusOfApplicant' && records[i].isVisible==false  && $this.requesterType=='Applicant'){
						   form.down('#workStatusOfApplicant').setVisible(false);
						   form.down('#workStatusOfStudent').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#workStatusOfStudent').allowBlank=true;
						   }
					   }
					   
					   if(records[i].formFieldId=='stdUnderstandNoWorkDoneInExchangeOfBursary' && records[i].isVisible==true && $this.requesterType=='Student'){
						   form.down('#stdUnderstandNoWorkDoneInExchangeOfBursary').setVisible(true);
						   form.down('#applicantUnderstandNoWorkDoneInExchangeOfBursary').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#applicantUnderstandNoWorkDoneInExchangeOfBursary').allowBlank=true;
						   }
					   }else if(records[i].formFieldId=='stdUnderstandNoWorkDoneInExchangeOfBursary'  && records[i].isVisible==false && $this.requesterType=='Student'){
						   form.down('#stdUnderstandNoWorkDoneInExchangeOfBursary').setVisible(false);
						   form.down('#applicantUnderstandNoWorkDoneInExchangeOfBursary').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#applicantUnderstandNoWorkDoneInExchangeOfBursary').allowBlank=true;
						   }
					   }
					   
					   if(records[i].formFieldId=='applicantUnderstandNoWorkDoneInExchangeOfBursary' && records[i].isVisible==true && $this.requesterType=='Applicant'){
						   form.down('#applicantUnderstandNoWorkDoneInExchangeOfBursary').setVisible(true);
						   form.down('#stdUnderstandNoWorkDoneInExchangeOfBursary').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#stdUnderstandNoWorkDoneInExchangeOfBursary').allowBlank=true;
						   }
					   }else if(records[i].formFieldId=='applicantUnderstandNoWorkDoneInExchangeOfBursary' && records[i].isVisible==false && $this.requesterType=='Applicant' ){
						   form.down('#applicantUnderstandNoWorkDoneInExchangeOfBursary').setVisible(false);
						   form.down('#stdUnderstandNoWorkDoneInExchangeOfBursary').setVisible(false);
						   if(records[i].isMandatory){
							   form.down('#stdUnderstandNoWorkDoneInExchangeOfBursary').allowBlank=true;
						   }
					   }
					   
					   if(records[i].formFieldId=='RequestDateId' && records[i].formFieldLabel){
						   form.down('#RequestDateId').setFieldLabel(records[i].formFieldLabel+':');
					   }
					   
					   if(records[i].formFieldId=='RequestDateId' && records[i].isVisible==false){
						   form.down('#RequestDateId').setVisible(false);
					   }
					   
					   if(records[i].formFieldId=='RequestDateId' && records[i].isMandatory==true){
						   var fieldLabel = form.down('#RequestDateId').getFieldLabel();
						   form.down('#RequestDateId').setFieldLabel(fieldLabel+'<span class="required" style="color:red"> *</span>');
					   }
					   
					   if(form.down('#subsequentScholarshipAvailable').getValue().subsequentScholarshipAvailable && records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='subsequentAmount' && records[i].isVisible==true){
   						    form.down('#subsequentAmount').setVisible(true);
        					form.down('#subsequentAmount').allowBlank=false;
        					form.down('#subsequentAmount').labelSeparator ='';
        					form.down('#subsequentAmount').setFieldLabel(fieldLabel+ ':<span class="required" style="color:red"> *</span>');
   					   }else{
        					form.down('#subsequentAmount').setVisible(false);
        					form.down('#subsequentAmount').allowBlank=true;
        					form.down('#subsequentAmount').reset();
        				}
				   }
			   }
		   }
	   });
   },
   serachScholarshipRequestList:function(btn){
	   btn.setDisabled(true);
	   var me = this,gridView,studentStatus,
	   serachForm = me.getScholarshipRequestListSerachForm(),
	   serachFormVal = serachForm.getValues();
	   if(serachFormVal.stdStatus==="ACTIVE"){
		   studentStatus=true;
	   }else if(serachFormVal.stdStatus==="INACTIVE"){
		   studentStatus=false;
	   }else{
		   studentStatus='All'; 
	   }
	   if(serachFormVal.requesterType == "Student"){
		   gridView = me.getScholarshipRequestListGridStudent();
		   delete serachFormVal.applicantId; 
		   gridView.getStore().getProxy().extraParams = {
			   requestId:serachFormVal.requestId,
			   requesterType:serachFormVal.requesterType,
			   studentId:serachFormVal.studentId,
			   scholarshipId:serachFormVal.scholarshipId,
			   requestById:serachFormVal.requestById,
			   requstAssigntoId:serachFormVal.requstAssigntoId,
			   requestStatus:serachFormVal.requestStatus,
			   fromDate:serachFormVal.fromDate,
			   toDate:serachFormVal.toDate,
			   loggedInUser:me.getCurrentlyLoggedInUser().id,
			   studentStatus:studentStatus
	       };
	   }else{
		   gridView = me.getScholarshipRequestListGridApplicant();
		   delete serachFormVal.studentId;
		   gridView.getStore().getProxy().extraParams = {
			   requestId:serachFormVal.requestId,
			   requesterType:serachFormVal.requesterType,
			   applicantId:serachFormVal.applicantId,
			   scholarshipId:serachFormVal.scholarshipId,
			   requestById:serachFormVal.requestById,
			   requstAssigntoId:serachFormVal.requstAssigntoId,
			   requestStatus:serachFormVal.requestStatus,
			   fromDate:serachFormVal.fromDate,
			   toDate:serachFormVal.toDate,
			   loggedInUser:me.getCurrentlyLoggedInUser().id
	       };
	   }
	   me.resetPageSetting(gridView.getStore());
	   gridView.getSelectionModel().deselectAll();
	   gridView.getStore().load(function(){
		   btn.setDisabled(false);
	   })
   },
   /*checkWhetherAllCostCenterAmtIsLessThanTotalScholarshipAmt:function(){
		var form =  this.getScholarshiprequestform();
		var submittBtn = form.down('#submitBtn');
		var declaration = form.down('#declaration');
		var totalScholarshipAmount = form.down('#totalScholarshipAmount').getValue();
		var amountFields = form.query('#amount');
		var sumOfAllRowsAmount=0;
		 Ext.each(amountFields, function(field) {
			 sumOfAllRowsAmount = sumOfAllRowsAmount + parseFloat(field.getValue());
		 });
		 if(sumOfAllRowsAmount<=totalScholarshipAmount && form.isValid() && totalScholarshipAmount<=this.scholarshipAmountPerStd && declaration.getValue()){
			 return true;
		 }else{
			 return false;
		 }
   },*/
   checkValidationWhetherRadioBtnIsYesOrNo:function(){
		var form =  this.getScholarshiprequestform();
		var submittBtn = form.down('#submitBtn');
		var declaration = form.down('#declaration');
		var alertFieldBasedOnRadioBtn  =  form.down('#alertFieldIfNoIsSelectedInWorkDoneRadioBtn');
		var radioValue;
		if(this.requesterType=='Student'){
			radioValue = form.down('#stdUnderstandNoWorkDoneInExchangeOfBursary').getValue().stdUnderstandNoWorkDoneInExchangeOfBursary;
		}else{
			radioValue = form.down('#applicantUnderstandNoWorkDoneInExchangeOfBursary').getValue().applicantUnderstandNoWorkDoneInExchangeOfBursary;
		}
		if(radioValue==false){
			alertFieldBasedOnRadioBtn.setVisible(true);
			if(this.requesterType=='Student'){
				alertFieldBasedOnRadioBtn.setValue(getCommonTranslation('STUDENT_MUST_BE_INFORMED'));
			}else if(this.requesterType=='Applicant'){
				alertFieldBasedOnRadioBtn.setValue(getCommonTranslation('APPLICANT_MUST_BE_INFORMED'));
			}
			 return false;
		}else{
			alertFieldBasedOnRadioBtn.setVisible(false);
			if(form.isValid() && declaration.getValue()){
  			 return true;
  			}
		}
   },
   checkScholarReqFormValidity:function(){
	   var form =  this.getScholarshiprequestform();
	   //var  amountValidity = this.checkWhetherAllCostCenterAmtIsLessThanTotalScholarshipAmt();
	   var radioBtnValidity = this.checkValidationWhetherRadioBtnIsYesOrNo();
	   var submitBtn = form.down('#submitBtn');
	   if(form.getForm().isValid() && radioBtnValidity){
		   submitBtn.setDisabled(false);
	   }else{
		   submitBtn.setDisabled(true);
		   return false;
	   }
   },
   rejectScholarshipRequest:function(btn){
	   btn.setDisabled(true);
	   var me = this, jsonDataEncode,params,apiUrl,scholarshipRaiseRequest,raiseRequestReviewer,apiMethod,selectedRecord,
	   contentPanel =  me.getContentPanel(),
	   form = btn.up('form'),
	   formRecord = me.gridRecord,
	   followUpRemarks,
	   studentGridView = me.getScholarshipRequestListGridApplicant(),
	   applicantgridView = me.getScholarshipRequestListGridStudent(),
	   currentloggedInUserId=me.getCurrentlyLoggedInUser().id,
	   activeTab = me.getActiveTabfromContentPanel();
	   if(studentGridView.isHidden()){
		   selectedRecord= applicantgridView.getSelectionModel().getSelection()[0];
	   }else{
		   selectedRecord= studentGridView.getSelectionModel().getSelection()[0];
	   }
	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	   if(me.loggedInUserRoles=='Scholarship Officer' || (currentloggedInUserId==1 && selectedRecord.data.requestStatus=="Approved")){
		   apiMethod='POST';
		   apiUrl=SERVERURL.PATH_BURSARY_OFFICER_EXECUTION_DETAIL_SAVE;
		   followUpRemarks = form.down('#executionFollowUpRemarks').getValue();
		   scholarshipRaiseRequest={
				          "id":formRecord.data.id
				       };
		   raiseRequestReviewer={
				    "id":currentloggedInUserId
		   };
		   params = {
				   scholarshipRaiseRequest : scholarshipRaiseRequest,
				   raiseRequestReviewer : raiseRequestReviewer,
				   reviewerRequestStatus :"REJECTED",
				   followUpRemark:followUpRemarks
		   };
	   }else{
		   apiMethod='PUT';
		   apiUrl=SERVERURL.PATH_SAVE_SCHOLARSHIP_FOLLOWUPDETAILS;
		   followUpRemarks = form.down('#followUpRemarks').getValue()
		   params = {
				   id :formRecord.data.scholarshipFollowUpDetails[0].id,
				   reviewerUserId : (currentloggedInUserId==1)?1:formRecord.data.assignedToId,
				   raiseRequestorUserId:formRecord.data.requestById,
				   raiseRequestId : formRecord.data.id,
				   declerationAcceptance :true,
				   followUpRemark:followUpRemarks,
				   status :"REJECTED"
		   };
	   }
	   jsonDataEncode =  Ext.encode(params);
	   Ext.Ajax.request({
           type: 'rest',
           url: apiUrl,
           jsonData: jsonDataEncode,
           method: apiMethod,

           success: function(form, action) {
           	  Ext.getBody().unmask();
	           	 if(studentGridView.isHidden()){
	           		applicantgridView.getStore().load();
	           		applicantgridView.getSelectionModel().deselectAll();
	             }else{
	            	 studentGridView.getStore().load();
	            	 studentGridView.getSelectionModel().deselectAll();
	             }
	           	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('REQUEST_REJECTED_SUCCESSFULLY'));
	            contentPanel.remove(activeTab);
              
           }

       });
   },
   reSubmitScholarshipRequest:function(btn){
	   btn.setDisabled(true);
	   var me = this, jsonDataEncode,params,apiUrl,scholarshipRaiseRequest,raiseRequestReviewer,apiMethod,selectedRecord,
	   contentPanel =  me.getContentPanel(),
	   form = btn.up('form'),
	   formRecord = me.gridRecord,
	   followUpRemarks,
	   studentGridView = me.getScholarshipRequestListGridApplicant(),
	   applicantgridView = me.getScholarshipRequestListGridStudent(),
	   currentloggedInUserId=me.getCurrentlyLoggedInUser().id,
	   activeTab = me.getActiveTabfromContentPanel();
	   if(studentGridView.isHidden()){
		   selectedRecord= applicantgridView.getSelectionModel().getSelection()[0];
	   }else{
		   selectedRecord= studentGridView.getSelectionModel().getSelection()[0];
	   }
	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	   if(me.loggedInUserRoles=='Scholarship Officer' || (currentloggedInUserId==1 && selectedRecord.data.requestStatus=="Approved")){
		   apiMethod='POST';
		   apiUrl=SERVERURL.PATH_BURSARY_OFFICER_EXECUTION_DETAIL_SAVE;
		   followUpRemarks = form.down('#executionFollowUpRemarks').getValue();
		   scholarshipRaiseRequest={
				          "id":formRecord.data.id
				       };
		   raiseRequestReviewer={
				    "id":formRecord.data.assignedToId
		   };
		   params = {
				   scholarshipRaiseRequest : scholarshipRaiseRequest,
				   raiseRequestReviewer : currentloggedInUserId,
				   reviewerRequestStatus :"RESUBMITTED",
				   followUpRemark:followUpRemarks
		   };
	   }else{
		   apiMethod='PUT';
		   apiUrl=SERVERURL.PATH_SAVE_SCHOLARSHIP_FOLLOWUPDETAILS;
		   followUpRemarks = form.down('#followUpRemarks').getValue()
		   params = {
			   id :formRecord.data.scholarshipFollowUpDetails[0].id,
			   reviewerUserId : (currentloggedInUserId==1)?1:formRecord.data.assignedToId,
			   raiseRequestorUserId:formRecord.data.requestById,
			   raiseRequestId : formRecord.data.id,
			   declerationAcceptance :true,
			   followUpRemark:followUpRemarks,
			   status :"SUBMITTED"
		   };
	   }
	   jsonDataEncode =  Ext.encode(params);
	   Ext.Ajax.request({
           type: 'rest',
           url: apiUrl,
           jsonData: jsonDataEncode,
           method: apiMethod,

           success: function(form, action) {
           	  Ext.getBody().unmask();
	           	 if(studentGridView.isHidden()){
	           		applicantgridView.getStore().load();
	           		applicantgridView.getSelectionModel().deselectAll();
	             }else{
	            	 studentGridView.getStore().load();
	            	 studentGridView.getSelectionModel().deselectAll();
	             }
                 showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('REQUEST_SUBMITTED_SUCCESSFULLY'));
                 contentPanel.remove(activeTab);
           }

       });
   },
   approveScholarshipRequest:function(btn){
	   btn.setDisabled(true);
	   var me = this, jsonDataEncode,params,apiUrl,scholarshipRaiseRequest,raiseRequestReviewer,apiMethod,selectedRecord,$btn=btn,
	   contentPanel =  me.getContentPanel(),
	   form = btn.up('form'),
	   formRecord = me.gridRecord,
	   followUpRemarks,
	   studentGridView = me.getScholarshipRequestListGridApplicant(),
	   applicantgridView = me.getScholarshipRequestListGridStudent(),
	   currentloggedInUserId=me.getCurrentlyLoggedInUser().id,
	   activeTab = me.getActiveTabfromContentPanel(),
	   scholarshipCombo = form.down('#scholarshipId'),
	   stdStatus = form.down('#stdStatusId').getValue(),
	   requesterTypeId = form.down('#requesterTypeId').getValue()
	   selectedValue = scholarshipCombo.getValue(),
	   store = scholarshipCombo.getStore(),
	   selectedSchlRec = store.findRecord('id', selectedValue);
	   
	   if(studentGridView.isHidden()){
		   selectedRecord= applicantgridView.getSelectionModel().getSelection()[0];
	   }else{
		   selectedRecord= studentGridView.getSelectionModel().getSelection()[0];
	   }
	   //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	   if(me.loggedInUserRoles=='Scholarship Officer' || (currentloggedInUserId==1 && selectedRecord.data.requestStatus=="Approved")){
		   apiMethod='POST';
		   apiUrl=SERVERURL.PATH_BURSARY_OFFICER_EXECUTION_DETAIL_SAVE;
		   followUpRemarks = form.down('#executionFollowUpRemarks').getValue();
		   scholarshipRaiseRequest={
				          "id":formRecord.data.id
				       };
		   raiseRequestReviewer={
				    "id":currentloggedInUserId
		   };
		   params = {
				   scholarshipRaiseRequest : scholarshipRaiseRequest,
				   raiseRequestReviewer : raiseRequestReviewer,
				   reviewerRequestStatus :"APPROVED",
				   followUpRemark:followUpRemarks
		   };
	   }else{
		   apiMethod='PUT';
		   apiUrl=SERVERURL.PATH_SAVE_SCHOLARSHIP_FOLLOWUPDETAILS;
		   followUpRemarks = form.down('#followUpRemarks').getValue()
		   params = {
				   id :formRecord.data.scholarshipFollowUpDetails[0].id,
				   reviewerUserId : (currentloggedInUserId==1)?1:formRecord.data.assignedToId,
				   raiseRequestorUserId:formRecord.data.requestById,
				   raiseRequestId : formRecord.data.id,
				   declerationAcceptance :true,
				   followUpRemark:followUpRemarks,
				   status :"APPROVED"
		   };
	   }
	   if(selectedSchlRec){
		   var allowInactive = selectedSchlRec.get('whetherAllowInactiveStudents');
		   if(allowInactive && requesterTypeId==='Student' && stdStatus==='false'){
			   showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_STUDENT_IS_INACTIVE_DO_YOU_STILL_WANT_TO_PROCEED'),function(btn,text){
				   if (btn == 'yes') {
					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					   Ext.Ajax.request({
						   type: 'rest',
						   url: SERVERURL.PATH_IS_SCHOLARSHIP_ACTIVE,
						   params: {
							   raiseRequestId: formRecord.data.id
						   },
						   method: 'GET',
						   success: function(form, action) {
							   Ext.getBody().unmask();
							   if(form.responseText === "false"){
								   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
							   }else{
								   jsonDataEncode =  Ext.encode(params);
								   Ext.Ajax.request({
									   type: 'rest',
									   url: apiUrl,
									   jsonData: jsonDataEncode,
									   method: apiMethod,
									   success: function(form, action) {
										   Ext.getBody().unmask();
										   if(studentGridView.isHidden()){
											   applicantgridView.getStore().load();
											   applicantgridView.getSelectionModel().deselectAll();
										   }else{
											   studentGridView.getStore().load();
											   studentGridView.getSelectionModel().deselectAll();
										   }
										   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('REQUEST_APPROVED_SUCCESSFULLY'));
										   contentPanel.remove(activeTab);
									   }
								   });
							   }
						   },
						   failure: function(form, action) {
							   Ext.getBody().unmask();
						   }
					   })
				   }else{
					   $btn.setDisabled(false);
				   }
			   }); 
		   }else{
			   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			   Ext.Ajax.request({
				   type: 'rest',
				   url: SERVERURL.PATH_IS_SCHOLARSHIP_ACTIVE,
				   params: {
					   raiseRequestId: formRecord.data.id
				   },
				   method: 'GET',
				   success: function(form, action) {
					   Ext.getBody().unmask();
					   if(form.responseText === "false"){
						   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
					   }else{
						   jsonDataEncode =  Ext.encode(params);
						   Ext.Ajax.request({
							   type: 'rest',
							   url: apiUrl,
							   jsonData: jsonDataEncode,
							   method: apiMethod,
							   success: function(form, action) {
								   Ext.getBody().unmask();
								   if(studentGridView.isHidden()){
									   applicantgridView.getStore().load();
									   applicantgridView.getSelectionModel().deselectAll();
								   }else{
									   studentGridView.getStore().load();
									   studentGridView.getSelectionModel().deselectAll();
								   }
								   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('REQUEST_APPROVED_SUCCESSFULLY'));
								   contentPanel.remove(activeTab);
							   }
						   });
					   }
				   },
				   failure: function(form, action) {
					   Ext.getBody().unmask();
				   }
			   });
		   }
	   }
   },
    saveIntelliMaliRecord: function(){
		var $this = this;
		var grid = $this.getIntellimaligrid();
		var json;
		

		var submitUrl;
		var isView = '';
		
			json = $this.createSaveJson($this);
			submitUrl = SERVERURL.PATH_INTELLI_MALI_SAVE;
			isView = 'ADD';
			
		
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var formData = Ext.encode(json);
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask(); 
				if (isView == 'ADD') {
		            tabName = getCommonTranslation('ADD_INTELLI_MALI_TRANSACTION');
		            showSuccessMessage(getCommonTranslation('INTELLI_MALI'), getCommonTranslation('INTELLI_MALI_RECORD_CREATED_SUCCESSFULLY'));
		            
		        }
		    	var getcontroller=$this.getController('menu.CoreERPNavigationController');
				grid.getSelectionModel().deselectAll();
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				grid.getStore().reload();
			}
		});
	},
	   updateIntelliMaliRecord: function(btn){
			var $this = this;
			var form = btn.up('form');
			var grid = $this.getIntellimaligrid();
			var json;
				json = $this.createSaveJson($this);
			json.id=form.down('#itellimaliId').getValue();
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			var formData = Ext.encode(json);
			Ext.Ajax.request({
				type : 'rest',
				url : SERVERURL.PATH_UPDATE_INTELLIMALI,
				jsonData : formData,
				method : 'POST',
				success : function(frm, action) {
					Ext.getBody().unmask(); 
				     tabName = getCommonTranslation('EDIT_INTELLIMALI_TRANSACTION');
			            showSuccessMessage(getCommonTranslation('INTELLI_MALI'), getCommonTranslation('INTELLI_MALI_RECORD_UPDATE_SUCCESSFULLY'));
			        
			    	var getcontroller=$this.getController('menu.CoreERPNavigationController');
					grid.getSelectionModel().deselectAll();
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
					grid.getStore().reload();
				}
			});
		},
   /*To set sum of accomodation fess , other fees , payment toward fee in total scholarship amount field*/
   setTotalScholarshipAmount:function(){
	   var this$=this;
	   var form =  this.getScholarshiprequestform();
	   var paymentTowardsFees = form.down('#paymentTowardsFees').getValue();
	   var accommodationFee = form.down('#paymentTowardsLivingExpensesOrAccommodation').getValue();
	   var otherFees =  form.down('#Other').getValue();
	   var paymentTowardsFeesValue = isNullOrEmpty(paymentTowardsFees)?0:parseFloat(paymentTowardsFees);
	   var accommodationFeeValue = isNullOrEmpty(accommodationFee)?0:parseFloat(accommodationFee);
	   var otherFeesValue = isNullOrEmpty(otherFees)?0:parseFloat(otherFees);
	   form.down('#totalScholarshipAmount').setValue(paymentTowardsFeesValue+accommodationFeeValue+otherFeesValue);
   },
   /*to reset the form on different user and with different status
    * @param1 - requesterType
    * @param2 - grid record*/
   setBasicDetailsOnResetButtonClick:function(requesterType,record){
	   var $this = this;
	   var form = this.getScholarshiprequestform();
	   form.down('#requestById').setValue(this.getCurrentlyLoggedInUser().value);
	   if(!isNullOrEmpty(record)){
		   if(record.data.requestStatus){ //req edit case 
			   form.down('#recordId').setValue(record.data.id);
			   form.down('#applicantId').setValue(record.data.applicantName+" ("+record.data.applicantCode+")");
			   form.down('#studentId').setValue(record.data.studentName+" ("+record.data.studentCode+")");
			   form.down('#batchId').setValue(record.data.batchName);
			   form.down('#emailId').setValue(record.data.emailId);
			   form.down('#requesterTypeId').setValue(record.data.requesterType);
			   form.down('#programId').setValue(record.data.programName);
			   form.down('#mobileId').setValue(record.data.mobileNo);
			   if(record.data.requestById == this.getCurrentlyLoggedInUser().id && record.data.requestStatus=="ASSIGNED"){  //when req creater open its own created req
				   form.down('#declaration').setValue(false);
			   }else if(record.data.requestById == this.getCurrentlyLoggedInUser().id && record.data.requestStatus=="REASSIGNED"){
				   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
				   form.down('#reqExecutedOn').setVisible(false);
				   form.down('#followUpRemarks').setVisible(false);
				   form.down('#userName').setVisible(false);
				   if(record.data.scholarshipFollowUpDetails && record.data.scholarshipFollowUpDetails[0]){
					   form.down('#followUpGrid').setVisible(true);
					   form.down('#followUpRemarks').setValue(record.data.scholarshipFollowUpDetails[0].followUpRemark);
					   form.down('#followUpGrid').getStore().getProxy().extraParams={
						    //assignToId:record.data.scholarshipFollowUpDetails[0].reviewerUserId,
					        scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					}
					   form.down('#followUpGrid').getStore().load();
				   }
			   }
		   }else{ //first time raise req case
			   if(requesterType=='Applicant'){
				   form.down('#applicantId').setValue(record.data.APPLICATION_PERSON_PRINTNAME+" ("+record.data.APPLICATION_ID+")");
				   form.down('#batchId').setValue(record.data.BATCH);
				   form.down('#emailId').setValue(record.data.EMAIL);
			   }else if(requesterType=='Student'){
				   form.down('#studentId').setValue(record.data.STUDENT_NAME+" ("+record.data.STUDENT_ID+")");
				   form.down('#batchId').setValue(record.data.BATCH_NAME);
				   form.down('#emailId').setValue(record.data.EMAIL_ID);
			   }
			   form.down('#followUpGrid').setVisible(false);
			   form.down('#requesterTypeId').setValue(requesterType);
			   form.down('#programId').setValue(record.data.PROGRAM_NAME);
			   form.down('#mobileId').setValue(record.data.MOBILE_NUMBER);
		   }
	   }
   
   },
   
   /* Manage Scholarship */
   showHideSectionTabs : function(structure, permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,permissionsMap);
		var sectionTrans = false;
		Ext.each(permissionList, function(privilege) {
			if (privilege === "IMPORTNOMINATIONAWARD") {
				sectionTrans = true;
			}
		});
		
		var panelItem = new Array();
		var $this = this;
		var newcont = structure.items.items.length;
		var insertPosition = newcont;
		panelItem.push({
			xtype:'tabpanel',
			plain: true,
			autoScroll:true,
//			style:{overflow:'hidden !important',margin:'0!important'},
			bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
			frame: false,
			cls:'SearchTabPanelWithRightTabs panelNoSpace horizontalScrollingFixed',
			border:false,
			defaults: {
				labelAlign: 'top'
			},
			items:[]
		});
		var insertAt = panelItem["0"].items.length;;
		if (sectionTrans) {
			panelItem["0"].items[insertAt] = {
					xtype: 'importnominationawardscholarship',
					itemId :'importnominationawardscholarshipItemId'
			};
			insertAt = insertAt + 1;
		}
			
		structure.insert(insertPosition, panelItem);
   },
   validateForm: function(form, btn){
 	  if(form && form.isValid()){
 		  btn.setDisabled(false);
 	  }
 	  else{
 		  btn.setDisabled(true);
 	  }
   },
   /*to check if duplicate record selected in cost centre field
    * @param1 -> cost centre fields*/
   WhetherDuplicatecostCentreSelected:function(costCentreFields){
	   var valuesSoFar = [];
	   for (var i = 0; i < costCentreFields.length; ++i) {
	        var value = costCentreFields[i].getValue();
	        if (value!=null && valuesSoFar.indexOf(value) !== -1) {
	        	return true;
	        }
	        valuesSoFar.push(value);
	    }
   },
   downloadUploadFormChange : function(cb, nv, ov){
	   var $this = this;
	   var downloadTemplateForm = $this.getDownloadintellimaliform();
	   var uploadTemplateForm = $this.getImportintellimaliform();
	   var bulkUploadTemplateForm = $this.getIntellimalibulkuploadform();
	   var grid = $this.getImportintellimalibulkuploadgrid();
	   var academyLocationsField = bulkUploadTemplateForm.down("#scholarshipId");
	   if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
		   academyLocationsField.setVisible(true);
		   uploadTemplateForm.hide();
		   downloadTemplateForm.show();
		   grid.setVisible(false);

	   }else{
		   downloadTemplateForm.hide();
		   academyLocationsField.setVisible(false);
		   uploadTemplateForm.show();
		   grid.setVisible(true);
		   uploadTemplateForm.down("#uploadFileField").reset();

	   }
   },
   getDownloadFile : function(documentId,fileType){
   	if(!isNullOrEmpty(documentId)){
   		var csvForm = Ext.create('Ext.form.Panel'); 
   		csvForm.getForm().submit({
   			target: '_blank',
   			method:'POST',
   			params :{
   				access_token : Ext.Ajax.defaultHeaders.access_token
   			},
   			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
   			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
   			standardSubmit :true
   		});
   	}
   },
    saveIntelliMaliRecord: function(){
		var $this = this;
		var grid = $this.getIntellimaligrid();
		var json;
		

		var submitUrl;
		var isView = '';
		
			json = $this.createSaveJson($this);
			submitUrl = SERVERURL.PATH_INTELLI_MALI_SAVE;
			isView = 'ADD';
			
		
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var formData = Ext.encode(json);
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask(); 
				if (isView == 'ADD') {
		            tabName = getCommonTranslation('ADD_INTELLI_MALI_TRANSACTION');
		            showSuccessMessage(getCommonTranslation('INTELLI_MALI'), getCommonTranslation('INTELLI_MALI_RECORD_CREATED_SUCCESSFULLY'));
		            
		        }
		    	var getcontroller=$this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				   var form = $this.getIntellimaliForm();
				   var formValue = form.getValues();
				   var al = $this.getAcademyLocationId(form);
				   var store =  grid.getStore();
				   store.getProxy().extraParams = {
					   academyLocationIds: al.join(),
					   accountingYearId: formValue.intellimaliAccountingYear,
					   studentId: formValue.student,
					   startDate: formValue.fromdate,
					   endDate: formValue.todate,
					   fundAllocationType: formValue.fundAllocation,
					   status:formValue.status,
					   page:1,
					   start:0,
					   limit:-1

				   };
				   store.load();
				   grid.getSelectionModel().deselectAll();
			}
		});
	},
	createSaveJson: function($this){
		var activeTab = $this.getActiveTabfromContentPanel();
		var form = activeTab.down('intellimalitransactionform');
		var formValue = form.getValues();
		var json= new Object;
		var accountingYear={
			"id":	formValue.intellimaliAccountingYear
		};
		var instituteCSM={
				"id":	formValue.institutionId
			};
		var student={
				"id":	formValue.student
			};
		var program={
				"id":	formValue.programId
			};
		var academyLocation={
			      "id": this.getCurrentAcademyLocation()
			    };
		var scholarship=(!isNullOrEmpty(formValue.scholarshipId)?formValue.scholarshipId:null)
			
		var accommodationprovider =	(!isNullOrEmpty(formValue.accommodationproviderId)?formValue.accommodationproviderId:null)
			
		var allowanceproposed=(!isNullOrEmpty(formValue.allowanceproposed)?formValue.allowanceproposed:null)
			
		var estMonthlyInstallment= parseFloat(formValue.estimatedmonthlyinstallment);
		var totalAmount= parseFloat(formValue.totalamount);
		
		var fundAllocationCash=false;
		var fundAllocationBooks=false;
		var fundAllocationMeals=false;
		var fundAllocationAccommodation=false;
		if(formValue.fundAllocation=='CASH'){
			fundAllocationCash=true;
		}else if(formValue.fundAllocation=='BOOKS'){
			fundAllocationBooks=true;
		}else if(formValue.fundAllocation=='MEALS'){
			fundAllocationMeals=true;
		}else{
			fundAllocationAccommodation=true;
		}
		
		var transactionTypeNew=false;
		var transactionTypeAdditional=false;
		var transactionTypeSubstract=false;
		var transactionTypeStop=false;
		if(formValue.transactionType=='NEW'){
			transactionTypeNew=true;
		}else if(formValue.transactionType=='ADDITIONAL'){
			transactionTypeAdditional=true;
		}else if(formValue.transactionType=='SUBSTRACT'){
			transactionTypeSubstract=true;
		}else{
			transactionTypeStop=true;
		}
		json = {
				"accountingYear":accountingYear,
				"instituteCSM":instituteCSM,
				"student":student,
				"suNumber":formValue.sunumber,
				"program":program,
				"passPortNumber":formValue.passportNumber,
				"totalAmount":totalAmount,
				"paymentStartDate":formValue.payementstartdate,
				"numberOfInstallment":formValue.numberofinstalment,
				"fundAllocationCash":fundAllocationCash,
				"fundAllocationBooks":fundAllocationBooks,
				"fundAllocationMeals":fundAllocationMeals,
				"fundAllocationAccommodation":fundAllocationAccommodation,
				"transactionTypeNew":transactionTypeNew,
				"transactionTypeAdditional":transactionTypeAdditional,
				"transactionTypeSubstract":transactionTypeSubstract,
				"transactionTypeStop":transactionTypeStop,
				"estMonthlyInstallment":estMonthlyInstallment,
				"scholarship":scholarship,
				"allowanceProposed":allowanceproposed,
				"accommodationProvider":accommodationprovider,
				"comments" :formValue.comments,
				"academyLocation":academyLocation
		};
		return json;	
	},
   /*To set sum of accomodation fess , other fees , payment toward fee in total scholarship amount field*/
   setTotalScholarshipAmount:function(){
	   var this$=this;
	   var form =  this.getScholarshiprequestform();
	   var paymentTowardsFees = form.down('#paymentTowardsFees').getValue();
	   var accommodationFee = form.down('#paymentTowardsLivingExpensesOrAccommodation').getValue();
	   var otherFees =  form.down('#Other').getValue();
	   var paymentTowardsFeesValue = isNullOrEmpty(paymentTowardsFees)?0:parseFloat(paymentTowardsFees);
	   var accommodationFeeValue = isNullOrEmpty(accommodationFee)?0:parseFloat(accommodationFee);
	   var otherFeesValue = isNullOrEmpty(otherFees)?0:parseFloat(otherFees);
	   form.down('#totalScholarshipAmount').setValue(paymentTowardsFeesValue+accommodationFeeValue+otherFeesValue);
   },
   /*to reset the form on different user and with different status
    * @param1 - requesterType
    * @param2 - grid record*/
   setBasicDetailsOnResetButtonClick:function(requesterType,record){
	   var $this = this;
	   var form = this.getScholarshiprequestform();
	   form.down('#requestById').setValue(this.getCurrentlyLoggedInUser().value);
	   if(!isNullOrEmpty(record)){
		   if(record.data.requestStatus){ //req edit case 
			   form.down('#recordId').setValue(record.data.id);
			   form.down('#applicantId').setValue(record.data.applicantName+" ("+record.data.applicantCode+")");
			   form.down('#studentId').setValue(record.data.studentName+" ("+record.data.studentCode+")");
			   form.down('#batchId').setValue(record.data.batchName);
			   form.down('#emailId').setValue(record.data.emailId);
			   form.down('#requesterTypeId').setValue(record.data.requesterType);
			   form.down('#programId').setValue(record.data.programName);
			   form.down('#mobileId').setValue(record.data.mobileNo);
			   if(record.data.requestById == this.getCurrentlyLoggedInUser().id && record.data.requestStatus=="ASSIGNED"){  //when req creater open its own created req
				   form.down('#declaration').setValue(false);
			   }else if(record.data.requestById == this.getCurrentlyLoggedInUser().id && record.data.requestStatus=="REASSIGNED"){
				   form.down('#followUpDetailsScholarshipFormId').setVisible(true);
				   form.down('#reqExecutedOn').setVisible(false);
				   form.down('#followUpRemarks').setVisible(false);
				   form.down('#userName').setVisible(false);
				   if(record.data.scholarshipFollowUpDetails && record.data.scholarshipFollowUpDetails[0]){
					   form.down('#followUpGrid').setVisible(true);
					   form.down('#followUpRemarks').setValue(record.data.scholarshipFollowUpDetails[0].followUpRemark);
					   form.down('#followUpGrid').getStore().getProxy().extraParams={
						    //assignToId:record.data.scholarshipFollowUpDetails[0].reviewerUserId,
					        scholarshipRaiseRequestId:record.data.scholarshipFollowUpDetails[0].raiseRequestId
					}
					   form.down('#followUpGrid').getStore().load();
				   }
			   }
		   }else{ //first time raise req case
			   if(requesterType=='Applicant'){
				   form.down('#applicantId').setValue(record.data.APPLICATION_PERSON_PRINTNAME+" ("+record.data.APPLICATION_ID+")");
				   form.down('#batchId').setValue(record.data.BATCH);
				   form.down('#emailId').setValue(record.data.EMAIL);
			   }else if(requesterType=='Student'){
				   form.down('#studentId').setValue(record.data.STUDENT_NAME+" ("+record.data.STUDENT_ID+")");
				   form.down('#batchId').setValue(record.data.BATCH_NAME);
				   form.down('#emailId').setValue(record.data.EMAIL_ID);
			   }
			   form.down('#followUpGrid').setVisible(false);
			   form.down('#requesterTypeId').setValue(requesterType);
			   form.down('#programId').setValue(record.data.PROGRAM_NAME);
			   form.down('#mobileId').setValue(record.data.MOBILE_NUMBER);
		   }
	   }
   
   },
   
   /* Manage Scholarship */
   showHideSectionTabs : function(structure, permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,permissionsMap);
		var sectionTrans = false;
		var addSearchTab = false;
		Ext.each(permissionList, function(privilege) {
			if (privilege === "IMPORTNOMINATIONAWARD") {
				sectionTrans = true;
			}
			if (privilege === "MANAGE_SCHOLARSHIP_SEARCH_TAB") {
				addSearchTab = true;
			}
		});
		
		var panelItem = new Array();
		var $this = this;
		var newcont = structure.items.items.length;
		var insertPosition = newcont;
		panelItem.push({
			xtype:'tabpanel',
			plain: true,
			autoScroll:true,
//			style:{overflow:'hidden !important',margin:'0!important'},
			bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
			frame: false,
			cls:'SearchTabPanelWithRightTabs panelNoSpace horizontalScrollingFixed',
			border:false,
			defaults: {
				labelAlign: 'top'
			},
			items:[]
		});
		var insertAt = panelItem["0"].items.length;
		
		if(addSearchTab){
			panelItem["0"].items[insertAt] = {
					xtype: 'managescholarshipsearchtab',
					itemId :'managescholarshipsearchtab'
			};
			insertAt = insertAt + 1;
		}
		
		if (sectionTrans) {
			panelItem["0"].items[insertAt] = {
					xtype: 'importnominationawardscholarship',
					itemId :'importnominationawardscholarshipItemId'
			};
		}
		structure.insert(insertPosition, panelItem);
   },
   validateForm: function(form, btn){
 	  if(form && form.isValid()){
 		  btn.setDisabled(false);
 	  }
 	  else{
 		  btn.setDisabled(true);
 	  }
   },
   /*to check if duplicate record selected in cost centre field
    * @param1 -> cost centre fields*/
   WhetherDuplicatecostCentreSelected:function(costCentreFields){
	   var valuesSoFar = [];
	   for (var i = 0; i < costCentreFields.length; ++i) {
	        var value = costCentreFields[i].getValue();
	        if (value!=null && valuesSoFar.indexOf(value) !== -1) {
	        	return true;
	        }
	        valuesSoFar.push(value);
	    }
   },
   downloadUploadFormChange : function(cb, nv, ov){
	   var $this = this;
	   var downloadTemplateForm = $this.getDownloadintellimaliform();
	   var uploadTemplateForm = $this.getImportintellimaliform();
	   var bulkUploadTemplateForm = $this.getIntellimalibulkuploadform();
	   var grid = $this.getImportintellimalibulkuploadgrid();
	   var academyLocationsField = bulkUploadTemplateForm.down("#scholarshipId");
	   if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
		   academyLocationsField.reset();
		   academyLocationsField.setVisible(true);
		   academyLocationsField.allowBlank=false;
		   uploadTemplateForm.hide();
		   downloadTemplateForm.show();
		   grid.setVisible(false);

	   }else{
		   downloadTemplateForm.hide();
		   academyLocationsField.reset();
		   academyLocationsField.setVisible(false);
		   academyLocationsField.allowBlank=true;
		   uploadTemplateForm.show();
		   grid.setVisible(true);
		   uploadTemplateForm.down("#uploadFileField").reset();

	   }
   },
   getDownloadFile : function(documentId,fileType){
   	if(!isNullOrEmpty(documentId)){
   		var csvForm = Ext.create('Ext.form.Panel'); 
   		csvForm.getForm().submit({
   			target: '_blank',
   			method:'POST',
   			params :{
   				access_token : Ext.Ajax.defaultHeaders.access_token
   			},
   			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
   			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
   			standardSubmit :true
   		});
   	}
   },
   getDownloadSchlDocs:function(documentId){
	   if(!isNullOrEmpty(documentId)){
   		var csvForm = Ext.create('Ext.form.Panel'); 
   		csvForm.getForm().submit({
   			target: '_blank',
   			method:'GET',
   			params :{
   				access_token : Ext.Ajax.defaultHeaders.access_token
   			},
   			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
   			url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
   			standardSubmit :true
   		});
   	}
   },
   getManageScholarshipSearchData:function(documentId){
	          var $this=this,studentStatus;
	          var form = $this.getManagescholarshipsearchfilter();
	          var formValue = form.getValues();
	          var scholarshipApplicationID = form.down('#scholarshipApplicationID');
	          var aLFieldValue = formValue.academyLocationId;
	          var alData;
	          var acaloc = [];
	          var selectedAL;
	          if(formValue.stdStatus==="ACTIVE"){
		         studentStatus=true;
	          }else if(formValue.stdStatus==="INACTIVE"){
		         studentStatus=false;
	          }else{
		         studentStatus='All'; 
	          }
	          if(aLFieldValue!="" && aLFieldValue!=null){
		              for(var i in aLFieldValue){
			                  if(!isNullOrEmpty(aLFieldValue[i])){
				                      alData = aLFieldValue[i].get("id");
				                      acaloc.push(alData);
				                  }else{
					                      alData = aLFieldValue[i];
					                      acaloc.push(alData);
					                  }
			              }
		          }
	          if(acaloc.length>0){
		              selectedAL=acaloc.join();
		          }else{
			              selectedAL=aLFieldValue;
			          }
	          if(formValue.applicableFor=="STUDENT"){
		              var grid = $this.getManagescholarshipstudentlistgrid();
		    var store =  grid.getStore();
		   store.getProxy().extraParams = {
			              academyLocationId: selectedAL,
			              applicableFor: formValue.applicableFor,
			              accountingYearId: formValue.accountingYear,
			              scholarshipId: formValue.scholarshipId,
			              scholarshipCategory: formValue.scholarshipCategory,
			   scholarshipApplicationId: scholarshipApplicationID.getDisplayValue(),
			              status:formValue.status,
			   studentId:formValue.studentId,
			   studentStatus:studentStatus
		   };
		          }else{
			              var grid = $this.getManagescholarshipapplicantlistgrid();
			    var store =  grid.getStore();
			   store.getProxy().extraParams = {
				              academyLocationId: selectedAL,
				              applicableFor: formValue.applicableFor,
				              accountingYearId: formValue.accountingYear,
				              scholarshipId: formValue.scholarshipId,
				              scholarshipCategory: formValue.scholarshipCategory,
				   scholarshipApplicationId: scholarshipApplicationID.getDisplayValue(),
				              status:formValue.status,
				   applicantId:formValue.applicantId
			   };
			          }
	         
	          this.resetPageSetting(store);
	          
	          grid.getSelectionModel().deselectAll();
	          store.load();
	      },
	   getButtonPermission:function(){
		   var activeTab = this.getActiveTabfromContentPanel();
		   var form = activeTab.down('spscholarshipacceptform');
//		   var form = this.getSpscholarshipacceptform();
		   var saveBtn = form.down('#saveBtnCerp');
		   var actionSubmitBtn = form.down('#actionSubmitBtn');
		   var declineScholarShipBtn = form.down('#declineScholarShipBtnAdmin');
		   actionSubmitBtn.setVisible(false);
		  declineScholarShipBtn.setVisible(false);
		   var associatedAcadLocationIds = new Array();
		   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSS_MANAGE_SCHOLARSHIP_DOCUMENTS_LIST_PERMISSIONS());
		   Ext.each(permissionList, function(privilege) {
			   if (privilege === 'SAVE') {
				   if(!isNullOrEmpty(saveBtn)){
					   saveBtn.setVisible(true);
				   }        		
			   }
			   if (privilege === 'ACTION') {
				   actionSubmitBtn.setVisible(true);
			   }
			   if (privilege === 'DECLINE') {
				   declineScholarShipBtn.setVisible(true);
			   }
		   });
	   },
	   setIntellimaliData:function(structure,rec){
		   structure.down('#resetButtonId').setVisible(false);
		   structure.down('#cancelButtonId').setVisible(true);
		   if(!isNullOrEmpty(rec.data.sequenceNumber)){
			   structure.down('#sequenceNumber').setVisible(true);
			   structure.down('#transactionDate').setVisible(true);
			   structure.down('#sequenceNumber').setValue(rec.data.sequenceNumber);
			   structure.down('#transactionDate').setValue(dateRender(rec.data.transactionDate));
		   }
		   if(!isNullOrEmpty(rec.data.accountingYear)){
			   structure.down('#intellimaliAccountingYear').getStore().load({
					 callback: function(record, operation, success) {
						 if (success) {
							 structure.down('#intellimaliAccountingYear').setValue(rec.data.accountingYear.id);
						 }
					 }
				 });
			   
		   }
		   structure.down('#intellimaliAccountingYear').setReadOnly(true);
		   if(!isNullOrEmpty(rec.data.instituteCSM)){
			   structure.down('#institutionId').getStore().load();
			   structure.down('#institutionId').setValue(rec.data.instituteCSM.id);
		   }
		   if(!isNullOrEmpty(rec.data.student)){
			   structure.down('#studentId').getStore().getProxy().extraParams = {
				   studentNameOrCode: rec.data.student.code,
				   academyLocationIds:rec.data.academyLocation.id
			   };
			   structure.down('#studentId').getStore().load({
					 callback: function(record, operation, success) {
						 if (success) {
							 structure.down('#studentId').setValue(rec.data.student.id);
						 }
					 }
				 });
		   }
		    if(!isNullOrEmpty(rec.data.academyLocation)){
			   structure.down('#academyLocationId').getStore().getProxy().extraParams = {
				   studentId: rec.data.student.id
			   };
			   structure.down('#academyLocationId').getStore().load({
					 callback: function(record, operation, success) {
						 if (success) {
							 structure.down('#academyLocationId').setValue(rec.data.academyLocation.id);
							 structure.down('#academyLocationId').setReadOnly(true);
						 }
					 }
				 });
		   }
		   structure.down('#studentId').setReadOnly(true);
		   if(!isNullOrEmpty(rec.data.program)){
			   structure.down('#programId').getStore().getProxy().extraParams = {
				   studentId: rec.data.student.id
			   };
			   structure.down('#programId').getStore().load({
					 callback: function(record, operation, success) {
						 if (success) {
							 structure.down('#programId') && structure.down('#programId').setValue(rec.data.program.id);
						 }
					 }
				 });
			   
		   }
		   
		   structure.down('#suNumber').setValue(rec.data.suNumber);
		   structure.down('#suNumber').setReadOnly(true);
		   structure.down('#passportNumber').setValue(rec.data.passPortNumber);
		   structure.down('#passportNumber').setReadOnly(true);
		   structure.down('#totalamount').setValue(rec.data.totalAmount);
		   structure.down('#payementstartdateId').setValue(dateRender(rec.data.paymentStartDate));
		   
		   structure.down('#payementstartdateId').clearInvalid();
		   structure.down('#numberofinstalment').setValue(rec.data.numberOfInstallment);
		   structure.down('#estimatedmonthlyinstallment').setValue(rec.data.estMonthlyInstallment);
		   structure.down('#estimatedmonthlyinstallment').setReadOnly(true);
		   structure.down('#itellimaliId').setValue(rec.data.id);
		   Ext.defer(function(){
			   structure.down('#payementstartdateId').setMinValue(new Date());
			   structure.isValid();
		   },1000)
		   if(rec.data.fundAllocationCash){
			   structure.down('#fundAllocationId').setValue({fundAllocation:"CASH"});
		   }else if(rec.data.fundAllocationBooks){
			   structure.down('#fundAllocationId').setValue({fundAllocation:"BOOKS"});
		   }else if(rec.data.fundAllocationMeals){
			   structure.down('#fundAllocationId').setValue({fundAllocation:"MEALS"});
		   }else if(rec.data.fundAllocationAccommodation){
			   structure.down('#fundAllocationId').setValue({fundAllocation:"ACCOMMODATION"});
			   structure.down('#accommodationproviderId').setVisible(true);  
			   structure.down('#accommodationproviderId').setDisabled(false);
		   }
		   structure.down('#fundAllocationId').setReadOnly(true);
		   if(rec.data.transactionTypeNew){
			   structure.down('#transactionTypeId').setValue({transactionType:"NEW"});
		   }else if(rec.data.transactionTypeAdditional){
			   structure.down('#transactionTypeId').setValue({transactionType:"ADDITIONAL"});
		   }else if(rec.data.transactionTypeSubstract){
			   structure.down('#transactionTypeId').setValue({transactionType:"SUBSTRACT"});
		   }else if(rec.data.transactionTypeStop){
			   structure.down('#transactionTypeId').setValue({transactionType:"STOP"});
		   }
		   structure.down('#transactionTypeId').setReadOnly(true);
		   
		   if(!isNullOrEmpty(rec.data.allowanceProposed)){
			
			   structure.down('#allowanceproposed').getStore().load({
					 callback: function(record, operation, success) {
						 if (success) {
							 if(rec){
								 structure.down('#allowanceproposed').setValue(rec.data.allowanceProposed.id);
							 }
							 
						 }
					 }
				 });
			   
		   }
		   if(rec.data.fundAllocation != "Cash" ){
			   structure.down('#allowanceproposed').setReadOnly(true);
		   }
		   if(!isNullOrEmpty(rec.data.accommodationProvider)){
			   structure.down('#accommodationproviderId').getStore().load();
			   structure.down('#accommodationproviderId').setValue(rec.data.accommodationProvider.id);
		   }
		   if(!isNullOrEmpty(rec.data.scholarship)){
			   var scholarshipStore=structure.down('#scholarshipId').getStore();
			   scholarshipStore.getProxy().extraParams = {
				     studentId: rec.data.student.id
				     };
			   scholarshipStore.load({
					 callback: function(record, operation, success) {
						 if (success) {
							 structure.down('#scholarshipId').setValue(rec.data.scholarship.id);
						 }
					 }
				 });
			  
		   }
		   structure.down('#scholarshipId').setReadOnly(true);
		   structure.down('#commentsId').setValue(rec.data.comments);
		   if(this.viewModeIntellimali == 'View'){
		   this.toggleReadOnlyFormItems(structure.getForm(), true);
		   structure.down('#submitBtn').setVisible(false);
		   structure.down('#cancelButtonId').setVisible(false);
		   structure.down('#updateBtn').setVisible(false);
			   Ext.defer(function() {
				       structure.down('#allowanceproposed').setReadOnly(true);
			   },1000,this);
		   }else{
			   structure.down('#updateBtn').setVisible(true);
			   structure.down('#submitBtn').setVisible(false);
			   structure.down('#cancelButtonId').setVisible(false);
		   }
		 
	   },
	   setDataOnScholarshipDetailsForNomination:function(record,applicableFor,isView){
		   var studentStatus,form = this.getScholarshipapplicationform();
		   var fnpBrandCampusItemId =form.down('#fnpBrandCampusItemId');
		   var studentIdOrName =form.down('#studentIdOrName');
		   var applicantIdOrName =form.down('#applicantIdOrName');
		   var programId = form.down('#programBatchCode');
		   var BatchId = form.down('#BatchId');
		   var stdBatchId = form.down('#stdBatchId');
		   var accountingYearId = form.down('#accountingYearId');
		   var scholarshipId = form.down('#scholarshipId');
		   var TranscationId = form.down('#TranscationId');
		   var stdStatus = form.down('#stdStatus');
		   if(isView){
			   form.down('#statusId').getStore().add({
				   value:record.data.status,
				   name:getCommonTranslation(record.data.status)
			   })
		   }
		   if(record.data.studentStatus){
			   studentStatus='ACTIVE'
		   }else{
			   studentStatus='INACTIVE'
		   }
		   this.toggleReadOnlyFormItems(form.getForm(),true);
		   form.down('#scholarshipAppNumber').setValue(record.data.scholarshipApplicationID);
		   form.down('#externalRefNum').setValue(record.data.studentExternalReference);
		   form.down('#scholarshipCategoryId').setValue(record.data.scholarshipCategory);
		   form.down('#statusId').setValue(record.data.status);
		   form.down('#statusId').readOnly=false;
		   form.down('#TranscationId').readOnly=false;
		   form.down('#recordId').setValue(record.data.id);
		   form.down('#amountId').setValue(record.data.amount);
		   form.down('#stdStatus').setValue(studentStatus);
		   
		   var url;
		   if(applicableFor == "STUDENT") {
	    		url = SERVERURL.PATH_CHECK_MAX_STUDENT_AMOUNT+'?scholarshipId='+record.data.scholarshipId+'&studentId='+record.data.studentId+'&nominationId='+record.data.id;
	    	}else {
	    		url = SERVERURL.PATH_CHECK_MAX_STUDENT_AMOUNT+'?scholarshipId='+record.data.scholarshipId+'&applicantId='+record.data.applicantId+'&nominationId='+record.data.id;
	    	}
		   if(!isView){
				Ext.Ajax.request({
					method : "GET",
					type : 'rest',
					url: url,
					success: function(response) {
						var data = Ext.decode(response.responseText)
						if(!isNullOrEmpty(data)) {
							form.down('#amountId').setValue(data);
							form.down('#amountId').setMaxValue(data);	
						}
					}
				});
		   }
		  
		   if(applicableFor=='STUDENT'){
			   form.down('#externalRefNum').setValue(record.data.studentExternalReference);
			   form.down('#applicableFor').setValue('STUDENT');  
			   form.down('#applicantIdOrName').allowBlank=true;
			   studentIdOrName.store.proxy.extraParams = {
					   studentCode : record.data.studentCode,
					   isForSave : record.data.studentStatus
	 			};	
			   studentIdOrName.store.load({
					callback: function(records, operation, success) {
						studentIdOrName.setValue(record.data.studentId);
						studentIdOrName.fireEvent('select',studentIdOrName);
					}
				});
		   }else{
			   form.down('#externalRefNum').setValue(record.data.applicantExternalReference);
			   applicantIdOrName.setVisible(true);
			   studentIdOrName.setVisible(false);
			   stdStatus.setVisible(false);
			   studentIdOrName.allowBlank=true;
			   form.down('#applicableFor').setValue('APPLICANT');
			   applicantIdOrName.store.proxy.extraParams = {
					   codeOrName : record.data.applicantCode
	 			};	
			   applicantIdOrName.store.load({
					callback: function(records, operation, success) {
						applicantIdOrName.setValue(record.data.applicantId);
						applicantIdOrName.fireEvent('select',applicantIdOrName);
					}
				});
		   }
		   /*if(applicableFor=='STUDENT'){
			   programId.store.getProxy().api.read = SERVERURL.PROGRAM_BATCH_SEAT_TYPE_CONF_STUDENTID;
			   programId.store.proxy.extraParams = {
					   studentId : record.data.studentId
			   };	
		   }else{
			   programId.store.getProxy().api.read = SERVERURL.PROGRAM_BATCH_SEAT_TYPE_CONF_APPLICATIONID;
			   programId.store.proxy.extraParams = {
					   applicationId : record.data.applicantId
			   };	
		   }
		   programId.store.load({
			   callback: function(records, operation, success) {
				   programId.setValue(record.data.programId);
				   BatchId.setValue(record.data.batch);
				   stdBatchId.setValue(record.data.batchId);
				   BatchId.setDisabled(false);
				   programId.setDisabled(false);
			   }
			});*/
		  /* BatchId.store.proxy.extraParams = {
				   id : record.data.programId
 			};
		   BatchId.store.load({
				callback: function(records, operation, success) {
					BatchId.setValue(record.data.batchId);
					BatchId.setDisabled(false);
				}
		   });*/
		   Ext.defer(function(){
			   fnpBrandCampusItemId.store.load({
					callback: function(records, operation, success) {
						fnpBrandCampusItemId.setValue(record.data.academyLocationId);
						fnpBrandCampusItemId.fireEvent('select',fnpBrandCampusItemId);
					}
				});
		   },1200);
		   
		   accountingYearId.store.load({
			   callback: function(records, operation, success) {
				   accountingYearId.setValue(record.data.accountingYearId);
			   }
		   });
		   Ext.defer(function(){
			   scholarshipId.store.proxy.extraParams = {
					   academyLocationId : record.data.academyLocationId,
					   programId:record.data.programId,
					   batchId:record.data.batchId,
					   accountYearId:record.data.accountingYearId,
					   studentId:record.data.studentId,
					   applicant:record.data.applicantId
	 			};
			   scholarshipId.store.load({
				   callback: function(records, operation, success) {
					   scholarshipId.setValue(record.data.scholarshipId);
					   scholarshipId.setDisabled(false);
				   }
			   });
		   },200);
		   
		   TranscationId.store.load({
			   callback: function(records, operation, success) {
				   TranscationId.setValue(record.data.transactionID);
			   }
		   });
		   programId.setValue(record.data.programId);
		   BatchId.setValue(record.data.batch);
		   stdBatchId.setValue(record.data.batchId);
		   if(isView){
			   if( record.data.status !== "NOMINATED"){
				   form.down('#amountId').setVisible(true);
				   form.down('#amountId').setReadOnly(true);
				   form.down('#TranscationId').setVisible(true);
				   form.down('#TranscationId').setDisabled(false);
				   form.down('#TranscationId').setReadOnly(true);
			   }
			   form.down('#closeBtn').setVisible(true);
			   form.down('#CancelBtn').setVisible(false);
			   form.down('#SubmitBtn').setVisible(false);
			   form.down('#statusId').setReadOnly(true);
			   form.down('#amountId').setReadOnly(true);
			   form.down('#TranscationId').setReadOnly(true);
		   }
	   },
	   saveScholarshipApplicationForm:function(){
		   var $this = this;
		   var jsonFormFieldData;
		   var form = this.getScholarshipapplicationform();
		   var filter = this.getManagescholarshipsearchfilter();
		   var academyLocation = form.down('#fnpBrandCampusItemId').getValue();
		   var programId = form.down('#programBatchCode').getValue();
		   var batchId = form.down('#BatchId').getValue();
		   var stdBatchId = form.down('#stdBatchId').getValue();
		   var accountYearId = form.down('#accountingYearId').getValue();
		   var categoryName = form.down('#scholarshipCategoryId').getValue();
		   var scholarshipId = form.down('#scholarshipId').getValue()
		   var TranscationId = form.down('#TranscationId').getValue();
		   var status = form.down('#statusId').getValue();
		   var amount = form.down('#amountId').getValue();
		   var studentId = form.down('#studentIdOrName').getValue();
		   var accountingYear = form.down('#accountingYearId').getValue();
		   var applicant = form.down('#applicantIdOrName').getValue();
		   var applicableFor = form.down('#applicableFor').getValue();
		   var recordId =  form.down('#recordId').getValue();
		   var scholarshipCombo = form.down('#scholarshipId');
		   var stdStatus = form.down('#stdStatus').getValue();
		   var applicableFor = form.down('#applicableFor').getValue();
		   var selectedValue = scholarshipCombo.getValue(); 
		   var store = scholarshipCombo.getStore();
		   var selectedRecord = store.findRecord('id', selectedValue);
		   var studentCombo = form.down('#studentIdOrName');
		   var studentComboStore = studentCombo.getStore();
		   var stdSelectedRecord = studentComboStore.findRecord('id', studentId);
		   var grid;
		   var submitUrl,studentStatus;
		   var studentGrid = this.getManagescholarshipstudentlistgrid();
	       var applicantgrid = this.getManagescholarshipapplicantlistgrid();
	       if(studentGrid.isHidden()){
	    	   grid=applicantgrid;
	       }else{
	    	   grid=studentGrid;
	       }
	       if(stdSelectedRecord && stdSelectedRecord.data){
    		   studentStatus=stdSelectedRecord.data.activeStatus;
    	   }
	       if(isNullOrEmpty(recordId)){
	    	   submitUrl=SERVERURL.PATH_SAVE_SCHOLARSHIP_NOMINATE_AWARD;
	    	   jsonFormFieldData = {
					   academyLocationId:academyLocation,
					   transactionID:TranscationId,
					   scholarshipId:scholarshipId,
					   programId:programId,
					   batchId:parseInt(stdBatchId),
					   scholarshipCategory:categoryName,
					   studentId:studentId,
					   accountingYearId:accountingYear,
					   applicantId:applicant,
					   applicableFor:applicableFor,
					   amount:amount,
					   status:status
			   }
	    	   //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    	   if(selectedRecord){
	    		   var allowInactive = selectedRecord.get('activeStatus');
	    		   if(allowInactive && applicableFor==='STUDENT' && !studentStatus){
	    			   showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_STUDENT_IS_INACTIVE_DO_YOU_STILL_WANT_TO_PROCEED'),function(btn,text){
	    				   if (btn == 'yes') {
	    					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    					   Ext.Ajax.request({
	    						   type: 'rest',
	    						   url: submitUrl,
	    						   jsonData: jsonFormFieldData,
	    						   method: 'POST',
	    						   success: function(res,form, action) {
	    							   var response = res.responseText
	    							   if(response === 'Success'){
	    								   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS'));
	    								   grid.store.getProxy().extraParams = {
	    									   academyLocationId:academyLocation,
	    									   accountingYearId:accountingYear,
	    									   applicableFor: applicableFor
	    								   };
	    								   grid.getStore().reload();
	    								   grid.getSelectionModel().deselectAll(true); 
	    								   $this.getContentPanelActiveTab().close();
	    								   filter.getForm().reset();
	    								   filter.down('#academyLocationItemId').setValue(academyLocation);
	    								   if(applicableFor=='APPLICANT'){
	    									   studentGrid.setVisible(false);
	    									   applicantgrid.setVisible(true);
	    									   filter.down('#applicableFor').setValue('APPLICANT');
	    								   }else{
	    									   applicantgrid.setVisible(false);
	    									   studentGrid.setVisible(true);
	    									   filter.down('#applicableFor').setValue('STUDENT');
	    								   }
	    							   }
	    							   else if(response === 'SCHOLARSHIP_IS_INACTIVE'){
	    								   showWarningMessage(getCommonTranslation('ALERT'), response +' '+getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'))
	    							   } else{
	    								   showWarningMessage(getCommonTranslation('ALERT'), response +' '+getCommonTranslation('SCHOLARSHIP_APPLICATION_ALREADY_IN_PROCESS_CANNOT_PROCEED'))
	    							   }
	    							   Ext.getBody().unmask();
	    						   },
	    						   failure: function(form, action) {
	    							   Ext.getBody().unmask();
	    						   }
	    					   });
	    				   }
	    			   });
	    		   }else{
	    			   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    			   Ext.Ajax.request({
	    				   type: 'rest',
	    				   url: submitUrl,
	    				   jsonData: jsonFormFieldData,
	    				   method: 'POST',
	    				   success: function(res,form, action) {
	    					   var response = res.responseText
	    					   if(response === 'Success'){
	    						   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS'));
	    						   grid.store.getProxy().extraParams = {
	    							   academyLocationId:academyLocation,
	    							   accountingYearId:accountingYear,
	    							   applicableFor: applicableFor
	    						   };
	    						   grid.getStore().reload();
	    						   grid.getSelectionModel().deselectAll(true); 
	    						   $this.getContentPanelActiveTab().close();
	    						   filter.getForm().reset();
	    						   filter.down('#academyLocationItemId').setValue(academyLocation);
	    						   if(applicableFor=='APPLICANT'){
	    							   studentGrid.setVisible(false);
	    							   applicantgrid.setVisible(true);
	    							   filter.down('#applicableFor').setValue('APPLICANT');
	    						   }else{
	    							   applicantgrid.setVisible(false);
	    							   studentGrid.setVisible(true);
	    							   filter.down('#applicableFor').setValue('STUDENT');
	    						   }
	    					   }
	    					   else if(response === 'SCHOLARSHIP_IS_INACTIVE'){
	    						   showWarningMessage(getCommonTranslation('ALERT'), response +' '+getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'))
	    					   } else{
	    						   showWarningMessage(getCommonTranslation('ALERT'), response +' '+getCommonTranslation('SCHOLARSHIP_APPLICATION_ALREADY_IN_PROCESS_CANNOT_PROCEED'))
	    					   }
	    					   Ext.getBody().unmask(); 
	    				   },
	    				   failure: function(form, action) {
							   Ext.getBody().unmask();
						   }
	    			   });
	    		   }
	    	   }
	       }else{
	    	   submitUrl=SERVERURL.PATH_UPDATE_SCHOLARSHIP_NOMINATE_AWARD;
	    	   jsonFormFieldData = {
	    			   id:recordId,
					   transactionID:TranscationId,
					   amount:amount,
					   status:status
			   }
	    	   if(status=='ACCEPTANCE_PENDING'){
	    		   if(selectedRecord){
	    			   var allowInactive = selectedRecord.get('activeStatus');
	    			   if(allowInactive && applicableFor==='STUDENT' && !studentStatus){
	    				   showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_STUDENT_IS_INACTIVE_DO_YOU_STILL_WANT_TO_PROCEED'),function(btn,text){
	    					   if (btn == 'yes') { 
	    						   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    						   Ext.Ajax.request({
	    							   type: 'rest',
	    							   url: submitUrl,
	    							   jsonData: jsonFormFieldData,
	    							   method: 'POST',
	    							   success: function(form, action) {
	    								   if(form.responseText === 'INACTIVE'){
	    									   Ext.getBody().unmask();
	    									   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
	    								   }else{
	    									   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
	    									   Ext.getBody().unmask(); 
	    									   grid.store.getProxy().extraParams = {
	    										   academyLocationId:academyLocation,
	    										   accountingYearId:accountingYear,
	    										   applicableFor: applicableFor
	    									   };
	    									   grid.getStore().reload();
	    									   grid.getSelectionModel().deselectAll(true);  
	    									   grid.down('#btnAdd').setDisabled(false);
	    									   $this.getContentPanelActiveTab().close();
	    								   }
	    							   },
	    							   failure: function(form, action) {
	    								   Ext.getBody().unmask();
	    							   }
	    						   });
	    					   }
	    				   }); 
	    			   }else{
	    				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    				   Ext.Ajax.request({
	    					   type: 'rest',
	    					   url: submitUrl,
	    					   jsonData: jsonFormFieldData,
	    					   method: 'POST',
	    					   success: function(form, action) {
	    						   if(form.responseText === 'INACTIVE'){
	    							   Ext.getBody().unmask();
	    							   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
	    						   }else{
	    							   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
	    							   Ext.getBody().unmask(); 
	    							   grid.store.getProxy().extraParams = {
	    								   academyLocationId:academyLocation,
	    								   accountingYearId:accountingYear,
	    								   applicableFor: applicableFor
	    							   };
	    							   grid.getStore().reload();
	    							   grid.getSelectionModel().deselectAll(true);  
	    							   grid.down('#btnAdd').setDisabled(false);
	    							   $this.getContentPanelActiveTab().close();
	    						   }
	    					   },
	    					   failure: function(form, action) {
	    						   Ext.getBody().unmask();
	    					   }
	    				   });
	    			   }  
	    		   }
	    	   }
	       }
	   },
	   
	   openDeleteConfirmationWindow:function(){
           var $this = this;
           var formWindow = $this.getScholarshipDeleteConfirmationWindow();
           if (!formWindow) {
               formWindow = Ext.widget('scholarshipDeleteConfirmationWindow');
               $win =  formWindow
           }
           formWindow.show();
       },
	   deleteIntellimaliRecords:function(deleteUrl) {
		      var this$ = this;
		      var grid = this$.getIntellimaligrid()
		      if (grid.getSelectionModel().getCount() > 0) {
		          showConfirmMessage(getCommonTranslation('INTELLI_MALI'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
		              if (btn == 'yes') {
//		                  if (grid.getSelectionModel().getCount() > 0) {
		                      var records = grid.getSelectionModel().getSelection();
		                      var ids = [];
		                      for (var count = 0; count < records.length; count++) {
		                          if (!isNullOrEmpty(records[count].get("id"))) {
		                        	  ids.push(records[count].get("id"));
		                          }
		                      }
	                          Ext.Ajax.request({
	                              type: 'rest',
	                              url: SERVERURL.PATH_DELETE_INTELLIMALI+'?ids='+ids.join(),
	                              async:false,
	                              method: 'DELETE',
	                              headers: {
	                                  'Content-Type': 'application/json'
	                              },
//	                              params: {
//	                            	  ids: ids.join()
//	                              },
	                              success: function(form, action) {
	                            	  grid.getSelectionModel().deselectAll();
	                            	  grid.getStore().reload();
	    		                      showSuccessMessage(getCommonTranslation('INTELLI_MALI'), getCommonTranslation('RECORD_DELETE_SUCCESS')); 
	                                }
	                          });
	                      }
//		              }
		          });
		      } else {
		          showWarningMessage(getCommonTranslation('INTELLI_MALI'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		      }
		  },
		  
		  openScholarshipApplyToScreen: function(button) {
		        var grid = button.up('grid');
		        if (grid.getSelectionModel().getCount() > 0) {
		            var record = grid.getSelectionModel().getSelection()[0];
		            var associateALPTab = this.openTabAndSetValue(getCommonTranslation('APPLY_TO'), 'scholarshipApplyToView', record.get('scholarshipId'), CONSTANTS.MENU_COLOR_TEN);
		            var gridStore = associateALPTab.down('grid').getStore();
		            gridStore.getProxy().extraParams = {
		            	scholarshipId: record.get('scholarshipId')
		            };
		            gridStore.sorters.removeAll();
		            this.resetPageSetting(gridStore, associateALPTab.down('grid'));
		            gridStore.pageSize = 100;
		            gridStore.loadPage(1);
		            this.getActiveTabfromContentPanel().scholarshipId = record.get('id');
		        }
		        else {
		            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		        }
		    },
		    
		    openDocsAndRefDetailsWin: function(btn) {
		    	var grid = btn.up('grid');
		    	if(btn.itemId == 'btnEdit' && grid.getSelectionModel().getCount() == 0) {
		            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		            return;
		        }
		    	var frmWin = this.getDocsAndRefDetailsWindow();
    			if(!frmWin){
    				Ext.widget('docsAndRefDetailsWindow');
    				frmWin = this.getDocsAndRefDetailsWindow();
    			}
    			frmWin.show();
    			if(btn.itemId == 'btnEdit') {
    				var record = grid.getSelectionModel().getSelection()[0];
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		    	Ext.Ajax.request({
    	    			type: 'rest',
    	    			url: SERVERURL.PATH_DATA_BY_SCHOLARSHIP_DOCUMENT_ID,
    	    			method: 'GET',
    	    			params: {
    	    				scholarshipDocumentId: record.get('id')
    	    			},
    	    			success: function(response) {
    	    				Ext.getBody().unmask();
    	    				try {
    	    					var data = Ext.decode(response.responseText);
    	    					var form = frmWin.down('form');
    	    					frmWin.docData = data;
    	    					form.getForm().setValues(data);
    	    					var docName = form.down('#selectDocument');
    	    					docName.getStore().load({
    	    						callback: function() {
    	    							docName.setValue(data.selectDocument.id);
    	    						}
    	    					});
    	    					var docLink = form.down('#documentLink');
    	    					if(data.document && data.document.id) {
	    	    					docLink.setText(data.document.name);
	    	    					docLink.encryptDocId = data.encryptDocId;
	    	    					docLink.show();
    	    					}
    	    					form.down('#selectDocument').setReadOnly(true);
    	    					form.down('#applicableTo').setReadOnly(true);
    	    					var applicability = form.down('#applicability');
    	    					var applicabilityData = applicability.lastSelection;
    	    					applicability.fireEvent('select', applicability, applicabilityData);
    	    				}
    	    				catch(err) {}
    	    			}
    	    		});
    			}
		    },
		    fieldHideShowAccounting:function(record){
		    	var me = this,
		    	accountForm = me.getAccountingDetailsSetupWin(),
		    	expenditureTypeId = accountForm.down('#expenditureTypeId'),
		    	taskNumberId = accountForm.down('#taskNumberId'),
		    	projectNumberId = accountForm.down('#projectNumberId'),
		    	costCenterView = accountForm.down('#costCenterView');
		    	if(record.accountingBased == "costCenterBased"){
		    		expenditureTypeId.setVisible(false);
		    		expenditureTypeId.setDisabled(true);
		    		taskNumberId.setVisible(false);
		    		taskNumberId.setDisabled(true);
		    		projectNumberId.setVisible(false);
		    		projectNumberId.setDisabled(true);
		    		costCenterView.setVisible(true);
		    		costCenterView.setDisabled(false);
		    	}else if(record.accountingBased == "poetBased"){
		    		expenditureTypeId.setVisible(true);
		    		expenditureTypeId.setDisabled(false);
		    		taskNumberId.setVisible(true);
		    		taskNumberId.setDisabled(false);
		    		projectNumberId.setVisible(true);
		    		projectNumberId.setDisabled(false);
		    		costCenterView.setVisible(false);
		    		costCenterView.setDisabled(true);


		    	}else if(record.accountingBased == "dynamicBased"){
		    		expenditureTypeId.setVisible(false);
		    		expenditureTypeId.setDisabled(true);
		    		taskNumberId.setVisible(false);
		    		taskNumberId.setDisabled(true);
		    		projectNumberId.setVisible(false);
		    		projectNumberId.setDisabled(true);
		    		costCenterView.setVisible(false);
		    		costCenterView.setDisabled(true);
		    	}
		    },
		    openEditScholarship: function(isView){
		    	var contentpanel = this.getContentPanel();
		    	var structure = Ext.widget('addscholarshiptab');
		    	if (isView) {
		    		var tabName = getCommonTranslation('VIEW_SCHOLARSHIP');
		    	} else {
		    		var tabName = getCommonTranslation('EDIT_SCHOLARSHIP');
		    	}
		    		
		    	openTab(contentpanel, tabName, structure, CONSTANTS.MENU_COLOR_FIVE);
		    	structure.down("#addscholarshipmappingprogresstracker").setVisible(false);
		        
			  	var addscholarshipmappingprogresstracker = structure.down("#addscholarshipmappingprogresstracker");
			  	structure.down("#accountingDetailTabId").setDisabled(false);
			  	structure.down("#documentAndReferenceTabId").setDisabled(false);	
			  	return structure;
		    },
		    editScholarshipTabPanel: function(isView) {
		    	var this$ = this;
		    	var grid = this$.getBursaryMasterGrid();
		    	var openScholarTab;
		    	
		    	if (grid.getSelectionModel().getCount() > 0) {
		    		var record = grid.getSelectionModel().getSelection()[0];
		    		var tabName = null;
		    		if (isView) {
		    			tabName = getCommonTranslation('VIEW_SCHOLARSHIP');
		    			openScholarTab = getCommonTranslation('VIEW_SCHOLARSHIP');
		    		} else {
		    			tabName = getCommonTranslation('EDIT_SCHOLARSHIP');
		    			openScholarTab = getCommonTranslation('EDIT_SCHOLARSHIP');
		    		}
		    		
		    		var getcontroller=this$.getController('menu.CoreERPNavigationController');
		    		var getTab=getcontroller.getTab(openScholarTab);
			       	 if(getTab!=null){
			       		 contentPanel.remove(getTab, true);
			       	 }
		       	    var getTab=getcontroller.getTab('Add Scholarship Tab');
			       	 if(getTab!=null){
			       		 contentPanel.remove(getTab, true);
			       	 }

			       	var addScholarshipFormWindow = this$.openEditScholarship(isView);
		    		
		    		addScholarshipFormWindow.down('#resetButtonId').setVisible(false);
		    		var saveButton = addScholarshipFormWindow.down('#addScholarshipTabFormSaveBtnId');
		    		if (isView) {
		    			saveButton.setVisible(false);
		    			this$.getActiveTabfromContentPanel().isScholarshipViewMode = true;
		    		} else {
		    			saveButton.setText(getCommonTranslation('SAVE'));
		    		}
		    		var form = addScholarshipFormWindow.down("#addScholarshipTabFormContainerId");
		    		
		    		setTimeout(function(){
		    			if (isView) {
		    				this$.toggleReadOnlyFormItems(form.down('form').getForm(), true);
		    				addScholarshipFormWindow.down('#ownerItemIds').addCls('resetPasswordMultiselect');
		    				addScholarshipFormWindow.down('#allowSchoalrshipIDName').addCls('resetPasswordMultiselect');
		    			}
		    		},500);
		    		var id = record.data.id;
		    		this$.getActiveTabfromContentPanel().scholarshipId = id;
		    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		    		Ext.Ajax.request({
		    			type: 'rest',
		    			url: SERVERURL.PATH_FIND_BY_SCHOLARSHIP_ID,
		    			method: 'GET',
		    			params: {
		    				id: id
		    			},
		    			success: function(res, action) {
		    				var data = Ext.decode(res.responseText);
		    				this$.getActiveTabfromContentPanel().scholarshipId = data.id;
		    				if(!isNullOrEmpty(data.scholarshipCategory) && data.scholarshipCategory=='DEPARTMENTAL') {
		    					addScholarshipFormWindow.down("#documentAndReferenceTabId").hide();
		    					addScholarshipFormWindow.down('#schlAccountingNextBtn').setVisible(false);
		    				}
		    				Ext.getBody().unmask();
		    				data.droolAgendaDescription=data.backgroundDescription;
		    				data.droolAgendaDescriptionOtherLanguage=data.backgroundOtherLanguage;
		    				if(!isNullOrEmpty(data.scholarshipValidFrom)) {
		    					data.scholarshipValidFrom=dateRender(data.scholarshipValidFrom);
		    				}
		    				if(!isNullOrEmpty(data.scholarshipValidTill)) {
			    				data.scholarshipValidTill=dateRender(data.scholarshipValidTill);
		    				}
		    				if(!isNullOrEmpty(data.applicationStartDate)) {
			    				data.applicationStartDate=dateRender(data.applicationStartDate);
		    				}
		    				if(!isNullOrEmpty(data.applicationEndDate)) {
			    				data.applicationEndDate=dateRender(data.applicationEndDate);
		    				}
		    				if(!isNullOrEmpty(data.internalFundAdministrator) && !isNullOrEmpty(data.internalFundAdministrator.id)) {
		    					data.internalFundAdmin=data.internalFundAdministrator.id;
		    				}
		    				data.awardwithOther=data.awardWithOther;
		    				form.down('form').getForm().setValues(data);
		    				var purpose = form.down('#purposeId')
		    				if(data && data.purpose){
			    				var  purposeList = data.purpose.split(',');
								purpose.getStore().load({
									callback: function(records) {
	
										purpose.setValue(purposeList);
	
									}
	
								});
		    				}
		    				form.down('#Id_hidden_field').setValue(data.id);
		    				form.down('#coversOldDebtId').setValue({coversOldDebt:data.coversOldDebt});
		    				form.down('#allocateBalanceOnId').setValue({allocateBalanceOn:data.allocateBalanceOn});
		    				form.down('#darScholarshipId').setValue({darScholarship:data.darScholarship});
		    				form.down('#applicationRequiredId').setValue({applicationRequired:data.applicationRequired});
		    				form.down('#allowInactiveStudent').setValue({allowInactive:data.whetherAllowInactiveStudents})
		    				form.down('#allowApplicationAfterEndDateId').setValue({allowApplicationAfterEndDate:data.allowApplicationAfterEndDate});
		    				if(data.fundAdministratorInternal) {
		    					form.down('#fundAdminId').setValue({fundAdminName:true});
		    				} else {
		    					form.down('#fundAdminId').setValue({fundAdminName:false});
		    				}
		    				form.down("#scholId").setReadOnly(true);
		    				var scholarshipCategoryFld = form.down("#scholarshipCategory");
		    				scholarshipCategoryFld.setReadOnly(true);
		    				scholarshipCategoryFld.fireEvent('select', scholarshipCategoryFld, scholarshipCategoryFld.lastSelection);
		    				this$.applyDFRForScholarshipMasterForm(form);
		    				var fieldSet = form.down("#administrationDetailsItemId");
		    				setTimeout(function(){
		    					fieldSet.collapse();
			    				fieldSet.expand();
		    				},1500);
		    			}
		    		});
		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		    	}
		    },
		    
		    doSaveDocAndRef: function(btn) {
		    	var this$ = this;
		    	var form = btn.up('form');
		    	var vals = form.getValues();
		    	var vals = form.getValues();
		    	var data = {
		    			"selectDocument": {
		    				"id": vals.selectDocument
		    			},
		    			"applicability": vals.applicability,
		    			"applicableTo": vals.applicableTo,
		    			"remark": vals.remark,
		    			"isAllowUplaod": vals.isAllowUplaod,
		    			"scholarship": {
		    				"id": this$.getActiveTabfromContentPanel().scholarshipId
		    			},
		    			"document": {
		    				"name": "",
		    				"path": "",
		    				"type": "DOCUMENT",
		    				"createdBy": {
		    					"id": this.getCurrentlyLoggedInUser().id
		    				}
		    			}
		    	};
		    	if(isNullOrEmpty(form.down('#uploadFileField').getValue())) {
		    		var win = this.getDocsAndRefDetailsWindow();
		    		if(!isNullOrEmpty(win.docData && win.docData.id)) {
		    			data.document = win.docData.document;
		    		}
		    		this.saveDocumentAndReference(data);
		    	}
		    	else {
		    		data.document.name = form.down('#uploadFileField').getRawValue();
		    		var isTransient = true;
     				var module = 'scholarship';
     				var entityId ;
     				var entityType = 'scholarshipDocumentAndReference';
     				this$.applyWindowMask(); 

     				this$.getController('Academia.controller.document.DocumentController').saveDocumentForm(entityId, module, entityType, 'DOCUMENTANDREFERENCE', 
		    				function(success, response, isCallBackTransient) {
     					data.document.path = response.path;
     					this$.saveDocumentAndReference(data);
		    		}, isTransient);
		    	}
		    },
		    
		    saveDocumentAndReference: function(data) {
		    	var me = this;
		    	var win = me.getDocsAndRefDetailsWindow();
		    	var submitUrl = SERVERURL.PATH_SAVE_SCHOLARSHIP_DOCUMENT;
		    	if(!isNullOrEmpty(win.docData && win.docData.id)) {
		    		submitUrl = SERVERURL.PATH_SCHOLARSHIP_DOCUMENT_UPDATE;
		    		data.id = win.docData.id;
		    		if(data.document && win.docData.document) {
		    			data.document.id = win.docData.document.id;
		    		}
		    	}
		    	Ext.Ajax.request({
		    		type: 'rest',
		    		url: submitUrl,
		    		jsonData: data,
		    		method: 'POST',
		    		success: function(res, action) {
		    			var response = Ext.decode(res.responseText);
		    			if(!isNullOrEmpty(response)) {
		    				showSuccessMessage(getFeeAndPaymentCommonTranslation('DOCS_AND_REF_DETAILS'), getCommonTranslation('SUCCESS'));
		    				me.getDocsAndRefDetailsWindow().close();
		    				me.getDocsAndRefStructure().down('grid').getStore().reload();
		    			}
		    		}
		    	});
		    },
		    
		    saveAccountDetailsSetup:function(btn){
		    	btn.setDisabled(true);
		    	var me = this,jsonData,scholarshipArray=[],
		    	accountDetailView = me.getAccountingDetailsSetupWin(),
		    	vals =accountDetailView.down('form').getValues(),
		    	accountYearId = accountDetailView.down('#accountYearId'),
		    	awardWithOther = accountDetailView.down('#awardWithOther'),
		    	allowedScholarship = accountDetailView.down('#allowedScholarship').getValue(),
		    	grid = me.getBursarymasteraccoutinggrid();
		    	accountDetailView.down('#cancelButtonId').setDisabled(true);
		    	if(allowedScholarship && allowedScholarship.length > 0){
		    		try{
		    			var scholarshipId = Ext.Array.pluck(Ext.Array.pluck(allowedScholarship, 'data'), 'id');
		    		} catch(e) {
		    			var scholarshipId = allowedScholarship;
		    		}
		    	}
		    	if(scholarshipId && scholarshipId.length){
		    		scholarshipId.forEach(function(rec){
			    		scholarshipArray.push({
			    			"allowedscholarship" : {
	        					"id" : rec
			    				}	
			    		})
			    	})
		    	}
		    	
		    	if(vals.accountingBased == "dynamicBased"){
		    		jsonData={
		    				"scholarship": {
		    					"id": me.getActiveTabfromContentPanel().scholarshipId
		    				},
		    				"accountingYear": {
		    					"id": vals.accountYearId,
		    					"value":accountYearId.getRawValue()
		    				},
		    				"scholarshipBudgetAmount": vals.totalBuget,
		    				"scholarshipBalanceAmount": vals.balanceAmount,
		    				"basedType": "DYNAMIC",
		    				"awardWithOther":vals.awardWithOther?vals.awardWithOther:null,
		    				"allowedScholarship":scholarshipArray
		    		}
		    	}else if(vals.accountingBased == "costCenterBased"){
		    		jsonData={
		    				"scholarship": {
		    					"id": me.getActiveTabfromContentPanel().scholarshipId
		    				},
		    				"accountingYear": {
		    					"id": vals.accountYearId,
		    					"value":accountYearId.getRawValue()
		    				},
		    				"scholarshipBudgetAmount": vals.totalBuget,
		    				"scholarshipBalanceAmount": vals.balanceAmount,
		    				"basedType": "COST_CENTRE",
		    				"scholarshipAccountingCostCentrePoetDetails": [{
		    					"costCentre": {
		    						"id": vals.costCenterId
		    					},
		    					"costCentreAmount": vals.totalBuget
		    				}             
		    				],
		    				"awardWithOther":vals.awardWithOther?vals.awardWithOther:null,
		    				"allowedScholarship":scholarshipArray

		    		}

		    	}else if(vals.accountingBased == "poetBased"){
		    		jsonData={
		    				"scholarship": {
		    					"id": me.getActiveTabfromContentPanel().scholarshipId
		    				},
		    				"accountingYear": {
		    					"id": vals.accountYearId,
		    					"value":accountYearId.getRawValue()
		    				},
		    				"scholarshipBudgetAmount": vals.totalBuget,
		    				"scholarshipBalanceAmount": vals.balanceAmount,
		    				"basedType": "POET",
		    				"scholarshipAccountingCostCentrePoetDetails": [{


		    					"poetMasterDetails": {
		    						"id": vals.projectNumber
		    					},"poetMasterTaskDetails": {
		    						"id": vals.taskNumber
		    					},"poetMasterContractDetails": {
		    						"id": vals.contractNumber
		    					},"poetMasterContractFundSource": {
		    						"id": vals.fundingSourceNumber
		    					},"expenditureType": {
		    						"id": vals.expenditureType
		    					},"expenditureOrganization": {
		    						"id": vals.expenditureOrg
		    					},
		    					"costCentreAmount": vals.totalBuget
		    				}             
		    				],
		    				"awardWithOther":vals.awardWithOther?vals.awardWithOther:null,
		    				"allowedScholarship":scholarshipArray
		    		}

		    	}
		    	var submitUrl = SERVERURL.PATH_SCHOLARSHIP_SETUP_SAVE;
		    	if(accountDetailView.isEdit){
		    		jsonData.id=accountDetailView.editRecordId;
		    		submitUrl= SERVERURL.PATH_UPDATE_SCHOLARSHIP_ACCOUNTING_DETAILS;
		    		if(accountDetailView.scholarshipAccountingCostCentrePoetDetails){
		    			jsonData.scholarshipAccountingCostCentrePoetDetails[0].id=accountDetailView.scholarshipAccountingCostCentrePoetDetails;
		    		}
		    	}

		    	me.applyWindowMask();
		    	Ext.Ajax.request({
		    		type: 'rest',
		    		url:submitUrl ,
		    		method: 'POST',
		    		jsonData : jsonData,
		    		success: function(res, action) {
		    			me.hideWindowMask();
		    			grid.getStore().load();
		    			btn.up('window').close();
		    			showSuccessMessage(getFeeAndPaymentCommonTranslation('ACCOUNTING_DETAILS_SETUP') ,getCommonTranslation('SUCCESS'));
		    		},
					failure: function(form, action) {
                                         btn.setDisabled(false);
   accountDetailView.down('#cancelButtonId').setDisabled(false);
                                 }
		    	});
		    },
		    
		    hadleAllowUploadCheckbox: function(combo, rec) {
		    	var form = combo.up('form');
		    	var checkbox = form.down('#isAllowUplaod');
		    	if(rec[0].get('id') == 'OPTIONAL') {
		    		checkbox.setReadOnly(false);
		    	}
		    	else {
		    		checkbox.setReadOnly(true);
		    		checkbox.setValue(true);
		    	}
		    },
		    
		    handleDocumentAndReferenceTab: function(combo, rec) {
		    	var tabPanel = combo.up('tabpanel');
		    	var docAndRefTab = tabPanel.getTabBar().items.getAt(2);
		    	if(rec[0].get('id') == 'DEPARTMENTAL') {
		    		docAndRefTab.hide();
		    		tabPanel.down('#schlAccountingNextBtn').setVisible(false);
		    	}
		    	else {
		    		docAndRefTab.show();
		    		tabPanel.down('#schlAccountingNextBtn').setVisible(true);
		    	}
		    },
		    
		    moveToDocAndRefTab: function() {
		    	var addScholarshipTabStructure = this.getAddscholarshiptabstructure();
		    	var stepsAndTabList1 = addScholarshipTabStructure.up()
		    	var documentAndReferenceTabId = stepsAndTabList1.down('#addscholarshiptabstructure').down('#documentAndReferenceTabId')
		    	documentAndReferenceTabId.setDisabled(false);
		    	addScholarshipTabStructure.setActiveTab(documentAndReferenceTabId);
		    	this.setProgressTracker(2);
		    },
		    
		    downloadDocument: function(btn) {
		    	if (!isNullOrEmpty(btn.encryptDocId)) {
		    		this.getController('Academia.controller.document.DocumentController').downloadDocumentFile(btn.encryptDocId);
		    	}
		    },
		    
		    deleteDocument: function(btn) {
		    	var grid = btn.up('grid');
		    	if(grid.getSelectionModel().getCount() > 0){
		    		showConfirmMessage(getCommonTranslation('DOCUMENTS_&_REFERENCE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn,text){
		    			if (btn == 'yes') {
		    				var record = grid.getSelectionModel().getSelection()[0];
		    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		    				Ext.Ajax.request({
		    					type: 'rest',
		    					url: SERVERURL.PATH_DELETE_SCHOLARSHIP_DOCUMENT + '?id=' + record.get('id'),
		    					method: 'DELETE',
		    					/*params: {
		    						id: record.get('id')
		    					},*/
		    					success: function(response) {
		    						Ext.getBody().unmask();
		    						try {
		    							if(isNullOrEmpty(response.responseText)) {
		    								showSuccessMessage(getCommonTranslation('DOCUMENTS_&_REFERENCE'), getCommonTranslation('SUCCESS'));
		    								grid.getStore().reload();
		    							}
		    							else if(data == 'Can not delete scholarshipDocument as already used') {
		    								showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('DEPENDENCY_EXISTS'));
		    							}
		    						}
		    						catch(err) {}
		    					}
		    				});
		    			}
		    		});
		    	}
		    	else {
		    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		    	}
		    },
		    fetchAccountingDetails:function(isView){
		    	var me =this,
		    	grid = me.getBursarymasteraccoutinggrid(),
		    	records = grid.getSelectionModel().getSelection()[0],
		    	id = records.data.id;
				Ext.Ajax.request({
	    			type: 'rest',
	    			url: SERVERURL.PATH_SCHOLARSHIP_ACCOUNTING_DETAILS,
	    			method: 'GET',
	    			params :{
	    				id:id
	    			},
	    			success: function(res, action) {
	    				var data = Ext.decode(res.responseText);
	    				me.editAccountingDetails(isView,data);
	    			}
	    		});
		    },
		    editAccountingDetails:function(isView,record){
		    	var accountingWin = Ext.widget('accountingDetailsSetupWin');
		    	accountingWin.show();
		    	var me = this,
		    	accountYearId = accountingWin.down('#accountYearId'),
		    	totalBuget = accountingWin.down('#totalBuget'),
		    	balanceAmount = accountingWin.down('#balanceAmount'),
		    	costCenterId = accountingWin.down('#costCenterId'),
		    	feeHead = accountingWin.down('#feeHead'),
		    	projectNumber = accountingWin.down('#projectNumber'),
		    	feeHeadProject = accountingWin.down('#feeHeadProject'),
		    	taskNumber = accountingWin.down('#taskNumber'),
		    	contractNumber = accountingWin.down('#contractNumber'),
		    	fundingSourceNumber = accountingWin.down('#fundingSourceNumber'),
		    	expenditureType = accountingWin.down('#expenditureType'),
		    	expenditureOrg = accountingWin.down('#expenditureOrg'),
		    	awardWithOther = accountingWin.down('#awardWithOther'),
		    	allowedScholarship = accountingWin.down('#allowedScholarship'),
		    	allowedScholarship,contractNumberId;
		    	accountingWin.isEdit = true;
		    	accountingWin.editRecordId = record.id;
		    	if(record.scholarshipAccountingCostCentrePoetDetails && record.scholarshipAccountingCostCentrePoetDetails[0] && record.scholarshipAccountingCostCentrePoetDetails[0].id){
		    		accountingWin.scholarshipAccountingCostCentrePoetDetails = record.scholarshipAccountingCostCentrePoetDetails[0].id;
		    	}
		    		

		    	accountYearId.getStore().load({
		    		callback: function(rec){
		    			accountYearId.setValue(record.accountingYear.id);
		    		}
		    	});
		    	awardWithOther.setValue(record.awardWithOther);
		    	var scholarshipIds=[];
		    	allowedScholarship.getStore().getProxy().extraParams={
					scholarshipId:record.scholarship.id
  				}
		    	if(record.awardWithOther == 'ONLY_ALLOWED_SCHOLARSHIP'){
		    		allowedScholarship.setVisible(true);
		    		record.allowedScholarship.forEach(function(rec){
		    			scholarshipIds.push(rec.allowedscholarship.id)
		    		});
		    		
		    		allowedScholarship.getStore().load({
	    				callback: function(rec){
	    					allowedScholarship.setValue(scholarshipIds);
	    				}
	    			});
		    	}
		    	
		    	
		    	accountYearId.setReadOnly(true);
		    	totalBuget.setValue(record.scholarshipBudgetAmount);
		    	balanceAmount.setValue(record.scholarshipBalanceAmount);

		    	if(record.basedType == 'COST_CENTRE'){
		    		accountingWin.down('#accountingType').items.items[0].setValue(true);
		    		accountingWin.down('#accountingType').items.items[1].setDisabled(true);
		    		accountingWin.down('#accountingType').items.items[2].setDisabled(true);
		    		if(record.scholarshipAccountingCostCentrePoetDetails[0] && record.scholarshipAccountingCostCentrePoetDetails[0].costCentre && record.scholarshipAccountingCostCentrePoetDetails[0].costCentre.value){
		    			costCenterId.getStore().getProxy().extraParams={
		    				name:record.scholarshipAccountingCostCentrePoetDetails[0].costCentre.value
		    			}
		    			costCenterId.getStore().load({
		    				callback: function(rec){
		    					costCenterId.setValue(record.scholarshipAccountingCostCentrePoetDetails[0].costCentre.id); 
		    				}
		    			})
		    		}

		    		if(record.scholarshipAccountingCostCentrePoetDetails[0] && record.scholarshipAccountingCostCentrePoetDetails[0].feeStageHeadConfiguration){
		    			feeHead.setValue(record.scholarshipAccountingCostCentrePoetDetails[0].feeStageHeadConfiguration.value);
		    		}
		    	}else if(record.basedType == 'POET'){
		    		accountingWin.down('#accountingType').items.items[0].setDisabled(true);
		    		accountingWin.down('#accountingType').items.items[1].setValue(true);
		    		accountingWin.down('#accountingType').items.items[2].setDisabled(true);
		    		if(record.scholarshipAccountingCostCentrePoetDetails[0] && record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterDetails && record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterDetails.projectNumber){
		    			projectNumber.getStore().getProxy().extraParams={
		    				qry:record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterDetails.projectNumber
		    			}
		    			projectNumberId = record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterDetails.id;
		    			projectNumber.getStore().load({
		    				callback: function(rec){
		    					projectNumber.setValue(record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterDetails.id); 
		    				}
		    			});
		    		}
		    		if(record.scholarshipAccountingCostCentrePoetDetails[0] && record.scholarshipAccountingCostCentrePoetDetails[0].feeStageHeadConfiguration){
		    			feeHeadProject.setValue(record.scholarshipAccountingCostCentrePoetDetails[0].feeStageHeadConfiguration.value);
		    		}

		    		//task number
		    		if(record.scholarshipAccountingCostCentrePoetDetails[0] && record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterTaskDetails){
		    			taskNumber.getStore().getProxy().extraParams={
		    				poetMasterDetailId:projectNumberId
		    			}
		    			taskNumber.getStore().load({
		    				callback: function(rec){
		    					taskNumber.setValue(record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterTaskDetails.id); 
		    				}
		    			});
		    			taskNumber.setDisabled(false);
		    		}
		    		//contract number

		    		if(record.scholarshipAccountingCostCentrePoetDetails[0] && record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterContractDetails){
		    			contractNumber.getStore().getProxy().extraParams={
		    				poetMasterDetailId:projectNumberId
		    			}

		    			contractNumberId = record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterContractDetails.id
		    			contractNumber.getStore().load({
		    				callback: function(rec){
		    					contractNumber.setValue(record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterContractDetails.id); 
		    				}
		    			});
		    			fundingSourceNumber.setDisabled(false);
		    		}
		    		contractNumber.setDisabled(false);
		    		//Funding Source Number number

		    		if(record.scholarshipAccountingCostCentrePoetDetails[0] && record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterContractFundSource){
		    			fundingSourceNumber.getStore().getProxy().extraParams={
		    				poetMasterContractId:contractNumberId
		    			}

		    			fundingSourceNumber.getStore().load({
		    				callback: function(rec){
		    					fundingSourceNumber.setValue(record.scholarshipAccountingCostCentrePoetDetails[0].poetMasterContractFundSource.id); 
		    				}
		    			});
		    			fundingSourceNumber.setDisabled(false);
		    		}
		    		//expenditure Type

		    		if(record.scholarshipAccountingCostCentrePoetDetails[0] && record.scholarshipAccountingCostCentrePoetDetails[0].expenditureType){
		    			expenditureType.getStore().getProxy().extraParams={
		    				query:record.scholarshipAccountingCostCentrePoetDetails[0].expenditureType.itemValue
		    			}

		    			expenditureType.getStore().load({
		    				callback: function(rec){
		    					expenditureType.setValue(record.scholarshipAccountingCostCentrePoetDetails[0].expenditureType.id); 
		    				}
		    			});
		    		}
		    		//expenditure Org

		    		if(record.scholarshipAccountingCostCentrePoetDetails[0] && record.scholarshipAccountingCostCentrePoetDetails[0].expenditureOrganization){
		    			expenditureOrg.getStore().getProxy().extraParams={
		    				query:record.scholarshipAccountingCostCentrePoetDetails[0].expenditureOrganization.itemValue
		    			}

		    			expenditureOrg.getStore().load({
		    				callback: function(rec){
		    					expenditureOrg.setValue(record.scholarshipAccountingCostCentrePoetDetails[0].expenditureOrganization.id); 
		    				}
		    			});
		    		}
		    	}else if(record.basedType == 'DYNAMIC'){
		    		accountingWin.down('#accountingType').items.items[0].setDisabled(true);
		    		accountingWin.down('#accountingType').items.items[1].setDisabled(true);
		    		accountingWin.down('#accountingType').items.items[2].setValue(true);

		    	}
		    	if(isView){
		    		me.toggleReadOnlyFormItems(accountingWin.down('form').getForm(), true);
		    		accountingWin.down('#accountDetailBtn').setVisible(false);
		    	}

		    },
		    
		    onSubmitDocAndRef: function(btn) {
		    	showSuccessMessage(getCommonTranslation('ALERT'), getCommonTranslation('SUCCESS'));
		    	this.getActiveTabfromContentPanel().close();
		    	this.getBursaryMasterGrid().getStore().reload();
		    },
		    fetchStudentDetails:function(studentId,isStudent){
		    	
		    	var me =this,
		    	serverUrl = SERVERURL.FIND_STUDENT_SCHOLARSHIP_APPLICATION,
		    	param={
		    			studentId:studentId
		    	};
		    	if(!isStudent){
		    		serverUrl = SERVERURL.FIND_APPLICANT_SCHOLARSHIP_APPLICATION;
		    		param={
		    				applicationId:studentId
			    	};
		    	}
				Ext.Ajax.request({
	    			type: 'rest',
	    			url: serverUrl,
	    			method: 'GET',
	    			params :param,
	    			success: function(res, action) {
	    				var data = Ext.decode(res.responseText);
	    				me.setStudentDetails(data);
	    				
	    			}
	    		});
		    },
		    setStudentDetails:function(studentRec){
		    	var me =this,studentAge,
		    	scholarshipForm = me.getScholarshipapplicationform(),
		    	country = scholarshipForm.down('#country'),
		    	idType = scholarshipForm.down('#idType'),
		    	idTypeNumber = scholarshipForm.down('#idTypeNumber'),
		    	studentStaus = scholarshipForm.down('#studentStaus'),
		    	externalNumber = scholarshipForm.down('#externalNumber'),
		    	gender = scholarshipForm.down('#gender'),
		    	age = scholarshipForm.down('#age'),
		    	race = scholarshipForm.down('#race'),
		    	hostelCodeName = scholarshipForm.down('#hostelCodeName'),
		    	livingArrangement = scholarshipForm.down('#livingArrangement'),
		    	accreditaionStatus = scholarshipForm.down('#accreditaionStatus'),
		    	accommodationProvidder = scholarshipForm.down('#accommodationProvidder'),
		    	feeBalance = scholarshipForm.down('#feeBalance'),
		    	gradeResult = scholarshipForm.down('#gradeResult'),
		    	previousYearAverage = scholarshipForm.down('#previousYearAverage');
		    	if(studentRec.birthDate){
		    		var today = new Date();
			        var birthDate = new Date(studentRec.birthDate);
			        studentAge = today.getFullYear() - birthDate.getFullYear();
			        var m = today.getMonth() - birthDate.getMonth();
			        if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
			        	studentAge--;
			        }
		    	}
		    	
		    	
		    	studentRec.country ? country.setValue(studentRec.country):country.setValue('NA');
		    	studentRec.externalSysRefOne ? externalNumber.setValue(studentRec.externalSysRefOne):externalNumber.setValue('NA');
		    	studentRec.genderCSM ? gender.setValue(studentRec.genderCSM):gender.setValue('NA');
		    	studentRec.idType ? idType.setValue(studentRec.idType):idType.setValue('NA');
		    	studentRec.livingArrangement ? livingArrangement.setValue(getCommonTranslation(studentRec.livingArrangement)):livingArrangement.setValue('NA');
		    	studentRec.accreditationStatus ? accreditaionStatus.setValue(getHostelTranslation(studentRec.accreditationStatus)):accreditaionStatus.setValue('NA');
		    	studentRec.grade12Marks? gradeResult.setValue(studentRec.grade12Marks):gradeResult.setValue('NA');
		    	studentRec.accommodProviderName ? accommodationProvidder.setValue(studentRec.accommodProviderName):accommodationProvidder.setValue('NA');
		    	studentRec.incomingStudentStatus ? studentStaus.setValue(getCommonTranslation(studentRec.incomingStudentStatus)):studentStaus.setValue('NA');
		    	studentRec.residenceName ? hostelCodeName.setValue(studentRec.residenceName):hostelCodeName.setValue('NA');
		    	studentRec.castCategory ? race.setValue(studentRec.castCategory):race.setValue('NA');
		    	studentRec.previousYearAverageMarks ? previousYearAverage.setValue(studentRec.previousYearAverageMarks):previousYearAverage.setValue('NA');
		    	studentRec.nationalID ? idTypeNumber.setValue(studentRec.nationalID):idTypeNumber.setValue('NA');
		    	studentAge && age.setValue(studentAge);
		    	feeBalance.setValue(studentRec.outStandingBalance);
		    	
		    	
		    },
		    getProgramBetchRec:function(academyLocationId,isStudent){
		    	var me = this;
        		form = me.getScholarshipapplicationform(),
        		program = form.down("#programBatchCode"),
        		batch = form.down("#BatchId"),
        		stdBatchId =  form.down('#stdBatchId'),
        		departmentalId =  form.down('#departmentalId'),
        		studentIdOrName = form.down("#studentIdOrName"),
        		applicantIdOrName = form.down("#applicantIdOrName"),
        		admissionStatus = form.down('#admissionStatus'),
        		programStore = program.getStore().getProxy();
        		
        		if(studentIdOrName.getValue()){
        			var newApi =  {read: SERVERURL.FIND_PROGRAM_BY_AL_AND_STUDENT_ID, update: SERVERURL.FIND_PROGRAM_BY_AL_AND_STUDENT_ID};
            		Ext.apply(programStore.api,newApi);
        			programStore.extraParams={
            			studentId:studentIdOrName.getValue(),
            			academyLocationId:academyLocationId
            		}
        		}else{
        			var newApi =  {read: SERVERURL.FIND_PROGRAM_BY_AL_AND_APPLICANT_ID, update: SERVERURL.FIND_PROGRAM_BY_AL_AND_APPLICANT_ID};
            		Ext.apply(programStore.api,newApi);
            		programStore.extraParams={
            				applicantId:applicantIdOrName.getValue(),
                			academyLocationId:academyLocationId
                		}
        		}
        		
        		program.getStore().load({
        			 callback: function(records, operation, success) {
        				 if (records.length >0) {
        					 program.setDisabled(false);
        					 program.setValue(records[0].data.programId);
        					 stdBatchId.setValue(records[0].data.batchId);
        					 batch.setValue(records[0].data.batchName);
        					 batch.setReadOnly(true);
        					 batch.setDisabled(false);
        					 departmentalId.getStore().removeAll();
        					 departmentalId.getStore().loadData([{
        						 departmentShortCode:records[0].data.departmentShortCode,
        						 departmenetName:records[0].data.departmenetName,
        						 departmentId:records[0].data.departmentId
        					 }],false);
        					 departmentalId.setValue(records[0].data.departmentId.toString())
        					 departmentalId.setReadOnly(true);
        					 departmentalId.setDisabled(false);
        					 if(studentIdOrName.getValue()){
        						 records[0].data.status && admissionStatus.setValue(getCommonTranslation(records[0].data.status));
        					 }else{
        						 records[0].data.currentStatus && admissionStatus.setValue(getCommonTranslation(records[0].data.currentStatus));
        					 }
        					 
        				 }else{
        					 program.setDisabled(false);
        				 }
        				 
  					 }	 
        		})
		    },
		    uploadOnlineDocumnetStudent:function(){
        		var activeTab = this.getActiveTabfromContentPanel();
        		var listOfOnlineDocGrid = activeTab.down('listofonlinedocumentsgrid');
        		if (listOfOnlineDocGrid.getSelectionModel().getCount() > 0) {
        			var selectedRecord = listOfOnlineDocGrid.getSelectionModel().getSelection()[0].data;
        			var frmWin = this.getSchldocumentdetailswin();
        			if(!frmWin){
        				Ext.widget('schldocumentdetailswin');
        				frmWin = this.getSchldocumentdetailswin();
        			}
        			frmWin.show();
        			frmWin.down('#documentName').setValue(selectedRecord.doucumentMasterName);
        			frmWin.down('#submissionDate').setValue(dateRender(new Date()));
        			frmWin.down('#submissionMode').setValue("Online");
        			frmWin.down('#documentStatus').setValue("Submitted");
        		}else {
     			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
     		   }  
        	
		    },
		    
		      showPurposeOnPopUpWindow : function(){
				var purposeWindow = this.getScholarshipPurposePopUpWindow();
				var grid = this.getBursaryMasterGrid();
				var records = grid.getSelectionModel().getSelection();
				
 				if (!purposeWindow) {
 					purposeWindow = Ext.widget('scholarshipPurposePopUpWindow',{
 						itemId:'scholarshipPurposePopUpWindowItemId'
 					});
 				}
 				purposeWindow.show();
 				
 				var purposeStore = this.getScholarshipPurposePopUpGrid().getStore();
 				var purpose;
				if (records.length == 1) {
					purpose = records[0].data.purpose
					var valuesArray = purpose.split(",");
					var gridRecords = [];
					Ext.each(valuesArray, function(value) {
						if (value == 'MERIT') {
							value = 'Merit';
						} if (value == 'HISTORIC_DEBT') {
							value = 'Historic Debt';
						} if (value == 'SPORTS') {
							value = 'Sports';
						} if (value == 'RECRUITMENT') {
							value = 'Recruitment';
						} if (value == 'FINANCIAL_NEED') {
							value = 'Financial Need';
						} if (value == 'SUPPORT_SCHOLARSHIP') {
							value = 'Support Scholarship';
						} if (value == 'RESEARCH') {
							value = 'Research';
						} if (value == 'LEADERSHIP') {
							value = 'Leadership';
						} if (value == 'FAMILY') {
							value = 'Family';
						} if (value == 'PRIVATE') {
							value = 'Private';
						} if (value == 'TRAVEL') {
							value = 'Travel';
						} if (value == 'DEPARTMENTAL') {
							value = 'Departmental';
						} if (value == 'GENERAL') {
							value = 'General';
						}
						gridRecords.push({
							'purpose': value
						});
					});
					purposeStore.loadData(gridRecords);

				}
 				//var grid = this.getScholarshipPurposePopUpGrid();
 				grid.down('#btnExportToPDF').setVisible(false);
 				grid.down('#btnExportToExcel').setVisible(false);
 				this.resetPageSetting(grid.getStore());
 				grid.getStore().load();
			},
			
		    declineScholarshipBehalfStudent:function(){
 				var $this = this;
 				var grid = $this.getManagescholarshipstudentlistgrid();
 				showConfirmMessage(getCommonTranslation('SCHOLARSHIP_DECLINE'),getCommonTranslation('DECLINE_SCHOLARSHIP_APPLICATION_BEHALF_STUDENT'),function(btn,text){
					 if (btn == 'yes') {
						 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						// to get the data of current open tab
		     				var scholarshipNominationId;
		     			    Ext.each($this.stdSchlData,function(data){
		     			    	if($this.getContentPanelActiveTab().title == data.scholarshipAppNumber){
		     			    		scholarshipNominationId= data.scholarshipNominationId;
		     			    		return false;
		     			    	}
		     			    });
						 var jsonData={
								   "id" : scholarshipNominationId,
								   "code":null,
								   "status":"DECLINED"
						 };
						Ext.Ajax.request({
							method : 'POST',
							jsonData : jsonData,
							type : 'rest',
							url : SERVERURL.PATH_UPDATE_STATUS_NOMINATION,
							headers : {
								'Content-Type' : 'application/json'
							},
							success : function(form,action) {
								Ext.getBody().unmask();
								grid.getStore().reload();
								grid.getSelectionModel().deselectAll(true);  
								$this.getContentPanelActiveTab().close();
								showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SCHOLARSHIP_DECLINED_SUCCESSFULLY'));
							}
						});
					 }
				 });
				
		    },
		    checkDateIspassed:function(){
		    	var me = this,
		    	form = me.getAddscholarshiptabform(),
		    	startDate = form.down('#scholarshipValidFromId'),
		    	endDate = form.down('#scholarshipValidTillId'),
		    	cmbStatus = form.down('#cmbStatus'),
		    	startDateVal = startDate.getValue(),
		    	endDateVal = endDate.getValue(),
		    	currentDate = new Date();
		    	currentDate.setHours(0, 0, 0, 0);
		    	if(startDateVal && endDateVal){
		    		startDateVal = new Date(startDateVal);
		    		startDateVal=startDateVal.setHours(0, 0, 0, 0);
		    		endDateVal = new Date(endDateVal);
		    		endDateVal=endDateVal.setHours(0, 0, 0, 0);
		    		if( startDateVal<= currentDate && currentDate <= endDateVal){
		    			cmbStatus.setValue(true);
		    		}else{
		    			cmbStatus.setValue(false);
		    		}
		    	}
		    }
});
