
Ext.define('Academia.controller.securitysetup.User',{
	extend: 'Academia.controller.base.BaseController',
	views:['criteriabuilder.userquicksearch.UserQuickSearch','criteriabuilder.userquicksearch.QuickSearch',
	         'criteriabuilder.grid.SearchResultGrid','securitysetup.UserGrid','securitysetup.RolePrivilegeGrid',
	       'securitysetup.UserDetails','securitysetup.AccessRightsTree','securitysetup.UserBasicDetails',
	       'common.StatusCombo','securitysetup.AssignAcademyLocationForm','securitysetup.AssignRoleForm',
	       'common.NestedJsonCombo','securitysetup.UserPrivilegeGridWindow','securitysetup.ProgramCourseTreeForUser',
			'securitysetup.AssignProgramWindow','securitysetup.UserPasswordPolicy','login.AdminResetPasswordWindow',
			'criteriabuilder.userquicksearch.UserUploaddownloadStructure','criteriabuilder.userquicksearch.UserUploadForm',
			'criteriabuilder.userquicksearch.UserDownloadForm','criteriabuilder.userquicksearch.ImportListUsers',
			'securitysetup.AcademyLocationRoleGridWindow', 'criteriabuilder.userquicksearch.UserRoleUploaddownloadStructure',
			'criteriabuilder.userquicksearch.UserRoleUploadForm', 'criteriabuilder.userquicksearch.UserRoleDownloadForm',
			'criteriabuilder.userquicksearch.ImportListUserRole','criteriabuilder.CriteriaCreator','criteriabuilder.userquicksearch.UsersSendMessage',
			'criteriabuilder.userquicksearch.UsersStaticDocumentAttachmentGrid','UploadOptionRadioGroup',
			'criteriabuilder.userquicksearch.UserUpdateUploadDownloadStructure',
			'criteriabuilder.userquicksearch.UserUpdateUploadForm',
			'criteriabuilder.userquicksearch.UserUpdateDownloadForm','securitysetup.MultipleALandRolesGrid',
			'criteriabuilder.userquicksearch.ImportUserUpdateGrid','securitysetup.MultipleALandRolesForm'],
	requires: [ 'Ext.ux.IFrame' ] ,
	stores:['user.UserTypeStore','criteriabuilder.SearchResultStore',
	        'securitysetup.AccessTree','common.SalutationStore','department.ParentDepartmentStore',
	        'department.ChildDepartmentStore','calendar.ActiveCalendarStore','userGroup.UserGroupStore',
	        'organization.academylocations.AllActiveAcademyStore','securitysetup.ModuleStore','securitysetup.PortalStore',
	        'organization.academylocations.LocationByAcademyStore','securitysetup.ActiveRolesStore','securitysetup.UserRolePrivilege',
	        'securitysetup.ProgramsForUsers','securitysetup.Programs','enquiry.studentDetail.GenderStore',
	        'enquiry.studentDetail.BloodGroupStore','common.ReligionStore','common.NationalityStore','common.StatusComboStore',
	        'authentication.PortalStore','securitysetup.SubModuleStore','common.InternalExternal','user.UserAcademyLocationStore',
	        'common.AllUserBySmartSearch','criteriabuilder.userquicksearch.QuickSearchName','criteriabuilder.userquicksearch.QuickSearchCode',
	        'common.AllActiveAcademyLocationStore','personinfo.faculty.FacultyTypeStore','user.EmployeeTypeStore',
	        'importutility.ModuleName','criteriabuilder.userquicksearch.ImportUsers','securitysetup.AcademyLocationByRoleStore',
	        'common.AcademyLocationNameSeparated', 'criteriabuilder.userquicksearch.ImportUserRoleStore', 'user.AccountTypeStore',
	        'messaging.MessagingTemplatesStore','committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore',
	        'attendance.UserGroup','securitysetup.LeaveCategorTypeStore','common.CountryStore','department.ParentDepartmentByAccesibleStore','department.SubDepartmentComboStore',
	        'criteriabuilder.userquicksearch.ImportUserUpdateStore','Academia.store.common.GenderTypeStore','common.FacultyTypeCSMStore','securitysetup.ActiveLockedAndUnLockedRolesStore',
	        'feeandpayment.AcademyLocationManageHoldMappingList','securitysetup.MultipleALandRolesGridStore','Academia.view.personinfo.student.StudentUploadPhotoWindow'],
	refs: [
	       {
	   		ref : 'quickSearchForm',
	   		selector : 'quicksearch form[itemId=userQuickSearchForm]'
	   	},{
	   		ref : 'quickSearch',
	   		selector : 'quicksearch'
	   	},{
	   		ref : 'searchResultGrid',
	   		selector:'searchresultgrid[itemId=userSearchresultgrid]'
		}, {
		    ref: 'academyLocationForm',
		    selector: 'useracademylocation form'
		}, {
		    ref: 'userAcademyLocation',
		    selector: 'useracademylocation' 
		}, {
		    ref: 'usergrid',
		    selector: 'usergrid'
		},{
			ref:'accessRightsTree',
			selector:'accessrighttree'
		},{
			ref:'assignRole',
			selector:'assignroleformwindow'
		},{
			ref:'assignRoleForm',
			selector:'assignroleformwindow form'
		},{
			ref:'userPrivilegeGridWindow',
			selector:'userPrivilegeGridWindow'
		},{
			ref:'userPrivilegeGrid',
			selector:'userPrivilegeGridWindow grid[itemId=userPrivilegeGrid]'
		},{
			ref:'assignProgramWindow',
			selector:'assignprogramwindow'
		},{
	        ref: 'winUserBasicDetails',
	        selector: 'userbasicdetails'
	    },{
	        ref: 'adminresetpasswordwindow',
	        selector: 'adminresetpasswordwindow[itemId=userlistadminresetpasswordwindow]'
	    },{
	    	ref: 'userdDetails',
	    	selector: 'userdetails'
	    },/*{
	    	ref :'sendMessageWindow',
	    	selector : 'sendmessagewindow[itemId=userSendMessageWindow]'
	    },*/{
	    	ref :'userssendmessage',
	    	selector : 'userssendmessage[itemId=userSendMessageWindow]'
	    },{
	    	ref:'importListUsers',
	    	selector:'importlistusers'
	    },{
	    	ref:'academylocationrolegridwindow',
	    	selector:'academylocationrolegridwindow'
	    },{
	    	ref:'importListUserRole',
	    	selector:'importlistuserrole'
	    },{
	    	ref:'criteriacreator',
	    	selector:'criteriacreator'
	    },{
	    	ref :'usersstaticdocumentattachmentgrid',
	    	selector : 'usersstaticdocumentattachmentgrid'
	    },{
	    	ref:'contentPanel',
	    	selector:'contentPanel'
	    },{
	   		ref : 'useruploadform',
	   		selector : 'useruploadform'
	   	},{
	   		ref : 'uploadoptionradiogroup',
	   		selector : 'uploadoptionradiogroup[itemId=userListUploadOptionRadioGroupItemId]'
	   	},{
	   		ref : 'userRoleuploadoptionradiogroup',
	   		selector : 'uploadoptionradiogroup[itemId=userRoleListUploadOptionRadioGroupItemId]'
	   	},{
	   		ref : 'userroleuploadform',
	   		selector : 'userroleuploadform'
	   	}, {
	   		ref : 'importuserupdategrid',
	   		selector : 'importuserupdategrid'
	   	},{
	   		ref : 'userupdateuploadoptionradiogroup',
	   		selector : 'uploadoptionradiogroup[itemId=userUpdateUploadOptionRadioGroupItemId]'
	   	},{
	   		ref:'multiplealandrolesform',
	   		selector:'multiplealandrolesform'
	   	},{
	   		ref:'multiplealandrolesgrid',
	   		selector:'multiplealandrolesgrid'
	   	},{
			ref:'studentuploadphotowindow',
			selector:'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId]'
		}],
	    
	config:{
		/**
         * @cfg {Ext.util.HashMap} USER_MANAGEMENT_PERMISSIONS (required)
         * The map of all the permissions that can will be set in the FeaturePrivilegeManager
         * pass the key ("USER_MANAGEMENT") to retrieve the hashmap.
         * @accessor
         */
		USER_MANAGEMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('USER_MANAGEMENT'),
		CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
		USER_ACCESS_RIGHTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('USER_ACCESS_RIGHTS'),
		portals:null,
		selectedUser : null
	},
    
	init: function(application) {
		//this.roleALMappings = [];
		this.alGridindex=0;
		this.isRemovedBtnClick = false;
    	this.isUploadBtnClick = false;
	    this.control({
	    	'userbasicdetails container[itemId=profile_image_icon]': {
	  			  afterrender: function(container) {
	  			        container.getEl().on('click', this.openPhotoUploadPopupToUser, this);
	  			    }
	  		   },
	  		 'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId] button[name=btnCancel]': {
				   click: function(button) {
					   var window = this.getStudentuploadphotowindow();
					   window.close();
				   }
			   },
			   'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId] button[name=btnEdit]': {
				   click: function(button) {
					   	var window = this.getStudentuploadphotowindow();
				        var btnEdit = window.down('button[name=btnEdit]');
				        var btnRemove = window.down('button[name=btnRemove]');
				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
				        var btnCancel = window.down('button[name=btnCancel]');
				        var btnBack = window.down('button[name=btnBack]');

				        btnEdit.setVisible(false);
				        btnRemove.setVisible(false);
				        btnCancel.setVisible(false);
				        
				        // Show Upload Photo and Take a Photo buttons
				        btnUploadPhoto.setVisible(true);
				        btnTakePhoto.setVisible(true);
				        btnBack.setVisible(true);
				   }
			   },
			   'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId] button[name=btnBack]': {
				   click: function(button) {
					   	var window = this.getStudentuploadphotowindow();
					   	window.down('#profile_image_containerBox').destroy();
					   	window.down('#profileRoatateImageIconId').hide();
					   	window.down('#profileImageFormItemId').insert(0,{
					   		// Profile Image Container
					   		xtype: 'container',
					   		width: 320,
					   		height: 280,
					   		layout: {
					   			type: 'vbox',
					   			align: 'center',
					   			style: {
					   				position: 'relative',
					   			}
					   		},
					   		itemId: 'profile_image_containerBox',
					   		items: [{
					   			xtype: 'image',
					   			itemId: 'profile_image',
					   			border: 1,
					   			style: {
					   				borderColor: '#e0e0e0',
					   				borderStyle: 'solid',
					   				borderRadius: '50%',
					   				marginTop:'67px !important'
					   			},
					   			width: 210,
					   			height: 210,
					   			src: 'resources/images/default-profile.png',
//					   			margin: '0 0 3 0', // Adds spacing around the image
					   		},{
					   			xtype: 'hidden',
					   			name: 'isImageRemoved',
					   			itemId: 'isImageRemovedItemId'
					   		}]
					   	},
					   	{
					   		id:'capture_panel',
					   		itemId:'capturePanelId',
					   		hidden:true,
					   		listeners:{
					   			show:function(obj){
					   				Webcam.set({
					   					width: 320,
					   					height: 240,
					   					crop_width: 320,
					   					crop_height: 240,
					   					flip_horiz: true,
					   					image_format: 'jpeg', // image format (may be jpeg or png)
					   					jpeg_quality: 100 // jpeg image quality from 0 (worst) to 100 (best)
					   				});
					   				Webcam.attach('#capture_panel-innerCt');
					   			},
					   			hide: function () {
					   				Webcam.reset();
					   			}
					   		}
					   	},{
					   		xtype:'panel',
					   		itemId:'previewPanelId',
					   		hidden:true
					   	},{
					   		xtype:'panel',
					   		hidden:true,
					   		html: "<canvas  id='canvas' width='310' height='272'></canvas>"
					   	},
					   	// Button Container for Profile Actions
					   	{
					   		xtype: 'container',
					   		layout: {
					   			type: 'hbox',
					   			align: 'middle',
					   			//pack: 'center',
					   		},
					   		margin: '20 0 0 0', // Adds spacing above the buttons
					   		/*defaults: {
					labelAlign: 'top',
					margin: '0 5', // Adds spacing between buttons
				},*/
					   		items: [{
					   			xtype: 'button',
					   			text: getCommonTranslation('EDIT'),
					   			name: 'btnEdit',
					   			itemId: 'btnEditItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			style: {
					   				width: "60px !important",
					   			}
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('REMOVE'),
					   			name: 'btnRemove',
					   			itemId: 'btnRemoveItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			disabled: true
					   		},{
					   			xtype: 'filefield',
					   			buttonText: getCommonTranslation('UPLOAD_PHOTO'),
					   			name: 'file',
					   			itemId: 'btnUploadPhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			buttonOnly: true
					   		}, {
					   			xtype: 'hidden',
					   			name: 'name',
					   			itemId: 'fileName'
					   		}, {
					   			xtype: 'hidden',
					   			name: 'personId',
					   			itemId: 'personId'
					   		}, {
					   			xtype: 'button',
					   			text: getCommonTranslation('TAKE_A_PHOTO'),
					   			name: 'btnTakePhoto',
					   			itemId: 'btnTakePhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('CAPTURE'),
					   			name: 'capturePhoto',
					   			itemId: 'capturePhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			style:{
					   				marginTop:'6px !important'
					   			}
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('RESET'),
					   			name: 'resetPhoto',
					   			itemId: 'resetPhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			style:{
					   				marginTop:'6px !important'
					   			}
					   		}]
					   	},
					   	{
					   		xtype: 'button',
					   		cls: 'profileRoatateImageIcon',	
					   		itemId: 'profileRoatateImageIconId',
					   		hidden: true,
					   		rotate: 0.1
					   	},{
					   		// Footer Button Container
					   		xtype: 'container',
					   		layout: {
					   			type: 'hbox',
					   			pack: 'space-between',
					   			//align: 'middle'
					   		},
					   		margin: '60 0 0 0', // Adds spacing above the footer buttons
					   		width: '100%',
					   		defaults: {
					   			//flex: 1,
					   			//margin: '0 100',
					   		},
					   		items: [{
					   			xtype: 'button',
					   			text: getCommonTranslation('CANCEL'),
					   			name: 'btnCancel',
					   			itemId: 'btnCancelItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,	
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('BACK'),
					   			name: 'btnBack',
					   			itemId: 'btnBackItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   		},{
					   			xtype: 'component', 
					   			flex: 2
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('SAVE'),
					   			name: 'btnSave',
					   			itemId: 'btnSaveItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			disabled: true
					   		}]
					   	});
					   	var profile = this.getContentPanelActiveTab();
				        var btnEdit = window.down('button[name=btnEdit]');
				        var btnRemove = window.down('button[name=btnRemove]');
				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
				        var btnCancel = window.down('button[name=btnCancel]');
				        var btnBack = window.down('button[name=btnBack]');
				        var btnSave = window.down('button[name=btnSave]');
				        var capturePhoto = window.down('#capturePhotoItemId');
 					   	var resetPhoto = window.down('#resetPhotoItemId');
 					   	var profileImage = window.down('#profile_image');
 					   	var capturePanel = window.down('#capturePanelId');
 					   	var previewPanelId = window.down('#previewPanelId');
				        
				        btnEdit.setVisible(true);
				        btnRemove.setVisible(true);
				        btnCancel.setVisible(true);
				        btnSave.setDisabled(true);
				        profileImage.setVisible(true);
				        
				        if (window.lastSavedImageUrl) {
                          profileImage.setSrc(window.lastSavedImageUrl);
	                    } else {
                    	   var newImgUrl = generateInitialsImage(
                			    profile.down('#firstName').value, 
                  				profile.down('#middleName').value, 
                  				profile.down('#lastName').value
      						);
                           profileImage.setSrc(newImgUrl);
	                     }
				        
				        if (window.previousProfileImage) {
	                           profileImage.setSrc(window.previousProfileImage);
	                           profileImage.setVisible(true);
	                       }
				        
				        btnUploadPhoto.setVisible(false);
				        btnTakePhoto.setVisible(false);
				        btnBack.setVisible(false);
				        capturePhoto.setVisible(false);
 					   	resetPhoto.setVisible(false);
 					   	capturePanel.setVisible(false);
 					    previewPanelId.setVisible(false);
 					    
 					   capturePhoto.setDisabled(false);
                       resetPhoto.setDisabled(true);
                       window.down('#btnUploadPhotoItemId').reset();
				   }
			   },
			   'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId] filefield[itemId=btnUploadPhotoItemId]': {
				   change: function(button, event){
					   isUploadBtnClick = true;
				        isRemovedBtnClick = false;
					   this.userToUploadProfilePhoto(button, event)	
				   }
			   },
			   'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId] button[itemId=btnSaveItemId]': {
				   click: this.userToUploadCapturedImage
			   },
			   'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId] button[itemId=btnRemoveItemId]': {
				   click:function(button, event){
				       isUploadBtnClick = false;
					   isRemovedBtnClick = true;
					   this.userToUploadProfilePhoto(button, event)					   
				   }
			   },
			   'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId] button[itemId=resetPhotoItemId]': {
                   click: function(button) {
                       var window = this.getStudentuploadphotowindow();
                       window.down('#capturePanelId').setVisible(true);
                       window.down('#previewPanelId').setVisible(false);
                       window.down('#previewPanelId').update('');
                       window.down('#capturePhotoItemId').setDisabled(false);
                       window.down('#resetPhotoItemId').setDisabled(true);
                       window.down('#btnSaveItemId').setDisabled(true);
                       window.cropData = null;
                       window.component = null;
                   }
               },
               'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId] button[itemId=btnTakePhotoItemId]': {
				   click: function(button) {
					   this.userToOpenCapturePhoto();
				   }
			   },
			   'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId] button[itemId=capturePhotoItemId]': {
				   click: function(button) {
					   this.userToCaptureUserPhoto(button);
				   }
			   },
	    	//Search criteria
			'quicksearch combo': {
	            render: this.onUserQuickSearchRender
	        },
	        'quicksearch button[itemId=searchButtonId]' : {
                click : function(btn){
                    var grid = btn.up('userquicksearch').down('grid');
                    this.loadGridAndSearchUsers();
                    this.genericCBGridAccessControlValidation(grid, this.getUSER_MANAGEMENT_PERMISSIONS());
                    this.disableMoreActionPivileges(grid,this.getUSER_MANAGEMENT_PERMISSIONS());
                    this.addDataGridConfigButton(grid,this.getUSER_MANAGEMENT_PERMISSIONS());
                }
            },
			
			/*'searchresultgrid[itemId=userSearchresultgrid]':{
				render: function(grid) {
	    			this.gridRenderFunction(grid);
	    			this.loadGridAndSearchUsers(); 			
				}
			},*/
			'userquicksearch searchresultgrid[itemId=userSearchresultgrid]': {
				cellclick: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					this.cellClickUserSearchResultGrid(view, td, cellIndex, record, tr, rowIndex, e, eOpts)
				},
				afterrender : function(grid){
					this.gridRenderFunction(grid);
	    			//this.loadGridAndSearchUsers();
					this.genericCBGridAccessControlValidation(grid, this.getUSER_MANAGEMENT_PERMISSIONS());
					this.disableMoreActionPivileges(grid,this.getUSER_MANAGEMENT_PERMISSIONS());
					this.addDataGridConfigButton(grid,this.getUSER_MANAGEMENT_PERMISSIONS());
				},
				/*afterrender:function(grid){
					var me=this;
					me.addDataGridConfigButton(grid,me.getUSER_MANAGEMENT_PERMISSIONS());
				},*/
//				selectionchange: function(column, selected,eOpts ){
//                	this.disableExtraButton(column,selected);                	
//                }
			},
			//user grid
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=searchResultGridBtnAdd]': {
	            click:  function() {
	            	var me = this;
	            	this.showFormTab(getCommonTranslation('ADD_USER'));
	            	var form = this.getWinUserBasicDetails();
	        		var countryCodeFieldArray = ["#mobileCountryCode"];
	        		this.setDefaultCountryCode(form, countryCodeFieldArray);
	        		 var countryCodeField = form.down("#mobileCountryCode");
                     var mobileField = form.down("#mobileNumber");
                     this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                     
                     Ext.Ajax.request({
                    	 type: 'rest',
                    	 url: SERVERURL.FIND_WHETHER_CONFIGORNOT_DATA_SETTING_OF_USERID,
                    	 method: 'GET',
                    	 headers : {
                    		 'Content-Type' : 'application/json'
                    	 },
                    	 success: function(response, action) {
                          var data = response.responseText;
                          if(data == "true"){
                        	  form.down('#code').setReadOnly(false);
                  	    	  form.down('#code').allowBlank = false;  
                          }else{
                        	  form.down('#code').setReadOnly(true);
                  	    	  form.down('#code').allowBlank = true; 
                          }       
                         // me.removePlaceHolder();
                    	 }
                     });
                    
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=searchResultGridBtnEdit]': {
	            click: function() {
	                this.editFormWindow();
	                var form = this.getWinUserBasicDetails();
	                var countryCodeField = form.down("#mobileCountryCode");
                     var mobileField = form.down("#mobileNumber");
                     this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=searchResultGridBtnView]': {
	            click: function() {
	                this.viewUserRecord();
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=searchResultGridBtnDelete]': {
	            click: function() {
	                this.deleteUserRecord();
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=resetButtonItemId]': {
	            click: function() {
	            	var grid = this.getSearchResultGrid();
		        	if (grid.getSelectionModel().getCount() > 0) {
		        		 this.openResetPasswordWindow();
	        		} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}  
		       	     
	            }
	        },
	        
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=createUserInAlfresco]': {
	        	click: function() {

	        		var grid = this.getSearchResultGrid();
	        		var userIdsArray = [];
	        		var gridRec=grid.getSelectionModel().getSelection();
	        		if (grid.getSelectionModel().getCount() > 0) {
	        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        			for( var i = 0; i < gridRec.length; i++) {
	        				userIdsArray.push(gridRec[i].data.USER_ID);
	        			}

	        			Ext.Ajax.request({
	        				type: 'rest',
	        				url: SERVERURL.PATH_CREATE_MULTIPLE_USERS,
	        				method: 'POST',
	        				jsonData : {
	        					userName: userIdsArray.join(),
	        				},
	        				headers : {
	        					'Content-Type' : 'application/json'
	        				},
	        				success: function(response, action) {
	        					Ext.getBody().unmask();
	        					showSuccessMessage(getCommonTranslation('ACTIVATE_BUTTON'), getCommonTranslation('SUCCESS'));
	        				}
	        			});

	        		} else {
	        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        		}  

	        	}
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=selectSimilarRecords]': {
	        	click: function() {
	        		var grid = this.getSearchResultGrid();
	        		if (grid.getSelectionModel().getCount() > 0) {
	        			showWarningMessage(getCommonTranslation('ALERT'),grid.getStore().getTotalCount()+' '+getCommonTranslation('SIMILAR_RECORDS_SELECTED'));
	        		} 
	        	}
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] menuitem[itemId=activateButtonItemId]': {
	            click: function() {
	            	var grid = this.getSearchResultGrid();
		        	if (grid.getSelectionModel().getCount() > 0) {
		        		 var userRecord = grid.getSelectionModel().getSelection()[0];
		        		if(!isNullOrEmpty(userRecord)){
		            		showConfirmMessage(getCommonTranslation('ACTIVATE_BUTTON'), getCommonTranslation('ACTIVATE_USER_CONFIRM_MESSAGE'), function(btn, text) {
		                        if (btn == 'yes') {
		                        	
		                        	var url = SERVERURL.ACIVATE_USER;
		                        	var id = userRecord.get('USER_ID');
		                        	url = url.concat('?id='+id);
		                            Ext.Ajax.request({
		                                type: 'rest',
		                                url: url,
		                                method: 'PUT',
		                                async: false,
		                                headers: {
		                                    'Content-Type': 'application/json'
		                                },
		                                success: function(response) {
		                                	showSuccessMessage(getCommonTranslation('ACTIVATE_BUTTON'), getCommonTranslation('USER_ACTIVATED_SUCCESSFULLY'));
		                                	grid.getSelectionModel().deselectAll();
		                                	grid.getStore().load();
		                                }
		                            });
		                        }
		                        });
	        		} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}  
		        	}
	            }
	        },
	        'userssendmessage[itemId=userSendMessageWindow] radiogroup[itemId=messageType]':{
  	        	change : function(val,nV,oV){
  	        		this.selectSectionMessageType(val,nV,oV);
  	        	}
  	        },
	        'userssendmessage[itemId=userSendMessageWindow] customcombobox[itemId=msgTempletId]':{
  	        	select : function(obj,rec){
  	        		this.selectUserMessageTemp(obj,rec);
  	        	}
  	        },
  	        'userssendmessage[itemId=userSendMessageWindow] button[itemId=adhocMsgSubmitBtn]':{
  	        	click: function(obj) {
  	        		var grid = this.getSearchResultGrid();
    				var userssendmessage = this.getUserssendmessage();
    				var formPnl = obj.up('form');
   	        		var isMySelfChecked = false;
   	        		var fldValues = formPnl.getForm().getFieldValues();
   	        		isMySelfChecked = fldValues.recieverType;
   	        		var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
    				userssendmessage.sendMessage(obj,grid,isMySelfChecked,currentlyLoggedInUserId);
  	        	}
  	        },'userssendmessage[itemId=userSendMessageWindow]  filefield[itemId=staticUploadFileField]': {
  	        	change: function(fileField, value, eOpts){
  	        		var this$ = this;
  	        		this$.uploadUserStaticDocumentFileMessage(fileField, value, eOpts);
  	        	}
  	        },
  	        'usersstaticdocumentattachmentgrid actioncolumn': {
  	        	click : function(view, rowIndex, colIndex, item, e, record, row){
  	        		this.deleteUserStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
  	        	}
  	        },'userssendmessage[itemId=userSendMessageWindow]': {
  	        	render: function(grid){
  	        		var this$ = this;
  	        		var docGrid = grid.down('#usersStaticDocumentAttachmentGridMessage');
  	        		docGrid.getStore().removeAll();
  	        		docGrid.getStore().sync();
  	        		var itemIdPrivilegeNameArray = [{"#adhocMessage" : "ADHOC_MESSAGE" , "#messageTemplate" : "MESSAGE_TEMPLATE", "radioGroupItemId" : "#messageType", "defaultButtonItemId" : "#adhocMessage" }];
  	        		this$.disableRadioGroupAndOtherPivileges(grid, this$.getUSER_MANAGEMENT_PERMISSIONS(), itemIdPrivilegeNameArray);
  	        	}
  	        }, 'userssendmessage[itemId=userSendMessageWindow] radiogroup#sendingPriority': {
  	        	change: function( radio, newValue, oldValue, eOpts) {
  	        		this.loadUserScheduleField(radio, newValue, oldValue);
  	        	}
  	        },

  	        /*V2D-13247*/
  	        'userssendmessage[itemId=userSendMessageWindow] textarea[itemId=smsDiscription]':{
  	        	change : function(val,nV,oV){
  	        		var usersSendMessage = this.getUserssendmessage();
  	        		var smsTextField = usersSendMessage.down('#smsDiscription');
  	        		var smsTextFieldDiscription = usersSendMessage.down('#smsDiscriptionNotice');
  	        		var maxLength = localStorage.getItem('maxLength');
  	        		var newValue = maxLength - smsTextField.getValue().length;
  	        		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
  	        	}
  	        },
  	        
  	      'userssendmessage[itemId=userSendMessageWindow] textarea[itemId=pushNotificationDiscription]':{
  			change : function(val,nV,oV){
  				var usersSendMessage = this.getUserssendmessage();
  				var pushTextField = usersSendMessage.down('#pushNotificationDiscription');
  				var pushTextFieldDiscription = usersSendMessage.down('#pushNotificationDiscriptionNotice');
  				var maxLength = 1000;
  				var newValue = maxLength - pushTextField.getValue().length;
  				pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
  			}
  		},
	        
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=sendMessageBtn]': {
	            /*click: function(obj) {
                	var grid = this.getSearchResultGrid();
	            	if (grid.getSelectionModel().getCount() > 0) {
	            		var this$ = this;
	                	var window = this$.getSendMessageWindow();
	                	if(!window){
	                		window = Ext.widget('sendmessagewindow',{
	                			itemId:'userSendMessageWindow'
	                		});
	                		window.down('#msgRecipientTypeItemId').setValue(RECIPIENT_TYPES_COSTANTS.USER);
	                	}
	                	window.show();
	            	} else {
	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}  
	            }*/
	        	click: this.openUserSendMessage
	        },
	        
	        /*'sendmessagewindow[itemId=userSendMessageWindow] button#adhocMsgSubmitBtn': {
	        	click: function(button) {
	        		var grid = this.getSearchResultGrid();
	        		button.up('window').sendMessage(button,grid);
    			}
	        },*/
	         
	        'useracademylocation customcombobox#academy_name': {
	        	select: function(obj, record) {
                	var $this=this;
                	var form = obj.up('form').getForm();
                	var whetherPrimeryField = form.findField('whetherPrimary');
                	if(!isNullOrEmpty(record[0].data.ownership)) {
                		whetherPrimeryField.setDisabled(true);
                	} else {
                		whetherPrimeryField.setDisabled(false);
                	}
                }
	        },
	       /* 'sendmessagewindow[itemId=userSendMessageWindow] combo#selectTemplate': {
	        	render: function(combo) {
	        		var store = combo.getStore();
	        		var msgRecipientTypeId = combo.up('window').down('#msgRecipientTypeItemId').getValue();
	        		 store.on('beforeload', function(store, operation) {
	                     store.proxy.extraParams = {
	                    		 msgRecipientTypeId :msgRecipientTypeId
	                     };
	                 });
    			},
    			select :function(combo,records){
    				var msgCategoryId = combo.up('window').down('#msgCategoryId');
    				var msgSubCategoryId = combo.up('window').down('#msgSubCategoryId');
    				msgCategoryId.setValue(records[0].data.msgCategoryId);
    				msgSubCategoryId.setValue(records[0].data.msgSubCategoryId);
    			}
	        },*/
	        
	        
            'adminresetpasswordwindow[itemId=userlistadminresetpasswordwindow] ': {
                beforerender: function(formWindow) {
                	var form = formWindow.down('form');
					var randomPassword=form.down("#passwordTypeItemId");
                	randomPassword.setVisible(false);
        	    	this.getController('Academia.controller.authentication.AuthenticationController').getPasswordPolicy(form);
                }
            },
           
			'adminresetpasswordwindow[itemId=userlistadminresetpasswordwindow] form #resetPassword' :{ 
				blur:this.getController('Academia.controller.authentication.AuthenticationController').checkPasswordValidity
			 },
			
			'adminresetpasswordwindow[itemId=userlistadminresetpasswordwindow] button[itemId=submitBtn]':{
	        	click:function(obj){
	        		 this.changePasswordByAdmin(obj);
	        	}
	        },
	        'adminresetpasswordwindow[itemId=userlistadminresetpasswordwindow] button[itemId=cancelBtn]':{
	        	click:function(obj){
	        		 obj.up('window').close();
	        	}
	        }
	        /*,
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=searchResultGridBtnExportExcel]': {
	            click: function() {
	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=searchResultGridBtnExportPdf]': {
	            click: function() {
	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
	            }
	        }*/,
	        'userbasicdetails':{
	        	afterrender : function(obj){			        	
		        	var associatedAcadLocationIds = new Array();
			        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getUSER_MANAGEMENT_PERMISSIONS());
			        var form = this.getContentPanelActiveTab()
			        var empIcon =form.down('#profile_image_icon');
			        empIcon.setVisible(false)
			        permissionList.forEach(function(btnName){
			            if(btnName == 'UPLOAD_IMAGE_EDIT_ICON_TO_USER'){
			            	empIcon.setVisible(true);
			            }
			        });
			        
		            var a = this.getWinUserBasicDetails();
		            var form =a.getForm();
		            field =form.findField("whetherInternal");
		            field.setValue(true);
		            this.managedFieldByDataSetting(obj);
		            },
				 render:function(obj){
					 this.getStore('user.AccountTypeStore').load();
				 },	
	        
			 },
			 'userbasicdetails customcombobox[itemId=mobileCountryCode]': {
                 select: function(rowModel, record) {
                 	var this$ = this;
                 	var form = this$.getUserBasicDetails();
                 	var countryCodeField = form.down("#mobileCountryCode");
                  	var mobileField = form.down("#mobileNumber");
                  	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                 }
                },
                'userbasicdetails numberfield[itemId=mobileNumber]': {
        			change: function(record){
        				var this$ = this;
                    	var form = this$.getUserBasicDetails();
                       var mobileField = form.down("#mobileNumber");
                    	mobileField.isValid();
            			form.getForm().checkValidity();
                    }
        		},
            'userbasicdetails filefield#photoFileImage[itemId=photoFileImage]': {
                change: function(formValue, value, eOpts) {
                	/*value = value.split(' ').join('_');
                	console.log('value ',value );
                	formValue.setRawValue(value);
                    this.saveUserPhotoUpload(formValue);*/
                	
                	var $this = this;
    				value = value.replace('C:\\fakepath\\', '');
    				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
    				formValue.setRawValue(newValue);
    				
    				var formPnl = $this.getWinUserBasicDetails();
    				var profile_image = formPnl.down('#profile_image');

    				var file = formValue.fileInputEl.dom.files[0];
    				var reader = new FileReader();
    				reader.addEventListener('load', function(evt) {
    					profile_image.setSrc(evt.target.result);
    				});
    				reader.readAsDataURL(file);
    				//formPnl.down('#photoUrlItemId').setValue(null);
                }
            },
            'userbasicdetails textfield[itemId=firstName]': {
                blur: this.setPrintNameValue
            },
            'userbasicdetails textfield[itemId=lastName]': {
                blur: this.setPrintNameValue
            },
            'userbasicdetails textfield[itemId=middleName]': {
                blur: this.setPrintNameValue
            },
            'userbasicdetails textfield[itemId=firstNameOtherLnguageId]': {
                blur: this.setPrintNameValueOther
            },
            'userbasicdetails textfield[itemId=lastNameOtherLnguageId]': {
                blur: this.setPrintNameValueOther
            },
            'userbasicdetails textfield[itemId=middleNameOtherLnguageId]': {
                blur: this.setPrintNameValueOther
            },
	        /** 
	         * Basic user details save
	         */
	        'userbasicdetails button#submitBtn':{
	        	 click: function() {
	        		 this.saveUpdateUser(this); 
	        	 }
	        },
	        'userbasicdetails button#cancelBtn':{
	        	 click: function() {
	        		 this.cancelUpdateUser(this); 
	        	 }
	        },
	        
	        'userbasicdetails datefield[itemId=birthDateItemId]':{
	        	 change: function() {
	        		
	        	   var frm = this.getUserBasicDetails();
	        	   var birthDate = frm.down('#birthDateItemId');
	  			   var dateOfJoining = frm.down('#dateOfJoining').setDisabled(false);
	  			   var dateOfExit = frm.down('#dateOfExit').setDisabled(false);
	  			   if(!isNullOrEmpty(birthDate.getValue())){
	  				   var getBirthYear =birthDate.getValue().getFullYear(); 
	  				   var joinDate = new Date(birthDate.getValue());
	  				   joinDate.setFullYear(getBirthYear + 18);
	  				   dateOfJoining.setMinValue(joinDate);
	  				    dateOfJoining.validate();
	  				
	        	 }
	        	 }
	        },
	        /** User access tree
	         */
	        /**
	         * On ender of access right tree.
	         */
	        'accessrighttree' : {
	        	render : function(grid) {
	        		this.disableUserAccessRightsPivileges(grid, this.getUSER_ACCESS_RIGHTS_PERMISSIONS())
					this.renderAccessRightTree(grid);
					/**
                     * This function is used to hide button menu while scrolling.
                     */
					this.hideButtonMenuWhileScrolling(grid);	
				}, 
				afterrender : function(grid) {
					var $this = this;
					var moreAddButton=grid.down('#btnAddPermissions');
					var moreAddAcadLocButton=grid.down('#btnAddAcademyLocation');
					var moreUnassignButton=grid.down('#btnUnassign');
					var grid=$this.getSearchResultGrid();
					 if (!isNullOrEmpty(grid) && grid.getSelectionModel().getCount() > 0) {
						var record = grid.getSelectionModel().getSelection()[0];
						var CODE = record.raw.CODE;
						if(CODE=="SYSADMIN") {
							moreAddButton.setDisabled(true);
							moreAddAcadLocButton.setDisabled(true);
							moreUnassignButton.setDisabled(true);
						}
					}
				},
				 select: function(rowSelect){
					 this.doEnableDisableRoleLink(rowSelect);
				 }
	        },
	        /**
	         * Add Edit of access right tree for assigning academy location to user.
	         */
	        'accessrighttree #add_academyLocation': {
	            click: this.showAcademyLocationForm
	        },
	        'accessrighttree #edit_academyLocation': {
	            click: this.editAcademyLocationForm
	        },
	       
	        
			'useracademylocation form button[itemId=saveAcademyLocation]':{
	            click: this.assignAcademyLocation
			},
			'useracademylocation form button[itemId=cancelBtn]':{
	            click: function(obj){
	            	this.getUserAcademyLocation().close();
	            }
			},
			 /**
	         * Add Edit of access right tree for assigning role to user_academy_location.
	         */
	        'accessrighttree  #add_acad_loc_role': {
	            click: function(obj, record) { 
	            	this.showRoleForm('ADD');
	            }
	        },
	        'accessrighttree #edit_acad_loc_role': {
	            click:this.editRoleForm
	        },
	        'assignroleformwindow  button#btnSaveRoleId':{
		    	   click: this.assignAcademyLocation_role
	        },	 
	        'assignroleformwindow  button#cancelBtn':{
		    	   click: function(){
		    		   this.getAssignRole().close();		   
		    	}
	        },	 
	        'accessrighttree #edit_programCourse': {
	            click: this.assignProgram
	        },
	        ' assignprogramwindow #programTypeSelector':{
	        	change:this.toggleProgramCourseTree
	        },
	        'assignprogramwindow #btnSaveProgramCourses':{
	        	click:this.assignProgramCourses
	        },
	       
		    /**
		     * Un assign academy location and role
		     */   
	        'accessrighttree #unassign_academyLocation': {
	            click:this.unassignAcademyLocation
	        },
	        'accessrighttree #unassign_acad_loc_role': {
	            click:this.unassignAcademyLocation_role
	        },
	        
	        /**
	         * Show privilege grid popup
	         */
	       'accessrighttree  #edit_privilege': {
	    	   click: this.showPrivilegeForm
	        },
	        'userPrivilegeGridWindow grid[itemId=userPrivilegeGrid] button#btnSavePrivilege': {
		    	   click: this.saveOveridePrevilege
	        },
	        
	        /**
	         * Privilege grid filter combo
	         */
	        'userPrivilegeGridWindow grid[itemId=userPrivilegeGrid] combo[itemId=comboPortal]': {
	        	render : function(combo){
	        		this.loadPortalStore(this.getPortals());
	        	},
                select: function(combo, records, eOpts) {
                    this.loadPortalCombo(combo, records);
                }
            },
            'userPrivilegeGridWindow grid #comboModule': {
                select: function(combo, records, eOpts) {
                    this.loadModuleCombo(combo, records);
                }
            },
            'quicksearch combo[itemId=academyLocationCombo]': {
                render: function(combo) {
                    this.loadAcadLocCombo(combo);
                },
                select: function(combo) {
                    this.disableUsersWithoutALCheckbox(combo);
                }
            },
            'quicksearch checkbox[itemId=users_without_AL]': {
                change: function(me, newValue, oldValue, eOpts) {
                    this.disableAcademyLocationCombo(me, newValue, oldValue, eOpts);
                }
            },
            'quicksearch button[itemId=cancelButtonId]': {
            	click: function(me){
            		this.resetFields(me);
            	}
            },
            'quicksearch combo[itemId=cmbDepartment]' : {
	        	  select: function(obj, record) {
	        		    this.getUserEnableSubDepartment(record[0].get("id"));
	        	  }
	        },

            'userPrivilegeGridWindow grid #comboSubModule': {
                select: function(combo, records, eOpts) {
                    this.loadSubModuleCombo(combo, records);
                }
            },
            'userPrivilegeGridWindow grid  #btnResetFilter': {
                click: function(button) {
                    this.resetFilter(button);
                }
            },
            'userPrivilegeGridWindow #btnSearchPrivilege':{
            	click: function(button) {
            		this.searchUserRolePrivleges(button);
            	 }
            },

	        
	        'userbasicdetails combo#departmentId' : {
	        	  select: function(obj, record) {
	        		    this.enableSubDepartment(record[0].get("id"));
	        	  }
	        },
	       	        
	        'userbasicdetails nestedJsonCombo#userGroupType' : {
	        	  select: function(obj, record) {
	        		    var userGroupName = record[0].get("userGroupName");
	        		    this.hideOrShowWeatherFaculty(userGroupName);
	        	  }
	        },
	        
	        'useracademylocation form combo#academy_name':{
	        	render: function(combo){
	        		this.loadAcadLocComboByUser(combo);
	        	},
	        	 select: function(obj, record) {
		    		var newValue = record[0].get("id");
		    		var academyNameComboStore= this.getUserAcademyLocation().down("#academy_name").getStore();
		    		var record=academyNameComboStore.getById(newValue);
	        		
	        		 var startDate=this.getUserAcademyLocation().down("#startDate");
	        		 startDate.setMinValue(dateRender(record.data.academy.startDate));
	        		 startDate.setMaxValue(dateRender(record.data.academy.tillDate));
	        		 
	        		 var tillDate=this.getUserAcademyLocation().down("#tillDate");
	        		 tillDate.setMinValue(dateRender(record.data.academy.startDate));
	        		 tillDate.setMaxValue(dateRender(record.data.academy.tillDate));
//	        		 this.enableLocationCombo(newValue);
	        	 }
	        },
	        'userpasswordpolicy button#submitBtn':{
	    		click:this.savePasswordPolicy
	    	},
	    	'userpasswordpolicy button#clearSearch':{
	    		click:function(btn) {
	    			var form = btn.up('form').getForm();
	    			form.reset();
	    			form.findField('whetherPasswordExpires').setValue(false);
	    			form.findField('whetherTemporaryLock').setValue(false);
	    		}
	    	},
	    	'userpasswordpolicy':{
	    		render:this.loadPasswordPolicy
	    	},
	        'searchresultgrid[itemId=userSearchresultgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	            }
	        }, 
	        'userquicksearch grid[itemId=userSearchresultgrid]': {
	        	selectionchange: function(column, selected) {
	        		var searchResultGrid = this.getSearchResultGrid();
	        		var resetButtonItemId = searchResultGrid.down('#resetButtonItemId');
	        		var activateUserBtn = searchResultGrid.down('#activateButtonItemId');
	        		
	        		//this.disableMoreActionPivileges(searchResultGrid,this.getUSER_MANAGEMENT_PERMISSIONS());
	        		var associatedAcadLocationIds = new Array();
	        		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	        		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getUSER_MANAGEMENT_PERMISSIONS());

	        		var isEditPermissionApply = false;
	        		var isDeletePermissionApply = false;
	        		var isEnableDisablePermissionApply = false;
	        		var isMakeActive = false;
	        		Ext.each(permissionList, function(privilege) {
	        			if (privilege === 'UPDATE') {
	        				isEditPermissionApply = true;
	        			}
	        			if (privilege === 'DELETE') {
	        				isDeletePermissionApply = true;
	        			}
	        			if (privilege === 'MAKE_ACTIVE') {
	        				isEnableDisablePermissionApply = true;
	        			}
	        		});
	        		
	        		/*if(selected.length>0){
	        			for(var i in selected){
	        				if(selected[i].data.STATUS=='Active'){
	        					isMakeActive = true;
	        					break;
	        				}
	        			}
	        			if(isMakeActive){
	        				searchResultGrid.down('#enableDisableBtn').setDisabled(true);
	        			}
	        			else{
	        				searchResultGrid.down('#enableDisableBtn').setDisabled(false);
	        			}
	        		}
	        		
	        		/*To fix this id bug: V2D-490616: Start*/
					    var makeActive = searchResultGrid.down('#enableDisableBtn');
					    var searchResultGridBtnEdit = searchResultGrid.down('#searchResultGridBtnEdit');

					    if (selected.length > 0 && selected[0] && selected[0].raw) { 
					        if (selected[0].raw.USER_LIST_STATUS === 'Active') {
					            makeActive.setDisabled(true);
					            searchResultGridBtnEdit.setDisabled(false);
					        } else {
					            makeActive.setDisabled(false);
					            searchResultGridBtnEdit.setDisabled(true);
					        }
					    }
					    else{
					    	makeActive.setDisabled(true);
					    	searchResultGridBtnEdit.setDisabled(true);
					    }
					/*To fix this id bug: V2D-490616: End*/
					    
	        		var selectAllCheck = searchResultGrid.headerCt.columnManager.columns[0].el.hasCls(Ext.baseCSSPrefix + 'grid-hd-checker-on');
	        		if(selectAllCheck){
	        			searchResultGrid.down('#selectSimilarRecords').setDisabled(false);
	        			searchResultGrid.config.isSimilar = true;
	        		}else{
	        			searchResultGrid.down('#selectSimilarRecords').setDisabled(true);
	        			searchResultGrid.config.isSimilar = false;
	        		}
	        		if(selected.length== 1){ 
	        			var wehtherDeletedValue = selected[0].get('WHETHER_DELETED');
	        			if (wehtherDeletedValue == "Active") {
	        				/*if (isEditPermissionApply) {
	        					searchResultGrid.down('#searchResultGridBtnEdit').setVisible(false);
	        				}*/
	        				if (isDeletePermissionApply) {
	        					searchResultGrid.down('#searchResultGridBtnDelete').setVisible(false);
	        				}
	        			} else {
	        				/*if (isEditPermissionApply) {
	        					searchResultGrid.down('#searchResultGridBtnEdit').setVisible(true);
	        				}*/
	        				if (isDeletePermissionApply) {
	        					searchResultGrid.down('#searchResultGridBtnDelete').setVisible(true);
	        				}
	        			}
	        			var activateUserStatus = selected[0].get('STATUS');

	        			if(activateUserStatus == "Inactive"){
	        				//searchResultGrid.down('#searchResultGridBtnEdit').setDisabled(true);
		        			searchResultGrid.down('#searchResultGridBtnView').setDisabled(true);
		        			searchResultGrid.down('#searchResultGridBtnDelete').setDisabled(true);
		        			//searchResultGrid.down('#enableDisableBtn').setDisabled(false);
	        			}else{	
//	        			resetButtonItemId.setDisabled(false);
	        			//searchResultGrid.down('#searchResultGridBtnEdit').setDisabled(false);
	        			searchResultGrid.down('#searchResultGridBtnView').setDisabled(false);
	        			searchResultGrid.down('#searchResultGridBtnDelete').setDisabled(false);
	        			//searchResultGrid.down('#enableDisableBtn').setDisabled(true);
	        			}
	        		}else{
//	        			resetButtonItemId.setDisabled(true);
//	        			activateUserBtn.setDisabled(true);
	        			/*searchResultGrid.down('#searchResultGridBtnEdit').setVisible(true);
	        			searchResultGrid.down('#searchResultGridBtnDelete').setVisible(true);*/
	        			searchResultGrid.down('#searchResultGridBtnEdit').setDisabled(true);
	        			searchResultGrid.down('#searchResultGridBtnView').setDisabled(true);
	        			searchResultGrid.down('#searchResultGridBtnDelete').setDisabled(true);
	        			/*if (isEditPermissionApply) {
        					searchResultGrid.down('#searchResultGridBtnEdit').setVisible(true);
        				}*/
        				if (isDeletePermissionApply) {
        					searchResultGrid.down('#searchResultGridBtnDelete').setVisible(true);
        				}
	        		}
	        	}
	        },
	        
	        'userquicksearch': {
	        	afterrender: function(structure) {
	        		var grid = structure.down('#userSearchresultgrid');
	        	    this.getCBGridHeaderFreeze(grid,structure);
	        	}
	        },

 		   'useruploadform button[itemId=uploadId]':{
 			   click:function(obj){
 				   var $this=this;
 				   var importWin=obj.up('useruploadform');
 				   var grdStore;
 				   var form=obj.up('useruploadform');
 				   submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
 				   $this.getHashOfFile(form);
 				   setTimeout(function() {
	 				   form.getForm().submit({
	 					   method : 'POST',
	 					   url : submitUrl,
	 					   success : function(form, action){
	 						   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 					   },
	 					   failure: function(form, action) {
  		   					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	 					   }
	 				   });
 				   },1000);

 				   Ext.defer(function() {
 					   var grid = $this.getImportListUsers();
 					   var form  = $this.getUploadoptionradiogroup();
 					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
 					  $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_USERS_UPLOAD');
 				   }, 2000, this);
 			   }  
 		   },

 		   'useruploadform button[itemId=resetBtn]':{
 			   click:function(obj){
 				   var $this = this;
 				   var form =obj.up('useruploadform').getForm();
 				   form.findField('file').reset();
 				   var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
 				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
 					   isUploadAll: false
 				   });
 				   form.isValid();
 			   },
 			   render :function(obj){
 				   var $this = this;
 				   var form =obj.up('useruploadform').getForm();
 				   var combo = form.findField('importUtilityMasterId');
 				   combo.getStore().load({
 					   callback: function(records, operation, success) {
 						   for(var i in records){
 							   if(records[i].data.value=='Bulk Users'){
 								   combo.setValue(records[i].data.id);
 								   combo.setReadOnly(true);
 							   }
 						   }
 					   }	   
 				   });
 			   }  
 		   },
 		   'useruploadform uploadoptionradiogroup[itemId=userListUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
 			   change: function( radioGroup, newValue, oldValue, eOpts){
 				   var grid =this.getImportListUsers();
 				   var form  = this.getUploadoptionradiogroup();
 				   var isUploadAll = newValue.isUploadAll;
 				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_USERS_UPLOAD');
 			   }   
 		   },
 		   'userdownloadform button[itemId=resetBtn]':{
 			   click:function(obj){
 				   var $this = this;
 				   var form =obj.up('userdownloadform').getForm();
 				   form.reset();
 			   }  
 		   },

 		   'userdownloadform button[itemId=downoladBtnId]':{
 			   click:function(obj){
 				   var $this = this;
 				   var form =obj.up('userdownloadform').getForm();
 				   var value = form.getValues();
 				   var csvForm = Ext.create('Ext.form.Panel'); 
 				   csvForm.getForm().submit({
 					   target: '_blank',
 					   method:'POST',
 					   params :{
 						   access_token : Ext.Ajax.defaultHeaders.access_token
 					   },
 					   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 					   url: SERVERURL.DOWNLOAD_USER_TEMPLATE_URL,
 					   standardSubmit :true
 				   });
 			   }  
 		   },
	        'useruploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
 			   change: this.userDownloadUploadFormChange
 		   },
 		  'importlistusers':{
			   render:function(obj){
				   var $this = this;
				   var grid = $this.getImportListUsers();
				   var form  = $this.getUploadoptionradiogroup();
				   var isUploadAll = form.items.items[0].getValue().isUploadAll;
				   $this.onChangeUploadOptionRadioGroup(isUploadAll,grid ,'IMPORT_BULK_USERS_UPLOAD');
			   },
			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   if (e.target.tagName == 'A') {
					   var fileType=null;
					   if(cellIndex==1){
						   fileType='successFile';
					   }else if(cellIndex==6){
						   fileType='errorFile';
					   }else if(cellIndex==7){
						   fileType='logFile';
					   }
					   var documentId = record.get("id");
					   if (!isNullOrEmpty(documentId)) {
						   this.getUserDownloadFile(documentId,fileType);
					   }
				   }
			   }
		   },
		   'importlistusers button[itemId=btnForce]':{
			   click: function(obj) {
				   var grid = this.getImportListUsers();
				   if (grid.getSelectionModel().getCount() > 0) {
					   if(grid.getSelectionModel().getCount() > 1){
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
					   }else{
						   var this$ = this;
						   var id = grid.getSelectionModel().selectionStart.data.id;
						   console.log(id);
						   var urlAppend="?jobName="+id;
						   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
						   Ext.Ajax.request({
							   url: submitURL,
							   method: 'GET',
							   success: function(response) {
								   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
								   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
									   //console.log("Manual trigger hit");
									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
								   }else if(response.responseText==="SUCCESS"){
									   //console.log("Manual trigger hit");
									   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
									   grid.getStore().reload();
								   }
							   }
						   });
					   }
				   } else {
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }  
			   }
		   },
		   
//		   'userbasicdetails combo#departmentId' : {
//	        	  select: function(obj, record) {
			 'userbasicdetails textfield[itemId=code]': {
		         blur : function(obj){
		         	var this$ = this;
		         	var userProfile = this$.getContentPanelActiveTab();
		         	//var userBasicDetailsForm = userProfile.down('#winUserBasicDetails');
		         	var userBasicDetailsForm = this$.getWinUserBasicDetails();
		         	var idVal = userBasicDetailsForm.down('[name=id]').getValue();
		         	var oldValue = "";
		         	if (!isNullOrEmpty(idVal) && Ext.isDefined(userBasicDetailsForm.getForm().getUserCode())) {
		         		oldValue = userBasicDetailsForm.getForm().getUserCode();
		         	}
		         	
		         	//var newValue = Ext.ComponentQuery.query('textfield[itemId=code]')[0];
		         	var newValue = userProfile.down('#code').getValue();
		         	if(!isNullOrEmpty(newValue)){
		         		if(!isNullOrEmpty(newValue)){
		             		if(newValue !=oldValue){
		             			var editUrl = SERVERURL.USER_UNIQUE_CHECK;
			                    	Ext.Ajax.request({
			                    		method: "GET",
			                    		type: 'rest',
			                    		url: editUrl,
			                    		params: {
			                    			code: newValue
			                    		},
			                    		success: function(response, action) {
			                    			var resp = Ext.JSON.decode(response.responseText);
			                    			if(resp==false){
			                    				Ext.ComponentQuery.query('textfield[itemId=code]')[0].setValue(oldValue);
			                    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_ID_UNIQUE_ERROR_MSG'));
			                    			}
			                    		}
			                    	})
		             		}
		         		} else if (!isNullOrEmpty(idVal)) {
		         			Ext.ComponentQuery.query('textfield[itemId=code]')[0].setValue(oldValue);
		         			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STAFF_ID_UNIQUE_ERROR_MSG'));
		         		}
		         	}
		         }
		     
		   },
		   'userroleuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
 			   change: this.userRoleDownloadUploadFormChange
		   },
		   'userroledownloadform multiselectcombofield[itemId=academyLocationId]':{
	 			render:function(obj,rec){
       			var store = obj.getStore();
       			store.load({
						callback: function(records, operation, success) {
							if (success) {
								var allAl =[];
								for(var i in records){
									allAl.push(records[i].get("id"));
								}
								obj.setValue(allAl);
							}
						}
					});
       			
	 			}
	 		},
	 		'userroledownloadform button[itemId=resetBtn]':{
	 			click:function(obj){
 				   var $this = this;
 				   var form =obj.up('userroledownloadform').getForm();
 				   form.reset();
	 			}  
	 		},
	 		'userroledownloadform button[itemId=downoladBtnId]':{
	 			click:function(obj){
	 				var $this = this;
	 				var form =obj.up('userroledownloadform').getForm();
	 				var csvForm = Ext.create('Ext.form.Panel'); 
	 				
	 		    	var academyLocationStr;
	 		    	var values = form.getValues();
	 		    	var aL = values.academyLocation;
	 		    	var userWithoutAL = values.USER_WITHOUT_AL;
	 		    	var prefillUserIdName = values.prefillUserIdName;
	 		    	if(values.prefillUserIdName !=undefined){
	 		    		prefillUserIdName=true;
	 		    	}else{
	 		    		prefillUserIdName=false;
	 		    	}
	 		    	if(!userWithoutAL)
	 		    		userWithoutAL = false;
	 		    	
	 		    	var alArray=[];

	 		    	if(aL !=undefined && aL.length > 0) {
	 		    		for(var i in aL) {
	 		    			if(Ext.isObject(aL[0])) {
	 		    				alArray.push(aL[i].get("id"));
	 		    			} else {
	 		    				alArray.push(aL[i]);
	 		    			}
	 		    		}
	 		    		academyLocationStr= alArray.join();
	 		    	} else {
	 		    		academyLocationStr = null;
	 		    	}
	 				csvForm.getForm().submit({
	 					target: '_blank',
	 					method:'POST',
	 					params :{
	 						access_token : Ext.Ajax.defaultHeaders.access_token,
	 						academyLocationIds : academyLocationStr,
	 						withoutAl : userWithoutAL,
	 						prefillUserIdName:prefillUserIdName
	 					},
	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	 					url: SERVERURL.DOWNLOAD_TEMPLATE_USER_ROLE,
	 					standardSubmit :true
	 				});
	 			}  
	 		},
	 		'userroleuploadform uploadoptionradiogroup[itemId= userRoleListUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	 			change: function( radioGroup, newValue, oldValue, eOpts){
	 				var grid = this.getImportListUserRole();
	 				var form  = this.getUserRoleuploadoptionradiogroup();
	 				var isUploadAll = newValue.isUploadAll;
	 				this.onChangeUploadOptionRadioGroup(isUploadAll,grid ,'IMPORT_BULK_USER_ROLE');
	 			}
	 		},
	 		'userroleuploadform button[itemId=uploadId]':{
	 			   click:function(obj){
	 				   var $this=this;
	 				   var importWin=obj.up('userroleuploadform');
	 				   var grdStore;
	 				   var form=obj.up('userroleuploadform');
	 				   submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	 				   $this.getHashOfFile(form);
	 				   setTimeout(function() {
		 				   form.getForm().submit({
		 					   method : 'POST',
		 					   url : submitUrl,
		 					   success : function(form, action){
		 						   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		 					   },
		 					   failure: function(form, action) {
	   		   					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		 					   }
		 				   });
	 				   },1000);

	 				   Ext.defer(function() {
	 					   var grid = $this.getImportListUserRole();
	 					   var form  = $this.getUserRoleuploadoptionradiogroup();
	 					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
	 					   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_USER_ROLE');

	 					   var uploadedBy = null;
	 					   if(!isUploadAll){
	 						   uploadedBy = $this.getCurrentlyLoggedInUser().id;
	 					   }
	 					   grid.getStore().getProxy().extraParams = {
	 						   moduleName:'IMPORT_BULK_USER_ROLE',
	 						   uploadedBy:uploadedBy
	 					   };
	 					   grid.getStore().load();
	 				   }, 2000, this);
	 			   }  
	 		   },
	 		   'userroleuploadform button[itemId=resetBtn]':{
	 			   click:function(obj){
	 				   var $this = this;
	 				   var form =obj.up('userroleuploadform').getForm();
	 				   form.findField('file').reset();
	 				   var uploadoptionradiogroupform  = $this.getUserRoleuploadoptionradiogroup();
	 				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	 					   isUploadAll: false
	 				   });
	 				   form.isValid();
	 			   },
	 			   render :function(obj){
	 				   var $this = this;
	 				   var form =obj.up('userroleuploadform').getForm();
	 				   var combo = form.findField('importUtilityMasterId');
	 				   combo.getStore().load({
	 					   callback: function(records, operation, success) {
	 						   for(var i in records){
	 							   if(records[i].data.value=='Bulk User Role'){
	 								   combo.setValue(records[i].data.id);
	 								   combo.setReadOnly(true);
	 							   }
	 						   }
	 					   }	   
	 				   });
	 			   }  
	 		   },
 	 		  'importlistuserrole':{
				   render:function(obj){
					   var $this = this;
					   var grid = $this.getImportListUserRole();
					   var form  = $this.getUserRoleuploadoptionradiogroup();
					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
 					   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_USER_ROLE');
				   },
				   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					   if (e.target.tagName == 'A') {
						   var fileType=null;
						   if(cellIndex==1){
							   fileType='successFile';
						   }else if(cellIndex==6){
							   fileType='errorFile';
						   }else if(cellIndex==7){
							   fileType='logFile';
						   }
						   var documentId = record.get("id");
						   if (!isNullOrEmpty(documentId)) {
							   this.getUserRoleDownloadFile(documentId,fileType);
						   }
					   }
				   }
			   },
			   'importlistuserrole button[itemId=btnForce]':{
				   click: function(obj) {
					   var grid = this.getImportListUserRole();
					   if (grid.getSelectionModel().getCount() > 0) {
						   if(grid.getSelectionModel().getCount() > 1){
							   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
						   }else{
							   var this$ = this;
							   var id = grid.getSelectionModel().selectionStart.data.id;
							   console.log(id);
							   var urlAppend="?jobName="+id;
							   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
							   Ext.Ajax.request({
								   url: submitURL,
								   method: 'GET',
								   success: function(response) {
									   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
										   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
									   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
										   //console.log("Manual trigger hit");
										   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
									   }else if(response.responseText==="SUCCESS"){
										   //console.log("Manual trigger hit");
										   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
										   grid.getStore().reload();
									   }
								   }
							   });
						   }
					   } else {
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					   }  
				   }
			   },
			   'userroledownloadform checkbox[itemId=users_without_AL]': {
	               change: function(me, newValue, oldValue, eOpts) {
	                   this.disableAcademyLocationMultiSelect(me, newValue, oldValue, eOpts);
	               }
	           },
	           'userroledownloadform combo[itemId=academyLocationId]': {
	               change: function(me, newValue, oldValue, eOpts) {
	            	   var downoladBtnId = me.up().down("#downoladBtnId");
	            	   var form = me.up('userroledownloadform').getForm();
	            	   var values = form.getValues();
	            	   var aL = values.academyLocation;
	            	   if(aL !=undefined && aL.length > 0){
	            		   downoladBtnId.setDisabled(false);
	            	   } else {
	            		   downoladBtnId.setDisabled(true);
	            	   }
               		}
	           },
	           'criteriacreator' :{
	        	   render:function(structure){
	        		   this.disableUserImportUtility(structure, this.getUSER_MANAGEMENT_PERMISSIONS());
	        	   }
	           },
	           'userbasicdetails checkbox[itemId=isTimesheetRequired]': {
	               change: function(me, newValue, oldValue, eOpts) {
	                   this.approvalDroolSelection(me, newValue, oldValue, eOpts);
	               }
	           },
	           'userbasicdetails checkbox[itemId=whetherFacultyId]': {
	               change: function(me, newValue, oldValue, eOpts) {
	            	   var form = me.up('userbasicdetails');
	            	   var userId = form.getValues().id;
	            	   if(newValue == false && !isNullOrEmpty(userId)) {
	            		   Ext.Ajax.request({
	   	   		            method: "GET",
	   	   		            type: 'rest',
	   	   		            url:SERVERURL.PATH_FIND_ROLES_BY_USER_ID,
	   	   			        params: {
	   	   			        	userId: userId
	   	   			        },
	   	   		            success: function(response) {
	   	   		            	var records = Ext.decode(response.responseText);
	   	   		            	if(!isNullOrEmpty(records)) {
	   	   		            		for(var i in records) {
	   	   		            			if(records[i].roles == 'FACULTY') {
	   	   		            			me.setValue(oldValue);
	   	   		            		    showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ROLE_IS_ALREADY_ASSIGNED_MSG'));
	   	   		            			break;
	   	   		            			}
	   	   		            		}
	   	   		            	}
	   	   		            }
	   	   		        });
	            	   }
	               }
	           },
	           
	           /* User Update Loader : Start*/
	           'userupdateuploaddownloadstructure radiogroup[itemId=importDownloadUploadRadioGroupItemId]': {
	        		change: this.userUpdateDownloadUploadFormChange
	        	},
	        	'userupdatedownloadform button[itemId=resetBtnItemId]': {
	        		click: function(obj) {
	        			var $this = this;
	        			var form = obj.up('userupdatedownloadform');
	        			form.getForm().reset();
	        	    	form.down("#userWithoutALItemId").setDisabled(false);
	        		}
	        	},
	        	'userupdatedownloadform button[itemId=downoladBtnId]': {
	        		click: function(obj) {
	        			var $this = this;
	        			var form = obj.up('userupdatedownloadform');
	        			
	        			var userId = form.down('#userItemId').getValue();
	        			var userNameId = form.down('#userNameItemId').getValue();
	        			var whetherInternal = form.down('#whetherInternalItemId').getValue();
	        			var userGroupId = form.down('#userGroupItemId').getValue();
	        			var roleId = form.down('#roleItemId').getValue();
	        			var departmentId = form.down('#departmentItemId').getValue();
	        			var gender = form.down('#genderItemId').getValue();
	        			var academyLocationId = form.down('#academyLocationItemId').getValue();
	        			var userWithoutAL = form.down('#userWithoutALItemId').getValue();
	        			
	        			var csvForm = Ext.create('Ext.form.Panel');
	        			csvForm.getForm().submit({
	        				target: '_blank',
	        				method: 'POST',
	        				params: {
	        					access_token: Ext.Ajax.defaultHeaders.access_token,
	        					userId: userId,
	        					userNameId: userNameId,
	        					whetherInternal: whetherInternal,
	        					userGroupId: userGroupId,
	        					roleId: roleId,
	        					departmentId: departmentId,
	        					gender: gender,
	        					academyLocationId: academyLocationId,
	        					userWithoutAL: userWithoutAL
	        				},
	        				headers: {
	        					'Authorization': Ext.Ajax.defaultHeaders.Authorization
	        				},
	        				url: SERVERURL.DOWNLOAD_TEMPLATE_USER_UPDATE,
	        				standardSubmit: true
	        			});
	        		}
	        	},
	        	'userupdateuploadform button[itemId=uploadId]': {
	        		click: function(obj) {
	        			var $this = this;
	        			var importWin = obj.up('userupdateuploadform');
	        			var grdStore;
	        			var form = obj.up('userupdateuploadform');
	        			submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	        	$this.getHashOfFile(form);
			        	setTimeout(function() {
		        			form.getForm().submit({
		        				method: 'POST',
		        				url: submitUrl,
		        				success: function(form, action) {
		        					importWin.getForm().isValid();
		        					showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
		        				},
		        				failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		        				}
		        			});
			        	},1000);

	        			Ext.defer(function() {
	        				var grid = $this.getImportuserupdategrid();
	        				var form = $this.getUserupdateuploadoptionradiogroup();
	        				var isUploadAll = form.items.items[0].getValue().isUploadAll;
	        				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'IMPORT_BULK_USER_UPDATE');
	        			}, 2000, this);
	        		}
	        	},
	        	'userupdateuploadform button[itemId=resetBtn]': {
	        		click: function(obj) {
	        			var $this = this;
	        			var form = obj.up('userupdateuploadform').getForm();
	        			form.findField('file').reset();
	        			var uploadoptionradiogroupform = $this.getUserupdateuploadoptionradiogroup();
	        			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	        				isUploadAll: false
	        			});
	        			form.isValid();
	        		},
	        		render: function(obj) {
	        			var $this = this;
	        			var form = obj.up('userupdateuploadform').getForm();
	        			var combo = form.findField('importUtilityMasterId');
	        			combo.getStore().load({
	        				callback: function(records, operation, success) {
	        					for (var i in records) {
	        						if (records[i].data.value == 'Bulk User Update') {
	        							combo.setValue(records[i].data.id);
	        							combo.setReadOnly(true);
	        						}
	        					}
	        				}
	        			});
	        		}
	        	},
	        	'userupdateuploadform uploadoptionradiogroup[itemId=userUpdateUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]': {
	        		change: function(radioGroup, newValue, oldValue, eOpts) {
	        			var grid = this.getImportuserupdategrid();
	        			var isUploadAll = newValue.isUploadAll;
	        			this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'IMPORT_BULK_USER_UPDATE');
	        		}
	        	},
	        	'importuserupdategrid': {
	        		render: function(obj) {
	        			var $this = this;
	        			var grid = $this.getImportuserupdategrid();
	        			var form = $this.getUserupdateuploadoptionradiogroup();
	        			var isUploadAll = form.items.items[0].getValue().isUploadAll;
	        			$this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'IMPORT_BULK_USER_UPDATE');
	        		},
	        		cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	        			if (e.target.tagName == 'A') {
	        				var fileType = null;
	        				if (cellIndex == 1) {
	        					fileType = 'successFile';
	        				} else if (cellIndex == 6) {
	        					fileType = 'errorFile';
	        				} else if (cellIndex == 7) {
	        					fileType = 'logFile';
	        				}
	        				var documentId = record.get("id");
	        				if (!isNullOrEmpty(documentId)) {
	        					this.getUserUpdateDownloadFile(documentId, fileType);
	        				}
	        			}
	        		}
	        	},
	        	'importuserupdategrid button[itemId=btnForce]': {
	        		click: function(obj) {
	        			var grid = this.getImportuserupdategrid();
	        			if (grid.getSelectionModel().getCount() > 0) {
	        				if (grid.getSelectionModel().getCount() > 1) {
	        					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	        				} else {
	        					var this$ = this;
	        					var id = grid.getSelectionModel().selectionStart.data.id;
	        					console.log(id);
	        					var urlAppend = "?jobName=" + id;
	        					var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
	        					Ext.Ajax.request({
	        						url: submitURL,
	        						method: 'GET',
	        						success: function(response) {
	        							if (response.responseText === "JOB_STATUS_NOT_PENDING") {
	        								showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	        							} else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
	        								showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	        							} else if (response.responseText === "SUCCESS") {
	        								showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
	        								grid.getStore().reload();
	        							}
	        						}
	        					});
	        				}
	        			} else {
	        				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	        			}
	        		}
	        	},
	        	'userupdatedownloadform checkbox[itemId=userWithoutALItemId]': {
	        		change: function(me, newValue, oldValue, eOpts) {
	        			var academyLocationItemId = me.up("userupdatedownloadform").down("#academyLocationItemId");
	        	     	if (me.getValue()) {
	        	     		academyLocationItemId.setDisabled(true);
	        	     		academyLocationItemId.reset();
	        	     	} else {
	        	     		academyLocationItemId.setDisabled(false);
	        	     	}
	        		}
	        	},
	        	'userupdatedownloadform combo[itemId=academyLocationItemId]': {
	                render: function(combo) {
	                    this.loadAcadLocCombo(combo);
	                },
	                select: function(combo) {
	                	var userWithoutALCheckbox = combo.up("userupdatedownloadform").down("#userWithoutALItemId");
	                	userWithoutALCheckbox.setDisabled(true);
	                }
	            },
	            'searchresultgrid button[itemId=enableDisableBtn]': {
	                click: function(button){                	
	                	this.enableDisableMessageEvent(button);
	                }
	            },
	            'userssendmessage' :{
	                        	afterrender:function(form){
	                        		 var me = this;
	             					me.saveDFRInfo(me.getCurrentAcademyLocation(),form);
	                        	 }
	             },
	             'accessrighttree #multipleALandRolesId':{
	 	        	click: function(obj) {
	 	        		//this.roleALMappings = [];
	 					var contentpanel = this.getContentPanel();
	 					var structure = Ext.widget('multiplealandrolesform');
	 					var tabName = getCommonTranslation('ASSIGN_MULTIPLE_ACADEMY_LOCATION_AND_ROLES');
	 					var getcontroller=this.getController('menu.CoreERPNavigationController');
	 					var getTab=getcontroller.getTab(tabName);
	 					if(getTab!=null){
	 						contentpanel.remove(getTab, true);
	 					}
	 					openTab(contentpanel, tabName, structure, CONSTANTS.MENU_COLOR_ONE);
	 					this.getMultiplealandrolesgrid().getStore().removeAll();
	 	        	}
	 	        },
	 	       'multiplealandrolesform button[itemId=GenDataBtn]':{
	 	    	   click: function(obj) {
	 	    		   this.addALRolesDataInGrid();
	 	    	   }
	 	       },
	 	      'multiplealandrolesform button[itemId=resetBtn]':{
	 	    	  click: function(obj) {
	 	    		  var form = this.getMultiplealandrolesform();
	 	    		  form.getForm().reset();
	 	    		  form.down('#multiAcademyLocationId').clearValue();
	 	    		  form.down('#multipleRolesId').clearValue();
	 	    		  form.down('#academyLocStartDate').setMaxValue();
	 	    		  form.down('#academyLocTillDate').setMinValue();
	 	    		  form.down('#roleStartDate').setMaxValue();
	 	    		  form.down('#roleTillDate').setMinValue(); 
	 	    	  }
	 	       },
	 	      'multiplealandrolesform button[itemId=btnDelete]':{
	 	    	  click: function(obj) {
	 	    		  var $this = this;
	 	    		  var form = this.getMultiplealandrolesform();
	 	    		  var grid = this.getMultiplealandrolesgrid();
	 	    		  var selectedRecord = grid.getSelectionModel().getSelection();
	 	    		  if(grid.getSelectionModel().getCount() > 0){
	 	    			 showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 	    				 if (btn == 'yes') {
	 	    					 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	 	    					 Ext.defer(function() {
	 	    						 Ext.each(selectedRecord, function(data,index){
	 	    							 var recordIndex =grid.store.findExact('gridRowIndex',data.data.gridRowIndex);
	 	    							 grid.store.removeAt(recordIndex); 
	 	    						 });
	 	    						 grid.getSelectionModel().deselectAll();
	 	    						 Ext.getBody().unmask();
	 	    						 showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
	 	    					 },1000, this);
	 	    				 }
	 	    			 });
	 	    		  }else{
	 	    			  Ext.getBody().unmask();
	 	    			  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	 	    		  }
	 	    	  }
	 	       },
	 	       'multiplealandrolesgrid button[itemId=saveDataBtn]':{
	 	    	  click: function(obj) {
	 	    		  this.saveALRolesMapping();
	 	    	  }
	 	       },
	 	       'multiplealandrolesgrid':{
	 	    	   cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	 	    		   if(cellIndex==1){
	 	    			 return false; //to prevent auto deselect of selmodel when radio button is clicked
	 	    		   }
	 	    	   }
	 	       },
               'studentuploadphotowindow[itemId=userToUploadPhotowindowItemId] button[itemId=profileRoatateImageIconId]': {
				   click: function(button) {
					   var formPanel = this.getStudentuploadphotowindow();
					   var imageContainerBoxId = formPanel.down('#profile_image_containerBox').id;
					   var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
					   imageInnerContainerBox.crop.rotate(button.rotate + .40);
					   button.rotate = parseFloat(button.rotate) + .50;
				   }
			   }
	 	       /* User Upload Loader : End*/
	    });
	},
	userToCaptureUserPhoto: function(btn){
		var $this = btn.up('window');
		var form = btn.up('window').down('form');
		var imageUrl;
		Webcam.snap( function(data_uri) {
			imageUrl = data_uri;
		});
        Ext.defer(function() {
        	var imgLoad = new Image();
    		imgLoad.onload = (function(){
    			var crop = new Academia.utilities.ImageCrop({
    				id:'testing',
    				width: 310,
    				height: 272,
    				src:imageUrl
    			});
    			crop.on('changeCrop', function(component,region) {
    				$this.cropData = region;
    				$this.component = component;
    			});
    			var PREVIEW_TEST = form.down('#previewPanelId');
    			PREVIEW_TEST.add(crop);
    			$this.down('#capturePanelId').setVisible(false);
    			$this.down('#previewPanelId').setVisible(true);
    			btn.setDisabled(true);
    			$this.down('#resetPhotoItemId').setDisabled(false);
    			$this.down('#btnSaveItemId').setDisabled(false);
    			
    			var canvas = document.getElementById('canvas');
				var ctx = canvas.getContext("2d");
				var region = $this.cropData; 
				var component = $this.component;
				var sw = region.width - region.x;
				var sh = region.height - region.y;

				var imgWidth = component.width;
				var imgHeight = component.height;

				var img = new Image();
				img.src = component.src;

				ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
    			$this.captureImageaUrl = canvas.toDataURL("image/png");
    		}).bind($this);
    		imgLoad.src = imageUrl;
    		$this.imagesUrl = imageUrl;
  	  }, 500, $this);  	
	
	},
	userToOpenCapturePhoto: function(){
   		var window = this.getStudentuploadphotowindow(),
   		profileImage = window.down('#profile_image'),
   		capturePanelId = window.down('#capturePanelId'),
   		btnUploadPhoto = window.down('#btnUploadPhotoItemId'),
   		btnTakePhoto = window.down('#btnTakePhotoItemId'),
   		capturePhoto = window.down('#capturePhotoItemId'),
   		resetPhoto = window.down('#resetPhotoItemId'),
   		btnBack = window.down('#btnBackItemId'),
   		btnSave = window.down('#btnSaveItemId');
   		window.down('#profile_image_containerBox').hide();
   		window.down('#profileRoatateImageIconId').hide();
   		window.previousProfileImage = profileImage.el.dom.src;
   		
   		btnUploadPhoto.reset();
   		btnUploadPhoto.setVisible(false);
   		btnTakePhoto.setVisible(false);
   		profileImage.setSrc('');
   		profileImage.setVisible(false);
   		capturePanelId.setVisible(true);
   		capturePhoto.setVisible(true);
   		resetPhoto.setVisible(true);
   		resetPhoto.setDisabled(true);
   		btnBack.setVisible(true);
   		btnSave.setVisible(true);   		
	},
	getUploadCaptureToPersonProfile : function(){
        var this$ = this;   
        var personProfile = this$.getContentPanelActiveTab();
     	var personId = personProfile.down("#personId").getValue()
        if(!isNullOrEmpty(personId)){
            Ext.Ajax.request({
                type: 'rest',
                binary: true,
                url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+personId,
                method: 'GET',
                success : function(response){
                    if(response.responseBytes.length>0){
                        var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
                        var url = window.URL.createObjectURL(blob);
                        var a=personProfile.down("#profile_image");
                        if(!isNullOrEmpty(a)){                         	
                        	a.getEl().dom.src=url;
                        	a.setVisible(true);
                        }
                    }
                }
            });
        }
    },
	userToUploadCapturedImage :  function(){
     	var me = this;
     	var grid = me.getSearchResultGrid();
     	var personProfile = me.getContentPanelActiveTab();
     	var photoUrl = me.getUserBasicDetails().down("#photoUrlItemId")
     	var personId = personProfile.down("#personId")
     	 personId = Number(personId.getValue());
         var formPanel = me.getStudentuploadphotowindow();
         var form = formPanel.down('form');
         
         if(form.down('#profile_image_containerBox').isVisible()) {
        	 var imageContainerBoxId = form.down('#profile_image_containerBox').id;
        	 var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
        	 var finalImageBase64;
        	 var imageBlob;
        	 if(!isNullOrEmpty(imageInnerContainerBox.crop)){        		 
        		 finalImageBase64 = imageInnerContainerBox.crop.getCroppedImage().src;
        		 imageBlob = base64ToBlob(finalImageBase64, 'image/png'); // Adjust type if needed
        	 }
         }
         var formValues = form.getValues();
         
         // Check if there's an image to upload
         var imageField = formPanel.down('#profileImageFormItemId');
         var imageVal = formPanel.down('#btnUploadPhotoItemId');
         var profile_image = formPanel.down('#profile_image');
         var isImageRemoved = formPanel.down('#isImageRemovedItemId');
         
         if(isImageRemoved.value == "true"){
              me.userToSaveUploadCapturedImage('');             
	    	  photoUrl.setValue('')
             return;
         }
         
         me.applyWindowMask();
         if (profile_image.isVisible()) {
             // If there's an image, upload it first
        	 var formData = new FormData();
        	 for (var key in formValues) {
        	     if (formValues.hasOwnProperty(key)) {
        	         formData.append(key, formValues[key]);
        	     }
        	 }
        	 formData.append('file', imageBlob, 'profile.png');
        	 
        	 var userInfo = Academia.model.authentication.UserInfoModel;
        	 var access_token = userInfo.get("accessToken");
        	 
        	 var url = SERVERURL.PERSON_IMAGE_UPLOAD+'?access_token='+access_token;
        	 
        	 var xhr = new XMLHttpRequest();
        	 xhr.open('POST', url);

        	 xhr.onload = function () {
        	     if (xhr.status >= 200 && xhr.status < 300) {
        	         var response = JSON.parse(xhr.responseText);
        	         var path = response.path;
        	         var updatedPath = path.replace(/^\/+/, "");
        	         photoUrl.setValue(path)
        	         me.userToSaveUploadCapturedImage(path);
        	     }
        	 };
        	 xhr.send(formData);
         	/*form.getForm().submit({
                 method: 'POST',
                 url: SERVERURL.PERSON_IMAGE_UPLOAD,
                 success: function(form, action) {
                     var responseData = Ext.decode(action.response.responseText);
                     var path = responseData.path;
                     var updatedPath = path.replace(/^\/+/, "");
                     me.userToSaveUploadCapturedImage(path);
                     photoUrl.setValue(path)
                 },
                 failure: function(response){
                 	me.hideWindowMask();
                 }
             });*/
         }else{
        	var me = this;
         	var userInfo = Academia.model.authentication.UserInfoModel;
 			var access_token = userInfo.get("accessToken");
         	var canvas = document.getElementById('canvas');
 			var ctx = canvas.getContext("2d");
 			var region = formPanel.cropData; 
 			var component = formPanel.component;
 			var sw = region.width - region.x;
 			var sh = region.height - region.y;
 			var imgWidth = component.width;
 			var imgHeight = component.height;
 			var img = new Image();
 			img.src = component.src;
 			ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
 			var dataUrl = canvas.toDataURL("image/png");
 			
 			var url = 'rest/personImage/uploadeB64Image?access_token='+access_token;
 			var form = new FormData();
 			form.append('file', dataUrl);
 			form.append('fileName', '1.png');
 			form.append('personId', personId);
 			var xhr = new XMLHttpRequest();
 			xhr.open('POST', url, true);
 			xhr.onreadystatechange = function () {
 				if (xhr.readyState == 4 && xhr.status == 200) {
 					if (xhr.responseText != "") {
 						var data = Ext.decode(xhr.responseText);
 						var profile = me.getContentPanelActiveTab(); 						
					if (data.path) {
							photoUrl.setValue(data.path)
		                    var updatedPath = data.path.replace(/^\/+/, "");
		                    me.getUploadCaptureToPersonProfile();
		                } 
 						showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
 					}
 				}
 				formPanel.close();	
 				//me.hideWindowMask();
 			};
 			xhr.send(form);
         } 
     },
     userToSaveUploadCapturedImage: function(imageUrl){
     	var me = this;
     	var grid = this.getSearchResultGrid();
     	var win = me.getStudentuploadphotowindow();
     	var personProfile = me.getContentPanelActiveTab();
     	var firstName = personProfile.down('#firstName').getValue();
     	var middleName = personProfile.down('#middleName').getValue()
     	var lastName = personProfile.down('#lastName').getValue()
     	var personId = personProfile.down("#personId")
    	 personId = Number(personId.getValue());
     	
     	//personProfile.record.raw.PERSON_IMAGE=imageUrl; 
     	var payload = {
     			personId: personId,
     			path: imageUrl
     	};
     	
     	var submitUrl = SERVERURL.PATH_UPLOAD_PERSON_PROFILE_PHOTOS;
     	
     	var data = Ext.encode(payload);
     	
     	Ext.Ajax.request({
     		url: submitUrl,
     		method: 'POST',
     		jsonData:data,
             success: function(response){
             	var responseData = response.responseText;
             	if (responseData=='fail') {
             		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('File Not Found'));
             	}else{
             		if(imageUrl == ""){
             			var a=personProfile.down("#profile_image");
        				 var newImgUrl = generateInitialsImage(
        						firstName, 
        						middleName, 
        						 lastName
        						);

        				a.setVisible(true);
        				a.getEl().dom.src = newImgUrl;
                 			
             			showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PERSON_PROFILE_PHOTO_REMOVE_SUCCESS'));
             		}
             		else{
             			me.getUploadCaptureToPersonProfile();
             			showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
             		}
             		var controller = me.getController('Academia.controller.authentication.AuthenticationController');
         			var userObj = me.getCurrentlyLoggedInUserWithPersonId();
         			if(controller && controller.getUserImage){
         				controller.getUserImage(userObj.personId, userObj.value);
         			}
             	}
             	win.close();
             	me.hideWindowMask();
             	grid.getStore().load()
             },
             failure: function(response){
             	me.hideWindowMask();
             }
     	})
     },
	 openPhotoUploadPopupToUser: function() {
	    	var profileUploadWindow = this.getStudentuploadphotowindow();
	    	
	        if (!profileUploadWindow) {
	        	profileUploadWindow = Ext.widget('studentuploadphotowindow',{
	        		itemId: 'userToUploadPhotowindowItemId'
	        	}); 
	        }
	        
	        if (!profileUploadWindow.hasAfterRenderHandler) {
	        	profileUploadWindow.on('afterrender', function () {
	        		var me = this;
	        		var profile = this.getContentPanelActiveTab();
	        		var grid = me.getSearchResultGrid();
	        	    var personId = profile.down("#personId")
	        	    var photoUrl = this.getUserBasicDetails().down("#photoUrlItemId")
	                 var personId = Number(personId.getValue());
	                if (!isNullOrEmpty(personId)) {
	                    Ext.Ajax.request({
	                        url: SERVERURL.PERSON_IMAGE_DOWNLOAD + '?personId=' + personId,
	                        method: 'GET',
	                        binary: true,
	                        success: function (response) {
	                            if (response.responseBytes.length > 0) {
	                                var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
	                                var url = window.URL.createObjectURL(blob);
	                                var profileImage = profileUploadWindow.down("#profile_image");
	                                profileImage.setVisible(true);
	                                if (photoUrl.getValue()) {
	                                	profileImage.getEl().dom.src = url;
	                                	profileUploadWindow.lastSavedImageUrl = url;
	                                    profileUploadWindow.down('#btnRemoveItemId').setDisabled(false);
	                                } else {
	                                	var newImgUrl = generateInitialsImage(
	                                				profile.down('#firstName').value, 
	                                				profile.down('#middleName').value, 
	                                				profile.down('#lastName').value 
	                      						);
	                                	profileImage.getEl().dom.src = newImgUrl;
	                                	profileUploadWindow.lastSavedImageUrl = newImgUrl;
	                                    profileUploadWindow.down('#btnRemoveItemId').setDisabled(true);
	                                }
	                            }
	                        },
	                    });
	                }
	            }, this);
	            
	            // Mark handler as attached to avoid duplicate bindings
	        	profileUploadWindow.hasAfterRenderHandler = true;
	        }
	        
	        profileUploadWindow.show();
	     },
	     userToUploadProfilePhoto: function(cmp, value) {
//	    	 	var grid=this.getSearchResultGrid();
//	 			var record = grid.getSelectionModel().getSelection()[0];
	    	    var window = this.getStudentuploadphotowindow();
	    	    var personProfile = this.getContentPanelActiveTab();
	    	    var form = window.down('form');
	    	    var image = form.down('#profile_image');
	    	    var imageContainerBoxId = form.down('#profile_image_containerBox').id;
	    	    var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
	    	    var btnSave = window.down('button[name=btnSave]');
	    	    var btnRemoveItemId = window.down("#btnRemoveItemId")
	    	    var photoUrl = this.getUserBasicDetails().down("#photoUrlItemId")
	    	    
	    	    var isImageRemoved = window.down('#isImageRemovedItemId');
	    	    
	    	    if (isRemovedBtnClick) {
	    	        isRemovedBtnClick = false; 
	    	        
	    	        var fallbackImg = generateInitialsImage(
	    	        		personProfile.down('#firstName').getValue(),
	    	        		personProfile.down('#middleName').getValue(),
	    	        		personProfile.down('#lastName').getValue()
					);
			        image.setSrc(fallbackImg);
			        isImageRemoved.setValue(true);
	    	        btnSave.setDisabled(false); 
	    	        btnRemoveItemId.setDisabled(true);
	    	        return;
	    	    }

	    	    if (isUploadBtnClick) {
	    	        isUploadBtnClick = false; 
	    	        var file = cmp.el.down('input[type=file]').dom.files[0];
	    	        if (!file) {
	    	            showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('NO_FILE_SELECTED'));
	    	            return;
	    	        }

	    	        // File extension validation
	    	        var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
	    	        if (!['png', 'jpeg', 'jpg'].includes(extension)) {
	    	            cmp.reset();
	    	            showWarningMessage(
	    	                getPersonModuleTranslation('PHOTO_UPLOAD'),
	    	                getPersonModuleTranslation('UPLOAD_VALID_FILE')
	    	            );
	    	            return;
	    	        }

	    	     // File size validation (Minimum: 100 KB, Maximum: 2 MB)
	    	        
    	        	if(file){
    	           		 if (file.size < 100 * 1024 || file.size > 2 * 1024 * 1024){      // file size should be less than 100 kb & greater than 2MB                       
    	           			 cmp.reset();
    	                        showWarningMessage(
    	                            getPersonModuleTranslation('PHOTO_UPLOAD'),
    	                            getCommonTranslation('FILE_SIZE_BETWEEN_RANGE')
    	                        );
    	                        return;
    	                    }else {
    	                        isImageRemoved.setValue(false);
    	                    }
    	            }
	    	           	        

	    	        // Process the valid file
	    	        form.down('#fileName').setValue(file.name);
	    	        var personProfile = this.getContentPanelActiveTab();
	    	        var personId = this.getUserBasicDetails().down("#personId")
	    	        personId = Number(personId.getValue())
	    	        form.down('#personId').setValue(personId);

	    	        var reader = new FileReader();
	    	        reader.onload = function(e) {
	    	        	var crop;
	    	        	var imageSrc;
	    	        	var canvasDiv ;
	    	            image.setSrc(e.target.result); 
	    	            Ext.defer(function(){
	    	            	imageSrc = imageInnerContainerBox.children[0].src;
	    			        image.setVisible(false);
	    			        window.down('#profileRoatateImageIconId').show();
	    	            	 crop = cropper(imageInnerContainerBox, {
	        				    area: [ 210, 210 ],
	        				    crop: [ 115, 115 ],
	        				    value: imageSrc,
	        				    allowResize: true,
	        		            allowZoom: true,
	        		            allowRotation: true,         		            
	        				})
	        				var jcropArea = imageInnerContainerBox.querySelector('.jcrop-area');
	    	            	 if (jcropArea) {
	    	            		    var innerJcropDiv1 = document.createElement('div');
	    	            		    innerJcropDiv1.className = 'border-left';

	    	            		    var innerJcropDiv2 = document.createElement('div');
	    	            		    innerJcropDiv2.className = 'border-right';

	    	            		    jcropArea.appendChild(innerJcropDiv1);
	    	            		    jcropArea.appendChild(innerJcropDiv2);
	    	            		}
	        				canvasDiv = jcropArea.nextSibling;
	        				if(!isNullOrEmpty(canvasDiv)){
	        					var mouseEventOccurred = false;
	        				if (canvasDiv) {
	        				    // Listen for mouse events and set the flag to true when one occurs
	        					canvasDiv.addEventListener('mousemove', function () {
	        						mouseEventOccurred = true;
	    				            if (mouseEventOccurred) {    				                
	    				                var croppedImage = crop.getCroppedImage().src;
	        				            image.setSrc(croppedImage);
	        				            image.setVisible(true);
	    				            }    				            
	    				        })
	    				        if(mouseEventOccurred == false) {
	        				    image.setSrc(imageSrc);
	        				    image.setVisible(true);
	        				}
	        				} 
	        			} 
	    				else {
	    				    image.setSrc(imageSrc);
	    				    image.setVisible(true);
	    				}
	    	            },500)
	    	            btnSave.setDisabled(false); 
	    	        };
	    	        reader.readAsDataURL(file);
	    	    }
	    	},
	getUserUpdateDownloadFile: function(documentId, fileType) {
		if (!isNullOrEmpty(documentId)) {
			var csvForm = Ext.create('Ext.form.Panel');
			csvForm.getForm().submit({
				target: '_blank',
				method: 'POST',
				params: {
					access_token: Ext.Ajax.defaultHeaders.access_token
				},
				headers: {
					'Authorization': Ext.Ajax.defaultHeaders.Authorization
				},
				url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
				standardSubmit: true
			});
		}
	},
	userUpdateDownloadUploadFormChange: function(cb, nv, ov) {
		var $this = this;
		var structure = cb.up('userupdateuploaddownloadstructure');
		var downloadTemplateForm = structure.down('userupdatedownloadform');
		var uploadTemplateForm = structure.down('userupdateuploadform');
		var grid = $this.getImportuserupdategrid();
		if (nv.downloadUploadTemplate == 'forDownloadTemplate') {
			uploadTemplateForm.hide();
			downloadTemplateForm.show();
			grid.setVisible(false);
		} else {
			$this.doAccessControlValidationForLoader(uploadTemplateForm, this.getCORE_ERP_LOADER_PERMISSIONS());
			var uploadoptionradiogroupform = $this.getUserupdateuploadoptionradiogroup();
			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				isUploadAll: false
			});
			downloadTemplateForm.hide();
			uploadTemplateForm.show();
			grid.setVisible(true);
			uploadTemplateForm.down("#uploadFileField").reset();
		}
		downloadTemplateForm.getForm().reset();
		downloadTemplateForm.down("#userWithoutALItemId").setDisabled(false);
	},
	disableAcademyLocationMultiSelect: function(me, newValue, oldValue, eOpts){
    	var academyLocationId = me.up().up().down("#academyLocationId");
    	var downoladBtnId = me.up().up().down("#downoladBtnId");
    	var form = me.up('userroledownloadform').getForm();
    	var values = form.getValues();
    	var aL = values.academyLocation;
    	if(me.getValue()){
    		academyLocationId.setDisabled(true);
    		downoladBtnId.setDisabled(false);
    	} else {
    		academyLocationId.setDisabled(false);
    		if(aL == undefined) {
    			var form = me.up('userroledownloadform').getForm();
    	    	var values = form.getValues();
    	    	var aL = values.academyLocation;
    		}
    		if(aL == undefined) {
    			downoladBtnId.setDisabled(true);
    		} else {
		    	if(aL !=undefined && aL.length > 0){
		    		downoladBtnId.setDisabled(false);
		    	} else {
		    		downoladBtnId.setDisabled(true);
		    	}
    		}
    	}
	},
	getUserRoleDownloadFile : function(documentId,fileType){
 	   if(!isNullOrEmpty(documentId)){
 		   var csvForm = Ext.create('Ext.form.Panel'); 
 		   csvForm.getForm().submit({
 			   target: '_blank',
 			   method:'POST',
 			   params :{
 				   access_token : Ext.Ajax.defaultHeaders.access_token
 			   },
 			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 			   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
 			   standardSubmit :true
 		   });
 	   }
	},
	userRoleDownloadUploadFormChange : function(cb, nv, ov){
		var $this = this;
		var structure = cb.up('userroleuploaddownloadstructure');
		var downloadTemplateForm = structure.down('userroledownloadform');
		var uploadTemplateForm = structure.down('userroleuploadform');
		var grid = $this.getImportListUserRole();
		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
			uploadTemplateForm.hide();
			downloadTemplateForm.show();
			grid.setVisible(false);
		}else{
			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
			var uploadoptionradiogroupform  = $this.getUserRoleuploadoptionradiogroup();
			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				isUploadAll: false
			});
			downloadTemplateForm.hide();
			uploadTemplateForm.show();
			grid.setVisible(true);
			uploadTemplateForm.down("#uploadFileField").reset();
		}
	},
	getUserDownloadFile : function(documentId,fileType){
 	   if(!isNullOrEmpty(documentId)){
 		   var csvForm = Ext.create('Ext.form.Panel'); 
 		   csvForm.getForm().submit({
 			   target: '_blank',
 			   method:'POST',
 			   params :{
 				   access_token : Ext.Ajax.defaultHeaders.access_token
 			   },
 			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 			   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
 			   standardSubmit :true
 		   });
 	   }
    },
	userDownloadUploadFormChange : function(cb, nv, ov){
		var $this = this;
		var structure = cb.up('useruploaddownloadstructure');
		var downloadTemplateForm = structure.down('userdownloadform');
		var uploadTemplateForm = structure.down('useruploadform');
		var grid = $this.getImportListUsers();
		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
			uploadTemplateForm.hide();
			downloadTemplateForm.show();
			grid.setVisible(false);
		}else{
			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
			downloadTemplateForm.hide();
			uploadTemplateForm.show();
			grid.setVisible(true);
			uploadTemplateForm.down("#uploadFileField").reset();
			
		}
	},
	userUploadPermissionFormChange : function(cb, nv, ov){
		var $this = this;
		var uploadTemplateForm = this.getUseruploadform();
		var grid = $this.getImportListUsers();
		 var isUploadAll = uploadTemplateForm.items.items[0].items.map.uploadgroupItemId.getValue().isUploadAll;
		   var uploadedBy = null;
		   if(!isUploadAll){
			   uploadedBy = $this.getCurrentlyLoggedInUser().id;
		   }
		   grid.getStore().getProxy().extraParams = {
			   moduleName:'IMPORT_BULK_USERS_UPLOAD',
			   uploadedBy:uploadedBy
		   };
		   grid.getStore().load();
	},
	
	userRoleUploadPermissionFormChange : function(cb, nv, ov){
		var $this = this;
		var uploadTemplateForm = this.getUserroleuploadform();
		var grid = $this.getImportListUserRole();
		 var isUploadAll = uploadTemplateForm.items.items[0].items.map.uploadgroupItemId.getValue().isUploadAll;
		   var uploadedBy = null;
		   if(!isUploadAll){
			   uploadedBy = $this.getCurrentlyLoggedInUser().id;
		   }
		   grid.getStore().getProxy().extraParams = {
			   moduleName:'IMPORT_BULK_USER_ROLE',
			   uploadedBy:uploadedBy
		   };
		   grid.getStore().load();
	},
	
	
	//*********** Search api Starts ************
	onUserQuickSearchRender: function(component, options) {
		if((component.itemId != 'academyLocationCombo')) {
			if (component.itemId != 'userType') {
				// Changes done by Divesh Solanki for V2D-16047
				component.getStore().getProxy().extraParams={
					   excludeStudents:'true'
				   };
			component.getStore().load();
			}
			
		}
    },
    loadGridAndSearchUsers : function(model, records) {
    	var quickSearchForm=this.getQuickSearchForm();
    	quickSearchForm.down('#searchButtonId').setDisabled(true);
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	var quickSearchFormValues=quickSearchForm.getForm().getValues();
		var jsonFormatFormData=this.createJsonFormat(quickSearchForm,records);
		var searchResultGrid = this.getSearchResultGrid();
		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.USERLISTVIEWCODE);
    	/**
    	 * Hide and show reset button on the bases of Include deleted user.
    	 */
    	var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getUSER_MANAGEMENT_PERMISSIONS());

		var isResetPasswordPermissionApply = false;
		var isEnablePermissionApply = false;
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'RESETPASSWORD') {
				isResetPasswordPermissionApply = true;
			}
			if (privilege === 'MAKE_ACTIVE') {
				isEnablePermissionApply = true;
			}
		});
    	var resetButton=searchResultGrid.down('#resetButtonItemId');
    	var enableDisableButton=searchResultGrid.down('#enableDisableBtn');
    	if(quickSearchFormValues.WHETHER_DELETED==true){
    		searchResultGrid.down('#searchResultGridBtnEdit').setDisabled(true);
    		searchResultGrid.down('#searchResultGridBtnDelete').setDisabled(true);
    		searchResultGrid.down('#enableDisableBtn').setDisabled(true);
    		resetButton.setVisible(false);
    		/*enableDisableButton.setVisible(true);*/
    	}else{
    		if (isResetPasswordPermissionApply) {
    			resetButton.setVisible(true);
    		}
    		if (isEnablePermissionApply) {
    			searchResultGrid.down('#enableDisableBtn').setDisabled(true);
    		}
    		searchResultGrid.down('#searchResultGridBtnEdit').setDisabled(true);
    		searchResultGrid.down('#searchResultGridBtnDelete').setDisabled(false);
    	}
    	/*var extraColumns=new Array();
    	extraColumns.push("View");
    	extraColumns.push("Download");
    	searchResultGrid.initialize(SERVERURL.USERQUICKSEARCH,resultViewUrl, jsonFormatFormData,extraColumns);
    	*/
    	searchResultGrid.config.searchFilterForm = quickSearchForm;
    	searchResultGrid.initialize(SERVERURL.USERQUICKSEARCH,resultViewUrl, jsonFormatFormData,quickSearchForm.down('#searchButtonId'));

	},
	exportUserList : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getQuickSearchForm();	
    	var searchResultGrid = this.getSearchResultGrid();
    	var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
    	var reportTitle=getCommonTranslation("USER_LIST");
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},   
	gridRenderFunction:function(grid){
		grid.setTitle(getCommonTranslation("USER_LIST"));
		grid.addButtonToolbar();
		/**
		 * Add dynamic reset button.
		 */
		var butonstoolbar=grid.down('#functionButtonsToolbar');
		/* butonstoolbar.insert(4,{
			 xtype: 'button',
  			 itemId: 'resetButtonItemId',
  			 text:getCommonTranslation('RESET_PASSWORD'),
  			 tooltip :getCommonTranslation('RESET_PASSWORD')
         });
		 
		 butonstoolbar.insert(5,{
			 xtype: 'button',
  			 itemId: 'activateButtonItemId',
  			 disabled:true,
  			 text:getCommonTranslation('ACTIVATE_BUTTON'),
  			 tooltip :getCommonTranslation('ACTIVATE_BUTTON')
         });*/
		butonstoolbar.insert(4,{
			 xtype: 'button',
			 itemId: 'sendMessageBtn',
			 text:getCommonTranslation('SEND_MESSAGE'),
			 tooltip :getCommonTranslation('SEND_MESSAGE')
	    });
		butonstoolbar.insert(5,{
			 xtype: 'button',
			 itemId: 'resetButtonItemId',
			 text:getCommonTranslation('RESET_PASSWORD'),
			 tooltip :getCommonTranslation('RESET_PASSWORD')
	    });
		butonstoolbar.insert(6,{
			 xtype: 'button',
			 itemId: 'enableDisableBtn',
			 text:getCommonTranslation('MAKE_ACTIVE'),
			 tooltip :getCommonTranslation('MAKE_ACTIVE')
	    });
	    butonstoolbar.insert(7,{
			xtype: 'button',
			itemId: 'createUserInAlfresco',
			text:getDMSTranslation('CREATE_USER_IN_ALFRESCO'),
			tooltip :getDMSTranslation('CREATE_USER_IN_ALFRESCO')
			   });
	    butonstoolbar.insert(9,{
			xtype: 'button',
			itemId: 'selectSimilarRecords',
			disabled:true,
			text:getCommonTranslation('SELECT_SIMILAR_RECORDS'),
			tooltip :getCommonTranslation('SELECT_SIMILAR_RECORDS')
			   });
		 /*butonstoolbar.insert(6,{
			 	xtype : 'splitbutton',
		        itemId:'spBtnMoreActions',
		        text : getCommonTranslation('MOREACTIONS'),
		        menu:[{
		            text:getMessagingModuleTranslation('SEND_MESSAGE'),
		            itemId:'sendMessageBtn'
		        },{
					text:getCommonTranslation('ACTIVATE_BUTTON'),
					itemId:'activateButtonItemId',
					disabled:true
				},{
					text:getCommonTranslation('RESET_PASSWORD'),
					itemId:'resetButtonItemId'
				}],

		        listeners: {click: function() {this.showMenu();}}
	    });*/
	},
	
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        } else {
        	return {
                "paramCode": key,
                "paramValues": [value]
            };
        }
    },
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
	createJsonFormat:function(quickSearchForm){	
		var me=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.USERLISTCONFIGCODE;

        formValues = quickSearchForm.getValues();        
        //var firstName = formValues.USER_NAME//.split(" ")[0]
        //formValues.USER_NAME = firstName;
        for (var key in formValues) {
        	var value = formValues[key]; 
        	if(!isNullOrEmpty(value) && value !=='All' && (key == 'WHETHER_DELETED' && value!==true) &&
        			(key !== 'USER_ROLE')){
        		var keyValueJsonObject = me.getJsonObject( key , value);
        		me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        	}else if(!isNullOrEmpty(value) && value !=='All' && value !=='BOTHs' && key !== 'USER_ROLE'){
        		var keyValueJsonObject = me.getJsonObject( key , value);
        		me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        	}
        }
        
        if(this.getCurrentlyLoggedInUser().code.toUpperCase()!="SYSADMIN"){
        	if(isNullOrEmpty(formValues.USER_WITHOUT_AL)){
        		if(isNullOrEmpty(formValues.ACADEMY_LOCATION_ID)){
        			var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', this.getCurrentAcademyLocation());
        			this.pushJsonObjectInArray(ACADEMY_LOCATION_ID, searchcriteria);
        		} 
        	}
        } 
        if(isNullOrEmpty(formValues.WHETHER_DELETED)) {
        	var keyValueJsonObject = me.getJsonObject( "WHETHER_DELETED" , false);
 	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        if(!isNullOrEmpty(formValues.USER_ROLE)) {
        	if(!isNullOrEmpty(formValues.USER_ROLE.id)) {
        		var USER_ROLE_ID = me.getJsonObject("USER_ROLE" , formValues.USER_ROLE.id);
        		me.pushJsonObjectInArray(USER_ROLE_ID,searchcriteria);
        	}
        }
        values.searchCriterias = searchcriteria;
//        if(this.getCurrentlyLoggedInUser().code=="SYSADMIN" && isNullOrEmpty(formValues.ACADEMY_LOCATION_ID)){
//        	delete values.searchCriterias.ACADEMY_LOCATION_ID;
//        }
        return values;
		
		
		/*
		var userIdTextBox=quickSearchForm.down('#user_id');
		var userNameTextBox=quickSearchForm.down('#user_name');
		var userTypeCombo=quickSearchForm.down('#user_type');
		var whetherDeletedCheckBox=quickSearchForm.down('#whether_deleted');
		var values=new Object();
		values.configCode=CONSTANTS.CB.USERLISTCONFIGCODE;
		var searchcriteria=new Array();
		if(userIdTextBox.getValue()!=""){
			searchcriteria.push({paramCode:"USER_ID", paramValues:[userIdTextBox.getValue()]});
		}
		if(userNameTextBox.getValue()!=""){
			searchcriteria.push({paramCode:"USER_NAME", paramValues:[userNameTextBox.getValue()]});
		}
		if(userTypeCombo.getValue()=="TRUE" || userTypeCombo.getValue()=="FALSE"){
			searchcriteria.push({paramCode:"WHETHER_INTERNAL", paramValues:[userTypeCombo.getValue()]});
		}
		if(whetherDeletedCheckBox.getValue()!=true){
			searchcriteria.push({paramCode:"WHETHER_DELETED", paramValues:[whetherDeletedCheckBox.getValue()]});
		}
		values.searchCriterias=searchcriteria;
		return values;
		
		*/
	},
	// *********** search api ends ************
	 /**
     * This method is use to load the module combo box store and filter the grid according to selected portal
     * 
     */
    loadPortalCombo: function(combo, records) {
        var store = this.getUserPrivilegeGrid().getStore();
        store.clearFilter();
        var moduleCombo = combo.up().down('#comboModule');
        var subModuleCombo = combo.up().down('#comboSubModule');
        moduleCombo.clearValue();
        subModuleCombo.clearValue();
        subModuleCombo.setDisabled(true);
        store.filterGrid(records[0].get('portalName'), "portal");
        var id = records[0].get('id');
        var moduleStore = this.getStore('securitysetup.ModuleStore');
        moduleStore.getProxy().extraParams = {
            portalId: id
        };
        moduleStore.load();
        moduleCombo.setDisabled(false);
    },
    
    /**
     * This method is use to load the Submodule combo box store and filter the grid according to selected module
     * 
     * */
    loadModuleCombo: function(combo, records) {
        var store = this.getUserPrivilegeGrid().getStore();
        var subModuleCombo = combo.up().down('#comboSubModule');
        var id = records[0].get('id');
        store.removeFilter("moduleId");
        subModuleCombo.clearValue();
        var subModuleStore =subModuleCombo.getStore();
        if (id != 0) {
            store.filterGrid(records[0].get('moduleName'), "module");
            subModuleStore.getProxy().extraParams = {
                moduleId: id
            };
            subModuleStore.reload();
            subModuleCombo.setDisabled(false);
        }
    },
    loadAcadLocCombo: function(combo) {
        var store = combo.getStore();
        store.getProxy().extraParams = {
    		id: this.getCurrentlyLoggedInUser().id
    	};
        
    },
    disableUsersWithoutALCheckbox: function(combo){
    	var userWithoutALCheckbox = combo.up("#userQuickSearchForm").down("#users_without_AL");
    	userWithoutALCheckbox.setDisabled(true);
    },
    disableAcademyLocationCombo: function(me, newValue, oldValue, eOpts){
    	var AcademyLocationCombo = me.up("#userQuickSearchForm").down("#academyLocationCombo");
    	if(me.getValue()){
    		AcademyLocationCombo.setDisabled(true);
    	}
    	else{
    		AcademyLocationCombo.setDisabled(false);
    	}
    },
    resetFields: function(me){
    	var form = me.up("#userQuickSearchForm");
		form.getForm().reset();
    	form.down("#users_without_AL").setDisabled(false);
    	form.down("#getSubDepartmentId").setDisabled(true);
    },
    /**
     * This method is use to  filter the grid according to selected sub module
     * 
     * */
    loadSubModuleCombo: function(combo, records) {
        var store = this.getUserPrivilegeGrid().getStore();
        var id = records[0].get('id');
        store.removeFilter("subModuleId");
        if (id != 0) {
            store.filterGrid(records[0].get('moduleName'), "subModule");
        }
    },
    /**
     * This method is use to  reset  the selected filters for grid 
     * 
     * */
    resetFilter: function(button) {
        button.up().down("#comboPortal").clearValue();
        var moduleCombo = button.up().down("#comboModule");
        moduleCombo.clearValue();
        moduleCombo.setDisabled(true);
        var subModuleCombo = button.up().down("#comboSubModule");
        subModuleCombo.clearValue();
        subModuleCombo.setDisabled(true);
        var store = this.getUserPrivilegeGrid().getStore();
        store.clearFilter();
    },
    
    /**
     * Render access tree on load by user id
     */
    renderAccessRightTree: function(tree) {

        var grid = this.getSearchResultGrid();
        if (!isNullOrEmpty(grid) && grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];

            var userId = record.raw.USER_ID;
            var treeStore = tree.getStore();
            treeStore.getProxy().extraParams = {
                userId: userId
            };
            treeStore.load();
        }
    },
    
    /**
	 * this function is used to hide button menu while scrolling
	 */
    hideButtonMenuWhileScrolling:function(grid){
    	var $this = this;
	    var userdDetails=this.getUserdDetails();
	    userdDetails.body.on('scroll', function(e){
		var moreAddButton=grid.down('#btnAddPermissions');
		var moreAddAcadLocButton=grid.down('#btnAddAcademyLocation');
		var moreUnassignButton=grid.down('#btnUnassign');
		moreAddButton.hideMenu();
		moreAddAcadLocButton.hideMenu();
		moreUnassignButton.hideMenu();
	    }, userdDetails);
    },
	/**
	 * This method is used to reset and enable subDepartment Combo.
	 * @param {Number} parentId : Parent department unique identifier.
	 * @param {Number} recId : [optional] if undefined set record. 
	 */
	enableLocationCombo: function(academyId, recId) {
	    var locationCombo = this.getUserAcademyLocation().down("#academy_location");
	    locationCombo.reset();
	    locationCombo.enable();
	    var store = locationCombo.getStore();
	    store.getProxy().extraParams = {
	    	academyId: academyId
	    };
	    store.load({
	        callback: function(records, operation, success) {
	            if (recId && success) {
	            	locationCombo.setValue(recId);
	            }
	        }
	    });
	},
	
	/**
	 * This method is used to reset and enable subDepartment Combo.
	 * @param {Number} parentId : Parent department unique identifier.
	 * @param {Number} recId : [optional] if undefined set record. 
	 */
	enableSubDepartment: function(parentId, recId) {
		if(parentId){
		    var subDepartmentCombo = this.getUserBasicDetails().down("#subDepartmentId");
		    subDepartmentCombo.reset();
		    subDepartmentCombo.enable();
		    var store = subDepartmentCombo.getStore();
		    store.getProxy().extraParams = {
		        parentId: parentId
		    };
		    store.load({
		        callback: function(records, operation, success) {
		            if (recId && success) {
		                subDepartmentCombo.setValue(recId);
		            }
		        }
		    });
		}
	},
	getUserEnableSubDepartment: function(parentId, recId) {
		if(parentId){
		    var subDepartmentCombo = this.getQuickSearch().down("#getSubDepartmentId");
		    subDepartmentCombo.reset();
		    subDepartmentCombo.enable();
		    var store = subDepartmentCombo.getStore();
		    store.getProxy().extraParams = {
		        parentId: parentId
		    };
		    store.load({
		        callback: function(records, operation, success) {
		            if (recId && success) {
		                subDepartmentCombo.setValue(recId);
		            }
		        }
		    });
		}
	},

	/**
	 * This method is used to show form in new tab.
	 */
	showFormTab:function(tabTitle){
		var menuController = this.getMenuController();	
		menuController.addTab( tabTitle,'userdetails',CONSTANTS.MENU_COLOR_ONE);
	},
	/**
	 * This method is used to show form in new tab from UserProfileController.
	 */
	openUserDetailViewFromRecentList: function(employeeData, weatherViewOnly) { 
	    var this$ = this;
	    var CODE = employeeData['CODE'];
	    var userGroup = employeeData['USER_GROUP_NAME'];
	    var userId = employeeData['USER_ID'];
	    this$.setSelectedUser(employeeData.personId);
	    var tabName;

	    if (weatherViewOnly) {
	        tabName = getCommonTranslation('VIEW_USER') + ' ' + CODE;
	    } else {
	        tabName = getCommonTranslation('EDIT_USER') + ' ' + CODE;
	    }

	    this$.showFormTab(tabName);
	    var id = employeeData.USER_ID;

	    var userBasicDetails = this$.getUserBasicDetails();
	    

	    var personId = userBasicDetails.down("#personId");
	    if (personId) {
	        personId.setValue(id);
	    }

	    var photoUrl = userBasicDetails.down("#photoUrlItemId");
	    if (photoUrl) {
	        photoUrl.setValue(employeeData.image);
	    }

	    var profile = this$.getContentPanelActiveTab();	
	    var userForm = this$.getUserDetails(tabName);
	    if (userForm) {
	        userForm.getForm().setValues({ userId: id });
	    }

	    Ext.Ajax.request({
	        url: SERVERURL.STAFF + id,
	        method: 'GET',
	        success: function(res) {
	            var data = Ext.decode(res.responseText);
	            var contentPanel = this$.getContentPanelActiveTab();
	            var userBasicDetailsForm = contentPanel.down("userbasicdetails");

	            /*if (!userBasicDetailsForm) {
	                console.error("User basic details form not found in active tab.");
	                return;
	            }*/

	            Ext.apply(userBasicDetailsForm.getForm(), {
	                userCode: null,
	                setUserCode: function(userCode) {
	                    this.userCode = userCode;
	                },
	                getUserCode: function() {
	                    return this.userCode;
	                }
	            });

	            this$.loadUserBasicDetailsForm(data, tabName, weatherViewOnly);
	            userBasicDetailsForm.getForm().setUserCode(data.code);

	            if (weatherViewOnly) {
	                toggleReadOnlyFormItems(userBasicDetailsForm.getForm(), true);
	            }
	        }
	    });

	    var userTab = this$.getUserDetails(tabName);
	    if (userTab) {
	        var treeId = userTab.down('#acessTreeId');
	        if (!treeId) {
	            var tree = Ext.create('Academia.view.securitysetup.AccessRightsTree', {
	                title: 'Access Rights',
	                collapsible: true,
	                itemId: 'acessTreeId',
	                cls: 'accessRightGridCls',
	                store: Ext.create('Academia.store.securitysetup.AccessTree')
	            });
	            userTab.add(tree);
	        }
	    }
	 // for user activities
        Ext.Ajax.request({
       	 url: SERVERURL.USER_ACTIVITY_RECENT_VISITED_STUDENT+"?visitedUserId="+Number(userId)+"&userGroup="+userGroup,
       	 method: 'POST',
       	 success: function(response) {
       		 var responseData = Ext.decode(response.responseText);
       	 },
       	 failure: function(response) {
       	     showErrorMessage('Error', 'No update');
       	 }
        })
	},
	
	/**
	 * This method is used to show form in new tab in edit mode.
	 */
	editFormWindow:function(weatherViewOnly){
		var this$=this;
		var grid=this.getSearchResultGrid();
		
		if(grid.getSelectionModel().getCount()>0){
			 var record = grid.getSelectionModel().getSelection()[0];
			 var userGroup = record.get('USER_GROUP_NAME');
			 var userId = record.get('USER_ID');
			 var CODE = record.raw.CODE;
			 this$.setSelectedUser(record.get('USER_ID'));
			 var tabName;
			 if(weatherViewOnly) {
				 tabName=getCommonTranslation('VIEW_USER') + ' ' + CODE;
			 } else {
				 tabName=getCommonTranslation('EDIT_USER')+ ' ' + CODE;
			 }
			 
			this$.showFormTab(tabName);
			var id=record.raw.USER_ID;
			var personId = this.getUserBasicDetails().down("#personId")
    	    personId.setValue(id)
    	    var photoUrl = this.getUserBasicDetails().down("#photoUrlItemId");
			photoUrl.setValue(record.raw.PERSON_IMAGE);
            var profile = this.getContentPanelActiveTab();	
			   this$.getUserDetails(tabName).getForm().setValues({userId: id});
			    Ext.Ajax.request({
			        type: 'rest',
			        url: SERVERURL.STAFF + id,
			        method: 'GET',
			        success: function(res, action) {
			        	var data=Ext.decode(res.responseText);
			        	var contentPanel = this$.getContentPanelActiveTab();
			        	var userBasicDetailsForm = contentPanel.down("userbasicdetails");
			        	Ext.apply(userBasicDetailsForm.getForm(),{
			        		userCode:null,
			        		setUserCode : function(userCode){
			        			userBasicDetailsForm.getForm().userCode = userCode;
			        		},
			        		getUserCode:function(){
			        			return userBasicDetailsForm.getForm().userCode;
			        		}
			        	});
			        	this$.loadUserBasicDetailsForm(data,tabName,weatherViewOnly);
			        	userBasicDetailsForm.getForm().setUserCode(data.code);
			        	if(weatherViewOnly) {
			        		toggleReadOnlyFormItems(userBasicDetailsForm.getForm(), true);	
			        		var container = userBasicDetailsForm.down('#profile_image_icon');
                            if (container && container.getEl()) {
                                var spanEl = container.getEl().down('span.hoverElement');
                                if (spanEl) {
                                    spanEl.setStyle('display', 'none');
                                }
                            }
			        	}
			        }
			    });
			    var usertab=this.getUserDetails(tabName);
			    var treeId = usertab.down('#acessTreeId');
			    if(!treeId){
			    	var tree = Ext.create('Academia.view.securitysetup.AccessRightsTree', {
			    	title: 'Access Rights',
			        collapsible : true,
			        itemId : 'acessTreeId',
			        cls:'accessRightGridCls',
			        store :Ext.create('Academia.store.securitysetup.AccessTree')
			    });
			    usertab.add(tree);
			    }
			    
			    // for user activities
                Ext.Ajax.request({
               	 url: SERVERURL.USER_ACTIVITY_RECENT_VISITED_STUDENT+"?visitedUserId="+Number(userId)+"&userGroup="+userGroup,
               	 method: 'POST',
               	 success: function(response) {
               		 var responseData = Ext.decode(response.responseText);
               	 },
                })
			    }
			    else {
					showWarningMessage(getCommonTranslation('ASSIGN_ROLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				}	
	},
	
	/**
	 * This method is used to load data in form.
	 * Id data is not null load form and load subDepartment by {@link #enableSubDepartment}
	 * @param data : Object to be load.
	 */
	loadUserBasicDetailsForm:function(data,tabName,weatherViewOnly){
		var this$=this;
		   if(data){
			   var formView=this$.getUserBasicDetails(tabName);
			   var form = formView.getForm();
			   var frm = this$.getUserBasicDetails(tabName);
			   frm.down("#photoViewPanelId").setVisible(true);
			   //frm.down("#photoFileImage").setVisible(true);
			   //frm.down("#texthidden").setVisible(true);
			   var code=data.code.trim();
			   if(code==="SYSADMIN" || code==="PUBLIC_PORTAL_USER" || code==="APPLICANT_PORTAL_USER" || code==="ENQUIRY_PORTAL_USER" || code==="SSO_USER"){
			   frm.down("#code").setReadOnly(true);
			   }else{
			   frm.down("#code").setReadOnly(false);
			   }
			   var records = this.generateFormDataFromResponse(data);
			   form.setValues(records);
               formView.down('#employeeTypeId').getStore().load(function(){
                   if(records.employeeType){
                       formView.down('#employeeTypeId').setValue(records.employeeType);
                   }
               });
			   formView.down('#departmentId').getStore().load(function(){
				   if(records.department){
					   formView.down('#departmentId').setValue(records.department.id);
				   }
			   });
			   this$.setHiddenFormValues(data);
			   var parentId=this$.getIdFromNestedObject(data, 'department');
			   var recId=this$.getIdFromNestedObject(data, 'subDepartment');
			   
			   var mobileCoutryCodeCombo = frm.down("#mobileCountryCode");
			   var mobileCoutryCodeStore = mobileCoutryCodeCombo.getStore();
			   var coutryCodeVal = data.person.mobileCountryCode;
			   
			   //.setValue(data.person.mobileCountryCode);
			   
			   var birthDate = frm.down('#birthDateItemId');
			   var dateOfJoining = frm.down('#dateOfJoining');
			   var dateOfExit = frm.down('#dateOfExit');
			   if(!isNullOrEmpty(birthDate.getValue())){
				   var getBirthYear =birthDate.getValue().getFullYear(); 
				   var joinDate = new Date(birthDate.getValue());
				   joinDate.setFullYear(getBirthYear + 18);
				   dateOfJoining.setMinValue(joinDate);
			   }
    		
			   mobileCoutryCodeStore.load({
			        callback: function(records, operation, success) {
			        	for(var i in records){
			        	  if (coutryCodeVal == records[i].data.isdCode) {
			        		  mobileCoutryCodeCombo.setValue(coutryCodeVal);
			              }
			        	}
			        }
			    });
			   
			   var userGroupname = data.userGroup.value;
			   dateOfExit.setValue(dateRender(data.dateOfExit));
			   this$.hideOrShowWeatherFaculty(userGroupname);
			   
	   		   this$.enableSubDepartment(parentId, recId);
	   		   this$.getDownLoad(data);
	   		this$.removePlaceHolder(weatherViewOnly);
		   }
	},

	generateFormDataFromResponse:function(data) {
		data.gender = data.person.genderCSM;
		data.birthDate = new Date(data.person.birthDate);
		data.bloodGroup = data.person.bloodGroup;
		data.religion = data.person.religion;
		data.emailId = data.person.emailId;
		data.nationality = data.person.nationality;
		data.mobileNumber = data.person.mobileNumber;
		data.mobileCountryCode = data.person.mobileCountryCode;
		data.salutation = data.person.salutation;
		data.alternateEmailId = data.person.alternateEmailId;
		data.externalSysRefOne = data.person.externalSysRefOne;
		data.externalSysRefTwo = data.person.externalSysRefTwo;
		data.externalSysRefThree = data.person.externalSysRefThree;
		
		if(!isNullOrEmpty(data.joiningDate)){
			data.joiningDate = new Date(data.joiningDate);
		}else{
			data.joiningDate =null;
		}
		if(!isEmpty(data.person.bankDetail)) {
			data.bankName = data.person.bankDetail.bankName;
			data.accountNumber = data.person.bankDetail.accountNumber;
			data.branchName = data.person.bankDetail.branchName;
			data.ifsCode = data.person.bankDetail.ifsCode;
			data.beneficiaryName = data.person.bankDetail.beneficiaryName;
			data.accountTypeId = data.person.bankDetail.accountTypeId;
			
		}		
		return data;		
	},
	
	setHiddenFormValues:function(data) {
		var form = this.getUserBasicDetails();
		form.down('#personId').setValue(data.person.id);
		form.down('#personVersion').setValue(data.person.version);
		form.down('#photoUrlItemId').setValue(data.person.photoUrl);
		if(data.person.bankDetail){
			form.down('#bankId').setValue(data.person.bankDetail.id);
			form.down('#bankVersion').setValue(data.person.bankDetail.version);
			form.down('#bankPerson').setValue(data.person.bankDetail.person);
		}
		form.down('#resetButtonId').setVisible(false);
	},
	
	/**
	 * This method is used to save or update user record.
	 * If id is null save else update record.
	 * 
	 */
	saveUpdateUser: function(controllerRef) {
		var grid=controllerRef.getSearchResultGrid();
		var me = this;
	    var form = this.getUserBasicDetails();
	    var contentPanel = this.getContentPanel(); 
	    var activeTab = contentPanel.getActiveTab();
	    var basicForm = form.getForm();
	    var values = basicForm.getValues();
	    var submitUrl, successMsg;
	   // var photoUrlHidFld = form.down('#photoUrlItemId');
	    //var userPhotoFileField= form.down('#photoFileImage').down('#photoFileImage');
	    var dateOfJoining= form.down('#dateOfJoining');
	    var dateOfExit= form.down('#dateOfExit');
	    var isUpdate = false;
	    if (basicForm.findField('id').getSubmitValue() == null || basicForm.findField('id').getSubmitValue() == "") {
	        submitUrl = SERVERURL.STAFF_SAVE;
	        successMsg = getCommonTranslation('USER_ADD_SUCCESS');
	    } else {
	        submitUrl = SERVERURL.USER_UPDATE;
	        successMsg = getCommonTranslation('USER_UPDATE_SUCCESS');
	        isUpdate = true;
	    }
	    if(!isEmpty(values)){
	        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    	var submitData = this.generateJsonForUser(values);
	 		 var formData = Ext.encode(submitData);		  
		     Ext.Ajax.request({
		        type: 'rest',
		        url: submitUrl,
		        jsonData: formData,
		        method: 'POST',
		        success: function(form1, action) {
		        	
		        	if (isUpdate){
		        		/*if(!isNullOrEmpty(userPhotoFileField.getValue())){
		        			me.saveUserPhotoUpload(form);
		        		}
		        		else{*/
		        			contentPanel.remove(activeTab,true);
			        		Ext.getBody().unmask();
			        		showSuccessMessage( getCommonTranslation('USER'),successMsg);
			        	}
//		        	}
		        	else{
		        		contentPanel.remove(activeTab,true);
		        		Ext.getBody().unmask();
		        		showSuccessMessage( getCommonTranslation('USER'),successMsg);
		        	}
		        	
		        	grid.getSelectionModel().deselectAll(true);
		        	grid.getStore().reload();
		        	grid.getSelectionModel().select(0, true);
		        	//var tab = form.up('panel');
		        	//me.closeTab(tab);
		        }
		    });
		    
	    }	    
	},

	generateJsonForUser:function(values) {
		var person = new Object();
		person.id =values.personId;
		person.version = values.personVersion;
		person.salutation = values.salutation;
		person.firstName=values.firstName;
		person.middleName=values.middleName;
		person.lastName=values.lastName;
		person.shortName=values.shortName;
		person.printName = values.printName;
		//person.gender=values.gender;
		person.initials=values.initials;
		person.genderCSM=values.gender;
		person.birthDate=values.birthDate;
//		person.emailId = values.emailId;
		if (!isNullOrEmpty(values.emailId)) {
			person.emailId = values.emailId;
        }else{
        	person.emailId = null;
        }
		person.mobileNumber= values.mobileNumber;
		person.mobileCountryCode = values.mobileCountryCode;
		person.alternateEmailId = values.alternateEmailId;
		person.photoUrl = values.photoUrl;
		person.dateOfJoining = values.dateOfJoining;
		person.externalSysRefOne = values.externalSysRefOne;
		person.externalSysRefTwo = values.externalSysRefTwo;
		person.externalSysRefThree = values.externalSysRefThree;
		if (isNullOrEmpty(values.bloodGroup)) {
			values.bloodGroup = null;
        }
        if (isNullOrEmpty(values.religion)) {
        	values.religion = null;
        }
        if (isNullOrEmpty(values.nationality)) {
        	values.nationality = null;
        }
         
        if (!isNullOrEmpty(values.nationality) && isNullOrEmpty(values.nationality.id)) {
        	values.nationality = null;
        }
        
        if (!isNullOrEmpty(values.religion) && isNullOrEmpty(values.religion.id)) {
        	values.religion = null;
        }
        
        if (!isNullOrEmpty(values.approvalDrool) && isNullOrEmpty(values.approvalDrool.id)) {
        	values.approvalDrool = null;
        }
        
        if (isNullOrEmpty(values.employeeType)) {
        	delete values.employeeType ;
        }
		person.bloodGroup=values.bloodGroup;
		person.religion=values.religion;
		person.nationality=values.nationality;
		//console.log('values.accountTypeId : ', values.accountTypeId);
		person.bankDetail = {
				id: values.bankId,
	            version: values.bankVersion,
	            //person: values.bankPerson,
	            bankName: values.bankName,
	            accountNumber: values.accountNumber,
	            branchName:values.branchName,
	            ifsCode:values.ifsCode,
	            beneficiaryName:values.beneficiaryName,
	            accountTypeId:values.accountTypeId
		};
		values.person = person;
		
		var form = this.getUserBasicDetails();
		var userGroupName = form.down('#userGroupType').rawValue;
	    /*if(userGroupName == getCommonTranslation('OTHER_EMPLOYEE')) {
	    	delete values.facultyType;
		} else if(userGroupName == getCommonTranslation('FACULTY')) {
			delete values.employeeType;
		} else {
			delete values.employeeType;
			delete values.facultyType;
		}*/
		delete values.mobileNumber;
		delete values.mobileCountryCode;
		delete values.salutation;
		delete values.nameToBePrinted;
		delete values.gender;
		delete values.birthDate;
		delete values.bloodGroup;
		delete values.religion;
		delete values.nationality;
		delete values.bankName;
		delete values.accountNumber;
		delete values.branchName;
		delete values.ifsCode;
		delete values.emailId;
		delete values.customFieldDatas;
		delete values.bankId;
		delete values.bankVersion;
		delete values.bankPerson;
		delete values.personId;
		delete values.personVersion;
		//delete values.ageAsOnBirthDate;
		delete values.beneficiaryName;
		delete values.accountTypeId;
		delete values.alternateEmailId;
		delete values.photoUrl;
		delete values.externalSysRefOne;
		delete values.externalSysRefTwo;
		delete values.externalSysRefThree;
		
		if(!values.status){
			if (isNullOrEmpty(values.dateOfExit)) {
				var today = new Date();
				values.dateOfExit=today.getFullYear()+'-'+(today.getMonth()+1)+'-'+today.getDate();
	        }
			
		}
		
		return values;
	},
	
	
	/**
	 * This method is used to show Academy Location Form.
	 * New window is created if not created.
	 */
	showAcademyLocationForm:function(){
		 var formWindow = this.getAcademyLocationForm();	
	     if (!formWindow) {
	         Ext.widget('useracademylocation');
	         formWindow = this.getUserAcademyLocation();
	     }
	     formWindow.show();
	     var form = this.getAcademyLocationForm().getForm();
	     this.setUserId(form);
	},
	/**
	 * This method is used to show Academy Location Form.
	 * New window is created if not created.
	 */
	closeAcademyLocationForm:function(){
		this.getUserAcademyLocation().close();	
	},
	/**
	 * This method is used to show Academy Location Form.
	 * New window is created if not created.
	 */
	editAcademyLocationForm:function(){
		//var gridTree = this.getAccessRightsTree();
		var gridTree = this.getActiveTabfromContentPanel().down('accessrighttree');
		if(gridTree.getSelectionModel().getCount()>0){
			 this.showAcademyLocationForm();	
			  var records = gridTree.getSelectionModel().getSelection();
	            if (records != undefined && records != "" && records != null) {
	            	this.loadAcademyLocationForm(records[0]);
	            }
		} else {
			showWarningMessage(getCommonTranslation('ASSIGN_ROLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}	
	},
	/**
	 * This method is used to load data in academy location form.
	 */
	loadAcademyLocationForm:function(data){
		var this$=this;
		   if(data){
			   var form = this$.getUserAcademyLocation().down('#userAcademyLocatioFormId');
			   var academyCombo = form.down('#academy_name');
			   var whetherPrimeryField = form.down('#whetherPrimary');
			   var academyStore = academyCombo.getStore();
			   if(!isNullOrEmpty(data.data.startDate))
				   data.data.startDate = new Date(data.data.startDate);
			   if(!isNullOrEmpty(data.data.tillDate))
				   data.data.tillDate = new Date(data.data.tillDate);
			   academyStore.load({
				   callback : function(record){
					   for(var i in record){
						   if(data.raw.academyLocation.id==record[i].data.id){
							   if(!isNullOrEmpty(record[i].data.ownership)) {
			                		whetherPrimeryField.setDisabled(true);
			                	} else {
			                		whetherPrimeryField.setDisabled(false);
			                	}
							   academyCombo.setValue(data.raw.academyLocation.id);
							   
							   var startDate=this$.getUserAcademyLocation().down("#startDate");
							   startDate.setMinValue(dateRender(record[i].data.academy.startDate));
							   startDate.setMaxValue(dateRender(record[i].data.academy.tillDate));

							   var tillDate=this$.getUserAcademyLocation().down("#tillDate");
							   tillDate.setMinValue(dateRender(record[i].data.academy.startDate));
							   tillDate.setMaxValue(dateRender(record[i].data.academy.tillDate));

							   break;
						   }
					   }
				   }
			   });
			   
			   form.getForm().setValues(data.raw);
               form.getForm().setValues({id: data.data.userAcadLocId});
               form.getForm().setValues({startDate: data.data.startDate});
               form.getForm().setValues({tillDate: data.data.tillDate});
		   }
	},
	
	/**
	 * This method is used to assign academy location to user.
	 */
	assignAcademyLocation:function(){
		var this$=this;
		var form = this.getAcademyLocationForm().getForm();
		
			var values = form.getValues();
			if(isNullOrEmpty(values.whetherPrimary)) {
				values.whetherPrimary=false;
			}
			var submitUrl;
			if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
				submitUrl = SERVERURL.UAL_SAVE;
			} else {
				submitUrl = SERVERURL.UAL_UPDATE;
			}
			var formData = Ext.encode(values);
			this$.applyWindowMask();
			Ext.Ajax.request({
				type: 'rest',
				url: submitUrl,
				jsonData: formData,
				method: 'POST',
				success: function(form, action) {
					this$.hideWindowMask();
					showSuccessMessage( getCommonTranslation('USER'),getCommonTranslation('SUCCESS'));
					this$.closeAcademyLocationForm();
					this$.relodeAccessRightTree();
				}
			});
	},
	/**
	 * This method is used to show role form if academy location is selected.
	 */
	showRoleForm:function(mode){
		//var gridTree = this.getAccessRightsTree();	
		var gridTree = this.getActiveTabfromContentPanel().down('accessrighttree');

		var flag=false;
		if(gridTree.getSelectionModel().getCount()>0){
			var record = gridTree.getSelectionModel().getSelection()[0];
			if( mode=='ADD' && record.get("userAcadLocId")){
				flag=true;
			}else if( mode=='EDIT' && record.get("role.roleName")){
				flag=true;
			}
		}
		if(flag){
			var formWindow = this.getAssignRole();	
			if (!formWindow) {
				Ext.widget('assignroleformwindow');
				formWindow = this.getAssignRole();
			}
			formWindow.show();
			var form = this.getAssignRoleForm().getForm();
			this.setUserId(form);
			var record = gridTree.getSelectionModel().getSelection()[0];
			var parentRecord = record.parentNode;
			
			if( mode=='ADD'){

				var startDate=this.getAssignRoleForm().down("#startDate");
				var tillDate=this.getAssignRoleForm().down("#tillDate");

				if(!isNullOrEmpty(record.data.startDate)){
					startDate.setMinValue(dateRender(record.data.startDate));
					tillDate.setMinValue(dateRender(record.data.startDate));
				}
				if(!isNullOrEmpty(record.data.tillDate)){
					startDate.setMaxValue(dateRender(record.data.tillDate));
					tillDate.setMaxValue(dateRender(record.data.tillDate));
				}
			}
			if( mode=='EDIT'){
				var startDate=this.getAssignRoleForm().down("#startDate");
				var tillDate=this.getAssignRoleForm().down("#tillDate");

				if(!isNullOrEmpty(parentRecord.data.startDate)){
					startDate.setMinValue(dateRender(parentRecord.data.startDate));
					tillDate.setMinValue(dateRender(parentRecord.data.startDate));
				}
				if(!isNullOrEmpty(parentRecord.data.tillDate)){
					startDate.setMaxValue(dateRender(parentRecord.data.tillDate));
					tillDate.setMaxValue(dateRender(parentRecord.data.tillDate));
				}
			}
				
				if( mode=='ADD'){
					form.setValues({userAcademyLocation: record.get("userAcadLocId")});
				}else if( mode=='EDIT'){
					form.setValues({userAcademyLocation:  parentRecord.data.userAcadLocId });
				}
		} else {
			showWarningMessage(getCommonTranslation('ASSIGN_ROLE'),  getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	closeRoleForm:function(){
		 this.getAssignRole().close();
	},
	/**
	 * This method is used to show Academy Location Form in edit mode.
	 * New window is created if not created and load data.
	 */
	editRoleForm:function(){
		//var gridTree = this.getAccessRightsTree();
		var gridTree = this.getActiveTabfromContentPanel().down('accessrighttree');
		if(gridTree.getSelectionModel().getCount()>0){
			 this.showRoleForm('EDIT');	
			 if(this.getAssignRoleForm()){
			  var records = gridTree.getSelectionModel().getSelection();
			  if (records != undefined && records != "" && records != null) {
				  if(!isNullOrEmpty(records[0].raw.startDate))
					  records[0].raw.startDate = new Date(records[0].raw.startDate);
				  if(!isNullOrEmpty(records[0].raw.tillDate))
					  records[0].raw.tillDate = new Date(records[0].raw.tillDate);
				  this.getAssignRoleForm().getForm().setValues(records[0].raw);
				  this.getAssignRoleForm().getForm().setValues({id: records[0].raw.userAcadLocRoleId});
			  }
			}	
		}
		else {
			showWarningMessage(getCommonTranslation('ASSIGN_ROLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}	
	},
	/**
	 * This method is used to assign academy location to user.
	 */
	assignAcademyLocation_role:function(){
		var this$=this;
		var userBasicDetails = this.getUserBasicDetails();
	    var basicForm = userBasicDetails.getForm();
	    var userValues = basicForm.getValues(); 
		
	    var form = this.getAssignRoleForm().getForm();
		var values = form.getValues();
		var facultyflag = true;
		if(values.role.id == 2) {
		 if(!userValues.whetherFaculty) {
			 facultyflag = false;
		 }
		}
		if(facultyflag) {
			var submitUrl;
		    if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
		        submitUrl = SERVERURL.UALR_CREATE;
		    } else {
		        submitUrl = SERVERURL.UALR_UPDATE;
		    }
		    var formData = Ext.encode(values);
		    this$.applyWindowMask(); 
		   
		    Ext.Ajax.request({
		        type: 'rest',
		        url: submitUrl,
		        jsonData: formData,
		        method: 'POST',
		        success: function(form, action) {
		        	this$.hideWindowMask();
		        	showSuccessMessage( getCommonTranslation('USER'),getCommonTranslation('SUCCESS'));
		        	this$.closeRoleForm();
		        	this$.relodeAccessRightTree();
		        }
		    });
		} else {
			this$.closeRoleForm();
			showWarningMessage(getCommonTranslation('ASSIGN_ROLE'),getUserModuleTranslation('FACULTY_ROLE_CANNOT_ASSIGNG_WITHOUT_FACULTY_PRIVILEGES'));
		}
	},
	
	relodeAccessRightTree: function(){
		//var gridTree = this.getAccessRightsTree();
		var gridTree = this.getActiveTabfromContentPanel().down('accessrighttree');
		gridTree.getStore().reload();
	},
	
	
	showPrivilegeForm: function(){
		var this$ = this;
		//var gridTree = this.getAccessRightsTree();
		var gridTree = this.getActiveTabfromContentPanel().down('accessrighttree');
		if(gridTree.getSelectionModel().getCount()>0){
			var record = gridTree.getSelectionModel().getSelection()[0];
			if( record.get("role")){
				 var formWindow = this.getUserPrivilegeGridWindow();	
			     if (!formWindow) {
			    	 Ext.widget('userPrivilegeGridWindow');
			         formWindow = this.	getUserPrivilegeGridWindow();
			     }
			     var  roleId= record.raw.role.id;
			     var url =  SERVERURL.ROLE_PORTAL_GET_PORTALS;
			     url = url.concat('?id=' + roleId),
			     Ext.Ajax.request({
			            type: 'rest',
			            method: 'GET',
			            async: true,
			            url: url,
			            success: function(response) {
			            	var data = Ext.decode(response.responseText);
			            	this$.setPortals(data);
			            	formWindow.show();
			            	var gridStore=this$.getUserPrivilegeGrid().getStore();
						     gridStore.getProxy().extraParams = {
						     		roleId: roleId
						     	};
						     gridStore.reload();
			            }
			        });
			} else {
				showWarningMessage(getCommonTranslation('ASSIGN_ROLE'),  getCommonTranslation('PLEASE_SELECT_RECORD'));
			}
		} else {
			showWarningMessage(getCommonTranslation('ASSIGN_ROLE'),  getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	closePrivilegeForm:function(){
		 this.getUserPrivilegeGridWindow().close();
	},
	
	saveOveridePrevilege:function(){
		var this$ = this;
		var records=this.getUserPrivilegeGrid().getStore().getUpdatedRecords();
		for(var i = 0 ; i < records.length ; i++){
			delete records[i].data.featureName;
		}
        //var accrssRightTree = this.getAccessRightsTree();
		var accrssRightTree = this.getActiveTabfromContentPanel().down('accessrighttree');
        var record = accrssRightTree.getSelectionModel().getSelection()[0];
        var userAcadLocRoleId = record.get("userAcadLocRoleId");

        var userPrivileges = new Array();
        Ext.each(records, function(obj) {
            userPrivileges.push(obj.data);
        });
        var updateRoleGridModel = new Object();
        updateRoleGridModel.userAcademyLocationRoleId=userAcadLocRoleId;
        updateRoleGridModel.userPrivileges=userPrivileges;
        this$.applyWindowMask(); 
        Ext.Ajax.request({
            type: 'rest',
            method: 'POST',
            url: SERVERURL.UALR_OVERRIDE_PRIVILEGE,
            jsonData: updateRoleGridModel,
            success: function() {
            	this$.hideWindowMask();
            	showSuccessMessage(getCommonTranslation('USER_ROLE_PRIVILEGE'),getCommonTranslation('SUCCESS'));
                this$.closePrivilegeForm();
            }
        });
        
	},
	
	assignProgram:function(){
		//var gridTree = this.getAccessRightsTree();
		var gridTree = this.getActiveTabfromContentPanel().down('accessrighttree');
		if(gridTree.getSelectionModel().getCount()>0){			
			var record = gridTree.getSelectionModel().getSelection()[0];
			 var userAcadId = record.get('userAcadLocId');
			if(userAcadId) {
			var acadName =  record.get('academy.value'); 
			var location =  record.get('location.value');
			var acadLocation = acadName + "  " + "-" + "  " + location;
			
			 var permissionType = record.get('programCoursePermissionType');
			
			var window = this.getAssignProgramWindow();
			if(!window){
				window = Ext.widget('assignprogramwindow');
			}
			window.down('#userAcademyLocationId').setValue(userAcadId);
			window.down('#acadNameId').setValue(acadLocation);
			//if(permissionType !=='NONE') {
				window.down('#programTypeSelector').setValue({'programType' :permissionType});
			// } 
				if(permissionType ==='SPECIFIC_PROGRAM_ALL_COURSE') {
				 var params = {
						 userAcademyLocationId : userAcadId
				 };
				 this.sendGetAjaxRequest(SERVERURL.FIND_SPECIFIC_PROGRAMS_FOR_USER,'GET',params,function(opt,success,response){
					 var programs = Ext.decode(response.responseText);
					 var programArray = new Array();
					 Ext.each(programs,function(program){
						 programArray.push(program.id);
					 });					
					 window.down('#programCombo').setValue(programArray);
				 });
			 }
			window.show();
			} else {
				showWarningMessage(getCommonTranslation('ASSIGN_PROGRAM'),  getCommonTranslation('PLEASE_SELECT_ACADEMY_LOCATION'));
			}
		} else{
			showWarningMessage(getCommonTranslation('ASSIGN_ROLE'),  getCommonTranslation('PLEASE_SELECT_RECORD'));
		}		
	},
	
	toggleProgramCourseTree:function(radio,newValue) {
		var panel = radio.up('window').down('treepanel');
		var combo = radio.up('window').down('combo');
		var acadName = radio.up('window').down('#acadNameId').getValue();
		var userAcadId = radio.up('window').down('#userAcademyLocationId').getValue();
		if(newValue.programType ==='SPECIFIC_PROGRAM_SPECIFIC_COURSE') {
			panel.setVisible(true);
			panel.setTitle(acadName);
			combo.setVisible(false);
			var store = panel.getStore();
			var params=new Object();
			params.userAcademyLocationId=userAcadId;
			params.programCoursePermissionType='SPECIFIC_PROGRAM_SPECIFIC_COURSE';
			store.load({
				params:params
			});
		} else if(newValue.programType ==='SPECIFIC_PROGRAM_ALL_COURSE'){
			combo.setVisible(true);
			combo.setDisabled(false);
			this.loadProgramCombo(combo,userAcadId);
			panel.setVisible(false);
		} else{
			panel.setVisible(false);
			combo.setVisible(false);
			combo.setDisabled(true);
		}
	},
	
	assignProgramCourses:function(button){
		var form = button.up('window').down('form');
		var values = form.getValues();
		var data = '';
		var me = this;
		var checkedNodes='';
		var tree = button.up('window').down('treepanel');
		if(values.programType ==='SPECIFIC_PROGRAM_SPECIFIC_COURSE') {
			 checkedNodes = tree.getView().getChecked();
		}
		data = this.createJsonForProgramCourses(values,checkedNodes);
		var submitData = Ext.encode(data);
		me.applyWindowMask(); 
		  
		this.sendSaveAjaxRequest(SERVERURL.SAVE_PROGRAM_COURSES_FOR_USER,'POST',submitData,function(opt,success,response){
			me.hideWindowMask();
			if(success) {
				showSuccessMessage(getCommonTranslation('PROGRAM_AND_COURSES'),getCommonTranslation('SUCCESS'));
				button.up('window').close();
				me.relodeAccessRightTree();
				/* var form = me.getUserBasicDetails();
				 var tab = form.up('panel');
				 me.closeTab(tab);*/
			}
		});
	},
	
	createJsonForProgramCourses:function(values,checkedNodes){
		var programObject = new Object();
		var programs = new Array();
		var courses = new Array();
		programObject.userAcademyLocationId = values.userAcademyLocationId;
		programObject.programCoursePermissionType = values.programType;
		if(!isEmpty(values.programs)) {
			Ext.each(values.programs,function(program){
				var programObj = new Object();
				if(program instanceof Object) {
					programObj.id = program.get('id');
					programs.push(programObj);
				} else {
					programObj.id =program;
					programs.push(programObj);
				}				
			});
		}
		if(!isNullOrEmpty(checkedNodes)) {
			Ext.each(checkedNodes,function(node){
				if(!node.get('leaf')){
					var program = new Object();
					var programId = node.get('id');
					var id = programId.substr(1,programId.length);
					program.id = id;
					var children = node.childNodes;
					if(!isEmpty(children)) {
						Ext.each(children,function(childNode){
							if(childNode.get('checked')){
								var courseIdInString = childNode.get('id');
								var splitArr = courseIdInString.split('//');
								var courseId = splitArr[1].substr(1, splitArr[1].length);
								courses.push(courseId);
								//courses.push(courseId.substr(1,courseId.length));
							}	
						});
						program.courseIds = courses;
						courses=[];
					}
					programs.push(program);
				} 
			});
			/*if(isEmpty(programs)) {
				Ext.each(checkedNodes,function(node){
					var childId =  node.get('id');
					var courseId = childId.substr(1,childId.length);
					var parentId = node.get('parentId');
					var programId = parentId.substr(1,parentId.length);
					var program = new Object();
					program.id = programId;
					courses.push(courseId);
					program.courseIds = courses;
				});
			}*/
			
		}
		programObject.programModels = programs;
		return programObject;
	},
	
	/**
	 * This method is used to unassign Academy Location.
	 */
	unassignAcademyLocation:function(){
		var $this = this;
		var userBasicDetails = this.getUserBasicDetails();
		var user = userBasicDetails.getValues();
		var userId = user.id;
		//var gridTree = this.getAccessRightsTree();
		var gridTree = this.getActiveTabfromContentPanel().down('accessrighttree');
		var record=gridTree.getSelectionModel().lastSelected;
		if(record == null){
			showWarningMessage(getCommonTranslation('UNASSIGN_ACADEMY_LOCATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
		else if(record!=null && record.data.userAcadLocRoleId == null){
			var selectedUserAcadLocId=record.data.userAcadLocId;
			if(record.data.whetherPrimary == true) {
				Ext.Ajax.request({
		            method: "GET",
		            type: 'rest',
		            url:SERVERURL.PATH_FIND_ASSOCIATED_AL_COUNT_BY_USER,
			        params: {
			        	id: userId
			        },
		            success: function(response) {
		            	if(response.responseText == '1') {
		            		$this.unAssignUserAcademyLocation(gridTree, selectedUserAcadLocId);
		            	} else {
		            		showWarningMessage(getCommonTranslation('UNASSIGN_ACADEMY_LOCATION'), getCommonTranslation('USER_UNASSIGN_ACADEMY_LOCATION'));
		            	}
		            }
		        });
			} else {
				this.unAssignUserAcademyLocation(gridTree, selectedUserAcadLocId);
			}
			/*Ext.Ajax.request({
	            method: "DELETE",
	            type: 'rest',
	            url:SERVERURL.UAL_DELETE,
		        params: {
		        	userAcadLocId: selectedUserAcadLocId
		        },
	            success: function(response) {
	            	showSuccessMessage(getCommonTranslation('UNASSIGN_ACADEMY_LOCATION'), getCommonTranslation('SUCCESS'));
	            	gridTree.getSelectionModel().deselectAll(true);
	            	gridTree.getStore().reload();
	            	gridTree.getSelectionModel().select(0, true);
	            }
	        });*/
		}
		else {
			showWarningMessage(getCommonTranslation('UNASSIGN_ACADEMY_LOCATION'), getCommonTranslation('PLEASE_SELECT_PARENT_RECORD'));
		}	
	},
	
	/**
	 * This method is used to unassign Academy Location Role.
	 */
	unassignAcademyLocation_role:function(){
		//var gridTree = this.getAccessRightsTree();
		var gridTree = this.getActiveTabfromContentPanel().down('accessrighttree');
		var record=gridTree.getSelectionModel().lastSelected;
		if(record!=null && record.data.userAcadLocRoleId !=null){
			var selecteduserAcadLocRoleId=record.data.userAcadLocRoleId;
			Ext.Ajax.request({
	            method: "DELETE",
	            type: 'rest',
	            url:SERVERURL.UALR_DELETE,
		        params: {
		        	userAcadLocRoleId: selecteduserAcadLocRoleId
		        },
	            success: function(response) {
	            	showSuccessMessage(getCommonTranslation('UNASSIGN_ACADEMY_LOCATION_ROLE'), getCommonTranslation('SUCCESS'));
	            	gridTree.getSelectionModel().deselectAll(true);
	            	gridTree.getStore().reload();
	            	gridTree.getSelectionModel().select(0, true);
	            }
			 });
		}
		else {
			showWarningMessage(getCommonTranslation('UNASSIGN_ACADEMY_LOCATION_ROLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}	
	},
	/**
	 * This method is used to find user id.
	 */
	setUserId:function(form){
		var userId=this.getUserId(form);
		return form.setValues({userId: userId});
	},
	/**
	 * This method is used to find user id.
	 */
	getUserId:function(form){
		return this.getUserBasicDetails().up().getForm().findField('userId').getSubmitValue();
	},
	
	
	getIdFromNestedObject: function(object, field) {
		if (object && object[field] && object[field].hasOwnProperty('id')) {
			return object[field]["id"];
	    }
	},
	
	/**
	 * This method will show the selected user record into view mode. 
	 */
	viewUserRecord: function() {
		this.editFormWindow(true);
		var contentPanel = this.getContentPanelActiveTab();
		var form = contentPanel.down("userbasicdetails");
		form.up().down('accessrighttree').getDockedItems('toolbar[dock="top"]')[0].hide();
		var buttons = form.up().down('userbasicdetails').query('button');
		Ext.each(buttons, function(button) {
			button.hide();
		});
		var getForm = form.getForm();
		toggleReadOnlyFormItems(getForm, true);
	},
	
	/**
	 * This method will delete the selected user record into view mode. 
	 */
	deleteUserRecord: function() {
		var grid=this.getSearchResultGrid();
		var record=grid.getSelectionModel().selected.items[0];
		if(record!=null && record.data.USER_ID !=null){
			
			showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                	var selecteduserId=record.data.USER_ID;
        			var url = SERVERURL.USER_DELETE;
        			url = url.concat('/'+selecteduserId);
        			Ext.Ajax.request({
        	            method: "DELETE",
        	            type: 'rest',
        	            url:url,
        	            success: function(response) {
        	            	showSuccessMessage(getCommonTranslation('DELETE_USER'), getCommonTranslation('SUCCESS'));
        	            	grid.getSelectionModel().deselectAll(true);
        	            	grid.getStore().reload();
        	            	grid.getSelectionModel().select(0, true);
        	            }
        			 });
                }
            });
		}
		else {
			showWarningMessage(getCommonTranslation('DELETE_USER'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}	
	},
	
	/**
	 * method added after removing the ref,
	 * returns form
	 */
	getUserBasicDetails: function(tabTitle) {
		var menuController =  this.getMenuController();	
		var tabRef;
		tabRef = menuController.getTab(tabTitle);
		return tabRef.down('form');
	},
	
	saveUserPhotoUpload : function(formValue){
    	var this$ = this;
    	//var userProfile = this$.getContentPanelActiveTab();
    	var userBasicDetail = this$.getWinUserBasicDetails();
    	var personId = userBasicDetail.down("#personId");
    	var userPhotoUploadForm = userBasicDetail.down('#photoFileImage');
       	this$.savePersonPhotoUpload(userPhotoUploadForm, personId.getValue() ,SERVERURL.PERSON_IMAGE_UPLOAD, SERVERURL.PERSON_IMAGE_DOWNLOAD);
      /* 	, function(success){
    		if(success){
    			this$.onRenderUserPersonalInformationForm();
    		}
    		
    	});*/
    	
    },
    getContentPanelActiveTab: function() {
    	var this$ = this;
        var personProfile = null;
        var controller = this$.getController('Academia.controller.personinfo.common.PersonCommonController');
        var contentPanel = controller.getContentPanel();
        if (contentPanel) {
            personProfile = contentPanel.getActiveTab();
        }
        return personProfile;
    },
    onRenderUserPersonalInformationForm : function(){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var userId = personProfile.getUserId();
        if (!isNullOrEmpty(userId)) {
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        	var url = SERVERURL.STUDENT_PERSONAL_INFORMATION_BY_ID + userId;
        	this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
        		Ext.getBody().unmask();
        		if(success){
        			var data = Ext.decode(response.responseText);
                    if(!isEmpty(data)){
                    	this$.setValueToPersonalInformationForm(data);
                    }
        		}
        		
        	});
        }
    },
    savePersonPhotoUpload: function(currentForm, personId ,uplaodUrl, callback) {
    	var this$ = this;
        var fileUploadPath = currentForm.getValues();
        if (!isNullOrEmpty(fileUploadPath)) {
        	currentForm.getForm().submit({
                method: 'POST',
                url: uplaodUrl,
                params: {
                    personId: personId
                },
                success: function(response, action) {
                	//this$.getDownLoad();
                	/* Fix user update issue while uploading photo */
                	var resData = Ext.decode(action.response.responseText);	
                	var form = this$.getUserBasicDetails();
            		form.down('#personVersion').setValue(resData.version);
            		Ext.getBody().unmask();
            		var tab = form.up('panel');
            		this$.closeTab(tab);
            		showSuccessMessage( getCommonTranslation('USER'),getCommonTranslation('USER_UPDATE_SUCCESS'));
                }
            });
       /* }else{
        	callback(null, null, true);
        }*/
        
        
        }

    },
    
    getDownLoad : function(data){
    	//var activeTab = Ext.getCmp('userdetails').getActiveTab(); // Get the active tab
        //var userBasicDetail = activeTab ? activeTab.down("#winUserBasicDetails") : null; // Ensure correct component reference

    	//var userBasicDetail = this.getWinUserBasicDetails();
    	var userBasicDetail = this.getContentPanelActiveTab();
    	var image = userBasicDetail.down("#profile_image");
    	var personId = userBasicDetail.down("#personId").getValue();
    	
    	var userType = "FACULTY";
    	Ext.Ajax.request({type: 'rest',binary: true,url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+personId+'&userType='+userType+'&isDefaultImageRequired=false',
			  method: 'GET',success : function(res){
				  if(res.responseBytes.length>0){
					  var blob = new Blob([res.responseBytes], {type: 'image/jpg'});
					  var url = window.URL.createObjectURL(blob);
					  image.getEl().dom.src=url;
				  }
				  else{
						Ext.defer(function () {
							var a=userBasicDetail.down("#profile_image");
							 var newImgUrl = generateInitialsImage(
								 	data.firstName, 
									 data.middleName, 
									 data.lastName 
									);

							a.setVisible(true);
							if (a.rendered && a.getEl()) { 
								a.getEl().dom.src = newImgUrl;
							}
						}, 3000);
					}
			  }
  	});
    },
	
	/**
	 * method added after removing the ref,
	 * returns form
	 */
	getUserDetails: function(tabTitle) {
		var menuController =  this.getMenuController();	
		var tabRef = menuController.getTab(tabTitle);
		return tabRef;
	},
	getMenuController:function(){
		return  Academia.app.getController('menu.CoreERPNavigationController');
	},
	
	savePasswordPolicy:function(button) {
		var this$=this;
		var form = button.up('form');
		var values = form.getValues();
		var requestMethod = '';
		
		if(parseInt(values.maxLength)<parseInt(values.minLength)){
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PASSWORD_POLICY_MAX_MIN_PASSWORD_LENGTH_MSG'));
			return;
		}
		if(isNullOrEmpty(values.id)) {
			requestMethod = 'POST';
		} else{
			requestMethod = 'PUT';
		}
		var submitData = Ext.encode(values);
		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		 
		this.sendSaveAjaxRequest(SERVERURL.SAVE_USER_PASSWORD_POLICY,requestMethod,submitData,function(opt,success,response){
			Ext.getBody().unmask();
			if(success) {
				this$.loadPasswordPolicy(form);
				showSuccessMessage(getCommonTranslation('USER_PASSWORD_POLICY'), getCommonTranslation('SUCCESS'));
			}
		});
	},	

	loadPasswordPolicy:function(form) {
		this.sendGetAjaxRequest(SERVERURL.SAVE_USER_PASSWORD_POLICY,'GET',null,function(opt,success,response){
			if(success) {
				if(!isEmpty(response)) {
					var data = Ext.decode(response.responseText);
					form.getForm().setValues(data);
				}				
			}
		});
	},
	
	
	loadProgramCombo:function(combo,userAcadId) {
		var store = combo.getStore();
		store.load({
			params:{
				userAcademyLocationId:userAcadId
			}
		});
	},
	/**
	 * This method is used to cancel update user record form.
	 * 
	 */
	cancelUpdateUser: function() {
       // this.getWinUserBasicDetails().close();
        var form = this.getUserBasicDetails();
		 var tab = form.up('panel');
		 this.closeTab(tab);
    },
    /**
	 * SET the print name value when user entered first middle and lastname.
	 * 
	 */
    setPrintNameValue:function(){
    	var form = this.getUserBasicDetails();
    	var firstName = form.down('#firstName').getValue();
    	var middleName = form.down('#middleName').getValue();
    	var lastName = form.down('#lastName').getValue();
    	
    	var printName=null;
    	if(isNullOrEmpty(middleName)){
    		printName =firstName+" "+lastName;
    	}else{
    		printName =firstName+" "+middleName+" "+lastName ;
    	}
    	form.down('#printName').setValue(printName.trim());
    	form.down('#shortName').setValue(printName.trim());
    },
    setPrintNameValueOther:function(){
    	var form = this.getUserBasicDetails();
    	var firstName = form.down('#firstNameOtherLnguageId').getValue();
    	var middleName = form.down('#middleNameOtherLnguageId').getValue();
    	var lastName = form.down('#lastNameOtherLnguageId').getValue();
    	
    	var printName=null;
    	if(isNullOrEmpty(middleName)){
    		printName =firstName+" "+lastName;
    	}else{
    		printName =firstName+" "+middleName+" "+lastName ;
    	}
    	form.down('#printNameOtherLnguageId').setValue(printName.trim());
    	form.down('#shortNameOtherLnguageId').setValue(printName.trim());
    },
    /**
     * Open passwordRest window for admin 
     */
    openResetPasswordWindow:function(){
    	/*var $this=this;
        var formWindow = $this.getAdminresetpasswordwindow();	
 	      if (!formWindow) {
 	         Ext.widget('adminresetpasswordwindow');
 	         formWindow = $this.getAdminresetpasswordwindow();
 	      }
 	     formWindow.show();*/
 	     
 	    var resetPswrdWindowItemId ="userlistadminresetpasswordwindow";
        var resetPswrdFormWindow = Ext.widget('adminresetpasswordwindow', {
             itemId: resetPswrdWindowItemId
         });
        resetPswrdFormWindow.show();  
        var quickSearchForm=this.getQuickSearchForm();
        var resetPasswordFilterform = resetPswrdFormWindow.down('form');
        var resetpasswordfield = resetPasswordFilterform.getForm().findField('resetPasswordFilterdata');
        resetpasswordfield.setValue(quickSearchForm.getValues());
    },
    
    /**
     * 
     *Check and Change password by admin. 
     */
    changePasswordByAdmin:function(button){
    	var this$ = this;
    	var grid = this.getSearchResultGrid();
    	var gridRec=grid.getSelectionModel().getSelection();
    	var window=button.up('window');
    	var form=button.up('form').getForm();
		var formValues=form.getValues();
		var pswrdurl = SERVERURL.CHANGE_PASSWORD_BY_ADMIN;
		var userIdsArray = [];
		var data;
		if(gridRec.length == 1){
			if(isNullOrEmpty(gridRec[0].data.USER_ID)){
				var data={
						"userId":gridRec[0].raw.USER_ID,
						"newPassword":this$.encryptPassword(formValues.confirmedPassword),
					    "isResetPassword":true
				};
			}
			else{
				var data={
						"userId":gridRec[0].data.USER_ID,
						"newPassword":this$.encryptPassword(formValues.confirmedPassword),
						 "isResetPassword":true
				};
			}

		}
		else if( gridRec.length > 1){
			for( var i = 0; i < gridRec.length; i++) {
				if(isNullOrEmpty(gridRec[i].data.USER_ID)){
					userIdsArray.push(gridRec[i].raw.USER_ID);
				}
				else{
					userIdsArray.push(gridRec[i].data.USER_ID);
				}
			}
			var data={
					"userIds":userIdsArray.join(),
					"newPassword":this$.encryptPassword(formValues.confirmedPassword),
					 "isResetPassword":true
			};
		}
		if(!isNullOrEmpty(grid.config.searchFilterForm)){
			var searchForm = grid.config.searchFilterForm.getForm();
			searchForm.getFields().each(function(field) {
				if(gridRec.length == 1){
					if(isNullOrEmpty(gridRec[0].data.USER_ID)){
						if(field.itemId =='user_id' && !isNullOrEmpty(field.getValue())){
							data.filterUserId = gridRec[0].data.USER_ID;
						}
					}
				}
				if(field.itemId =='user_name' && !isNullOrEmpty(field.getValue())){
					data.userCode = field.getValue();
				}
				if(field.itemId =='userType' && !isNullOrEmpty(field.getValue())){
					data.userGroupId = field.getValue();
				}
				if(field.itemId =='userRole' && !isNullOrEmpty(field.getValue())){
					data.roleId = field.getValue();
				}
				if(field.itemId =='cmbDepartment' && !isNullOrEmpty(field.getValue())){
					data.departmentId = field.getValue();
				}
				if(field.itemId =='getSubDepartmentId' && !isNullOrEmpty(field.getValue())){
					data.subDepartmentId = field.getValue();
				}
				if(field.itemId =='gender' && !isNullOrEmpty(field.getValue())){
					data.genderId = field.getValue();
				}
				if(field.itemId =='academyLocationCombo' && !isNullOrEmpty(field.getValue())){
					data.academyLocationId = field.getValue();
				}
				if(field.itemId =='users_without_AL' && !isNullOrEmpty(field.getValue())){
					data.isWithoutAcademyLocation = field.getValue();
				}
				if(field.itemId =='whether_deleted' && !isNullOrEmpty(field.getValue())){
					data.whetherDeleted = field.getValue();
				}
			});	
		}
		data.isSimilar = grid.config.isSimilar;
		
		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DO_YOU_WANT_TO_CONFIRM_CHANGE_PASSWORD_MSG'),
				function(btn, text) {
			if (btn == 'yes'){
				this$.applyWindowMask();
				//showSuccessMessage(getCommonTranslation('RESET_PASSWORD'),getCommonTranslation('TRANSACTION_IN_PROGRESS_RESETPASSWORD_MSG'));   V2D-328087
				window.close();
				Ext.Ajax.request({
					method: "POST",
					type: 'rest',
					url:pswrdurl,
					jsonData:data,
					success: function(response) {
						this$.hideWindowMask();
						var mssg = response.responseText;
						if (mssg == "SUCCESS") {
							window.close();
							showSuccessMessage(getCommonTranslation('RESET_PASSWORD'),getCommonTranslation('ADMIN_PASSWORD_CHANGE_MSG'));
						}else if(mssg == "USER_LOCKED"){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_LOCKED_MSG'));
						}else if(mssg.includes("PASSWORD_IN_USE")){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PASSWORD_IN_USE'));
						}else{
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_NOT_FOUND_MSG'));
						}
					}
				});
			}
		});
		
		/*if( gridRec.length > 0){
			for( var i = 0; i < gridRec.length; i++) {
		var data={
				  "userId":gridRec[i].data.USER_ID,
				  "newPassword":formValues.confirmedPassword
				};
			}
			
			Ext.Ajax.request({
	            method: "POST",
	            type: 'rest',
	            url:pswrdurl,
	            jsonData:data,
	            success: function(response) {
	            	var mssg = response.responseText;
					if (mssg == "SUCCESS") {
					    window.close();
	            	    showSuccessMessage(getCommonTranslation('RESET_PASSWORD'),getCommonTranslation('ADMIN_PASSWORD_CHANGE_MSG'));
					}else if(mssg == "USER_LOCKED"){
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_LOCKED_MSG'));
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_NOT_FOUND_MSG'));
					}
	            }
			});
		}*/
					
				/*}
            }
		 });*/
    },
    
    /**
     * This function is load protal combo in privilege grid in user profile
     */
    loadPortalStore:function(params) {
    	var portalIds = new Array();
    	Ext.each(params, function(portalId) {
    		portalIds.push(portalId.id)
    	});
   	 var privilegeGrid = this.getUserPrivilegeGrid();
        var combo =  privilegeGrid.down('#comboPortal');
   	combo.getStore().load({
   		params:{
   			portalIds:portalIds
   		}
   	});
   },
   
   /**
    * This function is used to load AL combo based on user 
    */
   loadAcadLocComboByUser:function(combo){
	   var store = combo.getStore();
	   var url = SERVERURL.FIND_ALL_ACADEMY_LOCATION_OBJECT_BY_USER;
//	   var id = this.getSelectedUser();
	   var  currentAL= this.getCurrentAcademyLocation();
	   var loggedInUser = this.getCurrentlyLoggedInUser();
	   var id = loggedInUser.id;
	   url = url.concat('?id='+ id + '&academyLocationId=' + currentAL);
	   store.getProxy().api.read = url;
       store.reload();
             
       
   },
    //******************Disable reset password button**********************************
disableMoreActionPivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	buttonsToolBar = gridReference.query('toolbar')[0];
    	
    	/*var activateButton = grid.down('#activateButtonItemId');
    	activateButton.setVisible(false);
    	var splitbuttons = grid.down('#spBtnMoreActions');
    	splitbuttons.setVisible(false);*/
    	
    	var sendMessageBtn = grid.down('#sendMessageBtn');
    	sendMessageBtn.setVisible(false);
    	var resetButton = grid.down('#resetButtonItemId');
    	resetButton.setVisible(false);
    	var enableDisableBtn = grid.down('#enableDisableBtn');
    	enableDisableBtn.setVisible(false);
    	var alfrescoButton = grid.down('#createUserInAlfresco');
        alfrescoButton.setVisible(false);
        var selectSimilarBtn = grid.down('#selectSimilarRecords');
        selectSimilarBtn.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		/*if (privilege === 'RESETPASSWORD') {
        		var button = buttonsToolBar.query('#resetButtonItemId')[0];
        		if(!isNullOrEmpty(button)){
        			resetButton.setVisible(true);
        		}        		
        	}*/
    		if (privilege === 'ACTIVATEUSER') {
        		var button = buttonsToolBar.query('#activateButtonItemId')[0];
        		if(!isNullOrEmpty(button)){
        			activateButton.setVisible(true);
        		}        		
        	}
    		/*if (privilege === 'MOREACTIONS') {
        		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
        		if(!isNullOrEmpty(button)){
        			splitbuttons.setVisible(true);
        		}        		
        	}*/
    		if (privilege === 'SEND_MESSAGE') {
        		if(!isNullOrEmpty(sendMessageBtn)){
        			sendMessageBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'RESETPASSWORD') {
        		if(!isNullOrEmpty(resetButton)){
        			resetButton.setVisible(true);
        		}        		
        	}
    		if (privilege === 'MAKE_ACTIVE') {
        		if(!isNullOrEmpty(enableDisableBtn)){
        			enableDisableBtn.setVisible(true);
        		}        		
        	}
        	if (privilege === 'CREATE_USER_IN_ALFRESCO') {
    	        if(!isNullOrEmpty(alfrescoButton)){
    	        alfrescoButton.setVisible(true);
    	        }        
    	    }
        	if (privilege === 'SELECT_SIMILAR_RECORDS') {
    	        if(!isNullOrEmpty(selectSimilarBtn)){
    	        	selectSimilarBtn.setVisible(true);
    	        }        
    	    }
    	});
    },
    
    
    /******
     * User whether faculty hide/show functionality by user group
     */
    
    hideOrShowWeatherFaculty:function(userGroupName) {
    	//var form = this.getWinUserBasicDetails();
	    var form = this.getActiveTabfromContentPanel().down('userbasicdetails');
    	if(userGroupName == getCommonTranslation('OTHER_EMPLOYEE')){
	    	
	    	/*form.down('#employeeTypeId').setVisible(true);
	    	form.down('#employeeTypeId').allowBlank = false;
	    	
	    	form.down('#facultyTypeId').setVisible(false);
	    	form.down('#facultyTypeId').allowBlank = true;*/
	    	
	    	form.down('#whetherFacultyId').setVisible(false);
	    	form.down('#whetherFacultyId').setValue(false);
	    	
	    	//form.down('#whetherLeaveApplicableId').setVisible(true);
	    	
	    } else if(userGroupName == getCommonTranslation('FACULTY')) {
	    	
	    	/*form.down('#facultyTypeId').setVisible(true);
	    	form.down('#facultyTypeId').allowBlank = false;
	    	
	    	form.down('#employeeTypeId').setVisible(false);
	    	form.down('#employeeTypeId').allowBlank = true;
	    	form.down('#employeeTypeId').reset();*/
	    	
	    	form.down('#whetherFacultyId').setVisible(false);
	    	form.down('#whetherFacultyId').setValue(true);
	    	
	    	form.down('#whetherLeaveApplicableId').setVisible(true);
	    } else {
	    	
	    	/*form.down('#employeeTypeId').setVisible(false);
	    	form.down('#employeeTypeId').allowBlank = true;
	    	form.down('#employeeTypeId').reset();
	    	form.down('#facultyTypeId').setVisible(false);
	    	form.down('#facultyTypeId').allowBlank = true;*/
	    	
	    	form.down('#whetherFacultyId').setVisible(true);
	    }
    	
    	var valid = form.isValid();
    	if(!valid) {
    		form.down('#submitBtn').setDisabled(true);
    	}
    },
    
    /**
     * This is used to disable extra buttons on serach result grid
     */
    disableExtraButton:function(column,selected) {
    	var grid = this.getSearchResultGrid();
    	var resetButtonItemId = grid.down('#resetButtonItemId');
    	if(selected.length== 1){ // enable
    		resetButtonItemId.setDisabled(false);
    	}else{  // disable
    		resetButtonItemId.setDisabled(true);
    	}
    },
    
    cellClickUserSearchResultGrid: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var this$ = this;
        //var searchResultGrid = this$.getSearchResultGrid();
        var columnName = view.getGridColumns()[cellIndex].dataIndex;
        var userId;
        if(columnName== "ROLE") {
        	userId = record.get('USER_ID');        
	        
        	var formWindow = this$.getAcademylocationrolegridwindow();
	      	if (!formWindow) {
	      		 Ext.widget('academylocationrolegridwindow');
	      		 formWindow = this$.getAcademylocationrolegridwindow();
	      	 }
	      	 //var bindingStore = this.getStore('securitysetup.AcademyLocationByRoleStore');
	      	 var listGrid=formWindow.down('#academyLocationRoleGridId');
	         //var paginationStore = listGrid.getDockedItems()[1].items.items[0];
	      	 //listGrid.bindStore(bindingStore);
	      	 //paginationStore.bindStore(bindingStore);
	      	 var store = listGrid.getStore();
	      	 this$.resetPageSetting(store);
	      	 store.getProxy().extraParams = {
	      		 userId:userId
	      	 };
	      	 store.load();
	      	 
	      	 formWindow.show();
        }
    },
    
    disableUserImportUtility: function(structure, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        var userBulkImportTab = false,
            userRoleBulkImportTab = false,
            userUpdateBulkImportTab = false;

        for (var i = 0; i < permissionList.length; i++) {
            if (permissionList[i] === "IMPORT_BULK_USERS") {
                userBulkImportTab = true;
            }
            else if (permissionList[i] === "IMPORT_BULK_USER_ROLE") {
                userRoleBulkImportTab = true;
            }
            else if (permissionList[i] === "IMPORT_BULK_USER_UPDATE") {
            	userUpdateBulkImportTab = true;
            }
        }
        this.showUserImportUtilityTab(userBulkImportTab, userRoleBulkImportTab, structure, userUpdateBulkImportTab);
    },

    showUserImportUtilityTab: function(userBulkImportTab, userRoleBulkImportTab, structure, userUpdateBulkImportTab) {
        var panelItem = new Array();
        var $this = this;
        var newcont = structure.items.items.length;
        var insertPosition = newcont + 1;
        
        panelItem.push({
            xtype: 'tabpanel',
            itemId: 'allVisibleTP',
            plain: true,
            style: {
                overflow: 'hidden !important',
                margin: '0!important'
            },
            bodyStyle: {
                margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
            },
            frame: false,
            border: false,
            defaults: {
                labelAlign: 'top'
            },
            items: [{
                xtype: 'userquicksearch',
                title: getCommonTranslation('QUICK_SEARCH'),
                tabCls: 'right-tab',
                listeners: {
                	activate: function(me, eOpts){
                		var  contentPanelMain = $this.getContentPanel().getActiveTab();
                		setTimeout(function(){
                			contentPanelMain.scrollBy(0,2);
                			contentPanelMain.scrollBy(0,-2);
                		},50);
                	}
                }
            }, {
                xtype: 'advancedsearchquerybuilder',
                searchConfigCode: CONSTANTS.CB.USERLISTCONFIGCODE,
                searchResultViewCode: CONSTANTS.CB.USERLISTVIEWCODE,
                permissionMapKey: "USER_MANAGEMENT",
                gridTitle: getCommonTranslation("USER_LIST"),
                tabCls: 'right-tab'
            }]
        });
        var insertAt = panelItem["0"].items.length;
        if (userBulkImportTab){
        	panelItem["0"].items[insertAt] = {
        			xtype: 'useruploaddownloadstructure',
        			title: getCommonTranslation('IMPORT_USERS')

        	};
        	insertAt = insertAt + 1;
        }
        if (userRoleBulkImportTab){
        	panelItem["0"].items[insertAt] = {
        			xtype: 'userroleuploaddownloadstructure',
        			title: getCommonTranslation('IMPORT_USER_ROLE')

        	};
        	insertAt = insertAt + 1;
        }
        if (userUpdateBulkImportTab){
        	panelItem["0"].items[insertAt] = {
        			xtype: 'userupdateuploaddownloadstructure',
        			title: getCommonTranslation('IMPORT_USER_UPDATE')

        	};
        	insertAt = insertAt + 1;
        }
        structure.insert(insertPosition, panelItem);
        /*if (userBulkImportTab && userRoleBulkImportTab) {
            panelItem.push({
                xtype: 'tabpanel',
                itemId: 'allVisibleTP',
                plain: true,
                style: {
                    overflow: 'hidden !important',
                    margin: '0!important'
                },
                bodyStyle: {
                    margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
                },
                frame: false,
                border: false,
                defaults: {
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'userquicksearch',
                    title: getCommonTranslation('QUICK_SEARCH'),
                    tabCls: 'right-tab'
                }, {
                    xtype: 'advancedsearchquerybuilder',
                    searchConfigCode: CONSTANTS.CB.USERLISTCONFIGCODE,
                    searchResultViewCode: CONSTANTS.CB.USERLISTVIEWCODE,
                    permissionMapKey: "USER_MANAGEMENT",
                    gridTitle: getCommonTranslation("USER_LIST"),
                    tabCls: 'right-tab'
                }, {
                    xtype: 'useruploaddownloadstructure',
                    title: getCommonTranslation('IMPORT_USERS'),
                }, {
                    xtype: 'userroleuploaddownloadstructure',
                    title: getCommonTranslation('IMPORT_USER_ROLE'),
                }, {
                    xtype: 'userupdateuploaddownloadstructure',
                    title: getCommonTranslation('IMPORT_USER_UPDATE'),
                }]
            });

        } else if (userBulkImportTab) {
            panelItem.push({
                xtype: 'tabpanel',
                itemId: 'allVisibleTP',
                plain: true,
                style: {
                    overflow: 'hidden !important',
                    margin: '0!important'
                },
                bodyStyle: {
                    margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
                },
                frame: false,
                border: false,
                defaults: {
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'userquicksearch',
                    title: getCommonTranslation('QUICK_SEARCH'),
                    tabCls: 'right-tab'
                }, {
                    xtype: 'advancedsearchquerybuilder',
                    searchConfigCode: CONSTANTS.CB.USERLISTCONFIGCODE,
                    searchResultViewCode: CONSTANTS.CB.USERLISTVIEWCODE,
                    permissionMapKey: "USER_MANAGEMENT",
                    gridTitle: getCommonTranslation("USER_LIST"),
                    tabCls: 'right-tab'
                }, {
                    xtype: 'useruploaddownloadstructure',
                    title: getCommonTranslation('IMPORT_USERS'),
                }, {
                    xtype: 'userupdateuploaddownloadstructure',
                    title: getCommonTranslation('IMPORT_USER_UPDATE'),
                }]
            });

        } else if (userRoleBulkImportTab) {
            panelItem.push({
                xtype: 'tabpanel',
                itemId: 'allVisibleTP',
                plain: true,
                style: {
                    overflow: 'hidden !important',
                    margin: '0!important'
                },
                bodyStyle: {
                    margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
                },
                frame: false,
                border: false,
                defaults: {
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'userquicksearch',
                    title: getCommonTranslation('QUICK_SEARCH'),
                    tabCls: 'right-tab'
                }, {
                    xtype: 'advancedsearchquerybuilder',
                    searchConfigCode: CONSTANTS.CB.USERLISTCONFIGCODE,
                    searchResultViewCode: CONSTANTS.CB.USERLISTVIEWCODE,
                    permissionMapKey: "USER_MANAGEMENT",
                    gridTitle: getCommonTranslation("USER_LIST"),
                    tabCls: 'right-tab'
                }, {
                    xtype: 'userroleuploaddownloadstructure',
                    title: getCommonTranslation('IMPORT_USER_ROLE'),
                }, {
                    xtype: 'userupdateuploaddownloadstructure',
                    title: getCommonTranslation('IMPORT_USER_UPDATE'),
                }]
            });

        } else {
            panelItem.push({
                xtype: 'tabpanel',
                itemId: 'allVisibleTP',
                plain: true,
                style: {
                    overflow: 'hidden !important',
                    margin: '0!important'
                },
                bodyStyle: {
                    margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
                },
                frame: false,
                border: false,
                defaults: {
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'userquicksearch',
                    title: getCommonTranslation('QUICK_SEARCH'),
                    tabCls: 'right-tab'
                }, {
                    xtype: 'advancedsearchquerybuilder',
                    searchConfigCode: CONSTANTS.CB.USERLISTCONFIGCODE,
                    searchResultViewCode: CONSTANTS.CB.USERLISTVIEWCODE,
                    permissionMapKey: "USER_MANAGEMENT",
                    gridTitle: getCommonTranslation("USER_LIST"),
                    tabCls: 'right-tab'
                }, {
                    xtype: 'userupdateuploaddownloadstructure',
                    title: getCommonTranslation('IMPORT_USER_UPDATE'),
                }]
            });

        }*/
    },
    selectSectionMessageType : function(val,nV,oV){

   	 var $this =  this;
   	 var formWin = $this.getUserssendmessage();
   	  formWin.down("#templatedItemId").hide();
      formWin.down("#templatedItemId").allowBlank=true;

   	 //var value = nV.1;
   	 if(nV.messageType==2){
   		 formWin.down("#messageId").hide();
   		 formWin.down("#selectTemplate").allowBlank=true;
   		 formWin.down("#selectTemplate").setVisible(false);     		 
   		 formWin.down("#messageName").allowBlank=true;   
   		 formWin.down("#messageName").setVisible(false);
   		 formWin.down("#msgTempletId").setVisible(true);
   		 formWin.down("#msgTempletId").allowBlank=false;
   		 formWin.down("#msgTempletId").reset();
   		 formWin.down("#subject").setVisible(true);
   		 formWin.down("#subject").allowBlank=false;
   		 formWin.down("#subject").reset();
   		 formWin.down("#discriptionId").setVisible(true);
   		 formWin.down("#discriptionId").reset();
   		 formWin.down('#smsDiscription').reset();
   		 formWin.down('#smsDiscription').hide();
   		 formWin.down('#smsDiscriptionNotice').hide();
   		 formWin.down('#pushNotificationDiscription').hide();
		 formWin.down('#pushNotificationDiscriptionNotice').hide();
		 formWin.down('#fldSendToContainer').show();
   	 }else{
   		 formWin.down("#msgTempletId").allowBlank=true;
   		 formWin.down("#msgTempletId").setVisible(false);     		
   		 formWin.down("#messageId").setVisible(true);
   		 formWin.down("#selectTemplate").setVisible(true);     		
   		 formWin.down("#messageName").setVisible(true);
   		 formWin.down("#messageName").reset();
   		 formWin.down("#subject").allowBlank=true;
   		 formWin.down("#subject").setVisible(false);
   		 formWin.down("#discriptionId").setVisible(false);
   		 formWin.down("#messageName").allowBlank=false;  
   		 formWin.down("#selectTemplate").allowBlank=false;
   		 formWin.down("#selectTemplate").reset();
   		 formWin.down("#usersDocumentMessageAttachmentGrid").setVisible(false);
   		 formWin.down("#staticUploadFileField").setVisible(false);
   		 formWin.down('#smsDiscription').reset();
   		 formWin.down('#smsDiscription').hide();
   		 formWin.down('#smsDiscriptionNotice').hide();
   		 formWin.down('#pushNotificationDiscription').hide();
		 formWin.down('#pushNotificationDiscriptionNotice').hide();
   		 var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
   		 formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
   		 formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
   		 formWin.down('#fldSendToContainer').hide();
   	 }
   	formWin.getForm().checkValidity();
    },
    selectUserMessageTemp: function(obj,rec){
	       	 var $this =  this;
	       	 var formWin = $this.getUserssendmessage();
	       	 var subject = formWin.down('#subject');
	       	 var smsDiscription = formWin.down('#smsDiscription');
     		 var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
     		 var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
     		 var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
     		 formWin.down("#templatedItemId").hide();
 		 formWin.down("#templatedItemId").reset();
 		 formWin.down("#templatedItemId").allowBlank=true;
 		 if(formWin.defaultValue){
			                       formWin.down("#templatedItemId").setValue(formWin.defaultValue)
 		                                }
	       	 if(rec[0].data.value == "SMS")
	       	 {
	    		 formWin.down("#subject").allowBlank=true;
	       		 formWin.down("#subject").hide();
	       		 
	       		  if(formWin.templateIdVisble){
    			 formWin.down("#templatedItemId").show();
      		 }else{
      			 formWin.down("#templatedItemId").allowBlank=true;
      			                   formWin.down("#templatedItemId").hide();
      			 
      		 }if(formWin.templateIdMandatory){
      			 if(formWin.templateIdVisble){
                                       formWin.down("#templatedItemId").allowBlank=false;
                                       formWin.down("#templatedItemId").setFieldLabel(getMessagingModuleTranslation('TEMPLATE_ID') +':<span class="required" style="color:red"> *</span>')

                               }else{
                                      formWin.down("#templatedItemId").allowBlank=true;
                               }
      		 }
      		  else{
     			formWin.down("#templatedItemId").allowBlank=true;
      		 
      		           }  
      		 
      		
	       		 
	       		 formWin.down("#staticUploadFileField").hide();
	       		 formWin.down("#usersDocumentMessageAttachmentGrid").hide();
	       		 formWin.down('#discriptionId').reset();
	       		 formWin.down('#discriptionId').hide();	       		 
	       		 subject.reset();
	       		 smsDiscription.show();
	       		 smsDiscriptionNotice.show();
	       		 pushNotificationDiscription.hide();
	       		 pushNotificationDiscriptionNotice.hide();
	       		 pushNotificationDiscription.reset();
	       	 }else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION_ONLY" || rec[0].data.value == "Push Notification Only")
	       	 {
	       		 formWin.down('#discriptionId').reset();
	       		 formWin.down('#smsDiscription').reset();
	       		 formWin.down('#smsDiscription').hide();
	       		 formWin.down('#smsDiscriptionNotice').hide();
	       		 formWin.down("#staticUploadFileField").hide();
	       		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
	       		 formWin.down("#usersDocumentMessageAttachmentGrid").hide()
	       		 subject.reset();
	       		 subject.show();
	       		 this.setAllowBlank (subject,false);
	       		 //formWin.down("#subject").allowBlank=false;
	       		 formWin.down('#discriptionId').show();
	       		 pushNotificationDiscription.hide();
	       		 pushNotificationDiscriptionNotice.hide();
	       		 pushNotificationDiscription.reset();    		
	       	 }
	       	 /*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
	       		 subject.show();
	       		 formWin.down("#staticUploadFileField").hide();
	       		 this.setAllowBlank (subject,false);
	       		 formWin.down("#usersDocumentMessageAttachmentGrid").hide();
	       		 formWin.down('#discriptionId').reset();
	       		 formWin.down('#discriptionId').hide();
	       		 subject.reset();
	       		 smsDiscription.reset();
	       		 smsDiscription.hide();
	       		 smsDiscriptionNotice.hide();
	       		 pushNotificationDiscription.reset();
	       		 pushNotificationDiscription.show();
	       		 pushNotificationDiscriptionNotice.show();
	       		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
	       		 //formWin.down('#smsDiscription')
	       	 }*/
	       	 else
	       	 {
	       		 formWin.down('#discriptionId').reset();
	       		 formWin.down('#smsDiscription').reset();
	       		 formWin.down('#smsDiscription').hide();
	       		 formWin.down('#smsDiscriptionNotice').hide();
	       		 formWin.down("#staticUploadFileField").show();
	       		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
	       		 formWin.down("#usersDocumentMessageAttachmentGrid").show()
	       		 subject.reset();
	       		 subject.show();
	       		 this.setAllowBlank (subject,false);
	       		 //formWin.down("#subject").allowBlank=false;
	       		 formWin.down('#discriptionId').show();
	       		 pushNotificationDiscription.hide();
	       		 pushNotificationDiscriptionNotice.hide();
	       		 pushNotificationDiscription.reset();    		
	       	 }
	       	formWin.getForm().checkValidity();
	       },
	       /**
	        * upload static document file for Student
	        */
	       uploadUserStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
	    	   var this$ = this;
	    	   var setupForm = fileField.up('userssendmessage');
	    	   var grid = setupForm.down('#usersStaticDocumentAttachmentGridMessage');
	    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
	    	   fileField.setRawValue(fileUploadPath);
	    	   var file = fileField.fileInputEl.dom.files[0];
	    	   var fileSizeLimit = '5';
	    	   var url = SERVERURL.FILE_PRIORITY;
	    	   Ext.Ajax.request({
					type: 'rest',
					url: url+'?type=emailFileSize',
					method: 'GET',
					success : function(response, action){
						var responseData = Ext.JSON.decode(response.responseText);
						if(responseData.length>0 && responseData[0].value!=undefined && !isNullOrEmpty(responseData[0].value))
						{
							fileSizeLimit=responseData[0].value;
						}
	    	   if((file.size / 1048576) <=  fileSizeLimit ){
	    		   if(!isNullOrEmpty(fileUploadPath)){
	    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
	    			   if (this$.isValidFileExtensionForMessaging(extension)) {
	    				   var entityId = 'student';
	    				   var module = 'messaging';
	    				   var entityType = 'template';
	    				   var documentType = 'DOCUMENT';
	    				   var isTransient = true;
	    				   this$.saveUserStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
	    					   if(success){
	    						   var path = Ext.JSON.decode(action.response.responseText).path;
	    						   var user = this$.getCurrentlyLoggedInUser();
	    						   var store = grid.getStore();
	    						   var documentStatus = "SUBMITTED";
	    						   var documentType = null;
	    						   if(!isNullOrEmpty(path)){
	    							   store.add({
	    								   id: '',
	    								   name: fileUploadPath,
	    								   path: path ,
	    								   createdBy : {
	    									   id :user.id,
	    									   value : user.value,
	    									   code : user.code
	    								   },
	    								   status : documentStatus,
	    								   documentType : documentType,
	    								   templateConfigDocId: '',
	    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

	    							   });
	    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
	    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
	    						   }

	    						   fileField.reset();
	    					   }

	    				   }, isTransient);
	    			   }else{
	    				   fileField.reset();
	    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	    			   }
	    		   }
	    	   }else{
	    		   fileField.reset();
	    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ATTACHMENT_LIMIT_EXCEEDS')+' '+fileSizeLimit+' MB');
	    	   }
	       	   }
			   });
	       },
	       /**
	        * Remove entry from grid
	        */
	       deleteUserStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
	    	   var grid = view.up('#usersStaticDocumentAttachmentGridMessage');
	    	   var panel = this.getContentPanel().getActiveTab();
	    	   var tabTitle = panel.title;
	    	   var store = grid.getStore();
	    	   var templateConfigDocId = record.get('templateConfigDocId');
	    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
	    	   if(!(tabTitle == viewTitle)){
	    		   if(!isNullOrEmpty(templateConfigDocId)){
	    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	    				   if (btn == 'yes') {
	    					   Ext.Ajax.request({
	    						   type: 'rest',
	    						   url: SERVERURL.STATIC_DOC_DELETE,
	    						   method: 'DELETE',
	    						   params: {
	    							   templateConfigDocId : templateConfigDocId
	    						   },
	    						   headers: {
	    							   'Content-Type': 'application/json'
	    						   },
	    						   success: function(form, action) {
	    							   store.remove(record);
	    							   showSuccessMessage(getPersonModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	    						   }
	    					   });
	    				   }
	    			   });

	    		   }else{
	    			   store.remove(record);
	    			   showSuccessMessage(getPersonModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	    		   }
	    	   }else{
	    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
	    	   }

	       },
	       /**
	        * This method is to enable schedule field
	        */
	       loadUserScheduleField : function(radio,newValue, oldValue){
	       	var adhocMessageForm = radio.up('form');
	       	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
	       	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
	       	var radioValue = radio.getValue().sendingPriority;
	       	
	       	if(radioValue=='IMMEDIATE'){
	       		scheduleDateField.setVisible(false);
	       		scheduleDateField.setDisabled(true);
	       		scheduleTimeField.setVisible(false);
	       		scheduleTimeField.setDisabled(true);    		
	       	}
	       	else if(radioValue=='SCHEDULE'){
	       		scheduleDateField.setVisible(true);
	       		scheduleDateField.setDisabled(false);
	       		scheduleTimeField.setVisible(true);
	       		scheduleTimeField.setDisabled(false);
	       	}
	       },
	       openUserSendMessage:function(obj){
		    	//var grid = this.getSearchresultgrid();
		    	var grid = obj.up('grid');
		    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
		    	if(grid.getSelectionModel().getCount()>0) {
		    		
		    			//var $this=this;
		    			var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
		    	       	   var structure = Ext.widget('userssendmessage',{
	               			itemId:'userSendMessageWindow',
	               			//customGridId: grid.itemId
	               		});
		    	       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
		    	       	   /**
		    	       	    * This is to remove tab from content panel and open same tab again
		    	       	    */
		    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
		    	       	   var getTab=getcontroller.getTab(tabName);
		    	       	   if(getTab!=null){
		    	       		   contentPanel.remove(getTab, true);
		    	       	   }
		    	       	var formWindowTab = this.getUserssendmessage();
		    	       	formWindowTab.down("#selectTemplate").allowBlank=true;
		    	       	formWindowTab.down("#selectTemplate").setVisible(false);
		    	       	formWindowTab.down("#messageName").allowBlank=true;   
		    	       	formWindowTab.down("#messageName").setVisible(false);
		    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
		    			templateStore.getProxy().extraParams={
		    				msgRecipientTypeId:1
		    			};
		    			templateStore.load();
		    			
		    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		    			   Ext.Ajax.request({
		    				   method : "GET",
		    				   type : 'rest',
		    				   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=UserTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
		    				   headers : {
		    					   'Content-Type' : 'application/json'
		    				   },
		    				   success : function(form,action) {
		    					   var data = Ext.JSON.decode(form.responseText);
		    					   formWindowTab.down("#id").setValue(data.id);
		    					   formWindowTab.down("#code").setValue(data.code);
		    					   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
		    					   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
		    					   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
		    					   Ext.getBody().unmask();
		    					   
		    					   //grid.getStore().reload();
		    					   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
		    				   }

		    			   });
		    	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
		    			/*if (!formWindow) {
		    				Ext.widget('applicantsendmessage');
		    				formWindow = $this.getUserssendmessage();
		    			}
		    			formWindow.show(;*/
		    		
		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		    	}
		    },
		    /**
		        * save document file. It's external call method
		        * @param entityId : person id, It's mandatory. 
		        * @param module : module name, for student module 'student', It's mandatory.
		        * @param entityType : entity type, It's mandatory.
		        * @param documentType : document type, It's mandatory.
		        * @param isTransient : true or false (send json back to module controller or not)
		        * @param callBackFunction : callback function return in module controller. It's mandatory.
		        */
		    	saveUserStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
		       	var submitUrl = '';
		       	var templateTab = this.getContentPanel();
		       	var formWin =  this.getUserssendmessage();
		       	var form = formWin.down('#msgDetailsForm');
		       	var id = form.down('#document_hidden_field');
		           if (isNullOrEmpty(id.getSubmitValue())) {
		               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
		           }
		           var data = new Object();
		           if(!isNullOrEmpty(entityId)){
		           	data.entityId = entityId;
		           }else{
		           	data.entityId = null;
		           }
		           if(!isNullOrEmpty(module)){
		           	data.module = module;
		           }else{
		           	data.module = null;
		           }
		           if(!isNullOrEmpty(entityType)){
		           	data.entityType = entityType;
		           }else{
		           	data.entityType = null;
		           }
		           form.getForm().setValues(data);
		           form.getForm().submit({
		           	method : 'POST',
		           	url : submitUrl,
		           	success : function(form, action){
		           		callBackFunction(true, action, isTransient);
		           		
		           	}
		           });
		       },
		       /**
		        * Add value to grid
		        */
		       loadGridWithFileNameMessage:function(grid,value,store){
		    	   grid.bindStore(store);
		       },
		       
		       approvalDroolSelection: function(me, newValue, oldValue, eOpts){
		    	   var form = this.getUserBasicDetails();
		    	   var approvalDrool = form.down("#approvalDrool");
		    	   
		    	   var isTimeSheetRequired=form.down('#approvalDrool');
		    	   if(newValue) {
		    		   approvalDrool.setVisible(true);
		    	   } else {
		    		   approvalDrool.setVisible(false);
		    	   }
		       },
		       
		       unAssignUserAcademyLocation : function(gridTree, selectedUserAcadLocId) {
		    	   Ext.Ajax.request({
			            method: "DELETE",
			            type: 'rest',
			            url:SERVERURL.UAL_DELETE,
				        params: {
				        	userAcadLocId: selectedUserAcadLocId
				        },
			            success: function(response) {
			            	showSuccessMessage(getCommonTranslation('UNASSIGN_ACADEMY_LOCATION'), getCommonTranslation('SUCCESS'));
			            	gridTree.getSelectionModel().deselectAll(true);
			            	gridTree.getStore().reload();
			            	gridTree.getSelectionModel().select(0, true);
			            }
			        });
		       },
		       
		       disableUserAccessRightsPivileges: function(gridReference,permissionsMap) {
		       	var associatedAcadLocationIds = new Array();
		       	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		       	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		       
		       	var addAcademyLocation = gridReference.down('#add_academyLocation');
		       	var addRole = gridReference.down('#add_acad_loc_role');
		       	var mulAcademyLocationAndRole=gridReference.down('#multipleALandRolesId');
		       	var editAcademyLocation = gridReference.down('#edit_academyLocation');
		       	var editRole = gridReference.down('#edit_acad_loc_role');
		       	var editPrivilege = gridReference.down('#edit_privilege');
		       	var editProgramAndCourses = gridReference.down('#edit_programCourse');
		       	var unassignAcademyLocation = gridReference.down('#unassign_academyLocation');
		       	var unassignRole = gridReference.down('#unassign_acad_loc_role');
		       	
		       	addAcademyLocation.setVisible(false);
		       	addRole.setVisible(false);
		       	mulAcademyLocationAndRole.setVisible(false);
		       	editAcademyLocation.setVisible(false);
		       	editRole.setVisible(false);
		       	editPrivilege.setVisible(false);
		       	editProgramAndCourses.setVisible(false);
		       	unassignAcademyLocation.setVisible(false);
		       	unassignRole.setVisible(false);
		       	
		       	var addButton = 0;
		       	var editButton = 0;
		       	var unassignButton = 0;
		       	
		       	Ext.each(permissionList, function(privilege) {
		       	    if (privilege === 'ADD_ACADEMY_LOCATION') {
		       	        if (!isNullOrEmpty(addAcademyLocation)) {
		       	            addAcademyLocation.setVisible(true);
		       	            addButton++;
		       	        }
		       	    } else if (privilege === 'ADD_ROLE') {
		       	        if (!isNullOrEmpty(addRole)) {
		       	            addRole.setVisible(true);
		       	            addButton++;
		       	        }
		       	    }  else if (privilege === 'ADD_MULTIPLE_ACADEMY_LOCATION_AND_ROLE') {
		       	        if (!isNullOrEmpty(mulAcademyLocationAndRole)) {
		       	        	mulAcademyLocationAndRole.setVisible(true);
		       	        	mulAcademyLocationAndRole++;
		       	        }
		       	    } 
		       	    else if (privilege === 'EDIT_ACADEMY_LOCATION') {
		       	        if (!isNullOrEmpty(editAcademyLocation)) {
		       	            editAcademyLocation.setVisible(true);
		       	            editButton++;
		       	        }
		       	    } else if (privilege === 'EDIT_ROLE') {
		       	        if (!isNullOrEmpty(editRole)) {
		       	            editRole.setVisible(true);
		       	            editButton++;
		       	        }
		       	    } else if (privilege === 'EDIT_PRIVILEGES') {
		       	        if (!isNullOrEmpty(editPrivilege)) {
		       	            editPrivilege.setVisible(true);
		       	            editButton++;
		       	        }
		       	    } else if (privilege === 'EDIT_PROGRAM_AND_COURSES') {
		       	        if (!isNullOrEmpty(editProgramAndCourses)) {
		       	            editProgramAndCourses.setVisible(true);
		       	            editButton++;
		       	        }
		       	    } else if (privilege === 'UNASSIGN_ACADEMY_LOCATION') {
		       	        if (!isNullOrEmpty(unassignAcademyLocation)) {
		       	            unassignAcademyLocation.setVisible(true);
		       	            unassignButton++;
		       	        }
		       	    } else if (privilege === 'UNASSIGN_ROLE') {
		       	        if (!isNullOrEmpty(unassignRole)) {
		       	            unassignRole.setVisible(true);
		       	            unassignButton++;
		       	        }
		       	    }
		       	});

		       	if (addButton == 0) {
		       	    addRole.destroy();
		       	    addAcademyLocation.destroy();
		       	}
		       	if (editButton == 0) {
		       	    editAcademyLocation.destroy();
		       	    editRole.destroy();
		       	    editPrivilege.destroy();
		       	    editProgramAndCourses.destroy();
		       	}
		       	if (unassignButton == 0) {
		       		unassignAcademyLocation.destroy();
		       		unassignRole.destroy();
		       	}
		},
		saveDFRInfo: function(academyLocationId,form) {
    	var templateId = form.down('#templatedItemId');
    	templateId.setVisible(false)
    	templateId.setFieldLabel(getMessagingModuleTranslation('TEMPLATE_ID'));
        Ext.Ajax.request({
            url: SERVERURL.COMMON_FORM_FIELD_INFO,
            method: 'GET',
            async: false,
            params: {
            	screenName: 'userssendmessage',
                academyLocationId:academyLocationId,
                languageCode:'en'
            },
            success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if( Object.keys(response).length > 0 ){
    				var records=response.userssendmessage;
    				for(i in records){
    					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templatedItemId'){
    					var defaultValue = records[i].defaultValue;
   						    if(!isNullOrEmpty(defaultValue)){
  						    	templateId.setValue(defaultValue);
  						    	form.defaultValue =defaultValue;
   						    }
    							if(records[i].isVisible==false ){
    								form.templateIdVisble =false;
    							}if(records[i].isMandatory == true ){
    								form.templateIdMandatory= true
    							}if(records[i].isVisible==true){
    								form.templateIdVisble =true;
    							}if(records[i].isMandatory == false ){
    								form.templateIdMandatory= false
    							}
    						}
    					}
    				}
    			
    		}
        });
    
    },  
		enableDisableMessageEvent:function(button){
	    	var grid = button.up('grid');
	    	var status="";
	    	if(grid){    		
	    		if(grid.getSelectionModel().getCount() > 0) {
	    				var records = grid.getSelectionModel().getSelection();
	    				var userIdsListStr=[];
	    					for(var i in records) {
	    						userIdsListStr.push(records[i].data.USER_ID);
	    					}
	    				    			
	                if(!isEmpty(records)){
	                    //var selectedStatus=records[i].data.STATUS;
	                	var selectedStatus=records[i].raw.USER_LIST_STATUS;
	                   // if (!isNullOrEmpty(userIdsListStr) &&  !isNullOrEmpty(records[i].data.STATUS)){
	                    	if (!isNullOrEmpty(userIdsListStr) &&  !isNullOrEmpty(records[i].raw.USER_LIST_STATUS)){
	                        if(selectedStatus == "Inactive"){
	                        	selectedStatus=true;                        	
	                        }else{
	                        	selectedStatus=false;
	                        }
	                        if(records!=null && userIdsListStr!=null){
	                			showConfirmMessage(getCommonTranslation('MAKE_ACTIVE'), getCommonTranslation('ALERT_ACTIVE_CONFIRM_MESSAGE'), function(btn, text){
	                				if(btn=='yes'){
	                				  var url = SERVERURL.ACIVATE_USER;
	                              	url = url.concat('?ids='+userIdsListStr);
	      	                        
	      	                        Ext.Ajax.request({
	      	                            type: 'rest',                                     
	      	                            url: url,
	      	                            method: 'PUT', 
	      	                            async: false,
	      	                            headers: {
	      	                                'Content-Type': 'application/json'
	      	                            },
	      	                            success: function(form, action) {
	      	                            	grid.getStore().reload();
	      	                            	if(selectedStatus){
	      	                            		showSuccessMessage(getCommonTranslation('ACTIVE'), getCommonTranslation('ACTIVE_USER_MESSAGE'));                  	
	      	                                }                        
	      	                            }
	      	                        });
	                			   }
	                			});
	                        }
	                    }                	
	                }    			 
	    		} else {
	            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
	            }    		
	    	}    	
	    },
	    doEnableDisableRoleLink:function(rowSelect){
	    	 var form = this.getUserBasicDetails();
	    	 var grid = form.up().down('accessrighttree');
	    	 var editRoleLink = grid.down('#edit_acad_loc_role');
	    	 var userId = this.getCurrentlyLoggedInUser().id;
	    	 var records = grid.getSelectionModel().lastSelected;
			 if(userId != 1){
				if(isNullOrEmpty(records.get("role.roleName"))){
					editRoleLink.setDisabled(false);
				}else if(!isNullOrEmpty(records.data.role)){
					if(records.data.role.isLocked == true){
						if(!isNullOrEmpty(editRoleLink)){
							editRoleLink.setDisabled(true);
						}
	                 }else{
	                	 if(!isNullOrEmpty(editRoleLink)){
	                		 editRoleLink.setDisabled(false);
	                	 }
	                 }
				}
			 }
	    },
	    /*This method is used to manage auto generate field
	     * @param- form*/
	    managedFieldByDataSetting:function(obj){
	    	 var $this = this;
	    	 Ext.Ajax.request({
	    		 type: 'rest',
	    		 url: SERVERURL.FIND_BY_ENTITY_ID, //URL-rest/idDefinition/findByEntityId  //?entityId=1                            
	    		 method: 'GET',
	    		 params: {
	    			 entityId: 40
	    		 },
	    		 success: function(response,form, action) {
	    			 if(!isNullOrEmpty(response.responseText)){
	    				 var responseObject =  Ext.JSON.decode(response.responseText);//make object of response text
	    				 $this.formData=responseObject;  
	    				 if(!isEmpty(responseObject)){
	    					 var code = obj.down("#code");
	    					 if(responseObject.whetherManualId){
	    						 code.setReadOnly(false)
	    						 $this.setAllowBlank(code,false);  
	    						 $this.setFieldPlaceHolder(code,'');
	    					 }else{
	    						 Ext.defer(function(){
	    							 code.setReadOnly(true);
	    						 },500);
	    						 
	    						 $this.setAllowBlank(code,true);
	    						 $this.setFieldPlaceHolder(code,getCommonTranslation('ID_AUTOGENERATE'));
	    					 }
	    				 }
	    			 }                 	                            	
	    		 }	            
	    	 });	
	    	 formWindow.show();
	    },
	    addALRolesDataInGrid:function(){
	    	var $this=this;
	    	var jsonArray=[];
	    	var grid = this.getMultiplealandrolesgrid();
	    	var form = this.getMultiplealandrolesform();
	    	var formData = form.getValues();
	    	var alArray = formData.multiAcademyLocation;
	    	var rolesArray = formData.multipleRoles;
	    	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	    	Ext.defer(function() {
	    		alArray.forEach(function(acadData){
		    		rolesArray.forEach(function(roleData){
		    		     var roleALMappings = Ext.Array.pluck(grid.store.data.items,'data');// to get all the record added in grid
		    		     var hasEntry=false;
		    		     if(roleALMappings.length>0){
		    		    	 //Check if the (role, AL) pair is already in the array
		    		    	  hasEntry = roleALMappings.some(function(element) {
     		    				  return (element.academyLocationId==acadData.data.id && element.roleId==roleData.data.id);
     		    			   });
		    		     }
		    		     if(!hasEntry){
		    		    	 var index = $this.alGridindex++; // to add index on each row
		    		    	 jsonArray.push({ 
		    		    		 roleId: roleData.data.id,role:roleData.data.value, academyLocationId: acadData.data.id,
		    		    		 academyLocationName: acadData.data.value , alStartDate : formData.academyLocStartDate,
		    		    		 alTillDate:formData.academyLocTillDate , roleStartDate:formData.roleStartDate,
		    		    		 roleTillDate:formData.roleTillDate,primaryAcaLoc:false,gridRowIndex:index
		    		    	 });
		    		     }
		    	    });
		    	});
		    	grid.getStore().add(jsonArray);
		    	form.getForm().reset();
		    	form.down('#multiAcademyLocationId').clearValue();
		    	form.down('#multipleRolesId').clearValue();
		    	form.down('#academyLocStartDate').setMaxValue();
		    	form.down('#academyLocTillDate').setMinValue();
		    	form.down('#roleStartDate').setMaxValue();
		    	form.down('#roleTillDate').setMinValue();
		    	Ext.getBody().unmask(); 
	    	},1000, this);
	    },
	    saveALRolesMapping:function(){
	    	var usersFormData = this.getWinUserBasicDetails().getValues();
	    	var form = this.getMultiplealandrolesform();
	    	form.down('#saveDataBtn').setDisabled(true);
	    	var formData = form.getValues();
	    	var grid = this.getMultiplealandrolesgrid();
	    	var selectedRecord = grid.getSelectionModel().getSelection();
	    	var formData = [];
	    	var isPrimaryALChecked=false;
	    	if(grid.getSelectionModel().getCount() > 0){
	    		Ext.each(selectedRecord, function(record) {
	    			var json = {
	    					roleId:record.data.roleId,
	    					academyLocationId:record.data.academyLocationId,
	    					alStartDate:record.data.alStartDate,
	    					alTillDate:record.data.alTillDate,
	    					roleStartDate:record.data.roleStartDate,
	    					roleTillDate:record.data.roleTillDate,
	    					userId:parseInt(usersFormData.id),
	    					wheatherPrimary:record.data.primaryAcaLoc
	    			}
	    			formData.push(json);
	    			if(record.data.primaryAcaLoc){
	    				isPrimaryALChecked=true;
	    			}
	    		});
	    		var submitData = Ext.encode(formData);	
	    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    		if(isPrimaryALChecked){
	    			Ext.Ajax.request({
	    				type: 'rest',
	    				url: SERVERURL.PATH_SAVE_USER_ROLE,
	    				method: 'POST',
	    				jsonData : submitData,
	    				headers : {
	    					'Content-Type' : 'application/json'   
	    				},
	    				success: function(response, action) {
	    					form.down('#saveDataBtn').setDisabled(false);
	    					grid.getSelectionModel().deselectAll();
	    					Ext.getBody().unmask();
	    					showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
	    				}
	    			});
	    		}else{
	    			form.down('#saveDataBtn').setDisabled(false);
	    			Ext.getBody().unmask();
	    			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_AT_LEAST_ONE_PRIMARY_ACADEMY_LOCATION')); 
	    		}
	    	}else{
	    		form.down('#saveDataBtn').setDisabled(false);
	    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
	    	}
	    },
	    removePlaceHolder:function(weatherViewOnly){
	    	    var addfileinfoform=this.getContentPanel().getActiveTab();
	    	                      Ext.Ajax.request({
	    	                         type: 'rest',
	    	                         url: SERVERURL.FIND_BY_ENTITY_ID,                             
	    	                         method: 'GET',
	    	                         params: {
	    	                             entityId: 40
	    	                         },
	    	                         success: function(response,form, action) {
	    	                             if(!isNullOrEmpty(response.responseText)){
	    	                                 var responseObject =  Ext.JSON.decode(response.responseText);                                  
	    	                                 if(!isEmpty(responseObject)){
	    	                                     var fileNumber = addfileinfoform.down("#code");
	    	                                     if(responseObject.whetherManualId){
									    		if(weatherViewOnly){
									    			 fileNumber.setReadOnly(true);
									    		}else{
									    			fileNumber.setReadOnly(false);
									    		}
	    		                                     fileNumber.emptyText=' ';
	    	                                         fileNumber.allowBlank=false;
	    	                                         //fileNumber.labelSeparator +='<span class="required" style="color:red"> *</span>';
	    	                                         fileNumber.setFieldLabel(fileNumber.fieldLabel);
	    	                                         fileNumber.applyEmptyText();
	    	                                     }else{
	    	                                         fileNumber.setReadOnly(true);
	    	                                         fileNumber.allowBlank=true;
	    	                                         fileNumber.emptyText= getCommonTranslation('ID_AUTOGENERATE');
	    	                                         fileNumber.applyEmptyText();
	    	    
	    	                                    }
	    	                                 }
	    	                             }                                                     
	    	                         }                
	    	                     });
	    	    
	    	}


});
