/**
 * @author Pritam.Patil
 * This is used for previous Locked User Functionality
 */
Ext.define('Academia.controller.securitysetup.unlockUser.PreviousLockedUserController', {
    extend: 'Academia.controller.base.BaseController',

    stores: ['criteriabuilder.userquicksearch.QuickSearchCode',
             'criteriabuilder.userquicksearch.QuickSearchName'],
             
    views: ['securitysetup.unlockuser.CurrentlyLockedUserSearchForm', 
            'securitysetup.unlockuser.PreviouslyLockedUserView', 
            'securitysetup.unlockuser.PreviouslyLockedUserPanel'],

    refs: [{
        ref: 'viewSearch',
        selector: 'currentlylockedusersearchform[itemId=previouslyLockedUserSearchForm]'
    }, {

        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=previouslyLockedUserGrid]'
    }],
    config: {
    	PREVIOUSLY_LOCKED_USER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PREVIOUSLY_LOCKED_USER_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	
            'currentlylockedusersearchform[itemId=previouslyLockedUserSearchForm] button[itemId=lockedUserSearchButtonId]': {
                click: this.loadGridAndSearchUsers,
                //afterrender: this.loadGridAndSearchUsers
            },

            'currentlylockedusersearchform[itemId=previouslyLockedUserSearchForm] button[itemId=lockedUserClearSearchBtn]': {
                click: this.clearSearchForm
            },
            'searchresultgrid[itemId=previouslyLockedUserGrid]' : {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				},
 				afterrender : function(grid) {
                    var me = this;
                    var structure = grid.up('previouslylockeduserpanel');
                    me.loadGridAndSearchUsers();
                    me.getGridHeaderFreezeForQuartz(grid, structure, true);
                }
            },
            'previouslylockeduserpanel grid[itemId=previouslyLockedUserGrid]': {
        	afterrender : function(grid){
					this.genericCBGridAccessControlValidation(grid, this.getPREVIOUSLY_LOCKED_USER_PERMISSIONS());
					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
			   		viewButton.setVisible(false);
				}
	        },
	        /**** Export button for currently locked user ******/
	        'searchresultgrid[itemId=previouslyLockedUserGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportPreviouslyLockedUser(SERVERURL.PDFEXPORT,'pdf',false);
	            }
	        },
	        'searchresultgrid[itemId=previouslyLockedUserGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportPreviouslyLockedUser(SERVERURL.PDFEXPORT,'pdf',true);
	            }
	        },
	        'searchresultgrid[itemId=previouslyLockedUserGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportPreviouslyLockedUser(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	            }
	        },
	        'searchresultgrid[itemId=previouslyLockedUserGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportPreviouslyLockedUser(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	            }
	        }
        });
    },
    
    /***
	  * This function is to export pdf and xcel
	  */
 
    exportPreviouslyLockedUser : function(exportUrl,filetype,whetherAll,requestType) {
	   	 var quickSearchForm=this.getViewSearch();
	   	 var searchResultGrid = this.getSearchResultGrid();	
	   	 var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
         var reportTitle=getCommonTranslation('PREVIOUSLY_LOCKED_USER');
	   	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	   	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	   	var visibleColumns=this.getVisibleColumns(searchResultGrid);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
		},
		
		createSearchCriteriaString: function(searchForm) {
	   	var me=this;
	       var formValues = new Array();
	       formValues = searchForm.getValues();        
	       var searchCriteriaString="";
	       for (var key in formValues) {
	       	var value = formValues[key];            
	           if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	               var keyValueJsonObject = me.getJsonObject( key , value);
	   	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	           }
	       }
	       searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	       return searchCriteriaString;
	   },
 
	   gridRenderFunction:function(grid){
			grid.addButtonToolbar();
	   },
    /**
     * This is used to load search result grid
     * @param model
     * @param records
     */
    loadGridAndSearchUsers: function(model, records) {
        var presearchviewForm = this.getViewSearch();
        var jsonFormatFormData = this.createJsonFormat(presearchviewForm);
        var searchResultGrid = this.getSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PREVIOUS_LOCKED_USER_VIEWCODE);
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);

    },

    /**
     * This method is used to create JSON format of form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function(presearchviewForm) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.PREVIOUS_LOCKED_USER_BASIC_CONFIGCODE;

        formValues = presearchviewForm.getValues();

        var USER_ID = this.getJsonObject('USER_ID', formValues.USER_ID);
        this.pushJsonObjectInArray(USER_ID, searchcriteria);

        var USER_NAME = this.getJsonObject('USER_NAME', formValues.USER_NAME);
        this.pushJsonObjectInArray(USER_NAME, searchcriteria);


        var LOCKED_ON_DATE_BETWEEN = this.getJsonObject('LOCKED_ON_DATE_BETWEEN', formValues.FROM_DATE, formValues.TO_DATE+" "+'23:59:59');
        this.pushJsonObjectInArray(LOCKED_ON_DATE_BETWEEN, searchcriteria);

        var MIN_NO_OF_TIME_LOCKED = this.getJsonObject('MIN_NO_OF_TIME_LOCKED', formValues.MIN_NO_OF_TIMES_LOCKED);
        this.pushJsonObjectInArray(MIN_NO_OF_TIME_LOCKED, searchcriteria);

        var MAX_NO_OF_TIME_LOCKED = this.getJsonObject('MAX_NO_OF_TIME_LOCKED', formValues.MAX_NO_OF_TIMES_LOCKED);
        this.pushJsonObjectInArray(MAX_NO_OF_TIME_LOCKED, searchcriteria);
        var lockReason='';
        var LOCKED_REASON='';
        if(formValues.LOCKED_REASON=='Locked for wrong password attempt'){
        	lockReason='locked_for_wrong_password_attempt';
        	LOCKED_REASON = this.getJsonObject('LOCKED_REASON', lockReason);
        }
        else{
            LOCKED_REASON = this.getJsonObject('LOCKED_REASON', formValues.LOCKED_REASON);
        }
        this.pushJsonObjectInArray(LOCKED_REASON, searchcriteria);

        values.searchCriterias = searchcriteria;
        return values;
    },

    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    /**
     * This method is used to clear fields on User Frequency search Form
     * @param button which is reference of button
     */
    clearSearchForm: function(button) {

        form = button.up('form').getForm();
        form.getFields().each(function(field) {
            field.reset();
        });
    }
});
