/**
 * @author Shashank Jain
 *  
 */
Ext.define('Academia.controller.setup.quickLink.QuickLinkController', {
	extend: 'Academia.controller.base.BaseController',
    
    models:['setup.quickLink.QuickLinkGridModel','setup.quickLink.QuickLinkWinForPortalModel'],
    
    stores:['setup.quickLink.QuickLinkGridStore','setup.quickLink.QuickLinkWinForPortalStore'],
    
    views: ['setup.quickLink.QuickLinkStructure','setup.quickLink.QuickLinkWin','setup.quickLink.QuickLinkGrid'],
   
    refs: [{
    	ref:'quicklinkstructure',
    	selector:'quicklinkstructure'
    },{
    	ref:'quicklinkwin',
    	selector:'quicklinkwin'
    },{
    	ref:'quicklinkgrid',
    	selector:'quicklinkgrid'
    }],
    config: {
    	QUICK_LINK_SETUP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('QUICK_LINK_SETUP_PRIVILEGES'),
    },
    init: function(application) {
        this.control({
        	
        	'quicklinkgrid':{
        		render:function(grid){
        			grid.getStore().reload();
        		},
        		
        		cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
						if(columnName == "docId"){
							if(e.target.tagName=='A'){
									var whetherFile = false;
									var documentId= record.data.docId.encryptedDocId;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel'); 
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												} else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									} 
							}
						}
				 }
        
        
        
        
        	},
        	
        	'quicklinkgrid button[itemId=btnAdd]':{
        		click:this.showQuickLinkWin
        	},
        	'quicklinkgrid button[itemId=btnEdit]':{
        		click:this.editQuickLinkWin
        	},
        	'quicklinkgrid button[itemId=btnView]':{
        		click:this.viewQuickLinkWin
        	},
        	'quicklinkwin button[itemId=CancelBtnQuickLink]':{
        		click:function(obj){
        			var window = obj.up('window');
        			window.close();
        		}
        	},
        	
        	'quicklinkwin button[itemId=SubmitBtnQuickLink]' :{
				click : this.getSaveQuickLink
			},
        	
        	'quicklinkwin filefield[itemId=imageUploadField]' : {
				change: function(photoFileImage, value, eOpts) {
		            		value = value.replace('C:\\fakepath\\', '');
		            		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
		            		photoFileImage.setRawValue(newValue);
		            		
		            		var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
		            		if(!isNullOrEmpty(value)){
		            			if (extension == "png" || extension == "jpeg" || extension == "jpg") {
		            				var file = photoFileImage.fileInputEl.dom.files[0];
		            				if(!isNullOrEmpty(file.size)&&(file.size/1024)<=50){
										// 50kb size of this files format should be
									}else{
										photoFileImage.reset()
										showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('UPLOAD_VALID_FILE'));
									}
		            			}else{
		                			photoFileImage.reset();
		                			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
		            			}
		            		}

		            	}
		            },
        	
        });
    },
    
    showQuickLinkWin:function(){
		var quickLinkWin = this.getQuicklinkwin();
		 if (!quickLinkWin) {
            Ext.widget('quicklinkwin');
            quickLinkWin = this.getQuicklinkwin();
        }
		 quickLinkWin.show();
	},
	
	editQuickLinkWin:function(){
		var this$ = this;
   		var grid = this$.getQuicklinkgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.showQuickLinkWin();
    		var form = this$.getQuicklinkwin();
    		this$.populateQuickLinkRecord(grid,form);
    		
    	}else{
			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		}
	},
	viewQuickLinkWin:function(){
		var this$ = this;
   		var grid = this$.getQuicklinkgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.showQuickLinkWin();
    		var form = this$.getQuicklinkwin();
    		this$.populateQuickLinkRecord(grid,form);
    		var formWin=form.down('#quickLinkWin').getForm();
    		toggleReadOnlyFormItems(formWin,true);
    		form.down('#SubmitBtnQuickLink').setVisible(false);
    		form.down('#CancelBtnQuickLink').setVisible(false);
    		
    	}else{
			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		}
	},
	
	populateQuickLinkRecord:function(grid,form){
		var record = grid.getSelectionModel().getSelection()[0];
		var id = form.down('#quickLinkId').setValue(record.data.id);
		var portalId = form.down('#portalId');
		portalId.getStore().load({
            callback:function(records){
                
            	for(var i=0;i<records.length;i++){
            		if(records[i].data.id==record.data.portal.id){
            			portalId.setValue(record.data.portal.id); 
            		}
            	}    
            }
            
        });
		var linkName = form.down('#linkName').setValue(record.data.linkName);
		var linkUrl= form.down('#linkUrl').setValue(record.data.linkUrl);
		var imageUploadField = form.down('#imageUploadField').setValue(record.data.imageUploadField);
		var sequenceNo= form.down('#sequenceNo').setValue(record.data.sequenceNo);
		var whetherActive= form.down('#whetherActive').setValue(record.data.whetherActive);
	},
	
	getSaveQuickLink : function(){
		var this$ = this;
		var userName='';
		var grid = this$.getQuicklinkgrid();
		var gridStore = grid.getStore();
		var dataGrid=gridStore.data;
		var win = this$.getQuicklinkwin();
		var gridRecord = grid.getSelectionModel().getSelection();
		var form=win.down('#quickLinkWin');
		var quickLinkId = win.down('#quickLinkId').getValue();
		var portalId = win.down('#portalId').getValue();
		var linkName = win.down('#linkName').getValue();
		var linkUrl= win.down('#linkUrl').getValue();
		var sequenceNo = win.down('#sequenceNo').getValue();
		var whetherActive = win.down('#whetherActive').getValue();
		
		var alreadyExist=false;
		for(var i=0;i<dataGrid.length;i++){
			
			if(dataGrid.items[i].data.id == quickLinkId && dataGrid.items[i].data.portal.id == portalId && dataGrid.items[i].data.sequenceNo == sequenceNo){
				alreadyExist=false;
				break;
			}
			if(dataGrid.items[i].data.portal.id == portalId && dataGrid.items[i].data.sequenceNo == sequenceNo){
				alreadyExist=true;
				break;
			}else{
				alreadyExist=false;
			}
		}
		var json= new Object;
		var submitUrl;
		var Portal = new Object();
		Portal.id = portalId;
		var imagePath = win.down('#imageUploadField').getValue();
		
		var imageUrlJson = new Object();
		imageUrlJson.id=null;
		imageUrlJson.path=null;
		imageUrlJson.createdBy=this$.getCurrentlyLoggedInUser();
		imageUrlJson.type = "DOCUMENT";
		
		if(quickLinkId != ""){
			submitUrl=SERVERURL.PATH_QUICK_LINK_SETUP_UPDATE;
			if(isNullOrEmpty(imagePath)) {
   				json = {
   						"id":quickLinkId,
   						"portal":Portal,
   						"linkName":linkName,
   						"linkUrl":linkUrl,
   						"docId":gridRecord[0].data.docId,
   						"sequenceNo":sequenceNo,
   						"whetherActive":whetherActive,
   				};
   			}
		}else{
			if(isNullOrEmpty(imagePath)) {
				json = {
   						"id":null,
   						"portal":Portal,
   						"linkName":linkName,
   						"linkUrl":linkUrl,
   						"docId":null,
   						"sequenceNo":sequenceNo,
   						"whetherActive":whetherActive,
   				};
			}
			submitUrl=SERVERURL.PATH_QUICK_LINK_SETUP_SAVE;
		}
		
		if(!alreadyExist){
			if(!isNullOrEmpty(imagePath)){
				form.submit({
					type: 'rest',
					url: SERVERURL.PATH_QUICK_LINK_SETUP_UPLOAD_IMAGE,
					method: 'POST',
					params:{
						userName : null
					},
					success : function(form, action) {
						this$.hideWindowMask();
						var  imageUrl= action.result.path;
						imageUrlJson.path=imageUrl;
						if(quickLinkId != ""){
							json = {
									"id":quickLinkId,
									"portal":Portal,
									"linkName":linkName,
									"linkUrl":linkUrl,
									"docId":imageUrlJson,
									"sequenceNo":sequenceNo,
									"whetherActive":whetherActive,
							};
						}else{
							json = {
									"id":null,
									"portal":Portal,
									"linkName":linkName,
									"linkUrl":linkUrl,
									"docId":imageUrlJson,
									"sequenceNo":sequenceNo,
									"whetherActive":whetherActive,
							};
						}
						var submitData = Ext.encode(json);
						Ext.Ajax.request({
							url: submitUrl,
							jsonData: submitData,
							method: 'POST',
							success: function(response) {
								this$.hideWindowMask();
								var quickId= response.responseText;
								this$.getQuicklinkwin().close();
								if(!isNullOrEmpty(quickLinkId)) {
									showSuccessMessage(getCommonTranslation('QUICK_LINK'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
								} else {
									showSuccessMessage(getCommonTranslation('QUICK_LINK'),getCommonTranslation('RECORD_ADD_SUCCESS'));
								}	
								gridStore.reload();
								grid.getSelectionModel().deselectAll(true);

							}
						});
					}
				});
			}else{
				var submitData = Ext.encode(json);
				Ext.Ajax.request({
					url: submitUrl,
					jsonData: submitData,
					method: 'POST',
					success: function(response) {
						this$.hideWindowMask();
						var quickId= response.responseText;

						this$.getQuicklinkwin().close();
						if(!isNullOrEmpty(quickLinkId)) {
							showSuccessMessage(getCommonTranslation('QUICK_LINK'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
						} else {
							showSuccessMessage(getCommonTranslation('QUICK_LINK'),getCommonTranslation('RECORD_ADD_SUCCESS'));
						}								   				
						gridStore.reload();
						grid.getSelectionModel().deselectAll(true);

					}
				});

			}
		}else{
			showWarningMessage(getCommonTranslation('QUICK_LINK'),getCommonTranslation('SEQUENCE_NUMBER_ALREADY_ADDED'));
		}
	},
	
});
