/**
 * @author Amit G
 */
Ext.define('Academia.controller.student.disciplinaryActionsReport.StudentDisciplinaryActionsReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch','feeandpayment.managebill.Student',
	         'common.picklist.AcademyTypeStore','personinfo.common.disciplinaryactivity.DisciplinaryTypeOfIncidentSearchCombo',
	         'Academia.store.attendance.SectionAndFacultyByPeriodID','Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	         'Academia.store.program.programbatchdetail.BatchStore','program.ProgramByGroupIdStore',
	         'student.report.StudentDisciplinaryActionReportStore','admission.applicationFormSale.ProgramGroupComboStore',
	         'common.IncidentTypeStore','common.CategoryOfIncidentStore','common.IncidentRatingPositiveStore',
	         'common.IncidentRatingNegativeStore','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameAdmissionCodeBySmartSearch',
	         'coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch','common.CurrentBatchStore','common.AssignedProgramStore',
	         'personinfo.common.disciplinaryactivity.DisciplinarySanctionTypeSUStore',
	         'personinfo.common.disciplinaryactivity.DisciplinarySUTypeOfMisconductSearchCombo',
	         'personinfo.common.disciplinaryactivity.DisciplinarySanctionDetailGridStore',
	         'personinfo.common.disciplinaryactivity.DisciplinarySanctionTypeSUStore',
             'personinfo.common.disciplinaryactivity.SanctionCompletedStore',
             'personinfo.common.disciplinaryactivity.DisciplinarySUAppealOutcome',
             'personinfo.common.disciplinaryactivity.DisciplinaryActionSUDocumentListStore',
             'student.report.StudentDisciplinaryActionSUReportStore'],
	         views: ['student.disciplinaryActionsReport.StudentDisciplinaryActionsReportTabStructure',
	                 'student.disciplinaryActionsReport.StudentDisciplinaryActionsReportStructure','student.disciplinaryActionsReport.StudentDisciplinaryActionsReportGrid',
	                 'student.disciplinaryActionsReport.StudentDisciplinaryActionsReportFilter',
	                 'student.disciplinaryActionSUReport.StudentDisciplinaryActionsSUReportTabStructure',
                     'student.disciplinaryActionSUReport.StudentDisciplinaryActionsSUReportStructure',
                     'student.disciplinaryActionSUReport.StudentDisciplinaryActionsSUReportFilter',
                     'student.disciplinaryActionSUReport.StudentDisciplinaryActionsSUReportGrid',
                     'personinfo.common.disciplinaryactivity.DisciplinaryActionSuSanctionDetailWindow',
                     'personinfo.common.disciplinaryactivity.SanctionDetailsGrid',
                     'personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentSUList',
                     'personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentListGridSU'
                     ],
	                 config : {
	                	 STUDENT_DISCIPLINARYACTIONSREPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_DISCIPLINARYACTIONS_REPORT_PRIVILEDGE'),
	                	 DISCIPLINARY_ACTION_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DISCIPLINARY_ACTION_REPORT_PRIVILEGES'),
	                	 FP_DISCIPLINARY_ACTION_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_DISCIPLINARY_ACTION_REPORT_PRIVILEGES'),
	  		             STUDENT_DISCIPLINARY_ACTION_SU_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DISCIPLINARY_ACTION_SU_REPORT_PRIVILEGES')

	                 },
	                 refs: [{
	                	 ref: 'studentdisciplinaryactionsreportfilter',
	                	 selector: 'studentdisciplinaryactionsreportfilter'
	                 },{
	                	 ref: 'studentdisciplinaryactionsreportgrid',
	                	 selector: 'studentdisciplinaryactionsreportgrid'
	                 },{
	                	 ref: 'studentdisciplinaryactionssureporttabstructure',
	                	 selector: 'studentdisciplinaryactionssureporttabstructure'
	                 },{
	                	 ref: 'studentdisciplinaryactionssureportstructure',
	                	 selector: 'studentdisciplinaryactionssureportstructure'
	                 },{
	                	 ref: 'studentdisciplinaryactionssureportgrid',
	                	 selector: 'studentdisciplinaryactionssureportgrid'
	                 },{
	                	 ref: 'studentdisciplinaryactionssureportfilter',
	                	 selector: 'studentdisciplinaryactionssureportfilter'
	                 },{
	                	 ref:'disciplinaryactionsusanctiondetailwindow',
	                	 selector:'disciplinaryactionsusanctiondetailwindow'
	                 },{
	         			ref : 'disciplinaryactiondocumentsulist',
	        			selector : 'disciplinaryactiondocumentsulist'
	        		},{
	        			ref :'disciplinaryactiondocumentlistgridsu',
	        			selector :'disciplinaryactiondocumentlistgridsu'
	        		}
],
	            	
	                 init: function(application) {
	                	 this.control({
	                		 
	                		  'studentdisciplinaryactionsreporttabstructure':{
	               			   render:function(studentdisciplinaryactionsreporttabstructure){
	               				   this.enableTabforstudentdisciplinaryPanel(studentdisciplinaryactionsreporttabstructure);
	               			   },
	               		   afterrender:function(structure)
	               		   {
	               			   var grid=structure.down('studentdisciplinaryactionsreportgrid');
	               			   this.getGridHeaderFreeze(grid,structure,true);
	               		   }
	               		   },
	                		 
	                		 
	                		 
	                		 
	                		'studentdisciplinaryactionsreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.disciplinaryActionsReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 store.load();
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				 if(wheatherSchool){
	                					 var form = obj.up('form');
	            	                	 var period = form.down('#periodId');
	            	                	 //period.reset();
	            	                	 period.setVisible(false);
	                				 }
	                			 }
	                		 },
	                		 'studentdisciplinaryactionsreportfilter combo#studentId': {
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 store.load();
	                			 },
	                			 select: function(combo, newValue, oldValue, eOpts) {
	                				 $this = this;
	         				        var studentdisciplinaryReport = $this.getStudentdisciplinaryactionsreportfilter();
	        				            var studentId = combo.getValue();
	        				            Ext.Ajax.request({
	        				                method: "GET",
	        				                type: 'rest',
	        				                url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
	        				                headers: {
	        				                    'Content-Type': 'application/json'
	        				                },
	        				                params: {
	        				                    studentId: studentId
	        				                },
	        				                success: function(response, action) {
	        				                    var data = Ext.decode(response.responseText);
	        				                    var programGroupCombo = studentdisciplinaryReport.down('#programGroupCombo');
	        				                    
	        				                    //var programCombo = studentIncidentsReport.down('#programId');
	        				                    //programCombo.setReadOnly(true);
	        				                    var academyLocationId=$this.getCurrentAcademyLocation();
	        				                    var programGroupComboStore = programGroupCombo.getStore();
	        				                    programGroupComboStore.load({
	        				                    	callback: function(records, operation, success) {
	        				                    		if (!isNullOrEmpty(data[0].programGroupId)) {
	        				                    			programGroupCombo.setValue(data[0].programGroupId);
	        				                    			programGroupCombo.setReadOnly(true);
	        				                    			var programCombo = studentdisciplinaryReport.down('#programId');
	        				                    			// batchCombo.setReadOnly(true);
	        				                    			programCombo.setDisabled(false);
	        				                    			// batchCombo.allowBlank = false;
	        				                    			var programComboStore = programCombo.getStore();
	        				                    			programComboStore.getProxy().extraParams = {
	        				                    				studentId:studentId,
	        				                    				programGroupId:data[0].programGroupId
	        				                    			};

	        				                    			programComboStore.load({
	        				                    				callback: function(records, operation, success) {
	        				                    					if (!isNullOrEmpty(data[0].programId)) {

	        				                    						programCombo.setValue(data[0].programId);
	        				                    						var batchCombo = studentdisciplinaryReport.down('#batchId');
	        				                    						// batchCombo.setReadOnly(true);
	        				                    						batchCombo.setDisabled(false);
	        				                    						// batchCombo.allowBlank = false;
	        				                    						var batchComboStore = batchCombo.getStore();
	        				                    						batchComboStore.getProxy().extraParams = {
	        				                    							studentId:studentId
	        				                    						};

	        				                    						batchComboStore.load({
	        				                    							callback: function(records, operation, success) {
	        				                    								if (!isNullOrEmpty(data[0].batchId)) {
	        				                    									batchCombo.setValue(data[0].batchId);
	        				                    									var periodCombo = studentdisciplinaryReport.down('#periodId');
	        				                    									//periodCombo.setReadOnly(true);
	        				                    									periodCombo.setDisabled(false);
	        				                    									var periodComboStore = periodCombo.getStore();
	        				                    									periodComboStore.getProxy().extraParams = {
	        				                    										studentId:studentId,
	        				                    										isDiciplinaryOrPositiveReportScreen: true
	        				                    									};

	        				                    									periodComboStore.load({
	        				                    										callback: function(records, operation, success) {
	        				                    											periodCombo.setValue(data[0].programPeriodId);
	        				                    											var sectionCombo = studentdisciplinaryReport.down('#section');
	        				                    											sectionCombo.setDisabled(false);
	        				                    											var sectionComboStore = sectionCombo.getStore();
	        				                    											sectionComboStore.getProxy().extraParams = {
	        				                    												periodId: data[0].programPeriodId
	        				                    											};
	        				                    											sectionComboStore.load({
	        				                    												callback: function(records, operation, success) {
	        				                    													if (!isNullOrEmpty(data[0].sectionId)) {
	        				                    														//sectionCombo.setValue(data[0].sectionId);
	        				                    													}else {
	        				                    														sectionCombo.emptyText = [ '' ];
	        				                    														sectionCombo.applyEmptyText();
	        				                    														sectionCombo.reset();
	        				                    													}
	        				                    												}
	        				                    											});
	        				                    										}
	        				                    									});
	        				                    								}
	        				                    							}
	        				                    						});
	        				                    					}
	        				                    				}
	        				                    			}); 
	        				                    		}
	        				                    	}
	        				                    });
	        				                }
	        				            });
	        				       // }
	        				    }
	                		 },
	                		 'studentdisciplinaryactionsreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.disciplinaryActionsReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentdisciplinaryactionsreportfilter combo#periodId':{
	                			 select: function(obj, record){
	                				 this.disciplinaryActionsReportPeriodSelect(obj, record)
	                			 }
	                		 },
	                		 'studentdisciplinaryactionsreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				 var grid = this.getStudentdisciplinaryactionsreportgrid();
	                				 var store = grid.getStore();
	                				 var form = this.getStudentdisciplinaryactionsreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = form.getForm().getValues();
	                				 store.getProxy().extraParams = {
	                					 studentId : values.studentId,
	                					 programGroupId : values.programGroupCombo,
	                					 incidentTypeId : values.incidentType,
	                					 programId : values.PROGRAM_NAME,
	                					 batchId : values.BATCH_NAME,
	                					 periodId : values.PERIOD_NAME,
	                					 sectionId : values.SECTION,
	                					 startDate : values.startDate,
	                					 endDate : values.endDate
	                				 }
	                				 this.resetPageSetting(store);
	                				 store.load({
	    		            			callback: function(records, operation, success) {
	    		            				 form.down('#searchBtn').setDisabled(false);
	    		            			}
	    	            			});
	                				 grid.config.searchFilterForm = this.getStudentdisciplinaryactionsreportfilter();
	                			 }
	                		 },
	                		 'studentdisciplinaryactionsreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var batch = form.down('#batchId');
	                				 var period = form.down('#periodId');
            	                	 var section = form.down('#section');
            	                	 var programGroupCombo = form.down('#programGroupCombo');
	                				 programGroupCombo.setReadOnly(false);
            	                	 
            	                	 section.setDisabled(true);
	                				 batch.setDisabled(true);
	                				 period.setDisabled(true);
	                				 var startDate = form.down('#startDate');
	                				 var endDate = form.down('#endDate');
	                				 startDate.setMaxValue(new Date());
	                				 startDate.setMinValue(false);
	                				 endDate.setMaxValue(new Date());
	                				 endDate.setMinValue(false);

	                				 var program = form.down('#programId');
	                				 var programStore = program.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 programStore.load();
	                			 }
	                		  },
	                		  'studentdisciplinaryactionsreportgrid ': {
	                  			   render: function(grid){
	                  				 if (portalId == 2) {
	                  					 this.doAccessControlValidation(grid, this.getFP_DISCIPLINARY_ACTION_REPORT_PERMISSIONS());
	                   				 }else{
	                   					 this.doAccessControlValidation(grid, this.getDISCIPLINARY_ACTION_REPORT_PERMISSIONS());
	                   				 }
	                  			   }
	                		  },
	                		  'studentdisciplinaryactionsreportfilter combo#programGroupCombo': {
	                			  select: function(obj, record){
	                				  this.disciplinaryActionsReportProgGropSelect(obj, record)
	                			  },
	                			  render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationId: academyLocationId
		                				 };
		                				 store.load();
		                			 }
	                		  },
	                		  'studentdisciplinaryactionssureportfilter combo#programIdItemId': {
		                			 select: function(obj, record){
		                				 this.disciplinaryActionsSUReportProgSelect(obj, record)
		                			 },
		                			 render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationIds: academyLocationId,
		                					 isAllProgram:true
		                				 };
		                				 store.load();
		                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
		                				 var wheatherSchool = alinfomodel.get('wheatherSchool');
		                				 if(wheatherSchool){
		                					 var form = obj.up('form');
		            	                	 var period = form.down('#periodItemId');
		            	                	 //period.reset();
		            	                	 period.setVisible(false);
		                				 }
		                			 }
		                		 },
		                		 'studentdisciplinaryactionssureportfilter combo#periodItemId':{
		                			 select: function(obj, record){
		                				 this.disciplinaryActionsSUReportPeriodSelect(obj, record)
		                			 }
		                		 },
		                		 'studentdisciplinaryactionssureportfilter combo#batchItemId':{
		                			 select: function(obj, record){
		                				 this.disciplinaryActionsSUReportBatchSelect(obj, record)
		                			 }
		                		 },
		                		 'studentdisciplinaryactionssureportfilter button[itemId=resetBtnSUItemId]' : {
		                			 click : function(obj) {
		                				 var form = obj.up('form');
		                				 form.getForm().reset();
		                				 var batch = form.down('#batchItemId');
		                				 var period = form.down('#periodItemId');
	            	                	 var section = form.down('#sectionItemId');
	            	                	 var programGroupCombo = form.down('#programGroupComboItemId');
		                				 programGroupCombo.setReadOnly(false);
	            	                	 
	            	                	 section.setDisabled(true);
		                				 batch.setDisabled(true);
		                				 period.setDisabled(true);
		                				 var startDate = form.down('#fromDateItemId');
		                				 var endDate = form.down('#toDateItemId');
		                				 startDate.setMaxValue(new Date());
		                				 startDate.setMinValue(false);
		                				 endDate.setMaxValue(new Date());
		                				 endDate.setMinValue(false);

		                				 var program = form.down('#programIdItemId');
		                				 var programStore = program.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 programStore.getProxy().extraParams = {
		                					 academyLocationIds: academyLocationId,
		                					 isAllProgram:true
		                				 };
		                				 programStore.load();
		                			 }
		                		  },
		                		  'studentdisciplinaryactionssureportfilter button[itemId=searchBtnSUItemID]' : {
			                			 click : function(form) {
			                				 var grid = this.getStudentdisciplinaryactionssureportgrid();
			                				 var store = grid.getStore();
			                				 var form = this.getStudentdisciplinaryactionssureportfilter();
			                				 form.down('#searchBtnSUItemID').setDisabled(true);
			                				 var values = form.getForm().getValues();
			                				 store.getProxy().extraParams = {
			                					 studentId : values.studentId,
			                					 programGroupId : values.programGroupCombo,
			                					 incidentTypeId : values.typeOfMisconduct,
			                					 programId : values.PROGRAM_NAME,
			                					 batchId : values.BATCH_NAME,
			                					 periodId : values.PERIOD_NAME,
			                					 sectionId : values.SECTION,
			                					 startDate : values.fromDate,
			                					 endDate : values.toDate,
			                					 sanctionTypeId : values.sanctionType,
			                					 recallDate : values.recallDate
			                				 }
			                				 this.resetPageSetting(store);
			                				 store.load({
				    		            			callback: function(records, operation, success) {
				    		            				 form.down('#searchBtnSUItemID').setDisabled(false);
				    		            			}
				    	            			});
			                				 grid.config.searchFilterForm = this.getStudentdisciplinaryactionssureportfilter();
			                			 }
			                     },
			                     'studentdisciplinaryactionssureportgrid':{
			                    		cellclick : function(grid, CellEl, ColIdx, records, RowEl, RowIdx, e,eopts) {
			                    			var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
			                    			var this$ = this;
			                    			if(columnName == "sanctionDetails"){
			   								  if(e.target.tagName=='A'){
			   									 this.showSanctionDetailsOnPopUpWindowReport(records);
			   								 }
			   							  }else if(columnName == "documents"){
			  								if(e.target.tagName=='A'){
			  									if(records.data.documents.length == 1){			 							
			  										 var documentId= records.data.documents["0"].documentId;
			  										this$.getController('Academia.controller.document.DocumentController').downloadDocumentFile(documentId);
                                                     
			  								   } else if(records.data.documents.length > 1){
			  											var docWindow = this.getDisciplinaryactiondocumentsulist();
			  											if (!docWindow) {
			  												// Ext.widget('disciplinaryactiondocumentlist');
			  												docWindow = Ext.widget('disciplinaryactiondocumentsulist',{
			  													itemId:'studentDisciplinaryReportDocumentSu'
			  												});
			  												//  docWindow = this.getDisciplinaryactiondocumentlist();
			  											}
			  											docWindow.show();
			  											var disciplinaryactiondocumentlistgrid = this.getDisciplinaryactiondocumentlistgridsu();
			  											disciplinaryactiondocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
			  											var store = disciplinaryactiondocumentlistgrid.getStore();
			  											store.getProxy().extraParams = {
			  												id: records.raw.disciplinaryActionId
			  											};
			  											store.load();
			  										}
			  								}
			  							
			   							  }
			                    		}
			                     },
			                     'disciplinaryactiondocumentlistgridsu':{
			 						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
			 							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
			 							var this$ = this;
			 							if(columnName == "documentName"){
			 								if(e.target.tagName=='A'){
			 									this$.getController('Academia.controller.document.DocumentController').downloadDocumentFile(record.get('documentId'));
			 								}
			 							}
			 						}
			 					},
			 					'disciplinaryactiondocumentsulist[itemId=studentDisciplinaryReportDocumentSu] disciplinaryactiondocumentlistgridsu button[itemId=btnDeleteSU]':{
									click:function(obj){
										this.deleteDisciplinarySUReportDocument();
									}
								},
								'disciplinaryactiondocumentsulist[itemId=studentDisciplinaryReportDocumentSu] disciplinaryactiondocumentlistgridsu button[itemId=downloadDocumentSUItemId]':{
									click:function(obj){
										this.documentSUDocumentZip();
									}
								}
	                	 });
	                 },
	                 
	                 
	                 enableTabforstudentdisciplinaryPanel:function(studentdisciplinaryactionsreporttabstructure)
	                 {
	                	 this.showTabfordisciplinaryPanel(studentdisciplinaryactionsreporttabstructure);
	                 },
	                 
	                 showTabfordisciplinaryPanel : function(studentdisciplinaryactionsreporttabstructure) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=studentdisciplinaryactionsreporttabstructure.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important'},
					  			   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  					xtype : 'studentdisciplinaryactionsreportstructure',
					  					itemId : 'studentdisciplinaryactionsreportstructure',
					  					title : getCommonTranslation('SEARCH'),
					  					tabCls : 'right-tab'
					  				}]
					  		   });

					  		 studentdisciplinaryactionsreporttabstructure.insert(insertPosition,panelItem);
					     },
	                 
	                 
	                 disciplinaryActionsReportProgGropSelect : function(obj, record) {
	                	 var programgroupId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var program = form.down('#programId');
	                	 var batch = form.down('#batchId');
	                	 var period = form.down('#periodId');
	                	 var section = form.down('#section');
	                	 program.reset();
	                	 batch.reset();
	                	 period.reset();
	                	 section.reset();
	                	 batch.setDisabled(true);
	                	 period.setDisabled(true);
	                	 section.setDisabled(true);
	                	 if(programgroupId > 0){
	                		 var store = program.getStore();
	                		 store.getProxy().extraParams = {
	                			 programGroupId: programgroupId,
	                			 academyLocationIds: academyLocationId,
            					 isAllProgram:true
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 disciplinaryActionsReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(true);
	                	 
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(true);
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 disciplinaryActionsReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(true);
	                	 
	                	 var batchId = record[0].get("id");
	                	 if(batchId > 0){	    	        					  
	                		 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: batchId
	                		 };
	                		 //store.load();
	                		 store.load({
								   callback: function(records, operation, success) {
									   if (success) {
										   if(records.length > 0){
											   if(wheatherSchool){
												   period.setValue(records[0].data.id);
												   var form = obj.up('form');
							                	   var section = form.down('#section');
							                	   section.reset();
							                	   section.setDisabled(false);
							                	   var periodId = records[0].data.id;
								                	 if(periodId > 0){	    	        					  
								                		 var store = section.getStore();
								                		 store.getProxy().extraParams = {
								                			 periodId: periodId
								                		 };
								                		 store.load();
								                	 }
											   }
										   }
									   }
								   }
							    });
	                	 }
	                 },
	                 disciplinaryActionsReportPeriodSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(false);
	                	 var periodId = record[0].get("id");
	                	 if(periodId > 0){	    	        					  
	                		 var store = section.getStore();
	                		 store.getProxy().extraParams = {
	                			 periodId: periodId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 disciplinaryActionsSUReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchItemId');
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 
	                	 var period = form.down('#periodItemId');
	                	 period.reset();
	                	 period.setDisabled(true);
	                	 
	                	 var section = form.down('#sectionItemId');
	                	 section.reset();
	                	 section.setDisabled(true);
	                	 
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 disciplinaryActionsSUReportPeriodSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var section = form.down('#sectionItemId');
	                	 section.reset();
	                	 section.setDisabled(false);
	                	 var periodId = record[0].get("id");
	                	 if(periodId > 0){	    	        					  
	                		 var store = section.getStore();
	                		 store.getProxy().extraParams = {
	                			 periodId: periodId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 disciplinaryActionsSUReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodItemId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 
	                	 var section = form.down('#sectionItemId');
	                	 section.reset();
	                	 section.setDisabled(true);
	                	 
	                	 var batchId = record[0].get("id");
	                	 if(batchId > 0){	    	        					  
	                		 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: batchId
	                		 };
	                		 //store.load();
	                		 store.load({
								   callback: function(records, operation, success) {
									   if (success) {
										   if(records.length > 0){
											   if(wheatherSchool){
												   period.setValue(records[0].data.id);
												   var form = obj.up('form');
							                	   var section = form.down('#sectionItemId');
							                	   section.reset();
							                	   section.setDisabled(false);
							                	   var periodId = records[0].data.id;
								                	 if(periodId > 0){	    	        					  
								                		 var store = section.getStore();
								                		 store.getProxy().extraParams = {
								                			 periodId: periodId
								                		 };
								                		 store.load();
								                	 }
											   }
										   }
									   }
								   }
							    });
	                	 }
	                 },
	                 showSanctionDetailsOnPopUpWindowReport: function(records){
	         			
	         			var docWindow = this.getDisciplinaryactionsusanctiondetailwindow();
	         			if (!docWindow) {
	         				docWindow = Ext.widget('disciplinaryactionsusanctiondetailwindow',{
	         					itemId:'disciplinaryactionsusanctiondetailwindowItemId'
	         				});
	         			}
	         			docWindow.show();
	         			var sanctionGrid = docWindow.down('#sanctiondetailsgridItemId');
	         			sanctionGrid.setTitle(getPersonModuleTranslation('SANCTION_DETAILS'));
	         			sanctionGrid.getStore().removeAll();
	         			setTimeout(function(){
	         				if(!isNullOrEmpty(records.raw.disciplinaryActionId)){
	         					Ext.Ajax.request({
	         						type: 'rest',
	         						url: SERVERURL.PATH_FIND_SANCTION_DETAIL_SU,
	         						method: "GET",
	         						params:{
	         							id:records.raw.disciplinaryActionId
	         						},
	         						success: function(frm, action) {
	         							Ext.getBody().unmask();
	         							var data = Ext.JSON.decode(frm.responseText);
	         							sanctionGrid.getStore().loadData(data);
	         						}
	         					});
	         				}
	         			},300);
	         			sanctionGrid.down('#btnAdd').hide();
	         			sanctionGrid.on('beforeedit', function(editor, e) {
	         		        return false;
	         		        });
	         			
	         			sanctionGrid.columns.forEach(function(obj){
	         				if(obj.dataIndex == 'addButton' || obj.dataIndex == 'deleteButton'){
	         					obj.destroy();
	         				}
	         			});

	         			var sanctionTypeCombo = sanctionGrid.columns[0].getEditor();
	         			sanctionTypeCombo.getStore().load();

	         			var appealOutcomeCombo = sanctionGrid.columns[4].getEditor();
	         			appealOutcomeCombo.getStore().load();
	         			
	         		},
	         		deleteDisciplinarySUReportDocument:function(){
						var $this=this;
						var form = $this.getDisciplinaryactiondocumentsulist();
						var studentdisciplinaryactionssureportgrid= $this.getStudentdisciplinaryactionssureportgrid();
						var disciplinaryaction = this.getDisciplinaryactiondocumentlistgridsu();
						var disciplinaryActionDocGrid=form.down('#disciplinaryactiondocumentlistgridItemIdsu');
						if (disciplinaryActionDocGrid.getSelectionModel().getCount() > 0) {
							var records = disciplinaryActionDocGrid.getSelectionModel().getSelection();
							var ids=[];
							Ext.Array.each(records,function(value){
								ids.push(value.data.id);
							});
							showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTIVITY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
								if (btn == 'yes'){
									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
									Ext.Ajax.request({
										method: "DELETE",
										type: 'rest',
										url : SERVERURL.DELETE_FILE_DOCUMENT_SU+'?fileDocumentIds='+ids.join(),
										headers: {
											'Content-Type': 'application/json'
										},
										success: function(form, action) {

											Ext.getBody().unmask();
											showSuccessMessage(getPersonModuleTranslation('DISCIPLINARY_ACTIVITY'),getPersonModuleTranslation('DISCIPLINARY_DOCUMENT_SUCCESS_DELETE_MSG'));	 
											disciplinaryActionDocGrid.store.reload();
											studentdisciplinaryactionssureportgrid.store.reload();
											disciplinaryActionDocGrid.getSelectionModel().deselectAll(true);
										}
									});
								}
							});
						} else {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
						}
					},
					documentSUDocumentZip : function() {
						
						var $this = this;
						var form = $this.getDisciplinaryactiondocumentsulist();
						var disciplinaryActionGrid=form.down('#disciplinaryactiondocumentlistgridItemIdsu');
						if (disciplinaryActionGrid.getSelectionModel().getCount() > 0) {
							var records = disciplinaryActionGrid.getSelectionModel().getSelection();
							var dispatchZipName = "Disciplinary action SU Documnet";
							var saveModel=[];  
							for(var i in records){
								if(!isNullOrEmpty(records[i].get('path'))) {
									saveModel.push(records[i].get('path'));
								}
								showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION_SU_DOCUMENTS'),
										getPersonModuleTranslation('DISCIPLINARY_ACTION_SU_DOCUMENTS_ALERT'),
										function(btn, text) {
									if (btn == 'yes') {
										var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
										$this.getController('Academia.controller.document.DocumentController')
										.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
									}
								});

							}
						}
						else {
							$this.hideWindowMask();
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}
	                 
});
