/**
 * @author Priyanshi sharma
 * */

Ext.define('Academia.controller.student.feeRegistrationFormSetup.FeeRegistrationFormSetupController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['student.feeRegistrationFormSetup.FeeRegFormSetupGridStore'],
	views: ['student.feeRegistrationFormSetup.FeeRegistrationFormSetupStructure','student.feeRegistrationFormSetup.FeeRegistrationFormSetupFilter',
		'student.feeRegistrationFormSetup.FeeRegistrationFormSetupGrid','student.feeRegistrationFormSetup.FeeRegistrationFormSetupWindow'],
		refs: [{
			ref:'feeregistrationformsetupstructure',
			selector:'feeregistrationformsetupstructure'
		},{
			ref:'feeregistrationformsetupfilter',
			selector:'feeregistrationformsetupfilter'
		},{
			ref:'feeregistrationformsetupgrid',
			selector:'feeregistrationformsetupgrid'
		},{
			ref:'feeregistrationformsetupwindow',
			selector:'feeregistrationformsetupwindow' 
		}],
		init: function() {
			this.control({
				'feeregistrationformsetupgrid button[itemId=btnAdd]':{
					click:this.showFeeRegFormSetupWin
				},
				'feeregistrationformsetupgrid button[itemId=btnEdit]':{
					click:this.setDataOnFeeRegFormSetupWin
				},
				'feeregistrationformsetupgrid button[itemId=btnView]':{
					click:this.setDataOnFeeRegFormSetupWin
				},
				'feeregistrationformsetupgrid button[itemId=btnDelete]':{
					click:this.deleteFeeRegFormSetup
				},
				'feeregistrationformsetupgrid':{
					beforeselect: function(selModel, record, index, eOpts) {
						var structure = this.getFeeregistrationformsetupstructure();
						structure.config.lastScrollTop = structure.body.getScrollTop();
					},
					selectionchange: function(column, selected,eOpts ){
						var structure = this.getFeeregistrationformsetupstructure();
						var grid = this.getFeeregistrationformsetupgrid();
						grid.down('#btnEdit').setDisabled(false);
						grid.down('#btnView').setDisabled(false);
						if(selected.length){
							var records = grid.getSelectionModel().getSelection();
							if(records && records.length>1){
								grid.down('#btnEdit').setDisabled(true);
								grid.down('#btnView').setDisabled(true);
							}
						}else{
							grid.down('#btnEdit').setDisabled(true);
							grid.down('#btnView').setDisabled(true);
						}
						Ext.defer(function() {
							structure.body.setScrollTop(structure.config.lastScrollTop);
						}, 80, this);
					}
				},
				'feeregistrationformsetupfilter button[itemId=searchBtnFeeRegSetupItemId]':{
					click:this.searchFeeRegSetupData
				},
				'feeregistrationformsetupfilter button[itemId=resetFeeRegSetupfilterItemId]':{
					click:function(btn){
						var form = btn.up('feeregistrationformsetupfilter');
						if(form){
							form.getForm().reset();
							if(form.down('#feeRegSetupLocationItemId')){
							  form.down('#feeRegSetupLocationItemId').clearValue();
							  form.down('#feeRegSetupLocationItemId').setDisabled(true);
							}
						}
					}
				},
				'feeregistrationformsetupfilter customcombobox[itemId=feeRegSetupAcademyItemId]':{
					select:function(combo){
						var location,store,filter = this.getFeeregistrationformsetupfilter();
						if(filter){
							location = filter.down('#feeRegSetupLocationItemId');
							if(location){
								location.setDisabled(false);
								store = location.getStore();
								location.reset();
								if(store){
									store.getProxy().extraParams={
										id:combo.getValue()
									};
									store.load();
								}
							}
						}
					}
				},
				'feeregistrationformsetupwindow customcombobox[itemId=feeRegSetupFormAcademyItemId]':{
					select:function(combo){
						var location,store,win = this.getFeeregistrationformsetupwindow();
						if(win){
							location = win.down('#feeRegSetupFormLocationItemId');
							if(location){
								location.setDisabled(false);
								store = location.getStore();
								location.reset();
								if(store){
									store.getProxy().extraParams={
										id:combo.getValue()
									};
									store.load();
								}
							}
						}
					}
				},
				'feeregistrationformsetupwindow button[itemId=btnCancelFeeRegSetupForm]':{
					click:function(btn){
						var win = btn.up('feeregistrationformsetupwindow');
						if(win){
							win.close();
						}
					}
				},
				'feeregistrationformsetupwindow button[itemId=btnSaveFeeRegSetupForm]':{
					click:function(btn){
						this.saveFeeRegFormSetupData();
					}
				}
			});
		},
		showFeeRegFormSetupWin:function(){
			var feeRegFormSetupWin = this.getFeeregistrationformsetupwindow();
			if (!feeRegFormSetupWin) {
				Ext.widget('feeregistrationformsetupwindow');
				feeRegFormSetupWin = this.getFeeregistrationformsetupwindow();
			}
			feeRegFormSetupWin.show();
		},
		saveFeeRegFormSetupData:function(){
			var me = this,win = this.getFeeregistrationformsetupwindow(),
			filter = this.getFeeregistrationformsetupfilter();
			formData = win.down('form').getForm().getValues();
			if(isNullOrEmpty(formData.regPopupContent) && isNullOrEmpty(formData.financeClause) && isNullOrEmpty(formData.docCheckBoxContentFirst) && 
					isNullOrEmpty(formData.docCheckBoxContentSecond) && isNullOrEmpty(formData.docCheckBoxContentThird) && isNullOrEmpty(formData.docCheckBoxContentFourth) &&
					isNullOrEmpty(formData.docCheckBoxContentFifth) && isNullOrEmpty(formData.docCheckBoxContentSixth)){
			  return showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('AT_LEAST_ONE_FIELD_SHOULD_BE_CONFIGURED'));
			}
			var locationArr=[];
			for (var i=0; i<formData.feeRegSetupFormLocation.length; i++) {
				academyLocation={
					"id":(formData.feeRegSetupFormLocation[i].data!=undefined)?formData.feeRegSetupFormLocation[i].data.locationId:formData.feeRegSetupFormLocation[i]
				}	
				locationArr.push(academyLocation)
			}
			var academy = {
				"id":formData.feeRegSetupFormAcademy
			};
			if(locationArr && locationArr.length>10){
				return showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAXIMUN_10_CAN_BE_SELECTED'));
			}
			if(formData.id){
				var submitUrl = SERVERURL.PATH_FIND_STUDENT_FEE_REGISTRATION_UPDATE;
				var apiType = 'PUT';
				var academyLocation={
						"id":formData.feeRegSetupFormLocation
				};	
				locationArr.push(academyLocation);
				var json={
						"id":formData.id,
						"academy":academy,
						"locations":locationArr,
						"registrationPopUpContent":formData.regPopupContent,
						"financeClause":formData.financeClause,
						"firstDocumentCheckBoxContent":formData.docCheckBoxContentFirst,
						"secondDocumentCheckBoxContent":formData.docCheckBoxContentSecond,
						"thirdDocumentCheckBoxContent":formData.docCheckBoxContentThird,
						"fourthDocumentCheckBoxContent":formData.docCheckBoxContentFourth,
						"fifthDocumentCheckBoxContent":formData.docCheckBoxContentFifth,
						"sixthDocumentCheckBoxContent":formData.docCheckBoxContentSixth,
				};
			}else{
				var submitUrl = SERVERURL.PATH_SAVE_STUDENT_FEE_REG_FORM_NEW_SETUP;
				var apiType = 'POST';
				var json={
						"academy":academy,
						"locations":locationArr,
						"registrationPopUpContent":formData.regPopupContent,
						"financeClause":formData.financeClause,
						"firstDocumentCheckBoxContent":formData.docCheckBoxContentFirst,
						"secondDocumentCheckBoxContent":formData.docCheckBoxContentSecond,
						"thirdDocumentCheckBoxContent":formData.docCheckBoxContentThird,
						"fourthDocumentCheckBoxContent":formData.docCheckBoxContentFourth,
						"fifthDocumentCheckBoxContent":formData.docCheckBoxContentFifth,
						"sixthDocumentCheckBoxContent":formData.docCheckBoxContentSixth,
				};
			}
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			var submitJson = Ext.encode(json);
			Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : submitJson,
				method : apiType,
				success : function(resp, action) {
					if(formData.id){
						showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
					}else{
						showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
					}
					var grid = me.getFeeregistrationformsetupgrid();
					if(!isNullOrEmpty(grid)){
						grid.getSelectionModel().deselectAll();
						me.resetGridSetting(grid);
						me.resetPageSetting(grid.store);
						grid.store.proxy.extraParams={};
						grid.getStore().load();
					}
					Ext.defer(function() {
						filter.getForm().reset();
						if(filter.down('#feeRegSetupLocationItemId')){
							filter.down('#feeRegSetupLocationItemId').clearValue();
							filter.down('#feeRegSetupLocationItemId').setDisabled(true);
						}
					}, 500); 
					win.close();
					Ext.getBody().unmask(); 
				}
			});
		},
		setDataOnFeeRegFormSetupWin:function(button){
			var grid = this.getFeeregistrationformsetupgrid(),
			record = grid.getSelectionModel().getSelection();
			if(record && record.length>0){
				this.showFeeRegFormSetupWin();
				var win = this.getFeeregistrationformsetupwindow();
				win.down('#feeRegSetupFormAcademyItemId').setReadOnly(true);
				win.down('#feeRegSetupFormLocationItemId').setReadOnly(true);
				win.down('#feeRegFormHiddenField').setValue(record[0].data.id);
				if(record[0].data && record[0].data.academy){
					win.down('#feeRegSetupFormAcademyItemId').getStore().load({
						callback:function(records, operation, success){
							 for(var i in records){
     							 if(records[i].data.id == record[0].data.academy.id){
     								win.down('#feeRegSetupFormAcademyItemId').setValue(record[0].data.academy.id);
     							 }
     						 }
							win.down('#feeRegSetupFormLocationItemId').setDisabled(false);
						}
					});
				}
				if(record[0].data && record[0].data.locations && record[0].data.locations.length>0){
					win.down('#feeRegSetupFormLocationItemId').getStore().proxy.extraParams={
						id:record[0].data.academy.id
					};
					win.down('#feeRegSetupFormLocationItemId').getStore().load({
						callback:function(records, operation, success){
							 for(var i in records){
     							 if(records[i].data.locationId == record[0].data.locations[0].id){
     								win.down('#feeRegSetupFormLocationItemId').setValue(record[0].data.locations[0].id);
     							 }
     						 }
						}
					});
				}
				win.down('#regPopupContentItemId').setValue(record[0].data.registrationPopUpContent);
				win.down('#financeClauseItemId').setValue(record[0].data.financeClause);
				win.down('#docCheckBoxContentFirst').setValue(record[0].data.firstDocumentCheckBoxContent);
				win.down('#docCheckBoxContentSecond').setValue(record[0].data.secondDocumentCheckBoxContent);
				win.down('#docCheckBoxContentThird').setValue(record[0].data.thirdDocumentCheckBoxContent);
				win.down('#docCheckBoxContentFourth').setValue(record[0].data.fourthDocumentCheckBoxContent);
				win.down('#docCheckBoxContentFifth').setValue(record[0].data.fifthDocumentCheckBoxContent);
				win.down('#docCheckBoxContentSixth').setValue(record[0].data.sixthDocumentCheckBoxContent);
				if(button.itemId=='btnView'){
					form = win.down('form').getForm();
					toggleReadOnlyFormItems(form,true);
					Ext.defer(function() {
						form.owner.removeCls('readonly-form');
			    	},500, this);
					win.down('#btnSaveFeeRegSetupForm').setVisible(false);
				}
			}
		},
		deleteFeeRegFormSetup:function(){
	        var this$ = this;
	        var grid = this$.getFeeregistrationformsetupgrid();
	    	var grdStore = grid.getStore();
	    	if (grid.getSelectionModel().getCount() > 0) {
	    		showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	    			if (btn == 'yes') {
						var records = grid.getSelectionModel().getSelection();
						var ids=[];
						Ext.each(records,function(record){
							ids.push(record.data.id);
						});
						Ext.Ajax.request({
							type: 'rest',
							method: 'DELETE',
							url: SERVERURL.PATH_FIND_STUDENT_FEE_REGISTRATION_DELTETE+'?ids='+ ids,
							headers: {
								'Content-Type': 'application/json'
							},
							success: function(form, action) {
								showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
								this$.resetGridSetting(grid);
								this$.resetPageSetting(grid.store);
								grdStore.reload();
							}
						});
					}
	    		});
	    	} else {
	    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
		},
		searchFeeRegSetupData:function(){
			var grid = this.getFeeregistrationformsetupgrid(),filter = this.getFeeregistrationformsetupfilter();
			var filterSelectedData = filter.getForm().getValues();
			var locationArr=[];
			for (var i=0; i<filterSelectedData.feeRegSetupLocation.length; i++) {
				var locationIds = (filterSelectedData.feeRegSetupLocation[i].data!=undefined)?filterSelectedData.feeRegSetupLocation[i].data.locationId:filterSelectedData.feeRegSetupLocation[i]
				locationArr.push(locationIds)
			}
			if(grid && grid.store && grid.store.getProxy){
				grid.store.getProxy().extraParams={
					academyId:filterSelectedData.feeRegSetupAcademy,
					locationIds:locationArr.join()
				};
				grid.getSelectionModel().deselectAll();
				this.resetGridSetting(grid);
				this.resetPageSetting(grid.store);
				grid.store.load();
			}
		}
});