/**
 * @author Amit G
 */
Ext.define('Academia.controller.student.incidentsReport.StudentIncidentsReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch','feeandpayment.managebill.Student',
	         'common.picklist.AcademyTypeStore','personinfo.common.disciplinaryactivity.DisciplinaryTypeOfIncidentSearchCombo',
	         'Academia.store.attendance.SectionAndFacultyByPeriodID','Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	         'Academia.store.common.CurrentBatchStore','common.AssignedProgramStore',
	         'student.report.StudentPositiveIncidentsReportStore','admission.applicationFormSale.ProgramGroupComboStore',
	         'common.IncidentTypeStore','common.CategoryOfIncidentStore','common.IncidentRatingPositiveStore','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameAdmissionCodeBySmartSearch',
	         'student.report.StudentNegativeIncidentsReportStore','program.ProgramByGroupIdStore','coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch','messaging.MessagingTemplatesStore',
	         'committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore'],
	         views: ['student.incidentsReport.StudentIncidentsReportTabStructure',
	                 'student.incidentsReport.StudentIncidentsReportStructure','student.incidentsReport.StudentIncidentsReportGrid',
	                 'student.incidentsReport.StudentIncidentsReportFilter',
	                 'student.incidentsReport.StudentNegativeIncidentsReportTabStructure',
	                 'student.incidentsReport.StudentNegativeIncidentsReportStructure','student.incidentsReport.StudentNegativeIncidentsReportGrid',
	                 'student.incidentsReport.StudentNegativeIncidentsReportFilter','personinfo.student.StudentSendMessages','messaging.StudentStaticDocumentAttachmentGrid'],
	                 config : {
	                	 
	                	// STUDENT_INCIDENTS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_INCIDENTS_REPORT_PRIVILEDGE'),
	                	 POSITIVE_INCIDENTS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('POSITIVE_INCIDENTS_REPORT_PRIVILEGES'),
	                	 NEGATIVE_INCIDENTS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('NEGATIVE_INCIDENTS_REPORT_PRIVILEGES'),
	                	 FP_POSITIVE_INCIDENTS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_POSITIVE_INCIDENTS_REPORT_PRIVILEGES'),
	                	 FP_NEGATIVE_INCIDENTS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_NEGATIVE_INCIDENTS_REPORT_PRIVILEGES'),
	                	 STUDENT_LIST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LIST_PRIVILEGES')
	                 },
	                 refs: [{
	                	 ref: 'studentincidentsreportfilter',
	                	 selector: 'studentincidentsreportfilter'
	                 },{
	                	 ref: 'studentincidentsreportgrid',
	                	 selector: 'studentincidentsreportgrid'
	                 },{
	                	 ref: 'studentnegativeincidentsreportfilter',
	                	 selector: 'studentnegativeincidentsreportfilter'
	                 },{
	                	 ref: 'studentnegativeincidentsreportgrid',
	                	 selector: 'studentnegativeincidentsreportgrid'
	                 },{
	                     ref: 'contentPanel',
	                     selector: 'contentpanel'
	                 },{
	                 	ref :'studentsendmessages',
	                	selector : 'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows]'
	                },{
	                	ref :'negativeIncidentReportStaticDocumentAttachmentGridMessageGrid',
	                	selector : 'studentstaticdocumentattachmentgrid [itemId=negativeIncidentReportStaticDocumentAttachmentGridMessage]'
	                }],
	            	
	                 init: function(application) {
	                	 this.control({
	                		'studentincidentsreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.incidentsReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 store.load();
	                				 
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				 if(wheatherSchool){
	                					 var form = obj.up('form');
	            	                	 var period = form.down('#periodId');
	            	                	 //period.reset();
	            	                	 period.setVisible(false);
	                				 }
	                			 }
	                		 },
	                		 'studentincidentsreportfilter combo#studentId': {
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 store.load();
	                			 },
	                			 select: function(combo, newValue, oldValue, eOpts) {
	                				 $this = this;
	         				        var studentIncidentsReport = $this.getStudentincidentsreportfilter();
	        				       /* var userCombo = studentIncidentsReport.down('#userGroupId');
	        				        var userType = userCombo.getValue(); */
	        				       // if (!isNullOrEmpty(userType) && userType == 3) { // userType == 3(Student)
	        				            var studentId = combo.getValue();
	        				            Ext.Ajax.request({
	        				                method: "GET",
	        				                type: 'rest',
	        				                url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
	        				                headers: {
	        				                    'Content-Type': 'application/json'
	        				                },
	        				                params: {
	        				                    studentId: studentId
	        				                },
	        				                success: function(response, action) {
	        				                    var data = Ext.decode(response.responseText);
	        				                    var programGroupCombo = studentIncidentsReport.down('#programGroupCombo');
	        				                    
	        				                    //var programCombo = studentIncidentsReport.down('#programId');
	        				                    //programCombo.setReadOnly(true);
	        				                    var academyLocationId=$this.getCurrentAcademyLocation();
	        				                    var programGroupComboStore = programGroupCombo.getStore();
	        				                    programGroupComboStore.load({
	        				                    	callback: function(records, operation, success) {
	        				                    		if (!isNullOrEmpty(data[0].programGroupId)) {
	        				                    			programGroupCombo.setValue(data[0].programGroupId);
	        				                    			programGroupCombo.setReadOnly(true);
	        				                    			var programCombo = studentIncidentsReport.down('#programId');
	        				                    			// batchCombo.setReadOnly(true);
	        				                    			programCombo.setDisabled(false);
	        				                    			// batchCombo.allowBlank = false;
	        				                    			var programComboStore = programCombo.getStore();
	        				                    			programComboStore.getProxy().extraParams = {
	        				                    				studentId:studentId,
	        				                    				programGroupId:data[0].programGroupId
	        				                    			};

	        				                    			programComboStore.load({
	        				                    				callback: function(records, operation, success) {
	        				                    					if (!isNullOrEmpty(data[0].programId)) {

	        				                    						programCombo.setValue(data[0].programId);
	        				                    						var batchCombo = studentIncidentsReport.down('#batchId');
	        				                    						// batchCombo.setReadOnly(true);
	        				                    						batchCombo.setDisabled(false);
	        				                    						// batchCombo.allowBlank = false;
	        				                    						var batchComboStore = batchCombo.getStore();
	        				                    						batchComboStore.getProxy().extraParams = {
	        				                    							studentId:studentId
	        				                    						};

	        				                    						batchComboStore.load({
	        				                    							callback: function(records, operation, success) {
	        				                    								if (!isNullOrEmpty(data[0].batchId)) {
	        				                    									batchCombo.setValue(data[0].batchId);
	        				                    									var periodCombo = studentIncidentsReport.down('#periodId');
	        				                    									//periodCombo.setReadOnly(true);
	        				                    									periodCombo.setDisabled(false);
	        				                    									var periodComboStore = periodCombo.getStore();
	        				                    									periodComboStore.getProxy().extraParams = {
	        				                    										studentId:studentId,
	        				                    										isDiciplinaryOrPositiveReportScreen: true
	        				                    									};

	        				                    									periodComboStore.load({
	        				                    										callback: function(records, operation, success) {
	        				                    											periodCombo.setValue(data[0].programPeriodId);
	        				                    											var sectionCombo = studentIncidentsReport.down('#section');
	        				                    											sectionCombo.setDisabled(false);
	        				                    											var sectionComboStore = sectionCombo.getStore();
	        				                    											sectionComboStore.getProxy().extraParams = {
	        				                    												periodId: data[0].programPeriodId
	        				                    											};
	        				                    											sectionComboStore.load({
	        				                    												callback: function(records, operation, success) {
	        				                    													if (!isNullOrEmpty(data[0].sectionId)) {
	        				                    														//sectionCombo.setValue(data[0].sectionId);
	        				                    													}else {
	        				                    														sectionCombo.emptyText = [ '' ];
	        				                    														sectionCombo.applyEmptyText();
	        				                    														sectionCombo.reset();
	        				                    													}
	        				                    												}
	        				                    											});
	        				                    										}
	        				                    									});
	        				                    								}
	        				                    							}
	        				                    						});
	        				                    					}
	        				                    				}
	        				                    			}); 
	        				                    		}
	        				                    	}
	        				                    });
	        				                }
	        				            });
	        				       // }
	        				    }
	                		 },
	                		 'studentincidentsreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.incidentsReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentincidentsreportfilter combo#periodId':{
	                			 select: function(obj, record){
	                				 this.incidentsReportPeriodSelect(obj, record)
	                			 }
	                		 },
	                		 'studentincidentsreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				var grid =this.getStudentincidentsreportgrid();
	                				 var store = grid.getStore();
	                				 var form = this.getStudentincidentsreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = form.getForm().getValues();
	                				 store.getProxy().extraParams = {
	                					 studentId : values.studentId,
	                					 programGroupId : values.programGroupCombo,
	                					 incidentTypeId : values.incidentType,
	                					 programId : values.PROGRAM_NAME,
	                					 batchId : values.BATCH_NAME,
	                					 periodId : values.PERIOD_NAME,
	                					 sectionId : values.SECTION,
	                					 categoryIncidentType : values.categoryIncidentType,
	                					 startDate : values.startDate,
	                					 endDate : values.endDate
	                				 }
	                				 this.resetPageSetting(store);
	                				 store.load({
	                                     callback: function(records, operation, success) {
	                                    	 form.down('#searchBtn').setDisabled(false);
	                                   }
	                               });
	                				 grid.config.searchFilterForm = this.getStudentincidentsreportfilter();
	                			 }
	                		 },
	                		 'studentincidentsreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form  = this.getStudentincidentsreportfilter();
	                				// var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var batch = form.down('#batchId');
	                				 var period = form.down('#periodId');
	                				 var section = form.down('#section');
	                				 var programGroupCombo = form.down('#programGroupCombo');
	                				 programGroupCombo.setReadOnly(false);
            	                	 
            	                	 section.setDisabled(true);
	                				 batch.setDisabled(true);
	                				 period.setDisabled(true);
	                				 
	                				 var startDate = form.down('#startDate');
	                				 var endDate = form.down('#endDate');
	                				 startDate.setMaxValue(new Date());
	                				 startDate.setMinValue(false);
	                				 endDate.setMaxValue(new Date());
	                				 endDate.setMinValue(false);

	                				 var program = form.down('#programId');
	                				 var programStore = program.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 programStore.load();
	                			 }
	                		 },
	                		 'studentincidentsreportfilter [itemId=incidentType]': {
	                         	beforerender : function(combo){
	                         		combo.store.proxy.extraParams = {
	                         				category: 'POSITIVE'
	                                 };
	                             }
	                         },
	                         'studentincidentsreportfilter [itemId=periodId]': {
	                        	 render: function(combo) {
			                         //var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
			                         //combo.bindStore(store);
			                     }
	                         },
	                         'studentincidentsreportgrid ': {
                  			   render: function(grid){
                  				 if (portalId == 2) {
                  					this.doAccessControlValidation(grid, this.getFP_POSITIVE_INCIDENTS_REPORT_PERMISSIONS());
                  					this.disableStdPositiveReportExportPivileges(grid, this.getFP_POSITIVE_INCIDENTS_REPORT_PERMISSIONS());
                  				 }else{
                  					this.doAccessControlValidation(grid, this.getPOSITIVE_INCIDENTS_REPORT_PERMISSIONS());
                  					this.disableStdPositiveReportExportPivileges(grid, this.getPOSITIVE_INCIDENTS_REPORT_PERMISSIONS());
                  				 }
                  			   },
                	         	selectionchange: function(column, selected,grid ){
                 	         		var grid = this.getStudentincidentsreportgrid();
                                	this.disableGridExportButton(column,selected,grid);                	
                                }
                  		   	 },
	                		 'studentnegativeincidentsreportfilter combo#studentId': {
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 store.load();
	                			 },
	                			 select: function(combo, newValue, oldValue, eOpts) {
	                				 $this = this;
	         				        var studentNegativeIncidentsReport = $this.getStudentnegativeincidentsreportfilter();
	        				       /* var userCombo = studentIncidentsReport.down('#userGroupId');
	        				        var userType = userCombo.getValue(); */
	        				       // if (!isNullOrEmpty(userType) && userType == 3) { // userType == 3(Student)
	        				            var studentId = combo.getValue();
	        				            Ext.Ajax.request({
	        				                method: "GET",
	        				                type: 'rest',
	        				                url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
	        				                headers: {
	        				                    'Content-Type': 'application/json'
	        				                },
	        				                params: {
	        				                    studentId: studentId
	        				                },
	        				                success: function(response, action) {
	        				                    var data = Ext.decode(response.responseText);
	        				                    var programGroupCombo = studentNegativeIncidentsReport.down('#programGroupCombo');
	        				                    
	        				                    //var programCombo = studentIncidentsReport.down('#programId');
	        				                    //programCombo.setReadOnly(true);
	        				                    var academyLocationId=$this.getCurrentAcademyLocation();
	        				                    var programGroupComboStore = programGroupCombo.getStore();
	        				                    programGroupComboStore.load({
	        				                    	callback: function(records, operation, success) {
	        				                    		if (!isNullOrEmpty(data[0].programGroupId)) {
	        				                    			programGroupCombo.setValue(data[0].programGroupId);
	        				                    			programGroupCombo.setReadOnly(true);
	        				                    			var programCombo = studentNegativeIncidentsReport.down('#programId');
	        				                    			// batchCombo.setReadOnly(true);
	        				                    			programCombo.setDisabled(false);
	        				                    			// batchCombo.allowBlank = false;
	        				                    			var programComboStore = programCombo.getStore();
	        				                    			programComboStore.getProxy().extraParams = {
	        				                    				studentId:studentId,
	        				                    				programGroupId:data[0].programGroupId
	        				                    			};

	        				                    			programComboStore.load({
	        				                    				callback: function(records, operation, success) {
	        				                    					if (!isNullOrEmpty(data[0].programId)) {

	        				                    						programCombo.setValue(data[0].programId);
	        				                    						var batchCombo = studentNegativeIncidentsReport.down('#batchId');
	        				                    						// batchCombo.setReadOnly(true);
	        				                    						batchCombo.setDisabled(false);
	        				                    						// batchCombo.allowBlank = false;
	        				                    						var batchComboStore = batchCombo.getStore();
	        				                    						batchComboStore.getProxy().extraParams = {
	        				                    							studentId:studentId
	        				                    						};

	        				                    						batchComboStore.load({
	        				                    							callback: function(records, operation, success) {
	        				                    								if (!isNullOrEmpty(data[0].batchId)) {
	        				                    									batchCombo.setValue(data[0].batchId);
	        				                    									var periodCombo = studentNegativeIncidentsReport.down('#periodId');
	        				                    									//periodCombo.setReadOnly(true);
	        				                    									periodCombo.setDisabled(false);
	        				                    									var periodComboStore = periodCombo.getStore();
	        				                    									periodComboStore.getProxy().extraParams = {
	        				                    										studentId:studentId,
	        				                    										isDiciplinaryOrPositiveReportScreen: true
	        				                    									};

	        				                    									periodComboStore.load({
	        				                    										callback: function(records, operation, success) {
	        				                    											periodCombo.setValue(data[0].programPeriodId);
	        				                    											var sectionCombo = studentNegativeIncidentsReport.down('#section');
	        				                    											sectionCombo.setDisabled(false);
	        				                    											var sectionComboStore = sectionCombo.getStore();
	        				                    											sectionComboStore.getProxy().extraParams = {
	        				                    												periodId: data[0].programPeriodId
	        				                    											};
	        				                    											sectionComboStore.load({
	        				                    												callback: function(records, operation, success) {
	        				                    													if (!isNullOrEmpty(data[0].sectionId)) {
	        				                    														//sectionCombo.setValue(data[0].sectionId);
	        				                    													}else {
	        				                    														sectionCombo.emptyText = [ '' ];
	        				                    														sectionCombo.applyEmptyText();
	        				                    														sectionCombo.reset();
	        				                    													}
	        				                    												}
	        				                    											});
	        				                    										}
	        				                    									});
	        				                    								}
	        				                    							}
	        				                    						});
	        				                    					}
	        				                    				}
	        				                    			}); 
	        				                    		}
	        				                    	}
	        				                    });
	        				                }
	        				            });
	        				       // }
	        				    }
	                		 },
                  		   	 'studentnegativeincidentsreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.negativeIncidentsReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 store.load();
	                				 
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				 if(wheatherSchool){
	                					 var form = obj.up('form');
	            	                	 var period = form.down('#periodId');
	            	                	 //period.reset();
	            	                	 period.setVisible(false);
	                				 }
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.negativeIncidentsReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportfilter combo#periodId':{
	                			 select: function(obj, record){
	                				 this.negativeIncidentsReportPeriodSelect(obj, record)
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				 var grid = this.getStudentnegativeincidentsreportgrid();
	                				 var store = grid.getStore();
	                				 var form = this.getStudentnegativeincidentsreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = form.getForm().getValues();
	                				 store.getProxy().extraParams = {
	                					 studentId : values.studentId,
	                					 programGroupId : values.programGroupCombo,
	                					 incidentTypeId : values.incidentType,
	                					 programId : values.PROGRAM_NAME,
	                					 batchId : values.BATCH_NAME,
	                					 periodId : values.PERIOD_NAME,
	                					 sectionId : values.SECTION,
	                					 startDate : values.startDate,
	                					 endDate : values.endDate
	                				 }
	                				 this.resetPageSetting(store);
	                				 store.load({
	                                     callback: function(records, operation, success) {
	                                    	 form.down('#searchBtn').setDisabled(false);
	                                   }
	                               });
	                				 grid.config.searchFilterForm = this.getStudentnegativeincidentsreportfilter();
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form = this.getStudentnegativeincidentsreportfilter();
	                				 //var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var batch = form.down('#batchId');
	                				 var period = form.down('#periodId');
	                				 var section = form.down('#section');
	                				 var programGroupCombo = form.down('#programGroupCombo');
	                				 programGroupCombo.setReadOnly(false);
            	                	 
            	                	 section.setDisabled(true);
	                				 batch.setDisabled(true);
	                				 period.setDisabled(true);
	                				 
	                				 var startDate = form.down('#startDate');
	                				 var endDate = form.down('#endDate');
	                				 startDate.setMaxValue(new Date());
	                				 startDate.setMinValue(false);
	                				 endDate.setMaxValue(new Date());
	                				 endDate.setMinValue(false);

	                				 var program = form.down('#programId');
	                				 var programStore = program.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 programStore.load();
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportfilter [itemId=incidentType]': {
	                			 beforerender : function(combo){
	                				 combo.store.proxy.extraParams = {
	                						 category: 'NEGATIVE'
	                				 };
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportgrid ': {
	                			 cellclick: function( cell, td, cellIndex) {
	                			       var studentDetailGrid = cell.up('grid');
	                			       var columnName = studentDetailGrid.columnManager.columns[cellIndex].dataIndex;
	                			       if(columnName == 'studentCode') {
	                			            var record = studentDetailGrid.getSelectionModel().getSelection()[0];
	                			            var userId = record.get('studentId');
	                			            var admissionId = record.get('admissionId');
	                			            var personId = record.get('personId');
	                			            var studentCode = record.get('studentCode');
	                			            var programBatchSeatTypeConfigId = record.get('programBatchSeatTypeConfigId');
	                			             if(!isNullOrEmpty(userId)) {
	                			                     var tabTitle = studentCode;
	                			                     var personId = personId;
	                			                     var admissionId=admissionId;	                			                     
	                			                     var programBatchSeatTypeConfigId = programBatchSeatTypeConfigId;
	                			                     Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
	                			                     var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
	                			                     var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
	                			                     personController.isProfilePicSaved = false;
	                			                     personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
	                			                     if(Ext.isDefined(studentDetailGrid.up('window'))){
	                			                            studentDetailGrid.up('window').close();
	                			                         }
	                			                 }
	                			        }
	                			},
	                			 render: function(grid){
	                				 if (portalId == 2) {
	                					 this.doAccessControlValidation(grid, this.getFP_NEGATIVE_INCIDENTS_REPORT_PERMISSIONS());
	                   				 }else{
	                   					this.doAccessControlValidation(grid, this.getNEGATIVE_INCIDENTS_REPORT_PERMISSIONS());
	                   					this.disableButtonPivilegesForNegativeIncident(grid, this.getNEGATIVE_INCIDENTS_REPORT_PERMISSIONS());
	                   				 }
	                			 },
	                			 afterrender:function(grid){
	               				  var me = this;
	               				  me.addDataGridConfigButton(grid,me.getNEGATIVE_INCIDENTS_REPORT_PERMISSIONS());
	   			    		},
	                	},
	                		  'studentincidentsreportfilter combo#programGroupCombo': {
	                			  select: function(obj, record){
	                				  this.incidentsReportProgGropSelect(obj, record)
	                			  },
	                			  render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationId: academyLocationId
		                				 };
		                				 store.load();
		                			 }
	                		  },
	                		  'studentnegativeincidentsreportfilter combo#programGroupCombo': {
	                			  select: function(obj, record){
	                				  this.incidentsNegativeReportProgGropSelect(obj, record)
	                			  },
	                			  render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationId: academyLocationId
		                				 };
		                				 store.load();
		                			 }
	                		  },
	                		  
	                		  'studentincidentsreporttabstructure':{
		               			   render:function(studentincidentsreporttabstructure){
		               				   this.enableTabforstudentincidentReportPanel(studentincidentsreporttabstructure);
		               			   },
		               		   afterrender:function(structure)
		               		   {
		               			   var grid=structure.down('studentincidentsreportgrid');
		               			   this.getGridHeaderFreeze(grid,structure,true);
		               		   }
	                		  },
	                		  'studentincidentsreportgrid button[itemId=exportReportsId]': {
	                			  click: function(obj) {
	                				  this.exportJRXMLPosotiveIncidentReport();
	                			  }
	                		  },
	                		  'studentnegativeincidentsreportgrid button[itemId=sendMessageIncidentReportBtn]': {
	                			  click: function(obj) {
	                				  this.openStudentSendMessage();
	                			  }
	                		  },
	                		  'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows] customcombobox[itemId=msgTempletId]':{
	                			  select : function(obj,rec){
	                				  this.selectMessageTemp(obj,rec);
	                			  }
	                		  },	
	                		  'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows]  filefield[itemId=staticUploadFileField]': {
	                			  change: function(fileField, value, eOpts){
	                				  var this$ = this;
	                				  //value = value.replace('C:\\fakepath\\', '');
	                				  var form=this$.getStudentsendmessages();
	                				  var subject = form.down('#subject').getValue();
	                				  if(isNullOrEmpty(subject)){
	                					  form.down('#subject').setValue(' ');
	                				  }
	                				  this$.uploadStudentStaticDocumentFileMessage(fileField, value, eOpts);
	                			  }
	                		  },
	                		  'studentstaticdocumentattachmentgrid[itemId=negativeIncidentReportStaticDocumentAttachmentGridMessage] actioncolumn': {
	                			  click : function(view, rowIndex, colIndex, item, e, record, row){
	                				  this.deleteStudentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
	                			  }
	                		  },
	                		  'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows]': {
	                			  render: function(grid){
	                				  var this$ = this;
	                				  var docGrid = grid.down('#negativeIncidentReportStaticDocumentAttachmentGridMessage');
	                				  docGrid.getStore().removeAll();
	                				  docGrid.getStore().sync();
	                			  },
	                			  afterrender: function(form) {
	                				  //this.getStudentIdsForMessaging();
	                				  var generateEmailBtn = form.down('#generateEmailBtn');
	                				  generateEmailBtn.hide();
	                				  var permissionMap = this.getSTUDENT_LIST_PERMISSIONS();
	                				  var associatedAcadLocationIds = new Array();
	                				  associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	                				  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
	                				  if(permissionList.indexOf("GENERATE_EMAIL") != -1) {
	                					  generateEmailBtn.show();
	                				  }
	                			  }
	                		  }, 
	                		  'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows] button[itemId=generateEmailBtn]': {
	                			  click: this.generateAIEmail
	                		  },
	                		  'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows] textfield[itemId=subject]': {
	                			  change: this.validateSubject
	                		  },
	                		  'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows] radiogroup#sendingPriority': {
	                			  change: function( radio, newValue, oldValue, eOpts) {
	                				  this.loadStudentScheduleField(radio, newValue, oldValue);
	                			  }
	                		  },
	                		  'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows] textarea[itemId=smsDiscription]':{
	                  			change : function(val,nV,oV){
	                				var studentsendmessage = this.getStudentsendmessages();
	                				var smsTextField = studentsendmessage.down('#smsDiscription');
	                				var smsTextFieldDiscription = studentsendmessage.down('#smsDiscriptionNotice');
	                				var maxLength = localStorage.getItem('maxLength');
	                				var newValue = maxLength - smsTextField.getValue().length;
	                				smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
	                			}
	                		}, 
	                		'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows] textarea[itemId=pushNotificationDiscription]':{
	                			  change : function(val,nV,oV){
	                				  var studentSendMessages = this.getStudentsendmessages();
	                				  var pushTextField = studentSendMessages.down('#pushNotificationDiscription');
	                				  var pushTextFieldDiscription = studentSendMessages.down('#pushNotificationDiscriptionNotice');
	                				  var maxLength = 1000;
	                				  var newValue = maxLength - pushTextField.getValue().length;
	                				  pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
	                			  }
	                		  },'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows] radiogroup[itemId=messageType]':{
	                			  change : function(val,nV,oV){
	                				  this.selectSectionMessageType(val,nV,oV);
	                			  }
	                		  },
	                		  'studentsendmessages[itemId=negativeIncidentReportSendMessageWindows] button[itemId=adhocMsgSubmitBtn]':{
	                			  click: function(obj) {
	                				  var isForAll = false;
	                				  var me=this;
	                				  //	var SearchForm = this.getStudentQuickSearchForm();
	                				  var jsonFormatFormData = '';
	                				  var grid = this.getStudentnegativeincidentsreportgrid();
	                				  var studentsendmessage = this.getStudentsendmessages();
	                				  //studentsendmessage.down('#adhocMsgSubmitBtn').setDisabled(true);

	                				  var sendMessageLable = studentsendmessage.down("#sendMsgCountItemId");
	                				  if (sendMessageLable.isVisible()) {
	                					  isForAll = true;
	                				  }
	                				  var formPnl = obj.up('form');
	                				  var isMySelfChecked = false;
	                				  var fldValues = formPnl.getForm().getFieldValues();
	                				  isMySelfChecked = fldValues.recieverType;
	                				  if(fldValues.recieverType[0] == false && fldValues.recieverType[1]==false && fldValues.recieverType[2]==false ){
	                					  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
	                					  return;
	                				  }
	                				  var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
	                				  var wsMsgEventRecipientConfigsUpdated = [];
	                				  /*var wsMsgEventRecipientConfigsUpdated = [{ 
	      										                           	 	msgRecipientTypeId: 500,
	      										                           	 	msgTemplateConfigId: 0,	//formData.id, 
	      										                           	 	selectiveRecipientIds: [] 
	      										                            },{ 
	      										                           	 	msgRecipientTypeId: 600,
	      										                           	 	msgTemplateConfigId: 0,	//formData.id, 
	      										                           	 	selectiveRecipientIds: [] 
	      										                            }];*/

	                				  var formData = obj.up('form').getValues();

	                				  var sendMessageToOptions = formData.recieverType;
	                				  var isStudentChecked = false;
	                				  var isParentChecked = false;
	                				  var isFeePayerChecked = false;

	                				  if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
	                					  if(sendMessageToOptions.constructor === Array){
	                						  if(sendMessageToOptions.length > 0){
	                							  sendMessageToOptions.forEach(function(current_value, index, initial_array) {
	                								  if(current_value == 1 || current_value == '1'){
	                									  isStudentChecked = true;
	                								  }
	                								  if(current_value == 2 || current_value == '2'){
	                									  isParentChecked = true;
	                								  }
	                								  if(current_value == 3 || current_value == '3'){
	                									  isFeePayerChecked = true;
	                								  }
	                							  });
	                						  }
	                					  }else{
	                						  if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
	                							  isStudentChecked = true;
	                						  }
	                						  if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
	                							  isParentChecked = true;
	                						  }
	                						  if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
	                							  isFeePayerChecked = true;
	                						  }
	                					  }
	                				  }

	                				  //var abc = xyz.c;

	                				  if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
	                					  //wsMsgEventRecipientConfigsUpdated = [];
	                					  me.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll, jsonFormatFormData);
	                				  }else{
	                					  var recipientIds;
	                					  if(grid.itemId == 'studentnegativeincidentsreportgrid'){
	                						  recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
	                						  recipientIds = Ext.encode(recipientIds);
	                						  //typeId = 2;
	                						  //recipientId = 2;
	                					  }

	                					  var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];

	                					  if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
	                						  // Ajax Call to get Parent Ids by Admission Ids

	                						  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	                						  Ext.Ajax.request({
	                							  type: 'rest',
	                							  url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
	                							  jsonData: RecipientTypeCodes,
	                							  method: 'POST',
	                							  success: function(response) {
	                								  var RecipientTypeCodesData = Ext.decode(response.responseText);

	                								  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	                								  Ext.Ajax.request({
	                									  type: 'rest',
	                									  url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
	                									  jsonData: recipientIds,
	                									  method: 'POST',
	                									  success: function(response) {
	                										  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	                										  // update wsMsgEventRecipientConfigsUpdated with parent ids
	                										  var wsMsgEventRecipientConfigsParents = {
	                												  msgRecipientTypeId: 66,
	                												  msgTemplateConfigId: 0,	//formData.id, 
	                												  selectiveRecipientIds: []
	                										  };
	                										  if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
	                											  wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
	                										  }
	                										  wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
	                										  wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);

	                										  // Ajax Call to get Fee Payer Ids by Admission Ids
	                										  Ext.Ajax.request({
	                											  type: 'rest',
	                											  url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
	                											  jsonData: recipientIds,
	                											  method: 'POST',
	                											  success: function(response) {
	                												  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	                												  // update wsMsgEventRecipientConfigsUpdated with fee payer ids
	                												  var wsMsgEventRecipientConfigsFeePayer = {
	                														  msgRecipientTypeId: 67,
	                														  msgTemplateConfigId: 0,	//formData.id, 
	                														  selectiveRecipientIds: []
	                												  };

	                												  if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
	                													  wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
	                												  }

	                												  wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
	                												  wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
	                												  me.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll, jsonFormatFormData);
	                											  }
	                										  });
	                									  }
	                								  });
	                							  }
	                						  });
	                					  }else{ // Only one checkbox is selected
	                						  var urlNew = '';
	                						  if(isParentChecked) { // If Parent checkbox is selected
	                							  // url for getting parent ids
	                							  urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
	                						  }
	                						  if(isFeePayerChecked) { // If Fee Payer checkbox is selected
	                							  // url for getting fee payer ids
	                							  urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
	                						  }

	                						  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	                						  Ext.Ajax.request({
	                							  type: 'rest',
	                							  url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
	                							  jsonData: RecipientTypeCodes,
	                							  method: 'POST',
	                							  success: function(response) {
	                								  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	                								  var RecipientTypeCodesData = Ext.decode(response.responseText);

	                								  Ext.Ajax.request({
	                									  type: 'rest',
	                									  url: urlNew,
	                									  jsonData: recipientIds,
	                									  method: 'POST',
	                									  success: function(response) {
	                										  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	                										  if(isParentChecked) { // If Parent checkbox is selected
	                											  // update wsMsgEventRecipientConfigsUpdated with parent ids
	                											  var wsMsgEventRecipientConfigsParents = {
	                													  msgRecipientTypeId: 66,
	                													  msgTemplateConfigId: 0,	//formData.id, 
	                													  selectiveRecipientIds: []
	                											  };
	                											  if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
	                												  wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
	                											  }
	                											  wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
	                											  wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
	                										  }
	                										  if(isFeePayerChecked) { // If Fee Payer checkbox is selected
	                											  // update wsMsgEventRecipientConfigsUpdated with fee payer ids
	                											  var wsMsgEventRecipientConfigsFeePayer = {
	                													  msgRecipientTypeId: 67,
	                													  msgTemplateConfigId: 0,	//formData.id, 
	                													  selectiveRecipientIds: []
	                											  };
	                											  if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
	                												  wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
	                											  }
	                											  wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
	                											  wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
	                										  }
	                										  me.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll, jsonFormatFormData);
	                									  }
	                								  });
	                							  }
	                						  });

	                					  }
	                				  }

	                			  }
	                		  }
	                	 });
	                 },
	                 
	                 
	                 enableTabforstudentincidentReportPanel:function(studentincidentsreporttabstructure)
	                 {
	                	 this.showTabforstudentincidentReportPanel(studentincidentsreporttabstructure);
	                 },
	                 
	                 showTabforstudentincidentReportPanel : function(studentincidentsreporttabstructure) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=studentincidentsreporttabstructure.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important',marginLeft:'0px !important'},
					  			   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  					xtype : 'studentincidentsreportstructure',
					  					itemId : 'studentincidentsreportstructure',
					  					title : getCommonTranslation('SEARCH'),
					  					tabCls : 'right-tab'
					  				}]
					  		   });

					  		 studentincidentsreporttabstructure.insert(insertPosition,panelItem);
					     },
	                 
	                 
	                 
	                 incidentsReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 incidentsReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 var batchId = record[0].get("id");
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
        				 var wheatherSchool = alinfomodel.get('wheatherSchool');
        				 
	                	 if(batchId > 0){	    	        					  
	                		 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: batchId
	                		 };
	                		 period.bindStore(store);
	                		 store.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length > 0){
										   if(wheatherSchool){
											   period.setValue(records[0].data.id);
											   var form = obj.up('form');
						                	   var section = form.down('#section');
						                	   section.reset();
						                	   section.setDisabled(false);
						                	   var periodId = records[0].data.id;
							                	 if(periodId > 0){	    	        					  
							                		 var store = section.getStore();
							                		 store.getProxy().extraParams = {
							                			 periodId: periodId
							                		 };
							                		 store.load();
							                	 }
										   }
									   }
								   }
							   }
						    });
	                		 
	                	 }
	                 },
	                 incidentsReportPeriodSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(false);
	                	 var periodId = record[0].get("id");
	                	 if(periodId > 0){	    	        					  
	                		 var store = section.getStore();
	                		 store.getProxy().extraParams = {
	                			 periodId: periodId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 negativeIncidentsReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(true);
	                	 
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(true);
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 negativeIncidentsReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(true);
	                	 
	                	 var batchId = record[0].get("id");
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');

	                	 if(batchId > 0){	    	        					  
	                		 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: batchId
	                		 };
	                		 period.bindStore(store);
	                		 store.load({
	                			 callback: function(records, operation, success) {
	                				 if (success) {
	                					 if(records.length > 0){
	                						 if(wheatherSchool){
	                							 period.setValue(records[0].data.id);
	                							 var form = obj.up('form');
	                							 var section = form.down('#section');
	                							 section.reset();
	                							 section.setDisabled(false);
	                							 var periodId = records[0].data.id;
	                							 if(periodId > 0){	    	        					  
	                								 var store = section.getStore();
	                								 store.getProxy().extraParams = {
	                									 periodId: periodId
	                								 };
	                								 store.load();
	                							 }
	                						 }
	                					 }
	                				 }
	                			 }
	                		 });

	                	 }
	                 },
	                 negativeIncidentsReportPeriodSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(false);
	                	 var periodId = record[0].get("id");
	                	 if(periodId > 0){	    	        					  
	                		 var store = section.getStore();
	                		 store.getProxy().extraParams = {
	                			 periodId: periodId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 incidentsReportProgGropSelect : function(obj, record) {
	                	 var programgroupId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var program = form.down('#programId');
	                	 var batch = form.down('#batchId');
	                	 var period = form.down('#periodId');
	                	 var section = form.down('#section');
	                	 program.reset();
	                	 batch.reset();
	                	 period.reset();
	                	 section.reset();
	                	 batch.setDisabled(true);
	                	 period.setDisabled(true);
	                	 section.setDisabled(true);
	                	 if(programgroupId > 0){
	                		 var store = program.getStore();
	                		 store.getProxy().extraParams = {
	                			 programGroupId: programgroupId,
	                			 academyLocationIds: academyLocationId,
	                			 isAllProgram:true
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 incidentsNegativeReportProgGropSelect : function(obj, record) {
	                	 var programgroupId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var program = form.down('#programId');
	                	 var batch = form.down('#batchId');
	                	 var period = form.down('#periodId');
	                	 var section = form.down('#section');
	                	 program.reset();
	                	 batch.reset();
	                	 period.reset();
	                	 section.reset();
	                	 batch.setDisabled(true);
	                	 period.setDisabled(true);
	                	 section.setDisabled(true);
	                	 if(programgroupId > 0){
	                		 var store = program.getStore();
	                		 store.getProxy().extraParams = {
	                			 programGroupId: programgroupId,
	                			 academyLocationIds: academyLocationId,
	                			 isAllProgram:true
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 //V2D-54139: Export Report Button Permission
		              disableStdPositiveReportExportPivileges : function(gridReference, permissionsMap) {
		            		var associatedAcadLocationIds = new Array();
		            		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		            		var permissionList = Academia.utilities.accessControl.AccessControlManager
		            		.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		            		buttonsToolBar = gridReference.query('toolbar')[0];
		            		var exportReport = buttonsToolBar.query('#exportReportsId')[0];
		            		Ext.each(permissionList, function(privilege) {
		            			if (privilege === 'EXPORTREPORTS') {
		            				if(!isNullOrEmpty(exportReport)){
		            					exportReport.setVisible(true);
		            				}        		
		            			}
		            		});
		            	},
                       	disableGridExportButton:function(column,selected,grid) {
                        	var exportButtonItemId = grid.down('#exportReportsId');
                        	var counter = 0;
                        	var count=selected.length;
                        	if(count>= 1){ // enable
                        		exportButtonItemId.setDisabled(false);
                        	}else{
                        		exportButtonItemId.setDisabled(true);
                        	}
                        },
                        exportJRXMLPosotiveIncidentReport: function() {
                        	var selectedId = 0;
                        	grid = this.getStudentincidentsreportgrid();
                        	if (grid.getSelectionModel().getCount() > 0) {
                        		var record = grid.getSelectionModel().getSelection();
                        		var studenttemp=[];
                        		for(var i in record){
                        			studenttemp.push(record[i].get("incidentId"));
                        		}
                        		selectedId=studenttemp.join();
                        		user=this.getCurrentlyLoggedInUser();
                        		// code to identify jasper
                        		var code ="POSITIVE_INCIDENT_PRINT_REPORT";
                        		var reportParams =new Object();
                        		reportParams.userId=user.code;
                        		reportParams.incidentIdsCommaSeperated = String(selectedId); // convert int into string
                        		var reportTitle=getCommonTranslation('STUDENT_POSITIVE_INCIDENT_REPORT_TITLE');
                        		var exportUrl = SERVERURL.POSITIVE_INCIDENT_PRINT;
                        		this.exportJRXMLReport(code,reportParams,reportTitle,'.zip',exportUrl);
                        		//$this.exportJRXMLReport(code,reportParams,title,'.pdf',exportUrl);
                        	}else{
                        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
                        	}
                        },
                        disableButtonPivilegesForNegativeIncident : function(gridReference, permissionsMap) {
                        	var associatedAcadLocationIds = new Array();
                        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
                        	var permissionList = Academia.utilities.accessControl.AccessControlManager
                        	.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                        	buttonsToolBar = gridReference.query('toolbar')[0];
                        	var sendMessageIncidentReportBtn = buttonsToolBar.query('#sendMessageIncidentReportBtn')[0];
                        	sendMessageIncidentReportBtn.setVisible(false);
                        	Ext.each(permissionList, function(privilege) {
                        		if (privilege === 'SENDMESSAGE') {
                        			if(!isNullOrEmpty(sendMessageIncidentReportBtn)){
                        				sendMessageIncidentReportBtn.setVisible(true);
                        			}        		
                        		}
                        	});
                        },
                        openStudentSendMessage:function(obj){
                        	var grid = this.getStudentnegativeincidentsreportgrid();
                        	//var gridMSG = this.getStaticDocumentAttachmentGrid();
                        	if(grid.getSelectionModel().getCount()>0) {

                        		var $this=this;
                        		var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
                        		var structure = Ext.widget('studentsendmessages',{
                        			itemId:'negativeIncidentReportSendMessageWindows'
                        		});
                        		var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
                        		/**
                        		 * This is to remove tab from content panel and open same tab again
                        		 */
                        		var getcontroller=this.getController('menu.CoreERPNavigationController');
                        		var getTab=getcontroller.getTab(tabName);
                        		if(getTab!=null){
                        			contentPanel.remove(getTab, true);
                        		}
                        		var formWindowTab = $this.getStudentsendmessages();
                        		formWindowTab.down("#selectTemplate").allowBlank=true;
                        		formWindowTab.down("#selectTemplate").setVisible(false);
                        		formWindowTab.down("#messageName").allowBlank=true;   
                        		formWindowTab.down("#messageName").setVisible(false);
                        		var templateStore = formWindowTab.down('#selectTemplate').getStore();
                        		templateStore.getProxy().extraParams={
                        			msgRecipientTypeId:2
                        		};
                        		templateStore.load();
                        		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                        		Ext.Ajax.request({
                        			method : "GET",
                        			type : 'rest',
                        			url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=StudentTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
                        			headers : {
                        				'Content-Type' : 'application/json'
                        			},
                        			success : function(form,action) {
                        				var data = Ext.JSON.decode(form.responseText);
                        				formWindowTab.down("#id").setValue(data.id);
                        				formWindowTab.down("#code").setValue(data.code);
                        				formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
                        				formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
                        				formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
                        				Ext.getBody().unmask();

                        				//grid.getStore().reload();
                        				//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
                        			}

                        		});
                        		openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_TWO);
                        		setTimeout(function(){
                        			formWindowTab.down("#templateId").setVisible(false);
                        		},100);
                        		/*if (!formWindow) {
            	    				Ext.widget('studentsendmessages');
            	    				formWindow = $this.getstudentsendmessages();
            	    			}
            	    			formWindow.show(;*/

                        	} else {
                        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                        	}
                        } , 
                        createJsonFormat: function(searchForm) {
                        	var this$=this;
                        	var formValues = new Array();
                        	var values = new Object();
                        	var searchcriteria = new Array();

                        	values.configCode = CONSTANTS.CB.STUDENT_LIST_BASIC_CONFIGCODE;

                        	formValues = searchForm.getValues();        
                        	var studentField = searchForm.getForm().findField('STUDENT_ID');
                        	var admissionField = searchForm.getForm().findField('ADMISSION_NUMBER');      
                        	var applicationFiled = searchForm.getForm().findField('APPICANT_PRINT_NAME');
                        	if(!isNullOrEmpty(formValues.ADMISSION_TO_DATE)){formValues.ADMISSION_TO_DATE = formValues.ADMISSION_TO_DATE+' 23:59:59';}

                        	for (var key in formValues) {
                        		var value = formValues[key];            
                        		if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField' && 
                        				key !== 'STUDENT_ID' && key !== 'ADMISSION_NUMBER' && key !== 'STUDENT_STATUS_CSM' ){
                        			var keyValueJsonObject = this$.getJsonObject( key , value);
                        			this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
                        		}
                        	}
                        	if(formValues["ADMISSION_STATUS"]){
                        		var academyLocationIds =this$.getUserAccessibleAL();
                        		var ACCESSIBLE_AL_ID = this$.getJsonObject( 'ACCESSIBLE_AL_ID' , academyLocationIds);
                        		this$.pushJsonObjectInArray(ACCESSIBLE_AL_ID,searchcriteria);
                        	}
                        	var academyLocationId = this.getCurrentAcademyLocation();

                        	/**this condition code added for application id filter only when selected**/
                        	if(!isNullOrEmpty(formValues.APPICANT_PRINT_NAME)){
                        		formValues.STATUS=true;
                        		formValues.ADMISSION_STATUS=true;
                        	}

                        	if(!isNullOrEmpty(formValues.STUDENT_ID)){
                        		var studentRec = studentField.getStore().getById(formValues.STUDENT_ID);
                        		if(!isNullOrEmpty(studentRec)){
                        			var studetnRecObj = this$.getJsonObject( 'STUDENT_ID' , studentRec.data.studentCode);
                        			this$.pushJsonObjectInArray(studetnRecObj,searchcriteria);
                        		}
                        	}
                        	if(!isNullOrEmpty(formValues.ADMISSION_NUMBER)){
                        		var admissionRec = admissionField.getStore().findRecord('id',formValues.ADMISSION_NUMBER);
                        		if(!isNullOrEmpty(admissionRec)){
                        			var admissionRecObj = this$.getJsonObject( 'ADMISSION_NUMBER' , admissionRec.data.code);
                        			this$.pushJsonObjectInArray(admissionRecObj,searchcriteria);
                        		}
                        	}
                        	var academyLocationObj = this$.getJsonObject( 'ACADEMY_LOCATION_ID' , academyLocationId);
                        	this$.pushJsonObjectInArray(academyLocationObj,searchcriteria);

                        	if(!isNullOrEmpty(formValues.religion)){
                        		var religionId = this$.getJsonObject( 'RELIGION_ID' , formValues.religion.id);
                        		this$.pushJsonObjectInArray(religionId,searchcriteria);
                        	}

                        	if(!isNullOrEmpty(formValues.castCategory)){
                        		var casteCatergoryId = this$.getJsonObject( 'CASTE_CATERGORY_ID' , formValues.castCategory.id);
                        		this$.pushJsonObjectInArray(casteCatergoryId,searchcriteria);
                        	}

                        	var debaredStudentsCheckBoxChecked = false;

                        	if( !isNullOrEmpty(formValues.debaredStudents) && formValues.debaredStudents ){
                        		debaredStudentsCheckBoxChecked = true;
                        	}

                        	if(formValues.STATUS  && formValues.ADMISSION_STATUS){
                        		var exitDate = this$.getJsonObject( 'EXIT_DATE_NULL' , true);
                        		this$.pushJsonObjectInArray(exitDate,searchcriteria);
                        	}else{
                        		if(!formValues.STATUS  && !formValues.ADMISSION_STATUS){
                        			var exitDate = this$.getJsonObject( 'EXIT_DATE_NOT_NULL' , true);
                        			if( debaredStudentsCheckBoxChecked ){
                        				exitDate = this$.getJsonObject( 'EXIT_DATE_NULL' , true);
                        			}
                        			if( formValues.APPICANT_PRINT_NAME ){
                        				exitDate = this$.getJsonObject( 'EXIT_DATE_NULL' , true);
                        			}              
                        			this$.pushJsonObjectInArray(exitDate,searchcriteria);
                        		}
                        	}
                        	if((!isNullOrEmpty(formValues.COURSE_NAME) || !isNullOrEmpty(formValues.COURSE_VARIENT_ID)) && formValues.STATUS  && formValues.ADMISSION_STATUS){
                        		var enrollementExitDate = this$.getJsonObject('ENROLLMENT_EXIT_DATE_NULL' , true);
                        		this$.pushJsonObjectInArray(enrollementExitDate,searchcriteria);
                        	}

                        	if (formValues.STATUS && !formValues.ADMISSION_STATUS) {
                        		var isPeriodCompleted = this$.getJsonObject('IS_PERIOD_COMPLETED', true);
                        		this$.pushJsonObjectInArray(isPeriodCompleted, searchcriteria);
                        		var pbsInactiveStdMaxSql ='(SELECT max(id) from program_batch_students where admissionId=T3.id group by admissionId)';
                        		var pbsStdMaxId = this$.getJsonObject('PBS_MAX_ID', pbsInactiveStdMaxSql);
                        		this$.pushJsonObjectInArray(pbsStdMaxId, searchcriteria);
                        	} else if (!formValues.STATUS && formValues.ADMISSION_STATUS) {
                        		var isPeriodCompleted = this$.getJsonObject('IS_PERIOD_COMPLETED', false);
                        		this$.pushJsonObjectInArray(isPeriodCompleted, searchcriteria);
                        	} else if (formValues.STATUS && formValues.ADMISSION_STATUS) {
                        		var isPeriodCompleted = this$.getJsonObject('IS_PERIOD_COMPLETED', false);
                        		this$.pushJsonObjectInArray(isPeriodCompleted, searchcriteria);
                        	} else if (!formValues.STATUS && !formValues.ADMISSION_STATUS) {
                        		var isPeriodCompleted = this$.getJsonObject('IS_PERIOD_COMPLETED', true);
                        		this$.pushJsonObjectInArray(isPeriodCompleted, searchcriteria);
                        		var pbsInactiveStdMaxSql ='(SELECT max(id) from program_batch_students where admissionId=T3.id group by admissionId)';
                        		var pbsStdMaxId = this$.getJsonObject('PBS_MAX_ID', pbsInactiveStdMaxSql);
                        		this$.pushJsonObjectInArray(pbsStdMaxId, searchcriteria);
                        	}

                        	if(!isNullOrEmpty(formValues.STUDENT_STATUS_CSM)){
                        		var studentStatusCSMComboArr = formValues.STUDENT_STATUS_CSM;
                        		var studentStatusCSMArr = [];
                        		for(i in studentStatusCSMComboArr){
                        			if( !isNullOrEmpty(studentStatusCSMComboArr[i].data) ){
                        				var studentStatusCSMId = studentStatusCSMComboArr[i].data.id;
                        				studentStatusCSMArr.push(studentStatusCSMId);
                        			}
                        		}
                        		if( studentStatusCSMArr.length != 0 ){
                        			var studentStatusCSMObj = {
                        					"paramCode": 'STUDENT_STATUS_CSM_ID_LIST',
                        					"paramValues": studentStatusCSMArr
                        			};
                        			this$.pushJsonObjectInArray(studentStatusCSMObj,searchcriteria);
                        		}
                        	}

                        	values.searchCriterias = searchcriteria;
                        	return values;
                        },
                        getStudentReceipientIdsForSendingMessages : function(grid){

                        	if (grid.getSelectionModel().getCount() > 0) {
                        		var records = grid.getSelectionModel().getSelection();
                        		var ids=[];
                        		if(grid.itemId == 'studentnegativeincidentsreportgrid'){
                        			for(var i in records) {
                        				ids.push(records[i].data.admissionId);
                        			}
                        		}			
                        	}
                        	return ids;
                        },/**
                         * This method is used to send message
                         */
                        sendMessage : function(button,grid,wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll,
                        		jsonFormatFormData){
                        	baseController = Academia.app.getController('Academia.controller.base.BaseController');
                        	var formData = button.up('form').getValues();
                        	var searchCriterias = null;
                        	var submitUrl = SERVERURL.ADOC_MESSAGEING_CREATE

                        	var isSendMsgToAll = false;
                        	var recipientIds = null;
                        	var typeId = null;
                        	var recipientId = null; 
                        	if(grid.itemId == 'studentnegativeincidentsreportgrid'){
                        		recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
                        		typeId = 2;
                        		recipientId = 2;
                        	}

                        	var basicSetUpForm=button.up('form');

                        	var staticDocumentGrid = basicSetUpForm.down('#negativeIncidentReportStaticDocumentAttachmentGridMessage');//this.getStaticDocumentAttachmentGrid();
                        	var staticDocumentStore = staticDocumentGrid.getStore();
                        	var staticDocuments = new Array();
                        	staticDocumentStore.each(function(values){

                        		var staticDocumentObject = new Object();

                        		staticDocumentObject.id = values.get('id');
                        		staticDocumentObject.templateConfigDocId = values.get('templateConfigDocId');
                        		staticDocumentObject.name = values.get('name');
                        		var date = values.get('submissionDate');
                        		if(isNullOrEmpty(date)){
                        			date = Ext.Date.format(new Date(), 'd-m-Y');
                        		}

                        		staticDocumentObject.submissionDate = date;
                        		staticDocumentObject.path = values.get('path');
                        		staticDocumentObject.createdBy = {
                        				id : values.get('createdBy').id,
                        				value : values.get('createdBy').value,
                        				code : values.get('createdBy').code
                        		},
                        		staticDocumentObject.status = values.get('status');
                        		staticDocumentObject.documentType = values.get('documentType');
                        		staticDocuments.push(staticDocumentObject);
                        	});


                        	if(formData.messageType=="2")
                        	{

                        		var json = new Object();
//                      		json.id = formData.id;
//                      		json.code = formData.code;
//                      		json.templateConfigName = formData.templateConfigName;
                        		json.msgSubCategoryId = formData.msgSubCategoryId;
                        		json.templateDataProviderId = null;
                        		json.whetherStaticMsg = false;
                        		//json.recipientTypeId = 43;
                        		json.recipientTypeId = typeId;
                        		json.msgMessageTypeId = 4;
                        		json.approvalRequired = false;
                        		json.approverId = null;
                        		json.academyLocationId = 3;
                        		json.authorId = 1;
                        		json.authorName = "System Admin System Admin";
                        		json.availableForAdhocMsg = true;
                        		json.status = "APPROVED";
                        		json.staticDocuments = staticDocuments;

                        		var jsonData=[];
                        		if(formData.msgTempletId =="EMAIL_SYSTEM_NOTIFICATION")
                        		{
                        			var obj1 = new Object();

                        			//var objArr = new Array();
                        			var arr1 = new Object();
                        			arr1.id = 1;
                        			arr1.code = 'Email';
                        			arr1.whetherMsgSubjAvail = true;
                        			arr1.whetherAttachmentSupported = true;

                        			//objArr.push(arr1);

                        			obj1.subjectLine = formData.subjectDisplayCode;
                        			obj1.msgContent = formData.discriptionId;
                        			obj1.msgDeliveryMode = arr1;

                        			var tempArr = new Array();
                        			var tempObj = new Object();

                        			tempArr.push(obj1);
                        			json.messageTemplates = tempArr
                        			//json.push(tempObj);
                        		}else if(formData.msgTempletId =="PUSH_NOTIFICATION")
                        		{
                        			var obj1 = new Object();

                        			//var objArr = new Array();
                        			var arr1 = new Object();
                        			arr1.id = 6;
                        			arr1.code = 'PUSH_NOTIFICATION';
                        			arr1.whetherMsgSubjAvail = true;
                        			arr1.whetherAttachmentSupported = false;

                        			//objArr.push(arr1);

                        			obj1.subjectLine = formData.subjectDisplayCode;
                        			obj1.msgContent = formData.discriptionId;
                        			obj1.msgDeliveryMode = arr1;

                        			var tempArr = new Array();
                        			var tempObj = new Object();

                        			tempArr.push(obj1);
                        			json.messageTemplates = tempArr
                        			//json.push(tempObj);
                        		}
                        		else if(formData.msgTempletId =="EMAIL_ONLY")
                        		{
                        			var obj1 = new Object();

                        			var arr1 = new Object();
                        			arr1.id = 1;
                        			arr1.code = 'EMAIL_ONLY';
                        			arr1.whetherMsgSubjAvail = true;
                        			arr1.whetherAttachmentSupported = true;


                        			obj1.subjectLine = formData.subjectDisplayCode;
                        			obj1.msgContent = formData.discriptionId;
                        			obj1.msgDeliveryMode = arr1;

                        			var tempArr = new Array();
                        			var tempObj = new Object();

                        			tempArr.push(obj1);
                        			json.messageTemplates = tempArr
                        		}else if(formData.msgTempletId =="SYSTEM_NOTIFICATION")
                        		{
                        			var obj1 = new Object();

                        			var arr1 = new Object();
                        			arr1.id = 4;
                        			arr1.code = 'SYSTEM_NOTIFICATION';
                        			arr1.whetherMsgSubjAvail = true;
                        			arr1.whetherAttachmentSupported = true;


                        			obj1.subjectLine = formData.subjectDisplayCode;
                        			obj1.msgContent = formData.discriptionId;
                        			obj1.msgDeliveryMode = arr1;

                        			var tempArr = new Array();
                        			var tempObj = new Object();

                        			tempArr.push(obj1);
                        			json.messageTemplates = tempArr
                        		}else if(formData.msgTempletId =="PUSH_NOTIFICATION_ONLY")
                        		{
                        			var obj1 = new Object();
                        			var arr1 = new Object();
                        			arr1.id = 6;
                        			arr1.code = 'PUSH_NOTIFICATION_ONLY';
                        			arr1.whetherMsgSubjAvail = true;
                        			arr1.whetherAttachmentSupported = false;


                        			obj1.subjectLine = formData.subjectDisplayCode;
                        			obj1.msgContent = formData.discriptionId;
                        			obj1.msgDeliveryMode = arr1;

                        			var tempArr = new Array();
                        			var tempObj = new Object();

                        			tempArr.push(obj1);
                        			json.messageTemplates = tempArr
                        		}else{
                        			var obj1 = new Object();

                        			var arr1 = new Object();
                        			arr1.id = 2;
                        			arr1.code = 'SMS';
                        			arr1.whetherMsgSubjAvail = false;
                        			arr1.whetherAttachmentSupported = false;

                        			//objArr.push(arr1);

                        			obj1.subjectLine = formData.subjectDisplayCode;
                        			obj1.msgContent = formData.smsDiscription;
                        			obj1.msgDeliveryMode = arr1;

                        			var tempArr = new Array();
                        			var tempObj = new Object();

                        			tempArr.push(obj1);
                        			json.messageTemplates = tempArr

                        			//json.push(jsonData);

                        		}
                        		if(!isNullOrEmpty(formData.templateId)){
                        			json.templateId = formData.templateId;
                        		}
                        		jsonDataEncode = Ext.encode(json);
                        		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                        		Ext.Ajax.request({
                        			type: 'rest',
                        			//url: SERVERURL.ADHOC_MESSAGE_UPDATE_COMMITTEE,
                        			url: SERVERURL.ADHOC_MESSAGE_UPDATE_TEMPLATE_CONFIG,
                        			jsonData: jsonDataEncode,
                        			method: 'POST',
                        			success: function(form, action) {
                        				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                        				var templateConfigId = Ext.decode(form.responseText);
                        				//submitUrl = SERVERURL.ADOC_MESSAGEING_CREATE; 
                        				//var submitUrl;
                        				/*var wsMsgEventRecipientConfigsUpdated = [{ 
            	    								                            	 msgRecipientTypeId: recipientId,
            	    								                            	 msgTemplateConfigId:templateConfigId,	//formData.id, 
            	    								                            	 selectiveRecipientIds:recipientIds 
            	    						                            }];*/

                        				var json = {
                        						id: null, 
                        						status: null, 
                        						//msgTemplateConfigId: formData.id, 
                        						sendingPriority: formData.sendingPriority, 
                        						msgCategoryId:formData.msgCategoryId, 
                        						msgSubCategoryId: formData.msgSubCategoryId, 
                        						messageId: formData.messageId, 
                        						displayCode: formData.subjectDisplayCode,
                        						isSendMsgToAll : isSendMsgToAll,
                        						searchCriterias : searchCriterias,
                        						wsMsgEventRecipientConfigs: [ 
                        							/*{ 
            	    							                            	 msgRecipientTypeId: recipientId,
            	    							                            	 msgTemplateConfigId:templateConfigId,	//formData.id, 
            	    							                            	 selectiveRecipientIds:recipientIds 
            	    							                             },
            	    							                             { 
            	    							                            	 msgRecipientTypeId: 42,
            	    							                            	 msgTemplateConfigId:templateConfigId, 
            	    							                            	 selectiveRecipientIds:[4,7] 
            	    							                             }*/
                        							], 
                        							wsAdhocRecipients: null, 
                        							approverId: null, 
                        							approvalRequired: false, 
                        							reviewStatusCode: "APPROVED"
                        							//recieverType: formData.recieverType
                        				};

                        				if(isStudentChecked){
                        					json.wsMsgEventRecipientConfigs.push({ 
                        						msgRecipientTypeId: recipientId,
                        						msgTemplateConfigId:templateConfigId,	//formData.id, 
                        						selectiveRecipientIds:recipientIds 
                        					});
                        				}
                        				if(isMySelfChecked[3]){
                        					json.wsMsgEventRecipientConfigs.push({ 
                        						msgRecipientTypeId: 166,
                        						msgTemplateConfigId:templateConfigId,	//formData.id, 
                        						selectiveRecipientIds:[currentlyLoggedInUserId]
                        					});
                        				}

                        				if(wsMsgEventRecipientConfigsUpdated.length > 0){
                        					wsMsgEventRecipientConfigsUpdated.forEach(function(current_value, index, initial_array) {
                        						//current_value.msgRecipientTypeId = recipientId;
                        						current_value.msgTemplateConfigId = templateConfigId;
                        						json.wsMsgEventRecipientConfigs.push(current_value);
                        					});
                        				}

                        				console.log(json.wsMsgEventRecipientConfigs);

                        				if(formData.sendingPriority==="SCHEDULE"){
                        					if(!isNullOrEmpty(formData.msgDueDate) && !isNullOrEmpty(formData.msgDueDateTime)){
                        						var dateString="";
                        						dateString=formData.msgDueDate+" "+formData.msgDueDateTime;
                        						json.msgDueDate=dateString;
                        					}else{
                        						json.msgDueDate= null;
                        					}
                        				}else if(formData.sendingPriority==="IMMEDIATE"){
                        					/*var now = new Date();
            	    						var dateString = Ext.Date.format(now,'Y-m-d h:i A');*/
                        					json.msgDueDate=null;
                        				}else{
                        					json.msgDueDate= null;
                        				}
                        				//var x = xyz.id;
                        				//delete myObj.test.key1;
                        				var academyLocation=baseController.getCurrentAcademyLocation();
                        				if(!isNullOrEmpty(academyLocation)){
                        					json.academyLocationId=academyLocation;
                        				}

                        				var currentlyLoggedInUser=baseController.getCurrentlyLoggedInUser();
                        				if(!isEmpty(currentlyLoggedInUser)){
                        					json.authorId=currentlyLoggedInUser.id;
                        					json.authorName=currentlyLoggedInUser.value;
                        				}
                        				jsonDataEncode = Ext.encode(json);
                        				var $this = this;
                        				Ext.Ajax.request({
                        					type : 'rest',
                        					url : submitUrl,
                        					jsonData : jsonDataEncode,
                        					method : 'POST',
                        					success : function(frm, action) {
                        						Ext.getBody().unmask();
                        						grid.getStore().reload();
                        						grid.getSelectionModel().deselectAll(true);
                        						var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
                        						var getcontroller=Academia.app.getController('menu.CoreERPNavigationController');
                        						var getTab=getcontroller.getTab(tabName);
                        						if(getTab!=null){
                        							contentPanel.remove(getTab, true);
                        						}
                        						showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('MESSAGE_SEND_MSG'));
                        					}
                        				});

                        			}

                        		});


                        	}else
                        	{	
                        		baseController = Academia.app.getController('Academia.controller.base.BaseController');
                        		var recipientIds = null;
                        		msgRecipientType = null;
                        		if(grid.itemId == 'studentnegativeincidentsreportgrid'){
                        			recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
                        			msgRecipientType = 2;
                        		}
                        		var json = {
                        				id: null, 
                        				status: null, 
                        				msgTemplateConfigId: null, 
                        				sendingPriority: formData.sendingPriority, 
                        				msgCategoryId:formData.msgCategoryId, 
                        				msgSubCategoryId: formData.msgSubCategoryId, 
                        				messageId: formData.messageId, 
                        				displayCode: formData.displayCode, 
                        				isSendMsgToAll : isSendMsgToAll,
                        				searchCriterias : searchCriterias,
                        				wsMsgEventRecipientConfigs: [], 
                        					wsAdhocRecipients: null, 
                        					approverId: null, 
                        					approvalRequired: false, 
                        					reviewStatusCode: "APPROVED",
                        		};

                        		if(isStudentChecked){ 
                        			json.wsMsgEventRecipientConfigs.push({ 
                        				msgRecipientTypeId: msgRecipientType,
                        				msgTemplateConfigId:formData.msgTemplateConfigId, 
                        				selectiveRecipientIds:recipientIds 
                        			});
                        		}
                        		if(isMySelfChecked[3]){
                        			json.wsMsgEventRecipientConfigs.push({ 
                        				msgRecipientTypeId: 166,
                        				msgTemplateConfigId:formData.msgTemplateConfigId,	//formData.id, 
                        				selectiveRecipientIds:[currentlyLoggedInUserId]
                        			});
                        		}

                        		if(wsMsgEventRecipientConfigsUpdated.length > 0){
                        			wsMsgEventRecipientConfigsUpdated.forEach(function(current_value, index, initial_array) {
                        				//current_value.msgRecipientTypeId = msgRecipientType;
                        				current_value.msgTemplateConfigId = formData.msgTemplateConfigId;
                        				json.wsMsgEventRecipientConfigs.push(current_value);
                        			});
                        		}

                        		if(formData.sendingPriority==="SCHEDULE"){
                        			if(!isNullOrEmpty(formData.msgDueDate) && !isNullOrEmpty(formData.msgDueDateTime)){
                        				var dateString="";
                        				dateString=formData.msgDueDate+" "+formData.msgDueDateTime;
                        				json.msgDueDate=dateString;
                        			}else{
                        				json.msgDueDate= null;
                        			}
                        		}else if(formData.sendingPriority==="IMMEDIATE"){
                        			//var now = new Date();
                        			//var dateString = Ext.Date.format(now,'Y-m-d h:i A');
                        			json.msgDueDate=null;
                        		}else{
                        			json.msgDueDate= null;
                        		}

                        		var academyLocation=baseController.getCurrentAcademyLocation();
                        		if(!isNullOrEmpty(academyLocation)){
                        			json.academyLocationId=academyLocation;
                        		}

                        		var currentlyLoggedInUser=baseController.getCurrentlyLoggedInUser();
                        		if(!isEmpty(currentlyLoggedInUser)){
                        			json.authorId=currentlyLoggedInUser.id;
                        			json.authorName=currentlyLoggedInUser.value;
                        		}
                        		jsonDataEncode = Ext.encode(json);

                        		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                        		Ext.Ajax.request({
                        			type: 'rest',
                        			url: submitUrl,
                        			jsonData: jsonDataEncode,
                        			method: 'POST',
                        			success: function(form, action) {
                        				Ext.getBody().unmask();
                        				showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('MESSAGE_SEND_MSG'));
                        				grid.getStore().reload();
                        				grid.getSelectionModel().deselectAll(true);
                        				var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
                        				var getcontroller=Academia.app.getController('menu.CoreERPNavigationController');
                        				var getTab=getcontroller.getTab(tabName);
                        				if(getTab!=null){
                        					contentPanel.remove(getTab, true);
                        				}
                        				//button.up('window').close();
                        			}

                        		});
                        	}	
                        }, 
                        selectMessageTemp: function(obj,rec){
                        	var $this =  this;
                        	var formWin = $this.getStudentsendmessages();
                        	var subject = formWin.down('#subject');
                        	var smsDiscription = formWin.down('#smsDiscription');
                        	var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
                        	var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
                        	var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
                        	if(rec[0].data.value == "SMS")
                        	{  formWin.down("#templateId").setVisible(false);
                        	formWin.down("#templateId").allowBlank=true;
                        	Ext.Ajax.request({
                        		type: 'rest',
                        		async: false,
                        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
                        		params: {
                        			screenName: 'studentsendmessages',
                        			academyLocationId: this.getCurrentAcademyLocation(),
                        			languageCode:'en'
                        		},
                        		method: 'GET',
                        		success: function(res, action) {
                        			var response = Ext.decode(res.responseText);
                        			if( Object.keys(response).length > 0 ){
                        				var records=response.studentsendmessages;
                        				for(i in records){
                        					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isVisible==true){
                        						formWin.down("#templateId").setVisible(true);
                        					}
                        					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isMandatory==true){
                        						formWin.down("#templateId").allowBlank=false;
                        					}
                        					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isMandatory==true && records[i].isVisible==false){
                        						formWin.down("#templateId").allowBlank=true;
                        					}

                        				}
                        			}else{
                        				formWin.down("#templateId").setVisible(false);
                        				formWin.down("#templateId").allowBlank=true;
                        			}
                        		}

                        	});
                        	this.setAllowBlank (formWin.down("#subject"),true);
                        	//formWin.down("#subject").allowBlank=true;
                        	formWin.down("#subject").hide();
                        	formWin.down("#staticUploadFileField").hide();
                        	formWin.down("#negativeIncidentReportStaticDocumentAttachmentGridMessageGrid").hide();
                        	formWin.down('#discriptionId').reset();
                        	formWin.down('#discriptionId').hide();	       		 
                        	formWin.down('#subject').reset();
                        	formWin.down('#smsDiscription').show();
                        	formWin.down('#smsDiscriptionNotice').show();
                        	pushNotificationDiscription.hide();
                        	pushNotificationDiscriptionNotice.hide();
                        	pushNotificationDiscription.reset();
                        	}/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
            		      		 subject.show();
            		      		 formWin.down("#staticUploadFileField").hide();
            		      		 this.setAllowBlank(subject,false);
            		      		 formWin.down("#studentDocumentMessageAttachmentGrid").hide();
            		      		 formWin.down('#discriptionId').reset();
            		      		 formWin.down('#discriptionId').hide();
            		      		 subject.reset();
            		      		 smsDiscription.reset();
            		      		 smsDiscription.hide();
            		      		 smsDiscriptionNotice.hide();
            		      		 pushNotificationDiscription.reset();
            		      		 pushNotificationDiscription.show();
            		      		 pushNotificationDiscriptionNotice.show();
            		      		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
            		      		 //formWin.down('#smsDiscription')
            		      	 }*/else{
            		      		 formWin.down("#templateId").hide();
            		      		 formWin.down("#templateId").allowBlank=true;
            		      		 formWin.down('#discriptionId').reset();
            		      		 formWin.down('#smsDiscription').reset();
            		      		 formWin.down('#smsDiscription').hide();
            		      		 formWin.down('#smsDiscriptionNotice').hide();
            		      		 formWin.down("#staticUploadFileField").show();
            		      		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
            		      		 formWin.down("#negativeIncidentReportStaticDocumentAttachmentGridMessageGrid").show();
            		      		 formWin.down("#subject").reset();
            		      		 formWin.down("#subject").show();
            		      		 this.setAllowBlank (formWin.down("#subject"),false);
            		      		 //formWin.down("#subject").allowBlank=false;
            		      		 formWin.down('#discriptionId').show();
            		      		 pushNotificationDiscription.hide();
            		      		 pushNotificationDiscriptionNotice.hide();
            		      		 pushNotificationDiscription.reset();
            		      	 }
                        }, /**
                         * upload static document file for Student
                         */
                        uploadStudentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
                        	var this$ = this;
                        	var setupForm = fileField.up('studentsendmessages');
                        	var grid = setupForm.down('#negativeIncidentReportStaticDocumentAttachmentGridMessage');
                        	fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
                        	fileField.setRawValue(fileUploadPath);
                        	var file = fileField.fileInputEl.dom.files[0];
                        	fileField.setRawValue(fileUploadPath);
                        	var fileSizeLimit = '5';
                        	var url = SERVERURL.FILE_PRIORITY;
                        	Ext.Ajax.request({
                        		type: 'rest',
                        		url: url+'?type=emailFileSize',
                        		method: 'GET',
                        		success : function(response, action){
                        			var responseData = Ext.JSON.decode(response.responseText);
                        			if(responseData.length>0 && responseData[0].value!=undefined && !isNullOrEmpty(responseData[0].value))
                        			{
                        				fileSizeLimit=responseData[0].value;
                        			}
                        			if((file.size / 1048576) <=  fileSizeLimit ){
                        				if(!isNullOrEmpty(fileUploadPath)){
                        					var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
                        					if (extension == "gif" || extension == "png" || extension == "bmp"
                        						|| extension == "jpeg" || extension == "jpg" || extension == "pdf" 
                        							|| extension == "doc" || extension == "docx" || extension == "txt"
                        								|| extension == "xls" || extension == "csv" || extension == "xml" 
                        									|| extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
                        						var entityId = 'student';
                        						var module = 'messaging';
                        						var entityType = 'template';
                        						var documentType = 'DOCUMENT';
                        						var isTransient = true;
                        						Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
                        						this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
                        							if(success){
                        								Ext.getBody().unmask();
                        								var path = Ext.JSON.decode(action.response.responseText).path;
                        								var user = this$.getCurrentlyLoggedInUser();
                        								var store = grid.getStore();
                        								var documentStatus = "SUBMITTED";
                        								var documentType = null;
                        								if(!isNullOrEmpty(path)){
                        									store.add({
                        										id: '',
                        										name: fileUploadPath,
                        										path: path ,
                        										createdBy : {
                        											id :user.id,
                        											value : user.value,
                        											code : user.code
                        										},
                        										status : documentStatus,
                        										documentType : documentType,
                        										templateConfigDocId: '',
                        										submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

                        									});
                        									this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
                        									showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
                        								}
                        								var form=this$.getStudentsendmessages();
                        								var subject = form.down('#subject').getValue();
                        								if(!isNullOrEmpty(subject)){
                        									if(subject == ' '){
                        										form.down('#subject').reset();
                        									}
                        								}
                        								fileField.reset();
                        							}

                        						}, isTransient);
                        					}else{
                        						fileField.reset();
                        						showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
                        					}
                        				}
                        			}else{
                        				fileField.reset();
                        				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ATTACHMENT_LIMIT_EXCEEDS')+' '+fileSizeLimit+' MB');
                        			}
                        		}
                        	});
                        }, 
                        saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
                        	var submitUrl = '';
                        	var templateTab = this.getContentPanel();
                        	var formWin =  this.getStudentsendmessages();
                        	var form = formWin.down('#msgDetailsForm');
                        	var id = form.down('#document_hidden_field');
                        	if (isNullOrEmpty(id.getSubmitValue())) {
                        		submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
                        	}
                        	var data = new Object();
                        	if(!isNullOrEmpty(entityId)){
                        		data.entityId = entityId;
                        	}else{
                        		data.entityId = null;
                        	}
                        	if(!isNullOrEmpty(module)){
                        		data.module = module;
                        	}else{
                        		data.module = null;
                        	}
                        	if(!isNullOrEmpty(entityType)){
                        		data.entityType = entityType;
                        	}else{
                        		data.entityType = null;
                        	}
                        	form.getForm().setValues(data);
                        	form.getForm().submit({
                        		method : 'POST',
                        		url : submitUrl,
                        		success : function(form, action){
                        			callBackFunction(true, action, isTransient);

                        		}
                        	});
                        },
                        loadGridWithFileNameMessage:function(grid,value,store){
                        	grid.bindStore(store);
                        },
                        deleteStudentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
                        	var grid = view.up('#negativeIncidentReportStaticDocumentAttachmentGridMessage');
                        	var panel = this.getContentPanel().getActiveTab();
                        	var tabTitle = panel.title;
                        	var store = grid.getStore();
                        	var templateConfigDocId = record.get('templateConfigDocId');
                        	var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
                        	if(!(tabTitle == viewTitle)){
                        		if(!isNullOrEmpty(templateConfigDocId)){
                        			showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                        				if (btn == 'yes') {
                        					Ext.Ajax.request({
                        						type: 'rest',
                        						url: SERVERURL.STATIC_DOC_DELETE,
                        						method: 'DELETE',
                        						params: {
                        							templateConfigDocId : templateConfigDocId
                        						},
                        						headers: {
                        							'Content-Type': 'application/json'
                        						},
                        						success: function(form, action) {
                        							store.remove(record);
                        							showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
                        						}
                        					});
                        				}
                        			});

                        		}else{
                        			store.remove(record);
                        			showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
                        		}
                        	}else{
                        		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
                        	}

                        }, 
                        validateSubject: function(cmp, nval) {
                        	var form = cmp.up('form');
                        	if(!isNullOrEmpty(nval) && form.down('#msgTempletId').getValue() == 'EMAIL_ONLY') {
                        		form.down('#generateEmailBtn').enable();
                        	}
                        	else {
                        		form.down('#generateEmailBtn').disable();
                        	}
                        },
                        generateAIEmail: function(btn) {
                        	if(!CONST.AI_ENABLED){
                        		showWarningMessage(getExaminationTranslation('REMARK'),
                        		"AI Feature Is Not Enabled. Please contact administrator.");
                        		return;
                        	}
                        	var me = this;
                        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                        	var vals = btn.up('form').getValues();
                        	Ext.Ajax.request({
                        		url: SERVERURL.PATH_GENRATE_EMAIL_AI,
                        		method: 'GET',
                        		params: {
                        			subject: vals.subjectDisplayCode
                        		},
                        		success: function(response) {
                        			Ext.getBody().unmask();
                        			if(response.responseText){
                        				me.getStudentsendmessages().down('[name=discriptionId]').setValue(response.responseText);
                        			}
                        		}
                        	});
                        }, /**
                         * This method is to enable schedule field
                         */
                        loadStudentScheduleField : function(radio,newValue, oldValue){
                        	var adhocMessageForm = radio.up('form');
                        	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
                        	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
                        	var radioValue = radio.getValue().sendingPriority;

                        	if(radioValue=='IMMEDIATE'){
                        		scheduleDateField.setVisible(false);
                        		scheduleDateField.setDisabled(true);
                        		scheduleTimeField.setVisible(false);
                        		scheduleTimeField.setDisabled(true);    		
                        	}
                        	else if(radioValue=='SCHEDULE'){
                        		scheduleDateField.setVisible(true);
                        		scheduleDateField.setDisabled(false);
                        		scheduleTimeField.setVisible(true);
                        		scheduleTimeField.setDisabled(false);
                        	}
                        },
                        selectSectionMessageType : function(val,nV,oV){

               	      	 var $this =  this;
               	      	 var formWin = $this.getStudentsendmessages();

               	      	 //var value = nV.1;
               	      	formWin.down('#recieverTypeIncludeMySelf').setValue(false);
               	      	 if(nV.messageType==2){
               	      		 formWin.down("#messageId").hide();
               	      		 formWin.down("#selectTemplate").allowBlank=true;
               	      		 formWin.down("#selectTemplate").setVisible(false);     		 
               	      		 formWin.down("#messageName").allowBlank=true;   
               	      		 formWin.down("#messageName").setVisible(false);
               	      		 formWin.down("#msgTempletId").setVisible(true);
               	      		 formWin.down("#msgTempletId").allowBlank=false;
               	      		 formWin.down("#msgTempletId").reset();
               	      		 formWin.down("#subject").setVisible(true);
               	      		 //formWin.down("#subject").allowBlank=false;
               	      		 formWin.down("#subject").reset();
               	      		 formWin.down("#discriptionId").setVisible(true);
               	      		 formWin.down("#discriptionId").reset();
               	      		 formWin.down('#smsDiscription').reset();
               	      		 formWin.down('#smsDiscription').hide();
               	      		 formWin.down('#smsDiscriptionNotice').hide();
               	     		 formWin.down('#pushNotificationDiscription').hide();
               	     		 formWin.down('#pushNotificationDiscriptionNotice').hide();
               	     		 formWin.down('#recieverTypeIncludeMySelf').setVisible(true);
               	      		 this.setAllowBlank (formWin.down("#subject"),false);
               	      	 }else{
               	      		 formWin.down("#msgTempletId").allowBlank=true;
               	      		 formWin.down("#msgTempletId").setVisible(false);     		
               	      		 formWin.down("#messageId").setVisible(true);
               	      		 formWin.down("#selectTemplate").setVisible(true);     		
               	      		 formWin.down("#messageName").setVisible(true);
               	      		 formWin.down("#messageName").reset();
               	      		 //formWin.down("#subject").allowBlank=true;
               	      		 this.setAllowBlank (formWin.down("#subject"),true);
               	      		 formWin.down("#subject").setVisible(false);
               	      		 formWin.down("#discriptionId").setVisible(false);
               	      		 formWin.down("#messageName").allowBlank=false;  
               	      		 formWin.down("#selectTemplate").allowBlank=false;
               	      		 formWin.down("#selectTemplate").reset();
               	      		 formWin.down("#negativeIncidentReportStaticDocumentAttachmentGridMessageGrid").setVisible(false);
               	      		 formWin.down("#staticUploadFileField").setVisible(false);
               	      		 formWin.down('#smsDiscription').reset();
               	      		 formWin.down('#smsDiscription').hide();
               	      		 formWin.down('#smsDiscriptionNotice').hide();
               	     		 formWin.down('#pushNotificationDiscription').hide();
               	     		 formWin.down('#pushNotificationDiscriptionNotice').hide();
               	     		 formWin.down('#recieverTypeIncludeMySelf').setVisible(false);
               	      		 this.setAllowBlank (formWin.down("#messageName"),false);
               	      		 this.setAllowBlank (formWin.down("#selectTemplate"),false);
               	      		// var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
               	      		// formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
               	      		 //formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
               	      	 }
               	       },
});
