/**
 * This controller is used for the Event Meeting Minutes Add/Edit/Delete/View
 * 
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.controller.taskmanagement.TaskManagementController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['taskmanagement.TaskManagementStore',
        'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
        'eventmeetingminutes.EventMeetingMinutesStatusStore',
        'eventmeetingminutes.EventMeetingMinutesTaskStore',
        'taskmanagement.TMMyTasksStore',
        'eventmeetingminutes.EventMeetingMinutesTaskRemarkStore',
        'eventmeetingminutes.EventMeetingMinutesDateTypeStore',
        'userGroup.UserGroupStore',
        'hostel.roomallocation.UserSmartSearchByUserType',
        'taskmanagement.TMTaskReportsStore',
        'taskmanagement.TMGraphicalReportsStore',
        'eventmeetingminutes.MyTaskAssignedByRemarkStore',
        'taskmanagement.TaskManagementAttachmentStore'
    ],
    views: ['taskmanagement.TaskManagementStructure',
        'taskmanagement.TaskManagementTabStructure',
        'taskmanagement.TaskManagementGrid',
        'taskmanagement.TaskManagementForm',
        'taskmanagement.TaskManagementTaskGrid',
        'taskmanagement.TMMyTasksStructure',
        'taskmanagement.TMMyTasksTabStructure',
        'taskmanagement.TMMyTasksFilter',
        'taskmanagement.TMMyTasksGrid',
        'taskmanagement.TMMyTasksUpdateTaskStatusWin',
        'eventmeetingminutes.EventMeetingMinutesTaskRemarkWin',
        'eventmeetingminutes.EventMeetingMinutesTaskRemarkGrid',
        'taskmanagement.TMTaskReportsStructure',
        'taskmanagement.TMTaskReportsTabStructure',
        'taskmanagement.TMTaskReportsFilter',
        'taskmanagement.TMTaskReportsGrid',
        'taskmanagement.TMGraphicalReportsFilter',
        'reports.common.PieChartReport',
        'taskmanagement.TMGraphicalReportsPieChart',
        'taskmanagement.TMGraphicalReportsBarChart',
        'taskmanagement.TaskManagementFilter',
        'taskmanagement.MyTaskAssignedByRemarkWin',
        'taskmanagement.MyTaskAssignedByRemarkGrid',
        'taskmanagement.AttachmentGridStructure',
        'taskmanagement.AttachmentGrid',
        'taskmanagement.AttachmentDocumentForm',
        'taskmanagement.DocumentAttachementWindow'
    ],
    models: ['eventmeetingminutes.EventMeetingMinutesModel',
        'eventmeetingminutes.EventMeetingMinutesTaskModel'
    ],
    requires: ['Academia.utilities.reader.EventMeetingMinuteCustomArrayReader'],
    config: {
        TM_CREATE_TASKS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TM_CREATE_TASKS_PRIVILEGES'),
        TM_MY_TASKS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TM_MY_TASKS_PRIVILEGES'),
        TM_TASK_REPORTS_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TM_TASK_REPORTS_PRIVILEGES'),
    },
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    }, {
        ref: 'taskmanagementgrid',
        selector: 'taskmanagementgrid'
    }, {
        ref: 'taskmanagementtaskgrid',
        selector: 'taskmanagementtaskgrid'
    }, {
        ref: 'taskmanagementform',
        selector: 'taskmanagementform'
    }, {
        ref: 'tmmytasksfilter',
        selector: 'tmmytasksfilter'
    }, {
        ref: 'tmmytasksgrid',
        selector: 'tmmytasksgrid'
    }, {
        ref: 'tmmytasksupdatetaskstatuswin',
        selector: 'tmmytasksupdatetaskstatuswin'
    }, {
        ref: 'eventmeetingminutestaskremarkwin',
        selector: 'eventmeetingminutestaskremarkwin'
    }, {
        ref: 'eventmeetingminutestaskremarkgrid',
        selector: 'eventmeetingminutestaskremarkgrid'
    }, {
        ref: 'tmtaskreportsfilter',
        selector: 'tmtaskreportsfilter'
    }, {
        ref: 'tmtaskreportsgrid',
        selector: 'tmtaskreportsgrid'
    }, {
        ref: 'tmgraphicalreportsfilter',
        selector: 'tmgraphicalreportsfilter'
    }, {
        ref: 'taskmanagementfilter',
        selector: 'taskmanagementfilter'
    },{
        ref: 'mytaskassignedbyremarkwin',
        selector: 'mytaskassignedbyremarkwin'
    },{
    	ref:'mytaskassignedbyremarkgrid',
    	selector:'mytaskassignedbyremarkgrid'
    },{
    	ref:'attachmentgrid',
    	selector:'attachmentgrid'
    },{
    	ref:'attachmentgridstructure',
    	selector:'attachmentgridstructure'
    },{
    	ref:'attachmentdocumentform',
    	selector:'attachmentdocumentform'
    },{
    	ref:'documentattachementwindow',
    	selector:'documentattachementwindow'
    }],
    init: function() {
    	this.taskFormMode;
    	this.screenName;
        this.control({
            'taskmanagementgrid button[itemId=btnAdd]': {
                click: function() {
                    this.openAddTaskManagementTab('ADD');
                }
            },
            'taskmanagementgrid button[itemId=btnEdit]': {
                click: function() {
                    this.openEditTaskManagementTab('EDIT');
                }
            },
            'taskmanagementgrid button[itemId=btnView]': {
                click: function() {
                    this.openViewTaskManagementTab();
                    this.taskFormMode='VIEW';
                }
            },
            'taskmanagementgrid button[itemId=btnDelete]': {
                click: function() {
                    var $this = this;
                    var grid = $this.getTaskmanagementgrid();
                    var serverURL = SERVERURL.TM_TASK_MANAGEMENT_DELETE;
                    if (grid.getSelectionModel().getCount() > 0) {
                        showConfirmMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                            if (btn == 'yes') {
                                Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                                var records = grid.getSelectionModel().getSelection();
                                var id = records[0].get("id");
                                Ext.Ajax.request({
                                    method: "DELETE",
                                    type: 'rest',
                                    url: serverURL + '?id=' + id,
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    success: function(form, action) {
                                        Ext.getBody().unmask();
                                        grid.getStore().reload();
                                        showSuccessMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'), getServiceRequestTranslation('TM_TASKS_DELETED_SUCCESSFULLY'));
                                    }
                                });
                            }
                        });
                    } else {
                        showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
                    }
                }
            },
            'taskmanagementtaskgrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var grid = $this.getTaskmanagementtaskgrid();
                    var columnName = grid.columnManager.columns[cellIndex].dataIndex;

                    if (e.target.tagName == 'DIV') {
                        if (columnName == "addButton") {
                            if (e.target.className == "addButtonClsForGridActionCls") {
                                if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                                    var serialNo;
                                    if (grid.getStore() != null)
                                        serialNo = grid.getStore().getCount();
                                    this.addNewRowInTaskGrid(serialNo + 1);
                                }
                            }
                        } else if (columnName == "deleteButton") {
                            if (e.target.className == "deleteButtonClsForGridActionCls") {
                                if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                                    if (grid.getStore().getRange().length > 1) {
                                        if (isNullOrEmpty(record.data.id)) {
                                            grid.getStore().removeAt(rowIndex);
                                            var models = grid.getStore().getRange();
                                            for (var i = 0; i < models.length; i++) {
                                                models[i].data.serialNo = i + 1;
                                            }
                                            grid.getStore().loadRawData(models, true);
                                        } else {
                                            showConfirmMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'),
                                                getServiceRequestTranslation('TM_EXISTING_TASK_DELETE_MSG'),
                                                function(btn, text) {
                                                    if (btn == 'yes') {
                                                        grid.getStore().removeAt(rowIndex);
                                                        var models = grid.getStore().getRange();
                                                        for (var i = 0; i < models.length; i++) {
                                                            models[i].data.serialNo = i + 1;
                                                        }
                                                        grid.getStore().loadRawData(models, true);
                                                    }
                                                });
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if (e.target.tagName == 'A') {
                        if (columnName == 'showViewLink') {
                            if (!isNullOrEmpty(record.data.id)) {
                                var formWindow = $this.getEventmeetingminutestaskremarkwin();
                                if (!formWindow) {
                                    Ext.widget('eventmeetingminutestaskremarkwin');
                                    formWindow = $this.getEventmeetingminutestaskremarkwin();
                                }
                                var remarkGrid = $this.getEventmeetingminutestaskremarkgrid();
                                var remarkStore = remarkGrid.getStore();
                                remarkStore.getProxy().extraParams = {
                                    eventMeetingMinutesTaskId: record.data.id
                                };
                                remarkStore.load({
                                    callback: function(records, operation, success) {
                                        if (records.length > 0) {
                                            formWindow.show();
                                        } else {
                                            showWarningMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'),
                                                getServiceRequestTranslation('EMM_NO_REMARK_AVAILABLE'));
                                        }
                                    }
                                });
                            }
                        }
                    }
                    if (e.target.tagName == 'A') {
                        if (columnName == 'attachments'){
                        	 if(this.getActiveTabfromContentPanel().title==getServiceRequestTranslation('TM_VIEW_TASKS')){
                        		this.taskFormMode='VIEW';
                        	 } 
                        	 this.openAttachmentTab('ATTACHMENTS','',record.data.id,'createTaskScreen');
                        }
                     }
                },
                afterrender:function(grid){
                   var me = this;
                   setTimeout(function(){
                   me.addDataGridConfigButton(grid, me.getTM_CREATE_TASKS_PERMISSIONS());
                   },1500);
                } 
            },
         
            'taskmanagementform button[itemId=resetTaskmanagementformItemId]': {
                click: function() {
                    this.resetTaskManagementForm();
                }
            },
            'taskmanagementform button[itemId=saveTaskmanagementformItemId]': {
                click: this.saveTaskManagement
            },
            /*'taskmanagementform textfield#minuteSubjectItemId': {
                blur: function(obj, record) {
                    var data = obj.getValue();
                    if (data) {
                        var form = this.getTaskmanagementform();
                        var grid = this.getTaskmanagementgrid();
                        var submitUrl = SERVERURL.EMM_EVENT_MEETING_MINUTES_UNIQUE_MINUTE_SUBJECT + '?minuteSubject=' + data + '&moduleName=TaskManagement';
                        Ext.Ajax.request({
                            type: 'rest',
                            url: submitUrl,
                            method: 'GET',
                            success: function(response, action) {
                                var responseData = Ext.decode(response.responseText);
                                if (responseData.code == 'EXIST') {
                                    if (grid.getSelectionModel().getCount() > 0) {
                                        if (grid.getSelectionModel().getSelection()[0].data.minuteSubject != data) {
                                            showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('TM_DUPLICATE_TITLE'));
                                            form.down("#minuteSubjectItemId").setValue(grid.getSelectionModel().getSelection()[0].data.minuteSubject);
                                        }
                                    } else {
                                        showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('TM_DUPLICATE_TITLE'));
                                        form.down("#minuteSubjectItemId").reset();
                                    }
                                }
                            }
                        });
                    }
                }
            },*/
            'taskmanagementgrid': {
            	beforerender: function() {
                    this.getStore('taskmanagement.TaskManagementStore').removeAll();
                    var grid = this.getTaskmanagementgrid();
                    var store = grid.getStore();
                    if (store)
                    	this.resetPageSetting(store);
                },
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getTM_CREATE_TASKS_PERMISSIONS());
                }
            },
            'tmmytasksfilter button[itemId=searchBtnTmmytasksfilterItemId]': {
                click: function() {
                    this.loadTMMyTasksGrid();
                },
                afterrender: function(obj, value) {
                    var form = obj.up('form');
                    var date = new Date();
                    var fromdate = new Date(date.setMonth(date.getMonth() - 1));
                    form.down('#fromDateItemId').setValue(dateRender(fromdate));
                    form.down('#toDateItemId').setValue(new Date());
                }
            },
            'tmmytasksfilter button[itemId=resetTmmytasksfilterItemId]': {
                click: function() {
                    var $this = this;
                    var form = this.getTmmytasksfilter();
                    form.getForm().reset();
                    var date = new Date();
                    var fromdate = new Date(date.setMonth(date.getMonth() - 1));
                    form.down('#fromDateItemId').setValue(dateRender(fromdate));
                    form.down('#toDateItemId').setValue(new Date());
                }
            },
            'tmmytasksgrid': {
                beforerender: function() {
                    this.getStore('taskmanagement.TMMyTasksStore').removeAll();
                },
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getTM_MY_TASKS_PERMISSIONS());
                },
                
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var grid = $this.getTmmytasksgrid();
                    var columnName = grid.columnManager.columns[cellIndex].dataIndex;
                    if (e.target.tagName == 'A') {
                        if (columnName == 'status') {
                            if (grid.getSelectionModel().getCount() > 0) {
                                var records = grid.getSelectionModel().getSelection();
                                if (records != "" && records != null && records != undefined) {
                                    var formWindow = $this.getTmmytasksupdatetaskstatuswin();
                                    if (!formWindow) {
                                        Ext.widget('tmmytasksupdatetaskstatuswin');
                                        formWindow = $this.getTmmytasksupdatetaskstatuswin();
                                    }
                                    var formData = records[0].data;
                                    var form = formWindow.down('#tmMyTasksUpdateTaskStatusFormItemId');
                                    var idItemId = form.down('#idItemId');
                                    var taskStatusItemId = form.down('#taskStatusItemId');

                                    idItemId.setValue(formData.id);
                                    if (!isNullOrEmpty(formData.status)) {
                                        taskStatusItemId.getStore().load({
                                            callback: function(records, operation, success) {
                                                taskStatusItemId.setValue(formData.status);
                                            }
                                        });
                                    }
                                }
                            }
                            formWindow.show();
                        } else if (columnName == 'taskRemarks') {
                            if (!isNullOrEmpty(record.data.id)) {
                                var formWindow = $this.getEventmeetingminutestaskremarkwin();
                                if (!formWindow) {
                                    Ext.widget('eventmeetingminutestaskremarkwin');
                                    formWindow = $this.getEventmeetingminutestaskremarkwin();
                                }
                                var remarkGrid = $this.getEventmeetingminutestaskremarkgrid();
                                var remarkStore = remarkGrid.getStore();
                                remarkStore.getProxy().extraParams = {
                                    eventMeetingMinutesTaskId: record.data.id
                                };
                                remarkStore.load({
                                    callback: function(records, operation, success) {
                                        if (records.length > 0) {
                                            formWindow.show();
                                        } else {
                                            showWarningMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'),
                                                getServiceRequestTranslation('EMM_NO_REMARK_AVAILABLE'));
                                        }
                                    }
                                });
                            }
                        }else if(columnName == 'assignedByRemark'){
                            if (!isNullOrEmpty(record.data.id)) {
                                var formWindow = $this.getMytaskassignedbyremarkwin();
                                if (!formWindow) {
                                    Ext.widget('mytaskassignedbyremarkwin');
                                    formWindow = $this.getMytaskassignedbyremarkwin();
                                }
                                var remarkGrid = $this.getMytaskassignedbyremarkgrid();
                                var remarkStore = remarkGrid.getStore();
                                remarkStore.getProxy().extraParams = {
                                	taskId: record.data.id
                                };
                                remarkStore.load({
                                    callback: function(records, operation, success) {
                                        if (records.length > 0) {
                                            formWindow.show();
                                        } else {
                                            showWarningMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'),
                                                getServiceRequestTranslation('EMM_NO_REMARK_AVAILABLE'));
                                        }
                                    }
                                });
                            }
                        }else if(columnName == 'attachments'){
                        	 this.openAttachmentTab('ATTACHMENTS','',record.data.id,'myTaskScreen');
                        }
                    }
                }
                
            },
            'tmmytasksupdatetaskstatuswin button[itemId=saveTmmytasksupdatetaskstatuswinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getTmmytasksupdatetaskstatuswin();

                    var form = formWindow.down('#tmMyTasksUpdateTaskStatusFormItemId');
                    var formValues = form.getValues();
                    var id = formValues.id;
                    var taskStatus = formValues.taskStatus;
                    var ownerRemark = formValues.ownerRemark;

                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.EMM_EMPLOYEE_PORTAL_DASHLET_UPDATE_TASK_STATUS,
                        jsonData: {
                            id: id,
                            status: taskStatus,
                            ownerRemark: ownerRemark
                        },
                        method: 'POST',
                        success: function(frm, action) {
                            Ext.getBody().unmask();
                            $this.loadTMMyTasksGrid();
                            formWindow.close();
                        }
                    });
                }
            },
            'tmmytasksupdatetaskstatuswin button[itemId=cancelTmmytasksupdatetaskstatuswinItemId]': {
                click: function() {
                    var $this = this;
                    var formWindow = $this.getTmmytasksupdatetaskstatuswin();
                    formWindow.close();
                }
            },
            'tmtaskreportsfilter customcombobox[itemId=userTypeItemId]': {
                select: function(obj, rec) {
                    var $this = this;
                    var form = $this.getTmtaskreportsfilter();
                    form.down('#ownerIdItemId').setDisabled(false);
                    var ownerIdStore = form.down('#ownerIdItemId').getStore();

                    var academyLocationId = $this.getCurrentAcademyLocation();
                    var alids = [];
                    alids.push(academyLocationId);
                    ownerIdStore.getProxy().extraParams = {
                        userType: rec[0].data.id,
                        academyLocationIds: alids.join()
                    };
                    ownerIdStore.load();
                }
            },
            'tmtaskreportsfilter button[itemId=searchBtnTmtaskreportsfilterItemId]': {
                click: function() {
                    this.loadTMTaskReportsGrid();
                },
                afterrender: function(obj, value) {
                    var form = obj.up('form');
                    var date = new Date();
                    var fromdate = new Date(date.setMonth(date.getMonth() - 1));
                    form.down('#fromDateItemId').setValue(dateRender(fromdate));
                    form.down('#toDateItemId').setValue(new Date());
                }
            },
            'tmtaskreportsfilter button[itemId=resetTmtaskreportsfilterItemId]': {
                click: function() {
                    var $this = this;
                    var form = this.getTmtaskreportsfilter();
                    form.getForm().reset();

                    var ownerIdItemId = form.down("#ownerIdItemId");
                    ownerIdItemId.setDisabled(true);
                    ownerIdItemId.reset();

                    var date = new Date();
                    var fromdate = new Date(date.setMonth(date.getMonth() - 1));
                    form.down('#fromDateItemId').setValue(dateRender(fromdate));
                    form.down('#toDateItemId').setValue(new Date());
                }
            },
            'tmtaskreportsgrid': {
                beforerender: function() {
                    this.getStore('taskmanagement.TMTaskReportsStore').removeAll();
                },
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getTM_TASK_REPORTS_PRIVILEGES());
                },
               	 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                        var $this = this;
                        var grid = $this.getTmtaskreportsgrid();
                        var columnName = grid.columnManager.columns[cellIndex].dataIndex;
                        if (e.target.tagName == 'A') {
                            if (columnName == 'attachments'){
                            	 this.openAttachmentTab('ATTACHMENTS','VIEWMODE',record.data.id,'taskReportScreen');
                            }
                         }
               	 }
               	
            },
            'tmtaskreportsfilter button[itemId=graphicalReportsTmtaskreportsfilterItemId]': {
                click: function() {
                    this.openGraphicalReportTab();
                }
            },
            'tmgraphicalreportsfilter button[itemId=generateTmgraphicalreportsfilterItemId]': {
                click: function() {
                    this.loadGraphicalReports();
                },
                afterrender: function(obj, value) {
                    var form = obj.up('form');
                    var date = new Date();
                    var fromdate = new Date(date.setMonth(date.getMonth() - 1));
                    form.down('#fromDateItemId').setValue(dateRender(fromdate));
                    form.down('#toDateItemId').setValue(new Date());
                }
            },
            'tmgraphicalreportsfilter button[itemId=resetTmgraphicalreportsfilterItemId]': {
                click: function() {
                    var $this = this;
                    var form = this.getTmgraphicalreportsfilter();
                    form.getForm().reset();
                    var date = new Date();
                    var fromdate = new Date(date.setMonth(date.getMonth() - 1));
                    form.down('#fromDateItemId').setValue(dateRender(fromdate));
                    form.down('#toDateItemId').setValue(new Date());

                    var tmGraphicalReportsPieChart = form.down('#tmGraphicalReportsPieChartItemId');
                    var tmGraphicalReportsBarChart = form.down('#tmGraphicalReportsBarChartItemId');
                    var chartText = form.down('#chartTextItemId');
                    var pieChartExportButton = form.down('#pieChartExportButtonItemId');
                    var barChartExportButton = form.down('#barChartExportButtonItemId');
                    tmGraphicalReportsPieChart.setVisible(false);
                    tmGraphicalReportsBarChart.setVisible(false);
                    chartText.setVisible(false);
                    pieChartExportButton.setVisible(false);
                    barChartExportButton.setVisible(false);

                    tmGraphicalReportsPieChart.getStore().removeAll();
                    tmGraphicalReportsPieChart.getStore().loadRawData([]);
                    tmGraphicalReportsBarChart.getStore().removeAll();
                    tmGraphicalReportsBarChart.getStore().loadRawData([]);
                }
            },
            'taskmanagementfilter customcombobox[itemId=userTypeItemId]': {
                select: function(obj, rec) {
                    var $this = this;
                    var form = $this.getTaskmanagementfilter();
                    form.down('#ownerIdItemId').setDisabled(false);
                    var ownerIdStore = form.down('#ownerIdItemId').getStore();

                    var academyLocationId = $this.getCurrentAcademyLocation();
                    var alids = [];
                    alids.push(academyLocationId);
                    ownerIdStore.getProxy().extraParams = {
                        userType: rec[0].data.id,
                        academyLocationIds: alids.join()
                    };
                    ownerIdStore.load();
                }
            },
            'taskmanagementfilter': {
                render: function() {
                	var user = this.getCurrentlyLoggedInUser();
                	
                	if (!isNullOrEmpty(user) && !isNullOrEmpty(user.id) && user.id == 1) {
                		var form = this.getTaskmanagementfilter();
                        
                        var userTypeId = form.down("#userTypeItemId");
                        var ownerId = form.down("#ownerIdItemId");
                        userTypeId.show();
                        ownerId.show();
                	}
                }
            },
            'taskmanagementfilter button[itemId=searchBtnTaskmanagementfilterItemId]': {
                click: function() {
                	this.loadTaskManagementGrid();
                },
                afterrender: function(obj, value) {
                    var form = obj.up('form');
                    var date = new Date();
                    var fromdate = new Date(date.setMonth(date.getMonth() - 1));
                    form.down('#fromDateItemId').setValue(dateRender(fromdate));
                    form.down('#toDateItemId').setValue(new Date());
                }
            },
            'taskmanagementfilter button[itemId=resetTaskmanagementfilterItemId]': {
                click: function() {
                    var $this = this;
                    var form = this.getTaskmanagementfilter();
                    form.getForm().reset();

                    var ownerIdItemId = form.down("#ownerIdItemId");
                    ownerIdItemId.setDisabled(true);
                    ownerIdItemId.reset();

                    var date = new Date();
                    var fromdate = new Date(date.setMonth(date.getMonth() - 1));
                    form.down('#fromDateItemId').setValue(dateRender(fromdate));
                    form.down('#toDateItemId').setValue(new Date());
                }
            },
            'attachmentgrid':{
            	render: function(grid) {
                    var addTaskGrid = this.getTaskmanagementtaskgrid();
                    var taskReportGrid = this.getTmtaskreportsgrid();
                    var myTask= this.getTmmytasksgrid();
                    var record;
                	var storess = grid.getStore();
    				storess.load();
    				if(this.taskFormMode=='VIEW'){
    					grid.down('#btnAdd').setDisabled(true);
    					grid.down('#btnDeleteSU').setDisabled(true);
    					this.taskFormMode='';
    				}
    			},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							this.getDownloadFile(record.get('documentId'));
						}
					}
				}
		},
		'attachmentdocumentform button#documentFormSubmitButtonId': {
     	   click: function(obj) {
     		   var form=obj.up('form');
					this.saveAttachmentDocumentForm(form);		                	  
					}
        },
		'attachmentgrid button[itemId=btnAdd]': {
			click: function() {
				var me=this;
				var docWindow = this.getDocumentattachementwindow();
				if (!docWindow) {
					docWindow = Ext.widget('documentattachementwindow',{
						itemId:'documentattachementwindow'
					});
				}
				docWindow.show();
			}
		},
		
			'attachmentgridstructure attachmentgrid button[itemId=downloadDocumentSUItemId]':{
				click:function(obj){
					this.documentDownloadAllAttachmentBtnZip();
				}
			},
			'attachmentgridstructure attachmentgrid button[itemId=btnDeleteSU]':{
				click:function(obj){
					this.deleteAttachmentDocument();
				}
			},
			'attachmentdocumentform filefield[itemId=uploadFileField]':{
				change: function(photoFileImage, value, eOpts) {
            		value = value.replace('C:\\fakepath\\', '');
            		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
            		photoFileImage.setRawValue(newValue);
            		
            		var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
            		if(!isNullOrEmpty(value)){
            			if (extension == "gif" || extension == "png" || extension == "bmp"
            				|| extension == "jpeg" || extension == "jpg" || extension == "pdf" || extension == "csv"   || extension == "xlsx" || extension == "xls" || extension == "txt" || extension == "doc"  || extension == "docx" || extension == "pptx") {
            				
            			}else{
                			photoFileImage.reset();
                			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
            			}
            		}
            	}
			}
        });
    },
    /** Open tab for Add Event Manage Minutes */
    openAddTaskManagementTab: function(openView) {
        var $this = this;
        var contentpanel = this.getContentpanel();
        var taskmanagementform = Ext.widget('taskmanagementform');
        taskmanagementform.setTitle(getServiceRequestTranslation('TM_ADD_TASKS'));
        if (openView == 'ADD') {
            taskmanagementform.setTitle(getServiceRequestTranslation('TM_ADD_TASKS'));
            var tabName = getServiceRequestTranslation('TM_ADD_TASKS');
        } else if (openView == 'EDIT') {
            taskmanagementform.setTitle(getServiceRequestTranslation('TM_EDIT_TASKS'));
            var tabName = getServiceRequestTranslation('TM_EDIT_TASKS');
        } else if (openView == 'VIEW') {
            taskmanagementform.setTitle(getServiceRequestTranslation('TM_VIEW_TASKS'));
            var tabName = getServiceRequestTranslation('TM_VIEW_TASKS');
        }
        /**
         * This is to remove tab from content panel and open same tab again
         */
        var getcontroller = this.getController('menu.CoreERPNavigationController');
        var getAddTab = getcontroller.getTab(getServiceRequestTranslation('TM_ADD_TASKS'));
        var getEditTab = getcontroller.getTab(getServiceRequestTranslation('TM_EDIT_TASKS'));
        var getViewTab = getcontroller.getTab(getServiceRequestTranslation('TM_VIEW_TASKS'));
        if (getAddTab != null) {
            contentPanel.remove(getAddTab, true);
        }
        if (getEditTab != null) {
            contentPanel.remove(getEditTab, true);
        }
        if (getViewTab != null) {
            contentPanel.remove(getViewTab, true);
        }
        openTab(contentpanel, tabName, taskmanagementform, CONSTANTS.MENU_COLOR_NINE);

        var taskGrid = $this.getTaskmanagementtaskgrid();
        taskGrid.getStore().removeAll();
        taskGrid.getStore().loadRawData([]);

        var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.FacultyIdValueSmartSearch');
        var viewParticipantArray = [];
        store.load({
            callback: function(records, operation, success) {
                for (var i in records) {
                    var data = records[i].data;
                    var newData = {
                        "id": data.id,
                        "printName": data.value
                    };
                    viewParticipantArray.push(newData);
                }
                
                taskGrid.config.viewParticipantList =viewParticipantArray;
                
                /*Ext.apply(taskGrid, {
                    viewParticipantList: null,
                    setViewParticipantList: function(viewParticipantList) {
                        taskGrid.viewParticipantList = viewParticipantList;
                    },
                    getViewParticipantList: function() {
                        return taskGrid.viewParticipantList;
                    }
                });
                taskGrid.setViewParticipantList(viewParticipantArray);*/
            }
        });

        if (openView == 'ADD') {
            var userId = this.getCurrentlyLoggedInUser();
            var minuteTakerIdItemId = taskmanagementform.down('#minuteTakerIdItemId');
            var minuteTakerStore = minuteTakerIdItemId.getStore();
            minuteTakerStore.load({
                callback: function(operation, success) {
                    if (success) {
                        minuteTakerIdItemId.setValue(userId.id);
                    }
                }
            });
            $this.addNewRowInTaskGrid(1);
            
            
        }

    },
    openAttachmentTab: function(openView,mode,recordId,screenName){
    	var $this = this; 
    	$this.screenName=screenName;
    	var contentPanel = this.getContentpanel();
    	var structure = Ext.widget('attachmentgridstructure');
    	var grid =structure.down('#attachmentgridItemId');
    	var addBtn = grid.down('#btnAdd');
    	var delBtn = grid.down('#btnDeleteSU');
    //	var downloadAllBtn = grid.down('#downloadDocumentSUItemId');
    	if(mode=="VIEWMODE"){
    		addBtn.setDisabled(true);
    		delBtn.setDisabled(true);
    	//	downloadAllBtn.setDisabled(false);
    	}else{
    		addBtn.setDisabled(false);
    		delBtn.setDisabled(false);
    	//	downloadAllBtn.setDisabled(false);
    	}
    	var tabName = getCommonTranslation('ATTACHMENTS');
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentPanel.remove(getTab, true);
    	}
    	grid.getStore().getProxy().extraParams = {
    					 taskId: recordId
    			        };
    	openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);
    	
	},
	saveAttachmentDocumentForm : function(form){
                var $this = this;
                var isTransient = true;
                var module = 'toolsAndServices';
                var jsonData = new Object;
                var entityId;
                var grid;
                if($this.screenName=='createTaskScreen'){
                	grid = this.getTaskmanagementtaskgrid();
                }else if($this.screenName=='myTaskScreen'){
                	grid = this.getTmmytasksgrid();
                }
                var record =   grid.getSelectionModel().getSelection()[0];
                var docController = this.getController('Academia.controller.document.DocumentController');
                docController.saveDocumentForm(entityId,null,null,'ATTACHMENTDOCUMENT',
                   function(success,response,isCallBackTransient) {
                	//showSuccessMessage(getCommonTranslation('FILE_DETAILS'),getServiceRequestTranslation('DOCUMENT_UPLOAD'));
                	var eventMeetingMinutesTask={
             			          "id":record.data.id
             			       };
                	var document={
                		"name":response.name,
                		"path":response.path,
                		"type":response.type,
                		"createdBy":$this.getIdValueJson(response.createdBy.id,response.createdBy.value)
                	};
                   jsonData={
                			"eventMeetingMinutesTask":eventMeetingMinutesTask,
                        	"document":document
                	};
                   Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.PATH_ATTACHMENT_LINK_SAVE,
						jsonData : jsonData,
						method : 'POST',
						success : function(response, action) {
							 var closewindow = $this.getDocumentattachementwindow();
			                 closewindow.close();
			                 showSuccessMessage(getCommonTranslation('FILE_DETAILS'),getServiceRequestTranslation('DOCUMENT_UPLOAD'));
							var attachmentgrid = $this.getAttachmentgrid();
		                    var store = attachmentgrid.getStore();
		                    store.load();
							Ext.getBody().unmask()
						}
					});
                    
                }, isTransient);
                
	},
	documentDownloadAllAttachmentBtnZip : function(){
		var $this = this;
		var form = $this.getAttachmentgridstructure();
		var attachmentgrid=form.down('#attachmentgridItemId');
		if (attachmentgrid.getSelectionModel().getCount() > 0) {
			var records = attachmentgrid.getSelectionModel().getSelection();
			var dispatchZipName = "File Details Documents";
			var saveModel=[];  
			for(var i in records){
				if(!isNullOrEmpty(records[i].get('path'))) {
					saveModel.push(records[i].get('path'));
				}
				showConfirmMessage(getCommonTranslation('ATTACHMENT_DOCUMENTS'),
						getCommonTranslation('ATTACHMENT_DOCUMENTS_ALERT'),
						function(btn, text) {
					if (btn == 'yes') {
						var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
						 var docController = $this.getController('Academia.controller.document.DocumentController');
						//$this.getController('Academia.controller.document.DocumentController')
						 docController.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
					}
				});

			}
		}
		else {
			$this.hideWindowMask();
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	deleteAttachmentDocument : function() {
		var $this=this;
		var form = $this.getAttachmentgridstructure();
		var attachmentgrid= $this.getAttachmentgrid();
		var attachmentaction = this.getAttachmentgridstructure();
		var attachmentDocGrid=form.down('#attachmentgridItemId');
		if (attachmentDocGrid.getSelectionModel().getCount() > 0) {
			var records = attachmentDocGrid.getSelectionModel().getSelection();
			var ids=[];
			Ext.Array.each(records,function(value){
				ids.push(value.data.id);
			});
			showConfirmMessage(getPersonModuleTranslation('ATTACHMENTS'),getCommonTranslation('ATTACHMENT_DOC_DELETE_CONFIRM_MESSAGE'),function(btn,text){
				if (btn == 'yes'){
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url : SERVERURL.PATH_TASK_DOCUMENT_DELETE+'?id='+ids.join(),
						headers: {
							'Content-Type': 'application/json'
						},
						success: function(form, action) {

							Ext.getBody().unmask();
							showSuccessMessage(getCommonTranslation('ATTACHMENTS'),getCommonTranslation('ATTACHMENT_DOCUMENT_SUCCESS_DELETE_MSG'));	 
							attachmentDocGrid.store.reload();
							attachmentgrid.store.reload();
							attachmentDocGrid.getSelectionModel().deselectAll(true);
						}
					});
				}
			});
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
		}
	},
	getDownloadFile : function(documentId){
        if(!isNullOrEmpty(documentId)){
            var $this = this;
            var docController = this.getController('Academia.controller.document.DocumentController');
            docController.downloadDocumentFile(documentId);
        }
    },
    addNewRowInTaskGrid: function(serialNo) {
        var $this = this;
        var grid = $this.getTaskmanagementtaskgrid();
        var ObjModel = [];
        var emmTaskModel = new Academia.model.eventmeetingminutes.EventMeetingMinutesTaskModel();

        var currentDate = new Date();
        currentDate.setHours(0);
        currentDate.setMinutes(0);
        currentDate.setSeconds(0);
        currentDate.setMilliseconds(0);
        emmTaskModel.set("serialNo", serialNo);
        emmTaskModel.set("assignDate", currentDate);
        emmTaskModel.set("description", '');
        emmTaskModel.set("ownerId", '');
        emmTaskModel.set("status", 'PENDING');
        emmTaskModel.set("statusPrefillValue", 'PENDING');
        emmTaskModel.set("dueDate", '');
        emmTaskModel.set("completionDate", '');
        emmTaskModel.set("noOfDaysOverdue", '');
        emmTaskModel.set("isEditable", 'ADD');
        emmTaskModel.set("isAddDeleteRow", true);

        ObjModel.push(emmTaskModel);
        grid.getStore().loadRawData(ObjModel, true);
    },
    resetTaskManagementForm: function() {
        var $this = this;
        var form = this.getTaskmanagementform();
        //form.getForm().reset();
        var minuteTakerIdItemId = form.down("#minuteTakerIdItemId");
        var minuteDateItemId = form.down("#minuteDateItemId");
        var minuteSubjectItemId = form.down("#minuteSubjectItemId");

        minuteTakerIdItemId.reset();
        minuteDateItemId.setValue(new Date());
        minuteSubjectItemId.reset();

        var userId = this.getCurrentlyLoggedInUser();
        var minuteTakerStore = minuteTakerIdItemId.getStore();
        minuteTakerStore.load({
            callback: function(operation, success) {
                if (success) {
                    minuteTakerIdItemId.setValue(userId.id);
                }
            }
        });

        var grid = this.getTaskmanagementtaskgrid();
        var store = grid.getStore();
        if (store)
            store.removeAll();
        $this.addNewRowInTaskGrid(1);
    },
    saveTaskManagement: function() {
        var $this = this;
        var eventmeetingminutesform = $this.getTaskmanagementform();
        var form = eventmeetingminutesform.getForm();
        var formValues = form.getValues();

        var eventMeetingMinutesModel = new Academia.model.eventmeetingminutes.EventMeetingMinutesModel();
        var minuteDate = formValues.minuteDate;
        eventMeetingMinutesModel.set("minuteDate", formValues.minuteDate);
        eventMeetingMinutesModel.set("minuteSubject", formValues.minuteSubject);

        var minuteTaker = null;
        if (!isNullOrEmpty(formValues.minuteTakerId)) {
            minuteTaker = {
                id: formValues.minuteTakerId
            };
        }
        eventMeetingMinutesModel.set("minuteTaker", minuteTaker);

        var taskGrid = $this.getTaskmanagementtaskgrid();
        var models = taskGrid.getStore().getRange();
        var myJson = new Array();
        for (var i = 0; i < models.length; i++) {
            // if (!isNullOrEmpty(models[i].get('statusPrefillValue')) && models[i].get('statusPrefillValue') == 'PENDING') {
            var emmTaskModel = new Academia.model.eventmeetingminutes.EventMeetingMinutesTaskModel();
            var serialNo = models[i].get('serialNo');
            if (!isNullOrEmpty(models[i].get('id'))) {
                emmTaskModel.set("id", models[i].get('id'));
            }
            if (!isNullOrEmpty(models[i].get('assignDate'))) {
                var dateAssign = new Date(models[i].get('assignDate'));
                minuteDate = new Date(minuteDate);
                minuteDate.setHours(0);
                minuteDate.setMinutes(0);
                if (dateAssign < minuteDate) {
                    showWarningMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'),
                        'Assign Date must be equal or greater than Task Date' + ' in ' + serialNo + ' Row.');
                    return false;
                } else {
                    emmTaskModel.set("assignDate", Ext.Date.format(dateAssign, CONSTANTS.SUBMIT_DATE_FORMAT));
                }
            }
            if (!isNullOrEmpty(models[i].get('description'))) {
                emmTaskModel.set("description", models[i].get('description'));
            }
            var owner = null;
            if (!isNullOrEmpty(models[i].get('ownerId'))) {
                owner = {
                    id: models[i].get('ownerId')
                };
            } else {
                owner = {
                    id: formValues.minuteTakerId
                };
            }
            emmTaskModel.set("owner", owner);

            if (!isNullOrEmpty(models[i].get('status'))) {
                emmTaskModel.set("status", models[i].get('status'));
            } else {
                showWarningMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'), getServiceRequestTranslation('EMM_PLEASE_SELECT') + ' ' +
                    getServiceRequestTranslation('EMM_MINUTE_STATUS') + ' in ' + serialNo + ' Row.');
                return false;
            }
            if (!isNullOrEmpty(models[i].get('dueDate'))) {
                var dateAssign = new Date(models[i].get('assignDate'));
                var dateDue = new Date(models[i].get('dueDate'));
                if (dateDue < dateAssign) {
                    showWarningMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'),
                        'Due Date must be equal or greater than Assign Date' + ' in ' + serialNo + ' Row.');
                    return false;
                } else {
                    emmTaskModel.set("dueDate", Ext.Date.format(dateDue, CONSTANTS.SUBMIT_DATE_FORMAT));
                }
            }
            if (!isNullOrEmpty(models[i].get('completionDate'))) {
                var dateCompletion = new Date(models[i].get('completionDate'));
                emmTaskModel.set("completionDate", Ext.Date.format(dateCompletion, CONSTANTS.SUBMIT_DATE_FORMAT));
            }
            if (!isNullOrEmpty(models[i].get('noOfDaysOverdue'))) {
                emmTaskModel.set("noOfDaysOverdue", models[i].get('noOfDaysOverdue'));
            }
            
            if (!isNullOrEmpty(models[i].get('remark'))) {
                emmTaskModel.set("remark", models[i].get('remark'));
            }
            delete emmTaskModel.data.serialNo;
            delete emmTaskModel.data.ownerId;
            delete emmTaskModel.data.ownerPrefillId;
            delete emmTaskModel.data.isEditable;
            delete emmTaskModel.data.statusPrefillValue;
            delete emmTaskModel.data.dueDatePrefillValue;
            delete emmTaskModel.data.isAddDeleteRow;
            delete emmTaskModel.data.showViewLink;
            delete emmTaskModel.data.topic;
            delete emmTaskModel.data.type;
            delete emmTaskModel.data.parentTaskId;
            delete emmTaskModel.data.forwardedDate;
            delete emmTaskModel.data.lastUpdate;
            delete emmTaskModel.data.assignDatePrefillValue;
            myJson.push(emmTaskModel.data);
            //}
        }
        eventMeetingMinutesModel.set("eventMeetingMinutesTasks", myJson);

        var message;
        var msg;
        var url;
        var tabName;

        if (isNullOrEmpty(formValues.id)) {
            message = getServiceRequestTranslation('TM_TASKS_CREATED_SUCCESSFULLY');
            msg = getCommonTranslation('RECORD_ADD_SUCCESS');
            url = SERVERURL.TM_TASK_MANAGEMENT_SAVE;
            tabName = getServiceRequestTranslation('TM_ADD_TASKS');
        } else {
            eventMeetingMinutesModel.set("id", formValues.id);
            message = getServiceRequestTranslation('TM_TASKS_UPDATED_SUCCESSFULLY');
            msg = getCommonTranslation('RECORD_UPDATE_SUCCESS');
            url = SERVERURL.TM_TASK_MANAGEMENT_UPDATE;
            tabName = getServiceRequestTranslation('TM_EDIT_TASKS');
        }
        delete eventMeetingMinutesModel.data.totalNoOfMinute;
        delete eventMeetingMinutesModel.data.totalNoOfPendingMinute;
        delete eventMeetingMinutesModel.data.totalNoOfForwardedMinute;
        delete eventMeetingMinutesModel.data.totalNoOfCompletedMinute;
        delete eventMeetingMinutesModel.data.minuteDateInOrgFormat;
        delete eventMeetingMinutesModel.data.showViewColumn;
        delete eventMeetingMinutesModel.data.minuteTakerName;
        delete eventMeetingMinutesModel.data.eventMeetingMinutesDocuments;
        delete eventMeetingMinutesModel.data.event;

        var formData = Ext.encode(eventMeetingMinutesModel.data);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: url,
            jsonData: formData,
            method: 'POST',
            success: function(response, action) {
                Ext.getBody().unmask();
                var data = Ext.decode(response.responseText);
                if (data.code == 'EXIST') {
                    showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('TM_DUPLICATE_TITLE'));
                    eventmeetingminutesform.down("#minuteSubjectItemId").reset();
                    eventmeetingminutesform.isValid();
                } else {
                    var contentpanel = $this.getContentpanel();
                    var getcontroller = $this.getController('menu.CoreERPNavigationController');
                    var getTab = getcontroller.getTab(tabName);
                    if (getTab != null) {
                        contentPanel.remove(getTab, true);
                    }
                    var grid = $this.getTaskmanagementgrid();
                    var store = grid.getStore();
                    if (store)
                        $this.resetPageSetting(store);
                    $this.loadTaskManagementGrid();
                    showSuccessMessage(message, msg);
                }
            }
        });
    },
    loadTaskManagementGrid: function() {
        var $this = this;
        var grid = $this.getTaskmanagementgrid();
        
        var form = $this.getTaskmanagementfilter();
        var userTypeId = form.down("#userTypeItemId").getValue();
        var ownerId = form.down("#ownerIdItemId").getValue();
        var fromDate = form.down("#fromDateItemId").getValue();
        var toDate = form.down("#toDateItemId").getValue();
        var store = grid.getStore();

		fromDate= new Date(fromDate);
		fromDate = Ext.Date.format(fromDate, 'Y-m-d');
		
		toDate= new Date(toDate);
		toDate = Ext.Date.format(toDate, 'Y-m-d');


        store.getProxy().extraParams = {
            moduleName: 'TaskManagement',
            userTypeId: userTypeId,
            minuteTakerId: ownerId,
            fromDate: fromDate,
            toDate: toDate
        };
        
        store.load();
        grid.getSelectionModel().deselectAll();
        /*pdf & excel report header filter*/
	    grid.config.searchFilterForm = form;
    },
    openEditTaskManagementTab: function(openView) {
        var $this = this;
        var grid = $this.getTaskmanagementgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            $this.openAddTaskManagementTab(openView);
            var submitUrl = SERVERURL.EMM_FIND_EVENT_MEETING_MINUTES_BY_ID;
            var record = grid.getSelectionModel().getSelection()[0];
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl + "?id=" + record.data.id,
                method: 'GET',
                success: function(response, action) {
                    Ext.getBody().unmask();
                    var data = Ext.decode(response.responseText);

                    var form = $this.getTaskmanagementform();
                    var idItemId = form.down('#idItemId');
                    var minuteTakerIdItemId = form.down('#minuteTakerIdItemId');
                    var minuteDateItemId = form.down('#minuteDateItemId');
                    var minuteSubjectItemId = form.down('#minuteSubjectItemId');

                    idItemId.setValue(data.id);
                    if (!isNullOrEmpty(data.minuteTaker) && !isNullOrEmpty(data.minuteTaker.id)) {
                        minuteTakerIdItemId.getStore().load({
                            callback: function(records, operation, success) {
                                minuteTakerIdItemId.setValue(data.minuteTaker.id);
                            }
                        });
                    }
                    minuteDateItemId.setValue(dateRender(data.minuteDate));
                    minuteSubjectItemId.setValue(data.minuteSubject);

                    /*if (!isNullOrEmpty(data.minuteTaker) && !isNullOrEmpty(data.minuteTaker.id)) {
                        minuteTakerIdItemId.getStore().load({
                            callback: function(records, operation, success) {
                                minuteTakerIdItemId.setValue(data.minuteTaker.id);
                            }
                        });
                    }*/
                    minuteDateItemId.setReadOnly(true);
                    minuteTakerIdItemId.setReadOnly(true);
                    minuteSubjectItemId.setReadOnly(true);
                    if (!isNullOrEmpty(data.eventMeetingMinutesTasks) && data.eventMeetingMinutesTasks.length > 0) {
                        var taskGrid = $this.getTaskmanagementtaskgrid();
                        var ObjModel = [];
                        var emmTaskModel = null;

                        var models = data.eventMeetingMinutesTasks;
                        for (var i = 0; i < models.length; i++) {
                            emmTaskModel = new Academia.model.eventmeetingminutes.EventMeetingMinutesTaskModel();

                            emmTaskModel.set("id", models[i].id);
                            emmTaskModel.set("serialNo", (i + 1));
                            if (openView == 'VIEW') {
                                emmTaskModel.set("isEditable", 'VIEW');
                                emmTaskModel.set("isAddDeleteRow", false);
                            } else {
                                emmTaskModel.set("isEditable", 'EDIT');
                                emmTaskModel.set("isAddDeleteRow", true);
                            }
                            if (!isNullOrEmpty(models[i].assignDate)) {
                                emmTaskModel.set("assignDate", models[i].assignDate);
                                emmTaskModel.set("assignDatePrefillValue", models[i].assignDate);
                            }
                            if (!isNullOrEmpty(models[i].description)) {
                                emmTaskModel.set("description", models[i].description);
                            }
                            if (!isNullOrEmpty(models[i].owner) && !isNullOrEmpty(models[i].owner.id)) {
                                emmTaskModel.set("ownerId", models[i].owner.id);
                            }
                            if (!isNullOrEmpty(models[i].status)) {
                                emmTaskModel.set("status", models[i].status);
                                emmTaskModel.set("statusPrefillValue", models[i].status);
                                /*if (openView == 'EDIT') {
                                    if ('COMPLETED' == models[i].status) {
                                        emmTaskModel.set("isEditable", 'VIEW');
                                        emmTaskModel.set("isAddDeleteRow", false);
                                    } else if ('PENDING' == models[i].status) {
                                        emmTaskModel.set("isEditable", 'EDIT');
                                    }
                                }*/
                            }
                            if (!isNullOrEmpty(models[i].dueDate)) {
                                emmTaskModel.set("dueDate", models[i].dueDate);
                                emmTaskModel.set("dueDatePrefillValue", models[i].dueDate);
                            }
                            if (!isNullOrEmpty(models[i].completionDate)) {
                                emmTaskModel.set("completionDate", models[i].completionDate);
                            }
                            if (!isNullOrEmpty(models[i].noOfDaysOverdue)) {
                                emmTaskModel.set("noOfDaysOverdue", models[i].noOfDaysOverdue);
                            }
                            if (!isNullOrEmpty(models[i].forwardedDate)) {
                                emmTaskModel.set("forwardedDate", models[i].forwardedDate);
                            }
                            if (!isNullOrEmpty(models[i].showViewLink)) {
                                emmTaskModel.set("showViewLink", models[i].showViewLink);
                            }
                            if (!isNullOrEmpty(models[i].remark)) {
                                emmTaskModel.set("remark", models[i].remark);
                            }
                            
                            ObjModel.push(emmTaskModel);
                        }
                        taskGrid.getStore().loadRawData(ObjModel, true);
                    }
                    var resetButton = form.down('#resetTaskmanagementformItemId');
                    resetButton.setVisible(false);

                    var showViewColumn = data.showViewColumn;

                    var gridColumns;
                    if (!isNullOrEmpty(taskGrid)) {
                        gridColumns = taskGrid.columns;
                    }
                    for (i in gridColumns) {
                        var gridColumn = gridColumns[i];
                        if (openView == 'VIEW') {
                            if (gridColumn.dataIndex == "addButton") {
                                gridColumn.hide();
                            } else if (gridColumn.dataIndex == "deleteButton") {
                                gridColumn.hide();
                            }
                        }
                        if (showViewColumn && gridColumn.dataIndex == "showViewLink") {
                            gridColumn.show();
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    openViewTaskManagementTab: function() {
        var $this = this;
        $this.openEditTaskManagementTab('VIEW');
        var form = $this.getTaskmanagementform();
        var eventmeetingminutesform = form.getForm();
        this.toggleReadOnlyFormItems(eventmeetingminutesform, true);
        form.down('#saveTaskmanagementformItemId').setVisible(false);
    },
    loadTMMyTasksGrid: function() {
        var $this = this;
        var form = $this.getTmmytasksfilter();
        var grid = $this.getTmmytasksgrid();

        var fromDate = form.down("#fromDateItemId").getValue();
        var toDate = form.down("#toDateItemId").getValue();
         if(fromDate != null){
            fromDate= new Date(fromDate);
            fromDate = Ext.Date.format(fromDate, 'Y-m-d');
         }

         if(toDate != null){
            toDate= new Date(toDate);
            toDate = Ext.Date.format(toDate, 'Y-m-d');
         }

        var taskStatus = form.down("#taskStatusItemId").getValue();

        var user = this.getCurrentlyLoggedInUser();
        var store = grid.getStore();
        store.getProxy().extraParams = {
            ownerId: user.id,
            fromDate: fromDate,
            toDate: toDate,
            taskStatus: taskStatus
        };
        store.load();
    },
    loadTMTaskReportsGrid: function() {
        var $this = this;
        var form = $this.getTmtaskreportsfilter();
        var grid = $this.getTmtaskreportsgrid();

        var userTypeId = form.down("#userTypeItemId").getValue();
        var ownerId = form.down("#ownerIdItemId").getValue();
        var dateType = form.down("#dateTypeItemId").getValue();
        var fromDate = form.down("#fromDateItemId").getValue();
        var toDate = form.down("#toDateItemId").getValue();
        var taskStatus = form.down("#taskStatusItemId").getValue();
        var user = this.getCurrentlyLoggedInUser();
        
        if(fromDate != null){
        	fromDate= new Date(fromDate);
        	fromDate = Ext.Date.format(fromDate, 'Y-m-d');
         }
        
        if(toDate != null){
        	toDate= new Date(toDate);
        	toDate = Ext.Date.format(toDate, 'Y-m-d');
        }
        
        var store = grid.getStore();
        store.getProxy().extraParams = {
            loggedInUserId: user.id,
            userTypeId: userTypeId,
            ownerId: ownerId,
            typeOfTask: dateType,
            fromDate: fromDate,
            toDate: toDate,
            taskStatus: taskStatus
        };
        store.load();
        /*pdf & excel report header filter*/
	      grid.config.searchFilterForm = form;
    },
    openGraphicalReportTab: function() {
        var $this = this;
        var contentpanel = this.getContentpanel();
        var tmgraphicalreportsfilter = Ext.widget('tmgraphicalreportsfilter');
        tmgraphicalreportsfilter.setTitle(getServiceRequestTranslation('TM_GRAPHICAL_REPORTS'));
        /**
         * This is to remove tab from content panel and open same tab again
         */
        var getcontroller = this.getController('menu.CoreERPNavigationController');
        var getTab = getcontroller.getTab(getServiceRequestTranslation('TM_GRAPHICAL_REPORTS'));
        if (getTab != null) {
            contentPanel.remove(getTab, true);
        }
        openTab(contentpanel, getServiceRequestTranslation('TM_GRAPHICAL_REPORTS'), tmgraphicalreportsfilter, CONSTANTS.MENU_COLOR_THREE);
    },
    getIdValueJson : function(id, value) {
		if (id)
			return {
			id : id,
			value : value
		};
	},
    loadGraphicalReports: function() {
        var $this = this;
        var form = this.getTmgraphicalreportsfilter();

        var fromDate = form.down("#fromDateItemId").getValue();
        var toDate = form.down("#toDateItemId").getValue();
        var chartGroup = form.down('#chartGroupItemId');
        var chartGroupValue = chartGroup.getValue();

        var tmGraphicalReportsPieChart = form.down('#tmGraphicalReportsPieChartItemId');
        var tmGraphicalReportsBarChart = form.down('#tmGraphicalReportsBarChartItemId');

        var pieChartExportButton = form.down('#pieChartExportButtonItemId');
        var barChartExportButton = form.down('#barChartExportButtonItemId');
        var chartText = form.down('#chartTextItemId');
        var chartTextBar = form.down('#chartTextBarItemId');
        chartText.setText('Task Report Date Range ' + dateRender(fromDate) + ' - ' + dateRender(toDate));
        chartTextBar.setText('Task Report Date Range ' + dateRender(fromDate) + ' - ' + dateRender(toDate));
        var user = this.getCurrentlyLoggedInUser();
        
        if(fromDate != null){
        	fromDate= new Date(fromDate);
        	fromDate = Ext.Date.format(fromDate, 'Y-m-d');
         }
        
        if(toDate != null){
        	toDate= new Date(toDate);
        	toDate = Ext.Date.format(toDate, 'Y-m-d');
         }

        if (chartGroupValue.chartName == 'pieChart') {
            var tmGraphicalReportsPieChartStore = tmGraphicalReportsPieChart.getStore();
            tmGraphicalReportsPieChartStore.getProxy().extraParams = {
                loggedInUserId: user.id,
                fromDate: fromDate,
                toDate: toDate
            };
            tmGraphicalReportsPieChartStore.load({
                callback: function(records, operation, success) {
                    var count = 0;
                    for (i in records) {
                        var obj = records[i];
                        if (obj.data.value == 0) {
                            ++count;
                        }
                    }
                    if (count == records.length) {
                        tmGraphicalReportsPieChart.setVisible(false);
                        pieChartExportButton.setVisible(false);
                        chartText.setVisible(false);
                        showWarningMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'),
                            getServiceRequestTranslation('TM_NO_DATA_AVAILABLE'));
                    } else {
                        tmGraphicalReportsPieChart.setVisible(true);
                        pieChartExportButton.setVisible(true);
                        chartText.setVisible(true);
                        $this.addExportToPngForDashboard(pieChartExportButton.menu, tmGraphicalReportsPieChart);
                    }
                    chartTextBar.setVisible(false);
                    tmGraphicalReportsBarChart.setVisible(false);
                    barChartExportButton.setVisible(false);
                }
            });
        } else if (chartGroupValue.chartName == 'barChart') {
            var tmGraphicalReportsBarChartStore = tmGraphicalReportsBarChart.getStore();
            tmGraphicalReportsBarChartStore.getProxy().extraParams = {
                loggedInUserId: user.id,
                fromDate: fromDate,
                toDate: toDate
            };
            tmGraphicalReportsBarChartStore.load({
                callback: function(records, operation, success) {
                    var count = 0;
                    for (i in records) {
                        var obj = records[i];
                        if (obj.data.value == 0) {
                            ++count;
                        }
                    }
                    if (count == records.length) {
                        tmGraphicalReportsBarChart.setVisible(false);
                        barChartExportButton.setVisible(false);
                        chartTextBar.setVisible(false);
                        showWarningMessage(getServiceRequestTranslation('TM_TASK_MANAGEMENT'),
                            getServiceRequestTranslation('TM_NO_DATA_AVAILABLE'));
                    } else {
                        tmGraphicalReportsBarChart.setVisible(true);
                        barChartExportButton.setVisible(true);
                        chartTextBar.setVisible(true);
                        $this.addExportToPngForDashboard(barChartExportButton.menu, tmGraphicalReportsBarChart);
                    }
                    chartText.setVisible(false);
                    tmGraphicalReportsPieChart.setVisible(false);
                    pieChartExportButton.setVisible(false);
                }
            });
        }
    },
});