/**
 * @author Bhanu PS
 */

Ext.define('Academia.model.examinationcenters.evaluation.coverageDetails.QuestionPaperGridModel', {
    extend: 'Ext.data.Model',
    fields: [
        'paperCode',
        'program',
        'batch',
        'period',
        'course',
        'evaluationPlan',
        'assignedUser',
        'evaluationSequenceDetail',
        'paperStatus',
        'dateOfAssignment',
        'dueDate',
        'submissionDate',
        'submittedBy',
        'assignmentStatus',
        'questionPaperUrl',
        'description',
        'wetherManualAssignment',
        'documents',
        'durationInMins',
        'academicTermId', {
            name: 'evaluationPlanName',
            convert: function (value, record) {
                if (record.data.evaluationPlan != undefined) {
                    return record.data.evaluationPlan.value;
                } else {
                    return '<span style=\'color:red\'>N/A</span>';
                }
            }
        }, {
            name: 'courseName',
            convert: function (value, record) {
                if (record.data.course != undefined) {
                    return record.data.course.value;
                }
            }
        }, {
            name: 'evaluationSequenceDetailName',
            convert: function (value, record) {
                if (record.data.evaluationSequenceDetail != undefined) {
                    return record.data.evaluationSequenceDetail.value;
                } else {
                    return '<span style=\'color:red\'>N/A</span>';
                }
            }
        }, {
            name: 'programName',
            convert: function (value, record) {
                if (record.data.program != undefined) {
                    return record.data.program.value;
                }
                return '';
            }
        }, {
            name: 'batchName',
            convert: function (value, record) {
                if (record.data.batch != undefined) {
                    return record.data.batch.value;
                }
                return '';
            }
        }, {
            name: 'periodName',
            convert: function (value, record) {
                if (record.data.period != undefined) {
                    return record.data.period.value;
                }
                return '';
            }
        }, {
            name: 'assignedUserName',
            convert: function (value, record) {
                var user = record.data.assignedUser;
                return user.value;
            }
        }, {
            name: 'submittedByName',
            convert: function (value, record) {
                if (record.data.submittedBy != undefined) {
                    return record.data.submittedBy.value;
                } else {
                    return '-';
                }
            }
        }, {
            name: 'questionPaperUrlNo',
            convert: function (value, record) {
                if (!isNullOrEmpty(record.data.documents)) {
                    return record.data.documents.length > 0 ? "<a href=\'#\'>" + record.data.documents.length + "</a>" : "0";
                } else {
                    return '-';
                }
            }
        }, {
            name: 'academicTerm',
            convert: function (value, record) {
                if (!isNullOrEmpty(value)) {
                    return value;
                } else {
                    return '';
                }
            }
        }
    ]
});