/**
 * @author Bhanu PS
 */

Ext.define('Academia.model.examinationcenters.evaluation.coverageDetails.RevalRuleGridModel', {
	extend : 'Ext.data.Model',
	fields : ['revaluationType',
	          'feePlanType',
	          'feePlanRule',
	          'noOfRevaluers',
	          'maxRevaluationToApply',
	          'ruleApplicable',
	          'mappedProgramCount',
	          'programName',
	          'batchName','courseName',
	          'periodName','feeAmount','feePlanId',
	          'whetherRevalFeeApplicable',{	
		      name : 'startDate',
		      dateFormat: 'Y-m-d',
		      convert : function (v, rec) {
	  			if(v){
	  				var startDate = new Date(v);
	  				var dateFormat = 'd-m-Y';
	  				return  Ext.Date.format(startDate,dateFormat);
	  			}
		      }
	          },{
		      name : 'endDate',
		      dateFormat: 'Y-m-d',
		      convert : function (v, rec) {
		  			if(v){
		  				var endDate = new Date(v);
		  				var dateFormat = 'd-m-Y';
		  				return  Ext.Date.format(endDate,dateFormat);
		  			}
			      }
	  },{
	      name : 'approvalEndDate',
	      dateFormat: 'Y-m-d',
	      convert : function (v, rec) {
	  			if(v){
	  				var approvalEndDate = new Date(v);
	  				var dateFormat = 'd-m-Y';
	  				return  Ext.Date.format(approvalEndDate,dateFormat);
	  			}
		      }
  }]	
});

