
Ext.define('Academia.model.student.report.StudentDeletedReportModel',{
	extend : 'Ext.data.Model',
	fields:[
		'id','lastUpdate','lastUpdatedBy','archivedStudentId','studentName','program','batch','period','emailId','contactNo','deletedByFirstName',
		'deletedByMiddleName','deletedByLastName','status',
		{
			name: 'deletedByFullName',
			type: 'string',
			convert: function( v, record ) {
    	    	
    	    	var deletedByFisrtName = '';
    	    	var deletedByMiddleName = '';
    	    	var deletedByLastName = '';
    	    	
    	    	if( !isNullOrEmpty(record.get( 'deletedByFirstName' )) ){
    	    		deletedByFisrtName = record.get( 'deletedByFirstName' );
    	    	}
    	    	if( !isNullOrEmpty(record.get( 'deletedByMiddleName' )) ){
    	    		deletedByMiddleName = record.get( 'deletedByMiddleName' );
    	    	}
    	    	if( !isNullOrEmpty(record.get( 'deletedByLastName' )) ){
    	    		deletedByLastName = record.get( 'deletedByLastName' );
    	    	}
    	    	var deletedBy = deletedByFisrtName + ' ' + deletedByMiddleName + ' ' + deletedByLastName;
    	    	return deletedBy.trim();
    	    }
		},{
			name: 'statusUpdated',
			type: 'string',
			convert: function( v, record ) {
				if(record.get( 'status' ) == true){
					return 'Active';
				}else{
					return 'Inactive';
				}
			}
		
		}
		]
});