Ext.define('Academia.store.documentmanagement.DocumentDataProviderStore', {
	extend : 'Ext.data.Store',
	fields: ['id', 'providerName', 'priority'],
	autoLoad : false,
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.DYNAMIC_DOCUMENT_DATA_PROVIDER
		},
		method : 'GET',
		reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records',
            successProperty: 'success'
        }
	},
	  listeners: {
	        load: {
	            element: 'el',
	            fn: function(store, records, successful, eOpts) {
	                for (var count = 0; count < records.length; count++) {
	                    var key = records[count].get('providerName');
	                    records[count].set('providerName', getDocumentTranslation(key));
	                }
	                store.commitChanges();
	            }
	        }, 
	     
	    }
});
