/**
 * @author Rohit Sharma
 */
Ext.define('Academia.store.exam.examConcessionStaffAllocation.RequestTypeStore', {
    extend: 'Ext.data.Store',
    fields: [
    	'id',
    	'value',
    	'secondValue',
    	'secondId',
    	{
    		name: 'display',
    		convert: function(val, rec) {
    			if(!isNullOrEmpty(rec.get('secondValue'))) {
    			return rec.get('value') + ' (' + rec.get('secondValue') + ')';
    			}
    			else {
    				return rec.get('value');
    			}
    		}
    	}
    ],
    autoLoad: false,
    proxy: {
        type: 'rest',
        api: {
            read: SERVERURL.PATH_GET_ALL_EXAM_CONCESSION_BY_CATEGORY
        },
        method: 'GET',
        reader: {
            type: 'json',
			idProperty: 'uuid'
        }
    }
});