/**
 * @author <a href="mailto:ankush.solanki@serosoft.in">Ankush Solanki</a>
 *
 */
Ext.define('Academia.store.examinationdegreeremark.DegreeAuditReportCreditStatusChartStore', {
	extend : 'Ext.data.Store',
	model : 'Academia.model.examinationdegreeremark.DegreeAuditReportModel',
	autoLoad : false,
	pageSize :5,
	proxy : {
		type: 'rest',
	    api:{
			read:SERVERURL.DEGREE_CLASSIFICATION_CREDIT_AUDIT_REPORT
		},
		reader: {
			type:'json',
			root:'rows',
			totalProperty:'records',
	        successProperty: 'success'
		}
	},
    listeners:{
    	load: function(store, records, successful, eOpts) {
        	for (var count = 0; count < records.length; count++) {
        		var key = getCommonTranslation(records[count].get("name"));
        		if (!isNullOrEmpty(key)) {
        			records[count].set('name', key);
        		}
        	}
        	store.commitChanges();
        }
    }
});
