/**
 * @author Nitin Gaikwad
 */
Ext.define('Academia.store.feeandpayment.reports.User', {
	extend : 'Ext.data.Store',
	model : 'Academia.model.feeandpayment.managebill.User',
	autoLoad : false,
	sorters: [{
	    sorterFn: function(o1, o2) {
	        var value1 = o1.get('nameToBePrinted');
	        var value2 = o2.get('nameToBePrinted');

	        if (!isNullOrEmpty(value1) && !isNullOrEmpty(value2)) {
	            if (value1.toLowerCase() === value2.toLowerCase()) {
	                return 0;
	            } else {
	                return value1.toLowerCase() > value2.toLowerCase() ? 1 : -1;
	            }
	        }
	        return 0;
	    }
	}],
	proxy : {
		type : 'rest',
		api:{
			read:SERVERURL.USER_SMART_SEARCH_MULTIPLE_ALS
		},
		reader: {
			type:'json'
		}
	}

});