Ext.define('Academia.store.messaging.CbMetaDataStore', {
     extend: 'Ext.data.Store',
     model: 'Academia.model.messaging.CBMetaDataModel',
     autoLoad: false,
     proxy: {
         type: 'rest',
         api: {        	   
             read: SERVERURL.FIND_CB_META_DATA      //URL -rest/cb/getSeacrhResultViewData
         },		
         reader: {
             type: 'json',
             root:'searchResultViewColumns'	 
         }
     },
     listeners: {
         load: {
             element: 'el',
             fn: function(store, records, successful, eOpts) {                 
                 for (var count = 0; count < records.length; count++) {
                     var record = records[count];
                     var resultKey=record.get('resultKey');
                     if(!isNullOrEmpty(resultKey) && record.raw.visibility!=false){
                    	 records[count].set('value', getMessagingModuleTranslation(resultKey));
                     }                     
                 }
                 store.commitChanges();
             }
         }
     }
 });