/**
 * @author priyanshi sharma
 * used to fetch all students of a academy location
 */
Ext.define('Academia.store.messaging.StudentsFilterByAcademyLocationIdStore',{
	extend : 'Ext.data.Store',
	model : 'Academia.model.common.IdValueCodeDataModel',
	sorters: [{
	    sorterFn: function(o1, o2) {
	        var value1 = o1.get('value');
	        var value2 = o2.get('value');

	        if (!isNullOrEmpty(value1) && !isNullOrEmpty(value2)) {
	            if (value1.toLowerCase() === value2.toLowerCase()) {
	                return 0;
	            } else {
	                return value1.toLowerCase() > value2.toLowerCase() ? 1 : -1;
	            }
	        }
	        return 0;
	    }
	}],
	autoLoad : false,
	proxy : {
		type: 'rest',
		api : {
			//read : SERVERURL.COMPLAINT_STUDENT_COMBO 
			read : SERVERURL.FEE_REPORT_STUDENTPBSINTAKEYEAR_DETAILS 
		},
		method: 'GET',
		reader: {
			type: 'json'
		} 
	},listeners:{
		beforeload: function(store){
			store.getProxy().extraParams.page = 1;
			store.getProxy().extraParams.start = 0;
			store.getProxy().extraParams.limit = 500;
		}
	}
});