Ext.define('Academia.store.messaging.TemplateDataProvider', {
     extend: 'Ext.data.Store',
     model: 'Academia.model.messaging.DataProviderModel',
     autoLoad: false,
     sorters: [{
         property: 'dataProviderName',
         direction: 'ASC'
     }],
     sortOnLoad: true,
     remoteSort: false,
     storeId : 'templateDataProviderStore',
     proxy: {
         type: 'rest',
         api: {        	   
             read: SERVERURL.FIND_ALL_TEMPLATE_DATA_PROVIDER      //URL -rest/templateDataProviderResource/findByMsgSubCategory?id=# 
         },
         reader: {
             type: 'json'
         }
     },
     listeners: {
         load: {
             element: 'el',
             fn: function(store, records, successful, eOpts) {                 
                 for (var count = 0; count < records.length; count++) {
                     var record = records[count];
                     var resultKey=record.get('dataProviderName');
                     if(!isNullOrEmpty(resultKey)){
                    	 records[count].set('dataProviderName', getMessagingModuleTranslation(resultKey));
                     }                     
                 }
                 store.commitChanges();
             }
         }
     }
 });