Ext.define('Academia.store.organization.LocationStructureStore',{
	extend : 'Ext.data.Store',
	model : 'Academia.model.organization.LocationStructure',
	autoDestroy: false,
    autoLoad: false,
    pageSize: 10,   
    remoteSort:true,   
    /*sorters: [{
        property: 'name',
        direction: 'ASC'
    }],*/
	proxy : {
		type : 'rest', 
		api : {
			read : SERVERURL.LOCATION_GRID_DATA   //url-rest/location/gridData
        },
        reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records'
        }
    },
    listeners: {
	    beforeload: function(store, operation, eOpts){	    	
	    	var map = new Ext.util.HashMap();
	    	map.add('name','locationName');	    		    	
	        if(store.sorters && store.sorters.getCount())
	        {  		        	
	            var sorter = store.sorters.getAt(0);	     
	             if(map.containsKey('name')){
	            	 sorter.property=map.get('name');
	             }    
	            store.getProxy().extraParams = {
	                'property'  : sorter.property,
	                'direction'   : sorter.direction
	            };
	        }
	    }
	}
});
