/**
 *  @author Raghavendra.Soni
 */
Ext.define('Academia.store.program.programDetails.programBatches.CatalogueContentGridStore', {
	extend : 'Ext.data.Store',
	fields : [
		'catalogueContentId',
		'catalogueContentValue',
		'content',
		'id',
		'programCode',
		'programId',
		'programName',
		'duration',
		'presentationLanguageId',
		'presentationLanguageName',
		'videoURL',
		'publishInCatalogue',
		'saqaId',
		'whetherHtml',
		{
			name: 'programCodeOrName',
			convert:function (v, rec) {
				return rec.get('programCode') + ' / ' + rec.get('programName');
			}
		},
		{
			name: 'fieldType',
			convert:function (v, rec) {
				return (rec.get('whetherHtml') == true) ? getCommonTranslation("HTML") : getCommonTranslation("TEXT");
			}
		},
		{
			name: 'gridContent',
			convert: function(v, rec) {
				if(rec.get('fieldType') == getCommonTranslation("HTML")){
					return rec.get('content').replaceAll("<","&lt;").replaceAll(">","&gt;");
				}
				else{
					return rec.get('content');
				}
			}
		}
	],
	autoLoad : false,
	pageSize: 5,
	proxy : {
		type : 'rest',
		api:{
			read:SERVERURL.PROGRAM_CATALOGUE_GRIDDATA 
		},
		reader: {
			type:'json',
			root:'rows',
			totalProperty: 'records'
		}
	}
});