/**
 * @Raghavendra.Soni
 */
Ext.define('Academia.store.program.programDetails.programBatches.programPeriod.PeriodActivityDatesStore',{
	extend : 'Ext.data.Store',
	fields:[
		'programPeriodConfig',
		'periodEventName', 
		{
			name: 'periodEventNameId',
			convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get('periodEventName')) ){
    	    		return record.get('periodEventName').id;
    	    	}
    	    	return '';
    	    }
		},
		'startDate', 
		'endDate',
		{
			name: 'adminStartDate',
			convert: function(v, record){
				if( !isNullOrEmpty(record.get('startDate')) ){
    	    		return new Date(record.get('startDate'));
    	    	}
    	    	return '';
			}
		},
		{
			name: 'adminEndDate',
			convert: function(v, record){
				if( !isNullOrEmpty(record.get('endDate')) ){
    	    		return new Date(record.get('endDate'));
    	    	}
    	    	return '';
			}
		}
	],
	autoLoad : false,
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.PATH_ACTIVITY_DETAIL_BY_PERIOD_ID
		},
		reader : {
			type : 'json',
			root:'rows',
			totalProperty: 'records'
		}
	}
});
