/**
 * @ Dharmendra Goyal
 */
Ext.define('Academia.store.program.programDetails.programBatches.programPeriod.ServiceRequestSetupDatesStore',{
	extend : 'Ext.data.Store',
	fields:[
		'requestType', 
		{
			name: 'requestTypeId',
			convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get('requestType')) ){
    	    		return record.get('requestType').id;
    	    	}
    	    	return '';
    	    }
		},
		'adminStartDate', 
		'adminEndDate',
		'studentStartDate',
		'studentEndDate',
		'programBatchPeriodConfig',
		'assignee',
		{
			name: 'assigneeId',
			convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get('assignee')) ){
    	    		return record.get('assignee').id;
    	    	}
    	    	return '';
    	    }
		},
		'approver',
		{
			name: 'approverId',
			convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get('approver')) ){
    	    		return record.get('approver').id;
    	    	}
    	    	return '';
    	    }
		},
		{
			name: 'aStartDate',
			convert: function(v, record){
				if( !isNullOrEmpty(record.get('adminStartDate')) ){
    	    		return new Date(record.get('adminStartDate'));
    	    	}
				else if( !isNullOrEmpty(v) && Ext.isDate(v)){
					record.set('adminStartDate', v.getTime());
					return v;
				}
    	    	return '';
			}
		},{
			name: 'aEndDate',
			convert: function(v, record){
				if( !isNullOrEmpty(record.get('adminEndDate')) ){
    	    		return new Date(record.get('adminEndDate'));
    	    	}
				else if( !isNullOrEmpty(v) && Ext.isDate(v)){
					record.set('adminEndDate', v.getTime());
					return v;
				}
    	    	return '';
			}
		},{
			name: 'sStartDate',
			convert: function(v, record){
				if( !isNullOrEmpty(record.get('studentStartDate')) ){
    	    		return new Date(record.get('studentStartDate'));
    	    	}
				else if( !isNullOrEmpty(v) && Ext.isDate(v)){
					record.set('studentStartDate', v.getTime());
					return v;
				}
    	    	return '';
			}
		},{
			name: 'sEndDate',
			convert: function(v, record){
				if( !isNullOrEmpty(record.get('studentEndDate')) ){
    	    		return new Date(record.get('studentEndDate'));
    	    	}
				else if( !isNullOrEmpty(v) && Ext.isDate(v)){
					record.set('studentEndDate', v.getTime());
					return v;
				}
    	    	return '';
			}
		}
	],
	autoLoad : false,
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.PATH_SERVICE_REQUEST_SETUP_DETAIL_BY_PERIOD_ID
		},
		reader : {
			type : 'json',
			root:'rows',
			totalProperty: 'records'
		}
	}
});
