/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.store.survey.AdHocSurveyReportGridStore',{
	extend:'Ext.data.Store',
	fields: [
	    // If you want to include the whole 'result' object (not necessary here unless needed for other logic)
	    {
	        name: 'result',
	        mapping: 'result[0]' // Mapping to the first element of the 'result' array
	    },
	    {
	        name: 'sid',
	        mapping: 'result[0].sid' // Accessing 'sid' from the first element of 'result' array
	    },
	    {
	        name: 'surveyls_title',
	        mapping: 'result[0].surveyls_title' // Mapping 'surveyls_title' from the first element of 'result' array
	    },
	    {
	        name: 'startdate',
	        mapping: 'result[0].startdate' // Mapping 'startdate' from the first element of 'result' array
	    },
	    {
	        name: 'expires',
	        mapping: 'result[0].expires' // Mapping 'expires' from the first element of 'result' array
	    },
	    {
	        name: 'active',
	        mapping: 'result[0].active' // Mapping 'active' from the first element of 'result' array
	    },
	    {
	        name: 'noOfQuestions',
	        mapping: 'result[0].noOfQuestions' // Mapping 'noOfQuestions' from the first element of 'result' array
	    },
	    {
	        name: 'isAnonymized',
	        mapping: 'result[0].isAnonymized' // Mapping 'isAnonymized' from the first element of 'result' array
	    },
	    {
	    	name: 'participationPercentage',
	        mapping: 'result[0].participationPercentage' // Mapping 'participationPercentage' from the first element of 'result' array
	    }
	],
	pageSize: CONSTANTS.DEFAULT_PAGESIZE,
	proxy: {
	    type: 'rest',
	    method: 'GET',
	    api: {
	        read: SERVERURL.PATH_GET_ADHOC_SURVEY_REPORT_GRID_DATA
	    },
	    reader: {
	        type: 'json',
	        root: 'rows',
	        totalProperty: 'records'
	    }
	}
});

