/**
 * 
 */

Ext.define('Academia.view.DMSView.DmsAllSitesGrid',{
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.dmsallsitesgrid',
	store:Ext.create('Academia.store.DMSStore.DMSSiteStore'),
	title: getDMSTranslation('ALL_SITES'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar : [{
		xtype : 'button',
		itemId : 'btnLeaveSite', //leaveSite
		tooltip : getDMSTranslation('LEAVE'),
		text: getDMSTranslation('LEAVE'),
		disabled: true
	},{
		xtype : 'button',
		itemId : 'btnRequestToJoinSite', //requestSite
		tooltip : getDMSTranslation('REQUEST_TO_JOIN'),
		text: getDMSTranslation('REQUEST_TO_JOIN'),
		disabled: true
	},{
		xtype : 'button',
		itemId : 'btnJoinSite', //joinSite
		tooltip : getDMSTranslation('JOIN'),
		text: getDMSTranslation('JOIN'),
		disabled: true
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns:[
		{
			header : getDMSTranslation('NAME'),
			dataIndex : 'title',
			flex:1
		},{
			header : getDMSTranslation('SHORT_NAME'),
			dataIndex : 'shortName',
			flex:1
		},{
			header : getDMSTranslation('DESCRIPTION'),
			dataIndex : 'description',
			flex:1
		},{
			header : getDMSTranslation('VISIBILITY'),
			dataIndex : 'visibility',
			flex:1,
			renderer : function(value){
				return getDMSTranslation(value);
			}
		}/*,{
			header : '',
			flex:1,
			renderer: function(value, meta, record) {
	            var id = Ext.id();
	            Ext.defer(function(){
	                new Ext.panel.Panel({
	                	items:[{
	                		xtype: 'button',
	                		text: getDMSTranslation('LEAVE'),
	                		itemId:'leaveSite',
	                		buttonAlign: 'center',
	                		ui: 'CustomBtnSubmit',
	                		scale: CONSTANTS.BUTTONSIZE
	                	},{
	                		xtype: 'button',
	                		text: getDMSTranslation('REQUEST_TO_JOIN'),
	                		buttonAlign: 'center',
	                		itemId:'requestSite',
	                		ui: 'CustomBtnSubmit',
	                		scale: CONSTANTS.BUTTONSIZE
	                	},{
	                		xtype: 'button',
	                		text: getDMSTranslation('JOIN'),
	                		buttonAlign: 'center',
	                		itemId:'joinSite',
	                		ui: 'CustomBtnSubmit',
	                		scale: CONSTANTS.BUTTONSIZE
	                	}]
	                }).render(document.body, id);
	            },50);
	            return Ext.String.format('<div id="{0}"></div>', id);
	        }
        }*/
	]
});
