/**
 * 
 */

Ext.define('Academia.view.DMSView.DmsSiteGrid',{
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.dmssitegrid',
	store:'DMSStore.DMSSiteStore',
	title: getDMSTranslation('SITE_LIST'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar : [{
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getDMSTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getDMSTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled: true
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		disabled: true
	}/*,
	{
		xtype: 'splitbutton',
		text: getDMSTranslation('MOREACTIONS'),
		itemId: 'btnMoreOperations',
		disabled:true,
		tooltip: getDMSTranslation('MOREACTIONS'),
		menu: new Ext.menu.Menu({
			items: [{
				text: getDMSTranslation('ADD_USER'), //Assign Application ID
				itemId: 'addUserBtn'
			}]
		})
	}*/],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns:[
		{
			header : getDMSTranslation('NAME'),
			dataIndex : 'title',
			flex:1
		},{
			header : getDMSTranslation('SHORT_NAME'),
			dataIndex : 'shortName',
			flex:1
		},{
			header : getDMSTranslation('DESCRIPTION'),
			dataIndex : 'description',
			flex:1
		},{
			header : getDMSTranslation('VISIBILITY'),
			dataIndex : 'visibility',
			flex:1,
			renderer : function(value){
				return getDMSTranslation(value);
			}
		}
	]
});
