Ext.define('Academia.view.DMSView.EditMyWorkflowPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.editmyworkflowpanel',
    margin: 0,
    autoScroll: true,
    frame: true,
    border: true,
    height: 580,
    items:[{
    	xtype: 'form',
    	itemId: 'editMyWorflowInnerPanelItemId',
    	cls: 'workflowInnerPanelCls',
    	defaults: {
			labelAlign: 'top',
    		width: 800
		},
    	items:[{
    		xtype: 'hiddenfield',
    		name: 'activityId',
    		itemId: 'activityIdItemId'
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('WORKFLOW_SUMMARY'),
    		defaults: {
    			labelAlign: 'left',
    			labelWidth: 80
    		},
        	layout: 'column',
    		items:[{
        		xtype: 'dataview',
        		itemId: 'myWorkflowSummaryDVItemId',
        		autoScroll: true,
    			columnWidth: 1,
        		store: Ext.create('Ext.data.ArrayStore',{
            		id: 0,
            		fields: [
            			'isInProgress',
            			'dueDate',
            			'priority',
            			'completedOn',
            			'completedBy',
            			'outcome',
            			'commenter',
            			'comment'
            		],
        			data: []
            	}),
            	itemSelector: 'div.thumb-wrap-workflow-summary',
        		tpl: new Ext.XTemplate(
				   '<tpl for=".">',
					    '<div class="thumb-wrap-workflow-summary">',
							'<div class="workflow-summary-icons">',
						   		'<h3>General</h3>',
						   		'<div class="workflow-summary-status">{isInProgress}</div>',
						   		'<div class="workflow-summary-due">{dueDate}</div>',
						   		'<div class="workflow-summary-priority workflow-summary-priority-medium">{priority}</div>',
						   	'</div>',
						   	'<div class="workflow-summary-recent-task">',
						   		'<h3>Most Recently Completed Task</h3>',
							   	'<div class="workflow-summary-recent-task-detail">',
							   		'<span class="viewmode-label">Completed on:</span><span class="viewmode-value">{completedOn}</span>',
							   		'<span class="viewmode-label">Completed by:</span><span class="viewmode-value">{completedBy}</span>',
							   		'<span class="viewmode-label">Outcome:</span><span class="viewmode-value">{outcome}</span>',
							   	'</div>',
							   	'<div class="workflow-summary-user-info">',
							   		'<div class="workflow-summary-user-avatar">',
							   			'<img src="resources/images/dms_user.png" alt="Avatar">',
							   		'</div>',
							   		'<div class="workflow-summary-user-comment">',
							   			'<div>{commenter}\'s comment:</div>',
							   			'<div class="workflow-summary-user-comment-bordered">{comment}</div>',
							   		'</div>',
							   	'</div>',
						   	'</div>',
						'</div>',
					'</tpl>'
    		    ),
    		    emptyText: '<div style="float: left; width: 100%;text-align: center;padding: 5px;">'+getDMSTranslation('NO_ITEMS_TO_SHOW')+'</div>'
        	}]
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('GENERAL_INFO'),
    		defaults: {
    			labelAlign: 'left',
    			labelWidth: 80
    		},
        	layout: 'column',
    		items:[{
    			xtype: 'displayfield',
    			fieldLabel: 'Title',
    			itemId: 'titleItemId',
    			columnWidth: 1
    		},{
    			xtype: 'displayfield',
    			fieldLabel: 'Description',
    			itemId: 'descriptionItemId',
    			columnWidth: 1
    		},{
    			xtype: 'displayfield',
    			fieldLabel: 'Started by',
    			itemId: 'startedByItemId',
    			columnWidth: 0.33
    		},{
    			xtype: 'displayfield',
    			fieldLabel: 'Due',
    			itemId: 'dueItemId',
    			columnWidth: 0.33
    		},{
    			xtype: 'displayfield',
    			fieldLabel: 'Completed',
    			itemId: 'completedItemId',
    			columnWidth: 0.33
    		},{
    			xtype: 'displayfield',
    			fieldLabel: 'Started',
    			itemId: 'startedItemId',
    			columnWidth: 0.33
    		},{
    			xtype: 'displayfield',
    			fieldLabel: 'Priority',
    			itemId: 'priorityItemId',
    			columnWidth: 0.33
    		},{
    			xtype: 'displayfield',
    			fieldLabel: 'Status',
    			itemId: 'statusItemId',
    			columnWidth: 0.33
    		},{
    			xtype: 'displayfield',
    			fieldLabel: 'Message',
    			itemId: 'messageItemId',
    			columnWidth: 1
    		}]
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('MORE_INFO'),
    		defaults: {
    			labelAlign: 'left',
    			labelWidth: 200
    		},
        	layout: 'column',
    		items:[
    			{
        			xtype: 'displayfield',
        			fieldLabel: 'Required Approval Percentage',
        			itemId: 'requiredPercentageItemId',
        			columnWidth: 1
        		},{
        			xtype: 'displayfield',
        			fieldLabel: 'Send Email Notifications',
        			itemId: 'sendEmailNotificationItemId',
        			columnWidth: 1
        		}
    		]
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('ITEMS'),
    		frame: true,
    		border: true,
    		defaults: {
    			labelAlign: 'top',
    			labelWidth: 80
    		},
        	layout: 'column',
    		items:[{
        		xtype: 'dataview',
        		itemId: 'editMyWorkflowDocumentItemId',
        		autoScroll: true,
    			columnWidth: 1,
        		store: Ext.create('Ext.data.ArrayStore',{
            		id: 0,
            		fields: ['type','img','fileName','action','time','displayTime','userName','version','size','displayVersion','folderPath','nodeRef', 'isLocked', 'lockedByUsername', 'lockedByDisplayName', 'role', 'activeWorkflows'],
        			data: []
            	}),
            	itemSelector: 'div.thumb-wrap-document-workflow',
        		tpl: new Ext.XTemplate(
    		    	   '<tpl for=".">',
    			            '<div class="thumb-wrap-document-workflow" >',
    			            	'<img src="{img}" />',
    			            	'<div class="listItem">',
    				            	'<span style="color: #333;cursor: pointer;font-size: 14px;display: inline-block;float: left;width: 80%;" class="fileNameSpan">{fileName}</span>',
    				            	'<span style="float:left;" title="{displayTime}">{action} {time} ago by {userName}</span>',
    			            	'</div>',
    			            '</div>',
    			        '</tpl>'
    		    ),
    		    emptyText: '<div style="float: left; width: 100%;text-align: center;padding: 5px;">'+getDMSTranslation('NO_ITEMS_TO_SHOW')+'</div>'
        	}]
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('CURRENT_TASKS'),
    		frame: true,
    		border: true,
    		defaults: {
    			labelAlign: 'top',
    			labelWidth: 80
    		},
        	layout: 'column',
    		items:[{
    			xtype: 'grid',
    			border:true,
    			columnWidth: 1,
    			itemId: 'myWorkflowCurrentTaskGridItemId',
    			store: Ext.create('Ext.data.ArrayStore',{
            		id: 0,
            		fields: ['id','type','assignedTo','dueDate','status'],
        			data: []//[[1,'Review','Addhyan Kapoor','Thu 16 Jan 2020','Not Yet Started']]
            	}),
    			columns: [{
    				dataIndex: 'type',
    				header: 'Type',
    				flex:1
    			},{
    				dataIndex: 'assignedTo',
    				header: 'Assigned To',
    				flex:1
    			},{
    				dataIndex: 'dueDate',
    				header: 'Due Date',
    				flex:1
    			},{
    				dataIndex: 'status',
    				header: 'Status',
    				flex:1
    			},{
    				header: 'Actions',
    				flex:1
    			}]
    		}]
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('HISTORY'),
    		border: true,
			frame: true,
    		defaults: {
    			labelAlign: 'top',
    			labelWidth: 80
    		},
        	layout: 'column',
    		items:[{
    			xtype: 'grid',
    			border:true,
    			columnWidth: 1,
    			itemId: 'myWorkflowHistoryGridItemId',
    			store: Ext.create('Ext.data.ArrayStore',{
            		id: 0,
            		fields: ['id','type','completedBy','dateCompleted','outcome','comment'],
        			data: []
            	}),
    			columns: [{
    				dataIndex: 'type',
    				header: 'Type',
    				flex:2
    			},{
    				dataIndex: 'completedBy',
    				header: 'Completed By',
    				flex:1
    			},{
    				dataIndex: 'dateCompleted',
    				header: 'Date Completed',
    				flex:1
    			},{
    				dataIndex: 'outcome',
    				header: 'Outcome',
    				flex:1
    			},{
    				header: 'comment',
    				header: 'Comment',
    				flex:1
    			}]
    		}]
    	},{
    		xtype: 'fieldset',
    		frame: true,
    		border: true,
    		defaults: {
    			labelAlign: 'top'
    		},
        	layout: 'hbox',
    		items:[{
    			xtype: 'button',
    			text: getDMSTranslation('CANCEL'),
    			itemId: 'cancelMyEditWorkflowBtnItemId',
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
    	}]
    }]
});