/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.admissionActivityReport.AdmissionActivityReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.admissionactivityreportgrid',
	store: 'admission.admissionActivityReport.AdmissionActivityReportListStore',
	title: getAdmissionTranslation('USER_WISE_ACTIVITY_REPORT'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'admission.admissionActivityReport.AdmissionActivityReportListStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : .2
	},{
		header : getFeeAndPaymentCommonTranslation('USER_NAME'),
		dataIndex : 'userName',
		flex : .2
	},{
		header : getAdmissionTranslation('NO_OF_LEADS'),
		dataIndex : 'noOfEnquiry',
		flex : .2,
		renderer : function(value){
			if(value > 0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getAdmissionTranslation('APPOINTMENTS_SCHEDULED'),
		dataIndex : 'noOfAppointmentScheduled',
		flex : .2
	},
	{
		header :getAdmissionTranslation('INTERVIEWS_TAKEN'),
		dataIndex : 'noOfInterviews',
		flex : .2
	},
	{
		header :getCommonTranslation('NO_OF_APPLICATIONS'),
		dataIndex : 'noOfApplication',
		flex : .2
	},
	{
		header :getAdmissionTranslation('NO_OF_ADMISSIONS'),
		dataIndex : 'noOfAdmission',
		flex : .2
	}]
});	
