/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.admissionActivityReport.SaleAdmissionEnrolProgramFullSummaryAdmGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.saleadmissionenrolprogramfullsummaryadmgrid',
    store: 'admission.admissionActivityReport.AdmissionEnrolProgramFullSummaryAdmGridStore',
    title: getAdmissionTranslation('SALES_ADMISSION_FULL_SUMMARY_BY_PROGRAM'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        getRowClass: function (record, rowIndex, rowParams, store) {
            return (record.get('total') == 'total') ? 'gridAdmActivityReportEnrol' : '';
        },
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex: 1.5,
        sortable: false
    },{
        header: getCommonTranslation('INTAKE_YEAR'),
        dataIndex: 'intakeYear',
        flex: 1,
        sortable: false
    },{
        header: getCommonTranslation('PROGRAM_GROUP'),
        dataIndex: 'programGroupName',
        flex: 1,
        sortable: false
    },{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: 1,
        sortable: false
    },{
        header: getAdmissionTranslation('TOTAL_ENQUIRY'),
        dataIndex: 'noOfEnquiry',
        flex: 1,
        sortable: false
    }, {
        header: getEnquiryTranslation('OPEN_ENQUIRY'),
        dataIndex: 'noOfOpenEnquiry',
        flex: 1,
        sortable: false
    }, {
        header: getEnquiryTranslation('ENQUIRY_CLOSED_SUCCESSFULLY'),
        dataIndex: 'noOfClosedEnquirySuccess',
        flex: 1,
        sortable: false
    }, {
        header: getEnquiryTranslation('ENQUIRY_CLOSED_UNSUCCESSFULLY'),
        dataIndex: 'noOfClosedEnquiryUnSuccess',
        flex: 1,
        sortable: false
    }, {
        header: getAdmissionTranslation('TOTAL_APPLICATIONS'),
        dataIndex: 'noOfApplication',
        flex: 1,
        sortable: false
    }, {
        header: getAdmissionTranslation('APPLICATIONS_PENDING'),
        dataIndex: 'noOfPendingApplication',
        flex: 1,
        sortable: false
    }, {
        header: getAdmissionTranslation('APPLICATIONS_APPROVED'),
        dataIndex: 'noOfApprovedApplication',
        flex: 1,
        sortable: false
    },{
        header: getAdmissionTranslation('APPLICATION_WITHDRAWN'),
        dataIndex: 'noOfRejectedApplication',
        flex: 1,
        sortable: false
    },{
        header: getAdmissionTranslation('ADMISSION_APPROVED'),
        dataIndex: 'noOfApprovedAdmission',
        flex: 1,
        sortable: false
    },{
        header: getAdmissionTranslation('ADMISSION_WITHDRAWN'),
        dataIndex: 'noOfRejectedAdmission',
        flex: 1,
        sortable: false
    }]
});
