/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show collection details in form  
 */
Ext.define('Academia.view.admission.admissionCommon.MakePaymentForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.makepaymentform',
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'hidden',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'applicationId',
            itemId: 'applicationId'
        }, {
            xtype: 'textfield',
            name: 'paidBy',
            fieldLabel: getAdmissionTranslation('PAID_BY'), //Paid By
             //Paid By
            allowBlank: false
        }, {
            xtype: 'numberfield',
            name: 'instrumentAmount',
            itemId: 'instrumentAmount',
            fieldLabel: getAdmissionTranslation('INSTRUMENT_AMOUNT'), //Instrument Amount
             //Instrument Amount
            allowBlank: false,
            readOnly: true,
            minValue: 0
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'paymentMode',
            itemId: 'cmbRef',
            store: 'admission.admissionCommon.PaymentModeStore',
            valueField: 'name',
            displayField: 'value',
            editable: false,
            fieldLabel: getAdmissionTranslation('PAYMENT_MODE'), // Payment Mode
             // Payment Mode             
            queryMode: 'local',
            triggerAction: 'all',
            forceSelection: true,
            allowBlank: false
        }, {
            xtype: 'textfield',
            name: 'instrumentDrawnOn',
            itemId: 'instrumentDrawnOn',
            fieldLabel: getAdmissionTranslation('INSTRUMENT_DRWAN_ON'), //Instrument Drawn On
             //Instrument Drawn On
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'numberfield',
            name: 'instrumentNo',
            itemId: 'instrumentNo',
            maxLength: 40,
            fieldLabel: getAdmissionTranslation('INSTRUMENT_NO'), //Instrument No.	                    
             //Instrument No.
            allowBlank: false,
            minValue: 0
        }, {
            xtype: 'datefield',
            name: 'instrumentDate',
            itemId: 'instrumentDate',
            fieldLabel: getAdmissionTranslation('INSTRUMENT_DATE'), //Instrument Date
            editable: false,
             //Instrument Date
          //--submitFormat: CONSTANTS.DATE_FORMAT,
//            format: CONSTANTS.DATE_FORMAT,
            allowBlank: false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        }]
    }, {
        xtype: 'textareafield',
        name: 'remark',
        fieldLabel: getAdmissionTranslation('PAYMENT_REMARKS'), //Payment Remarks        
        labelAlign: 'top',
        width: 475,
        height: 100,
        maxLength: 250
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'),
            itemId: 'btnSaveMakePaymentForm',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            itemId: 'btnCancelMakePaymentForm',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});
