/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of application programs in grid.  
 */
Ext.define('Academia.view.admission.applications.applicantProfileBase.ApplicationProgramGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.applicationprogramgrid',
    store: 'admission.applications.applicantProfileBase.ApplicationProgramGridStore',
    title: getAdmissionTranslation('LIST_APPLICATION_PROGRAMS'), //List of Application Programs	    
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },    
    selType: 'checkboxmodel',
    columns: [{
        header: getAdmissionTranslation('PREF_SEQ'), //Pref. Seq.
        dataIndex: 'prefSeq',
        hidden:true,
        flex: .2
    }, {
        header: getAdmissionTranslation('ACADEMY'), //Academy
        dataIndex: 'academyName',
        flex: .2,
        sortable: true
    }, {
        header: getAdmissionTranslation('LOCATION'), //Location
        dataIndex: 'locationName',
        flex: .2,
        sortable: true
    }, {
        header: getAdmissionTranslation('PROGRAM'), //Program
        dataIndex: 'programName',
        flex: .2,
        sortable: true
    }, {
        header: getAdmissionTranslation('BATCH'), //Batch
        dataIndex: 'batchName',
        flex: .2,
        sortable: true
    }, {
        header: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
        dataIndex: 'seatTypeValue',
        flex: .2,
        sortable: true
    }, {
        header: getAdmissionTranslation('PROGRAM_STATUS'), //Program Status
        dataIndex: 'currentStatus',
        flex: .2,
        renderer: function(val, rec,e){
        	if(!isNullOrEmpty(val)){
        		return getAdmissionTranslation(val);
        	} else {
        		return '';
        	}
        }
    }],    
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            store: 'admission.applications.applicantProfileBase.ApplicationProgramGridStore'
        }]
    }]
});