/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show selection snapshot in grid.  
 */
//var selectionSnapshotStore=Ext.create('Academia.store.admission.applicationFormSale.ApplicantSelectionSnapshotStore');
Ext.define('Academia.view.admission.applications.applicantProfileBase.SelectionSnapshotGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.selectionsnapshotgrid',    
    title: getAdmissionTranslation('SELECTION_SNAPSHOT'), //Selection Snapshot
    plugins: [{
        ptype: 'rowexpander',
        pluginId: 'SelectionSnapshotRowExpander',
        rowBodyTpl: [ '<tpl for="."><tpl if="!Ext.isEmpty(programStageDetails)">',
		               	'<table style="border:1px solid black; width:80%;">',

		               	'<col style="width:40%">',
		                '<col style="width:40%">',
		                '<thead>',
		                '<tr>',
		                        '<th style="width:50px;border-bottom:1px solid black;background-color: #f2f2f2;text-align:left">'+getAdmissionTranslation('STAGE')+'</th>',
		                        '<th style="width:50px;border-bottom:1px solid black;background-color: #f2f2f2;text-align:left">'+getCommonTranslation('STATUS')+'</th>',
		                '</tr>',
		                '</thead>',
		               		'<tpl for="programStageDetails">',
		               			'<tr>',
		               				'<td style="width:50px;text-align:left">{stageName}</td>',
		               				'<td style="width:50px;text-align:left">{stageStatus}</td>',
		               			'</tr>',
		               		'</tpl>',
		               	'</table></tpl>',
		               '</tpl>' ],/*new Ext.XTemplate('<td colspan="4"><table style="border:1px solid black;">', 
        		'<tr>',
        			'<th class="row-expander-table-th">' + getAdmissionTranslation('STAGE') + '</th>',
        			'<th class="row-expander-table-th">' + getCommonTranslation('STATUS') + '</th>',
        			'<th class="row-expander-table-th">' + getAdmissionTranslation('STATUS_REASON') + '</th>',
        			'<th class="row-expander-table-th">' + getCommonTranslation('REMARKS') + '</th>',        			
        		'</tr>',
        		'<tpl for=".">',
        		'<tr>',
        			'<td class="row-expander-table-td">{stage}</td>',
        			'<td class="row-expander-table-td">{status}</td>', 
        			'<td class="row-expander-table-td">{statusReason}</td>', 
        			'<td class="row-expander-table-td">{remarks}</td>',         			
        		'</tr>', 
        		'</tpl>', 
        '</table></td>')*/
    }],
    height:600,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },    
    isGridConfigurable: true,
    enableColumnHide: false,
    cls : 'horizontalScrollFixedApplicant',
    initComponent: function() {    	     
     	var grid=this;
     	var store = grid.buildStore();
     	Ext.apply(this, {
             store: store        
         });
         this.callParent(arguments);
         /*var custompagingtoolbar=grid.down('custompagingtoolbar');
         if(custompagingtoolbar){
         	custompagingtoolbar.bindStore(store);        	
         }*/
     },
    columns: [/*{
        header: getAdmissionTranslation('PREF_SEQ'), //Pref. Seq.
        dataIndex: 'priority',
        sortable: false,
        flex: .2
    },*/ {
        header: getCommonTranslation('APPLICATION_ID'), //Academy
        dataIndex: 'applicationCode',
        sortable: false,
        flex:.3,
        renderer : function(val){
        	if (!isNullOrEmpty(val) && val.length > 0) {
        		return '<a href="#">'+val+'</a>';
        	}
		}
    },{
        header: getCommonTranslation('ACADEMY'), //Academy
        dataIndex: 'academy.value',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('LOCATION'), //Location
        dataIndex: 'location.value',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('PROGRAM'), //Program
        dataIndex: 'program.value',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('BATCH'), //Batch
        dataIndex: 'batch.value',
        sortable: false,
        flex: .2
    },{
        header: getCommonTranslation('IDENTITY_TYPE'), //Identity Type
        dataIndex: 'idtype',
        sortable: false,
        flex: .2
    },{
        header: getCommonTranslation('IDENTITY_NUMBER'), //Identity No
        dataIndex: 'nationalID',
        sortable: false,
        flex: .2
    },{
        header: getCommonTranslation('SEAT_TYPE'), //Seat Type
        dataIndex: 'seatType.value',
        sortable: false,
        flex: .2
    },{
        header: getCommonTranslation('MODE_OF_DELIVERY'),
        dataIndex: 'modeOfDelivery.value',
        sortable: false,
        flex: .2,
		hidden: true
    }, {
        header: getCommonTranslation('REGISTRATION_TYPE'),
        dataIndex: 'batchPartTime',
        sortable: false,
        flex: .3,
		hidden: true,
		renderer : function(value) {
        	if(!isNullOrEmpty(value)) {
        		if(value==false) {
        			return 'Full Time';
        		}
        		else {
        			return 'Part Time';
        		}
        	}
        }
    }, {
        header: getCommonTranslation('SELECTION_PROCESS'), //Seat Type
        dataIndex: 'selectionProcess.value',
        //sortable: false,
        flex: .3,
		hidden: true
    },  {
        header: getCommonTranslation('OFFER_STATUS'), //Program Status
        dataIndex: 'currentStatus',
        sortable: false,
        flex: .3,
        renderer: function(obj) {
			return getAdmissionTranslation(obj);
		}
    }, {
	        header: getCommonTranslation('PROVISIONAL_OFFER'),
		        dataIndex: 'provisionalOfferLetterIssuedFileName',
		        flex: .3,
		        renderer:function(value,rec){
					if(value!="" && value!=undefined && value != null){
						return '<a href="#">'+value+'</a>';
					}else{
						return "";
					}
				},
				hidden: true
    }, {
        header: getCommonTranslation('OFFER_LETTER'), //Seat Type
        dataIndex: 'offerLetterIssuedFileName',
        //sortable: false,
        flex: .3,
		hidden: true,
		renderer:function(value,rec){
			//var id=rec.record.data.id;
			if(value!="" && value!=undefined && value != null){
				return '<a href="#">'+value+'</a>';
			}else{
				return "NA";
			}
		}
    }, {
	        header: getCommonTranslation('DAYS_TO_EXPIRE'),
		        dataIndex: 'offerLetterExpiryDate',
		        flex: .2,
		        renderer:function(value,rec){
		        	try {
		        	if(!isNullOrEmpty(rec.record.raw.offerLetterExpiryDate) && (rec.record.raw.currentStatus=="OFFER_LETTER_ISSUED" || rec.record.raw.currentStatus=="PROVISIONAL_LETTER_ISSUED")) {
			        		var days;
			        		var ONE_DAY = 1000 * 60 * 60 * 24;
			        	   var fromdate_ms = new Date(rec.record.raw.offerLetterExpiryDate);
			        	   var todate_ms = new Date();
			        	   fromdate_ms.setHours(00,00,0,0);
			        	   todate_ms.setHours(00,00,0,0);
			        	   fromdate_ms = Ext.Date.add(fromdate_ms,Ext.Date.DAY,1);
			        	   if(todate_ms>=fromdate_ms) {
			        		   return 0;
			        	   }
			        	   else {
			        	   var difference_ms = Math.abs(fromdate_ms - todate_ms);
			        	   if(todate_ms != null && fromdate_ms != null){
			        		   days = Math.round(difference_ms/ONE_DAY);
			        		   return days;
			        	   }
			        	   return "";
			        	   }
		        	}
		        	else {
		        		return "";
		        	}
		        	}
		        	catch(ex) {
		        		return "";
		        	}
				},
				hidden: false
		    }],    
    /*dockedItems: [{
        xtype: 'toolbar',
        hidden:true,
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')
        }]
    }],*/
    tbar: [{
        xtype: 'fieldcontainer',
        itemId: 'acceptOfferFieldContainerItemId',
        layout: 'hbox',
        cls: 'windowBtnPos',
        defaults: {
            labelAlign: 'top',
        },
        items: [{
            xtype: 'button',
            itemId: 'btnAcceptOfferItemId',
            tooltip: getAdmissionTranslation('APOL_ACCEPT_OFFER'),
            text: getAdmissionTranslation('APOL_ACCEPT_OFFER'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            hidden: true,
            disabled: true,
            style: {
                marginRight: '10px'
            }
        }, {
            xtype: 'button',
            itemId: 'btnDeclineOfferItemId',
            tooltip: getAdmissionTranslation('APOL_DECLINE_OFFER'),
            text: getAdmissionTranslation('APOL_DECLINE_OFFER'),
            ui: 'CustomBtnThird',
            scale: CONSTANTS.BUTTONSIZE,
            hidden: true,
            disabled: true,
            style: {
                marginRight: '10px',
                background: 'red !important',
                borderColor: 'red !important'
            },
        }]
    }],
    buildStore: function() {
        return Ext.create('Academia.store.admission.applicationFormSale.ApplicantSelectionSnapshotStore');
    }
});
