/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.applications.applicationBase.AdmissionApprovalDetailsAdmWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.admissionapprovaldetailsadmwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '40%',
	//height: 'auto',
	width: '80%',
	frame: true,
	title:getCommonTranslation('ADMISSION_APPROVAL_DETAILS'),
	items : [{
			xtype: 'grid',
			store : Ext.create('Academia.store.admission.applications.applicationBase.StoAdmAdmissionApprovalDetailsStore'),
			autoScroll: true,
			itemId : 'admissionApprovalDetailsGrid',
			border: true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			features: [{
				ftype: 'summary',
				showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
			}],
			columns: [{
				header : getCommonTranslation('OFFER_TYPE'),
				dataIndex : 'offerLetterType',
				flex : 0.2,
				renderer: function(val, rec,e){
			        if(!isNullOrEmpty(val)){
			        return  getAdmissionTranslation(val)+" Offer";
			        } else {
			        return "NA";
			        }
			       }
			},{
				header : getCommonTranslation('ADMISSTION_TYPE'),
				dataIndex : 'admissionType',
				flex : 0.2,
				renderer: function(value) {
					return getAdmissionTranslation(value);
				} 
			},{
				header : getCommonTranslation('ADMISSION_STATUS'),
				dataIndex : 'admissionStatus',
				flex : 0.2,
				renderer: function(value) {
					return getAdmissionTranslation(value);
				} 
			},{
				header : getCommonTranslation('ADMISSION_APPROVAL_DECLINED_DATE'),
				dataIndex : 'admissionApproveDeclinedWithdrawnDate',
				flex : 0.2,
				renderer: function(date) {
					return dateRender(date);
				}
			},{
				header : getCommonTranslation('ADMISSION_APPROVAL_DECLINED_BY'),
				dataIndex : 'admissionApproveDeclinedWithdrawnByName',
				flex : 0.2,
				renderer: function(value) {
					return getAdmissionTranslation(value);
				} 
			}] 	

		}] 
});
