/**
 * @author Amit G
 * This is used to show CONDITIONS_FOR_ADMISSIONS Application and Admission
 */
Ext.define('Academia.view.admission.applications.applicationBase.ApplicationConditionsForAdmission', {
	 extend: 'Ext.form.Panel',
    alias: 'widget.applicationconditionsforadmission',
    plugins: "formlabelrequired",  
    title: getAdmissionTranslation('CONDITIONS_FOR_ADMISSION'),
    autoScroll: false,
    cls:'panelNoSpace', 
    items: [{
    	xtype: 'form',
    	itemId: 'applicationconditionsforadmissionFormId',
    	standardSubmit: false,
    	items:[{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign:'top'
    		},
    		items: [{
    			xtype: 'hidden',
    			name: 'id',
    			itemId: 'Id'
    		},{
    			xtype: 'textarea',
    			fieldLabel: getAdmissionTranslation('CONDITIONS_APPLICABLE'),
    			width: 465,
    			name: 'conditionApplicable',
    			itemId: 'conditionApplicableId',
    			style:{'margin-left':'10px'},
    			allowBlank: true
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			labelAlign: 'top',
    			width: 226
    		},items: [{
    			xtype: 'applicationconditionsdocumentlist',
    			itemId: 'applicationconditionsdocumentlistId',
    			width: 465
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			labelAlign: 'top',
    			width: 226
    		},items: [{
    			xtype: 'button',
    			text: getCommonTranslation('SAVE'), 
    			itemId: 'btnSave',
    			ui: 'CustomBtnSubmit',
    			style:{'margin-left':'10px'},
    			scale: CONSTANTS.BUTTONSIZE,
    			formBind : true
    		}]
    	}]
    }]
});