/**
 * @author Amit G
 * This is used to show CONDITIONS_FOR_ADMISSIONS Application and Admission
 */
Ext.define('Academia.view.admission.applications.applicationBase.ApplicationProgramWiseConditionsForAdmission', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.applicationprogramwiseconditionsforadmission',
    autoScroll: true,
    items: [{
    	xtype: 'panel',
    	width:'100%',
    	cls: 'panelNoSpace',
    	items: [{
    		xtype : 'applicationprogramwiseconditionsadmissionadmgrid',
    		itemId: 'applicationProgramWiseConditionsAdmissionAdmGridItemId',
    	},{
    		xtype: 'panel',
        	width:'100%',
        	layout: 'hbox',
        	cls: 'panelNoSpace',
        	items: [{
        		xtype: 'applicantpwconditionsadminadmdocumentgrid',
        		itemId: 'applicantPWConditionsAdminAdmDocumentGridItemId',
        		width:'45%'
        	},{
        		xtype: 'applicantlistofapplicableconditionsadmgrid',
        		itemId: 'applicantListofApplicableConditionsAdmgridItemId',
        		width:'55%'
        	}]	
    	}]

    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	itemId:'formFieldContainerItemId',
    	defaults: {
    		labelAlign: 'top',
    		
    	},
    	items: [{
    		xtype: 'textarea',
    		name: 'txtAdmAdditionalCondition',
    		style:{'margin-left':'10px'},
    		width:460,
    		itemId: 'txtAdmAdditionalConditionItemId',
    		fieldLabel: getAdmissionTranslation('ADDITIONAL_CONDITIONS'),
    		readOnly:true,
    		maxLength:1000	
    	},{
    		xtype: 'datefield',
    		fieldLabel: getAdmissionTranslation('DATE_FOR_SATISFACTION_OF_CONDITION'),
    		name: 'admDateOfSatisfactionCondition',
    		itemId: 'admDateOfSatisfactionConditionItemId',
    		width:226,
    		readOnly:true,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		}
    	}]
	},{
		xtype: 'button',
		text: getTransportTranslation('SAVE'),
		style:{'margin-left':'10px'},
		formBind: true,
		itemId: 'admPWCSubmitBtn',
		ui: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE
		}]
});