/**
 *  Vyabha Thakur
 */
Ext.define('Academia.view.admission.applications.applicationBase.PendingOfferFlagWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.pendingofferflagwindow',
	modal: true,
    autoScroll:true,
    title: getCommonTranslation('PENDING_OFFER_FLAG'),
    maxHeight:600,
    items: [{
        xtype: 'form',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: 'anchor',
        standardSubmit: false,
        plugins:"formlabelrequired",
        defaults: {
        	  labelAlign: 'top',
        	  width: 226,
        },
        items: [{  
        	    xtype: 'hidden',
                name: 'id'
            },{
				xtype: 'customcombobox',
				name: 'pendingOfferflag',
				itemId: 'pendingOfferflag',
				fieldLabel: getCommonTranslation('FLAG_ID_NAME'),
				store:'common.PendingOfferLetterCSMStore',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				allowBlank:false,
				matchFieldWidth:true
			},{
            layout: {
                type: 'hbox'
            },
            style:{
            	marginLeft:'0px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'saveBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'cancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
        }]
    }]
});