/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.deletedApplicantsReport.DeletedApplicantsReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.deletedapplicantsreportgrid',
	store: 'admission.applications.applicantProfileBase.DeleteApplicationsGridStore',
	title: getAdmissionTranslation('DELETED_APPLICANTS_LIST'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'admission.applications.applicantProfileBase.DeleteApplicationsGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getAdmissionTranslation('ARCHIVED_APPLICATION_ID'),
		dataIndex: 'archivedApplicationId',
		flex:.1
		
	},{
		header:  getAdmissionTranslation('APPLICATION_NAME'),
		dataIndex: 'applicantName',
		flex:.1
	},{
		header : getAdmissionTranslation('EMAIL_ID'),
		dataIndex: 'emailId',
		flex:.1
	},{
		header:  getAdmissionTranslation('CONTACT_NO'),
		dataIndex: 'contactNo',
		flex:.1
	},{
		header:  getAdmissionTranslation('DELETION_DATE'),
		dataIndex: 'lastUpdate',
		flex:.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getAdmissionTranslation('DELETED_BY'),
		dataIndex: 'deletedByFullName',
		flex:.1
	}]
});
