/**
 * @author Pravin.Surve
 */
Ext.define('Academia.view.admission.replacement.SelectReplacementGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.selectreplacementgrid',
    title: getAdmissionTranslation('SELECT_REPLACEMENT'),
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [{
        xtype: 'customcombobox',
        width: 310,
        itemId: 'selectReplacementStageCombo',
        name: 'programSelectionProcessStageId',
        fieldLabel: getAdmissionTranslation('SELECT_CANDIDATES_FORM'),
        labelWidth:130,
        displayField: 'value',
        valueField: 'id',
        queryMode: 'local',
        autoload: false,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.admission.selectionStage.SelectionStageFromSeatType');
                combo.bindStore(store);
            }
        }
    },{

        xtype: 'customcombobox',
        width: 240,
        itemId: 'waitListId',
        name: 'waitListId',
        fieldLabel: getAdmissionTranslation('WAIT_LIST'),
        labelWidth:60,
        displayField: 'value',
        valueField: 'name',
        //queryMode: 'local',
        //autoload: false,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.admission.replacement.ReplacementWaitingListStore');
                combo.bindStore(store);
            }
        }
    
    }],
    columns: [{
        header: getAdmissionTranslation('REPLACE_BY_APPLICATION_ID'),
        dataIndex: 'replacedByAppId',
        sortable: true,
        flex: 0.5,
        renderer: function(value) {
            return '<a href="#">' + value + '</a>';
        }
    }, {
        header: getAdmissionTranslation('STUDENT_NAME'),
        dataIndex: 'replacedByAppName',
        sortable: true,
        flex: 1
    }, {
        header: getAdmissionTranslation('RANK'),
        dataIndex: 'rank',
        sortable: true,
        flex: 0.5
    }, {
        header: getAdmissionTranslation('QUOTA_RANK'),
        dataIndex: 'quotaRank',
        sortable: true,
        flex: 0.5
    }, {
        header: getAdmissionTranslation('FINAL_EVALUATION_STATUS'),
        dataIndex: 'replacedByStageStatus',
        sortable: true,
        flex: 1
    }],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.replacement.CandidateByReplacedStore');
    }

});