/**
 * This form is used for Add/Edit/View of the selection process record from the selection
 * process grid, from selection process of admissions module.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.SelectionProcessForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.selectionprocessform',
    title: getAdmissionTranslation('SELECTION_PROCESS_DETAILS'),
    standardSubmit: false,
    autoScroll: true,
    frame: true,
    plugins: "formlabelrequired",
    
    defaults: {
        labelAlign: 'top'
    },
    items: [{
    	xtype:'form',
    	itemId:'selectionProcessFormId',
    	items:[{
    	    	xtype : 'hidden',
    	    	name: 'id'
    	    },{
    	    	xtype : 'hidden',
    	    	name: 'numberOfStages'
    	    },{
    	    	xtype : 'hidden',
    	    	name: 'version'
    		}, {
    			xtype : 'fieldcontainer',
    			layout: {
    				type:'table',
    				columns :3
    			},
    			defaults: {
    		        labelAlign: 'top',
    		    	tdAttrs: { style: 'padding: 5px;' },
    		        width: 229
    		    },
    		    style : {
    		    	marginLeft : '5px'
    		    },
    			items : [ {
    				xtype : 'textfield',
    				name : 'name',
    				vtype:'NoSpaceAndSpecialCharactersAsInput',
    				fieldLabel : getAdmissionTranslation('SELECTION_PROCESS_NAME'),
    				allowBlank : false
    	        },{
    	            xtype: 'statusCombo',
    	            allowBlank: false,
    	            editable: false,
    	            width: 226,
    	            name: 'status',
    	            value:true 
    			},{
    	            xtype: 'customcombobox',
    	            allowBlank: false,
    	            editable: false,
    	            width: 226,
    	            name: 'selectionProcessType',
    	            itemId:'selectionProcessType',
    	            store: 'admission.admissionCycle.SelectionProcessTypeStore',
    	            fieldLabel : getAdmissionTranslation('SELECTION_PROCESS_TYPE'),
    	            valueField: 'id',
    				displayField: 'value',
    				typeAhead:true,
    				forceSelection:true
    			}, {
    				xtype : 'textarea',
    				name : 'remark',
    				itemId:'remark',
    				fieldLabel : getAdmissionTranslation('SELECTION_PROCESS_REMARKS')
    			}, {
    				xtype : 'textarea',
    				name : 'quotaTypeRemark',
    				itemId : 'quotaTypeRemark',
    				fieldLabel : getAdmissionTranslation('QUOTA_TYPE_REMARKS')
    			} ]
    		},{
    			xtype : 'fieldcontainer',
//    			border: 1,
//    			style: {
//    			    borderColor: '#d9d9d9',
//    			    borderStyle: 'solid'
//    			},
    			//TODO: remove hardcoding
    			width: 707,
    			defaults: {
    		        labelAlign: 'top',
    		        width: '655px'
    		    },
    		    
    			items: [ {
    				xtype: 'itemselector',
    				itemId: 'quotaTypeSelector',
    				fieldLabel: getAdmissionTranslation('APPLICABLE_QUOTA_TYPE'),
    				name: 'quotaTypeIds',
    				labelCls:'itemSelectorLabelCls',
    				store : 'admission.selectionProcess.QuotaTypes',
    		        displayField: 'code',
    		        valueField: 'id',           
//    		        allowBlank: false,
    		        msgTarget: 'side',
    		        maxHeight :300,
    		        fromTitle: getAdmissionTranslation('QUOTA_TYPES'),
    		        toTitle: getAdmissionTranslation('APPLICABLE_QUOTA_TYPES'),
    		        getSubmitData: function() {
    		        	  var me = this,
    		              data = null,
    		              val;
    		          if (!me.disabled && me.submitValue && !me.isFileUpload()) {
    		              val = me.getSubmitValue();
    		              val = '['+val+']';
    		              val = Ext.decode(val);
    		              if (val !== null) {
    		                  data = {};
    		                  data[me.getName()] = val;
    		              }
    		          }
    		          return data;
    		        }
    			}]
    		}, {
    	        xtype: 'fieldcontainer',
    	        width: '100%',
    	        style :{
    	        	marginLeft : '7px'
    	        },
    	        items: [{
    	            xtype: 'button',
    	            itemId: 'btnSaveSelectionProcess',
    	            text: getCommonTranslation('SAVE'), 
    	            ui: 'CustomBtnSubmit',
    	            scale: CONSTANTS.BUTTONSIZE,
    	            formBind: true
    	        },{
    	            xtype: 'button',
    	            text: getExaminationTranslation('RESET'),
    	            itemId: 'gradeMasterResetButtonId',
    	            ui: 'CustomBtnCancel',
    	            scale: CONSTANTS.BUTTONSIZE,
    	            handler: function() {
    	                this.up('form').getForm().reset();
    	            }
    	        }]
    	    
    	}]
    }]

});