/**
 * @author Niklesh Tiwane
 */
Ext.define('Academia.view.alumniSystem.alumniCommon.widget.applyToAlgrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.applyToAlgrid',
	border : true,
	store: 'alumni.alumniPortalSetUp.AlumniPortalApplyToAlGridStore',
	//selType:'checkboxmodel',
	selModel: {
		//mode:'MULTI',
		//showHeaderCheckbox: true,
		allowDeselect: true,
		//checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
    border: true,
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	emptyMsg: getAlumni('NORESULTSNMESSAGE'),
			store : 'alumni.alumniPortalSetUp.AlumniPortalApplyToAlGridStore'
        }]
    }],
    tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getAlumni('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		disabled:true,
		tooltip : getAlumni('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [ {
        header: getAlumni('ACADEMY_LOCATIONS'),
        dataIndex: 'academyName',
        flex: 1
	},{
        header: getAlumni('CAMPUS'),
        dataIndex: 'locationName',
        flex: 1
	}],
});