/**
 *  @author Harshit Satya
 */
Ext.define('Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsRaisingViewRaiseFund', {
    extend: 'Ext.form.Panel',
    alias: 'widget.alumnifundsraisingviewraisefund',
    autoScroll: false,
    frame: false,
    plugins: "formlabelrequired",
    style: {
        marginLeft: CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    defaults: {
        labelAlign: 'top',
    },
    items: [{
    	xtype: 'hidden',
    	itemId: 'recordId',
    	name: 'recordId'
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getAlumni('FUND_ID'),
            name: 'fundsCode',
            itemId: 'fundsCodeItemId',
            readOnly: true,
            emptyText: 'ID will be Auto Generated'
        }, {
            xtype: 'textfield',
            fieldLabel: getAlumni('TITLE'),
            name: 'title', 
            maxLength: 100,
            itemId: 'titleItemId',
            readOnly: true,
            allowBlank: false
        }, {
            xtype: 'customcombobox',
            fieldLabel: getAlumni('CURRENCY'),
            name: 'currency',
            itemId: 'currencyItemId',
            store: 'alumni.alumniFundsRaising.AlumniFundsCurrencyStore',
            displayField: 'name',
            valueField: 'id',
            forceSelection: true,
//            queryMode: 'local',
            editable: false,
            allowBlank: false,
            readOnly: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND')	
            },
            listeners: {
                afterrender: function (combo) {
                    combo.getStore().load();  // Trigger store load on combobox render
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'numberfield',
            fieldLabel: getAlumni('DONATION_GOAL'),
            name: 'donationGoal',
            itemId: 'donationGoalItemId',
            allowBlank: false,
            minValue: 1,
            readOnly: true,
            allowExponential: false,
        },{
            xtype: 'datefield',
            fieldLabel: getAlumni('START_DATE'),
            name: 'startDate',
            itemId: 'startDateItemId',
            format: 'd/m/Y',
            readOnly: true,
            minValue: new Date(),  // Prevents selecting dates before today
            listeners: {
                change: function(field, newValue) {
                    var endDateField = field.up('form').down('#endDateItemId');
                    if (newValue && endDateField) {
                        endDateField.setMinValue(newValue);  // Set the end date's minimum value based on start date
                    }
                }
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getAlumni('END_DATE'),
            name: 'endDate',
            itemId: 'endDateItemId',
            format: 'd/m/Y',
            readOnly: true,
            minValue: new Date()  // Prevents selecting dates before today
        }
]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'multiselectcombofield',
            width: 465,
            name: 'academyLocations',
            itemId: 'multiselectTargetByStaffAcademyId',
            allowBlank: false,
            fieldLabel: getAlumni('ACADEMY_LOCATION'),
            store: Ext.create('Academia.store.organization.academylocations.AcademyLocationStore'),
            displayField: 'value',
            valueField: 'id',
            matchFieldWidth: true,
            maxLength: 15000,
            autoloadStore: false,
            readOnly: true,
            editable: false,
            //queryMode: 'local',
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">{value}</div>';
                }
            },
            listeners: {
                afterrender: function(field) {
                    field.getEl().on('keydown', function(e) {
                        e.stopEvent(); 
                    });
                    
                    field.getEl().on('click', function(e) {
                        e.stopEvent();
                    });

                    field.getEl().on('focus', function(e) {
                        e.stopEvent();
                    });
                }
            }
        }]
    }, {
        xtype: 'panel',
        itemId: 'dynamicMainPanel',
        layout: 'vbox',
        style: {
            marginTop: '20px',
            marginBottom: '20px',
            marginLeft: '0',
        },
        items: [{
            xtype: 'container',
            html: '<h4>' + getAlumni('DONATION_RANGE') + '</h4>',
            style: {
                marginBottom: '10px'
            }
        },{
            xtype: 'fieldcontainer',
            title: getAlumni('DONATION_RANGE'),
            layout: {
                type: 'hbox',
            },
            defaults: {
                 labelAlign: 'top',
                 allowBlank: false,
                 allowExponential: false
            },
            items: [{
                xtype: 'numberfield',
                fieldLabel: getAlumni('MINIMUM_AMOUNT'),
                name: 'minAmt',
                itemId: 'minAmt',
                minValue: 1,
                readOnly: true,
                width: 226,
                allowExponential: false,
                listeners: {
                    change: function(field, newValue) {
                        var maxAmtField = field.up().down('numberfield[name=maxAmt]');
                        if (maxAmtField) {
                            maxAmtField.setMinValue(newValue + 1);
                            var maxAmtValue = maxAmtField.getValue();
                            if (maxAmtValue <= newValue) {
                                maxAmtField.setValue(newValue + 1);  
                            }
                        }
                    }
                }
            }, {
                xtype: 'numberfield',
                fieldLabel: getAlumni('MAXIMUM_AMOUNT'),
                name: 'maxAmt',
                itemId:'maxAmt',
                width: 226,
                readOnly: true,
                minValue: 1,
                allowExponential: false
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'combobox',
            fieldLabel: getAlumni('STATUS'),
            name: 'status',
            itemId: 'statusItemId',
            store: Ext.create('Ext.data.Store', {
                fields: ['id', 'value'],
                data: [
                    { id: 'active', value: 'Active' },
                    { id: 'inactive', value: 'Inactive' }
                ]
            }),
            style: {
            	marginTop: '-5px'
            },
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            readOnly: true,
            value: 'active',
            allowBlank: false
        }]
    }, {
        xtype: 'textareafield',
        fieldLabel: getAlumni('DESCRIPTION'),
        name: 'description',
        itemId: 'descriptionItemId',
        maxLength: 512,
        readOnly: true,
        width: 560,
        height: 150,
    }]
});
