/**
 *  @author Harshit Satya
 * 
 */
Ext.define('Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsTransactionFilter',{
	extend: 'Ext.form.Panel',
	alias : 'widget.alumnifundstransactionfilter',
	autoScroll: false,
	bodyPadding:'10 10 10 11',
	frame:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	defaults: {
		labelAlign: 'top',
	},
	items:[{
        xtype: 'fieldcontainer',
        width : '100%',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},		
        items: [{
        	xtype: 'hidden',
        	itemId: 'recordId',
        	name: 'recordId'
        },{
			xtype: 'customcombobox',
			fieldLabel:getAlumni('DONOR_NAME'),
			name: 'donorName',
            itemId: 'donorNameItemId',
            minChars:3,
			forceSelection:true,
			store: 'alumni.alumniFundsRaising.AlumniFundsDonorNameStore',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				}
	        },{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('ALUMNI_ID'),
				name: 'alumniId',
	            itemId: 'alumniIdItemId',
	            minChars:3,
				forceSelection:true,
				store: 'alumni.alumniFundsRaising.AlumniFundsPaymentCodeStore',
	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'code',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			},{
	            xtype: 'multiselectcombofield',
	            width: 500,
	            name: 'academyLocations',
	            itemId: 'multiselectTargetByStaffAcademyId',
//	            allowBlank: false,
	            fieldLabel: getAlumni('ACADEMY_LOCATION'),
	            store: Ext.create('Academia.store.organization.academylocations.AcademyLocationStore'),
	            displayField: 'code',
	            valueField: 'id',
	            matchFieldWidth: true,
	            maxLength: 15000,
	            autoloadStore: false,
	            editable: false,
	            //queryMode: 'local',
	            listConfig: {
	                listeners: {
	                    beforeshow: function (picker) {
	                        picker.width = picker.up('combobox').getSize().width;
	                    }
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function () {
	                    return '<div class="search-item">{value}</div>';
	                }
	            },
	            listeners: {
	                afterrender: function(field) {
	                    field.getEl().on('keydown', function(e) {
	                        e.stopEvent(); 
	                    });
	                }
	            }
	        }],			
    	},{
    		xtype: 'fieldcontainer',    
    		layout: {
    			type : 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},	
    		items: [{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('TRANSACTION_ID'),
				name: 'transactionId',
	            itemId: 'transactionIdIdItemId',
	            minChars:3,
				forceSelection:true,
				store: 'alumni.alumniFundsRaising.AlumniFundsPaymentTransactionIdStore',
	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'transactionId',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			}, {
				xtype: 'customcombobox',
				fieldLabel: getAlumni('TRANSACTION_STATUS'),
	            name: 'paymentStatus',
	            itemId: 'paymentStatusItemId',
	            store: Ext.create('Ext.data.Store', {
	                fields: ['id', 'value'],
	                data: [
	                    { id: 'Transaction Success', value: 'TXN_SUCCESS' },
	                    { id: 'Pending', value: 'PENDING' },
	                    { id: 'Success', value: 'SUCCESS' },
	                    { id: 'Failed', value: 'FAILED' },
	                    { id: 'Cancelled', value: 'CANCELLED' },
	                ]
	            }),
				displayField: 'id',
		        valueField: 'value',
				forceSelection: true,
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}	
			}]

    		
    	},{
    		xtype: 'fieldcontainer',    
    		layout : {
    			type : 'hbox'
    		},
    		width:'auto',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation("SEARCH") ,
    			name : 'submitBtn',
    			itemId : 'submitBtn',
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
    		},{
    			xtype: 'button',
    			itemId: 'btnResetItemId',
    			name: 'btnReset',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    		}]
    	
    	}]
});

