/**
 *  @author Harshit Satya
 */

Ext.define('Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsTransactionListingGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.alumnifundstransactionlistinggrid',
    store: 'alumni.alumniFundsRaising.AlumniFundsDonorTransactionFilterStore',
    title: getAlumni('DONORS_LIST'),
    autoScroll:true,
    border: true,
    refreshStoreData: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
    },
    cls:'mb-40',
    headerFix: {
    	headerFix: true,
    	portalIdsWithStructure: {
			'alumnifundsviewtransactionstructure':1
		}
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'alumni.alumniFundsRaising.AlumniFundsDonorTransactionFilterStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true,
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getAlumni('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hidden: true
	},'->'],
    columns: [ {
        header: getAlumni('TITLE'),
        dataIndex: 'fundsTitle',
        flex: 1
    }, {
        header: getCommonTranslation('DONATION_GOAL'),
        dataIndex: 'donationGoal',
        flex: 1
    },{
        header: getCommonTranslation('DONOR_NAME'),
        dataIndex: 'printName',
        flex: 1
    },{
        header: getCommonTranslation('ALUMNI_ID'),
        dataIndex: 'alumniUserCode',
        flex: 1
    },{
        header: getAlumni('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex: 1
    },{
    	header: getAlumni('RECEIVED_AMOUNT'),
        dataIndex: 'amount',
        flex: 1
    },{
        header: getAlumni('RECEIVED_DATE'),
        dataIndex: 'paymentDate',
        flex: 1,
        xtype: 'datecolumn',
		renderer:function(val){		
			return dateRender(val);
		}
    },{
    	header: getAlumni('TRANSACTION_ID'),
        dataIndex: 'transactionId',
        flex: 1
    }, {
        header: getCommonTranslation('TRANSACTION_STATUS'),
        dataIndex: 'paymentStatus',
        flex: 1,
        renderer:function(value, meta, record){
            if(value=="TXN_SUCCESS"){
                return "Transaction Success";
          }else if(value=="PENDING"){
                 return "Pending";
          }
          else if(value=="SUCCESS"){
                 return "Success";
          }else if(value=="FAILED") {
              return "Failed"
          }else if(value=="CANCELLED"){
              return "Cancelled"
          }
       }
    },{
		header : getAlumni('RECEIPT'),
		dataIndex : 'receiptPath',
		flex:1,
		renderer : function(value){
			if( !isNullOrEmpty(value) && value != 0 ){
				return  '<a href="#">Click here</a>';
			} else {
				return '-';
			}
		}
	}
    ]
});
