/**
 *  @author Niklesh Tiwane
 */

Ext.define('Academia.view.alumniSystem.alumniPortalSetUp.AlumniPortalSetUpGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.alumniPortalSetUpGrid',
    store: 'alumni.alumniPortalSetUp.AlumniPortalSetUpGridStore',
    title: getAlumni('LIST_OF_ALUMNI_SET_UP'),
    selType:'checkboxmodel',
    autoScroll:true,
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		//checkOnly : true,
	},
    border: true,
    refreshStoreData: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    cls:'mb-40',
    headerFix: {
        headerFix: true,
        portalIdsWithStructure: {
            'alumniPortalSetUpStructure':1
        }
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'alumni.alumniPortalSetUp.AlumniPortalSetUpGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true,
            isGridConfigurable: true,
    	    enableColumnHide: false,
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getAlumni('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		disabled:true,
		tooltip: getAlumni("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		disabled:true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getAlumni('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{

		xtype : 'splitbutton',
        itemId:'spBtnMoreActions',
        text : getAlumni('MOREACTIONS'),
        menu:[{
            text:getAlumni('RENAME'),
            itemId:'btnRename'
        },{
            text:getAlumni('COPY'),
            itemId:'btnCopy'
        }],
        listeners: { 
        	click: function() { 
        		this.showMenu(); 
        	} 
	}
      
	},'->'],
    columns: [ {
        header: getCommonTranslation('ALUMNI_SETUP_NAME'),
        dataIndex: 'setupName',
        flex: 1
    },{
        header: getAlumni('CREATED_BY'),
        dataIndex: 'printName',
        flex: 1,
    }, {
        header: getAlumni('CREATION_DATE'),
        dataIndex: 'createdDate',
        flex: 1,
        renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getAlumni('MAPPING_STATUS'),
        dataIndex: 'mappingStatus',
        flex: 1,
		sortable:true,
		renderer:function(value) {
			return value == true ? 'Mapped' : 'Unmapped';
		}
    },{
        header: getAlumni('STATUS'),
        dataIndex: 'status',
        flex: 1,
		sortable:true,
		renderer:function(value) {
			return value == true ? 'Active' : 'Inactive';
		}
    },{
        header: getAlumni('ACADEMY_LOCATION'),
        dataIndex: 'countOfAL',
        flex: 1,
        renderer : function(value){
			if( !isNullOrEmpty(value) && value != 0 ){
				return  '<a href="#">'+value+'</a>';
			} else {
				return  '<a href="#">'+0+'</a>';
			}
		}
    }]
});
