/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.attendance.FacultyAttendance',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.facultyattendance',
	plugins : "formlabelrequired",
	frame: false,
	autoScroll:false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	layout : {
		type : 'vbox'
	},
	/*defaults : {
		labelAlign : 'top',
		width : 226,
		margin: 0
	},*/
	items : [
{
	xtype:'hidden',
	name:'attendanceType'
},{
	xtype:'hidden',
	name:'noOfBackDays'
},{
	xtype:'hidden',
	name:'timeTablePlanning'
},
	/*{
		xtype:'form',
		frame:true,
		width:'100%',
		items: [*/{
			xtype : 'fieldcontainer',
			itemId:'programBatch_Id',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'hidden',
				name : 'id'
			},{
				xtype : 'hidden',
				name : 'sessionPlanningDone'
			},{
				xtype : 'hidden',
				name : 'courseVariantId',
				itemId:'courseVariantId_Id'
			},{
				xtype : 'hidden',
				name : 'variantId',
				itemId:'variantId_Id'
			}
			]},{
				xtype : 'fieldcontainer',
				width: 'auto',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				layout : {
					type : 'hbox'
				},
				items : [{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('COURSE'),
					width:460,
					name : 'courseId',
					itemId : 'courseId',
					store : 'attendance.AssignedCoursesFacultyStore',
					displayField : 'courseCodeName',
					valueField : 'courseId',
					typeAhead : true,
					disable:true,
					forceSelection : true,
					allowBlank:false,
					hidden:true,
					 queryParam:'name',
						minChars:3,
						typeAhead:false,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						  listConfig: {
							  listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
				                loadingText: getCommonTranslation('SEARCHING'),
				                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				                getInnerTpl: function() {
				                    return '<div class="search-item">' +
				                    '{courseCodeName}'  +
				                    '</div>';
				                }
				            }
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('COMPONENT'),
					name : 'componentId',
					itemId : 'componentId',
					store:'course.coursecomponent.CourseComponentCouseWise',
					displayField:'componentTypeName',
					valueField : 'id',
					typeAhead : true,
					disable:true,
					forceSelection : true,
					hidden:true
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
					name : 'courseVariant',
					itemId : 'courseVariantId',
					store:'course.coursevariants.CourseVariantStore',
					displayField : 'courseVariantCode',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					allowBlank:false,
					hidden:true
				}/*{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					name : 'courseSectionId',
					itemId : 'CourseSection_ID',
					store:'attendance.SectionByCourseNComponent',
					displayField : 'sectionCode',
					valueField : 'sectionId',
					typeAhead : true,
					forceSelection : true,
					allowBlank:false,
					hidden:true
				}*/]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				itemId:'programBatchContainer',
				hidden:true,
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items :[{
					xtype: 'customcombobox',
					fieldLabel: getCourseTxCommonTranslation('PROGRAM'),
					width:460,
					name:'courseProgramId',
					itemId: 'courseProgramID',
					store:'attendance.AllProgramMappedByCourse',
					displayField:'programName',
					valueField: 'programId',
					typeAhead:true,
					allowBlank:false,
					forceSelection:true
				},
				{
					xtype: 'customcombobox',
					fieldLabel: getCourseTxCommonTranslation('BATCH'),
					name:'programBatchCourse',
					itemId: 'programBatchCourseID',
					store:'common.BatchesByProgramId',
					displayField: 'value',
					valueField: 'id',
					typeAhead:true,
					disabled:true,
					allowBlank:false,
					forceSelection:true
				}/*{
					xtype: 'customcombobox',
					fieldLabel: getCourseTxCommonTranslation('PERIOD'),
					name:'programBatchPeriod',
					itemId: 'programBatchPeriodID',
					store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
					displayField: 'value',
					valueField: 'id',
					allowBlank:false,
					typeAhead:true,
					disabled:true,
					forceSelection:true
				}*/]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				//itemId:'programBatchContainer',
				//hidden:true,
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items :[{
				xtype: 'customcombobox',
				fieldLabel: getCourseTxCommonTranslation('PERIOD'),
				name:'programBatchPeriod',
				itemId: 'programBatchPeriodID',
				store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField: 'value',
				valueField: 'id',
				allowBlank:false,
				typeAhead:true,
				disabled:true,
				forceSelection:true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				width: 226,
				labelAlign: 'top',
				name : 'sectionId',
				itemId : 'programCoursection_ID',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				disabled:true,
				hidden:true,
				forceSelection : true,
				allowBlank: false
			}]},
			{
				xtype : 'fieldcontainer',
				width: 'auto',
				layout:'vbox',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('DATE'),
					name : 'dateOfAttendance',
					itemId:'dateOfAttendance_Id',
//					value : new Date(),
//					maxValue : new Date(),
//					format : CONSTANTS.DATE_FORMAT,
					//--submitFormat : CONSTANTS.DATE_FORMAT,
					vtype : 'daterange',
					allowBlank: false,
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);						
							obj.setMaxValue(new Date());						
							obj.setValue(new Date());
						}
					}
				},{
					xtype: 'customcombobox',
					name: 'timeSlotList',
					itemId:'timeSlotListId',
					width: 226,
					labelAlign: 'top',
					fieldLabel: getCourseTxCommonTranslation('TIME_SLOT'),
					store:'attendance.FacultyTimeSlot',
					displayField:'value',
					valueField:'value',
					typeAhead:true,
					allowBlank:true,
					forceSelection:true,
					disabled:true
//					hidden:true
				}]
			},{
				xtype:'panel',
				itemId:'panelId',
				layout : 'vbox',
				style:{
					marginLeft:'-10px',
					marginTop:'0px'
				},
				items:[{
					xtype : 'fieldcontainer',
					width: 'auto',
					itemId:'timeContainer',
//					hidden:true,
					layout : 'hbox',
					defaults : {
						width : 226,
						labelAlign : 'top'
					},
					items : [{
						xtype : 'timefield',
						name : 'fromTime',		
						itemId : 'fromTime',			
						fieldLabel:getProgramandcourseTranslation('START_TIME'),
						format:'g:i A',
						vtype: 'timerange',
						width:100,
//						endTimeField : 'toTime',
						width:100,
//						disabled:true,
						allowBlank: false,
						listeners:{
							change:function(obj,val){
								if (!isNullOrEmpty(val)) {
									var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 15);
									obj.nextSibling().setMinValue(sDate);	
								}
							}
						}
					},{
						xtype : 'timefield',
						name : 'toTime',		
						itemId : 'toTime',			
						fieldLabel:getProgramandcourseTranslation('END_TIME'),
						format:'g:i A',
						vtype: 'timerange',
//						startTimeField :'fromTime',
						width:100,
//						disabled:true,
						allowBlank: false,
						listeners:{
							change:function(obj,val){
								if (!isNullOrEmpty(val)) {
									var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -15);
									obj.previousSibling().setMaxValue(eDate);
								}
							}
						}
					}/*,{
						xtype: 'button',
						itemId: 'timeBtn',
						disabled:true,
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					}*/]
				}]
			},{
				xtype: 'fieldcontainer',
				width: 'auto',
				style:{
					marginTop:'-30px'
				},
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'searchBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},{
	                xtype: 'button',
	                text: getCourseTxCommonTranslation('RESET'),
	                itemId: 'resetBtn',
	                buttonAlign: 'left',
	                ui: 'CustomBtnCancel',
	                scale: CONSTANTS.BUTTONSIZE
	            }]
			}]
});