var PendingAttendanceDatesGridStore = Ext.create('Academia.store.attendance.PendingAttendanceDatesGridStore');
Ext.define('Academia.view.attendance.pendingattendance.PendingAttendanceDatesGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.pendingattendancedatesgrid',
	store : PendingAttendanceDatesGridStore,
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	title : getCommonTranslation('ATTENDANCE_PENDING_DATES'),
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : PendingAttendanceDatesGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {

		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     

	},
	columns :[{
		header : getCommonTranslation('DATE'),
		dataIndex : 'date',
		flex:1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {
			var window = view.up();
			if(window.itemId == 'exportAllGrid'){
				var value = dateRender(val);
				return  value;
			} else if(window.getCode()){
				var value = dateRender(val);
				return  '<a href="#">'+value+'</a>';
			}else{
				var value = dateRender(val);
				return  value;
			}
		}
	},{
		header : getCommonTranslation('FROM_TIME'),
		dataIndex : 'fromTime',
		flex:1,
		renderer:function(fromTime) {
			return fromTime;
		}
	},{
		header : getCommonTranslation('TO_TIME'),
		dataIndex : 'toTime',
		flex:1,
		renderer:function(toTime) {
			return toTime;
		}
	},{
		header : getCommonTranslation('FACULTY'),
		dataIndex : 'facultyName',
		flex : 1,
		sortable : true,
	}]
});
