/**
 * @author Niklesh Tiwane
 * 
 * show list of notification/alert in notification window.
 *    
 */
Ext.define('Academia.view.baselayout.header.NotificationAlertForRecentVisitedActivity', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.notificationalertforrecentvisitedactivity',  
    initComponent: function() { 
    	var notifyForRecentVisitedActivity = new Ext.XTemplate(
    			'<div class="notify-recent-visited-activity-container">',  
    		    '<div class="title" id="recentVisitedActivityTitleId">{[getCommonTranslation("RECENT_VISITED_ACTIVITIES")]}</div>',  
    		    '<div class="activities-wrapper">',  
    		        '<tpl for=".">',
    		            '<div class="activity-box" data-index="{[xindex - 1]}">',  
    		                '<div class="activity-column first-column">',  
    		                    '<span class="activity-icon {[values.iconCls]}"></span>',  
    		                '</div>',  
    		                '<div class="activity-column second-column">',
    		                '<div class="activity-title">{[getMegaMenuTranslation(values.displayCode) == values.displayCode ? getAnalyticsTranslation(values.displayCode) : getMegaMenuTranslation(values.displayCode)]}</div>',
    		                    '<div class="activity-description">{[getMegaMenuTranslation(values.menuName) == values.menuName ? getAnalyticsTranslation(values.menuName) : getMegaMenuTranslation(values.menuName)]}</div>',
    		                    '<tpl if="itemPinStatus">',    		                      		                        
    		                        '<img src="resources/images/pined.svg" id="pin-icon" class="pin-toggle-icon pined-icon">',    		                     
    		                '<tpl else>',    		                    
    		                    '<img src="resources/images/unpin.svg" id="unpin-icon" class="pin-toggle-icon unpin-icon">',     		                   
    		                '</tpl>', 
    		                '</div>',     		                 
    		            '</div>',  
    		        '</tpl>',  
    		    '</div>',  
    		'</div>' 
        	);
		var dataView = Ext.create('Ext.view.View', {
		    autoScroll: false,
		    cls: 'customized',
		    itemId: 'NotifyAlertViewToVistedUsersItemId',		   
		    emptyText: '<div class="x-grid-empty">'+getCommonTranslation('NODATADISPLAYMSG')+'<div>',  //'No data available'
		    tpl: notifyForRecentVisitedActivity,
		    itemSelector: 'div.activity-box',
		    listeners: {
		    	itemclick: function(view, record, item, index, e, eOpts) {
		    	    var displayCode = record.get('displayCode');
		    	    var currentItemPinStatus = record.get('itemPinStatus');
		    	    var activityStore = Ext.getStore('userProfileLastActivity.notificationAlertForRecentVisitedUsers.NotificationAlertForRecentVisitedActivityStore');
		    	  
		    	    var pinnedItems = activityStore.queryBy(function(rec) {
		    	        return rec.get('itemPinStatus') === true;
		    	    }).getCount();

		    	
		    	    if (e.target.id === 'unpin-icon' || e.target.id === 'pin-icon') {
		    	        var newItemPinStatus = (e.target.id === 'unpin-icon') ? true : false; 
		    	      
		    	        if (newItemPinStatus && pinnedItems >= 6) {
		    	        	showWarningMessage(getCommonTranslation('LIMIT_EXCEEDED'), getCommonTranslation('NOTIFICATION_PIN_LIMIT_EXCEEDED'));
		    	           
		    	            var iconEl = Ext.get(e.target);
		    	            if (iconEl) {
		    	            	iconEl.dom.src = "resources/images/pined.svg";
                                iconEl.replaceCls('unpin-icon', 'pined-icon');
		    	            }
		    	            return;
		    	        }

		    	        var requestParams = {
		    	            "displayCode": displayCode,
		    	            "itemPinStatus": newItemPinStatus
		    	        };

		    	        Ext.Ajax.request({
		    	            url: SERVERURL.PATH_GET_USER_CLICKED_LINKS_ACTIVITY,
		    	            method: 'POST',
		    	            jsonData: requestParams,
		    	            success: function(response) {
		    	                try {
		    	                        record.set('itemPinStatus', newItemPinStatus);
		    	                        var iconEl = Ext.get(e.target);
		    	                        if (iconEl) {
		    	                            if (newItemPinStatus) {
		    	                                iconEl.dom.src = "resources/images/pined.svg";
		    	                                iconEl.replaceCls('unpin-icon', 'pined-icon');
		    	                            } else {
		    	                                iconEl.dom.src = "resources/images/unpin.svg";
		    	                                iconEl.replaceCls('pined-icon', 'unpin-icon');
		    	                            }
		    	                            activityStore.load();
		    	                        }
		    	                } catch (exx) {
		    	                    
		    	                }
		    	            }
		    	        });
		    	        return;
		    	    } else {
		    	    	if (!isNullOrEmpty(displayCode)) {
		    	    	    var win = Ext.ComponentQuery.query('notificationalerttorecentactivitywindow')[0];
		    	    	    
		    	    	    if (win) {
		    	    	        win.on('close', function () {
		    	    	            var linkName = (getMegaMenuTranslation(displayCode) == displayCode) ? 
		    	    	                            getAnalyticsTranslation(displayCode) : 
		    	    	                            getMegaMenuTranslation(displayCode);
		    	    	                            var matchingSpanElements = Ext.DomQuery.select('span.x-btn-inner.x-btn-inner-left');
		    	    	                            var targetSpanElement = null;

		    	    	            /*var spanElement = Ext.DomQuery.selectNode(
		    	    	                'span.x-btn-inner.x-btn-inner-left:contains(' + linkName + ')'
		    	    	            );

		    	    	            if (spanElement) {
		    	    	                Ext.fly(spanElement).dom.click();
		    	    	            }*/
		    	    	                            var matchingSpanElements = Ext.DomQuery.select('span.x-btn-inner.x-btn-inner-left');
		    	    	                            var targetSpanElement = null;

		    	    	                            for (var i = 0; i < matchingSpanElements.length; i++) {
		    	    	                                var span = Ext.get(matchingSpanElements[i]);
		    	    	                                if (span.getHTML() === linkName) {
		    	    	                                    targetSpanElement = span;
		    	    	                                    break;
		    	    	                                }
		    	    	                            }
		    	    	                            if (targetSpanElement) {
		    	    	                                targetSpanElement.dom.click();
		    	    	                            }
		    	    	        }, this, { single: true });

		    	    	        win.close();
		    	    	    }
		    	    	}

		    	    }
		    	}		    
}	});
		this.items = dataView;
		this.callParent(arguments);
}

});